.************************************************
.*
.*   Copyright 2002-2006 nb software
.*
.*   Help for AMouse
.************************************************

:userdoc.

:h1 res=10 id=aboutMain.AMouse - Configuracin avanzada del ratn
:i1 id=aboutMain.AMouse - Configuracin avanzada del ratn
:p.:artwork name='C:\work\c\amouse\Language\Help\amouse.bmp' runin align=left.
Este programa se puede utilizar para configurar la rueda de un
"ratn con rueda" (p.ej. Intelli-Mouse). Puede&colon.

:ul compact.
:li.controlar la funcin de la rueda
:li.fijar el valor del avance en el desplazamiento con la rueda
:li.definir la funcin de los botones 3...5 del ratn
:eul.

:h1 res=1900 id=wheel1.Rueda 1/2/3
:i1 id=wheel1.Rueda 1/2/3
:p.En esta pgina se configuran las acciones del ratn iniciadas al mover la rueda.
Hay una pgina por cada combinacin soportada de rueda + tecla especial.
:p.Encontrars una explicacin ms detallada de cada control, si pulsas sobre
uno de los elementos de la siguiente lista&colon.

:ul compact.
:li.:link reftype=hd refid=no_func.Sin funcin:elink.
:li.:link reftype=hd refid=msgscroll.Mensajes de desplazamiento:elink.
:li.:link reftype=hd refid=msgline.Mensajes de teclado:elink.
:li.:link reftype=hd refid=msgpage.Desplazar una pgina por unidad de desplazamiento:elink.
:li.:link reftype=hd refid=msgvol.Establecer volumen de audio:elink.
:li.:link reftype=hd refid=keyboard.Actuar sobre ventana activa:elink.
:li.:link reftype=hd refid=pointer.Actuar sobre ventana bajo cursor del ratn:elink.
:li.:link reftype=hd refid=scrollitem.Velocidad de la rueda:elink.
:li.:link reftype=hd refid=cancel.Deshacer:elink.
:li.:link reftype=hd refid=standard.Por omisin:elink.
:eul.
:note.
Esta pgina slo ser visible si se detecta una rueda en el ratn.

:h2 res=1901 id=no_func.Modo de operacin - Sin Funcin
:p.Si se activa este botn el sistema ignorar las pulsaciones
sobre la rueda.

:h2 res=1902 id=msgscroll.Modo de operacin - Mensajes de desplazamiento
:p.Si se activa este botn se enva un mensaje de desplazamiento
(WM_VSCROLL/WM_HSCROLL) a las ventanas de texto. Esto simula el
movimiento de la barra de desplazamiento.

:h2 res=1903 id=msgline.Modo de operacin - Mensajes de teclado
:p.Si se activa este botn se enva un mensaje WM_CHAR a las
ventanas de texto. Simula la pulsacin de los cursores, si la
caracterstica est soportada por la ventana.

:h2 res=1904 id=msgpage.Modo de operacin - Desplazar una pgina por unidad de desplazamiento
:p.Si se activa este botn se enva un mensaje WM_CHAR a las
ventanas de texto. Simula la pulsacin de RePg y AvPg, si la
caracterstica est soportada por la ventana.

:h2 res=1905 id=msgvol.Modo de operacin - Establecer volumen de audio
:p.Si se activa este botn, el movimiento de la rueda establece el volumen del sistema multimedia.

:h2 res=1906 id=keyboard.Actuar sobre ventana activa
:p.Si se activa est opcin, se mover la barra de desplazamiento
vertical de la ventana activa.
:p.Con algunos ratones la ventana que est bajo el cursor del ratn podra
activarse al pulsar la rueda.
:note.
En algunas ventanas, las subventanas pueden contener barras de desplazamiento
(p.ej. en Netscape Communicator). En este caso se mueve la ventana seleccionada
en ltimo lugar.

:h2 res=1907 id=pointer.Actuar sobre ventana bajo cursor del ratn
:p.Si se activa est opcin, se mover la barra de desplazamiento
vertical de la ventana situada bajo el cursor del ratn.
:note.
No importa si esta ventana es la activa en este momento, o, incluso, si
est parcialmente oculta por otras ventanas.

:h2 res=1908 id=scrollitem.Velocidad de la rueda
:p.Con el :hp2.selector:ehp2. se fija el nmero de lneas desplazadas
si la rueda se mueve un punto.

:h2 id=cancel.Deshacer
:p.Todos los parmetros vuelven al valor que tenan antes del ltimo cambio.

:h2 id=standard.Por omisin
:p.Se establecen los valores por omisin.

:h1 res=2100 id=wheel2.Rueda 4
:i1 id=wheel2.Wheel 4
:p.En esta pgina se configuran los valores iniciales del controlador, vlidos
en el inicio del PC.
:p.Las propiedades se establecen seleccionando el correspondiente botn
en esta pgina.
:p.Encontrars una explicacin ms detallada de cada control, si pulsas sobre
alguno de los elementos de la siguiente lista&colon.
:ul compact.
:li.:link reftype=hd refid=scroll_vert.desplazamiento vertical:elink.
:li.:link reftype=hd refid=scroll_horz.desplazamiento horizontal:elink.
:li.:link reftype=hd refid=accel_delay.retardo en aceleracin de la rueda:elink.
:li.:link reftype=hd refid=accel_value.velocidad de aceleracin de la rueda:elink.
:li.:link reftype=hd refid=trackball.Nmero de ruedas:elink.
:li.:link reftype=hd refid=cancel.Deshacer:elink.
:li.:link reftype=hd refid=standard.Por omisin:elink.
:eul.
:note.
Esta pgina slo ser visible si se detecta una rueda en el ratn.

:h2 res=2101 id=scroll_vert.Valores de inicio - desplazamiento vertical
:p.Si se activa esta opcin, mover la rueda de un ratn con slo una
rueda realiza un desplazamiento vertical.

:h2 res=2102 id=scroll_horz.Valores de inicio - desplazamiento horizontal
:p.Si se activa esta opcin, mover la rueda de un ratn con slo una
rueda realiza un desplazamiento horizontal.

:h2 res=2103 id=accel_delay.retardo en aceleracin de la rueda (Tiempo de retardo)
:p.Si la rueda se desplaza ms rpido que el tiempo de retardo, el nmero de lneas desplazadas se
incrementar continuamente. El tiempo de retardo debe estar entre 100 y 2000 ms.

:h2 res=2104 id=accel_value.velocidad de aceleracin de la rueda (Valor de aceleracin)
:p.Este selector fija el nmero utilizado para incrementar las unidades de desplazamiento,
si se mueve la rueda muy rpido.

:h2 res=2105 id=trackball.Nmero de ruedas
:p.Algunos ratones no son capaces de proporcionar al controlador su nmero de ruedas o la existencia de un trackball.
En este caso es posible definir sus propiedades con este botn.

:h1 res=2300 id=wheel3.Rueda 5
:i1 id=wheel3.Rueda 5
:p.La pgina :hp2.Rueda 5:ehp2. define excepciones del comportamiento de la rueda para algunas aplicaciones.
Si mueves la rueda del ratn se buscar, en la lista de esta pgina, una descripcin aceptable para la ventana / control.
Se buscar la :hp2.Descripcin:ehp2. en la lista hasta que se encuentre una que coincida con la aplicacin que este bajo el puntero del ratn.
Si no hay ninguna coincidencia, se toma la lista por omisin de :hp2.AMouse:ehp2. (definida en :font facename=Courier size=14x14.AMouRes.rc:font facename=default.).
El texto descriptivo de la lista se utiliza para identificacin por el usuario, por eso el nombre es arbitrario; incluso puede haber nombres duplicados.
:p.Las propiedades deben establecerse seleccionando el correspondiente botn de esta pgina.
:p.Encontrars una explicacin ms detallada de cada control, si pulsas sobre
alguno de los elementos de la lista siguiente&colon.
:ul compact.
:li.:link reftype=hd refid=wheel_up.&uarrow.:elink.
:li.:link reftype=hd refid=wheel_down.&darrow.:elink.
:li.:link reftype=hd refid=wheel_delete.Suprimir:elink.
:li.:link reftype=hd refid=wheel_insert.Insertar:elink.
:li.:link reftype=hd refid=cancel.Cancelar:elink.
:eul.
:note.
Est pgina slo ser visible si se ha detectado una rueda en el ratn.

:p.:hp7.Descripcin de los campos:ehp7.
:p.El comportamiento se muestra en la caja de abajo. La columna de la izquierda define la ventana / control,
al que afectar el movimiento de la rueda. Los significados son&colon.
:ul compact.
:li.:hp2.Aplicacin:ehp2.
.br
Nombre de la aplicacin (p.ej. :font facename=Courier size=14x14.PROGRAMM.EXE:font facename=default.). 
Si este campo queda vaco el resultado de la comparacin siempre ser VERDADERO. Las clases del WPS siempre necesitan que este campo este vaco.
:li.:hp2.Clase:ehp2.
.br
Clase de ventana de la ventana / control. Aqu se puede poner tanto el nombre de la clase (sensible a maysculas!)
como la id precedida de &osq.&numsign.&csq.. Si este campo queda vaco el resultado de la comparacin siempre ser VERDADERO.
:li.:hp2.Clase Padre:ehp2.
.br
Clase de ventana del padre de la ventana / control. Aqu se puede poner tanto el nombre de la clase (sensible a maysculas!)
como la id precedida de &osq.&numsign.&csq.. Si este campo queda vaco el resultado de la comparacin siempre ser VERDADERO.
:li.:hp2.Opcin:ehp2.
.br
Aqu se encontrar una opcin (la descripcin se ver all), si es necesaria para una &osq.vRelacin&csq. o &osq.hRelacin&csq. especfica.
En todos los dems casos este campo permanece vaco.
:eul.
:p.La columna de la derecha define la accin iniciada por la rueda. Los significados son&colon.
:ul compact.
:li.:hp2.Modo:ehp2.
.br
Define el tipo de mensaje enviado a la ventana / control.
Se utilizar :hp2.Desplazamiento:ehp2., si en la pgina
:link reftype=hd refid=wheel1.Rueda 1:elink. se ha seleccionado el
modo de operacin :link reftype=hd refid=msgscroll.mensajes de desplazamiento:elink..
:hp2.Cursor:ehp2. funciona con
:link reftype=hd refid=msgline.mensajes de teclado:elink.,
:hp2.Pgina:ehp2. en
:link reftype=hd refid=msgpage.Desplazar una pgina por unidad de desplazamiento:elink..
:hp2.Desplazamiento o Cursor:ehp2. reacciona, si el modo de operacin seleccionado es tanto
:link reftype=hd refid=msgscroll.mensajes de desplazamiento:elink. como
:link reftype=hd refid=msgline.mensajes de teclado:elink..
:hp2.Todo:ehp2. reacciona en todas las propiedades.
:li.:hp2.vRelacin resp. hRelacin:ehp2.
.br
Define si el mensaje se enva directamente a la ventana / control, o si la siguente bsqueda ha de hacerse
en la jerarqua de la ventana. Los significados son&colon.
:ul compact.
:li.:hp2.Ninguno:ehp2.&colon. El mensaje se enviar directamente al control encontrado.
:li.:hp2.Padre:ehp2.&colon. Se busca un padre aceptable en la lista de descripciones.
:li.:hp2.Propietario:ehp2.&colon. Se busca un propietario aceptable en la lista de descripciones.
:li.:hp2.Siguiente:ehp2.&colon. La bsqueda se continuar en el z-orden de los controles que estn
bajo el puntero del ratn.
:li.:hp2.Siguiente CB:ehp2.&colon. Slo se utiliza en cajas Combo. Bsicamente realiza lo mismo que :hp2.Siguiente:ehp2.,
pero maneja el rea invisible sobre el campo de entrada si la caja de listas no se est mostrando.
:li.:hp2.Hermano[Opcin]:ehp2.&colon. Se buscar una ventana hermana en la lista de descripciones con un nombre de clase
definido en el campo :hp2.opcin:ehp2..
:eul.
:li.:hp2.vOpcin / hOpcin:ehp2.
.br
Contiene una opcin dependiendo del tipo de mensaje establecido. Consulta all.
:li.:hp2.Arriba / Abajo bzw. Izq. / Dcha.:ehp2.
.br
Define el mensaje enviado a la ventana / control. Estn disponibles los siguientes mensajes&colon.
:ul compact.
:li.:hp2.WM_NULL:ehp2.&colon. No se enviar ningn mensaje. Normalmente, se utiliza
cuando se ha establecido el atributo :hp2.Ninguno:ehp2. en :hp2.vRelacin:ehp2./:hp2.hRelacin:ehp2..
:li.:hp2.WM_CONTROL:ehp2.&colon. Se enva un cdigo de teclado directamente al controlador de teclado.
Son posibles las siguientes opciones&colon.
:ul compact.
:li.:hp2.pgina:ehp2.&colon. Se envan los cdigos de teclado para las teclas Repg-/Avpg.
:li.:hp2.cursor arriba/abajo:ehp2.&colon. Se envan los cdigos de teclado para las teclas de cursor Arriba-/Abajo.
:li.:hp2.cursor izquierda/derecha:ehp2.&colon. Se envan los cdigos de teclado para las teclas de cursor Izquierda-/Derecha.
:li.:hp2.mult cursor arriba/abajo:ehp2.&colon. Se envan los cdigos de teclado para las teclas de cursor Arriba-/Abajo.
El nmero de mensajes enviados se especifica en la propiedad :link reftype=hd refid=scrollitem.Velocidad de la rueda:elink..
:li.:hp2.mult cursor izquierda/derechat:ehp2.&colon. Se envan los cdigos de teclado para las teclas de cursor Izquierda-/Derecha.
El nmero de mensajes enviados se especifica en la propiedad :link reftype=hd refid=scrollitem.Velocidad de la rueda:elink..
:eul.
:li.:hp2.WM_VSCROLL:ehp2.&colon. Se enva un mensaje de desplazamiento vertical  a la barra de desplazamiento vertical.
:li.:hp2.WM_HSCROLL:ehp2.&colon. Se enva un mensaje de desplazamiento horizontal a la barra de desplazamiento horizontal.
:li.:hp2.N x WM_VSCROLL:ehp2.&colon. Como :hp2.WM_VSCROLL:ehp2., pero el nmero de mensajes queda definido por
la propiedad :link reftype=hd refid=scrollitem.Velocidad de la rueda:elink..
:li.:hp2.N x WM_HSCROLL:ehp2.&colon. Como :hp2.WM_HSCROLL:ehp2., pero el nmero de mensajes queda definido por
la propiedad :link reftype=hd refid=scrollitem.Velocidad de la rueda:elink..
:li.:hp2.WM_CHAR:ehp2.&colon. Se enva un mensaje de carcter. Son posibles las mismas opciones que para
:hp2.WM_CONTROL:ehp2..
:eul.
:eul.

:p.:hp7.Ejemplos:ehp7.
:p.Debido a un error en versiones antiguas de Mozilla (versin 1.3 y anteriores) el desplazamiento horizontal con mensajes normales de WM_SCROLL
no funciona. Una manera de solucionar esto podra ser introducir las dos siguientes opciones.
:p.:artwork name='C:\work\c\amouse\Language\Help\Mozilla_Line_034.bmp' align=left.
:p.Esta entrada acta, si en la pgina :link reftype=hd refid=wheel1.Rueda 1:elink. se ha seleccionado el
modo de operacin :hp2.mensajes de desplazamiento:ehp2. o :hp2.mensajes de teclado:ehp2..
En este caso los mensajes de tecla de cursor horizontal y vertical se envan al padre.
(&odq.mult cursor&cdq.). Mozilla es identificado, si tanto :hp2.Clase:ehp2. como
:hp2.Clase padre:ehp2. son del tipo :hp2.MozillaWindowClass:ehp2..
:p.:artwork name='C:\work\c\amouse\Language\Help\Mozilla_Page_034.bmp' align=left.
:p.Para desplazamientos de una pgina (:hp2.Modo = Pgina:ehp2.) se enva un mensaje de carcter Repg/Avpg en caso de desplazamiento vertical.
:p.:artwork name='C:\work\c\amouse\Language\Help\Command_Line_034.bmp' align=left.
:p.Si mueves la rueda sobre una ventana de indicador de mandatos, el comportamiento por omisin es desplazar los contenidos de la ventana (si 
hay barras de desplazamiento presentes).
Las propiedades mostradas arriba hacen que en su lugar que se desplace el historial de comandos.

:h2 res=2313 id=wheel_up.&uarrow. (Mover entrada hacia arriba)
:p.Mueve la entrada seleccionada en la lista de entradas una posicin hacia arriba.

:h2 res=2314 id=wheel_down.&darrow. (Mover entrada hacia abajo)
:p.Mueve la entrada seleccionada en la lista de entradas una posicin hacia abajo.

:h2 res=2316 id=wheel_delete.Suprimir
:p.Suprime la entrada seleccionada en la lista para este botn.

:h2 res=2315 id=wheel_insert.Insertar
:p.Inserta una nueva entrada en la lista para este botn.

:h1 res=2700 id=insertappl.Insertar Aplicacin
:i1 id=insertappl.Insertar Aplicacin
:p.Este dilogo se utiliza para insertar una nueva definicin del comportamiento de la rueda para una aplicacin seleccionada.
El significado de los controles corresponde con la descripcin en 
:link reftype=hd refid=wheel3.Rueda 5:elink.. La :hp2.Descripcin:ehp2. su puede utilizar para insertar
cualquier texto definido por el usuario que identifique las entradas en la lista de
:link reftype=hd refid=wheel3.Rueda 5:elink..

:h1 res=1500 id=keys1.Teclas 1
:i1 id=keys.Teclas 1
:p.En esta pgina se definen las acciones para los botones 3, 4 y 5 del ratn.
:p.Las propiedades se establecen seleccionando la respectiva eleccin en esta pgina.
:p.Encontrars una explicacin ms detallada de cada control, si pulsas sobre
alguno de los elementos de la siguiente lista&colon.
:ul compact.
:li.:link reftype=hd refid=button3.Botn 3:elink.
:li.:link reftype=hd refid=button4.Botn 4:elink.
:li.:link reftype=hd refid=button5.Botn 5:elink.
:li.:link reftype=hd refid=button6.Botn 6:elink.
:li.:link reftype=hd refid=button7.Botn 7:elink.
:li.:link reftype=hd refid=button8.Botn 8:elink.
:li.:link reftype=hd refid=button9.Botn 9:elink.
:li.:link reftype=hd refid=button10.Botn 10:elink.
:li.:link reftype=hd refid=cbutton3.Ctrl+Botn 3:elink.
:li.:link reftype=hd refid=cbutton4.Ctrl+Botn 4:elink.
:li.:link reftype=hd refid=cbutton5.Ctrl+Botn 5:elink.
:li.:link reftype=hd refid=cbutton6.Ctrl+Botn 6:elink.
:li.:link reftype=hd refid=cbutton7.Ctrl+Botn 7:elink.
:li.:link reftype=hd refid=cbutton8.Ctrl+Botn 8:elink.
:li.:link reftype=hd refid=cbutton9.Ctrl+Botn 9:elink.
:li.:link reftype=hd refid=cbutton10.Ctrl+Botn 10:elink.
:li.:link reftype=hd refid=abutton3.Alt+Botn 3:elink.
:li.:link reftype=hd refid=abutton4.Alt+Botn 4:elink.
:li.:link reftype=hd refid=abutton5.Alt+Botn 5:elink.
:li.:link reftype=hd refid=abutton6.Alt+Botn 6:elink.
:li.:link reftype=hd refid=abutton7.Alt+Botn 7:elink.
:li.:link reftype=hd refid=abutton8.Alt+Botn 8:elink.
:li.:link reftype=hd refid=abutton9.Alt+Botn 9:elink.
:li.:link reftype=hd refid=abutton10.Alt+Botn 10:elink.
:li.:link reftype=hd refid=keycombset3.Set 3:elink.
:li.:link reftype=hd refid=keycombset4.Set 4:elink.
:li.:link reftype=hd refid=keycombset5.Set 5:elink.
:li.:link reftype=hd refid=keycombset6.Set 6:elink.
:li.:link reftype=hd refid=keycombset7.Set 7:elink.
:li.:link reftype=hd refid=keycombset8.Set 8:elink.
:li.:link reftype=hd refid=keycombset9.Set 9:elink.
:li.:link reftype=hd refid=keycombset10.Set 10:elink.
:li.:link reftype=hd refid=keycomb.Key combination:elink.
:li.:link reftype=hd refid=cancel.Cancelar:elink.
:li.:link reftype=hd refid=standard.Por omisin:elink.
:eul.
:note.
Esta pgina slo ser visible si se detecta una rueda en el ratn.

:p.:hp2.Funciones de los botones:ehp2.
:p.Estn disponibles las siguiente funciones&colon.

:ul.
:li.:hp5.Cortar:ehp5.
.br
Se realizar la funcin de "Cortar" al portapapeles (Mays-Supr)
:li.:hp5.Copiar:ehp5.
.br
Se realizar la funcin de "Copiar" al portapapeles  (Ctrl-Ins)
:li.:hp5.Pegar:ehp5.
.br
Se realizar la funcin de "Pegar" del portapapeles (Mays-Ins)
:li.:hp5.Botn central:ehp5.
.br
EL botn seleccionado se comportar como el tercer botn de un ratn. El estado
de las teclas de maysculas del teclado se preserva y maneja correctamente.
:li.:hp5.Minimizar/Ocultar todas las ventanas:ehp5.
.br
Se minimizarn u ocultarn todas las ventanas, dependiendo de su comportamiento.
:li.:hp5.Restaurar todas las ventanas:ehp5.
.br
Se restaurarn todas las ventanas a su tamao anterior a la funcin minimizar/ocultar/maximizar.
:li.:hp5.Lista de ventanas:ehp5.
.br
Se muestra la Lista de ventanas
:li.:hp5.Cerrar aplicacin:ehp5. 
.br
Se cerrar la aplicacin.
:li.:hp5.Doble click:ehp5.
.br
Se enva a la aplicacin un mensaje de doble click.
:li.:hp5.Maximizar ventana:ehp5.
.br
Se maximizar la ventana.
:li.:hp5.Minimizar/Ocultar ventana:ehp5.
.br
Se minimizar u ocultar la ventana, dependiendo de su comportamiento.
:li.:hp5.Restaurar ventana:ehp5.
.br
Se restaurar la ventana a su tamao anterior a la funcin minimizar/ocultar/maximizar.
:li.:hp5.Alternar direccin de desplazamiento:ehp5.
.br
La direccin del desplazamiento se alternar entre vertical y horizontal.
:li.:hp5.Colocar ventana al fondo:ehp5.
.br
La ventana sobre la que est el cursor se desplazar detrs de todas las otras
ventanas del escritorio.
:li.:hp5.Key combination:ehp5.
.br
The key code of the key combination shown in the entry field will be sent to the application.
:li.:hp5.Ninguna accin:ehp5.
.br
Pulsar el botn no origina ninguna accin.
:eul.

:h2 res=1501 id=button3.Botn 3
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 3 del ratn.

:h2 res=1502 id=button4.Botn 4
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 4 del ratn.

:h2 res=1503 id=button5.Botn 5
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 5 del ratn.

:h2 res=1504 id=button6.Botn 6
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 6 del ratn.

:h2 res=1505 id=button7.Botn 7
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 7 del ratn.

:h2 res=1506 id=button8.Botn 8
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 8 del ratn.

:h2 res=1507 id=button9.Botn 9
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 9 del ratn.

:h2 res=1508 id=button10.Botn 10
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 10 del ratn.

:h2 res=1511 id=cbutton3.Ctrl+Botn 3
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 3 del ratn junto a la tecla Ctrl.

:h2 res=1512 id=cbutton4.Ctrl+Botn 4
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 4 del ratn junto a la tecla Ctrl.

:h2 res=1513 id=cbutton5.Ctrl+Botn 5
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 5 del ratn junto a la tecla Ctrl.

:h2 res=1514 id=cbutton6.Ctrl+Botn 6
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 6 del ratn junto a la tecla Ctrl.

:h2 res=1515 id=cbutton7.Ctrl+Botn 7
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 7 del ratn junto a la tecla Ctrl.

:h2 res=1516 id=cbutton8.Ctrl+Botn 8
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 8 del ratn junto a la tecla Ctrl.

:h2 res=1517 id=cbutton9.Ctrl+Botn 9
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 9 del ratn junto a la tecla Ctrl.

:h2 res=1518 id=cbutton10.Ctrl+Botn 10
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 10 del ratn junto a la tecla Ctrl.

:h2 res=1521 id=abutton3.Alt+Botn 3
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 3 del ratn junto a la tecla Alt.

:h2 res=1522 id=abutton4.Alt+Botn 4
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 4 del ratn junto a la tecla Alt.

:h2 res=1523 id=abutton5.Alt+Botn 5
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 5 del ratn junto a la tecla Alt.

:h2 res=1524 id=abutton6.Alt+Botn 6
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 6 del ratn junto a la tecla Alt.

:h2 res=1525 id=abutton7.Alt+Botn 7
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 7 del ratn junto a la tecla Alt.

:h2 res=1526 id=abutton8.Alt+Botn 8
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 8 del ratn junto a la tecla Alt.

:h2 res=1527 id=abutton9.Alt+Botn 9
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 9 del ratn junto a la tecla Alt.

:h2 res=1528 id=abutton10.Alt+Botn 10
:p.Esta combinacin de controles se utiliza para seleccionar la accin a realizar
cuando se pulsa el botn 10 del ratn junto a la tecla Alt.

:h2 res=1529 id=keycombset3.Set key combination 3
:p.This button is used to assign the :link reftype=hd refid=keycomb.key combination:elink. in the entry field to 
the mouse button, if the :link reftype=hd refid=button3.combo box:elink. has been set to :hp1.Key combination:ehp1..

:h2 res=1530 id=keycombset4.Set key combination 4
:p.This button is used to assign the :link reftype=hd refid=keycomb.key combination:elink. in the entry field to 
the mouse button, if the :link reftype=hd refid=button4.combo box:elink. has been set to :hp1.Key combination:ehp1..

:h2 res=1531 id=keycombset5.Set key combination 5
:p.This button is used to assign the :link reftype=hd refid=keycomb.key combination:elink. in the entry field to 
the mouse button, if the :link reftype=hd refid=button5.combo box:elink. has been set to :hp1.Key combination:ehp1..

:h2 res=1532 id=keycombset6.Set key combination 6
:p.This button is used to assign the :link reftype=hd refid=keycomb.key combination:elink. in the entry field to 
the mouse button, if the :link reftype=hd refid=button6.combo box:elink. has been set to :hp1.Key combination:ehp1..

:h2 res=1533 id=keycombset7.Set key combination 7
:p.This button is used to assign the :link reftype=hd refid=keycomb.key combination:elink. in the entry field to 
the mouse button, if the :link reftype=hd refid=button7.combo box:elink. has been set to :hp1.Key combination:ehp1..

:h2 res=1534 id=keycombset8.Set key combination 8
:p.This button is used to assign the :link reftype=hd refid=keycomb.key combination:elink. in the entry field to 
the mouse button, if the :link reftype=hd refid=button8.combo box:elink. has been set to :hp1.Key combination:ehp1..

:h2 res=1535 id=keycombset9.Set key combination 9
:p.This button is used to assign the :link reftype=hd refid=keycomb.key combination:elink. in the entry field to 
the mouse button, if the :link reftype=hd refid=button9.combo box:elink. has been set to :hp1.Key combination:ehp1..

:h2 res=1536 id=keycombset10.Set key combination 10
:p.This button is used to assign the :link reftype=hd refid=keycomb.key combination:elink. in the entry field to 
the mouse button, if the :link reftype=hd refid=button10.combo box:elink. has been set to :hp1.Key combination:ehp1..

:h2 res=1537 id=keycomb.Define key combination
:p.This entry field allows to define key combinations, that may be assigned to an arbitrary mouse button.
:p.After a key combination has been defined and assigned to a mouse button, this key combination will be sent to 
the applicaton, if the responding mouse button has been pressed.
:p.To define a key combination, the entry field must be clicked. Afterwards, the key combination has to be pressed (e.g. :hp2.Alt-F4:ehp2.).
The entry field then shows this key combination. By pressing one of the :hp2.Set:ehp2.-buttons, this key combination is
assiged to the corresponding mouse button.

:h1 res=1700 id=keys2.Teclas 2
:i1 id=keys2.Keys 2
:p.En esta pgina se define el comportamiento de varios controles a acciones del ratn.
:p.Las propiedades se deben establecer seleccionando la correspondiente eleccin en esta pgina.
:p.Encontrars una explicacin ms detallada de cada control pulsando
sobre los elementos de la siguiente lista&colon.
:ul compact.
:li.:link reftype=hd refid=dblclick_entry.Doble click sobre campos de entrada:elink.
:li.:link reftype=hd refid=click_combo.Click sobre cajas combo:elink.
:li.:link reftype=hd refid=smartcruise.SmartCruise:elink.
:li.:link reftype=hd refid=cancel.Deshacer:elink.
:li.:link reftype=hd refid=standard.Estndar:elink.
:eul.

:h2 res=1701 id=dblclick_entry.Doble click sobre campos de entrada
:p.Si seleccionas este botn, al realizar una doble pulsacin con el ratn sobre un campo
de entrada, se seleccionar una palabra completa.

:h2 res=1702 id=click_combo.Click sobre cajas combo
:p.Si este botn est seleccionado, cuando pulses con el ratn sobre el campo de entrada de una
caja combo, se abrir la lista desplegable de dicha caja.

:h2 res=1703 id=smartcruise.SmartCruise
:p.Esto habilita la funcin SmartCruise de los ratones Logitech MX500, MX700 and MX1000. Si est casilla
esta activada, se ignoran las propiedades para los botones 7, 8, 9 y 10. Con esta funcin, los botones 7 y 8
desplazan verticalmente, los botones 9 y 10 (si los hay) desplazan horizontalmente.

:h1 res=1100 id=devinfo.Informacin del dispositivo
:i1 id=devinfo.Informacin del dispositivo
:p.Est pgina muestra el tipo y nmero de versin del software del PC relativo
a este producto.
:p.Adems se informa del tipo de ratn detectado por el sistema.
:note.
Para muchos ratones es imposible detectar el nmero de botones correctamente. Adems,
el Presentation Manager slo soporta 3 botones como mximo. Esta es la razn por la
que posiblemente el nmero de botones mostrado pueda ser incorrecto, si el ratn
tiene ms de 3.

:h1 res=1300 id=wldevinfo.Informacin del dispositivo 2
:i1 id=wldevinfo.Informacin del dispositivo 2
:p.Esta pgina muestra informacin especfica para ratones sin cable, si soportan mostrar estos datos.
:p.El :hp5.Nmero de dispositivo:ehp5., slo interesa para ratones USB y muestra el ndice del dispositivo.
:p.El :hp5.Nmero de canal:ehp5. muestra el canal usado con el ratn, que soporte multiples canales.
:p.El :hp5.Estabo de la batera:ehp5. muestra el estado actual de carga de la batera.
:p.Pulse sobre cada uno de los elementos de la lista de abajo, para obtener una 
explicacin ms detallada&colon.
:ul compact.
:li.:link reftype=hd refid=battery_warning.Aviso de batera:elink.
:eul.

:h2 res=1304 id=battery_warning.Aviso de batera
:p.Si activa esta casilla se mostrar una ventana emergente si  la batera de su ratn est casi vaca.

:h1 res=2500 id=timing.Tiempos
:i1 id=timing.Tiempos
:p.En este dilogo se establecen diversos tiempos del ratn: tanto el ratio interno de sondeo
como los valores de aceleracin.
 
:p.:hp5.Descripcin de la aceleracin:ehp5.&colon. Para cada evento del ratn,
la cuenta de unidades fsicas movidas se compara contra los umbrales de primer
y segundo nivel. Si la cuenta es superior al umbral del segundo nivel se utilizar
el multiplicador del segundo nivel; si la cuenta es superior al primer nivel pero
inferior al segundo se utilizar el multiplicador del primer nivel. Si la cuenta es
inferior al umbral del primer nivel no se utilizar multiplicador. Estos clculos se
hacen para los ejes X e Y independientemente.
Los valores se calculan de la siguiente manera&colon.

:table cols='20 20' rules=both frame=box.
:row.
:c.umbral del primer nivel
:c.valor del selector
:row.
:c.umbral del segundo nivel
:c.valor del selector * 7
:row.
:c.multiplicador del primer nivel
:c.valor del selector
:row.
:c.multiplicador del segundo nivel
:c.valor del selector * 2
:etable.

:ul compact.
:li.:link reftype=hd refid=pollrate.Ratio de sondeo del ratn:elink.
:li.:link reftype=hd refid=mouaccel_value.Valor de aceleracin:elink.
:li.:link reftype=hd refid=mouaccel_threshold.Umbral de aceleracin:elink.
:li.:link reftype=hd refid=cancel.Cancelar:elink.
:li.:link reftype=hd refid=standard.Por omisin:elink.
:eul.

:h2 res=2501 id=pollrate.Ratio de sondeo del ratn
:p.El selector define el ratio interno de sondeo del ratn.

:h2 res=2502 id=mouaccel_value.Valor de aceleracin
:p.El selector define el valor de aceleracin.

:h2 res=2503 id=mouaccel_threshold.Umbral de aceleracin
:p.El selector define el umbral de aceleracin.

:euserdoc.
