* Program   : DECUSRPT.PRG
* Version   : V4.2
* Author(s) : Joe Tomas 
* Date      : 08/20/86
* Notice    : 
* Called by : REPORTS.PRG
* Call(s)   :   
* Notes     : DECUS PRODUCT STATUS REPORT
*           : 
CLEAR
SET INTENSITY ON
STORE '   ' TO LOWER
STORE '   ' TO UPPER
STORE 0 TO TOTSTART
STORE 0 TO TOTEND
STORE 0 TO TOTNET
STORE 0 TO TOTQTY
STORE 0 TO TOTDISCR
STORE 0 TO TOTALLOW
STORE 0 TO TOTGROSS

RESTORE FROM DATES ADDITIVE

USE MASTER INDEX MASTER
GOTO TOP
@ 01,00
SET COLOR TO I
?? VWIDE+SPACE(40)
@ 02,00
SET COLOR TO I+
?? VWIDE+'       *** DECUS STATUS REPORT ***      '
SET COLOR TO I
@ 03,00
?? VWIDE+SPACE(40)
@ 04,00 CLEAR
* CHECK FOR "OK-RPTS.MEM" FILE - IF IT EXISTS, CONSOLIDATION HAS BEEN DONE
SET COLOR TO

IF .NOT. FILE("OK-RPTS.MEM")
   @ 10,00
   ?? VBELL3
   SET COLOR TO +I
   @ 10,12 SAY ' DATA FILES HAVE NOT BEEN CONSOLIDATED - CANNOT CONTINUE '

   DO WHILE INKEY()=0
      SET COLOR TO I
      @ 23,24 SAY " PRESS ANY KEY TO CONTINUE "
      SET COLOR TO I+
      @ 23,24 SAY " PRESS ANY KEY TO CONTINUE "
   ENDDO
   SET COLOR TO
   CLEAR
   USE
   RETURN
ENDIF

@ 05,11 SAY 'Enter the LOWER and UPPER range of product codes for this'
@ 06,11 SAY 'report.  Enter ALL for the entire report.  Enter END at '
@ 07,11 SAY 'either LOWER or UPPER range to end reporting function.'
@ 10,43 SAY '                                           '
@ 12,43 SAY '                                           '

DO WHILE LOWER <> 'END' .OR. UPPER <> 'END'

   @ 10,25 SAY 'ENTER LOWER RANGE ' GET LOWER
   @ 12,25 SAY 'ENTER UPPER RANGE ' GET UPPER
   READ
  
   STORE UPPER(LOWER) TO LOWER
   STORE UPPER(UPPER) TO UPPER

   @ 20,24 SAY '                                               '

   IF LOWER = 'END' .OR. UPPER = 'END'
      USE
      CLEAR
      RETURN
   ENDIF

   IF LOWER <> 'ALL' .AND. UPPER <> 'ALL'
      SEEK LOWER

      IF .NOT. FOUND() .OR. LOWER > UPPER
         @ 20,00 
         ?? VBELL3
         SET COLOR TO +
         @ 20,24 
         ?? 'INVALID LOWER RANGE CODE'
         SET COLOR TO
         LOOP
      ENDIF

      SEEK UPPER

      IF .NOT. FOUND() .OR. UPPER < LOWER
         @ 20,00
         ?? VBELL3
         SET COLOR TO +
         @ 20,24 
         ?? 'INVALID UPPER RANGE CODE'
         SET COLOR TO
         LOOP
      ENDIF
   ENDIF

   SET PRINT ON
   * ==== SET PRINTER TO 132 COLUMN MODE
   ? CHR(27)+CHR(91)+CHR(52)+CHR(119)
   SET PRINT OFF

   STORE ' ' TO ANS
   @ 04,00 CLEAR
   SET COLOR TO
   @ 10,13 SAY 'PLACE PLAIN PAPER IN PRINTER...PRESS ANY KEY TO START'

   DO WHILE INKEY()=0
      SET COLOR TO +
      @ 10,50 SAY 'ANY KEY'
      SET COLOR TO
      @ 10,50 SAY 'ANY KEY'
   ENDDO

   CLEAR GETS
   @ 10,00 CLEAR
   SET COLOR TO I+*
   @ 10,23 SAY ' PRINTING REPORT...DO NOT INTERRUPT '
   SET COLOR TO

   IF UPPER = 'ALL' .OR. LOWER = 'ALL'
      GOTO TOP
      STORE PROCOD TO LOWER
      GOTO BOTTOM
      STORE PROCOD TO UPPER
   ENDIF

   GOTO TOP
   SET CONSOLE OFF
   STORE 10 TO LINE
   STORE .T. TO PAGETOP
   SEEK LOWER

   DO WHILE .NOT. EOF()
      SET DEVICE TO PRINT
  
      IF PAGETOP
         @ 02,055 SAY '        DECUS        '
         @ 03,055 SAY 'PRODUCT STATUS REPORT'
         @ 04,055 SAY SDATE+' TO '+EDATE
         @ 05,001 SAY 'PRODUCT RANGE : '+ LOWER + ' TO ' + UPPER
         @ 06,000 SAY REPLICATE("-",130)
         @ 07,001 SAY 'DECUS'
         @ 07,067 SAY 'BEG'
         @ 07,073 SAY 'END'
         @ 07,079 SAY 'QTY'
         @ 07,088 SAY 'GROSS'
         @ 07,111 SAY 'NET'
         @ 07,123 SAY 'INV'
         @ 08,001 SAY 'CODE'
         @ 08,010 SAY 'DEC PART #'
         @ 08,035 SAY 'ITEM DESCRIPTION'
         @ 08,060 SAY 'MLP'
         @ 08,067 SAY 'INV.'
         @ 08,073 SAY 'INV.'
         @ 08,079 SAY 'SOLD'
         @ 08,089 SAY 'MLP'
         @ 08,099 SAY 'ALLOW'
         @ 08,109 SAY 'REVENUE'
         @ 08,123 SAY '+/-'
         @ 09,000 SAY REPLICATE("=",130)
      ENDIF

      STORE .F. TO PAGETOP
     
      IF PROCOD >= LOWER .AND. PROCOD <= UPPER
         STORE CATQTY+CATEQTY+CCTQTY+CCTEQTY+POTQTY+POTEQTY TO QTYSLD
         STORE CATNET+CATENET+CCTNET+CCTENET+POTNET+POTENET TO NET

         @ LINE,002 SAY PROCOD
         @ LINE,010 SAY PARTNO
         @ LINE,024 SAY DESCRI
         @ LINE,056 SAY MLP PICTURE '#####.##'
         @ LINE,066 SAY STARTCNT
         @ LINE,072 SAY ENDCNT
         @ LINE,078 SAY QTYSLD PICTURE '###'
         @ LINE,085 SAY MLP*QTYSLD PICTURE '#####.##'
         @ LINE,097 SAY (MLP*QTYSLD)-NET PICTURE '#####.##'
         @ LINE,109 SAY NET PICTURE '#####.##'
         @ LINE,122 SAY ENDCNT+QTYSLD-STARTCNT PICTURE '####'
         STORE TOTSTART + STARTCNT TO TOTSTART
         STORE TOTEND + ENDCNT TO TOTEND
         STORE TOTQTY + QTYSLD TO TOTQTY
         STORE TOTGROSS+(MLP*QTYSLD) TO TOTGROSS
         STORE TOTALLOW+(MLP*QTYSLD)-NET TO TOTALLOW
         STORE TOTNET + NET TO TOTNET
         STORE TOTDISCR + ENDCNT+QTYSLD-STARTCNT TO TOTDISCR
         STORE LINE+1 TO LINE
         SKIP 1

         DO WHILE EOF() .OR. PROCOD > UPPER
            @ LINE+1,000 SAY REPLICATE("=",130)
            @ LINE+2,000 SAY '*** GRAND TOTALS ***'
            @ LINE+2,066 SAY TOTSTART PICTURE '####'
            @ LINE+2,072 SAY TOTEND PICTURE '####'
            @ LINE+2,078 SAY TOTQTY PICTURE '####'
            @ LINE+2,085 SAY TOTGROSS PICTURE '######.##'
            @ LINE+2,097 SAY TOTALLOW PICTURE '#####.##'
            @ LINE+2,108 SAY TOTNET PICTURE '######.##'
            @ LINE+2,122 SAY TOTDISCR PICTURE '####'
            USE
            SET DEVICE TO SCREEN
            SET CONSOLE ON
            CLEAR
            RETURN
         ENDDO

         IF LINE > 61
            STORE 10 TO LINE
            ? ' '
            ? ' '
            ? ' '
            STORE .T. TO PAGETOP
         ENDIF

      ENDIF
   ENDDO
ENDDO
EJECT
SET CONSOLE ON
CLEAR
USE
RETURN
