* Program   : CONSOL.PRG
* Version   : V4.2
* Author(s) : Joe Tomas
* Date      : 08/22/86
* Notice    : 
* Called by : FMAINT.PRG
* Call(s)   :
* Notes     : CONSOLIDATES LAST BACKUP DATA DISK FROM EACH POS SYSTEM
*           : INTO MASTER DATA FILE FOR FINANCIAL REPORTS
CLEAR
SET COLOR TO I
@ 01,00 
?? VWIDE+SPACE(40)
SET COLOR TO I+
@ 02,00 
?? VWIDE+' *** CONSOLIDATE PRODUCT DATA FILES *** '
SET COLOR TO I
@ 03,00 
?? VWIDE+SPACE(40)
SET COLOR TO
@ 04,00
TEXT

        This function will consolidate all the daily PRODUC file
        data disks and should be used ONLY after the DECUS show is
        over.  The data disks will be read, appended to a MASTER
        data file and quantities will be consolidated for printing
        the financial reports.
ENDTEXT
@ 12,08 SAY 'PLEASE HAVE THE BACKUP DATA DISK FOR THE LAST DAY FROM EACH'
@ 13,08 SAY 'POS SYSTEM READY!'
SET COLOR TO +*
@ 12,49 SAY 'LAST DAY'
SET COLOR TO

STORE '  ' TO ANS
SET COLOR TO +
@ 20,25 SAY 'CONTINUE ?  (Y/N) '
SET COLOR TO
@ 20,43 GET ANS PICTURE '!'
READ

IF ANS <> 'Y'
   CLEAR
   RETURN
ENDIF

@ 4,0 CLEAR

STORE 0 TO ANS1
STORE 1 TO ANS
SET CONFIRM ON

DO WHILE ANS <> ANS1
   STORE 0 TO ANS1
   STORE 0 TO ANS
   SET COLOR TO I+
   @ 23,30 SAY ' ENTER <99> TO QUIT '
   SET COLOR TO
   @ 10,20 SAY 'HOW MANY DATA DISKS DO YOU HAVE? ' GET ANS PICTURE '99'
   READ

   IF ANS = 99
      USE
      CLEAR
      RETURN
   ENDIF

   @ 12,20 SAY 'PLEASE ENTER THE QUANTITY AGAIN. ' GET ANS1 PICTURE '99'
   READ
   @ 16,20 

   IF ANS = ANS1 .AND. (ANS <> 0 .OR. ANS1 <> 0)
      LOOP
   ELSE
      @ 16,20
      ?? VBELL3
      SET COLOR TO +
      @ 16,20 SAY 'INVALID ENTRY - TRY AGAIN'
      SET COLOR TO
      STORE 0 TO ANS1
      STORE 1 TO ANS
   ENDIF

ENDDO

@ 4,0 CLEAR

STORE 1 TO REPEAT

DO WHILE REPEAT <= ANS

   @ 10,20
   @ 12,20
   @ 16,20
   @ 10,20 SAY 'PLEASE INSERT DISK #'+STR(REPEAT,2)+' INTO DRIVE A:'
   
   DO WHILE INKEY() = 0
      SET COLOR TO I
      @ 23,24 SAY 'PRESS ANY KEY TO BEGIN UPDATE...'
      SET COLOR TO I+
      @ 23,24 SAY 'PRESS ANY KEY TO BEGIN UPDATE...'
   ENDDO
   
   SET COLOR TO
   @ 20,15 

   IF FILE("A:UPDATE.MEM")
      @ 12,00
      ?? VBELL3
      SET COLOR TO +
      @ 12,15 SAY 'DISK HAS ALREADY BEEN UPDATED! REPLACE WITH NEW DISK!'
      SET COLOR TO
      LOOP
   ENDIF

   IF REPEAT <= ANS
      USE MASTER INDEX MASTER
      @ 12,00
      SET COLOR TO I*+
      @ 12,20 SAY 'NOW UPDATING MASTER FILE WITH DISK #'+STR(REPEAT,2)
      SET COLOR TO
      APPEND FROM A:PRODUC
      SAVE TO A:UPDATE ALL LIKE REPEAT

     STORE REPEAT + 1 TO REPEAT
   ENDIF

ENDDO

USE

@ 4,0 CLEAR
SET COLOR TO I+*
@ 12,20 SAY 'NOW TOTALING MASTER DATA FILE...PLEASE WAIT'
SET COLOR TO
USE MASTER INDEX MASTER
TOTAL ON PROCOD TO TEMP FIELDS CATQTY,CATNET,CATEQTY,CATENET,;
CCTQTY,CCTNET,CCTEQTY,CCTENET,POTQTY,POTNET,POTEQTY,POTENET
USE
DELETE FILE MASTER.DBF
RENAME TEMP.DBF TO MASTER.DBF
USE MASTER
INDEX ON PROCOD TO MASTER
SET INDEX TO MASTER

* ADJUST MISC CODE (999) GROSS AND ALLOWANCE
FIND 999

REPLACE MLP WITH ;
(CATNET+CATENET+CCTNET+CCTENET+POTNET+POTENET)/(CATQTY+CATEQTY+CCTQTY+CCTEQTY;
+POTQTY+POTEQTY)
REPLACE PARTNO WITH '  -QSLEP-UZ'
REPLACE DESCRI WITH 'MISC. LOW END SOFTWARE ITEMS'
USE

* FLAG FILE FOR FINANCIAL REPORTS - IF IT EXISTS, OK TO PRINT
SAVE TO OK-RPTS ALL LIKE ANS1
@ 04,00 CLEAR
?? VBELL3
SET COLOR TO +
@ 12,10 SAY "UPDATES ARE NOW COMPLETE.  You may now print financial reports."
SET COLOR TO

DO WHILE INKEY() = 0
   SET COLOR TO I
   @ 23,24 SAY ' PRESS ANY KEY TO CONTINUE '
   SET COLOR TO I+
   @ 23,24 SAY ' PRESS ANY KEY TO CONTINUE '
ENDDO
SET COLOR TO
USE
CLEAR
RETURN
