
;Ŀ
;                                                                   
;                                               
;                                                         
;                                                  
;                                                           
;                                               
;                                                                   
;                                                                   
;        2MDOS 1.0  -  (C) 1994-1995  Ciriaco Garca de Celis.      
;                                                                   
;      Para obtener el ejecutable:                                  
;        TASM  2mdos    /m5                                         
;        TLINK 2mdos    /t                                          
;                                                                   
;   El fichero 2MFBOOT.DB que se carga con INCLUDE debe obtenerse   
;   previamente a partir de 2MFBOOT.ASM con ayuda de 2MFBMAKE.BAS   
;                                                                   
;

ON             EQU   1                 ; constantes booleanas
OFF            EQU   0

; ------------ Macros de propsito general.

XPUSH          MACRO regmem            ; apilar lista de registros
                 IRP rm, <regmem>
                   PUSH rm
                 ENDM
               ENDM

XPOP           MACRO regmem            ; desapilar lista de registros
                 IRP rm, <regmem>
                   POP rm
                 ENDM
               ENDM

; ------------ Programa.

_PRINCIPAL     SEGMENT
               ASSUME CS:_PRINCIPAL, DS:_PRINCIPAL

               ORG   100h

ini_residente  EQU   $

; ****************************************
; *                                      *
; *   D A T O S    R E S I D E N T E S   *
; *                                      *
; ****************************************

inicio:        JMP   main

; ------------ Identificacin estandarizada del programa.

program_id     LABEL BYTE
segmento_real  DW    0   ; segmento real donde ser cargado
offset_real    DW    0   ; offset real     "     "     "
longitud_total DW    0   ; zona de memoria ocupada (prrafos)
info_extra     DB    80h ; bits 0, 1 y 2-> 000: normal, con PSP
                         ;                 001: bloque UMB XMS
                         ;                 010: *.SYS
                         ;                 011: *.SYS formato EXE
                         ; bit 7 a 1: extension_id definida
multiplex_id   DB    0   ; nmero Multiplex de este TSR
vectores_id    DW    tabla_vectores
extension_id   DW    tabla_extra
               DB    "*##*"
autor_nom_ver  DB    "CiriSOFT:2MDOS:1.0",0
               DB    2  ; nmero de vectores de interrupcin usados
tabla_vectores EQU   $
i13_40_0       DB    13h           ; INT 13h
ant_i13        LABEL DWORD         ; direccin original
ant_i13_off    DW    0
ant_i13_seg    DW    0
               DB    2Fh           ; INT 2Fh
ant_i2F        LABEL DWORD         ; direccin original
ant_i2F_off    DW    0
ant_i2F_seg    DW    0

tabla_extra    LABEL BYTE
               DW    ctrl_exterior ; permitido control exterior
               DW    0             ; campo reservado

ctrl_exterior  LABEL BYTE
reubicabilidad DB    1             ; programa 100% reubicable
activacion     DW    act
act            DB    1

; ******************************************************
; *                                                    *
; *   C O D I G O   Y   D A T O S   D E    2 M D O S   *
; *                                                    *
; ******************************************************

sop2m          DB    ?       ; indica si hay soporte 2M instalado
sopdcopy       DB    ON      ; por defecto, soporte para DISKCOPY
opt            DB    ON      ; por defecto, optimizacin de formateo
boost          DB    ON      ; por defecto, optimizacin DiskBoost
fdread         DB    ON      ; por defecto, con soporte FDREAD
fmt            DB    OFF     ; por defecto, sin apoyo a MS-DOS FORMAT
x_hd           DW    2       ; sector sliding para alta densidad
y_hd           DW    3
x_dd           DW    1
y_dd           DW    3       ; sector sliding para doble densidad
mingap         DW    32      ; GAP3 mnimo para interleave 1:1
fmt_A          DW    0       ; formato activo en curso (0 DOS/FDF)
               DW    0       ; cilindros/sectores del formato
fmt_B          DW    0       ; dem para B:
               DW    0

xms_handler    LABEL DWORD   ; direccin del controlador XMS, si
xms_hndl_off   DW    ?       ; est instalado
xms_hndl_seg   DW    ?
xms_handle     DW    0       ; handle XMS (0 = no utilizada XMS)

; ------------ Rutina de gestin de INT 2Fh.

nueva_i2F      PROC  FAR
               STI
               CMP   AH,CS:multiplex_id
               JE    preguntan
               JMP   CS:ant_i2F        ; saltar al gestor de INT 2Fh
preguntan:     CMP   DI,1992h
               JNE   ret_no_info       ; no llama alguien del convenio
               MOV   AX,ES
               CMP   AX,1492h
               JNE   ret_no_info       ; no llama alguien del convenio
               PUSH  CS
               POP   ES                ; s llama: darle informacin
               LEA   DI,autor_nom_ver
ret_no_info:   MOV   AX,0FFFFh         ; "entrada multiplex en uso"
               IRET
nueva_i2F      ENDP

; ------------ Nueva rutina de gestin de INT 13h.

nueva_i13      PROC
               STI
               CMP   DL,1
               JA    jmp_bios          ; no es disquetera
               CMP   AH,2
               JB    jmp_bios
               CMP   AH,5
               JB    fdread_code
               JNE   otra_func
               JMP   format
otra_func:     CMP   AH,18h
               JNE   set_old?
               JMP   set_media
set_old?:      CMP   AH,17h
               JE    set_old_media
jmp_bios:      JMP   CS:ant_i13

; ------------ Emulacin de FDREAD.

fdread_code:   CMP   CS:fdread,ON      ; funciones 2, 3 y 4
               JNE   jmp_bios
               XPUSH <AX, BX, DS>
               XOR   BX,BX
               MOV   DS,BX
               LDS   BX,DS:[1Eh*4]     ; DS:BX -> tabla base disco
               ADD   AL,CL
               DEC   AL
               MOV   [BX+4],AL             ; sectores/pista necesarios
               MOV   BYTE PTR DS:[BX+5],1  ; GAP R/W mnimo
               OR    CH,CH                 ; pista 0?
               XPOP  <DS, BX, AX>
               JZ    call_i13          ; as es
               PUSH  AX                ; *
               PUSHF
               CALL  CS:ant_i13
               JNC   exit_ok           ; no hubo error
               CMP   AH,3
               JE    exit_nok          ; protegido de escritura
               CMP   AH,6
               JE    exit_nok          ; cambio de disco
               CMP   AH,9
               JE    exit_nok          ; frontera de DMA (INT 40h)
               POP   AX
               XPUSH <DS, BX>          ; lo hubo...ser del stepping?
               MOV   BX,40h
               MOV   DS,BX
               MOV   BX,90h
               ADD   BL,DL
               CMP   CH,43             ; pista > 43?
               JA    quita_step
               XOR   BYTE PTR DS:[BX],20h    ; invertir doble stepping
               JMP   fin_step
quita_step:    AND   BYTE PTR DS:[BX],0DFh   ; quitar doble stepping
fin_step:      XPOP  <BX, DS>
call_i13:      PUSHF
               CALL  CS:ant_i13
               PUSH  AX
               JMP   exit_ok
exit_nok:      STC
exit_ok:       INC   SP
               INC   SP                ; quitar AX de la pila
               RETF  2

; ------------ Nueva funcin 17h.

set_old_media: PUSH  BX
               CALL  ptr_BX_data
               MOV   WORD PTR CS:[BX],0  ; formatos flexibles slo en
               POP   BX                  ; la funcin 18h, no la 17h
               JMP   CS:ant_i13

; ------------ Nueva funcin 18h.

set_media:     XPUSH <DS, BX>          ; *1-2-3
               PUSH  CS
               POP   DS
               MOV   disco,DL
               MOV   cilsec,CX
               CALL  get_fmt           ; buscar el formato solicitado
               JNC   hay_fmt           ; existe
f18_bios:      MOV   CX,cilsec
               MOV   DL,disco
               XPOP  <BX, DS>          ; *1
               JMP   jmp_bios          ; formato no reconocido (?)
hay_fmt:       CMP   BYTE PTR [BX+1],0 ; formatos del DOS
               JE    fmt_dos_fdf
               CMP   sopdcopy,ON
               JNE   f18_bios          ; no hay soporte DISKCOPY
               CMP   BYTE PTR [BX+1],2 ; formatos 2M
               JE    fmt_2m
               CMP   fdread,ON         ; formatos FDFORMAT...
               JE    fmt_dos_fdf
               JMP   f18_bios          ; no se emula soporte FDFORMAT

fmt_2m:        MOV   BX,[BX+2]
               PUSH  BX
               CALL  ptr_BX_data
               MOV   DI,BX
               POP   BX
               MOV   [DI],BX           ; formato 2M seleccionado
               MOV   BX,cilsec
               MOV   [DI+2],BX
               MOV   f2m_nsects,BL
               MOV   f2m_npistas,BH
               XPOP  <BX, DS>          ; *2
               PUSH  CS
               POP   ES
               LEA   DI,param_f2m      ; tabla INT 1Eh para formato 2M
               MOV   AH,0
               CLC
               RETF  2

fmt_dos_fdf:   PUSH  BX
               CALL  ptr_BX_data
               MOV   WORD PTR [BX],0   ; no es formato 2M
               POP   BX
               MOV   ptrdat,BX
               MOV   CX,cilsec
               CMP   CH,43
               JBE   p40
               CMP   fdread,ON    ; si FDREAD OFF, 5.25 no admite 720K
               JNE   no_525hd
               XPUSH <AX, BX, CX, DX, DI, ES>
               MOV   DL,disco
               MOV   AH,8
               PUSHF
               CALL  ant_i13
               CMP   BL,2         ; unidad de 1.2M?
               XPOP  <ES, DI, DX, CX, BX, AX>
               JNE   no_525hd
               CMP   CL,15        ; si DD -> simular 40 pistas
               JB    p40
no_525hd:      MOV   CH,79        ; forzar n de pistas soportado
               JMP   p40u80
p40:           MOV   CH,39
p40u80:        MOV   CL,[BX+2]    ; forzar n de sectores soportado
               MOV   DL,disco
               XPOP  <BX, DS>     ; *3
               PUSHF
               CALL  CS:ant_i13   ; la BIOS estndar no protestar
               PUSHF              ; *
               XPUSH <DS, SI>     ; **
               MOV   SI,40h
               MOV   DS,SI
               MOV   SI,90h
               MOV   CL,CS:disco
               MOV   CH,0
               ADD   SI,CX
               AND   BYTE PTR DS:[SI],11011111b ; sin doble stepping
               CMP   BYTE PTR CS:cilsec+1,43    ; 80 pistas?
               JA    step_ok                    ; as es
               OR    BYTE PTR DS:[SI],00100000b ; poner doble stepping
step_ok:       PUSH  ES
               POP   DS                ; DS -> tabla parmetros BIOS
               PUSH  CS
               POP   ES                ; ES -> nuestra futura tabla
               MOV   SI,DI
               LEA   DI,param_fxx
               MOV   CX,13             ; mejor 13 que 11
               CLD
               REP   MOVSB             ; copiar tabla BIOS a RAM
               LEA   DI,param_fxx
               PUSH  BX                ; ***
               MOV   BX,CS:ptrdat
               MOV   BL,CS:[BX+3]
               MOV   ES:[DI+7],BL      ; GAP3 correcto para formateo
               POP   BX                ; ***
               MOV   CX,CS:cilsec
               MOV   DL,CS:disco
               XPOP  <SI, DS>          ; **
               POPF                    ; *
               MOV   ES:[DI+11],CH     ; n pistas solicitado
               MOV   ES:[DI+4],CL      ; n sectores solicitado
               RETF  2

; ------------ Nueva funcin 5.

format:        CMP   SI,"2M"           ; llaman directamente a 2M?
               JE    fmt_estandar
               PUSH  BX                ; nueva funcin de formateo
               CALL  ptr_BX_data
               CMP   WORD PTR CS:[BX],0
               JNE   formatea_2m       ; formato 2M
               POP   BX
               JMP   fmt_estandar      ; formato DOS/FDF

               ; --- Formateo 2M en curso.

formatea_2m:   XPUSH <SI, DI, BP>      ; * BX ya apilado
               XPUSH <DS, ES>          ; **
               XPUSH <CX, DX>          ; ***
               XPUSH <CS, CS>
               XPOP  <DS, ES>
               CALL  build_boot        ; construir arranque disco 2M
               XPOP  <DX, CX>          ; ***
               CALL  format_2m         ; formatear pista disco 2M
               XPOP  <ES, DS>          ; **
               XPOP  <BP, DI, SI, BX>  ; *
               RETF  2

               ; --- Formateo estndar/fdformat en curso. Se aplican
               ;     las optimizaciones activas a menos que se detecte
               ;     un formato extrao en el programa que llama.

fmt_estandar:  XPUSH <AX, BX, CX, DX>  ; *1-2
               XPUSH <SI, DI, BP>
               XPUSH <DS, ES>
               CMP   SI,"2M"           ; formateo directo con 2M?
               JE    fmt_ok
               MOV   SI,BX             ; ES:SI buffer
               MOV   BL,CH             ; cilindro
               MOV   BH,DH             ; cabezal
               XOR   DI,DI
               MOV   DS,DI
               LDS   DI,DS:[1Eh*4]     ; DS:DI -> INT 1Eh
               MOV   CL,[DI+4]
               MOV   CH,0              ; CX = n sectores INT 1Eh
               PUSH  CX                ; **1-2
test_tam:      CMP   ES:[SI],BX
               JNE   test_raro         ; cilindro/cabezal falsos
               CMP   BYTE PTR ES:[SI+2],36
               JA    test_raro         ; n de sector extrao
               CMP   BYTE PTR ES:[SI+2],0
               JE    test_raro         ; n de sector extrao
               CMP   BYTE PTR ES:[SI+3],2
               JNE   test_raro         ; el sector no es de 512
               JMP   test_otro
test_raro:     POP   CX                ; **1
               JMP   fmt_ok            ; respetar formato pedido
test_otro:     ADD   SI,4
               LOOP  test_tam          ; formato normal?
               POP   CX                ; **2
               CMP   CS:boost,ON
               JNE   no_boost          ; inhibida tecnologa DiskBoost
               CMP   CL,15
               JE    diskboost         ; 1.2M
               CMP   CL,18
               JNE   no_boost          ; 1.44M
diskboost:     JMP   boostdisk
no_boost:      CMP   CL,21
               JE    optimiza          ; siempre en 1.72M (interleave)
               CMP   CS:opt,ON
               JE    optimiza          ; activada optimizacin general
fmt_ok:        XPOP  <ES, DS>
               XPOP  <BP, DI, SI>
               XPOP  <DX, CX, BX, AX>  ; *1

               ; --- Formatear normal sin optimizacin.

               JMP   jmp_bios          ; funcin BIOS original

               ; --- Formatear con optimizacin sector sliding.

optimiza:      PUSH  CS
               POP   ES
               MOV   BP,BX             ; cabezal/cilindro
               PUSH  DX                ; * cabezal/unidad
               LEA   SI,buffer_extra
               MOV   AL,BYTE PTR CS:x_hd
               MOV   AH,BYTE PTR CS:y_hd
               CMP   CL,15             ; 15 o ms sectores -> HD
               JAE   xy_ok
               MOV   AL,BYTE PTR CS:x_dd
               MOV   AH,BYTE PTR CS:y_dd
xy_ok:         PUSH  AX                ; AL = /X ,  AH = /Y
               ADD   AL,AH
               MUL   BL                ; cilindro * (X+Y)
               MOV   DX,AX
               POP   AX
               MUL   BH                ; cabezal * X
               ADD   AX,DX
               XOR   DX,DX             ; DX:AX = cil * (X+Y) + cab * X
               MOV   BL,CL
               MOV   BH,0
               DIV   BX                ; DL = DX:AX MOD sectores = dis
               SUB   DL,CL
               NEG   DL                ; DL = sectores - dis =
               MOV   BL,CL             ;    = primer_sector - 1
               MOV   BH,[DI+7]         ; GAP3 de formateo
               SUB   BH,BYTE PTR CS:mingap  ; BH < 0 si GAP3 muy pequeo
               MOV   DI,CX
               SHL   DI,1
               SHL   DI,1              ; DI = CX * 4
               ADD   DI,SI             ; DI -> final tabla de datos
               MOV   AX,SI             ; AX -> inicio tabla de datos
               SUB   SI,4
               MOV   DH,2              ; tamao 512
               PUSH  CX                ; **
genera_pn:     ADD   SI,4
               INC   DX                ; siguiente sector en la pista
               CMP   DL,BL
               JBE   ns_ok
               MOV   DL,1              ; empezar desde el 1
ns_ok:         AND   BH,BH
               JNS   pon_sec           ; GAP3 es bastante grande
               ADD   SI,4              ; si no, usar interleave 2:1
               CMP   SI,DI
               JB    pon_sec
               MOV   SI,AX
pon_sec:       MOV   ES:[SI],BP        ; cilindro / cabezal
               MOV   ES:[SI+2],DX      ; n sector / tamao
               LOOP  genera_pn
               POP   CX                ; ** n sectores
               MOV   AL,CL             ; AL = sectores
               POP   DX                ; * DL = unidad, DH = cabezal
               MOV   CX,BP
               XCHG  CH,CL             ; CH = cilindro
               MOV   AH,5              ; formatear
               LEA   BX,buffer_extra
               PUSHF
               CALL  CS:ant_i13
               JMP   fmt_ret

               ; --- Formatear con optimizacin DiskBoost.

boostdisk:     PUSH  CS
               POP   ES
               PUSH  [DI+6]            ; * preservar [DI+7]
               MOV   DH,CL             ; DH = sectores
               MOV   AH,40             ; GAP3 para 1.2
               CMP   CL,15
               JE    fmtgp_ok
               MOV   AH,45             ; GAP3 para 1.44
fmtgp_ok:      MOV   [DI+7],AH         ; GAP3 final
               LEA   SI,buffer_extra
               INC   CL                ; como mnimo 1 sector ms
               MOV   AH,BH             ; cabezal
               XOR   AH,1              ; 0 en cabezal 1 y 1 en el 0
               ADD   AH,CL             ; otro sector ms en cabezal 0
               PUSH  [DI+4]            ; ** preservar [DI+4]
               MOV   [DI+4],AH         ; nmero de sectores final
               MOV   AL,CL             ; sectores (15  18) + 1
               MOV   CL,AH             ; sectores finales (AL + 0  1)
               MOV   AH,2              ; tamao 2 (512 bytes)
haz_tabla:     MOV   ES:[SI],BX        ; cilindro / cabezal
               MOV   ES:[SI+2],AX      ; nmero de sector / tamao
               CMP   AL,DH             ; excedido el nmero normal?
               JBE   fmt_nsok          ; no
               MOV   WORD PTR ES:[SI+2],0  ; pues simular sector raro
fmt_nsok:      INC   AL
               CMP   AL,[DI+4]         ; alcanzado ltimo sector?
               JBE   nsec_ok           ; no
               MOV   AL,1              ; empezar por el primero
nsec_ok:       ADD   SI,4
               LOOP  haz_tabla         ; completar tabla
               MOV   AH,5              ; funcin de formateo
               MOV   AL,[DI+4]         ; n sectores finales
               MOV   CH,BL             ; cilindro
               MOV   DH,BH             ; cabezal
               LEA   BX,buffer_extra   ; nuestra tabla
               PUSHF
               CALL  CS:ant_i13        ; formatear pista
               POP   [DI+4]            ; ** restaurar [DI+4]
               POP   [DI+6]            ; * restaurar [DI+7]

               ; --- Retorno tras formateo sin variar flags ni AX.

fmt_ret:       XPOP  <ES, DS>
               XPOP  <BP, DI, SI>
               XPOP  <DX, CX, BX>      ; *2
               INC   SP
               INC   SP                ; quitar AX de la pila
               RETF  2

; ------------ Buscar en nuestra tabla el formato solicitado.

get_fmt        PROC
               XPUSH <AX, CX, DX>      ; *
               XPUSH <SI, DI, BP>
get_rep:       MOV   AH,8
               MOV   DL,disco
               PUSH  ES
               PUSHF
               CALL  CS:ant_i13        ; tipo de unidad?
               POP   ES
               JNC   t_ok
               CMP   AH,6
               JE    get_rep
               STC
               JMP   no_hay_fmt
t_ok:          AND   BL,BL
               JZ    no_hay_fmt
               DEC   BL
               MOV   BH,0
               SHL   BL,1
               ADD   BX,OFFSET tabla_tipos
               MOV   BX,[BX]           ; BX -> lista formatos
               MOV   CX,cilsec
busca_fmt:     CMP   CL,[BX]
               JE    ese_fmt           ; encontrado
busca_otro:    CMP   BYTE PTR [BX],0
               JE    no_hay_fmt        ; fin de la tabla
               ADD   BX,4
               JMP   busca_fmt
ese_fmt:       CLC                     ; retorno correcto
               JMP   fmt_rt
no_hay_fmt:    STC                     ; formato no encontrado
fmt_rt:        XPOP  <BP, DI, SI>
               XPOP  <DX, CX, AX>      ; *
               RET
get_fmt        ENDP

nueva_i13      ENDP

; ------------ Apuntar BX a los datos de la unidad DL.

ptr_BX_data    PROC
               LEA   BX,fmt_A
               AND   DL,DL
               JZ    fmtptr_ok
               LEA   BX,fmt_B
fmtptr_ok:     RET
ptr_BX_data    ENDP

; ------------ Datos residentes.

disco          DB    ?
cilsec         DW    ?         ; cilindros/sectores en curso
ptrdat         DW    ?         ; puntero temporal a los datos

t_tams         DB    1,2,3,6,11,22     ; sectores 128 ocupados por un
                                       ; sector mayor en 2MF /M

param_f2m      LABEL BYTE                      ; Tabla formato INT 1Eh
               DB    0BFh, 002h, 025h, 002h    ; vlida para todos los
f2m_nsects     DB    016h, 01Bh, 0FFh, 06Ch    ; formatos 2M ajustando
               DB    0F6h, 00Fh, 008h          ; el nmero de sectores
f2m_npistas    DB    051h, 000h                ; y pistas

param_fxx      LABEL BYTE                      ; Tabla formato INT 1Eh
               DB       ?,    ?,    ?,    ?    ; para formatos del DOS
               DB       ?,    ?,    ?,    ?    ; y FDFORMAT
               DB       ?,    ?,    ?
               DB       ?,    ?

tabla_tipos    DW    t360    ; unidad tipo 1
               DW    t1200   ; unidad tipo 2
               DW    t720    ; unidad tipo 3
               DW    t1440   ; unidad tipo 4
               DW    t2880   ; unidad tipo 5 (BIOS AMI)
               DW    t2880   ; unidad tipo 6 (BIOS IBM)

               ; Estructura de esta tabla (por cada tipo de formato):
               ;  1) DB N de sectores del formato (0-ltima entrada)
               ;  2) DB byte de tipo de formato: (0-DOS, 1-FDF, 2-2M)
               ;  3) DW Slo si es 2M, puntero a la tabla del formato
               ;  3) DB Slo si es FDF/DOS, n sectores "legales"
               ;  4) DB Slo si es FDF/DOS, GAP3 para formateo
               ; Esta tabla se ordena para que las unidades de mayor
               ; densidad soporten los formatos de doble densidad. En
               ; los formatos comunes a 2M/FDF se coloca primero 2M.

t1200          DB    15,0, 15, 84      ; 1.20M - DOS
               DB    16,1, 15, 64      ; 1.31M - FDF
               DB    17,1, 15, 33      ; 1.39M - FDF
               DB    18,2              ; 1.47M - 2M
               DW    f_1476
               DB    18,1, 15, 2       ; 1.47M - FDF
               DB    19,2              ; 1.55M - 2M
               DW    f_1558
t360           DB    8,0,   8, 127     ;  320K - DOS
               DB    9,0,   9, 80      ;  360K - DOS
               DB    10,2              ;  820K - 2M
               DW    f_820_525
               DB    10,1,  9, 40      ;  820K - FDF
               DB    11,2              ;  902K - 2M
               DW    f_902
               DB    0       ; fin de la tabla 5.25

t2880          DB    36,0, 36, 80      ; 2.88M - DOS
               DB    44,2              ; 3.60M - 2M
               DW    f_3608
               DB    46,2              ; 3.77M - 2M
               DW    f_3772
t1440          DB    18,0, 18, 108     ; 1.44M - DOS
               DB    19,1, 18, 72      ; 1.55M - FDF
               DB    20,1, 18, 40      ; 1.64M - FDF
               DB    21,1, 18, 12      ; 1.72M - FDF
               DB    22,2              ; 1.80M - 2M
               DW    f_1804
               DB    23,2              ; 1.88M - 2M
               DW    f_1886
t720           DB    9,0,   9, 80      ;  720K - DOS
               DB    10,2              ;  820K - 2M
               DW    f_820_350
               DB    10,1,  9, 40      ;  820K - FDF
               DB    12,2              ;  984K - 2M
               DW    f_984
               DB    13,2              ; 1.06M - 2M
               DW    f_1066
               DB    14,2              ; 1.14M - 2M
               DW    f_1148
               DB    0       ; fin de la tabla 3.5

               ; --- Sector de arranque de futuro disquete 2M y
               ;     rea de trabajo para el formateo estndar.

buffer_fmt     DB    0E9h            ; JMP 16 bit
bf_jmp         DW    ?               ; offset del salto
bf_id          DB    "2M-STV"        ; system ID
bf_fmt         DW    ?               ; formato 2M correspondiente
               DW    512             ; bytes por sector
bf_sclus       DB    1               ; sectores por cluster
               DW    1               ; sectores reservados al comienzo
               DB    2               ; nmero de copias de la FAT
bf_root        DW    224             ; entradas al directorio raz
bf_totsects    DW    ?               ; sectores totales en el disco
bf_media       DB    ?               ; descriptor de medio
bf_sectfat     DW    ?               ; sectores ocupados por cada FAT
bf_sectpista   DW    ?               ; sectores por pista
               DW    2               ; nmero de cabezales
               DD    0               ; sectores especiales reservados
               DD    0               ; nmero de sectores (32 bit)
               DB    0               ; unidad fsica
               DB    0               ; reservado
               DB    29h             ; disquete DOS >= 4.0
               DD    00000000h       ; nmero de serie
               DB    "NO NAME    "   ; etiqueta del disco
               DB    "FAT12   "      ; tipo de FAT
               DB    0               ; reservado por 2M
bf_checksum    DB    ?               ; checksum de 2M (si empleado)
               DB    7               ; versin formato 7 (SuperBOOT)
bf_fmt_vels    DB    ?               ; a 1 si formato 2MF/M
               DB    ?               ; velocidad transferencia pista 0
               DB    ?               ; velocidad    "       pista != 0
bf_ptrboot     DW    ?               ; offset al programa de arranque
bf_ptrT1       DW    76              ; T1: informacin para pista 0
bf_ptrT2       DW    ?               ; T2: informacin para pista!=0
bf_ptrT3       DW    ?               ; T3: tabla de tamao de sectores

buffer_extra   DB    512 DUP (0)     ; espacio para un sector y para
                                     ; el resto del arranque de 2M

fin_resid_no2m LABEL BYTE

; *********************************************
; *   FIN DEL AREA RESIDENTE SIN SOPORTE 2M   *
; *********************************************

; ------------ Construir sector de arranque de disquete 2M. A la
;              entrada, BX apunta al formato en la tabla.

build_boot     PROC
               MOV   SI,[BX]      ; SI -> tabla con informacin 2M
               MOV   BX,[BX+2]    ; BL = sectores, BH = cilindros-1
               INC   BH                ; BH = cilindros
               MOV   AX,BX
               MOV   AH,0
               MOV   bf_sectpista,AX
               MUL   BH                ; sectores * cilindros
               SHL   AX,1              ; por dos cabezales
               MOV   bf_totsects,AX
               MOV   CX,[SI]           ; tipo formato
               MOV   bf_fmt,CX
               MOV   BL,0F0h           ; media ID para 1.47M
               CMP   CX,"60"
               JE    media_ok
               MOV   BL,0FAh           ; media ID para el resto
media_ok:      MOV   bf_media,BL
               MOV   CX,bf_root        ; entradas directorio raz
               SHR   CX,1
               SHR   CX,1
               SHR   CX,1
               SHR   CX,1              ; ficheros raiz / 16
               SUB   AX,CX             ; sectores totales - raiz
               DEC   AX                ; y menos boot
               MOV   BX,3
               MUL   BX                ; 3 * (NumSect-(FichRaiz>>4)-1)
               XPUSH <AX, DX>
               MOV   AX,1024
               MOV   DL,bf_sclus
               MOV   DH,0
               MUL   DX
               ADD   AX,6
               MOV   BX,AX             ; 6 + 1024 * SectCluster
               XPOP  <DX, AX>
               DIV   BX
               AND   DX,DX             ; divisin exacta?
               JZ    tfat_ok
               INC   AX                ; redondear
tfat_ok:       MOV   bf_sectfat,AX
               LEA   DI,bf_fmt_vels
               ADD   SI,2
               CLD
               MOVSB
               MOVSW
               SUB   SI,2+3            ; anular ADD y MOVS
               LEA   DI,buffer_extra   ; informacin 1 pista fsica
               MOV   AX,[SI+5]
               MOV   [DI],AX           ; AL = n sectores, AH = GAP3
               ADD   DI,2
               MOV   BX,[SI+7]         ; BL = 1 sector, interleave BH
               MOV   DL,BH
               MOV   DH,0              ; interleave DX
               MOV   AH,0              ; AX sectores
               MOV   BH,AL             ; BH sectores (control bucle)
               MOV   CX,AX
               ADD   CX,DI             ; ptr al ltimo byte de T1 + 1
               MOV   BP,DI
crea_T1:       MOV   [DI],BL           ; poner sector
               INC   BL                ; siguiente sector
               ADD   DI,DX             ; factor de interleave
               CMP   DI,CX
               JB    ptr_ok
               INC   BP
               MOV   DI,BP             ; recargar puntero
ptr_ok:        DEC   BH
               JNZ   crea_T1
               MOV   DI,CX             ; puntero a T2
               MOV   bf_ptrT2,DI
               SUB   bf_ptrT2,OFFSET buffer_fmt
               CMP   bf_fmt_vels,1
               JE    fmt_stv
               MOV   CX,5              ; formato 2MF /F...
               ADD   SI,9
               REP   MOVSB             ; creada T2
               MOV   bf_ptrT3,DI
               SUB   bf_ptrT3,OFFSET buffer_fmt
               MOV   CL,[DI-5]
               MOV   CH,0
               MOV   AL,[DI-3]
               REP   STOSB             ; creada T3
               JMP   boot_build
fmt_stv:       MOV   CX,3              ; formato 2MF /M...
               ADD   SI,9
               REP   MOVSB             ; creando T2
               MOV   CL,[DI-1]
               MOV   CH,0              ; n sectores
               PUSH  CX                ; *
               MOV   BX,SI
               ADD   BX,CX             
               DEC   BX                ; BX apunta a futura T3 - 1
               MOV   DL,129
crea_t2:       MOV   [DI],DL           ; n sector a renumerar
               LODSB
               MOV   [DI+1],AL         ; n sector final
               PUSH  BX                ; **
               XLAT
               MOV   [DI+2],AL         ; tamao
               LEA   BX,t_tams
               XLAT
               ADD   DL,AL
               POP   BX                ; **
               ADD   DI,3
               LOOP  crea_t2
               POP   CX                ; *
               MOV   bf_ptrT3,DI
               SUB   bf_ptrT3,OFFSET buffer_fmt
               REP   MOVSB
boot_build:    MOV   bf_ptrboot,DI                ; apuntar arranque
               SUB   bf_ptrboot,OFFSET buffer_fmt
               MOV   bf_jmp,DI                    ; salto al BOOT
               SUB   bf_jmp,OFFSET bf_id
               MOV   BX,DI
               LEA   SI,buffer_fmt[64]
               XOR   AL,AL
eval_chk:      DEC   BX                ; calcular checksum
               CMP   BX,SI
               JB    pon_chk
               ADD   AL,[BX]
               JMP   eval_chk
pon_chk:       NEG   AL
               MOV   bf_checksum,AL
               LEA   SI,_BootHDPrg     ; cdigo de arranque HD
               MOV   CX,_BootHDPrgLong
               CMP   bf_sectpista,15
               JAE   pr_boot_ok
               LEA   SI,_BootDDPrg     ; cdigo de arranque DD
               MOV   CX,_BootDDPrgLong
pr_boot_ok:    CALL  xms_movsb         ; copiar arranque
               JZ    pr_boot_bien      ; (podra fallar en XMS)
               INC   bf_checksum       ; fallo: forzar mal checksum
pr_boot_bien:  MOV   BX,DI
               LEA   DI,buffer_fmt[511]
               LEA   SI,msg_final[15]
               MOV   CX,16
               STD
firma:         CMP   DI,BX
               JBE   fin_build
               MOVSB                   ; completar signatura final
               LOOP  firma
fill0:         CMP   DI,BX
               JBE   fin_build
               MOV   BYTE PTR [DI],0   ; rellenar de ceros el resto
               DEC   DI
               JMP   fill0
fin_build:     RET
build_boot     ENDP

; ------------ Formatear pista de disquete 2M.

format_2m:     MOV   SI,"2M"           ; formateo 2M
               MOV   AH,5              ; funcin de formateo
               XPUSH <CX, DX>          ; *
               MOV   AL,7Fh
               LEA   BX,buffer_fmt     ; sector de arranque disco 2M
               PUSHF
               CALL  ant_i13           ; invocar el formateo de 2M
               XPOP  <DX, CX>          ; *
               JC    ret_fmt           ; fallo
               MOV   AL,CH             ; no hubo fallo
               OR    AL,DH
               JZ    init_t0           ; es cilindro 0 y cabezal 0
               CMP   bf_fmt_vels,1
               CLC                     ; no haba error
               JNE   ret_fmt           ; no es formato 2MF /M
               XPUSH <CX, DX>          ; *
               MOV   AX,bf_sectpista   ; n sectores
               MOV   AH,3              ; funcin de escritura
               OR    DH,80h            ; forzar escritura fsica
               MOV   CL,1              ; desde el primer sector
               PUSHF
               CALL  ant_i13
               JMP   ret_fmt_p
init_t0:       XPUSH <CX, DX>          ; inicializar primera pista
               MOV   AX,301h           ; escribir 1 sector
               LEA   BX,buffer_fmt     ; el sector de arranque fsico
               MOV   CX,1              ; sector 1
               MOV   DH,80h            ; no sector de arranque lgico
               PUSHF
               CALL  ant_i13           ; grabar arranque fsico
               JC    ret_fmt_p         ; hubo problemas
               MOV   CX,bf_sectfat
               CMP   CL,8
               JAE   crea_SB           ; es disco de alta densidad
               CLC                     ; no haba error
               JMP   ret_fmt_p
crea_SB:       LEA   SI,_Boot2mCode    ; grabar SuperBOOT...
               ADD   CL,3              ; CL primer sector
               MOV   BX,5              ; nmero de sectores
graba_SB:      PUSH  BX                ; **1-2
               PUSH  CX                ; ***1-2
               LEA   DI,buffer_extra   ; ES:DI -> rea de 512 bytes
               MOV   CX,512
               CLD
               CALL  xms_movsb         ; traer sector de XMS/conv.
               JNZ   fallo_SB          ; fallo del controlador XMS
               POP   CX
               PUSH  CX
               LEA   BX,buffer_extra   ; ES:BX buffer
               MOV   AX,301h           ; escribir 1 sector
               MOV   DH,80h            ; sector fsico, no lgico
               PUSHF
               CALL  ant_i13           ; grabar sector SuperBOOT
               POP   CX                ; ***1
               INC   CL                ; siguiente sector
               POP   BX                ; **1
               DEC   BX
               JNZ   graba_SB          ; grabar resto de SuperBOOT
               JMP   ret_fmt_p
fallo_SB:      POP   CX                ; ***2
               POP   BX                ; **2
               STC                     ; fallo al grabar SuperBOOT
               MOV   AH,32             ; "fallo del controlador" :-)
ret_fmt_p:     XPOP  <DX, CX>          ; *
ret_fmt:       MOV   AL,0
               RET

; ------------ Ejecutar MOVSB si no hay XMS o simular MOVSB desde la
;              memoria XMS si la hay. Al offset en SI relativo a la
;              memoria XMS se le resta el offset de fin_resid_xms para
;              determinar el desplazamiento efectivo en la XMS.

xms_movsb      PROC
               CMP   xms_handle,0
               JNE   mov_xms
               REP   MOVSB
               CMP   AL,AL             ; ZF = 1 -> no hay error
               JMP   ret_xms_movsb
mov_xms:       XPUSH <AX, CX, SI, DS>
               INC   CX
               AND   CL,11111110b             ; n bytes par
               SUB   SI,OFFSET fin_resid_xms  ; direccin en XMS
               XOR   AX,AX
               PUSH  ES
               PUSH  DI                ; destino ES:DI
               PUSH  AX                ; destino memoria convencional
               PUSH  AX
               PUSH  SI                ; offset 0:SI en mem. ext.
               PUSH  xms_handle        ; handle destino XMS
               PUSH  AX                ; tamao bloque (parte alta)
               PUSH  CX                ; tamao bloque (parte baja)
               PUSH  SS
               POP   DS
               MOV   SI,SP             ; DS:SI apuntando a la pila
               MOV   AH,0Bh            ; funcin para mover EMB
               CALL  CS:xms_handler    ; ejecutar funcin XMS
               ADD   SP,16             ; equilibrar pila
               CMP   AL,1              ; fall el controlador?
               XPOP  <DS, SI, CX, AX>
               JNE   ret_xms_movsb     ; error (ZF = 0)
               ADD   SI,CX
               ADD   DI,CX
               XOR   CX,CX             ; ZF = 1
ret_xms_movsb: RET
xms_movsb      ENDP

               ; Tabla con las definiciones fsicas de formatos 2M.
               ; La primera lnea de todas las entradas significa:
               ;   1) Cdigos del formato
               ;   2) Flag de escritura tras formateo (1 si 2MF/M)
               ;   3) Velocidad de transferencia en pista 0
               ;   4) Velocidad de transferencia en restantes pistas
               ;   5) Sectores fsicos de 512 bytes en pista 0
               ;   6) GAP3 para formateo en pista 0
               ;   7) Primer nmero de sector en pista 0
               ;   8) Interleave en pista 0
               ; Los siguientes bytes (formato para pista!=0):
               ;   En el formato estndar (2MF /F):
               ;     1) Sectores fsicos de 1  2 Kbytes
               ;     2) GAP3 para formateo
               ;     3) Tamao sector
               ;     4) sector sliding al conmutar de cabezal (/X)
               ;     5) sector sliding al conmutar de cilindro (/Y)
               ;   En el formato de mxima capacidad (2MF /M):
               ;     1) N sectores 128 bytes para preformateo
               ;     2) GAP3 para formateo
               ;     3) Sectores fsicos efectivos
               ;     4) Sectores numerados (tantos como indique (3))
               ;     5) Tamaos de sector ordenados (dem)

f_820_525      LABEL BYTE
               DB    "05",0,1,1,9,80,1,1
               DB    5,100,3,1,1
f_902          LABEL BYTE
               DB    "01",1,1,1,9,80,1,1
               DB    32,4,5,3,1,4,2,0,4,2,4,3,0
f_1476         LABEL BYTE
               DB    "06",0,0,0,16,60,1,1
               DB    9,50,3,1,2
f_1558         LABEL BYTE
               DB    "02",1,0,0,17,25,1,2
               DB    53,3,6,4,1,5,2,6,3,4,4,2,4,4,3
f_820_350      LABEL BYTE
               DB    "07",0,2,2,9,80,1,1
               DB    5,100,3,1,1
f_984          LABEL BYTE
               DB    "07",0,2,1,9,80,1,1
               DB    6,100,3,1,1
f_1066         LABEL BYTE
               DB    "03",1,2,1,9,80,1,1
               DB    38,5,6,3,1,4,2,0,0,4,2,4,4,0,0
f_1148         LABEL BYTE
               DB    "03",1,2,1,9,80,1,1
               DB    38,2,4,3,1,4,2,4,3,4,4
f_1804         LABEL BYTE
               DB    "08",0,0,0,19,70,1,1
               DB    11,40,3,1,2
f_1886         LABEL BYTE
               DB    "04",1,0,0,19,70,1,1
               DB    64,3,7,4,1,5,2,6,3,7,4,4,4,4,4,3,2
f_3608         LABEL BYTE
               DB    "10",0,3,3,36,108,1,1
               DB    11,126,4,1,2
f_3772         LABEL BYTE
               DB    "09",1,3,3,36,108,1,1
               DB    127,5,12,1,7,2,8,3,9,4,10,5,11,6,12
               DB    4,4,4,4,4,4,4,4,4,4,4,3

msg_final      DB    "Made in Spain", 0, 055h, 0AAh

fin_resid_xms  LABEL BYTE

; ****************************************************
; *   FIN DEL AREA RESIDENTE CON DATOS DE 2M EN XMS  *
; ****************************************************

               ; --- Cdigo 2M para grabar en los 5 sectores ocultos
               ;     de los disquetes de alta densidad al formatear.

_Boot2mCode:   INCLUDE 2MFBOOT.DB
_Boot2mLong    EQU   $-OFFSET _Boot2mCode

               ; --- Sectores de arranque de los disquetes 2M.

_BootHDPrg:    INCLUDE 2MBOOTHD.INC
_BootHDPrgLong EQU   $-OFFSET _BootHDPrg

_BootDDPrg:    INCLUDE 2MBOOTDD.INC
_BootDDPrgLong EQU   $-OFFSET _BootDDPrg

fin_residente  EQU   $  ; fin del rea residente en el peor caso

; ********************************************************************
; *  FIN DEL AREA RESIDENTE CON DATOS DE 2M EN MEMORIA CONVENCIONAL  *
; ********************************************************************

bytes_resid_n2 EQU   fin_resid_no2m - ini_residente  ; sin 2M
bytes_resid_x  EQU   fin_resid_xms  - ini_residente  ; datos 2M en XMS
bytes_resid    EQU   fin_residente  - ini_residente  ; datos 2M no XMS


; *****************************
; *                           *
; *   I N S T A L A C I O N   *
; *                           *
; *****************************

main           PROC
               LEA   BP,parametros
               MOV   BX,81h
               CALL  obtener_param     ; analizar posibles parmetros
               JNC   params_ok         ; son correctos
               OR    error,ERRSINTAX
               JMP   informar
params_ok:     CALL  inic_general      ; inicializar ciertas variables
               TEST  error,MALBIOS
               JZ    bios_ok
               JMP   informar
bios_ok:       CALL  set_i40
               CMP   param_u,ON        ; se solicita desinstalarlo?
               JNE   cont_ins          ; no
               CALL  residente?        ; s: est residente?
               JNC   desinstalable
               OR    error,NOINSTALADO ; programa an no instalado
               JMP   informar
desinstalable: CALL  testWin
               JNC   win_out_ok
               OR    error,WIN_UNLOAD
               JMP   informar          ; no desinstalar desde Windows
win_out_ok:    OR    accion,DESINSTALADO
               MOV   ES,tsr_seg
               MOV   DI,tsr_off
               MOV   AH,ES:[DI-9]
               CALL  mx_unload         ; desinstalarlo:
               JC    fallo_desins
               MOV   DX,ES:xms_handle
               AND   DX,DX
               JZ    xms_free          ; no usaba XMS
               CMP   xms_ins,ON
               JNE   xms_free          ; que raro...
               MOV   AH,0Ah
               CALL  gestor_XMS        ; liberar XMS
xms_free:      CALL  set_i1e           ; precauciones tabla base disco
               LEA   DI,ptr_info_dos   ; restaurar unidades DOS
               JMP   settipo
fallo_desins:  OR    error,IMPDESINS   ; no es posible desinstalar
               JMP   informar
cont_ins:      CALL  residente?
               JNC   ya_reside
               CMP   AX,0              ; reside una versin distinta?
               JE    instalable
               OR    error,NOINSTALABLE  ; versin incompatible
               JMP   informar
ya_reside:     OR    accion,YAINSTALADO
               CMP   param_noxms,ON    ; /NOXMS slo admitido 1 vez
               JNE   setpr
err_1a_vez:    OR    error,PRIMERAVEZ
               JMP   setpr
instalable:    CALL  testWin
               JNC   win_in_ok
               OR    error,WIN_LOAD
               JMP   informar          ; no instalar desde Windows
win_in_ok:     OR    accion,INSTALADO
               MOV   AL,OFF
               CMP   param_dis,AL
               JE    ins_asi           ; instalar como /NODISKCOPY
               CALL  hay2m?
               JC    ins_asi           ; si no hay 2M, /NODISKCOPY
               MOV   AL,ON             ; si hay 2M, /DISKCOPY
ins_asi:       MOV   param_dis,AL
               MOV   sopdcopy,AL
               MOV   sop2m,AL
               CALL  instalar_tsr      ; instalar el TSR
               JC    informar
setpr:         CALL  adaptar_param     ; parmetros en copia residente
               MOV   ES,tsr_seg
               LEA   DI,ptr_info_dos   ; unidades de tipo normal
               CMP   ES:sopdcopy,OFF
               JE    settipo           ; sin soporte DISKCOPY
               CMP   ES:fmt,OFF
               JE    settipo           ; sin apoyo a FORMAT
               LEA   DI,ptr_info_2m    ; unidades de tipo 2M
settipo:       CALL  set_dev_params
informar:      CMP   param_u,ON
               JE    inf_ex
               CMP   param_dis,ON
               JNE   inf_ex
               CMP   ES:sopdcopy,ON
               JE    inf_ex
               OR    error,DISKCOPYNO  ; no ha funcionado /DISKCOPY
inf_ex:        CALL  info
               MOV   DX,mem640         ; tamao zona residente
               AND   DX,DX
               JZ    fin_noresid
               MOV   AX,3100h
               INT   21h               ; terminar residente
fin_noresid:   MOV   AX,4C00h
               INT   21h               ; terminar no residente
main           ENDP

instalar_tsr   PROC
               CALL  mx_get_handle     ; obtener entrada Multiplex
               JNC   handle_ok
               OR    error,MX64FULL    ; no quedan entradas
               STC
               RET
handle_ok:     MOV   multiplex_id,AH   ; entrada multiplex
               CMP   sopdcopy,ON
               JE    pide_xms
               MOV   AX,(bytes_resid_n2+15)/16
               MOV   parrafos_resid,AX ; sin soporte DISKCOPY
               JMP   instalar
pide_xms:      CALL  usar_XMS          ; si la hay, guai
instalar:      CALL  preservar_ints    ; tomar nota de vectores
               CMP   param_ml,ON       ; se indic parmetro /ML?
               JE    instalar_ml       ; en efecto
               MOV   AX,parrafos_resid ; rea residente sin PSP
               CALL  UMB_alloc         ; pedir memoria superior XMS
               JNC   instalar_umb      ; hay la suficiente
               MOV   AX,parrafos_resid
               CALL  UPPER_alloc       ; pedir memoria superior DOS 5
               JC    instalar_ml       ; no hay la suficiente
               MOV   ES,AX
               CALL  upper_fork        ; dejar residente el bloque
               STC                     ; indicar que usa memoria DOS
instalar_umb:  MOV   ES,AX             ; segmento del bloque UMB
               MOV   DI,0              ; ES:0 zona a donde reubicar
               MOV   mem640,DI         ; no terminar residente
               JMP   instalar_asi
instalar_ml:   ADD   parrafos_resid,6  ; respetar 96 bytes de PSP
               MOV   AX,parrafos_resid
               MOV   mem640,AX         ; ocupar memoria convencional
               STC
               MOV   DI,96             ; instalacin mem. convencional
               CALL  free_environ      ; liberar espacio de entorno
               STC                     ; no se usa XMS
instalar_asi:  CALL  inicializa_id     ; inicializar identificacin
               MOV   CX,parrafos_resid
               CALL  reubicar_prog     ; reubicar programa a ES:DI
               CALL  activar_ints      ; interceptar vectores
               CLC
               RET
instalar_tsr   ENDP


;*********************************************************
;*                                                       *
;*  SUBRUTINAS DE PROPOSITO GENERAL PARA LA INSTALACION  *
;*                                                       *
;*********************************************************

               INCLUDE 2MUTIL.INC

; ------------ Ya est instalada otra versin distinta del programa.

error_version  PROC
               PUSH  ES
               LEA   DX,mal_ver_txt1
               CALL  print
               LES   DI,tsr_dir
               MOV   AL,':'
               MOV   CL,255
               CLD
               REPNE SCASB
               REPNE SCASB
               MOV   DL,ES:[DI]        ; nmero de versin
               MOV   AH,2
               INT   21h
               MOV   DL,'.'
               MOV   AH,2
               INT   21h
               MOV   DL,ES:[DI+2]      ; revisin
               MOV   AH,2
               INT   21h
               LEA   DX,mal_ver_txt2
               CALL  print
               POP   ES
               RET
error_version  ENDP

; ------------ Inicializar ciertas variables.

inic_general   PROC
               CALL  inic_XMS          ; detectar controlador XMS
               MOV   AX,(bytes_resid+15)/16
               MOV   parrafos_resid,AX ; memoria mxima necesaria
               MOV   DL,0
               CALL  tipo_disco
               JNC   hay_unidad
               MOV   DL,1
               CALL  tipo_disco
               JNC   hay_unidad
               OR    error,MALBIOS     ; no hay disqueteras
               RET
hay_unidad:    RET
inic_general   ENDP

; ------------ Poner 3,1 Kb de datos en XMS si la hay.

usar_XMS       PROC
               CMP   param_noxms,ON
               JE    ret_usx           ; parmetro /NOXMS
               CMP   xms_ins,ON
               JNE   ret_usx           ; no hay controlador XMS
               MOV   AX,XMS_off
               MOV   xms_hndl_off,AX   ; anotar direccin controlador
               MOV   AX,XMS_seg
               MOV   xms_hndl_seg,AX
               MOV   AH,9              ; pedir memoria extendida
               MOV   DX,4              ; 4 kbytes
               CALL  gestor_XMS
               CMP   AX,1
               JNE   ret_usx
               MOV   xms_handle,DX
               MOV   AX,(bytes_resid_x+15)/16
               MOV   parrafos_resid,AX ; memoria mnima necesaria
               XOR   AX,AX
               PUSH  AX
               PUSH  AX                ; desplazamiento 0:0
               PUSH  DX                ; handle destino mem. extendida
               LEA   BX,fin_resid_xms
               PUSH  CS
               PUSH  BX                ; segmento:offset
               PUSH  AX                ; handle fuente memoria conv.
               PUSH  AX                ; tamao bloque (parte alta)
               MOV   AX,4096
               PUSH  AX                ; tamao bloque (parte baja)
               MOV   SI,SP             ; DS:SI apuntando a la pila
               MOV   AH,0Bh            ; funcin para mover EMB
               CALL  gestor_XMS        ; ejecutar funcin XMS
               ADD   SP,16             ; equilibrar pila
               CMP   AL,1              ; fall el controlador?
               JE    ret_usx
               MOV   xms_handle,0      ; fall, no usada XMS
               MOV   AX,(bytes_resid+15)/16
               MOV   parrafos_resid,AX ; memoria total necesaria
ret_usx:       RET
usar_XMS       ENDP

; ------------ Inicializar rea program_id del programa residente.
;              A la entrada, ES:DI = seg:off a donde ser reubicado
;              y CF=0 si se utiliza memoria superior XMS.

inicializa_id  PROC
               PUSHF
               MOV   segmento_real,ES  ; anotar segmento del bloque
               MOV   offset_real,DI    ; dem con el offset
               MOV   AX,parrafos_resid
               MOV   longitud_total,AX
               MOV   AL,1
               POPF                    ; CF=0: usar memoria UMB XMS
               JNC   info_ok
               DEC   AL                ; usar memoria convencional
info_ok:       OR    info_extra,AL
               RET
inicializa_id  ENDP

; ------------ Devolver CF=0 si 2M o 2MX estn instalados.

hay2m?         PROC
               PUSH  AX
               PUSH  ES
               LEA   SI,id_2m          ; identificacin del programa
               MOV   CX,id_2m_tam
               MOV   AX,1492h
               MOV   ES,AX
               MOV   DI,1992h          ; ES:DI protocolo de bsqueda
               CALL  mx_find_tsr       ; buscar si est en memoria
               JNC   hay2m?_ret
               LEA   SI,id_2mx         ; identificacin del programa
               MOV   CX,id_2mx_tam
               CALL  mx_find_tsr
               JNC   hay2m?_ret
               STC
hay2m?_ret:    POP   ES
               POP   AX
               RET
hay2m?         ENDP

; ------------ Adaptar parmetros del programa ya instalado.

adaptar_param  PROC
               PUSH  ES
               MOV   ES,tsr_seg
               CMP   param_dis,-1
               JE    hay_fdr?
               MOV   AL,param_dis
               CMP   AL,OFF
               JE    sopdcopy_ok       ; siempre vlido /NODISKCOPY
               CMP   ES:sop2m,ON
               JNE   hay_fdr?          ; /DISKCOPY vlido si hay soporte
sopdcopy_ok:   MOV   ES:sopdcopy,AL
hay_fdr?:      CMP   param_fdr,-1
               JE    hay_opt?
               MOV   AL,param_fdr
               MOV   ES:fdread,AL
hay_opt?:      CMP   param_opt,-1
               JE    hay_boo?
               MOV   AL,param_opt
               MOV   ES:opt,AL
hay_boo?:      CMP   param_boo,-1
               JE    hay_fmt?
               MOV   AL,param_boo
               MOV   ES:boost,AL
hay_fmt?:      CMP   param_fmt,-1
               JE    adap_xh?
               MOV   AL,param_fmt
               MOV   ES:fmt,AL
adap_xh?:      CMP   param_xh,OFF
               JE    adap_yh?
               MOV   AX,x_hd
               MOV   ES:x_hd,AX
adap_yh?:      CMP   param_yh,OFF
               JE    adap_xd?
               MOV   AX,y_hd
               MOV   ES:y_hd,AX
adap_xd?:      CMP   param_xd,OFF
               JE    adap_yd?
               MOV   AX,x_dd
               MOV   ES:x_dd,AX
adap_yd?:      CMP   param_yd,OFF
               JE    adap_g?
               MOV   AX,y_dd
               MOV   ES:y_dd,AX
adap_g?:       CMP   param_g,OFF
               JE    fin_adap
               MOV   AX,mingap
               MOV   ES:mingap,AX
fin_adap:      POP   ES
               RET
adaptar_param  ENDP

; ------------ Informar al usuario.

info           PROC
               CMP   param_ayuda,ON    ; solicitud de ayuda?
               JNE   info_normal?
               LEA   DX,ayuda_txt
               CALL  print
               JMP   fin_info
info_normal?:  CMP   param_xayuda,ON   ; solicitud de ms ayuda?
               JNE   info_normal
               LEA   DX,mas_ayuda_txt
               CALL  print
               JC    salir_hlp
               JMP   fin_info
salir_hlp:     LEA   DX,limpia_txt     ; se puls ESC en la ayuda
               CALL  print
               JMP   fin_info
info_normal:   LEA   DX,programa_txt
               CALL  print
               TEST  error,0FFFFh
               JZ    info_ins          ; no hay error
               JMP   info_err          ; lo hay: informar del mismo
info_ins:      LEA   DX,instalado_txt
               TEST  accion,INSTALADO  ; informar "instalado"?
               JZ    info_modo
               CALL  print
               CALL  advertir
               JMP   fin_info
info_modo:     LEA   DX,ya_instal_txt
               TEST  accion,YAINSTALADO  ; informar "ya instalado"?
               JNZ   acc_ok
               LEA   DX,des_ok_txt     ; informar "desinstalado"
               CALL  print
               JMP   fin_info
acc_ok:        CALL  print             ; instalado/ya instalado...
               PUSH  ES
               MOV   ES,tsr_seg
               LEA   DX,modo_boo_txt
               CALL  print
               LEA   DX,activo_txt
               CMP   ES:boost,ON
               JE    boo_onoff_ok
               LEA   DX,inactivo_txt
boo_onoff_ok:  CALL  print
               LEA   DX,modo_opt_txt
               CALL  print
               LEA   DX,activo_txt
               CMP   ES:opt,ON
               JE    opt_onoff_ok
               LEA   DX,inactivo_txt
opt_onoff_ok:  CALL  print
               LEA   DX,modo_fdr_txt
               CALL  print
               LEA   DX,activo_txt
               CMP   ES:fdread,ON
               JE    fdr_onoff_ok
               LEA   DX,inactivo_txt
fdr_onoff_ok:  CALL  print
               LEA   DX,sopdc_txt      ; soporte DISKCOPY
               CMP   ES:sopdcopy,ON
               JE    modo_sop_ok
               LEA   DX,nosopdc_txt    ; no hay soporte DISKCOPY
modo_sop_ok:   CALL  print
               CMP   ES:sop2m,OFF
               JE    modo_fmt?         ; no hay datos para DISKCOPY
               LEA   DX,no_xms_txt
               CMP   ES:xms_handle,0
               JE    modo_xms_ok
               LEA   DX,xms_txt
modo_xms_ok:   CALL  print
modo_fmt?:     CMP   ES:fmt,OFF
               JE    modos_fin
               CMP   ES:sopdcopy,OFF
               JE    modos_fin
               LEA   DX,sop_fmt_txt    ; soporte extra para FORMAT
               CALL  print
modos_fin:     POP   ES
               CALL  advertir
               JMP   fin_info
info_err:      LEA   DX,err_sintax_txt
               TEST  error,ERRSINTAX   ; error de sintaxis?
               JZ    otroerr1
               CALL  print
otroerr1:      LEA   DX,mal_bios_txt
               TEST  error,MALBIOS     ; imposible detectar
               JZ    otroerr2          ; tipo unidades?
               CALL  print
otroerr2:      LEA   DX,imp_desins_txt
               TEST  error,NOINSTALADO ; no instalado, piden
               JZ    otroerr4          ; desinstalar?
               CALL  print
otroerr4:      LEA   DX,des_no_ok_txt
               TEST  error,IMPDESINS   ; imposible desinstalar?
               JZ    otroerr5
               CALL  print
otroerr5:      TEST  error,NOINSTALABLE  ; versin incorrecta?
               JZ    otroerr6
               CALL  error_version
otroerr6:      LEA   DX,nocabe_txt
               TEST  error,MX64FULL    ; imposible instalar?
               JZ    otroerr8
               CALL  print
otroerr8:      LEA   DX,win_ld_txt
               TEST  error,WIN_LOAD    ; instalar desde Windows?
               JZ    otroerr9
               CALL  print
otroerr9:      LEA   DX,win_ul_txt
               TEST  error,WIN_UNLOAD  ; desinstalar desde Windows?
               JZ    otroerr10
               CALL  print
otroerr10:     LEA   DX,pmt_ins_txt
               TEST  error,PRIMERAVEZ  ; parmetros no permitidos?
               JZ    otroerr11
               CALL  print
otroerr11:     LEA   DX,pmt_ndc_txt
               TEST  error,DISKCOPYNO  ; /DISKCOPY imposible?
               JZ    fin_info
               CALL  print
fin_info:      RET

advertir:      MOV   AL,param_xh
               ADD   AL,param_yh
               ADD   AL,param_xd
               ADD   AL,param_yd
               ADD   AL,param_g
               CMP   AL,OFF
               JE    fin_adv
               LEA   DX,aviso_txt
               CALL  print
fin_adv:       RET

info           ENDP

; ------------ Utilizar preferentemente INT 40h en lugar de INT 13h.
;              para saber si INT 13h en este ordenador acaba llamando
;              a la INT 40h, se desva la INT 40h y se provoca un
;              inocuo reset de disquetes va INT 13h para comprobar si
;              pasa por INT 40h.

set_i40        PROC
               CALL  test_i40
               TEST  accion,I40
               JZ    set_i40_ret       ; no soportada la INT 40h
               MOV   i13_40_0,40h
               MOV   i13_40_1,40h      ; usar INT 40 en vez de INT 13
set_i40_ret:   RET
set_i40        ENDP

               ; --- Comprobar si la INT 40h est en uso

test_i40:      XPUSH <DS, ES>          ; *
               MOV   AX,3540h
               INT   21h
               XPUSH <ES, BX>          ; vector de INT 40h original
               LEA   DX,i40_aux
               MOV   AX,2540h
               INT   21h               ; establecer nueva INT 40h
               XOR   AX,AX
               MOV   DL,0
               INT   13h               ; reset de disco
               XPOP  <DX, DS>
               MOV   AX,2540h
               INT   21h               ; restaurar INT 40h original
               XPOP  <ES, DS>          ; *
               RET

i40_aux        PROC
               OR    CS:accion,I40     ; s utilizada INT 40h
               IRET                    ; desde la INT 13h
i40_aux        ENDP

; ------------ Desde Windows, no se permite instalar o desinstalar.

testWin        PROC
               PUSH  AX
               CMP   param_w,ON        ; se indic parmetro /W?
               JE    fin_testWin
               MOV   AX,1600h
               INT   2Fh
               AND   AL,AL             ; Windows en modo extendido?
               JZ    noWinEnh
               CMP   AL,80h            ; Windows en modo extendido?
               JE    noWinEnh
siWin:         STC                     ; estamos dentro de Windows
               JMP   fin_testWin
noWinEnh:      MOV   AX,4680h
               INT   2Fh
               AND   AX,AX
               JZ    siWin             ; Windows en modo real/estndar
fin_testWin:   POP   AX
               RET                     ; CF=1 si dentro de Windows
testWin        ENDP

; ------------ Al desinstalar, asegurar que el mayor nmero de sector
;              en la tabla base de disco es suficiente; por si estaba
;              activa la emulacin FDREAD y esto es DR-DOS.

set_i1e        PROC
               PUSH  ES
               MOV   AX,351Eh
               INT   21h
               CMP   BYTE PTR ES:[BX+4],63
               JAE   i1e_ok
               MOV   BYTE PTR ES:[BX+4],63
i1e_ok:        POP   ES
               RET
set_i1e        ENDP


; ***********************************************
; *                                             *
; *   D A T O S    N O    R E S I D E N T E S   *
; *                                             *
; ***********************************************

; ------------ Control de instalacin.

offsets_ints   DW    2         ; nmero de vectores interceptados
i13_40_1       DB    13h       ; tabla de offsets de los vectores
               DW    nueva_i13 ; de interrupcin interceptados
               DB    2Fh
               DW    nueva_i2F

; ------------ Parmetros soportados

param_ml       DB    OFF       ; a ON si se indic parmetro /ML
param_u        DB    OFF       ; a ON si se indic parmetro /U
param_w        DB    OFF       ; a ON si se indic parmetro /W
param_xh       DB    OFF       ; a ON si se indic parmetro /XH
param_xd       DB    OFF       ; a ON si se indic parmetro /XD
param_yh       DB    OFF       ; a ON si se indic parmetro /YH
param_yd       DB    OFF       ; a ON si se indic parmetro /YD
param_g        DB    OFF       ; a ON si se indic parmetro /G
param_ayuda    DB    OFF       ; a ON si se indic /? /H  ?
param_xayuda   DB    OFF       ; a ON si se indic /??
param_opt      DB    -1        ; a ON u OFF segn /OPT o /NOOPT
param_boo      DB    -1        ; a ON u OFF segn /BOOST o /NOBOOST
param_fdr      DB    -1        ; a ON u OFF segn /FDREAD o /NOFDREAD
param_fmt      DB    -1        ; a ON u OFF segn /FORMAT o /NOFORMAT
param_dis      DB    -1        ; a ON u OFF segn /DISKCOPY o /NODISKCOPY
param_noxms    DB    OFF       ; a ON si se indic /NOXMS

parametros     LABEL BYTE

               DB    "/??",0
               DW    param_xayuda
               DB    ON

               DB    "?",0
               DW    param_ayuda
               DB    ON

               DB    "/?",0
               DW    param_ayuda
               DB    ON

               DB    "/H",0
               DW    param_ayuda
               DB    ON

               DB    "/U",0
               DW    param_u
               DB    ON

               DB    "/W",0
               DW    param_w
               DB    ON

               DB    "/ML",0
               DW    param_ml
               DB    ON

               DB    "/G",1
               DW    0,255
               DW    mingap
               DW    param_g
               DB    ON

               DB    "/XH",1
               DW    0,255
               DW    x_hd
               DW    param_xh
               DB    ON

               DB    "/YH",1
               DW    0,255
               DW    y_hd
               DW    param_yh
               DB    ON

               DB    "/XD",1
               DW    0,255
               DW    x_dd
               DW    param_xd
               DB    ON

               DB    "/YD",1
               DW    0,255
               DW    y_dd
               DW    param_yd
               DB    ON

               DB    "/I",0
               DW    param_i
               DB    ON

               DB    "/OPt",0
               DW    param_opt
               DB    ON

               DB    "/NOOPt",0
               DW    param_opt
               DB    OFF

               DB    "/BOost",0
               DW    param_boo
               DB    ON

               DB    "/NOBOost",0
               DW    param_boo
               DB    OFF

               DB    "/FDread",0
               DW    param_fdr
               DB    ON

               DB    "/NOFDread",0
               DW    param_fdr
               DB    OFF

               DB    "/FOrmat",0
               DW    param_fmt
               DB    ON

               DB    "/NOFOrmat",0
               DW    param_fmt
               DB    OFF

               DB    "/DIskcopy",0
               DW    param_dis
               DB    ON

               DB    "/NODIskcopy",0
               DW    param_dis
               DB    OFF

               DB    "/NOXMs",0
               DW    param_noxms
               DB    ON

               DB    0                 ; fin de la tabla

; ------------ Otras variables.

id_2m          DB    "CiriSOFT:2M:"    ; marcas de presencia de 2M
id_2m_tam      EQU   $-OFFSET id_2m
id_2mx         DB    "CiriSOFT:2MX:"
id_2mx_tam     EQU   $-OFFSET id_2mx

ERRSINTAX      EQU   1
MALBIOS        EQU   2
NOINSTALADO    EQU   4
IMPDESINS      EQU   8
NOINSTALABLE   EQU  16
MX64FULL       EQU  32
WIN_LOAD       EQU  64
WIN_UNLOAD     EQU 128
PRIMERAVEZ     EQU 256
DISKCOPYNO     EQU 512

INSTALADO      EQU   1         ; cdigos de accin e informacin
YAINSTALADO    EQU   2
DESINSTALADO   EQU   4
I40            EQU   8

error          DW    0         ; variable para acumular errores
accion         DB    0         ; variable que indica lo sucedido

; ------------ Otras variables.

ptr_info_2m    DW    0, 0, i1558, 0, i1886, i3772, i3772
ptr_info_dos   DW    0, 0, i1200, 0, i1440, i2880, i2880

i1558          DB    4, 1              ; sectores iguales / tipo 1.2M
               DW    2, 82             ; detecta cambio / n pistas
               DB    0                 ; tipo de soporte
               DW    512               ; BPB: bytes por sector
               DB    1                 ; BPB: sectores por cluster
               DW    1                 ; BPB: sectores reservados
               DB    2                 ; BPB: nmero de FATs
               DW    224               ; BPB: entradas en el raz
               DW    3116              ; BPB: n total de sectores
               DB    0FAh              ; BPB: descriptor de medio
               DW    10                ; BPB: sectores por FAT
               DW    19, 2             ; BPB: sectores pista / cabezas
               DB    14 DUP (0)        ; BPB: restantes campos
i1886          DB    4, 7              ; sectores iguales / tipo 1.44M
               DW    2, 82             ; detecta cambio / n pistas
               DB    0                 ; tipo de soporte
               DW    512               ; BPB: bytes por sector
               DB    1                 ; BPB: sectores por cluster
               DW    1                 ; BPB: sectores reservados
               DB    2                 ; BPB: nmero de FATs
               DW    224               ; BPB: entradas en el raz
               DW    3772              ; BPB: n total de sectores
               DB    0FAh              ; BPB: descriptor de medio
               DW    11                ; BPB: sectores por FAT
               DW    23, 2             ; BPB: sectores pista / cabezas
               DB    14 DUP (0)        ; BPB: restantes campos
i3772          DB    4, 9              ; sectores iguales / tipo 2.88M
               DW    2, 82             ; detecta cambio / n pistas
               DB    0                 ; tipo de soporte
               DW    512               ; BPB: bytes por sector
               DB    2                 ; BPB: sectores por cluster
               DW    1                 ; BPB: sectores reservados
               DB    2                 ; BPB: nmero de FATs
               DW    224               ; BPB: entradas en el raz
               DW    7544              ; BPB: n total de sectores
               DB    0FAh              ; BPB: descriptor de medio
               DW    12                ; BPB: sectores por FAT
               DW    46, 2             ; BPB: sectores pista / cabezas
               DB    14 DUP (0)        ; BPB: restantes campos
i1200          DB    4, 1              ; sectores iguales / tipo 1.2M
               DW    2, 80             ; detecta cambio / n pistas
               DB    0                 ; tipo de soporte
               DW    512               ; BPB: bytes por sector
               DB    1                 ; BPB: sectores por cluster
               DW    1                 ; BPB: sectores reservados
               DB    2                 ; BPB: nmero de FATs
               DW    224               ; BPB: entradas en el raz
               DW    2400              ; BPB: n total de sectores
               DB    0F9h              ; BPB: descriptor de medio
               DW    7                 ; BPB: sectores por FAT
               DW    15, 2             ; BPB: sectores pista / cabezas
               DB    14 DUP (0)        ; BPB: restantes campos
i1440          DB    4, 7              ; sectores iguales / tipo 1.44M
               DW    2, 80             ; detecta cambio / n pistas
               DB    0                 ; tipo de soporte
               DW    512               ; BPB: bytes por sector
               DB    1                 ; BPB: sectores por cluster
               DW    1                 ; BPB: sectores reservados
               DB    2                 ; BPB: nmero de FATs
               DW    224               ; BPB: entradas en el raz
               DW    2880              ; BPB: n total de sectores
               DB    0F0h              ; BPB: descriptor de medio
               DW    9                 ; BPB: sectores por FAT
               DW    18, 2             ; BPB: sectores pista / cabezas
               DB    14 DUP (0)        ; BPB: restantes campos
i2880          DB    4, 9              ; sectores iguales / tipo 2.88M
               DW    2, 80             ; detecta cambio / n pistas
               DB    0                 ; tipo de soporte
               DW    512               ; BPB: bytes por sector
               DB    2                 ; BPB: sectores por cluster
               DW    1                 ; BPB: sectores reservados
               DB    2                 ; BPB: nmero de FATs
               DW    224               ; BPB: entradas en el raz
               DW    5760              ; BPB: n total de sectores
               DB    0F0h              ; BPB: descriptor de medio
               DW    9                 ; BPB: sectores por FAT
               DW    36, 2             ; BPB: sectores pista / cabezas
               DB    14 DUP (0)        ; BPB: restantes campos

; ------------ Texto.

programa_txt   DB    13,10,"  2MDOS 1.0",0

instalado_txt  DB    " instalado.",13,10,255," installed.",13,10,0

ya_instal_txt  DB    " ya instalado.",13,10,255
               DB    " already installed.",13,10,0

modo_boo_txt   DB    "    Optimizacin de formateo DiskBoost ",255
               DB    "    DiskBoost format optimization ",0

modo_opt_txt   DB    "    Optimizacin de formateo sector sliding ",255
               DB    "    Sector sliding format optimization ",0

modo_fdr_txt   DB    "    Emulacin FDREAD ",255
               DB    "    FDREAD emulation ",0

activo_txt     DB    "activa.",13,10,255,"enabled.",13,10,0

inactivo_txt   DB    "inhibida.",13,10,255,"disabled.",13,10,0

sopdc_txt      DB    "    Formateo de discos destino 2M/FDFORMAT soportado por DISKCOPY.",13,10,255
               DB    "    2M/FDFORMAT target diskettes format supported by DISKCOPY.",13,10,0

nosopdc_txt    DB    "    Sin soporte de formateo para DISKCOPY de discos 2M/FDFORMAT.",13,10,255
               DB    "    No format support for DISKCOPY of 2M/FDFORMAT disks.",13,10,0

xms_txt        DB    "    Datos residentes para DISKCOPY en memoria extendida.",13,10,255
               DB    "    Resident DISKCOPY data placed in extended memory.",13,10,0

no_xms_txt     DB    "    Datos residentes para DISKCOPY en memoria convencional.",13,10,255
               DB    "    Resident DISKCOPY data placed in conventional memory.",13,10,0

sop_fmt_txt    DB    "    Soporte extra para FORMAT de MS-DOS habilitado.",13,10,255
               DB    "    Additional support for MS-DOS FORMAT enabled.",13,10,0

aviso_txt      DB    "    Aviso: sector sliding o GAP modificado con opciones no documentadas.",13,10,255
               DB    "    Warning: sector sliding or GAP modified with undocumented switches.",13,10,0

pmt_ins_txt    DB    13,10,"    El parmetro /NOXMS slo se admite al instalar.",13,10,255
               DB    13,10,"    /NOXMS switch is only valid at installation.",13,10,0

pmt_ndc_txt    DB    13,10,"    No se puede activar ya el soporte de formateo para DISKCOPY si"
               DB    13,10,"    no se activ en el momento de la instalacin de este programa.",13,10,255
               DB    13,10,"    It is not possible to enable now DISKCOPY format support if"
               DB    13,10,"    it wasn't actived when 2MDOS becomes resident in memory.",13,10,0

nocabe_txt     DB    ": Instalacin imposible.",13,10
               DB    "      Ya hay 64 programas residentes con la "
               DB    "misma tcnica.",13,10,255
               DB    ": Unable to install.",13,10
               DB    "      There are already 64 TSR's with the same technique."
               DB    13,10,0

err_sintax_txt DB    13,10,"    - Parmetro(s) incorrecto(s)."
               DB    13,10,"      Ejecute 2MDOS /? para obtener "
               DB    "ayuda.",13,10,7,255
               DB    13,10,"    - Incorrect option(s)."
               DB    13,10,"      Execute 2MDOS /? to obtain help."
               DB    13,10,7,0

mal_bios_txt   DB    13,10,"    - Error: No puedo detectar el tipo de las unidades."
               DB    13,10,"             Instale 2M-ABIOS  2M-XBIOS antes de este programa.",13,10,255
               DB    13,10,"    - Error: Impossible to detect diskette drive types."
               DB    13,10,"             Please install 2M-ABIOS or 2M-XBIOS before this program.",13,10,0

win_ld_txt     DB    " *NO* instalado:",13,10,"    Este programa debe cargarse ANTES de entrar en Windows.",13,10,7,255
               DB    " *NOT* installed:",13,10,"    This program must be loaded before WINDOWS.",13,10,7,0
win_ul_txt     DB    " *NO* desinstalado:",13,10,"    Este programa debe descargarse fuera de Windows.",13,10,7,255
               DB    " *NOT* uninstalled:",13,10,"    This program must be uninstalled outside of WINDOWS.",13,10,7,0

mal_ver_txt1   DB    13,10,"    - Error: ya est instalada la versin ",255
               DB    13,10,"    - Error: Version ",0
mal_ver_txt2   DB    " de este programa.",13,10,7,255
               DB    " of this program is already installed.",13,10,7,0

des_ok_txt     DB    " desinstalado.",13,10,255," uninstalled.",13,10,0

des_no_ok_txt  DB    13,10,"    - Desinstalacin imposible (se ha "
               DB    "instalado despus un programa"
               DB    13,10,"      que no respeta el convenio y tiene "
               DB    "alguna interrupcin comn).",13,10,7,255
               DB    13,10,"    - Uninstall unavailable (it has been"
               DB    " installed before a program that"
               DB    13,10,"      does not support CiriSOFT convention"
               DB    " and uses a common interrupt).",13,10,7,0

imp_desins_txt DB    13,10,"    - Programa an no instalado: "
               DB    "imposible desinstalarlo.",13,10,255
               DB    13,10,"    - Program not installed: "
               DB    "impossible to uninstall.",13,10,0

limpia_txt     DB    13,"                                                                              ",13,0


ayuda_txt      LABEL BYTE
DB 13,10
DB 13,10,"          2MDOS 1.0 - MODULO DE OPTIMIZACION DEL SUBSISTEMA DE DISCO"
DB 13,10,"   (C) 1994-1995 Ciriaco Garca de Celis - Grupo Universitario de Informtica"
DB 13,10,"   C/Renedo, 2, 4-C; 47005 Valladolid (Espaa) - ciri@gui.uva.es - 2:341/21.8"
DB 10
DB 13,10,"       2MDOS [/FDread|NOFDread] [/DIskcopy|NODIskcopy] [/FOrmat|NOFOrmat]"
DB 13,10,"             [/OPt|NOOPt] [/BOost|NOBOost] [/NOXMs] [/ML] [/U]"
DB 10
DB 13,10,"  Este controlador adicional crea una capa entre 2M y la BIOS para que el DOS"
DB 13,10," pueda trabajar normalmente con estos disquetes. No es preciso tener instalado"
DB 13,10," este controlador para soportar los disquetes 2M o para usar 2MF; sin embargo,"
DB 13,10," con l DISKCOPY puede copiar discos 2M formateando el disco destino. La mayor"
DB 13,10," utilidad de 2MDOS (con o sin 2M instalado)  consiste en optimizar el formateo"
DB 13,10," de discos estndar del sistema, con las poderosas tcnicas sector sliding y"
DB 13,10," DiskBoost. As, FORMAT (y la mayora de programas formateadores) crean discos"
DB 13,10," totalmente estndar mucho ms rpidos (sin que haya que instalar despus este"
DB 13,10," programa para poder emplearlos)."
DB 10
DB 13,10,"  Adems 2MDOS da soporte por defecto a disquetes no estndar, creados por la"
DB 13,10," utilidad FDFORMAT y permite a FORMAT poder crear disquetes FDFORMAT."
DB 10
DB 13,10,"  Este programa consume 5,7Kb en equipos sin memoria extendida (o con /NOXMS)"
DB 13,10," con ella ocupa 2,6 Kb (slo 1,8 Kb con /NODISKCOPY  sin 2M instalado).  Para"
DB 13,10," obtener ms informacin sobre los parmetros ejecute 2MDOS /??"
DB 13,10,255

DB 13,10,"               2MDOS 1.0 - DISK SUBSYSTEM OPTIMIZATION UTILITY"
DB 13,10,"  (C) 1994-1995 Ciriaco Garca de Celis - Grupo Universitario de Informtica."
DB 13,10,"   C/Renedo, 2, 4-C; 47005 Valladolid (Spain) - ciri@gui.uva.es - 2:341/21.8"
DB 10
DB 13,10,"       2MDOS [/FDread|NOFDread] [/DIskcopy|NODIskcopy] [/FOrmat|NOFOrmat]"
DB 13,10,"             [/OPt|NOOPt] [/BOost|NOBOost] [/NOXMs] [/ML] [/U]"
DB 10
DB 13,10,"  This aditional driver improves the interface between 2M and BIOS,  to  make"
DB 13,10," DOS capable of normal work with these diskettes.  It  isn't necessary to load"
DB 13,10," it to support 2M disks or to run  2MF;  but when installed,  DOS DISKCOPY can"
DB 13,10," copy 2M diskettes while formatting the target disk.  But the most interesting"
DB 13,10," feature of using 2MDOS is to improve DOS standard diskette formats  (with  or"
DB 13,10," without 2M loaded) with the powerful techniques Sector Sliding & DiskBoost."
DB 13,10," In this way, DOS FORMAT  (and most of the rest format utilities)  can  create"
DB 13,10," very fast diskettes which are completely standard (and without having to load"
DB 13,10," 2MDOS to support them in future)."
DB 10
DB 13,10,"  Also, 2MDOS improves by default support for FDFORMAT non standard diskettes"
DB 13,10," making DOS FORMAT capable of building FDFORMAT diskettes."
DB 10
DB 13,10,"  This program takes 5.7 Kbytes of RAM in systems without XMS memory (or with"
DB 13,10," /NOXMS switch set) in other case it takes 2.6K  (1.8K  if  /NODISKCOPY switch"
DB 13,10," set or with 2M not loaded). For more information on switches, try 2MDOS /??"
DB 13,10,0

mas_ayuda_txt  LABEL BYTE
DB 13,10
DB 13,10," /DISKCOPY (por defecto si 2M est instalado) y /NODISKCOPY"
DB 13,10,"    El soporte DISKCOPY establecido por defecto permite al DISKCOPY de MS-DOS"
DB 13,10,"    y DR-DOS poder copiar disquetes 2M/FDFORMAT con la capacidad de formatear"
DB 13,10,"    el disco destino si no lo estaba.  Realmente el soporte es an mayor  (el"
DB 13,10,"    FORMAT de DR-DOS puede incluso formatear disquetes 2M, indicando pistas y"
DB 13,10,"    sectores, pero desactiva el SuperBOOT; es mejor emplear 2MF. El FORMAT de"
DB 13,10,"    MS-DOS tambin funciona pero slo crea bien discos 2M de doble densidad)."
DB 13,10,"    Si 2M no est instalado, se activa la opcin inversa,  que  desactiva  el"
DB 13,10,"    soporte DISKCOPY y economiza algo de memoria."
DB 10
DB 13,10," /FORMAT y /NOFORMAT (esta ltima por defecto)"
DB 13,10,"    El soporte FORMAT permite al FORMAT del MS-DOS crear discos 2M y/o FDREAD"
DB 13,10,"    de alta densidad. Esta opcin NO ES NECESARIA para el FORMAT de DR-DOS!."
DB 13,10,"    Si no se activa esta opcin, el  FORMAT  de MS-DOS crear incorrectamente"
DB 13,10,"    los discos 2M/FDREAD de alta densidad.  Esta opcin es poco recomendable;"
DB 13,10,"    es  mejor  activarla slo puntualmente para crear un disco FDREAD de alta"
DB 13,10,"    densidad y volver a inhibirla despus porque, si est activa, por defecto"
DB 13,10,"    se  crearn  discos de mxima capacidad; para formatear un disco estndar"
DB 13,10,"    habra que forzarlo (/F:1.44, /F:720, /F:360; /F:1.2 debe sustituirse por"
DB 13,10,"    /T:80 /N:15, por otra limitacin de FORMAT); los dems formatos deben ser"
DB 13,10,"    seleccionados indicando pistas y sectores.  Otro inconveniente de activar"
DB 13,10,"    esta opcin es que, con ella activa, bajo el administrador de archivos de"
DB 13,10,"    Windows 3 slo se pueden formatear discos 2M/FDREAD de mxima capacidad."
DB 10
DB 13,10,"                                                            [PULSA UNA TECLA]",1
DB 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,"                 ",13,10,10
DB 13,10," /NOXMS"
DB 13,10,"    Con esta opcin, los datos residentes para el soporte DISKCOPY se colocan"
DB 13,10,"    en memoria convencional o superior en lugar de extendida;  dependiendo de"
DB 13,10,"    la clase de controlador de memoria, puede suponer economizar 4Kb de XMS "
DB 13,10,"    16 Kb de EMS, y emplear 3,1 kbytes ms de memoria convencional/superior."
DB 10
DB 10
DB 13,10," /ML"
DB 13,10,"    Fuerza la instalacin en memoria convencional, del cdigo y datos de este"
DB 13,10,"    programa (2MDOS se autoinstala por defecto en memoria superior si puede)."
DB 10
DB 10
DB 13,10," /U"
DB 13,10,"    Desinstala el programa de la memoria, si es posible. Desinstalar 2MDOS es"
DB 13,10,"    necesario para poder desinstalar 2M, debido a la interconexin de ambos."
DB 10
DB 10
DB 13,10," /FDREAD (por defecto) y /NOFDREAD"
DB 13,10,"    Con el soporte FDREAD activo, no es necesario ya instalar la utilidad del"
DB 13,10,"    mismo nombre para soportar discos FDFORMAT. Adems as FORMAT puede crear"
DB 13,10,"    disquetes FDFORMAT (con /DISKCOPY activo) indicando pistas y sectores (el"
DB 13,10,"    de  MS-DOS  no puede crear discos de alta densidad correctamente si no se"
DB 13,10,"    indica /FORMAT; el de DR-DOS no tiene problemas)."
DB 13,10,"                                                            [PULSA UNA TECLA]",1
DB 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,"                 "
DB 10
DB 13,10," /OPT (por defecto) y /NOOPT"
DB 13,10,"    Con la opcin de optimizacin activa, muy recomendable,  2MDOS intercepta"
DB 13,10,"    el funcionamiento del FORMAT del DOS, Norton o PC Tools para optimizar la"
DB 13,10,"    numeracin de los sectores en las pistas  (sector sliding)  durante  el"
DB 13,10,"    proceso de formateo de un disquete estndar. El posterior acceso ser ms"
DB 13,10,"    rpido, sin prdida alguna de compatibilidad, siendo los nuevos disquetes"
DB 13,10,"    tan transportables como los originales del DOS."
DB 10
DB 10
DB 13,10," /BOOST (por defecto) y /NOBOOST"
DB 13,10,"    Con esta opcin habilitada, los disquetes estndar de 1.2 y 1.44M emplean"
DB 13,10,"    la nueva tecnologa DiskBoost, un 15% ms rpida que sector sliding y"
DB 13,10,"    un 50% ms de lo normal. Pueden seguir siendo accedidos sin problemas sin"
DB 13,10,"    tener instalado 2MDOS en cualquier otra mquina o sistema operativo."
DB 13,10,255

DB 13,10
DB 13,10," /DISKCOPY (default if 2M is installed) and /NODISKCOPY"
DB 13,10,"    DISKCOPY support set on by default,  lets both MS-DOS and DR-DOS DISKCOPY"
DB 13,10,"    programs to copy  2M/FDFORMAT  diskettes  with the capability of format a"
DB 13,10,"    unformatted target. The final support is larger (DR-DOS FORMAT is capable"
DB 13,10,"    of format 2M diskettes telling it about the number of tracks and sectors,"
DB 13,10,"    but disables SuperBOOT feature; so, 2MF is best. MS-DOS format also works"
DB 13,10,"    but only format correctly 2M double density disks). When 2M is not loaded"
DB 13,10,"    in memory the other option is enabled, to disable DISKCOPY support and to"
DB 13,10,"    save some memory."
DB 10
DB 13,10," /FORMAT and /NOFORMAT (default)"
DB 13,10,"    Format support lets  MS-DOS  FORMAT  build  2M and/or FDREAD high density"
DB 13,10,"    disks.  This option is NOT NECESSARY with DR-DOS FORMAT!.  If this option"
DB 13,10,"    is not enabled  MS-DOS  FORMAT will incorrectly format 2M and FDREAD high"
DB 13,10,"    density disks. This option isn't generally recommended; the best solution"
DB 13,10,"    is to enable it only  before  formatting  an FDREAD high density disk and"
DB 13,10,"    just disable it after.  While this option is enabled, the default will be"
DB 13,10,"    to format 2M/FDREAD maximum capacity diskettes;  to format a standard one"
DB 13,10,"    it will be necessary to force it (/F:1.44, /F:720, /F:360; /F:1.2 must be"
DB 13,10,"    replaced  by  /T:80 /N:15  due  a  FORMAT  problem); the rest of the disk"
DB 13,10,"    formats can be selected  using  track/sectors  FORMAT  switches.  Another"
DB 13,10,"    problem that appears enabling this option, is that Windows 3 file manager"
DB 13,10,"    is only able to format maximum capacity 2M/FDREAD disks."
DB 13,10,"                                                              [PRESS ANY KEY]",1
DB 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,"               "
DB 13,10," /NOXMS"
DB 13,10,"    With this switch enabled,  the resident data for DISKCOPY support will be"
DB 13,10,"    placed in conventional or  upper  memory,  instead  of  extended  memory;"
DB 13,10,"    depending on the memory manager type,  it  can save 4Kb of XMS or 16Kb of"
DB 13,10,"    EMS, and to spend over 3.1 Kbytes more of conventional or upper memory."
DB 10
DB 10
DB 13,10," /ML"
DB 13,10,"    Forces a conventional memory installation of  2MDOS  code and data  (this"
DB 13,10,"    program is an upper memory self-installating utility)."
DB 10
DB 10
DB 13,10," /U"
DB 13,10,"    Tells 2MDOS to uninstall, if possible.  To uninstall 2MDOS it's necessary"
DB 13,10,"    to be able to uninstall 2M, because of the connection between both TSRs."
DB 10
DB 10
DB 13,10," /FDREAD (default) and /NOFDREAD"
DB 13,10,"    With FDREAD support active,  it  is  not necessary to install the program"
DB 13,10,"    of the same name to support FDREAD diskettes.  Also, DOS FORMAT can build"
DB 13,10,"    FDFORMAT  disks  (if /DISKCOPY is active)  telling it about the number of"
DB 13,10,"    sectors and tracks (MS-DOS FORMAT can't correctly make high density disks"
DB 13,10,"    without /FORMAT switch, but DR-DOS has no problems)."
DB 13,10,"                                                              [PRESS ANY KEY]",1
DB 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,"               "
DB 10
DB 13,10," /OPT (default) and /NOOPT"
DB 13,10,"    With the format optimization enabled (recommended) DOS, Norton, PC Tools,"
DB 13,10,"    ...and other format programs will be intercepted in order to DOS optimize"
DB 13,10,"    the sector sequence along the tracks (sector sliding) during the format"
DB 13,10,"    process of a standard diskette.  Resulting access times will be very much"
DB 13,10,"    faster,  without any compatibility decrease and new diskettes as portable"
DB 13,10,"    as DOS primary ones."
DB 10
DB 10
DB 13,10," /BOOST (default) and /NOBOOST"
DB 13,10,"    With this option enabled,  standard 1.2M and 1.44M diskettes will use the"
DB 13,10,"    new Diskboost technology,  a 15% faster than sector sliding and a 50%"
DB 13,10,"    faster than DOS normal. These diskettes can be used without problems (and"
DB 13,10,"    without installing 2MDOS) in any other computer or operating system."
DB 13,10,0

buffer_aux     DB    64 DUP (0)   ; buffer para alguna funcin del DOS

_PRINCIPAL     ENDS
               END   inicio
