
/*\
                                                                    
                                        
                                                         
                                                 
                                                           
                                                
                                                                    
         2M-INFO 3.0  -  UTILIDAD DE DOCUMENTACION SOBRE 2M         
                                                                    
               (C) 1994-1995 Ciriaco Garca de Celis.               
                                                                    
 - Para cualquier Turbo C o Borland C++ en modelo de memoria LARGE. 
 - Este programa se compila abriendo un proyecto e introduciendo en 
   l 2M-INFO.C, 2M-IN765.C, 2M-INFDT.C, 2M-INDOC.C y 2M-INF.ASM    
                                                                    
\*/


#include <bios.h>
#include <dos.h>
#include <alloc.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "2m-info.h"


unsigned _stklen = 16384;


#define FICH_FMC "2M-INFO.FMC"
#define FICH_DOC "2M-INFO.FDA"
#define FICH_IDX "2M-INFO.IDX"
#define FALTA_FMC   1
#define POCA_MEM    2
#define ERROR_FMC   4


#define R 0
#define G 1
#define B 2


extern void debug765 (void);
extern void fdtr (int, int);
extern void vgahi256 (void);
extern void setpix (int, int, int);
extern void setpage (int);
extern void showpage (int);
extern void prcar (int, int, int, int, int, int, int, int);
extern void PintaBitMap (char *, int, int, int, int, int, int, int, int);
extern int VerFicheroDoc (char *, char *, char *, Parametros *);
extern int getpix (int, int);
extern int ptecla (char);
extern int segvideo;
extern int semilla;
extern unsigned rnd (unsigned);
extern char far *FuenteInfo;


int  HablaSp (void),
     ExisteVga (void),
     Tecla (void),
     Hay2M3 (void),
     EsOS2 (void),
     EsWinEnh (void),
     Luminosidad (int),
     VgaPantallaIni (void),
     CargarGalaxia (void),
     input (char *, int, int, int, int);
void Vram (int),
     Ayuda (void),
     ProcesaParametros (int, char **, Parametros *),
     ImprimirError (int),
     VgaPantallaFin (void),
     Estrellas (void),
     escribir2M (char *),
     LogoTxt (void),
     CursorOff (void),
     BrilloOn (void),
     TxtPantallaIni (void),
     TxtPantallaFin (void),
     Trampa (int),
     PaletaIni (void),
     PaletaFin (void),
     Paciencia (void),
     prcad (char *, int, int, int, int, int, int, int),
     Imprimir2M (void),
     ImprimirLogo (void),
     ImprimirCardWare (void),
     ventana (int, int, int, int, int, int, int),
     Marco3dg (int, int, int, int, int, int, int, int),
     v3dg (int, int, int, int, int, int, int, int, int),
     v3d (int, int, int, int, int),
     Marco3df (int, int, int, int, int, int, int),
     v3df (int, int, int, int, int, int, int, int),
     boton (int, int, int, int, int, int, char *);
char *dec2str (unsigned),
     *dec3str (unsigned),
     *dec5str (unsigned),
     *dec2strq (unsigned),
     *dec3strq (unsigned),
     *dec5strq (unsigned);


char *KeybShifts = MK_FP (0x40, 0x17);
int   sp;                               /* 1-espaol 0-ingls */
char  ruta[64];                         /* directorio de ejecucin */


void Vram (int operacion)
{
  static scr_ok, modo, pag, cx, cy, colorbits;
  static char *scrbuf;
  union REGS regs;

  if (operacion==PRESERVAR) {
    scr_ok=0;
    modo=peekb(0x40, 0x49) & 0x7F;
    if (peekb(0x40, 0x84) < 24) pokeb(0x40, 0x84, 24);
    if ((modo<=3)||(modo==7)) {
      if ((scrbuf=farmalloc(4096L))!=NULL) {
        scr_ok=1;
        movedata ((modo==7) ? 0xb000: 0xb800,
                  (modo==7) ? 0     : peek(0x40, 0x4e),
                  FP_SEG(scrbuf), FP_OFF(scrbuf), 4096);
        pag=peekb(0x40,0x62);
        cx=peekb(0x40,0x50+pag*2); cy=peekb(0x40,0x51+pag*2);
        colorbits=peek(0x40, 0x10) & 0x30;
        textmode ((modo!=7) ? C80:MONO);
        }
      }
    }
    else if ((operacion==RESTAURAR) || (operacion==MOSTRAR)) {
      poke (0x40, 0x10, peek(0x40, 0x10) & 0xFFCF | colorbits);
      regs.x.ax=modo; int86 (0x10, &regs, &regs);
      if (scr_ok) {
          regs.x.ax=0x500+pag; int86 (0x10, &regs, &regs);
          movedata (FP_SEG(scrbuf), FP_OFF(scrbuf),
                    (modo==7) ? 0xb000 : 0xb800,
                    (modo==7) ? 0      : peek(0x40, 0x4e), 4096);
          regs.x.ax=0x200; regs.x.bx=pag<<8;
          regs.h.dh=cy; regs.h.dl=cx; int86 (0x10, &regs, &regs);
          if (operacion==RESTAURAR) farfree(scrbuf);
          }
      }
}


void Ayuda (void)
{
  if (sp)
      printf("\n2M-INFO 3.0\n"
             "   /Q  Evitar la pantalla de presentacin  (equivale a dejar pulsada\n"
             "       alguna tecla MAYUSCULAS al entrar, y a salir pulsando ALT-X).\n"
             "   /D  Arranca directamente la utilidad 765DEBUG 4.0\n"
             "   /T  Arranca directamente la utilidad FDTR (se admite unidad).\n"
             "   /M  Fuerza la presentacin en  modo texto  (por defecto si no hay\n"
             "       al menos una tarjeta VGA en el sistema).\n"
             "   /25 Usar 25 lneas en vez de 30 (por defecto si no hay VGA o bajo\n"
             "       Windows Enhanced -excepto Windows 95- u OS/2).\n"
             "   /30 Usar 30 lneas si es posible (problemtico en las ventanas de\n"
             "       Windows Enhanced u OS/2: utilice adems pantalla completa).\n"
             "   /I  Conmuta de Espaol a Ingls o viceversa.\n\n"
             " (C) 1994-1995 Ciriaco Garca de Celis - Grupo Universitario de Informtica\n"
             " C/Renedo, 2, 4-C; 47005 Valladolid (Espaa) - ciri@gui.uva.es - 2:341/21.8\n");
    else
      printf("\n2M-INFO 3.0\n"
             "   /Q  Skips the first introductory screen (equivalent to leave pressed\n"
             "       a SHIFT key at the beginning, and to exit using ALT-X).\n"
             "   /D  Starts running 765DEBUG 4.0 utility.\n"
             "   /T  Starts running FDTR utility (drive letter supported).\n"
             "   /M  Forces a text mode presentation (by default if the system hasn't\n"
             "       at least a VGA card).\n"
             "   /25 Use 25 lines instead 30 (by default if VGA card isn't present or\n"
             "       under Windows Enhanced -except Windows 95- or OS/2).\n"
             "   /30 Use 30 lines if possible  (it  can  be problematic under Windows\n"
             "       Enhanced or OS/2 windows: use also full screen).\n"
             "   /I  Conmutes from English to Spanish or vice versa.\n\n"
             " (C) 1994-1995 Ciriaco Garca de Celis - Grupo Universitario de Informtica\n"
             " C/Renedo, 2, 4-C;  47005 Valladolid (Spain) - ciri@gui.uva.es - 2:341/21.8\n");
  exit (1);
}


void ProcesaParametros (int nump, char **pmts, Parametros *cmd)
{
  int  i, pm, ayuda=0, mdi=0, mndm=0, mtxt=0,
              md=0, mt=0, m25=0, m30=0, unidad=0, midx=0;
  char *p;

  strcpy (ruta, pmts[0]);
  for (i=strlen(ruta); (i>0) && (ruta[i] != '\\'); i--);
  ruta[i+1]=0;

  for (pm=1; pm<nump; pm++) {
    strupr (pmts[pm]);
    if (strstr(pmts[pm],"/?")!=NULL) ayuda++;
    else if ((strstr(pmts[pm],"/H")!=NULL) && (strlen(pmts[pm])==2)) ayuda++;
    else if (strstr(pmts[pm],"/IDX")!=NULL) midx++;
    else if (strstr(pmts[pm],"/I")!=NULL) {mdi++; sp^=1;}
    else if (strstr(pmts[pm],"/Q")!=NULL) mndm++;
    else if (strstr(pmts[pm],"/M")!=NULL) mtxt++;
    else if (strstr(pmts[pm],"/D")!=NULL) md++;
    else if (strstr(pmts[pm],"/T")!=NULL) mt++;
    else if (strstr(pmts[pm],"/25")!=NULL) m25++;
    else if (strstr(pmts[pm],"/30")!=NULL) m30++;
    else if ((p=strstr(pmts[pm],":"))!=NULL) {
      unidad = *(--p);
      if ((unidad<'A') || (unidad>'Z')) unidad=0; else unidad -= 'A';
      }
    else ayuda++;
    }

  cmd->Ayuda    = ayuda;
  cmd->ModoI    = mdi;
  cmd->NoDemo   = mndm;
  cmd->ModoTxt  = mtxt;
  cmd->Modo765  = md;
  cmd->ModoTest = mt;
  cmd->Modo25   = m25;
  cmd->Modo30   = m30;
  cmd->HazIdx   = midx;
  cmd->Unidad   = unidad;
}


int ExisteVga()
{
  union REGS r;

  r.x.ax=0x1A00; int86 (0x10, &r, &r);
  return ((r.x.ax & 0xFF)==0x1A);
}


int Tecla()
{
  int t;

  while (kbhit()) getch(); t=getch(); if (!t) t=getch() << 8;
  return (t);
}


int Hay2M3()     /* devolver 1 si 2M 3.X est instalado */
{
  int entrada, instalado=0;
  union REGS r; struct SREGS s;

  for (entrada=0xc0; (entrada<=0xff) && (!instalado); entrada++) {
    r.x.ax=entrada << 8; s.es=0x1492; r.x.di=0x1992;
    int86x (0x2f, &r, &r, &s);
    if (r.x.ax==0xFFFF)
      if ((peek(s.es,r.x.di-4)==9002) && (peek(s.es,r.x.di-2)==10787))
        if (strstr (MK_FP(s.es, r.x.di),"2M:3.")) instalado=1;
        if (strstr (MK_FP(s.es, r.x.di),"2MX:3.")) instalado=1;
    }
  return (instalado);
}


int EsOS2 (void)   /* Devolver 1 si corriendo bajo OS/2 */
{
  union REGS r;

  if (_osmajor >= 3) {
      r.x.ax=0x4010;
      int86 (0x2F, &r, &r);
      return (r.x.ax != 0x4010);
      }
    else return (0);   /* DOS 2.X, evitar llamada a INT 2Fh */
}


int EsWinEnh (void)   /* Devolver versin de Windows Enhanced */
{
  union REGS r;

  if (_osmajor >= 3) {
      r.x.ax=0x1600;
      int86 (0x2F, &r, &r);
      if (!r.h.al) r.h.ah=0;
      return ((r.h.al << 8) | r.h.ah);
      }
    else return (0);   /* DOS 2.X, evitar llamada a INT 2Fh */
}


int CargarGalaxia()
{
  int          f, i, x, y, tramas[12][2];
  long         lbloque, posic, lgrafico, lbuffer, byte;
  FichMultCiri imagen;
  char         *buffer, *grafico, *pg, *pb, car, nfich[64], id[16];
  union  REGS  r;
  struct SREGS s;

  strcpy (nfich, ruta); strcat (nfich, FICH_FMC);

  if ((f=open(nfich, O_RDONLY | O_BINARY))==-1) return (FALTA_FMC);
  lseek (f, FMC_ID_OFF, SEEK_SET);
  if (read (f, id, 16)==-1) return (ERROR_FMC);
  if (strcmp(id, FMC_ID)) return (ERROR_FMC);

  posic = FMC_ID_HEAD;
  do {
    if (posic>=filelength(f)) return (ERROR_FMC);
    do {
      lseek (f, posic, SEEK_SET);
      if (read (f, &imagen, sizeof(FichMultCiri))==-1) return (ERROR_FMC);
      posic += imagen.lbloque;
    } while ((imagen.tipo != FMC_GRAFICO) && (posic<filelength(f)));
  } while (strcmp(imagen.nombre, "Galaxia"));

  if (!(imagen.atributos & 1)) return (ERROR_FMC);  /* no comprimido */

  lgrafico=imagen.info.gr.lx * imagen.info.gr.ly + 64L*3;
  lbuffer=imagen.lbloque - sizeof(FichMultCiri);
  if ((grafico=farmalloc(lgrafico))==NULL) return (POCA_MEM);
  if ((buffer=farmalloc(lbuffer))==NULL) {
    farfree (grafico);
    return (POCA_MEM);
    }

  if (read (f, buffer, lbuffer)==-1) {
    farfree (buffer);
    farfree (grafico);
    return (ERROR_FMC);
    }
  close (f);

  pg=grafico; pb=buffer;
  for (byte=0; byte < lbuffer; byte++, pb++) {  /* descomprimir */
    car = *pb & 0x3F;
    switch (*pb & 0xC0) {
      case  64: *pg++=car; *pg++=car; break;
      case 128: *pg++=car; *pg++=car; *pg++=car; break;
      case 192: for (i=0, pb++; i<*pb; i++) *pg++=car; byte++; break;
      default:  *pg++=car;  break;
      }
    }

  farfree (buffer);

  if (lgrafico < pg-grafico) {
    farfree (grafico);
    return (ERROR_FMC);
    }

  r.x.ax=0x1012; r.x.bx=0; r.x.cx=64;
  s.es=FP_SEG(grafico); r.x.dx=FP_OFF(&grafico[r.x.bx]);
  int86x (0x10, &r, &r, &s);  /* establecer paleta */

  PintaBitMap (&grafico[192], imagen.info.gr.lx,
               0, 0, imagen.info.gr.lx, imagen.info.gr.ly, 160, 0, 0);

  PintaBitMap (&grafico[192], imagen.info.gr.lx,
               0, 0, imagen.info.gr.lx, imagen.info.gr.ly, 0, 166-80, 1);

  tramas[0][0]=0;    tramas[0][1]=0;
  tramas[1][0]=115;  tramas[1][1]=32;
  tramas[2][0]=0;    tramas[2][1]=32;
  tramas[3][0]=19;   tramas[3][1]=32;
  tramas[4][0]=32;   tramas[4][1]=160;
  tramas[5][0]=34;   tramas[5][1]=192;
  tramas[6][0]=16;   tramas[6][1]=160;
  tramas[7][0]=0;    tramas[7][1]=64;
  tramas[8][0]=128;  tramas[8][1]=192;
  tramas[9][0]=144;  tramas[9][1]=192;
  tramas[10][0]=128; tramas[10][1]=0;
  tramas[11][0]=92;  tramas[11][1]=32;

  srand (1);

  for (y=0; y<3; y++)
    for (x=0; x<10; x++) {
      i = random(10);
      PintaBitMap (&grafico[192], imagen.info.gr.lx,
                   tramas[i][0], tramas[i][1], 16, 32, x*16, y*32,
                   random (2));
      }

  for (y=10; y<13; y++)
    for (x=0; x<10; x++) {
      i = random(10);
      PintaBitMap (&grafico[192], imagen.info.gr.lx,
                   tramas[i][0], tramas[i][1], 16, y==12?16:32,
                   x*16, y*32, random(2));
      }

  for (y=0; y<6; y++)
    for (x=10; x<20; x++) {
      i = random(10);
      PintaBitMap (&grafico[192], imagen.info.gr.lx,
                   tramas[i][0], tramas[i][1], 16, y==5?20:32,
                   x*16, y*32+220, random(2));
      }

  PintaBitMap (&grafico[192], imagen.info.gr.lx,
               tramas[10][0], tramas[10][1], 16, 32, 90, 96, 0);
  PintaBitMap (&grafico[192], imagen.info.gr.lx,
               tramas[11][0], tramas[11][1], 16, 32, 128, 96, 0);
  PintaBitMap (&grafico[192], imagen.info.gr.lx,
               tramas[10][0], tramas[10][1], 16, 32, 165, 292, 1);
  PintaBitMap (&grafico[192], imagen.info.gr.lx,
               tramas[11][0], tramas[11][1], 16, 32, 220, 288, 1);

  farfree (grafico);

  return (0);
}


int VgaPantallaIni()
{
  int err=0, errg=0;

  vgahi256();
  PaletaIni();
  setpage (1);
  showpage (1);
  Paciencia();
  setpage (0);

  if (!(err=CargarGalaxia())) {
      Imprimir2M();
      ImprimirLogo();
      }
    else
      ImprimirError (err);

  errg |= Luminosidad (DESCENDENTE);
  showpage (0);
  if (!errg)
    errg |= Luminosidad (ASCENDENTE);

  if ((err) && ((bioskey(1) & 0xFF) != 0x1B)) Tecla();
  return (err | errg);
}


void VgaPantallaFin()
{
  int err;

  vgahi256();
  PaletaFin();
  setpage (1);
  showpage (1);
  Paciencia();
  setpage (0);

  if (!(err=CargarGalaxia())) {
      Imprimir2M();
      ImprimirCardWare();
      }
    else
      ImprimirError (err);

  showpage (0);
}


void Estrellas()
{
  unsigned register x, i;
  unsigned *pantalla;
  unsigned tpant, nc, b1, b2, b3, b4;

  if ((peekb(0x40, 0x49) & 0x7F) == 7) {
      pantalla = MK_FP (0xB000, 0);
      nc=6; b1=b2=2; b3=b4=10;
      }
    else {
      pantalla = MK_FP (0xB800, 0);
      nc=1; b1=1; b2=3; b3=9; b4=11;
      }

  tpant = (peekb(0x40, 0x84)+1)*80;

  for (i=0; i < tpant; i++) pantalla[i]=' ';

  semilla=99;
  for (i=0; i < (tpant/20); i++) {
    x = rnd(tpant) << 1; pantalla[x] =   7 | ((rnd(nc)+b1) << 8);
    x = rnd(tpant) << 1; pantalla[x] =  46 | ((rnd(nc)+b2) << 8);
    x = rnd(tpant) << 1; pantalla[x] = 249 | ((rnd(nc)+b3) << 8);
    x = rnd(tpant) << 1; pantalla[x] = 250 | ((rnd(nc)+b4) << 8);
    }
}


void escribir2M (char *mensaje)
{
  int i;
  char      *pantalla;

  gotoxy (8, wherey()+1);
  pantalla = MK_FP ((peekb(0x40, 0x49) & 0x7F) == 7 ? 0xB000:0xB800,
    (wherex() + wherey()*80)*2);

  for (i=0; i<strlen(mensaje); i++)
    switch (mensaje[i]) {
      case ' ': pantalla+=2; break;
      case '': *pantalla++='';
                if (i<35) *pantalla++=10; else *pantalla++=109;
                break;
      case '':
      case '':
      case '': *pantalla++=mensaje[i];
                if (i<35) *pantalla++=10; else *pantalla++=5;
                break;
      }
}


void LogoTxt()
{
  textbackground (0);
  Estrellas();

  gotoxy (1, 4);
  escribir2M("        ");
  escribir2M("      ");
  escribir2M(" ߱    ");
  escribir2M("             ܱ");
  escribir2M("             ۱۱");
  escribir2M("   ߱          ");
  escribir2M("           ߱     ߱");
  escribir2M("                              ");
  escribir2M("                                     ");
  escribir2M("                            ߱          ");
  escribir2M("                               ");
  escribir2M("               ");
  escribir2M("                     ");
}


void CursorOff (void)
{
  union REGS regs;

  regs.x.ax=0x200; regs.x.bx=peekb(0x40,0x62)<<8;
  regs.h.dl=1; regs.h.dh=63; int86 (0x10, &regs, &regs);
}


void BrilloOn (void)
{
  union REGS regs;

  if (peekb(0x40, 0x49)!=7) {       /* evitarlo en MDA */
    regs.x.ax=0x1003; regs.x.bx=0;
    int86 (0x10, &regs, &regs);
    }
}


void TxtPantallaIni()
{
  LogoTxt();

  textcolor (9);
  if (sp) {
      gotoxy (22,19);
      cputs("M A S   A L L A   D E L   L I M I T E"); }
    else {
      gotoxy (21,19);
      cputs("F A R   A W A Y   F R O M   L I M I T S");
      }

  textcolor (14); gotoxy (26+sp,22);
  cputs("(C) Ciriaco Garca de Celis");

  gotoxy (36+sp,23); textcolor (12);
  cputs("CiriSOFT");
  CursorOff();
}


void TxtPantallaFin()
{
  LogoTxt();

  textcolor (12);

  if (sp) {
      gotoxy (26, 3);
      cputs (" S E   M E   O L V I D A B A !"); }
    else {
      gotoxy (24, 3);
      cputs ("I   R E M E M B E R   I T   N O W!");
      }

  gotoxy (31, 19); textcolor (14);
  if (sp)
      cputs ("E S   C A R D W A R E");
    else
      cputs ("I S   C A R D W A R E");

  gotoxy (24, 21); textcolor (9);
  if (sp)
      cputs ("Recuerda enviar tu tarjeta postal a:");
    else
      cputs ("Don't forget to send your postcard to:");

  textcolor (10);
  gotoxy (30, 22); cputs("Ciriaco Garca de Celis");
  gotoxy (33, 23); cputs("C/Renedo, 2, 4-C");
  gotoxy (33, 24); cputs("47005 Valladolid");
  if (sp) {
      gotoxy (37, 25); cputs("(Espaa)"); }
    else {
      gotoxy (37, 25); cputs("(Spain)"); }

  CursorOff();
}


void Trampa (int vez)
{
  static char cmd[64];
  char   prompt[80], *pantalla;
  int    cy, pag, cols, x, car;

  pag=peekb(0x40, 0x62); cols=peek(0x40, 0x4A);
  cy=peekb(0x40, 0x51+pag*2);
  pantalla = MK_FP ((peekb(0x40, 0x49) & 0x7F) == 7 ? 0xB000:0xB800,
                    peek (0x40, 0x4C) * pag);

  if (vez==INICIO) {
      for (x=0; (x<cols) && (pantalla[(x+(cy-1)*cols)*2] != '>'); x++)
        prompt[x]=pantalla[(x+(cy-1)*cols)*2];
      prompt[x++]='>'; prompt[x]=0;
      memmove (pantalla,  /* evitar scroll hardware de nnansi.sys */
               pantalla + (cols << 1), peek(0x40, 0x4C)-(cols << 1));
      printf("%s", prompt); x=cmd[0]=0;
      do {
        car = getch();
        if (!car) car = getch() << 8;
          else if (car>=' ') cmd[x++]=car, cmd[x]=0, printf("%c", car);
        if (((car==8) || (car==0x4B00)) && (x>0))
          cmd[--x]=0, printf("%s", "\b \b");
        } while ((car!=13) && (x<15));
      }
    else {
      if (sp)
          printf("\n        Nota:  Si ya ha enviado su tarjeta postal, la prxima vez"
                 "\n        puede evitar este aviso abandonando el programa con ALT-X.\n");
        else
          printf("\n        Note:  If you have already sent your postcard, next time"
                 "\n        you can avoid this advice exiting the program with ALT-X.\n");

      while (kbhit()) getch();
      for (x=0; x<strlen(cmd); x++) ptecla (cmd[x]);
      }
}


void PaletaIni()
{
  char         dac[256][3];
  union  REGS  r;
  struct SREGS s;
  register     i;

  dac[000][R]=dac[000][G]=dac[000][B]=0;       /* negro */
  for (i=64; i<110; i++) {                     /* '2M' */
    dac[i][R]=i-64+18;
    dac[i][G]=((i-64) >> 1) + 18;
    dac[i][B]=0;
    }
  for (i=110; i<155; i++) {                    /* '3.0' */
    dac[i][R]=i-109+19;
    dac[i][G]=i-109+19;
    dac[i][B]=0;
    }
  for (i=155; i<199; i++) {                    /* 'Ciriaco...' */
    dac[i][R]=(i-155+20) >> 4;
    dac[i][G]=i-155+20;
    dac[i][B]=(i-155+20) >> 4;
    }
  for (i=199; i<229; i++) {                    /* leyenda x2 */
    dac[i][R]=(i-199)*7/4+11;
    dac[i][G]=((i-199)*7/4+11)/3;
    dac[i][B]=11;
    }
  for (i=229; i<244; i++) {                    /* x1 */
    dac[i][R]=dac[i][G]=random(16);
    dac[i][B]=random(16)+48;
    }

  dac[255][R]=dac[255][G]=dac[255][B]=0;       /* negro */
  dac[254][R]=dac[254][G]=0; dac[254][B]=48;   /* 'CiriSOFT' */

  r.x.ax=0x1012; r.x.bx=0; r.x.cx=256;
  s.es=FP_SEG(dac); r.x.dx=FP_OFF(&dac[r.x.bx]);
  int86x (0x10, &r, &r, &s);
}


void PaletaFin()
{
  char         dac[256][3];
  union  REGS  r;
  struct SREGS s;
  register     i;

  dac[000][R]=dac[000][G]=dac[000][B]=0;       /* negro */
  for (i=64; i<110; i++) {                     /* '2M' */
    dac[i][R]=i-64+18;
    dac[i][G]=((i-64) >> 1) + 18;
    dac[i][B]=0;
    }
  for (i=110; i<155; i++) {                    /* '3.0' */
    dac[i][R]=i-109+19;
    dac[i][G]=i-109+19;
    dac[i][B]=0;
    }
  for (i=155; i<174; i++) {                    /* 'Olvido' */
    dac[i][R]=((i-155)*3+9) >> 4;
    dac[i][G]=(i-155)*3+9;
    dac[i][B]=((i-155)*3+9) >> 4;
    }
  for (i=174; i<201; i++) {                    /* 'CardWare' */
    dac[i][R]=(i-174)*7/4+16;
    dac[i][G]=((i-174)*7/4+16)/3;
    dac[i][B]=16;
    }
  for (i=201; i<225; i++) {                    /* 'Postal...' */
    dac[i][R]=0;
    dac[i][G]=(i-201)*2+17;
    dac[i][B]=(i-201)*2+17;
    }
  for (i=225; i<239; i++) {                    /* 'C/...' */
    dac[i][R]=(i-225)*4+11;
    dac[i][G]=(i-225)*4+11;
    dac[i][B]=(i-225)*4+11;
    }

  dac[255][R]=dac[255][G]=dac[255][B]=0;       /* negro */

  r.x.ax=0x1012; r.x.bx=0; r.x.cx=256;
  s.es=FP_SEG(dac); r.x.dx=FP_OFF(&dac[r.x.bx]);
  int86x (0x10, &r, &r, &s);
}


void Paciencia()
{
  if (sp)
      prcad ("Un momento...", 115, 180, 1, 2, 198-2, 0xFF, 2);
    else
      prcad ("One moment...", 115, 180, 1, 2, 198-2, 0xFF, 2);
}


int Luminosidad (int modo)
{
  static   char dac[256][3];
  register      i, j;
  unsigned int  tm, tmout, tec;
  unsigned int  far *cbios=MK_FP(0x40, 0x6C);  /* reloj del sistema */
  unsigned char p;

  if (modo==DESCENDENTE) {
      for (i=0; i<256; i++) {          /* anotar la paleta activa */
        disable();
        outportb (0x3C7, i);
        dac [i][0] = inportb (0x3C9);  /* R */
        dac [i][1] = inportb (0x3C9);  /* G */
        dac [i][2] = inportb (0x3C9);  /* B */
        enable();
        }
      for (i=64; i>=0; i--) {          /* claridad descendente  */
        tec = bioskey(1) & 0xFF;
        if (tec == 0x1B) break; else if (tec) (void) bioskey(0);
        for (j=0; j<256; j++) {
        if  (!(j % 128)) {
          tmout=0;
          do {                         /* esperar retrazo vertical */
            p = inportb(0x3DA) & 8;
            if (tm != *cbios) {
              tm = *cbios; tmout++;
              if (tmout>9) goto aborta;
              }
            } while (p == 8);
          do {                         /* esperar su fin */
            p = inportb(0x3DA) & 8;
            if (tm != *cbios) {
              tm = *cbios; tmout++;
              if (tmout>9) goto aborta;
              }
            } while (p != 8);
          }
          disable();
          outportb (0x3C8, j);
          outportb (0x3C9, dac[j][0]*i >> 6);
          outportb (0x3C9, dac[j][1]*i >> 6);
          outportb (0x3C9, dac[j][2]*i >> 6);
          enable();
          }
        }
      }
    else if (modo==ASCENDENTE) {       /* claridad ascendente */
      for (i=0; i<=64; i++) {
        tec = bioskey(1) & 0xFF;
        if (tec == 0x1B) break; else if (tec) (void) bioskey(0);
        for (j=0; j<256; j++) {
        if  (!(j % 128)) {
          tmout=0;
          do {                         /* esperar retrazo vertical */
            p = inportb(0x3DA) & 8;
            if (tm != *cbios) {
              tm = *cbios; tmout++;
              if (tmout>9) goto aborta;
              }
            } while (p == 8);
          do {                         /* esperar su fin */
            p = inportb(0x3DA) & 8;
            if (tm != *cbios) {
              tm = *cbios; tmout++;
              if (tmout>9) goto aborta;
              }
            } while (p != 8);
          }
          disable();
          outportb (0x3C8, j);
          outportb (0x3C9, dac[j][0]*i >> 6);
          outportb (0x3C9, dac[j][1]*i >> 6);
          outportb (0x3C9, dac[j][2]*i >> 6);
          enable();
          }
        }
      }

  aborta:
  return (tmout > 9);  /* posible fallo HW en entornos avanzados */
}


void prcad (char *cad, int x, int y, int largo, int alto,
            int tinta, int papel, int escala)
{
  while (*cad) {
    prcar (*cad, x, y, largo, alto, tinta, papel, escala);
    x+=largo*8;
    cad++;
    }
}


void Imprimir2M()
{
  int x, y, cy, tt;

  prcar ('2', 60,  100, 8, 10, 64+15+45, 0xFF, -1);
  prcar (255, 124, 100, 8, 10, 64-15,    0xFF,  1);

  for (y=-148; y<-112; y++)         /* completar la 'M' */
    for (x=140; x<152; x++) {
      cy = (x << 1) + y;
      tt = (cy >> 1) - 1;
      setpix (x, cy, tt);
      setpix (303-x, cy, tt);
      }

  prcar ('3', 200, 160, 3, 5, 110+15+44, 0xFF, -2);
  prcar ('.', 221, 160, 2, 5, 110-15,    0xFF,  2);
  prcar ('0', 235, 160, 3, 5, 110-15,    0xFF,  2);
}


void ImprimirLogo()
{
  prcad ("CiriSOFT", 95, 230, 2, 6, 254, 0xFF, 0);
  prcad ("Ciriaco Garca de Celis", 67, 244, 1, 4, 155-4, 0xFF, 2);
  if (sp)
      prcad ("Ms all... del lmite", 71, 360, 1, 2, 199-2, 0xFF, 2);
    else
      prcad ("Far away... from limits", 67, 360, 1, 2, 199-2, 0xFF, 2);
}


void ImprimirError (int error)
{
  if (sp)
      switch (error) {
        case FALTA_FMC: prcad ("Fichero *.FMC no encontrado!",
                        40, 180, 1, 2, 110-2, 0xFF, 2); break;
        case POCA_MEM:  prcad ("Memoria insuficiente para",
                        55, 170, 1, 2, 110-2, 0xFF, 2);
                        prcad ("pantalla de presentacin.",
                        55, 200, 1, 2, 110-2, 0xFF, 2); break;
        case ERROR_FMC: prcad ("Problemas con el fichero *.FMC!",
                        30, 180, 1, 2, 110-2, 0xFF, 2); break;
        }
    else switch (error) {
        case FALTA_FMC: prcad ("File *.FMC not found!",
                        78, 180, 1, 2, 110-2, 0xFF, 2); break;
        case POCA_MEM:  prcad ("Insufficient memory",
                        87, 170, 1, 2, 110-2, 0xFF, 2);
                        prcad ("for initial screen.",
                        87, 200, 1, 2, 110-2, 0xFF, 2); break;
        case ERROR_FMC: prcad ("Problems with *.FMC file!",
                        63, 180, 1, 2, 110-2, 0xFF, 2); break;
        }

  if (sp)
      prcad ("Pulse una tecla para continuar.",35, 340, 1, 2, 198-2, 0xFF, 2);
    else
      prcad ("Press any key to continue.",60, 340, 1, 2, 198-2, 0xFF, 2);
}


void ImprimirCardWare()
{
  if (sp) {
      prcad ("Se me olvidaba!", 96, 20, 1, 5, 155-6, 0xFF, 1);
      prcad ("es CardWare", 28, 230, 3, 3, 174-9, 0xFF, 2);
      prcad ("Recuerda enviar tu tarjeta postal a:", 17, 280, 1, 2, 201-6, 0xFF, 2);
      }
    else {
      prcad ("I remember it now!", 84, 20, 1, 5, 155-6, 0xFF, 1);
      prcad ("is CardWare", 26, 230, 3, 3, 174-9, 0xFF, 2);
      prcad ("Don't forget to send your postcard to:", 9, 280, 1, 2, 201-6, 0xFF, 2);
      }

  prcad ("Ciriaco Garca de Celis", 68, 320, 1, 1, 225-1, 0xFF, 2);
  prcad ("C/Renedo 2,  4-C", 93, 340, 1, 1, 225-1, 0xFF, 2);
  prcad ("47005 Valladolid", 93, 360, 1, 1, 225-1, 0xFF, 2);

  if (sp)
      prcad ("(Espaa)", 125, 380, 1, 1, 225-1, 0xFF, 2);
    else
      prcad ("(Spain)", 129, 380, 1, 1, 225-1, 0xFF, 2);
}


void ventana (operacion, x0, y0, x1, y1, tinta, papel)
{
  static char *memoria;
  char   *pantalla;
  int    i, t;

  if (operacion==ABRIR) {
       if ((memoria = farmalloc (2L*(x1-x0+3)*(y1-y0+2)))!=NULL)
         gettext (x0, y0, x1+2, y1+1, memoria);
       textbackground (papel); if (tinta>7) t=tinta-8; else t=tinta;
       textcolor (t+8);
       gotoxy (x0, y0); putch('');
       gotoxy (x0, y1); putch('');
       textcolor (t);
       gotoxy (x1, y0); putch('');
       gotoxy (x1, y1); putch('');
       for (i=1; i<x1-x0; i++) {
         textcolor (t+8); gotoxy (x0+i, y0); putch('');
         textcolor (t);   gotoxy (x0+i, y1); putch('');
         }
       for (i=1; i<y1-y0; i++) {
         textcolor (t+8); gotoxy (x0, y0+i); putch('');
         textcolor (t); gotoxy (x1, y0+i); putch('');
         }
       window  (x0+1, y0+1, x1-1, y1-1);
       textcolor (tinta); clrscr();
       pantalla = MK_FP ((peekb(0x40, 0x49) & 0x7F) == 7 ? 0xB000:0xB800, 0);
       t = ((y1*80 + x0) << 1) + 1;
       for (i=1; i<x1-x0+2; i++) pantalla[t+(i<<1)]=7;
       t = ((y0*80 + x1) << 1) + 1;
       for (i=0; i<y1-y0; i++)
         pantalla[t+i*160]=pantalla[t+i*160+2]=7;
       }
     else {
       puttext (x0, y0, x1+2, y1+1, memoria);
       if (memoria != NULL) farfree (memoria);
       window (1, 1, 80, 25);
       }
}


void Marco3dg (cx, cy, lx, ly, foco, tin, pap, banda)
{
  int tb, x, y, w;

  w = _wscroll; _wscroll=0;

  if (tin<8) tb=tin+8; else tb=tin;

  if (foco) {
      textbackground (pap); textcolor (tb);

      for (y=cy; y < cy+ly; y++) {
        textbackground (pap); gotoxy (cx, y); putch('');
        }
      for (x=cx+1; x < cx+lx-1; x++) {
        textbackground (banda); gotoxy (x, cy); putch('');
        }

      textcolor (8);

      for (y=cy; y < cy+ly; y++) {
        textbackground (pap); gotoxy (cx+lx-1, y); putch('');
        }
      for (x=cx+1; x < cx+lx-1; x++) {
        textbackground (banda); gotoxy (x, cy+ly-1); putch('');
        }
      }
    else {
      textbackground (pap); textcolor (8);

      for (y=cy; y < cy+ly; y++) {
        textbackground (banda); gotoxy (cx, y); putch('');
        }
      for (x=cx+1; x < cx+lx-1; x++) {
        textbackground (pap); gotoxy (x, cy); putch('');
        }

      textcolor (tb);

      for (y=cy; y < cy+ly; y++) {
        textbackground (banda); gotoxy (cx+lx-1, y); putch('');
        }
      for (x=cx+1; x < cx+lx-1; x++) {
        textbackground (pap); gotoxy (x, cy+ly-1); putch('');
        }
      }

  _wscroll = w;
}


void v3dg (cx, cy, lx, ly, foco, dis, tin, pap, banda)
{
  int  x, y, i;
  char txt[81];

  Marco3dg (cx, cy, lx, ly, foco, tin, pap, banda);
  Marco3dg (cx+dis*2, cy+dis, lx-dis*4, ly-dis*2, foco^1, tin, pap, banda);
  textbackground (banda);

  *txt=0;
  for (x=0; x < lx-2; x++) strcat (txt, " ");
  for (i=0; i<dis-1; i++) {
    gotoxy (cx+1, cy+1+i); cputs(txt);
    gotoxy (cx+1, cy+ly-dis+i); cputs(txt);
    }
  *txt=0;
  for (i=0; i < dis*2-1; i++) strcat (txt, " ");
  for (y=cy+1; y < ly; y++) {
    gotoxy (cx+1, y); cputs(txt);
    gotoxy (cx+lx-2*dis, y); cputs(txt);
    }
  textbackground (pap);
}


void Marco3df (cx, cy, lx, ly, foco, tin, pap)
{
  int tb, x, y, w;

  w = _wscroll; _wscroll=0;

  if (tin<8) tb=tin+8; else tb=tin;

  textbackground (pap); textcolor (foco?tb:8);

  gotoxy (cx, cy); putch('');
  for (y=cy+1; y < cy+ly-1; y++) {
    gotoxy (cx, y); putch('');
    }
  gotoxy (cx, y); putch('');

  for (x=cx+1; x < cx+lx-1; x++) {
    gotoxy (x, cy); putch('');
    }

  textcolor (foco?8:tb);

  gotoxy (cx+lx-1, cy); putch('');
  for (y=cy+1; y < cy+ly-1; y++) {
    gotoxy (cx+lx-1, y); putch('');
    }
  gotoxy (cx+lx-1, y); putch('');

  for (x=cx+1; x < cx+lx-1; x++) {
    gotoxy (x, cy+ly-1); putch('');
    }

  _wscroll = w;
}


void v3df (cx, cy, lx, ly, foco, dis, tin, pap)
{
  Marco3df (cx, cy, lx, ly, foco, tin, pap);
  Marco3df (cx+dis*2, cy+dis, lx-dis*4, ly-dis*2, foco^1, tin, pap);
}


void v3d (cx, cy, lx, ly, dis)
{
  window (cx+dis*2+1, cy+dis+1, cx+lx-dis*2-2, cy+ly-dis-2);
}


void boton (int cx, int cy, int borde, int ttex, int t, int p, char *texto)
{
  int tb, tt;

  if (borde<8) { tb=borde+8; tt=borde;} else { tb=borde; tt=borde-8; }

  gotoxy (cx, cy);
  textbackground (tt); textcolor (tb); putch ('');
  textcolor (ttex); cputs (texto);
  textcolor (8); putch ('');
  textcolor (t); textbackground (p);
}


int input (char *cad, int modo, int maxcar, int tinta, int papel)
{
  int x, y, t, i, px, primeravez=1;
  static insercion=1;

  x=wherex(); y=wherey(); px = strlen (cad);

  gotoxy (x, y);
  textcolor (tinta+BLINK); textbackground (papel);
  cputs (cad);
  textcolor (tinta); for (i=px; i<maxcar; i++) putch(' ');
  gotoxy (x+px, y);

  do {
    if (insercion)
        _setcursortype (_NORMALCURSOR);
      else
        _setcursortype (_SOLIDCURSOR);
    if (!(t=getch())) t = getch() << 8;
    if ((primeravez) && (t!=8) && (t!=13) && (t<256)) cad[0]=px=0;
    primeravez=0;
    switch (t) {
      case 0x4B00: if (px) px--; break;
      case 0x4D00: if (px < strlen(cad)) px++; break;
      case 8:      if (px)
                     for (i=--px; i<=strlen(cad); i++) cad[i]=cad[i+1];
                   break;
      case 0x5300: for (i=px; i<=strlen(cad); i++) cad[i]=cad[i+1]; break;
      case 0x4700: px=0; break;
      case 0x4F00: px = strlen(cad); break;
      case 0x5200: insercion ^= 1;
      default:     if(
                       (t>=32) && (t<256) && (
                         (modo==0) ||
                         ((modo==1) && (t>='0') && (t<='9')) ||
                         ((modo==2) && (
                           ((t>='0') && (t<='9')) ||  /* Modo 0: Asc */
                           ((t>='a') && (t<='f')) ||  /* Modo 1: Dec */
                           ((t>='A') && (t<='F'))     /* Modo 2: Hex */
                           )
                         )
                       )
                     )
                     if (!insercion) {
                         if (px < maxcar) {
                           cad[strlen(cad)+1]=0;
                           cad[px++]=t;
                           }
                         }
                       else
                         if (strlen(cad) < maxcar) {
                           for (i=strlen(cad); i>=px; i--) cad[i+1]=cad[i];
                           cad[i+1]=t; px++;
                           }
                   break;
      }
    gotoxy (x, y); for (i=0; i<maxcar; i++) putch(' ');
    gotoxy (x, y); cputs (cad); gotoxy (x+px, y);
  } while ((t!=13) && (t!=27));

  if ((t==13) && (strlen(cad)==0)) t=27;  /* campo vaco -> ESC */

  return (t==13);
}


char *dec2str (unsigned num)
{
  static char cad[32];

  if (num >= 10) { cad[0]=num/10+'0'; num %= 10; } else cad[0]='0';
  cad[1]=num+'0';
  cad[2]=0;

  return (cad);
}


char *dec2strq (unsigned num)
{
  char *p;

  p=dec2str(num);
  if (*p=='0') p++;
  return (p);
}


char *dec3str (unsigned num)
{
  static char cad[32];
  int    i;

  if (num >= 100) { cad[0]=num/100+'0'; num %= 100; } else cad[0]='0';
  if (num >= 10) { cad[1]=num/10+'0'; num %= 10; } else cad[1]='0';
  cad[2]=num+'0';
  cad[3]=0;

  for (i=0; (i<2) && (cad[i]=='0'); i++) cad[i]=' ';

  return (cad);
}


char *dec3strq (unsigned num)
{
  char *p;

  p=dec3str(num);
  while (*p==' ') p++;
  return (p);
}


char *dec5str (unsigned num)
{
  static char cad[32];
  int    i;

  if (num >= 10000) { cad[0]=num/10000+'0'; num %= 10000; } else cad[0]='0';
  if (num >= 1000) { cad[1]=num/1000+'0'; num %= 1000; } else cad[1]='0';
  if (num >= 100) { cad[2]=num/100+'0'; num %= 100; } else cad[2]='0';
  if (num >= 10) { cad[3]=num/10+'0'; num %= 10; } else cad[3]='0';
  cad[4]=num+'0';
  cad[5]=0;

  for (i=0; (i<4) && (cad[i]=='0'); i++) cad[i]=' ';

  return (cad);
}


char *dec5strq (unsigned num)
{
  char *p;

  p=dec5str(num);
  while (*p==' ') p++;
  return (p);
}


int TipoDrive (int unidad)
{
  union REGS r;

  r.h.ah=8; r.h.dl=unidad; r.h.bl = 255;
  int86 (0x13, &r, &r);

  if ((r.x.flags & 1) || (r.h.bl==255)) return (-1);
  else return ((unsigned char) r.h.bl);
}


int HablaSp()       /* devolver 1 si mensajes en castellano */
{
  union REGS r; struct SREGS s;
  char info[64];
  int i, idioma, spl[]={54, 591, 57, 506, 56, 593, 503, 34, 63, 502,
             504, 212, 52, 505, 507, 595, 51, 80, 508, 598, 58, 3, 0};

  idioma=0;          /* supuesto el ingls */

  if (_osmajor>=3) {
    r.x.ax=0x3800; s.ds=FP_SEG(info); r.x.dx=FP_OFF(info);
    intdosx (&r, &r, &s);
    i=0; while (spl[i++]) if (spl[i-1]==r.x.bx) idioma=1;
    }

  return (idioma);
}


void main (int argc, char *argv[])
{
  Parametros cmd;
  int        NoDemo;

  sp = HablaSp();

  ProcesaParametros (argc, argv, &cmd);
  if (cmd.Ayuda) Ayuda();

  Vram (PRESERVAR);

  NoDemo = cmd.NoDemo || cmd.Modo765 || cmd.ModoTest;

  if (!NoDemo && (!(*KeybShifts & 3)))
    if (ExisteVga() && !cmd.ModoTxt) {
        if (!(NoDemo = VgaPantallaIni())) /* posible fallo de la funcin */
        do getch(); while (kbhit());
        }
      else {
        TxtPantallaIni();
        do getch(); while (kbhit());
        }

  Vram (RESTAURAR);
  Vram (PRESERVAR);

  if (cmd.ModoTest) fdtr (1, cmd.Unidad);
  else if (cmd.Modo765) debug765();
  else if (VerFicheroDoc (ruta, FICH_DOC, FICH_IDX, &cmd)) NoDemo=1;

  if (!NoDemo) {
      Vram (MOSTRAR);
      Trampa (INICIO);
      if (ExisteVga() && !cmd.ModoTxt)
          VgaPantallaFin();
        else
          TxtPantallaFin();

      Tecla();

      Vram (RESTAURAR);
      Trampa (FIN);
      }
    else Vram (RESTAURAR);
}
