;
; *** Listing 13-4 ***
;
; Negates several 32-bit values with non-branching code.
;
	jmp	Skip
;
; Negates a 32-bit value.
;
; Input:
;	DX:AX = 32-bit value to negate
;
; Output:
;	DX:AX = negated 32-bit value
;
; Registers altered: AX, DX
;
Negate32Bits:
	neg	dx
	neg	ax
	sbb	dx,0
	ret
;
Skip:
	call	ZTimerOn
; First, negate zero.
	sub	dx,dx
	mov	ax,dx	;0
	call	Negate32Bits
; Next, negate 1 through 50.
X=1
	rept	50
	sub	dx,dx
	mov	ax,X
	call	Negate32Bits
X=X+1
	endm
; Finally, negate -1 through -50.
X=-1
	rept	50
	mov	dx,0ffffh
	mov	ax,X
	call	Negate32Bits
X=X-1
	endm
	call	ZTimerOff
