#include	"puzz.h"

/************************************************************************
 * Function type declarations						*
 ************************************************************************/

void	disp_init(), disp_uninit(), disp_box(), disp_clear(), disp_edit();
void	boxscreen(), disp_clrkeys(), disp_keys(), zoom_bem(), key_label();
void	disp_clrfield(), disp_edit_bem(), zoom_cursor(), bem_cursor();
void	disp_edit_bem_image(), disp_edit_bem_name();
void	clear_bem(), copy_bem(), disp_bem(), save_source(), load_source();


/************************************************************************
 * DISP_INIT()								*
 ************************************************************************/

void	disp_init() {

	int	i;

	if(!setmode(0x10)) {
		printf("only EGA right now.  sorry...\n");
		exit(1);
	}
	for(i=0; i<16; i++) {
		setcolors(i, palette[i]);
	}
}

/************************************************************************
 * DISP_UNINIT()							*
 ************************************************************************/

void	disp_uninit() {

	setmode(3);
}

/************************************************************************
 * DISP_BOX()								*
 ************************************************************************/

void	disp_box(x1, y1, x2, y2, color, rule)
unsigned	x1, y1, x2, y2, color, rule;
{
	unsigned t;

	if(x1>x2) {
		t  = x1;
		x1 = x2;
		x2 = t;
	}
	if(y1>y2) {
		t  = y1;
		y1 = y2;
		y2 = t;
	}
	horline(x1+1,y1,x2,color,rule);
	verline(x2,y1+1,y2,color,rule);
	horline(x2-1,y2,x1,color,rule);
	verline(x1,y2-1,y1,color,rule);
}


/************************************************************************
 * DISP_CLEAR()								*
 ************************************************************************/

void	disp_clear() {

	clrscreen(CLRBACKGROUND);
	boxscreen();
}

/************************************************************************
 * BOXSCREEN()								*
 ************************************************************************/

void	boxscreen() {

	int	i;

	disp_box(0, 0, 639, 349, CLRBORDER1, 0);
	disp_box(2, 2, 637, 347, CLRBORDER1, 0);
	for(i=1; i<639; i += 2) {
		plotxy(i,   1, CLRBORDER2, 0);
		plotxy(i, 348, CLRBORDER2, 0);
	}
	for(i=3; i<348; i += 2) {
		plotxy(  1, i, CLRBORDER2, 0);
		plotxy(638, i, CLRBORDER2, 0);
	}
	flabel(320-3*41,349," BEdit  1.0   Copyright 1987  Everett Kaser ", CLRBORDER2, 0, 0);
}

/************************************************************************
 * BEEP()								*
 ************************************************************************/

void	beep(freq, dur)
int	freq, dur;
{
	int	i;

	beepon(freq);
	for(i=0; i<dur && !iskey(); i++) ;
	beepoff();
}


/************************************************************************
 * DISP_EDIT()								*
 ************************************************************************/

void	disp_edit() {

	int	i, j;

destart:
	disp_clear();
	for(i=0; i<16; i++) {
		disp_box(8+39*i, 320, 44+39*i, 341, 15, 0);
		for(j=321; j<341; j++) horline(9+39*i, j, 43+39*i, i, 0);
	}
	disp_box(XFIELD, YFIELD, XFIELD+609, YFIELD+289, 15, 0);
	disp_keys(0);
/*	disp_set();*/
	while(1) {
		i = key();
		switch(i) {
			case 0x4800:	/* up arrow */
				break;
			case 0x5000:	/* dn arrow */
				break;
			case 0x4b00:	/* lf arrow */
				break;
			case 0x4d00:	/* rt arrow */
				break;
			case 0x3b00:	/* F1 */
				disp_edit_bem();
				disp_clrfield();
/*				disp_set();*/
				disp_keys(0);
				break;
			case 0x3c00:	/* F2 */
/*				disp_edit_set();*/
				disp_keys(0);
				break;
			case 0x3f00:	/* F5 SAVE */
				save_source();
				break;
			case 0x4000:	/* F6 LOAD */
				load_source();
				goto destart;
				break;
			case 0x4200:	/* F8 */
				return;
				break;
			default:
				beep(14000, 400);
				break;
		}
	}
}

/************************************************************************
 * DISP_KEYS()								*
 ************************************************************************/

void	disp_keys(keyset)
int	keyset;
{
	int	i;

	disp_clrkeys();
	for(i=0; i<9; i++) {
		if(i != 4) disp_box(14+68*i, 5, 77+68*i, 17, 15, 0);
	}
	switch(keyset) {
		case 0:
			key_label(0, " edit BEM ", 15, 1);
			key_label(5, "   SAVE   ", 15, 1);
			key_label(6, "   LOAD   ", 15, 1);
			key_label(8, "   EXIT   ",  0, 2);
			break;
		case 1:
			key_label(0, "edit IMAGE", 15, 1);
			key_label(5, "   FLIP   ", 15, 1);
			key_label(6, " REVERSE  ", 15, 1);
			key_label(8, "   DONE   ",  0, 1);
			break;
		case 2:
			key_label(0, " <- color ", 15, 1);
			key_label(1, " color -> ", 15, 1);
			key_label(2, "plot PIXEL", 15, 1);
			key_label(5, " SNAPSHOT ", 15, 1);
			key_label(6, " clear BEM", 15, 1);
			key_label(7, " copy BEM ", 15, 1);
			key_label(8, "   DONE   ",  0, 1);
			break;
		case 4:
			key_label(0, "<-BemCLASS", 15, 1);
			key_label(1, "BemCLASS->", 15, 1);
			key_label(2, "PLACE Bem ", 15, 1);
			key_label(3, "ERASE Bem ", 15, 1);
			key_label(5, "Hero START", 15, 1);
			key_label(6, " Hero END ", 15, 1);
			key_label(7, "CLEAR set ", 15, 1);
			key_label(8, "   DONE   ",  0, 1);
			break;
		default:
			key_label(4, "BAD KEYSET", 15, 2);
			break;
	}
}


/************************************************************************
 * KEY_LABEL()								*
 ************************************************************************/
void	key_label(keynumb, str, forecolor, backcolor)
int	keynumb, forecolor, backcolor;
char	*str;
{
	flabel(16+68*keynumb, 14, str, forecolor, backcolor, 0);
	line(16+68*keynumb, 15, 75+68*keynumb, 15, backcolor, 0);
}


/************************************************************************
 * DISP_CLRKEYS()							*
 ************************************************************************/

void	disp_clrkeys() {

	int	i;

	for(i=5; i<18; i++) horline(14, i, 621, 0, 0);
}


/************************************************************************
 * DISP_CLRFIELD()							*
 ************************************************************************/

void	disp_clrfield() {

	int	i;

	for(i=YFIELD+1; i<YFIELD+289; i++) horline(XFIELD+1, i, XFIELD+608, 0, 0);
}


/************************************************************************
 * DISP_EDIT_BEM()							*
 ************************************************************************/

void	disp_edit_bem() {

	int	i, j, k;
	char	c;

	disp_clrfield();
/*	disp_box(XFIELD+327,YFIELD+5, XFIELD+603, YFIELD+283, CLRZOOM, 0);*/
	for(i=0; i<=lastbem; i++) {
		disp_bem(i);
	}
	for(i=0; i<16; i++) {
		for(j=0; j<16; j++) {
			disp_box(XFIELD+10+i*8,YFIELD+5+j*8,XFIELD+18+i*8,YFIELD+13+j*8,CLRZOOM,3);
			disp_box(XFIELD+146+i*8,YFIELD+5+j*8,XFIELD+154+i*8,YFIELD+13+j*8,CLRZOOM,3);
		}
	}
	zoom_bem(0);
	disp_keys(1);
	while(1) {
		bem_cursor();
		i = key();
		bem_cursor();
		switch(i) {
			case 0x4800:	/* up arrow */
				if(--curbem < 0) curbem = lastbem;
				zoom_bem(0);
				break;
			case 0x5000:	/* dn arrow */
				if(++curbem > lastbem) curbem = 0;
				zoom_bem(0);
				break;
			case 0x4b00:	/* lf arrow */
				curbem -= 8;
				if( curbem < 0 ) {
					while( curbem <= lastbem) curbem += 8;
					curbem -= 8;
				}
				zoom_bem(0);
				break;
			case 0x4d00:	/* rt arrow */
				if( (curbem += 8) > lastbem) {
					while( curbem >= 0) curbem -= 8;
					curbem += 8;
				}
				zoom_bem(0);
				break;
			case 0x3b00:	/* F1  edit image */
				bem_cursor();
				disp_edit_bem_image();
				bem_cursor();
				disp_keys(1);
				break;
			case 0x3f00:	/* F5 flip */
				for(i=0; i<8; i++) {
					for(j=0; j<16; j++) {
						c = bems[curbem].image[i][j];
						bems[curbem].image[i][j] = bems[curbem].image[15-i][j];
						bems[curbem].image[15-i][j] = c;
					}
				}
				zoom_bem(0);
				break;
			case 0x4000:	/* F6 reverse */
				for(i=0; i<16; i++) {
					for(j=0; j<8; j++) {
						c = bems[curbem].image[i][j];
						bems[curbem].image[i][j] = bems[curbem].image[i][15-j];
						bems[curbem].image[i][15-j] = c;
					}
				}
				zoom_bem(0);
				break;
			case 0x4200:	/* F8 */
				return;
			default:
				break;
		}
	}
}


/************************************************************************
 * DISP_EDIT_BEM_IMAGE()						*
 ************************************************************************/

void	disp_edit_bem_image() {

	int	i, j;

	disp_keys(2);
	while(1) {
		zoom_cursor();
		i = key();
		zoom_cursor();
		switch(i) {
			case 0x4800:	/* up arrow */
				if(bemy) --bemy;
				break;
			case 0x5000:	/* dn arrow */
				if(bemy<15) ++bemy;
				break;
			case 0x4b00:	/* lf arrow */
				if(bemx) --bemx;
				break;
			case 0x4d00:	/* rt arrow */
				if(bemx<15) ++bemx;
				break;
			case 0x3b00:	/* F1 <-color */
				if(--curcolor < 0 ) curcolor = 15;
				break;
			case 0x3c00:	/* F2 color-> */
				if(++curcolor >15 ) curcolor = 0;
				break;
			case 0x3d00:	/* F3 set pixel */
				bems[curbem].image[bemy][bemx] = curcolor;
bplotxy(XFIELD+11+8*bemx,YFIELD+12+8*(15-bemy),7,7,colors[bems[curbem].image[bemy][bemx]],0);
				disp_bem(curbem);
				break;
			case 0x3f00:	/* F5 snapshot */
				for(i=0; i<16; i++)
					for(j=0; j<16; j++)
						snapshot[i][j] = bems[curbem].image[i][j];
				zoom_bem(1);
				break;
			case 0x4000:	/* F6 clear bem */
				clear_bem();
				break;
			case 0x4100:	/* F7 copy bem */
				copy_bem();
				break;
			case 0x4200:	/* F8 */
				return;
			default:
				putch('\007');
				break;
		}
	}
}

/************************************************************************
 * ZOOM_CURSOR()							*
 ************************************************************************/

void	zoom_cursor() {

	int	row, col;

	row = YFIELD+15*8+6-bemy*8;
	col = XFIELD+11+8*bemx;
	line(col, row+3, col+6, row+3, 11,3);
	line(col+3, row, col+3, row+6, 11,3);
	flabel(25+39*curcolor,319,"*",15,0,3);
}

/************************************************************************
 * BEM_CURSOR()								*
 ************************************************************************/

void	bem_cursor() {

	int	row, col;

	row = YFIELD+263-18*(curbem%8);
	col = XFIELD+8+80*(curbem/8);
	disp_box(col, row, col+19, row+19, CLRBORDER2, 3);
}


/************************************************************************
 * ZOOM_BEM()								*
 ************************************************************************/

void	zoom_bem(zoomsnap)
int	zoomsnap;
{

	int	i, j, k;
	char	*p;

	if(!zoomsnap) {
		k = XFIELD+11;
		if( (i=iskey())==0x4b00 || i==0x4d00 || i==0x4800 || i==0x5000) return;
	} else {
		k = XFIELD+147;
	}
	for(i=0; i<16; i++) {
		for(j=15; j>=0; j--) {
			if(!zoomsnap)	p = colors[bems[curbem].image[15-j][i]];
			else		p = colors[snapshot[15-j][i]];
			bplotxy(k+8*i,YFIELD+12+8*j,7,7,p,0);
		}
	}
}


/************************************************************************
 * SHOW_BUFF()								*
 ************************************************************************/

void	show_buff(x, y, s, s1, c)
int	x,y,s1,c;
char	*s;
{
	char	t[2];

	flabel(x+6*s1, y, s+s1, 15, 0, 0);
	flabel(x+6*strlen(s),y,"  ",15,0,0);
	if(insmode) {
	if( '\0' == (t[0] = *(s+c)) ) t[0] = ' ';
		t[1] = '\0';
		flabel(x+6*c, y, t, 0, 15, 0);
	} else {
		horline(x+6*c, y-7, x+6*c+5, 15, 3);
	}
}


/************************************************************************
 * ENTER()								*
 ************************************************************************/

int	enter(x, y, s, slen, pathflag)
int	x,y,slen,pathflag;
char	*s;
{
	int	i, j, d, k;

	for(i=0; i<slen && *(s+i); i++) ;
	show_buff(x, y, s, 0, i);
	while(1) {
		switch(j=key()) {
			case 0x1c0d:	/* ENTER (cr) */
				return(1);
			case 0x011b:	/* esc */
			case 0x4200:	/* F8 */
				return(0);
			case 0x0e08:	/* backspace */
				if(i) {
					--i;
					if(insmode) {
						for(j=i; j<slen; j++) *(s+j) = *(s+j+1);
					}
					show_buff(x,y,s, i, i);
				}
				break;
			case 0x4b00:	/* lf cursor */
				if(i) --i;
				show_buff(x,y,s, i, i);
				break;
			case 0x4d00:	/* rt cursor */
				if(*(s+i)) {
					++i;
					show_buff(x,y,s, i-1, i);
				}
				break;
			case 0x5200:	/* insert   */
				insmode = 1 & ++insmode;
				show_buff(x,y,s, i, i);
				break;
			case 0x5300:	/* delete   */
				for(j=i; j<slen; j++) *(s+j) = *(s+j+1);
				show_buff(x,y,s, i, i);
				break;
			default:
				if(i==slen) {
					beep(10000,400);
					break;
				}
				j &= 0xff;
				if(pathflag) {
					switch(j) {
					    case '$':
					    case '#':
					    case '&':
					    case '@':
					    case '!':
					    case '%':
					    case '(':
					    case ')':
					    case '-':
					    case '}':
					    case '{':
					    case '_':
					    case '.':
					    case '\\':
					    case ':':
					    case 39:
					    case 96:
goodchar:
						if(insmode) {
							for(k=slen-1; k>=i; k--) *(s+k+1) = *(s+k);
							*(s+slen) = '\0';
						}
						if( i != slen ) {
							*(s+i) = j;
							++i;
						} else beep(10000,400);
						show_buff(x,y,s, i-1, i);
						break;
					    default:
						d = toupper(j & 0xff);
			if( (d>='A' && d<='Z') || (d>='0' && d<='9') ) goto goodchar;
						break;
					}
				} else {
					if(j<' ' || j>127 ) beep(14000,600);
					else {
						*(s+i) = j;
						++i;
						show_buff(x,y,s, i-1, i);
					}
				}
				break;
		} /* end of switch */
	}
}


/************************************************************************
 * COPY_BEM()								*
 ************************************************************************/
void	copy_bem() {

	int	i,j;

	for(i=0; i<16; i++)
		for(j=0; j<16; j++)
			bems[curbem].image[i][j] = snapshot[i][j];
	disp_bem(curbem);
	zoom_bem(0);
}

/************************************************************************
 * CLEAR_BEM()								*
 ************************************************************************/
void	clear_bem() {

	int	i,j;

	for(i=0; i<16; i++)
		for(j=0; j<16; j++)
			bems[curbem].image[i][j] = curcolor;
	disp_bem(curbem);
	zoom_bem(0);
}


/************************************************************************
 * DISP_BEM()								*
 ************************************************************************/

void	disp_bem(i)
int	i;
{
	bplotxy(XFIELD+10+80*(i/8), YFIELD+280-18*(i%8),16,16,bems[i].image,0);
	if(curbem == lastbem  &&  lastbem < 31) ++lastbem;
}


/************************************************************************
 * SAVE_SOURCE()							*
 ************************************************************************/

void	save_source() {

	int	a, b, c, d, i, j, k, result=0, fh, lim;
	unsigned char	temp[260];
	unsigned char	*p, *q;
	unsigned char	im[128], z;

	disp_clrkeys();
	flabel(16, 14, "source pathname:", 15, 0, 0);
	if(enter(16+6*16, 14, source_name, 64, 1)) {
if(-1 == (fh=open(source_name, O_CREAT | O_TRUNC | O_TEXT | O_RDWR, S_IWRITE | S_IREAD))) {
			disp_clrkeys();
			sprintf(temp, "error creating file: %s  ...press <SPACE> to continue...", source_name);
			flabel(16,14, temp, 15, 3, 0);
			key();
		} else {
			disp_clrkeys();
			flabel(16,14, "writing file...",15,0,0);
			lim = (lastbem==31) ? 32 : lastbem;
			for(i=0; i<lim; i++) {
				p = bems[i].image[0];
				q = im;
				for(j=0; j<32; j++) {
					a = b = c = d = 0;
					for(k=0; k<8; k++) {
						z = *p++;
						a = a<<1;
						b = b<<1;
						c = c<<1;
						d = d<<1;
						if( z & 1 ) a |= 1;
						if( z & 2 ) b |= 1;
						if( z & 4 ) c |= 1;
						if( z & 8 ) d |= 1;
					}
					*q      = a;
					*(q+32) = b;
					*(q+64) = c;
					*(q+96) = d;
					++q;
				}
				for(k=0; k<8; k++) {
					result |= outfile("\t\t", fh, result);
					for(j=0; j<16; j++) {
						sprintf(temp, "%d,", im[16*k+j]);
						result |= outfile(temp, fh, result);
					}
					result |= outfile("\n", fh, result);
				}
				result |= outfile("\n", fh, result);
			}
			close(fh);
		}
	}
	disp_keys(0);
}


/************************************************************************
 * OUTFILE()								*
 ************************************************************************/

int	outfile(temp, fh, doitflag)
char	*temp;
int	fh, doitflag;
{
	int	j;
	char	tempbuff[81];

	if(doitflag) return(1);
	j = strlen(temp);
	if( j != write(fh, temp, j) ) {
		j = errno;
		disp_clrkeys();
		if(j==EACCES) flabel(16,14,"ERROR: file is READ_ONLY or LOCKed", 15, 3, 0);
		else if(j==EBADF) flabel(16,14,"ERROR: invalid file handle",15,3,0);
		else if(j==ENOSPC) flabel(16,14,"ERROR: no space on device",15,3,0);
		else flabel(16,14,"ERROR: unknown",15,3,0);
		flabel(16+6*50, 14, "...press <SPACE> to continue...",15,0,0);
		key();
		disp_clrkeys();
		return(1);
	} else {
		return(0);
	}
}

/************************************************************************
 * LOAD_SOURCE()							*
 ************************************************************************/

void	load_source() {

	int	i, j, k, result=0;
	FILE	*fp;
	char	temp[260];
	unsigned char	*p;

	disp_clrkeys();
	flabel(16, 14, "source pathname:", 15, 0, 0);
	if(enter(16+6*16, 14, source_name, 64, 1)) {
		if(NULL == (fp=fopen(source_name, "r"))) {
			disp_clrkeys();
			sprintf(temp, "error opening file: %s  ...press <SPACE> to continue...", source_name);
			flabel(16,14, temp, 15, 3, 0);
			key();
		} else {
			disp_clrkeys();
			flabel(16,14, "reading file...",15,0,0);
			load_bems(fp);
			fclose(fp);
		}
	}
	disp_keys(0);
}


/************************************************************************
 * LOAD_BEM(fh)								*
 ************************************************************************/

int	load_bems(fp)
FILE	*fp;
{
	int	i, j, k, a, b, c, d;
	unsigned char	temp[260], im[128], *p, *q, z, t;

	while(!feof(fp)) {
		p = bems[lastbem].image[0];
		q = im;
		for(i=0; i<128; i++) {
			if(1 != fscanf(fp, " %d , ", &a)) {
				return(-3);
			}
			im[i] = a;
		}
		for(j=0; j<32; j++) {
			a = *q;
			b = *(q+32);
			c = *(q+64);
			d = *(q+96);
			++q;
			for(t=0x80; t; t=t>>1) {
				z = 0;
				if( a & t ) z |= 1;
				if( b & t ) z |= 2;
				if( c & t ) z |= 4;
				if( d & t ) z |= 8;
				*p++ = z;
			}
		}
		if(++lastbem>30) return(i);
	}
}
