PAGE  59,132
TITLE	ASMGEN - An 8086/8087/8088 disassembler
;==========================================================================
;==								         ==
;==			        ASMGEN				         ==
;==								         ==
;==      Created:   3-Jun-85					         ==
;==      Passes:    5	       Analysis Flags on: HIK		         ==
;==								         ==
;==========================================================================
; This disassembly and code revision of ASMGEN was performed by:
;			James E.Galbraith
;			1201 Chase St. 
;			Novato, CA 94945
;
; This source code was generated from the public domain program ASMGEN.COM,
; version 2.01, by using the disassembler program SOURCER.  The disassembly 
; of ASMGEN, using ASMGEN as the disassembler, was used for reference.  Two 
; different disassembler programs were used because they use entirely 
; different strategies, and have somewhat complementary strengths and 
; weaknesses.  Numerous iterations were required before a good disassembly 
; was accomplished.  The phrase "good disassembly" means regenerated source 
; code that can be altered, and then be reassembled to properly executable 
; code.  The simplest test for a good disassembly is to insert a NOP 
; instruction at the beginning of the program or between any arbitrary 
; pair of instructions and then reassemble it.  If the program runs the 
; same as before, then the test may have passed.  Until such a "good 
; disassembly" has been achieved, there must be no changes to any of the 
; address relationships in the program.  The main problems, which must be 
; resolved manually, are usually with immediate operand data values vs. 
; address offsets, and embedded address difference relationships.  
;
; I got this program as a public domain program, and am releasing my 
; modified version back into public domain.  The only operational changes 
; that I made were to make it conform more closely to the description in 
; the ASMGEN.DOC file.  Program code changes were made to remove "hacker" 
; type self-modifying code and to make it easier for someone else to 
; disassemble it in the future.  I have included the original version, 
; along with ASMGEN.SEQ, as an example of an ASMGEN disassembly.
; 
;==========================================================================
;
;	Changes made for Version 3.00.
;
; There are a number of changes that have been made to this program for
; version 3.00.  These changes are in two classes - fixing bugs and cleaning
; up bad code.  This includes what I consider particularly bad "8080 hacker" 
; style code.  Additionally, ASCII string messages have been placed in the 
; program code to indicate the location and nature of "points of interest" 
; for future disassembly.  Addresses listed are from the disassembled 
; version 2.01.  Specific program changes are commented below.
;
; 1.) The term "smoking gun" comes from its use to describe particularly
; damaging evidence in a court trial.  It is used here to describe
; particularly bad coding that would never have been written without
; hostile intent.  The most flagrent example (the "smoking gun") involves
; mucking around with the JMP instruction offset byte at address 0943 by
; various instructions.  The six instructions (at 02FF, 0377, 034A, 0358,
; 03D5, and 03FD) treat the offset byte with disrespect that is completely
; inappropriate to a jump offset byte.  The instruction at 03D5 is a
; DECrement instruction, an operation which is a totally incompatible with
; a JMP instruction offset byte in a variable byte length instruction set.
; These instructions have now been assigned their own byte variable, named
; SMOKING_GUN_0944.
;
; 2.) The altered immediate operand data values have been reassigned as
; conventional bytes or words (as appropriate).  They are initiallized to
; the value that was originally contained in the immediate operand.
;
; 3.) Altered instruction op-codes have been replaced by the use of flag
; bytes and conditional operations.  Such altered op-codes should have died 
; with the 8080.
;
; 4.) A number of TEST (AX,immediate operand) instructions were used to skip
; over the operand word.  The operand word was, itself, executable code and
; the destination of subroutine CALLs.  All such TEST instructions have been
; replaced by JMP SHORT instructions.  This is a "cute trick" that saves one
; byte of code, but makes the intent of the code more obscure until its
; function is deciphered.  If it weren't for the "smoking gun" item, above,
; this could be considered just 8080 style hacker code.
;
; 5.) The assembler directive 'PAGE 58,132' is added just preceding 'TITLE'.
;
; 6.) PATCH83 MACRO has been altered to allow using it correctly with the
; /H switch.  An 'H' is added to the '81' op-code byte.
;
; 7.) PATCH83 MACRO has been altered to allow it to accomodate negative
; numbers.
;
; 8.) The program code has been corrected to make PATCH83 work correctly.  In
; version 2.01 the tests were implemented incorrectly.  The function of PATCH83
; is based on an optimization trick allowed with the 8086/88 instruction set.
; An arithmetic or logical instruction that operates on a 16-bit register
; (other than AX) with an immediate operand, that can be expressed as a sign
; extended 8-bit value, has a shorter alternative instruction form.  This
; optimization is used with MASM 5.0 and 5.1, but not with earlier versions.
; Op-code 81H is for the 4-byte long form, 83H is for the 3-byte short form.  
; PATCH83 is used to force later versions of MASM to generate the longer form 
; so that the program can be reassembled to its original executable code.  
; Until data value vs address offset issues are resolved, it is absolutely 
; essential that code relationships not be altered.
;
;-----------------------------------------------------------------------
; This is the corrected PATCH83 MACRO definition (see symbol MAC_PATCH83).  
; This source code file (ASMGEN3) has been edited to include the three 
; occurences of "PATCH83" that (should) be generated when it is disassembled 
; using ASMGEN.COM.  These are the same ones that occur in ASMGEN version 
; 2.01, although it completely misses the third instance of PATCH83 (at offset 
; 14BC in version 2.01).  This has been done for the benefit of future users 
; of ASMGEN, when they try to disassemble ASMGEN.  It also makes it easier 
; to reassemble using earlier versions of Microsoft MASM than 5.0.
PATCH83	MACRO	X
ORG	$-3
DB	81H
ORG	$+2
DB	X
ENDM
;==========================================================================
;
;	Changes made for Version 3.01.
;
; 9.) The immediate operand value 0FFFF now has an 'H' suffix.  This means 
; that if the /H switch is set, it is no longer necessary to search for each 
; occurence to add an 'H'.  ASMGEN.COM version 2.01 can now be disassembled 
; with the /H switch set, and then reassembled with no severe errors.  There 
; are 116 warning errors, but that is merely MASM's commentary on the quality 
; of the version 2.01 code.
;
; 10.) The 'D' command now works correctly when the /H switch is set.
;
; 11.) INT 20H program termination was replaced with INT 21H Function 4CH, 
; except when running under DOS versions below 2.00, INT 21H Function 0.
;
;=======================================================================
;Program Segment Prefix (PSP) -- address allocation (either .COM or .EXE)
; 0000H, 2-byte = op-code INT 20H, return to DOS (an artifact of CPM)
; 0002H, 1-word = Segment, end of allocation block
; 0004H, 1-byte = Resreved for DOS
; 0005H, = long call to MS-DOS function dispatcher
; 000AH, DWord = prev. contents of termination interrupt vector, INT 22H
; 000EH, DWord = prev. contents of Ctrl-C handler interrupt vector, INT 23H
; 0012H, DWord = prev. contents of critical-error handler vector, INT 24H
; 0016H, 22-byte = Reserved for DOS
; 002CH, 1-word = Segment address of environment block
; 002EH,  -byte = Reserved for DOS
; 005CH, 16-byte = default FCB #1
; 006CH, 16-byte = default FCB #2 (overlaid if FCB #1 opened)
; 0080H, 128-byte = default Disk Transfer Area (buffer)
; 0080H, 1-byte = number of bytes transferred in command tail
; 0081H, 127-byte = command tail buffer area
;-----------------------------------------------------------------------
;Program Header for a .EXE file.
; 0000H, 1-byte = 4DH -- First part of .EXE file signature
; 0001H, 1-byte = 5AH -- Second part of .EXE file signature
; 0002H, 1-word = Length of file MOD 512
; 0004H, 1-word = Size of file in 512-byte pages, including header
; 0006H, 1-word = Number of relocation table items
; 0008H, 1-word = Size of header in paragraphs (16-byte units)
; 000AH, 1-word = Minimum number of paragraphs needed above program
; 000CH, 1-word = Maximum number of paragraphs desired above program
; 000EH, 1-word = Segment displacement of stack module
; 0010H, 1-word = Contents of Stack Pointer at entry
; 0012H, 1-word = Word checksum
; 0014H, 1-word = Contents of IP register at entry (Program Counter)
; 0016H, 1-word = Segment displacement of code module
; 0018H, 1-word = Offset of first relocation item in program
; 001AH, 1-byte = Overlay number (0 for resident part of program)
; 001BH, variable reserved space
;[0018]  Relocation table
;[0006]  variable reserved space (padding for 256-byte alignment)
;[0008]  Data segment(s)
;[0014]  Program segment(s), [0016:0014] is IP at program entry
;[001E]  Stack Segment
;-----------------------------------------------------------------------
;Normal File Control Block (FCB), total length is 37 bytes
;  00H, 1-byte = Drive Identification (not 0FFH)
; +01H, 8-byte = Filename (8-characters, padded with spaces)
; +09H, 3-byte = Extension (3-characters, padded with spaces)
; +0CH, 1-word = Current Block Number
; +0EH, 1-word = Record size
; +10H, 4-byte = FIle size (in bytes)
; +14H, 1-word = Date created/last updated
; +16H, 1-word = Time created/last updated
; +18H, 8-byte = Reserved for DOS
; +20H, 1-byte = Current record number
; +21H, 4-byte = Random Record Number
;-----------------------------------------------------------------------
;Extended File Control Block (FCB), total length is 44 bytes
;  00H, 1-byte = 0FFH
; +01H, 5-byte = Reserved (must be zeros)
; +06H, 1-byte = Attribute byte
; +07H, 1-byte = Drive Identification
; +08H, 8-byte = Filename (8-characters, padded with spaces)
; +10H, 3-byte = Extension (3-characters, padded with spaces)
; +13H, 1-word = Current Block Number
; +15H, 1-word = Record size
; +17H, 4-byte = FIle size (in bytes)
; +1BH, 1-word = Date created/last updated
; +1DH, 1-word = Time created/last updated
; +1FH, 8-byte = Reserved for DOS
; +27H, 1-byte = Current record number
; +28H, 4-byte = Random Record Number
;=======================================================================

DATA_0002_E	EQU	2			; (=0)
;ALTR_W_03A6+1	EQU	3A7H			; (72B5:703A7=0)
;ALTR_OPB_064A+0 EQU	64AH			; (72B5:064A=0C3H)
;ALTR_W_0802+1	EQU	803H			; (72B5:0803=0)
;ALTR_W_08E3+1	EQU	8E4H			; (72B5:08E4=0)
;ALTR_J_B_0943+1 EQU	944H			; (72B5:0944=0AH)
;ALTR_W_0945+1	EQU	946H			; (72B5:0946=0)
;ALTR_W_09A0+1	EQU	9A1H			; (72B5:09A1=0)
;ALTR_W_09E2+1	EQU	9E3H			; (72B5:09E3=0FFFFH)
;ALTR_B_0A0E+2	EQU	0A10H			; (72B5:0A10=40H)
;ALTR_W_0A47+1	EQU	0A48H			; (72B5:0A48=10H)
;ALTR_W_0B2B+1	EQU	0B2CH			; (72B5:0B2C=0)
;ALTR_W_0D37+1	EQU	0D38H			; (72B5:0D38=0)
;ALTR_B_0EF8+1	EQU	0EF9H			; (72B5:0EF9=0)
;ALTR_B_0F47+1	EQU	0F48H			; (72B5:0F48=0)
;ALTR_B_0FBA+1	EQU	0FBBH			; (72B5:0FBB=0)
;ALTR_J_B_1081+1 EQU	1082H			; (72B5:1082=24H)
;ALTR_B_10AA+1	EQU	10ABH			; (72B5:10AB=0)
;ALTR_B_10B6+1	EQU	10B7H			; (72B5:10B7=0)
;ALTR_W_10BC+2	EQU	10BEH			; (72B5:10BE=8888H)
;ALTR_W_1123+1	EQU	1124H			; (72B5:1124=0)
;ALTR_W_1222+1	EQU	1223H			; (72B5:1223=0)
;ALTR_OPW_1965+0 EQU	1965H			; (72B5:1965=0CAFEH)
;ALTR_W_1AC9+1	EQU	1ACAH			; (72B5:1ACA=0)
;DATA_2E9E_E	EQU	2E9EH			; (=0)

;DATA_2E9E_E	EQU	OFFSET LAST_BYTE+19FH
DATA_2E9E_E	EQU	OFFSET DTA4_2C9E+512

CR		EQU	0DH
LF		EQU	0AH

;=======================================================================

SEG_A		SEGMENT
		ASSUME	CS:SEG_A, DS:SEG_A

		ORG	100h
;=======================================================================

ASMGEN		PROC	FAR

START:
		JMP	SHORT BEGIN
;==========================================================================

		DB	' ASMGEN',7,1AH	;name, beep, ctrl-Z (EOF)
OLD_W_03A7	DW	0
OLD_RET_NOP_064A DB	0	;00=RETN, 0FFH=NOP (execute following code)
OLD_W_0803	DW	0
OLD_W_08E4	DW	0
SMOKING_GUN_0944 DB	0	;was altereed byte at 0944
OLD_JUMP_0944	DB	0	;00=jump, 0FFH=no jump
OLD_W_0946	DW	0	;(immediate) operand word/(byte?)
OLD_W_09A1	DW	0
OLD_W_09E3	DW	0FFFFH
OLD_B_0A10	DB	040H
OLD_W_0A48	DW	0010H
OLD_W_0B2C	DW	0
OLD_W_0D38	DW	0
OLD_B_0EF9	DB	0
OLD_B_0F48	DB	0
OLD_B_0FBB	DB	0
OLD_JUMP_1082	DB	0	;00=jump, 0FFH=no jump
OLD_B_10AB	DB	0
OLD_B_10B7	DB	0
OLD_W_10BE	DW	8888H
OLD_W_1124	DW	0
OLD_W_1223	DW	0
OLD_DEC_1965	DB	1	;01=decrement, 00=test for zero
OLD_W_1ACA	DW	0

;==========================================================================

;**DAT_02B9	DB	0
SEQ_FILE_CMDS	DB	0	;(14 bytes in table)
		DB	'/'	; .SEQ switch character
		DB	'I'	; set Initial value for IP
		DB	'A'	; Assume directive
		DB	'X'	; repeat structure
		DB	0, 0
		DB	'D'	; data operand (not label) (resume as code)
		DB	'#'	; defined length string
		DB	'$'	; defined length string
		DB	'S'	; disassemble as ASCII string of characters
		DB	'W'	; disassemble as data words or labels
		DB	'B'	; disassemble as data bytes
		DB	'C'	; disassemble as code

;**DATA_02C7	DB	'MHBTFLERO'	
				; SEQ_SW_BYTES, indexed switch characters 
SEQ_FILE_SWITCH	DB	'M'	; Suppress MACRO library
		DB	'H'	; Append hex 'H'
		DB	'B'	; Generate byte references
		DB	'T'	; Control trace output
		DB	'F'	; 8087 mnemonics
		DB	'L'	; Generate label or number
		DB	'E'	; Embedded references in ASM file
		DB	'R'	; Control TBL output
		DB	'O'	; Control ASM output

;==========================================================================

EXIT_CODE	DB	00, 4CH			; DOS EXIT function code

;==========================================================================
;			Program Code Starts
;==========================================================================

BEGIN:		CLD				; Clear direction
		MOV	SP,OFFSET START

		MOV	AH,30H
		INT	21H			; get DOS version number
		CMP	AL,2
		JAE	DOS_2_UP
		MOV	EXIT_CODE+1,0
DOS_2_UP:
		MOV	AX,DS:DATA_0002_E	; (=0)
		MOV	BX,CS
		SUB	AX,BX
		TEST	AH,0F0H
		JZ	LOC_0115
		MOV	AX,0FFFFH
		JMP	SHORT LOC_0119
LOC_0115:
		MOV	CL,4
		SHL	AX,CL			; Shift w/zeros fill
LOC_0119:
		MOV	DATA_2883,AX		; (=0)
		SUB	AX,DATA_2E9E_E		; (=0)
		JC	LOC_0126
		CMP	AX,100H
		JAE	LOC_012C
LOC_0126:
		MOV	DX,OFFSET MS_INSUFF_MEM	; (72B5:27D9=49H)
		JMP	LOC_0214
LOC_012C:
		MOV	DX,OFFSET INT_23H_ENTRY
		MOV	AX,2523H
		INT	21H			; DOS Services  ah=function 25h
						;  set intrpt vector al to ds:dx
		MOV	SI,81H			; command tail in PSP
		CALL	SCAN_SPTAB_0E3F
		JNZ	LOC_013F
		JMP	LOC_0204
LOC_013F:
		CALL	SUB_056C
		CALL	SCAN_SPTAB_0E3F
		JNZ	LOC_014F
LOC_0147:
		MOV	BYTE PTR FCB4_NAME_2A35,20H	; (72B5:2A35=0AH) ' '
		JMP	LOC_0269
LOC_014F:
		CMP	AL,3BH			; ';'
		JE	LOC_0147
		CALL	SUB_0E37
		MOV	DI,OFFSET FCB1_291C	; 
		MOV	AX,2904H
		INT	21H			; DOS Services  ah=function 29h
						;  parse filenam @ds:si FCBes:di
		CMP	BYTE PTR FCB1_NAME_291D,20H	; (72B5:291D=20H) ' '
		JNE	LOC_017D
		PUSH	SI
		MOV	SI,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		MOV	DI,OFFSET FCB1_291C	; (72B5:291C=0)
		MOV	CX,9
		REP	MOVSB			; Rep when cx >0 Mov [si] to es:[di]
		MOV	SI,OFFSET MS_ASM_2764	; (72B5:2764=41H)
		MOV	DI,OFFSET FCB1_EXT_2925	; (72B5:2925=20H)
		MOV	CX,3
		REP	MOVSB			; Rep when cx >0 Mov [si] to es:[di]
		POP	SI
LOC_017D:
		CALL	SCAN_SPTAB_0E3F
		JZ	LOC_01BD
		CMP	AL,3BH			; ';'
		JE	LOC_01B9
		CALL	SUB_0E37
		MOV	DI,OFFSET FCB2_2942	; (72B5:2942=0)
		MOV	AX,2904H
		INT	21H			; DOS Services  ah=function 29h
						;  parse filenam @ds:si FCBes:di
		CMP	BYTE PTR FCB2_NAME_2943,20H	; (72B5:2943=20H) ' '
		JNE	LOC_01B0
		PUSH	SI
		MOV	SI,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		MOV	DI,OFFSET FCB2_2942	; (72B5:2942=0)
		MOV	CX,9
		REP	MOVSB			; Rep when cx >0 Mov [si] to es:[di]
		MOV	SI,OFFSET MS_TBL_276E	; (72B5:276E=54H)
		MOV	DI,OFFSET FCB2_EXT_294B	; (72B5:294B=20H)
		MOV	CX,3
		REP	MOVSB			; Rep when cx >0 Mov [si] to es:[di]
		POP	SI
LOC_01B0:
		CALL	SCAN_SPTAB_0E3F
		JZ	LOC_01BD
		CMP	AL,3BH			; ';'
		JNE	LOC_0211
LOC_01B9:
		DEC	DATA_286F		; (=0)
LOC_01BD:
		MOV	SI,OFFSET FCB1_NAME_291D	; (72B5:291D=20H)
		MOV	DI,OFFSET MS_NUL_2767	; (72B5:2767=4EH)
		MOV	CX,4
		REPE	CMPSB			; Rep zf=1+cx >0 Cmp [si] to es:[di]
		JNZ	LOC_01D1
		CMP	BYTE PTR FCB1_FILSZ_292C,20H	; (72B5:292C=20H) ' '
		JE	LOC_01EB
LOC_01D1:
		CMP	BYTE PTR FCB1_NAME_291D,20H	; (72B5:291D=20H) ' '
		JE	LOC_01EB
		MOV	BYTE PTR DATA_2862,41H	; (=0) 'A'
		MOV	SI,OFFSET FCB1_291C	; (72B5:291C=0)
		MOV	DI,OFFSET FCB4_2A34	; (72B5:2A34=0DH)
		MOV	CX,24H			; 36 decimal
		REP	MOVSB			; Rep when cx >0 Mov [si] to es:[di]
		CALL	SUB_0714
LOC_01EB:
		CMP	BYTE PTR FCB2_NAME_2943,20H	; (72B5:2943=20H) ' '
		JE	LOC_0226
		MOV	BYTE PTR DATA_2862,52H	; (=0) 'R'
		MOV	SI,OFFSET FCB2_2942	; (72B5:2942=0)
		MOV	DI,OFFSET FCB4_2A34	; (72B5:2A34=0DH)
		MOV	CX,24H			; 36 decimal
		REP	MOVSB			; Rep when cx >0 Mov [si] to es:[di]
		JMP	SHORT LOC_0269
LOC_0204:
;**CHANGED**	MOV	DX,OFFSET MS_PC_DASM_2969	; (72B5:2969=54H)
		MOV	DX,OFFSET MS_PC_DISASMB	; (72B5:2969=54H)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		CALL	SUB_06F1
		JMP	SHORT LOC_0287
	;***	DB	90H
LOC_0211:
		MOV	DX,OFFSET MS_INVALID_CMD	; (72B5:27ED=49H)

ASMGEN		ENDP

;==========================================================================
;         Output Beep and error message DX
;==========================================================================

DSPY_ER_DX_0214	PROC	NEAR
LOC_0214:
		MOV	SP,OFFSET START
		MOV	AL,7
		CALL	DSPY_CHR_AL_070
LOC_021C:
		CALL	DSPY_CRLF_06FB
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
LOC_0223:
		CALL	DSPY_CRLF_06FB
LOC_0226:
		TEST	BYTE PTR DATA_286F,0FFH	; (=0)
		JNZ	LOC_0290		; INT 20H program terminate
		CLD				; Clear direction
		MOV	SP,OFFSET START
		MOV	DX,OFFSET MS_PROMPT_XARQ ; (=58H)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		MOV	SI,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		CALL	SUB_06B1
		MOV	DX,OFFSET DATA_2627	; (=3EH)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		CALL	SUB_06F1
		CALL	SCAN_SPTAB_0E3F
		JZ	LOC_0226
		LODSB				; String [si] to al
		AND	AL,5FH			; clear bit-5, strip case
		MOV	DATA_2862,AL		; (=0)
		MOV	DI,OFFSET FCB4_2A34	; (72B5:2A34=0DH)
		CMP	AL,41H			; 'A'
		JNE	LOC_0262
		CALL	SUB_053A
		CALL	SUB_0714
		JMP	SHORT LOC_0226
LOC_0262:
		CMP	AL,52H			; 'R'
		JNE	LOC_0283
		CALL	SUB_053A
LOC_0269:
		CMP	BYTE PTR DATA_2861,2	; (=0)
		JE	LOC_0277
		PUSH	DI
		PUSH	SI
		CALL	SUB_071B
		POP	SI
		POP	DI
LOC_0277:
		CMP	BYTE PTR FCB4_NAME_2A35,20H	; (72B5:2A35=0AH) ' '
		JE	LOC_0226
		CALL	SUB_0B4A
		JMP	SHORT LOC_0226
LOC_0283:
		CMP	AL,58H			; 'X'
		JNE	LOC_028C
LOC_0287:
		CALL	SUB_056C
		JMP	SHORT LOC_0226

LOC_028C:					; Is it "Q" for QUIT?
		CMP	AL,51H			; 'Q'
		JNE	LOC_0211
LOC_0290:
;**CHANGED**	INT	20H			; Program Terminate
		MOV	AX,WORD PTR EXIT_CODE
		INT	21H			; Program Terminate

DSPY_ER_DX_0214	ENDP


;==========================================================================
;
;			External Entry Point
;
;==========================================================================

INT_23H_ENTRY	PROC	FAR
		STI				; Enable interrupts
		PUSH	CS
		POP	SS
		MOV	SP,OFFSET START
		PUSH	CS
		POP	DS
		PUSH	CS
		POP	ES
		CALL	DSPY_CRLF_06FB
		CALL	SUB_064A
		CMP	BYTE PTR DATA_2861,2	; (=0)
		JE	LOC_02AC
		CALL	SUB_0572
LOC_02AC:
;**CHANGED**	MOV	DX,OFFSET DATA_268E	; (72B5:268E=0DH)
		MOV	DX,OFFSET MS_CRLF_$	; (72B5:268E=0DH)
		TEST	BYTE PTR DATA_286F,0FFH	; (=0)
		JNZ	LOC_0290		; INT 20H, program terminate
		JMP	LOC_021C		; display CR LF
INT_23H_ENTRY	ENDP

;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_02D0	PROC	NEAR
LOC_02D0:
		MOV	AL,0FFH
;**CHANGED**	MOV	DI,OFFSET DATA_2870	; (=0FFH)
		MOV	DI,OFFSET SEQ_SW_BYTES	; (=0FFH)
		MOV	CX,9
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		MOV	SI,OFFSET MAC_PATCH83	; (72B5:24E0=0)
LOC_02DD:
		LODSB				; String [si] to al
		CMP	AL,0FFH
		JE	LOC_02EC
		CMP	AL,1
		JA	LOC_02DD
		MOV	BYTE PTR [SI-1],0
		JMP	SHORT LOC_02DD
LOC_02EC:
		PUSH	WORD PTR FCB3_EXT_2A17	; (72B5:2A17=7261H)
		PUSH	WORD PTR FCB3_EXT2_2A19	; (72B5:2A19=2079H)
		MOV	SI,OFFSET MS_SEQ_276B	; (72B5:276B=53H)
		MOV	DI,OFFSET FCB3_EXT1_2A18	; (72B5:2A18=72H)
		MOV	CX,3
		REP	MOVSB			; Rep when cx >0 Mov [si] to es:[di]
;**CHANGED**	MOV	DS:ALTR_J_B_0943+1,CL	; (72B5:0944=0AH)
		MOV	DS:SMOKING_GUN_0944,CL	; (72B5:0944=0AH)
		CALL	SUB_0E00
		MOV	DI,DATA_2E9E_E		; (=0)
		JNC	LOC_0314
LOC_030B:
		POP	WORD PTR FCB3_EXT2_2A19	; (72B5:2A19=2079H)
		POP	WORD PTR FCB3_EXT_2A17	; (72B5:2A17=7261H)
		RETN
LOC_0314:
		MOV	AX,WORD PTR FCB3_FILSZ_2A1F	; (72B5:2A1F=2058H)
		MOV	DATA_284D,AX		; (72B5:284D=0)
		MOV	BX,5
		XOR	CX,CX
LOC_031F:
		CALL	SUB_04BE
		DEC	BX
		JP	LOC_031F		; Jump if parity=1
;**CHANGED**	MOV	DS:ALTR_W_03A6+1,CX	; (72B5:03A7=0)
		MOV	DS:OLD_W_03A7,CX	; (72B5:03A7=0)
LOC_0329:
		CALL	SUB_04D7
		JC	LOC_030B
		CALL	RD_SK_SPTB_1238
		CMP	AL,61H			; 'a' 
		JB	LOC_0337
		AND	AL,5FH			; clear bit-5, strip case
LOC_0337:
;**CHANGED**	CMP	BYTE PTR DS:ALTR_J_B_0943+1,0FFH	; (72B5:0944=0AH)
		CMP	BYTE PTR DS:SMOKING_GUN_0944,0FFH	; (72B5:0944=0AH)
		JE	LOC_03B5
		PUSH	DI
;**CHANGED**	MOV	DI,OFFSET DAT_02B9	; (72B5:02B9=0)
		MOV	DI,OFFSET SEQ_FILE_CMDS	; .SEQ file commands (table)
		MOV	CX,0EH			; (14 bytes in table)
		REPNE	SCASB			; Rep zf=0+cx >0 Scan es:[di] for al
		POP	DI
		JNZ	ALTR_W_03A6		; jump if char not in table
;**CHANGED**	CMP	BYTE PTR DS:ALTR_J_B_0943+1,0C0H	; (72B5:0944=0AH)
		CMP	BYTE PTR DS:SMOKING_GUN_0944,0C0H	; (72B5:0944=0AH)
		JNE	LOC_0354
		JMP	LOC_03EB
LOC_0354:
		CMP	AL,58H			; 'X' .SEQ repeating structure
		JNE	LOC_0360
;**CHANGED**	MOV	BYTE PTR DS:ALTR_J_B_0943+1,0C0H	; (72B5:0944=0AH)
		MOV	BYTE PTR DS:SMOKING_GUN_0944,0C0H	; (72B5:0944=0AH)
		JMP	LOC_03F8
LOC_0360:
		CMP	AL,2FH			; '/' .SEQ switch character?
		JNE	LOC_03D1		; if not, jump and try command
		CALL	RD_NXT_BYT_1B1B		; check for .SEQ file switches
		CMP	AL,61H			; 'a' 
		JB	LOC_036D
		AND	AL,5FH			; clear bit-5, strip case
LOC_036D:
		PUSH	DI
;**CHANGED**	MOV	DI,OFFSET DATA_02C7	; (=4DH)
		MOV	DI,OFFSET SEQ_FILE_SWITCH
		MOV	CX,9			; scan for switch character
		REPNE	SCASB			; Rep zf=0+cx >0 Scan es:[di] for al
		POP	DI
		JNZ	ALTR_W_03A6		; jump if switch not found
		XCHG	BX,CX
		CALL	RD_NXT_BYT_1B1B
		CMP	BX,7			; BX is switch index value
		JAE	LOC_039E
;**CHANGED**	NOT	DATA_2870[BX]		; (=0FFH)
		NOT	SEQ_SW_BYTES[BX]	; (=0FFH)
		MOV	AH,0FFH			; switch ON value
		CMP	AL,2BH			; '+' is it plus?
		JE	LOC_0393		; if yes, set switch
		CMP	AL,2DH			; '-' is it minus?
		JNE	LOC_0397		; if not minus, jump
		MOV	AH,0			; switch OFF value
LOC_0393:
;**CHANGED**	MOV	DATA_2870[BX],AH	; (=0FFH)
		MOV	SEQ_SW_BYTES[BX],AH	; write indexed switch value
LOC_0397:
		PUSH	AX
		CALL	SUB_04BE
		POP	AX
		JMP	SHORT LOC_03A3
LOC_039E:
;**CHANGED**	MOV	BYTE PTR DATA_2870[BX],0	; (=0FFH)
		MOV	BYTE PTR SEQ_SW_BYTES[BX],0	; (=0FFH)
LOC_03A3:
		JMP	LOC_0497
;-----------------------------------------------
; switch character not found
ALTR_W_03A6:
;**CHANGED**	MOV	DX,0
		MOV	DX,OLD_W_03A7
		MOV	DI,OFFSET DATA_270C	; (72B5:270C=30H)
		CALL	CNV_W_2_HX_151D
		MOV	DX,OFFSET MS_ERR_SEQ_26E0	; (72B5:26E0=55H)
		JMP	LOC_0214
LOC_03B5:
		MOV	CL,AL
		CALL	RD_NXT_BYT_1B1B
		AND	AL,5FH			; clear bit-5, strip case
		MOV	AH,AL
		MOV	AL,CL
		PUSH	DI
		MOV	DI,OFFSET SEG_REGS_24BB	; (72B5:24BB=45H)
		MOV	CX,4
		REPNE	SCASW			; Rep zf=0+cx >0 Scan es:[di] for ax
		POP	DI
		JNZ	ALTR_W_03A6
		ADD	CL,10H
		JMP	SHORT LOC_03F8
;-----------------------------------------------
LOC_03D1:
		CMP	AL,41H			; 'A' Assume directive
		JNE	LOC_03DB
;**CHANGED**	DEC	BYTE PTR DS:ALTR_J_B_0943+1	; (72B5:0944=0AH)
		DEC	BYTE PTR DS:SMOKING_GUN_0944	; (72B5:0944=0AH)
		JMP	SHORT LOC_03F8
LOC_03DB:
		CMP	AL,49H			; 'I' Initial value for IP
		JNE	LOC_03F8
		MOV	DATA_285A,BX		; (=0)
		MOV	BYTE PTR DATA_286D,0FFH	; (=0)
		JMP	LOC_049B

LOC_03EB:
		CMP	CL,1			; 7 SEQ commands
		JB	ALTR_W_03A6
		CMP	CL,8
		JA	ALTR_W_03A6
		OR	CL,40H			; '@' make 41H thru 48H
LOC_03F8:
		MOV	AH,4			; 4 bytes to store
		CALL	SUB_0F6C
;**CHANGED**	TEST	BYTE PTR DS:ALTR_J_B_0943+1,0FFH	; (72B5:0944=0AH)
		TEST	BYTE PTR DS:SMOKING_GUN_0944,0FFH	; (72B5:0944=0AH)
		JNZ	LOC_0421
;**CHANGED**	CMP	BX,DS:ALTR_W_03A6+1	; (72B5:03A7=0)
		CMP	BX,DS:OLD_W_03A7	; (72B5:03A7=0)
		JAE	LOC_041D
		PUSH	DI
;**CHANGED**	MOV	DX,DS:ALTR_W_03A6+1	; (72B5:03A7=0)
		MOV	DX,DS:OLD_W_03A7	; (72B5:03A7=0)
		MOV	DI,OFFSET DATA_2736	; (72B5:2736=30H)
		CALL	CNV_W_2_HX_151D
		MOV	DX,OFFSET MS_AD_ORDR_2712	; (72B5:2712=41H)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		POP	DI
LOC_041D:
;**CHANGED**	MOV	DS:ALTR_W_03A6+1,BX	; (72B5:03A7=0)
		MOV	DS:OLD_W_03A7,BX	; (72B5:03A7=0)
LOC_0421:
		MOV	AX,BX
		STOSW				; Store ax to es:[di]
		MOV	AL,CL
		STOSB				; Store al to es:[di]
		MOV	BX,DI
		MOV	AL,0
		STOSB				; Store al to es:[di]
		CALL	RD_SK_SPTB_1238
		CMP	AL,3BH			; ';' is it comment delimiter?
		JE	SCAN_2_EOL_04A2		; if yes, jump
LOC_0433:
		CMP	AL,0DH			; CR
		JE	LOC_0459
		CMP	AL,0AH			; LF
		JE	LOC_0459
		CMP	AL,9			; TAB
		JE	LOC_0459
		MOV	AH,1
		CALL	SUB_0F6C
		CMP	AL,61H			; 'a' 
		JB	LOC_044A
		AND	AL,5FH			; clear bit-5, strip case
LOC_044A:
		STOSB				; Store al to es:[di]
		INC	BYTE PTR [BX]
		CMP	BYTE PTR [BX],7FH
		JE	LOC_0459
		CALL	RD_NXT_BYT_1B1B
		CMP	AL,20H			; ' '
		JNE	LOC_0433
LOC_0459:
		TEST	BYTE PTR [BX],0FFH
		JZ	LOC_0497
		OR	BYTE PTR [DI-1],80H
		CMP	BYTE PTR [BX],7FH
		JE	LOC_0497
		CMP	AL,0DH			; CR
		JE	LOC_0497
		CALL	RD_SK_SPTB_1238
		CMP	AL,3BH			; ';'
		JE	SCAN_2_EOL_04A2
LOC_0472:
		CMP	AL,0DH			; CR
		JE	LOC_0493
		CMP	AL,9			; TAB
		JNE	LOC_047C
		MOV	AL,20H			; ' '
LOC_047C:
		MOV	AH,1
		CALL	SUB_0F6C
		STOSB				; Store al to es:[di]
		OR	BYTE PTR [BX],80H
		INC	BYTE PTR [BX]
		CMP	BYTE PTR [BX],0FFH
		JE	LOC_0493
		CALL	RD_NXT_BYT_1B1B
		CMP	AL,3BH			; ';'
		JNE	LOC_0472
LOC_0493:
		OR	BYTE PTR [DI-1],80H
LOC_0497:
		CMP	AL,0DH			; CR
		JE	LOC_04B1
LOC_049B:
		CALL	RD_SK_SPTB_1238
		CMP	AL,3BH			; ';'
		JNE	LOC_04AD
SCAN_2_EOL_04A2:
		CALL	RD_SK_SPTB_1238
		CMP	AL,1AH			; Ctrl-Z
		JE	LOC_04BB
		CMP	AL,0DH			; CR
		JNE	SCAN_2_EOL_04A2
LOC_04AD:
		CMP	AL,0DH			; CR
		JNE	LOC_04BB
LOC_04B1:
		CALL	RD_NXT_BYT_1B1B
		CMP	AL,0AH			; LF
		JNE	LOC_04BB
		JMP	LOC_0329
LOC_04BB:
		JMP	ALTR_W_03A6
SUB_02D0	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_04BE	PROC	NEAR
		MOV	AH,4
		CALL	SUB_0F6C
		MOV	AX,CX
		STOSW				; Store ax to es:[di]
		MOV	AL,BL
		OR	AL,20H			; ' '
;**CHANGED**	TEST	BYTE PTR DATA_2870[BX],0FFH	; (=0FFH)
		TEST	BYTE PTR SEQ_SW_BYTES[BX],0FFH	; (=0FFH)
		JZ	LOC_04D3
		OR	AL,10H
LOC_04D3:
		MOV	AH,0
		STOSW				; Store ax to es:[di]
		RETN
SUB_04BE	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_04D7	PROC	NEAR
		CALL	RD_SK_SPTB_1238
		CMP	AL,3BH			; ';'
		JNE	LOC_04E1
		POP	AX
		JMP	SHORT SCAN_2_EOL_04A2
LOC_04E1:
		XOR	BX,BX
		CMP	AL,26H			; '&'
		JE	LOC_04EE
;**CHANGED**	MOV	BYTE PTR DS:ALTR_J_B_0943+1,0	; (72B5:0944=0AH)
		MOV	BYTE PTR DS:OLD_JUMP_0944,0FFH	; don't take jump
		JMP	SHORT LOC_04F6
LOC_04EE:
		CALL	RD_SK_SPTB_1238
		JMP	SHORT LOC_04F6
LOC_04F3:
		CALL	RD_NXT_BYT_1B1B
LOC_04F6:
		MOV	AH,AL

						; ****** Error, 'A' s/b 'a' ******
;**ERROR**	CMP	AL,41H			; 'A'  -typographical error-
		CMP	AL,61H			; 'a'
		JB	LOC_04FE
		AND	AL,5FH			; clear bit-5, strip case
LOC_04FE:
		SUB	AL,30H			; '0'
		JC	LOC_0521
		CMP	AL,0AH			; number TEN
		JB	LOC_0508
		SUB	AL,7			; ASCII HEX conversion
LOC_0508:
		CMP	AL,0FH
		JA	LOC_0521
		MOV	CX,4

LOCLOOP_050F:
		ADD	BX,BX
		JC	LOC_051B
		LOOP	LOCLOOP_050F		; Loop if cx > 0

		MOV	AH,0
		ADD	BX,AX
		JNC	LOC_04F3
LOC_051B:
		MOV	DX,OFFSET MS_HXVL_ER_2771	; (72B5:2771=48H)
		JMP	LOC_0214
LOC_0521:
		CMP	AH,20H			; ' '
		JE	LOC_RET_0539
		CMP	AH,9                    ; Tab
		JE	LOC_RET_0539
		AND	AH,5FH			; clear bit-5, strip case
		CMP	AH,48H			; 'H'
		JE	LOC_RET_0539
		CMP	AH,1AH                  ; EOF
		STC				; Set carry flag
		JNZ	LOC_051B                ; read next char

LOC_RET_0539:
		RETN
SUB_04D7	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_053A	PROC	NEAR
		CALL	SCAN_SPTAB_0E3F
		JNZ	LOC_0548
		CMP	DI,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		JE	LOC_0563
		MOV	SI,OFFSET DATA_2150_CON	; (72B5:2150=43H)
LOC_0548:
		MOV	AX,2901H
		INT	21H			; DOS Services  ah=function 29h
						;  parse filenam @ds:si FCBes:di
		OR	AL,AL
		JNZ	LOC_0558
		CMP	BYTE PTR [DI+1],20H	; ' '
		JE	LOC_0558
		RETN
LOC_0558:
		MOV	SI,DI
		CALL	SUB_06B1
		MOV	DX,OFFSET MS_FILE_SPEC_ER	; (72B5:27A5=20H)
		JMP	LOC_0214
LOC_0563:
		MOV	WORD PTR FCB3_NAME_2A10,20H	; (72B5:2A10=646EH)
		JMP	LOC_0226
SUB_053A	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_056C	PROC	NEAR
		MOV	DI,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		CALL	SUB_053A

;==== External Entry into Subroutine ======================================

SUB_0572:
		MOV	DATA_2915,DATA_2E9E_E	; (=0) (=0)
		MOV	AL,0
;**CHANGED**	MOV	DS:ALTR_B_0F47+1,AL	; (72B5:0F48=0)
		MOV	DS:OLD_B_0F48,AL	; (72B5:0F48=0)
		MOV	BYTE PTR DATA_2861,1	; (=0)
		MOV	DATA_286D,AL		; (=0)
		MOV	DATA_285A,100H		; (=0)
		RETN
SUB_056C	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_058C	PROC	NEAR
;**CHANGED**	MOV	DI,OFFSET DATA_298B	; 132-byte line buffer
		MOV	DI,OFFSET LINE_BUF_132CHR ; 132-byte line buffer
		PUSH	CX
		PUSH	SI
		PUSH	DI
		MOV	DX,AX
		CALL	CNV_W_2_HX_151D
		POP	DI
		XCHG	SI,DI
		MOV	CX,4

LOCLOOP_059D:
		LODSB				; String [si] to al
		CALL	WR_CHR_AL_05C1
		LOOP	LOCLOOP_059D		; Loop if cx > 0

		POP	SI
		POP	CX
		RETN
SUB_058C	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_05A6	PROC	NEAR
		MOV	AX,DX
		PUSH	DI
		CALL	SUB_058C
		POP	DI
		RETN
SUB_05A6	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

WR_CRLF_05AE	PROC	NEAR
		MOV	AL,0DH			; CR
		CALL	WR_CHR_AL_05C1
		MOV	AL,0AH			; LF
;***TEST1	DB	0A9H			; TEST - (JMP SHORT LOC_05C1)
		JMP	SHORT WR_CHR_AL_05C1

;==== External Entry into Subroutine ======================================

WR_L_05B6:
		MOV	AL,4CH			; 'L'
;***TEST2	DB	0A9H			; TEST - (JMP SHORT LOC_05C1)
		JMP	SHORT WR_CHR_AL_05C1

;==== External Entry into Subroutine ======================================

WR_SEMI_05B9:
LOC_05B9:
		MOV	AL,3BH			; ';'
;***TEST3	DB	0A9H			; TEST - (JMP SHORT LOC_05C1)
		JMP	SHORT WR_CHR_AL_05C1

;==== External Entry into Subroutine ======================================

SUB_05BC:
		MOV	AL,9			; TAB
;***TEST4	DB	0A9H			; TEST - (JMP SHORT LOC_05C1)
		JMP	SHORT WR_CHR_AL_05C1

;==== External Entry into Subroutine ======================================

SUB_05BF:
		MOV	AL,20H			; ' '

;==== External Entry into Subroutine ======================================

WR_CHR_AL_05C1:
;**CHANGED**	TEST	BYTE PTR DATA_2870,0FFH	; (=0FFH)
		TEST	BYTE PTR SW_O_OUTPUT_LST,0FFH ; (=0FFH)
		JZ	LOC_RET_0600
		CMP	BYTE PTR DATA_2861,1	; (=0)
		JE	LOC_RET_0600
		PUSH	AX
		PUSH	DI
		MOV	DI,OFFSET DATA_2848	; (=0)
		INC	BYTE PTR [DI]
		CMP	AL,9
		JNE	LOC_05E0
		ADD	BYTE PTR [DI],7
		AND	BYTE PTR [DI],0F8H	; clear low 3-bits
LOC_05E0:
		MOV	DI,DATA_2881		; (=0)
		AND	AL,7FH			; clear bit-7
		STOSB				; Store al to es:[di]
		CMP	DI,DATA_2E9E_E		; (=0)
		JNE	LOC_05F0
		CALL	SUB_062D
LOC_05F0:
		MOV	DATA_2881,DI		; (=0)
		INC	DATA_2849		; (=0)
		JNZ	LOC_05FE
		INC	DATA_284B		; (=0)
LOC_05FE:
		POP	DI
		POP	AX

LOC_RET_0600:
		RETN
WR_CRLF_05AE	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

WR_STRING_0601	PROC	NEAR
LOC_0601:
		LODSB				; String [si] to al
		TEST	AL,7FH
		JZ	LOC_RET_060D
		CALL	WR_CHR_AL_05C1
		AND	AL,80H			; clear all but bit-7
		JZ	LOC_0601

LOC_RET_060D:
		RETN
WR_STRING_0601	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_060E	PROC	NEAR
		PUSH	AX

LOCLOOP_060F:
		MOV	AH,DATA_2848		; (=0)
		AND	AH,7			; clear all but 3 LSB's
		MOV	AL,7
		SUB	AL,AH
		CBW				; Convrt byte to word
		CMP	CX,AX
		JBE	LOC_0626
		SUB	CX,AX
		CALL	SUB_05BC
		JMP	SHORT LOC_0629
LOC_0626:
		CALL	SUB_05BF
LOC_0629:
		LOOP	LOCLOOP_060F		; Loop if cx > 0

		POP	AX
		RETN
SUB_060E	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_062D	PROC	NEAR
		PUSH	DX
		MOV	DX,OFFSET DTA4_2C9E	; (72B5:2C9E=0)
		MOV	AH,1AH
		INT	21H			; DOS Services  ah=function 1Ah
						;  set DTA to ds:dx
		XCHG	DX,DI
		MOV	DX,OFFSET FCB4_2A34	; (72B5:2A34=0DH)
		MOV	AH,15H
		INT	21H			; DOS Services  ah=function 15h
						;  sequent file write FCB @ds:dx
		OR	AL,AL
		POP	DX
		JNZ	LOC_0644
		RETN
LOC_0644:
		MOV	DX,OFFSET MS_DSKFULL_26AB	; (72B5:26AB=49H)
		JMP	LOC_0214
SUB_062D	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_064A	PROC	NEAR

		TEST	OLD_RET_NOP_064A,0FFH
		JNZ	LOC_064B		; jump if old NOP condition

ALTR_OPB_064A:					; Altered code -- RETN or NOP
		RETN
SUB_064A	ENDP

LOC_064B:
;**CHANGED**	MOV	BYTE PTR DS:ALTR_OPB_064A+0,0C3H	; (72B5:064A=0C3H)
		MOV	OLD_RET_NOP_064A,0	; (=0C3H) RETN
		MOV	AL,1AH
		CALL	WR_CHR_AL_05C1
		MOV	BX,DATA_2881		; (=0)
		SUB	BX,OFFSET DTA4_2C9E	; (72B5:2C9E=0)
		PUSHF
		JZ	LOC_0663
		CALL	SUB_062D
LOC_0663:
		POPF
		JZ	LOC_0677
		MOV	AX,200H
		SUB	AX,BX
		JZ	LOC_0677
		SUB	WORD PTR FCB4_FILSZ_2A44,AX	; (72B5:2A44=646FH)
		JNC	LOC_0677
		DEC	WORD PTR FCB4_FLSZH_2A46	; (72B5:2A46=2065H)
LOC_0677:
		MOV	DX,OFFSET FCB4_2A34	; (72B5:2A34=0DH)
		MOV	AH,10H
		INT	21H			; DOS Services  ah=function 10h
						;  close file, FCB @ ds:dx
		OR	AL,AL
		JNZ	LOC_06AB
		MOV	DX,OFFSET MS_BYT_N_OT_FLE	; (72B5:278E=42H)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
;**CHANGED**	MOV	DI,OFFSET DATA_298B	; 132-byte line buffer
		MOV	DI,OFFSET LINE_BUF_132CHR ; 132-byte line buffer
		PUSH	DI			; save as pointer to display buf
		MOV	DX,DATA_284B		; data for HEX ASCII conversion
		OR	DX,DX			; test for zero
		JZ	LOC_0698
		CALL	CNV_W_2_HX_151D
LOC_0698:
		MOV	DX,DATA_2849		; data for HEX ASCII conversion
		CALL	CNV_W_2_HX_151D
		MOV	AX,2448H		; 'H$' add terminal character
		STOSW				; Store ax to es:[di]
		POP	DX			; get pointer to display buf
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		JMP	SHORT LOC_06FB
	;***	DB	90H
LOC_06AB:
		MOV	DX,OFFSET MS_NOCLOSE_265F	; (72B5:265F=0DH)
		JMP	LOC_0214

;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_06B1	PROC	NEAR
		PUSH	CX
		LODSB				; String [si] to al
		CMP	AL,0
		JE	LOC_06C6
		CMP	BYTE PTR [SI],20H	; ' '
		JE	LOC_06C6
		OR	AL,40H			; '@'
		CALL	DSPY_CHR_AL_070
		MOV	AL,3AH			; ':'
		CALL	DSPY_CHR_AL_070
LOC_06C6:
		LODSB				; String [si] to al
		MOV	CX,8
		CMP	AL,20H			; ' '
		JNE	LOC_06D4
		CALL	DSPY_DOT_0703
		JMP	SHORT LOC_06EA

LOCLOOP_06D3:
		LODSB				; String [si] to al
LOC_06D4:
		CALL	SUB_06EC
		LOOP	LOCLOOP_06D3		; Loop if cx > 0

		CMP	BYTE PTR [SI],20H	; ' '
		JE	LOC_06EA
		MOV	CX,3
		CALL	DSPY_DOT_0703

LOCLOOP_06E4:
		LODSB				; String [si] to al
		CALL	SUB_06EC
		LOOP	LOCLOOP_06E4		; Loop if cx > 0

LOC_06EA:
		POP	CX
		RETN
SUB_06B1	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_06EC	PROC	NEAR
		CMP	AL,20H			; ' '
		JNE	LOC_0708
		RETN

;==== External Entry into Subroutine ======================================
;
;         Buffered Keyboard Input

SUB_06F1:
		MOV	DX,OFFSET KBD_BUF_2968	; (72B5:2968=20H)
		MOV	AH,0AH
		INT	21H			; DOS Services  ah=function 0Ah
						;  get keybd line, put at ds:dx
		MOV	SI,OFFSET DATA_296A	; Keyboard line buffer

;==== External Entry into Subroutine ======================================

DSPY_CRLF_06FB:
LOC_06FB:
		MOV	AL,0DH			; CR
		CALL	DSPY_CHR_AL_070
		MOV	AL,0AH			; LF
;***TEST5	DB	0A9H			; TEST skips next instruction
		JMP	SHORT DSPY_CHR_AL_070

;==== External Entry into Subroutine ======================================

DSPY_DOT_0703:
		MOV	AL,2EH			; '.'
;***TEST6	DB	0A9H			; TEST skips next instruction
;		JMP	SHORT DSPY_CHR_AL_070
;SUB_0706:
;		MOV	AL,20H			; ' '
SUB_06EC	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

DSPY_CHR_AL_070	PROC	NEAR
LOC_0708:
		PUSH	AX
		PUSH	DX
		AND	AL,7FH			; clear bit-7
		XCHG	AX,DX
		MOV	AH,2
		INT	21H			; DOS Services  ah=function 02h
						;  display char dl
		POP	DX
		POP	AX
		RETN
DSPY_CHR_AL_070	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0714	PROC	NEAR
		CMP	BYTE PTR DATA_2861,2	; (=0)
		JE	LOC_0722

;==== External Entry into Subroutine ======================================

SUB_071B:
		CALL	SUB_02D0
		MOV	DATA_288F,DI		; (=0)
LOC_0722:
		MOV	BYTE PTR DATA_286E,0	; (=0)

						; 24H s/b LOC_RET_10A7-SUB_1081-2
;**CHANGED**	MOV	BYTE PTR DS:ALTR_J_B_1081+1,24H	; (72B5:1082=24H) '$'
;**CHANGED**	MOV	BYTE PTR DS:ALTR_J_B_1081+1,LOC_RET_10A7-SUB_1081-2
		MOV	BYTE PTR DS:OLD_JUMP_1082,0	;take jump
		MOV	BX,DATA_2893		; (=0)
		TEST	BYTE PTR [BX],80H
		JNZ	LOC_073A
		MOV	BYTE PTR DATA_2888,0FFH	; (=0)
LOC_073A:
		CALL	SUB_0C37
;**CHANGED**	MOV	BYTE PTR DATA_2870,0FFH	; (=0FFH)
		MOV	BYTE PTR SW_O_OUTPUT_LST,0FFH ; (=0FFH)
		JNC	LOC_0747
		JMP	LOC_0223
LOC_0747:
		MOV	BP,DATA_2893		; (=0)
		CMP	BYTE PTR DATA_2861,1	; (=0)
		JNE	LOC_075C
		MOV	DX,OFFSET MS_BLDG_REF_TBL	; (72B5:2808=42H)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		JMP	SHORT LOC_0799
	;***	DB	90H
LOC_075C:
		CALL	SUB_0E4C
		CALL	SUB_0B70
		CALL	SUB_0C2E
		JNC	LOC_076A
		JMP	LOC_0214
LOC_076A:
;**CHANGED**	TEST	BYTE PTR DATA_2878,0FFH	; (=0FFH)
		TEST	BYTE PTR SW_M_MACRO_LIST,0FFH ; (=0FFH)
		JZ	LOC_0789
		MOV	SI,OFFSET MAC_PATCH83	; (72B5:24E0=0)
LOC_0774:
		LODSB				; String [si] to al
		CMP	AL,0FFH
		JE	LOC_0789
		CMP	AL,1
		JNE	LOC_0782
		CALL	WR_STRING_0601
		JMP	SHORT LOC_0774
LOC_0782:
		LODSB				; String [si] to al
		TEST	AL,80H
		JNZ	LOC_0774
		JMP	SHORT LOC_0782
LOC_0789:
		MOV	SI,OFFSET MN_DOT_RADIX_16	; (72B5:25C5=2EH)
;**CHANGED**	TEST	BYTE PTR RAD16_FLAG_2877,0FFH	; (72B5:2877=0FFH)
		TEST	BYTE PTR SW_H_HEX_SUFFIX,0FFH	; (72B5:2877=0FFH)
		JNZ	LOC_0796
		MOV	SI,OFFSET MN_CRLF_INIT_VL	; (72B5:25D0=4CH)
LOC_0796:
		CALL	WR_STRING_0601
LOC_0799:
		CMP	BYTE PTR DATA_2887,80H	; (=0)
		JNE	LOC_07A5
		MOV	BYTE PTR DATA_2887,0	; (=0)
LOC_07A5:
		MOV	SI,DATA_2889		; (=0)
		CMP	SI,DATA_288F		; (=0)
		JB	LOC_07B2
LOC_07AF:
		JMP	LOC_088F
LOC_07B2:
		MOV	AX,DATA_2858		; (=0)
		CMP	AX,[SI]
		JB	LOC_07AF
		MOV	CX,SI
		LODSW				; String [si] to ax
		LODSB				; String [si] to al
		PUSH	AX
		LODSB				; String [si] to al
;**CHANGED**	MOV	DS:ALTR_W_1123+1,SI	; (72B5:1124=0)
		MOV	DS:OLD_W_1124,SI	; (72B5:1124=0)
		AND	AL,7FH			; clear bit-7
		MOV	AH,0
		ADD	SI,AX
		POP	AX
		MOV	DATA_2889,SI		; (=0)
		CMP	AL,9
		JNE	LOC_0817
		CMP	SI,DATA_288F		; (=0)
		JAE	LOC_07FE
		TEST	BYTE PTR [SI+2],40H	; '@'
		JZ	LOC_07FE
		MOV	SI,CX
;**CHANGED**	MOV	DS:ALTR_W_0802+1,SI	; (72B5:0803=0)
		MOV	DS:OLD_W_0803,SI	; (72B5:0803=0)
;**CHANGED**	MOV	DS:ALTR_W_08E3+1,SI	; (72B5:08E4=0)
		MOV	DS:OLD_W_08E4,SI	; (72B5:08E4=0)
LOC_07E8:
		ADD	SI,3
		LODSB				; String [si] to al
		AND	AL,7FH			; clear bit-7
		MOV	AH,0
		ADD	SI,AX
		CMP	SI,DATA_288F		; (=0)
		JAE	LOC_07FE
		TEST	BYTE PTR [SI+2],40H	; '@'
		JNZ	LOC_07E8
LOC_07FE:
		MOV	DATA_2889,SI		; (=0)

ALTR_W_0802:					; Altered code
;**CHANGED**	MOV	DI,0
		MOV	DI,OLD_W_0803
		OR	DI,DI
		JZ	LOC_0811
		MOV	BYTE PTR DATA_291B,0FFH	; (=0)
		JMP	SHORT LOC_0888
	;***	DB	90H
LOC_0811:
		MOV	DX,OFFSET MS_STR_SEQ_273E	; (72B5:273E=55H)
		JMP	LOC_0214
LOC_0817:
		TEST	AL,20H			; ' ' space
		JNZ	LOC_0851
		CMP	AL,0AH			; number TEN
		JB	LOC_0866
LOC_081F:
		CMP	SI,DATA_288F		; (=0)
		JAE	LOC_0888
		LODSW				; String [si] to ax
		MOV	CX,AX
		MOV	DATA_2885,AX		; (=0)
		LODSB				; String [si] to al
		PUSH	AX
		LODSB				; String [si] to al
		AND	AL,7FH			; clear bit-7
		MOV	AH,0
		ADD	SI,AX
		POP	AX
		SUB	AL,10H
		JC	LOC_088C
		CMP	AL,3
		JA	LOC_088C
		SHL	AL,1			; Shift w/zeros fill
		MOV	AH,0
;**CHANGED**	MOV	BYTE PTR DS:ALTR_J_B_1081+1,AH	; (72B5:1082=24H)
		MOV	BYTE PTR DS:OLD_JUMP_1082,0FFH	;don't take jump
		MOV	BX,AX
		MOV	DATA_2823[BX],CX	; 4-words indexed
		MOV	DATA_2889,SI		; (=0)
		JMP	SHORT LOC_081F
LOC_0851:
		MOV	BL,AL
		AND	BL,0CFH			; clear bits 4 & 5
		MOV	BH,0
		TEST	AL,10H			; check if bit-4 is zero
		MOV	AL,BH
		JZ	LOC_0860
		NOT	AL
LOC_0860:
;**CHANGED**	MOV	DATA_2870[BX],AL	; (=0FFH)
		MOV	SEQ_SW_BYTES[BX],AL	; (=0FFH)
		JMP	SHORT LOC_0888
LOC_0866:
		MOV	DATA_2887,AL		; (=0)
		CMP	AL,6
		JNE	LOC_0872
		MOV	BYTE PTR DATA_2887,80H	; (=0)
LOC_0872:
		MOV	BYTE PTR DATA_291B,0	; (=0)
		MOV	DATA_2919,0		; (=0)
		MOV	BYTE PTR DATA_2856,0	; (=0)
;**CHANGED**	MOV	AX,DS:ALTR_W_0802+1	; (72B5:0803=0)
		MOV	AX,DS:OLD_W_0803	; (72B5:0803=0)
;**CHANGED**	MOV	DS:ALTR_W_08E3+1,AX	; (72B5:08E4=0)
		MOV	DS:OLD_W_08E4,AX	; (72B5:08E4=0)
LOC_0888:
		LODSW				; String [si] to ax
		MOV	DATA_2885,AX		; (=0)
LOC_088C:
		JMP	LOC_07A5
LOC_088F:
		XOR	AX,AX
;**CHANGED**	MOV	DS:ALTR_W_09E2+1,AX	; (72B5:09E3=0FFFFH)
		MOV	DS:OLD_W_09E3,AX	; (72B5:09E3=0FFFFH)
		MOV	DATA_2854,AX		; (Tab counter ?)
		MOV	DATA_2846,AL		; (=0)
		MOV	DATA_2847,AL		; (=0)
		MOV	DATA_285D,AL		; (=0)
		MOV	DATA_285C,AL		; (=0)
		CMP	BYTE PTR DATA_2861,1	; (=0)
		JE	LOC_08C8
		CALL	SUB_1081
LOC_08AD:
		TEST	BYTE PTR DATA_2888,0FFH	; (=0)
		JZ	LOC_08C5
		MOV	AX,[BP+1]
		CMP	AX,DATA_2858		; (=0)
		JA	LOC_08C5
		CALL	SUB_0FA8
		CALL	SUB_10A8
		JZ	LOC_08AD
LOC_08C5:
		CALL	SUB_05BC

LOC_08C8:					; 0AH s/b LOC_094F-ALTR_J_B_0943-2
;**CHANGED**	MOV	BYTE PTR DS:ALTR_J_B_0943+1,0AH	; (72B5:0944=0AH)
;**CHANGED**	MOV	BYTE PTR DS:ALTR_J_B_0943+1,LOC_094F-ALTR_J_B_0943-2
		MOV	BYTE PTR DS:OLD_JUMP_0944,0	; take jump
		TEST	BYTE PTR DATA_2856,0FFH	; (=0)
		JNZ	LOC_0917
		TEST	BYTE PTR DATA_291B,0FFH	; (=0)
		JZ	LOC_0917
		TEST	DATA_2919,0FFFFH	; (=0)
		JNZ	LOC_0917

ALTR_W_08E3:					; Altered code
;**CHANGED**	MOV	SI,0
		MOV	SI,OLD_W_08E4
LOC_08E6:
		LEA	SI,[SI+3]		; Load effective addr
		LODSB				; String [si] to al
		AND	AL,7FH			; clear bit-7
		MOV	AH,0
		ADD	SI,AX
		CMP	SI,DATA_288F		; (=0)
		JAE	LOC_08FC
		TEST	BYTE PTR [SI+2],40H	; '@'
		JNZ	LOC_0902
LOC_08FC:
;**CHANGED**	MOV	SI,DS:ALTR_W_0802+1	; (72B5:0803=0)
		MOV	SI,DS:OLD_W_0803	; (72B5:0803=0)
		JMP	SHORT LOC_08E6
LOC_0902:
;**CHANGED**	MOV	DS:ALTR_W_08E3+1,SI	; (72B5:08E4=0)
		MOV	DS:OLD_W_08E4,SI	; (72B5:08E4=0)
		LODSW				; String [si] to ax
		MOV	DATA_2919,AX		; (=0)
		LODSB				; String [si] to al
		AND	AL,3FH			; clear bits 6 & 7
		MOV	DATA_2887,AL		; (=0)
		LODSB				; String [si] to al
		AND	AL,7FH			; clear bit-7
		MOV	AH,0
		ADD	SI,AX
LOC_0917:
		MOV	BYTE PTR DATA_286E,1	; (=0)
;**CHANGED**	MOV	DI,OFFSET DATA_298B	; 132-byte line buffer
		MOV	DI,OFFSET LINE_BUF_132CHR ; 132-byte line buffer
		MOV	BYTE PTR [DI],80H
		CALL	SUB_165A
		MOV	BH,0
		MOV	DATA_2848,BH		; (=0)
		MOV	BL,DATA_2887		; (=0)
		AND	BL,7FH			;*** mask low 7-bits ERROR?
		ADD	BX,BX
		CALL	WORD PTR DATA_1BA9[BX]	;*(72B5:1BA9=1277H)  9 entries
		MOV	AH,0BH
		INT	21H			; DOS Services  ah=function 0Bh
						;  if keybd char available,al=FF
		CMP	BYTE PTR DATA_2861,1	; (=0)
		JE	LOC_0984

ALTR_J_B_0943:					; Altered code
;**CHANGED**	JMP	SHORT LOC_094F
		TEST	BYTE PTR OLD_JUMP_0944,0FFH ; test for jump
		JZ	LOC_094F		; if zero, take jump

ALTR_W_0945:					; Altered code
;**CHANGED**	MOV	DX,0
		MOV	DX,OLD_W_0946		;(immediate) operand word
		MOV	AX,3B09H		; "TAB Semicolon"
		STOSW				; Store ax to es:[di]
		CALL	CNV_W_2_HX_151D
LOC_094F:
		TEST	BYTE PTR DATA_2866,0FFH	; (=0)
		JZ	LOC_0963
		MOV	AL,9			; TAB
		STOSB				; Store al to es:[di]
		CALL	SUB_181D
		MOV	AL,9			; TAB
		STOSB				; Store al to es:[di]
		MOV	AX,3F3FH		; '??'
		STOSW				; Store ax to es:[di]
LOC_0963:
		OR	BYTE PTR [DI-1],80H
		MOV	SI,OPW_TBL_WD_285F	; (72B5:285F=0)
		AND	SI,0FFFH		; keep low 12-bits
		ADD	SI,OFFSET MN_AAA	; (72B5:20F4=41H)
		CALL	WR_STRING_0601
;**CHANGED**	MOV	SI,OFFSET DATA_298B	; 132-byte line buffer
		MOV	SI,OFFSET LINE_BUF_132CHR ; 132-byte line buffer
		TEST	BYTE PTR [SI],7FH
		JZ	LOC_0984
LOC_097E:
		CALL	SUB_05BC
		CALL	WR_STRING_0601
LOC_0984:
		MOV	DI,DATA_288D		; (=0)
		CMP	DI,DATA_2893		; (=0)
		JAE	LOC_09AB
		MOV	AX,[DI]
		CMP	AX,DATA_2858		; (=0)
		JA	LOC_09AB
		ADD	DI,2
		MOV	DATA_288D,DI		; (=0)
		MOV	SI,OFFSET MS_RELOC_275E	; (72B5:275E=3BH)

ALTR_W_09A0:					; Altered code
;**CHANGED**	MOV	DX,0
		MOV	DX,OLD_W_09A1
		CALL	SUB_0E70
		OR	BYTE PTR [DI],1
		JMP	SHORT LOC_097E
LOC_09AB:
		MOV	SI,OFFSET DATA_2879	; (72B5:2879=9)
		TEST	BYTE PTR DATA_2887,7FH	; (=0)
		JNZ	LOC_09BE
		TEST	BYTE PTR [SI+3],7FH
		JZ	LOC_09BE
		CALL	WR_STRING_0601
LOC_09BE:
;**CHANGED**	TEST	BYTE PTR DATA_2870,0FFH	; (=0FFH)
		TEST	BYTE PTR SW_O_OUTPUT_LST,0FFH	; (=0FFH)
		JNZ	LOC_09C8
		JMP	LOC_0AAA
LOC_09C8:
;**CHANGED**	MOV	BYTE PTR DS:ALTR_B_0A0E+2,28H	; (72B5:0A10=40H) '('
		MOV	BYTE PTR DS:OLD_B_0A10,28H	; (72B5:0A10=40H) '('
;**CHANGED**	TEST	WORD PTR DS:ALTR_W_09E2+1,0FFFFH	; (72B5:09E3=0FFFFH)
		TEST	WORD PTR DS:OLD_W_09E3,0FFFFH	; (72B5:09E3=0FFFFH)
		JZ	LOC_09ED
LOC_09D5:
		CALL	SUB_05BC
		CMP	BYTE PTR DATA_2848,1EH	; (=0) 30 decimal
		JB	LOC_09D5
		CALL	WR_SEMI_05B9

ALTR_W_09E2:					; Altered code
;**CHANGED**	MOV	SI,0FFFFH
		MOV	SI,OLD_W_09E3
		CALL	WR_STRING_0601
;**CHANGED**	MOV	BYTE PTR DS:ALTR_B_0A0E+2,40H	; (72B5:0A10=40H) '@'
		MOV	BYTE PTR DS:OLD_B_0A10,40H	; (72B5:0A10=40H) '@'
LOC_09ED:
;**CHANGED**	TEST	BYTE PTR DATA_2875,0FFH	; (=0FFH)
		TEST	BYTE PTR SW_T_TRACE_OUTP,0FFH	; (=0FFH)
		JZ	LOC_0A6A
		MOV	BL,DATA_2848		; (=0)
		AND	BL,0F8H			; clear low 3-bits
LOC_09FB:
		ADD	BL,8
		CALL	SUB_05BC
		CMP	BL,28H			; '('
		JB	LOC_09FB
;**CHANGED**	MOV	WORD PTR DS:ALTR_W_0A47+1,10H	; (72B5:0A48=10H)
		MOV	WORD PTR DS:OLD_W_0A48,10H	; (72B5:0A48=10H)
		JZ	LOC_0A35

ALTR_B_0A0E:					; Altered code
;**CHANGED**	CMP	BL,40H			; '@'
		CMP	BL,OLD_B_0A10		; '@'
		JB	LOC_0A35
		CALL	WR_CRLF_05AE
		CALL	SUB_05BC
		CALL	SUB_05BC
		CALL	SUB_05BC
;**CHANGED**	MOV	WORD PTR DS:ALTR_W_0A47+1,18H	; (72B5:0A48=10H)
		MOV	WORD PTR DS:OLD_W_0A48,18H	; (72B5:0A48=10H)
		CMP	DATA_2854,6		; (Tab counter ?)
		JA	LOC_0A35
		CALL	SUB_05BC
		CALL	SUB_05BC
		CALL	SUB_05BC
LOC_0A35:
		CALL	WR_SEMI_05B9
		MOV	AX,DATA_2858		; (=0)
		MOV	CX,DATA_2854		; (=0)
		SUB	AX,CX
;**CHANGED**	CMP	CX,DS:ALTR_W_0A47+1	; (72B5:0A48=10H)
		CMP	CX,DS:OLD_W_0A48	; (72B5:0A48=10H)
		JBE	LOC_0A4A

ALTR_W_0A47:					; Altered code
;**CHANGED**	MOV	CX,10H
		MOV	CX,OLD_W_0A48
LOC_0A4A:
		CALL	SUB_058C
		MOV	SI,OFFSET DATA_282B	; 24-byte buffer

LOCLOOP_0A50:
		CALL	SUB_05BF
		LODSB				; String [si] to al
;**CHANGED**	MOV	DI,OFFSET DATA_298B	; 132-byte line buffer
		MOV	DI,OFFSET LINE_BUF_132CHR ; 132-byte line buffer
		PUSH	DI
		CALL	CNV_B_2_HX_1524
		POP	DI
		XCHG	SI,DI
		LODSB				; String [si] to al
		CALL	WR_CHR_AL_05C1
		LODSB				; String [si] to al
		CALL	WR_CHR_AL_05C1
		XCHG	SI,DI
		LOOP	LOCLOOP_0A50		; Loop if cx > 0

LOC_0A6A:
		CALL	WR_CRLF_05AE
		TEST	BYTE PTR DATA_285D,0FFH	; (=0)
		JZ	LOC_0A7D
		MOV	SI,OFFSET MN_TAB_NOP	; (72B5:239D=9)
		CALL	WR_STRING_0601
		CALL	WR_CRLF_05AE

LOC_0A7D:	;test for op-code 81H, possible op-code 83H optimization.

		CMP	BYTE PTR OPCODE_BYT_286B,81H	; (72B5:286B=0)
		JNE	LOC_0AA0		; Jump if not op-code 81H

		MOV	AL,MOD_REG_RM_286C	; (72B5:286C=0)
		XOR	AL,0C0H			;flip the MOD bits
		AND	AL,0C7H			;mask out REG op-code bits
		JZ	LOC_0AA0		;PATCH83 not used for AX reg
		TEST	AL,0C0H			;was it MOD 11?
		JNZ	LOC_0AA0		;PATCH83 only used for MOD 11

		CMP	OLD_W_0946,07FH		;is value 0 thru 127?
		JA	LOC_0AA_NEG		;if no, jump

		MOV	BYTE PTR MAC_PATCH83,1	; (72B5:24E0=0)
		MOV	SI,OFFSET MN_PATCH83_POS
		CALL	WR_STRING_0601
		JMP	SHORT LOC_0AA0

LOC_0AA_NEG:
		CMP	OLD_W_0946,0FF80H	;is value -1 thru -128?
		JB	LOC_0AA0		;if no, jump

		MOV	BYTE PTR MAC_PATCH83,1	; (72B5:24E0=0)
		MOV	SI,OFFSET MN_PATCH83_NEG
		CALL	WR_STRING_0601

LOC_0AA0:
		TEST	BYTE PTR DATA_285C,0FFH	; (=0)
		JZ	LOC_0AAA
		CALL	WR_CRLF_05AE
LOC_0AAA:
		TEST	DATA_284D,0FFFFH	; (72B5:284D=0)
		JZ	LOC_0AB5
		JMP	LOC_0799
LOC_0AB5:
		TEST	BYTE PTR DATA_286D,0FFH	; (=0)
		JNZ	LOC_0AE3
		MOV	DX,DATA_2A94		; Code Segment value
		MOV	CL,4
		SHL	DX,CL			; Shift w/zeros fill
		ADD	DX,DATA_2A92		; Code Offset value
;**CHANGED**	MOV	DS:ALTR_W_0B2B+1,DX	; (72B5:0B2C=0)
		MOV	DS:OLD_W_0B2C,DX	; (72B5:0B2C=0)
		MOV	BYTE PTR DATA_2887,0	; (=0)
		MOV	BYTE PTR OPW_HI_NBL_286A,0	; (72B5:286A=0)
		MOV	BYTE PTR OPJ_HI_BYT_2869,20H	; (72B5:2869=0) ' '
;**CHANGED**	MOV	BYTE PTR DATA_2871,0FFH	; (=0FFH)
		MOV	BYTE PTR SW_R_TABLE_LST,0FFH	; (=0FFH)
		CALL	SUB_0EAB
LOC_0AE3:
		CMP	BYTE PTR DATA_2861,1	; (=0)
		JE	LOC_0AFE
;**CHANGED**	MOV	BYTE PTR DATA_2870,0FFH	; (=0FFH)
		MOV	BYTE PTR SW_O_OUTPUT_LST,0FFH	; (=0FFH)
LOC_0AEF:
		TEST	BYTE PTR DATA_2888,0FFH	; (=0)
		JZ	LOC_0AFE
		CALL	SUB_0FA8
		CALL	SUB_10A8
		JMP	SHORT LOC_0AEF
LOC_0AFE:
		MOV	DX,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		MOV	AH,10H
		INT	21H			; DOS Services  ah=function 10h
						;  close file, FCB @ ds:dx
		CMP	BYTE PTR DATA_2861,1	; (=0)
		JNE	LOC_0B1B
		MOV	BYTE PTR DATA_2861,2	; (=0)
		CMP	BYTE PTR DATA_2862,41H	; (=0) 'A'
		JNE	LOC_RET_0B49
		JMP	LOC_0722
LOC_0B1B:
		CALL	SUB_1221
		MOV	SI,OFFSET DATA_217E	; (72B5:217E=45H)
		CALL	WR_STRING_0601
		TEST	BYTE PTR DATA_286D,0FFH	; (=0)
		JNZ	LOC_0B43

ALTR_W_0B2B:					; Altered code
;**CHANGED**	MOV	DX,0
		MOV	DX,OLD_W_0B2C
		CALL	SUB_0E70
		CALL	SUB_1B70
		JC	LOC_0B3D
		JZ	LOC_0B3D
		CALL	WR_STRING_0601
		JMP	SHORT LOC_0B43
LOC_0B3D:
		CALL	WR_L_05B6
		CALL	SUB_05A6
LOC_0B43:
		CALL	WR_CRLF_05AE
		CALL	SUB_064A

LOC_RET_0B49:
		RETN
SUB_0714	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0B4A	PROC	NEAR
		MOV	BX,DATA_2893		; (=0)
		TEST	BYTE PTR [BX],80H
		JNZ	LOC_RET_0B6F
		MOV	BYTE PTR DATA_2888,0FFH	; (=0)
;**CHANGED**	MOV	BYTE PTR DS:ALTR_B_0FBA+1,0	; (72B5:0FBB=0)
		MOV	BYTE PTR DS:OLD_B_0FBB,0	; (72B5:0FBB=0)
		CALL	SUB_0B70
		MOV	SI,BP
		JNC	LOC_0B67
		JMP	LOC_0214
LOC_0B67:
		CALL	SUB_0FA8
		JZ	LOC_0B67
		CALL	SUB_064A

LOC_RET_0B6F:
		RETN
SUB_0B4A	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0B70	PROC	NEAR
		MOV	AX,OFFSET DTA4_2C9E	; (72B5:2C9E=0)
		MOV	DATA_2881,AX		; (=0)
		MOV	SI,OFFSET MN_TITLE	; (72B5:2431=54H)
		CALL	WR_STRING_0601
		MOV	SI,OFFSET FCB3_NAME_2A10	; (72B5:2A10=6EH)
		MOV	CX,8

LOCLOOP_0B82:
		LODSB				; String [si] to al
		CMP	AL,20H			; ' '
		JE	LOC_0B8C
		CALL	WR_CHR_AL_05C1
		LOOP	LOCLOOP_0B82		; Loop if cx > 0

LOC_0B8C:
;**CHANGED**	MOV	DI,OFFSET DATA_298B	; 132-byte line buffer
		MOV	DI,OFFSET LINE_BUF_132CHR ; 132-byte line buffer
		PUSH	DI
		MOV	AL,9
		STOSB				; Store al to es:[di]
		MOV	DX,WORD PTR FCB3_DATE_2A23	; (72B5:2A23=6365H)
		MOV	BX,DX
		MOV	CL,5
		SHR	BX,CL			; Shift w/zeros fill
		AND	BX,0FH			; clear high 12-bits
	;***	nop				;*Fixup for MASM (M)
		PATCH83	0			;PATCH83 edited in (JEG)
		CALL	SUB_11E7
		MOV	BX,DX
		AND	BX,1FH			; clear high 11-bits
	;***	nop				;*Fixup for MASM (M)
		PATCH83	0			;PATCH83 edited in (JEG)
		CALL	SUB_11E4
		MOV	BL,DH
		SHR	BX,1			; Shift w/zeros fill
		ADD	BX,50H
		CALL	SUB_11E4
		MOV	AX,5B09H		; "TAB ["
		STOSW				; Store ax to es:[di]
		MOV	AH,2AH
		INT	21H			; DOS Services  ah=function 2Ah
						;  get date, cx=year, dx=mon/day
		MOV	BL,DH
		MOV	BH,0
		CALL	SUB_11E7
		MOV	BL,DL
		CALL	SUB_11E4
		MOV	BX,CX
		SUB	BX,76CH		;***** WHAT IS THIS ? *****
		CALL	SUB_11E4
		MOV	AL,5DH			; ']'
		STOSB				; Store al to es:[di]
		MOV	AX,8A0DH		; "CR LF", high bit set
		STOSW				; Store ax to es:[di]
		POP	SI
		CALL	WR_STRING_0601
		CALL	WR_CRLF_05AE
		MOV	DX,OFFSET FCB4_2A34	; (72B5:2A34=0DH)
		MOV	AH,16H
		INT	21H			; DOS Services  ah=function 16h
						;  creat/truncat file FCB @ds:dx
		PUSH	AX
		MOV	AH,FCB4_RESRV_2A4C	; (72B5:2A4C=73H)
		CMP	AH,0FFH
		JE	LOC_0C03
		MOV	DX,OFFSET MS_WRITING_27FD	; (72B5:27FD=0DH)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		MOV	SI,OFFSET FCB4_2A34	; (72B5:2A34=0DH)
		CALL	SUB_06B1
		CALL	DSPY_CRLF_06FB
LOC_0C03:
;**CHANGED**	MOV	BYTE PTR DS:ALTR_OPB_064A+0,90H	; (72B5:064A=0C3H)
		MOV	OLD_RET_NOP_064A,0FFH ; (=0C3H) set NOP
		MOV	BYTE PTR FCB4_CUREC_2A54,0	; (=52H)
		MOV	WORD PTR FCB4_RECSZ_2A42,200H	; (72B5:2A42=4320H)
;**CHANGED**	MOV	BYTE PTR DATA_2872,0FFH	; (=0FFH)
		MOV	BYTE PTR SW_E_EMBED_REF,0FFH	; (=0FFH)
;**CHANGED**	MOV	BYTE PTR DATA_2870,0FFH	; (=0FFH)
		MOV	BYTE PTR SW_O_OUTPUT_LST,0FFH	; (=0FFH)
		MOV	DATA_2849,0		; (=0)
		MOV	DATA_284B,0		; (=0)
		MOV	BP,DATA_2893		; (=0)
		POP	AX

;==== External Entry into Subroutine ======================================

SUB_0C2E:
		OR	AL,AL
		JZ	LOC_RET_0C36
		MOV	DX,OFFSET MS_DIRFULL_2691	; (72B5:2691=4EH)
		STC				; Set carry flag

LOC_RET_0C36:
		RETN
SUB_0B70	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0C37	PROC	NEAR
		CALL	SUB_0E00
		JNC	LOC_0C3D
		RETN
LOC_0C3D:
		MOV	DATA_2889,DATA_2E9E_E	; (=0) (=0)
		MOV	AX,DATA_288F		; (=0)
		MOV	DATA_288D,AX		; (=0)
		XOR	AX,AX
		MOV	DATA_2867,AX		; (=0)
		MOV	DATA_2866,AL		; (=0)
;**CHANGED**	MOV	DS:ALTR_B_0EF8+1,AL	; (72B5:0EF9=0)
		MOV	DS:OLD_B_0EF9,AL	; (72B5:0EF9=0)
		MOV	DATA_2856,AL		; (=0)
		MOV	DATA_2919,AX		; (=0)
;**CHANGED**	MOV	DS:ALTR_W_0802+1,AX	; (72B5:0803=0)
		MOV	DS:OLD_W_0803,AX	; (72B5:0803=0)
		MOV	DATA_291B,AL		; (=0)
		MOV	DATA_2887,AL		; (=0)
		MOV	DATA_2854,AX		; (=0)
		CMP	BYTE PTR DATA_2861,1	; (=0)
		JNE	LOC_0CD1
		XOR	AX,AX
;**CHANGED**	MOV	DS:ALTR_B_10B6+1,AL	; (72B5:10B7=0)
		MOV	DS:OLD_B_10B7,AL	; (72B5:10B7=0)
		MOV	DATA_2853,AL		; (=0)
		MOV	DATA_2891,AX		; (=0)
		MOV	DATA_2A94,AX		; Code Segment value
		MOV	DATA_2A92,100H		; Code Offset value
		MOV	DATA_2A8C,AX		; (=0A0AH)
		MOV	DATA_2A8E,0FFFFH	; (=7845H)
		MOV	AX,WORD PTR FCB3_FILSZ_2A1F	; (72B5:2A1F=2058H)
		MOV	DATA_2851,AX		; (=0)
		MOV	DI,DATA_288F		; (=0)
		CMP	WORD PTR FCB3_EXT1_2A18,5845H	; 'EX' test for EXE
		JNE	LOC_0CB7
		CMP	BYTE PTR FCB3_EXT3_2A1A,45H	; (72B5:2A1A=20H) 'E'
		JNE	LOC_0CB7
		CALL	SUB_0D5A
		MOV	DI,DATA_2915		; (=0)
		TEST	BYTE PTR DATA_286D,0FFH	; (=0)
		JNZ	LOC_0CB7
		MOV	DATA_285A,0		; (=0)
LOC_0CB7:
		MOV	DATA_2893,DI		; (=0)
		MOV	BYTE PTR [DI],0C0H
		MOV	AH,3
		CALL	SUB_0F6C
		MOV	AL,41H			; 'A'
		STOSB				; Store al to es:[di]
		XOR	AX,AX
;**CHANGED**	MOV	DS:ALTR_W_1222+1,AX	; (72B5:1223=0)
		MOV	DS:OLD_W_1223,AX	; (72B5:1223=0)
		STOSW				; Store ax to es:[di]
		MOV	BYTE PTR DATA_2888,0	; (=0)
LOC_0CD1:
		MOV	AX,DATA_2851		; (=0)
		MOV	DATA_284D,AX		; (72B5:284D=0)
		MOV	WORD PTR FCB3_RECSZ_2A1D,200H	; (72B5:2A1D=90AH)
		MOV	WORD PTR FCB3_BLKNO_2A1B,0	; (72B5:2A1B=0D3AH)
		MOV	AL,DATA_2853		; (=0)
		MOV	FCB3_CUREC_2A2F,AL	; (=65H)
		MOV	DI,OFFSET INIT_CS_SEG_FIX	; (72B5:2603=30H)
		MOV	DX,DATA_2A94		; Code Segment value
		CALL	CNV_W_2_HX_151D
		MOV	DX,DATA_2A92		; Code Offset value
		INC	DI
		CALL	CNV_W_2_HX_151D
		MOV	DI,OFFSET DATA_2823	; (=0)
		XOR	AX,AX
		MOV	CX,4
		REP	STOSW			; Rep when cx >0 Store ax to es:[di]
		MOV	DI,OFFSET INIT_SP_SEG_FIX	; (72B5:2618=30H)
		MOV	DX,DATA_2A8C		; 
		CALL	CNV_W_2_HX_151D
		INC	DI
		MOV	CL,4
		SHL	DX,CL			; Shift w/zeros fill
		PUSH	DX
		MOV	DX,DATA_2A8E		; 
		CALL	CNV_W_2_HX_151D
		MOV	AX,DATA_285A		; (=0)
		MOV	DATA_2858,AX		; (=0)
		MOV	DATA_287F,OFFSET DTA4_2C9E	; (=0) (72B5:2C9E=0)
		POP	AX
		PUSH	AX
		ADD	DX,AX
;**CHANGED**	TEST	BYTE PTR DS:ALTR_B_10B6+1,0FFH	; (72B5:10B7=0)
		TEST	BYTE PTR DS:OLD_B_10B7,0FFH	; (72B5:10B7=0)
		PUSHF
		JZ	LOC_0D3D
		CALL	SUB_0EAB

ALTR_W_0D37:					; Altered code
;**CHANGED**	MOV	BX,0
		MOV	BX,OLD_W_0D38
		OR	BYTE PTR [BX],1
LOC_0D3D:
		POPF
		POP	DX
		JZ	LOC_0D53
		CALL	SUB_0EAB
;**CHANGED**	MOV	BX,DS:ALTR_W_0D37+1	; (72B5:0D38=0)
		MOV	BX,DS:OLD_W_0D38	; (72B5:0D38=0)
		OR	BYTE PTR [BX],1
		MOV	DATA_2825,DX		; (=0)
;**CHANGED**	MOV	DS:ALTR_W_10BC+2,DX	; (72B5:10BE=8888H)
		MOV	DS:OLD_W_10BE,DX	; (72B5:10BE=8888H)
LOC_0D53:
		CLC				; Clear carry flag
;**CHANGED**	MOV	BYTE PTR DS:ALTR_B_0FBA+1,0	; (72B5:0FBB=0)
		MOV	BYTE PTR DS:OLD_B_0FBB,0	; (72B5:0FBB=0)

LOC_RET_0D59:
		RETN
SUB_0C37	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0D5A	PROC	NEAR
;**CHANGED**	DEC	BYTE PTR DS:ALTR_B_10B6+1	; (72B5:10B7=0)
		DEC	BYTE PTR DS:OLD_B_10B7	; (72B5:10B7=0)
		MOV	CX,1AH
		MOV	WORD PTR FCB3_RECSZ_2A1D,1	; (72B5:2A1D=90AH)
		MOV	DX,OFFSET DTA1_2A7E	; (72B5:2A7E=72H)
		MOV	AH,1AH
		INT	21H			; DOS Services  ah=function 1Ah
						;  set DTA to ds:dx
		MOV	DX,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		MOV	CX,1AH
		MOV	AH,27H
		INT	21H			; DOS Services  ah=function 27h
						;  random block read, FCB @ds:dx
		OR	AL,AL
		JZ	LOC_0D7F
		JMP	SHORT LOC_0DFA
	;***	DB	90H
LOC_0D7F:
		MOV	AX,DATA_2A86		; 
		ADD	AX,1FH
		MOV	CL,5
		SHR	AX,CL			; Shift w/zeros fill
		MOV	DATA_2853,AL		; (=0)
		MOV	CL,9
		SHL	AX,CL			; Shift w/zeros fill
		XCHG	AX,BX
		MOV	AX,DATA_2A82		; 
		DEC	AX
		SHL	AX,CL			; Shift w/zeros fill
		SUB	AX,BX
		MOV	BX,DATA_2A80		; 
		CMP	BX,4
		JNE	LOC_0DA5
		MOV	BX,200H
LOC_0DA5:
		ADD	AX,BX
		MOV	DATA_2851,AX		; (=0)
		MOV	AX,DATA_2A96		; FCB3 Random Rec Num value
		MOV	FCB3_RNDRC_2A30,AX	; (=7073H)
		TEST	DATA_2A84,0FFFFH	; 
		JZ	LOC_RET_0D59
		MOV	DX,OFFSET DTA2_2A98
		MOV	AH,1AH
		INT	21H			; DOS Services  ah=function 1Ah
						;  set DTA to ds:dx
LOC_0DBF:
		MOV	DX,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		MOV	CX,4
		MOV	AH,27H
		INT	21H			; DOS Services  ah=function 27h
						;  random block read, FCB @ds:dx
		OR	AL,AL
		JNZ	LOC_0DFA
		MOV	BX,WORD PTR DTA2_W2_2A9A ; Segment value
		MOV	CL,4
		SHL	BX,CL			; Shift w/zeros fill
		ADD	BX,WORD PTR DTA2_2A98	; Offset value
		MOV	DI,DATA_288F		; (=0)
LOC_0DDD:
		CMP	DI,DATA_2915		; (=0)
		JAE	LOC_0DEC
		CMP	BX,[DI]
		JBE	LOC_0DEC
		ADD	DI,2
		JMP	SHORT LOC_0DDD
LOC_0DEC:
		MOV	AH,2
		CALL	SUB_0F6C
		XCHG	AX,BX
		STOSW				; Store ax to es:[di]
		DEC	DATA_2A84		; (=7420H)
		JNZ	LOC_0DBF
		RETN
LOC_0DFA:
		MOV	DX,OFFSET MS_ERR_RD_26C6	; (72B5:26C6=45H)
		JMP	LOC_0214
SUB_0D5A	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0E00	PROC	NEAR
		MOV	DX,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		MOV	DI,OFFSET FCB3_BLKNO_2A1B	; (72B5:2A1B=3AH)
		MOV	CX,19H			; 25 decimal, initiallize FCB3
		MOV	AL,0
		REP	STOSB			; Rep when cx >0 Store al to es:[di]
		MOV	AH,0FH
		INT	21H			; DOS Services  ah=function 0Fh
						;  open file, FCB @ ds:dx
		MOV	DATA_287F,OFFSET DTA4_2C9E	; (=0) (72B5:2C9E=0)
		MOV	WORD PTR FCB3_RECSZ_2A1D,200H	; (72B5:2A1D=90AH)
		OR	AL,AL
		JZ	LOC_RET_0E36
		MOV	DX,OFFSET MS_FILE_267D	; (72B5:267D=46H)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		MOV	SI,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		CALL	SUB_06B1
		MOV	DX,OFFSET MS_NOTFND_2683	; (72B5:2683=20H)
		MOV	AH,9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		STC				; Set carry flag

LOC_RET_0E36:
		RETN
SUB_0E00	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0E37	PROC	NEAR
		CALL	SCAN_SPTAB_0E3F
		CMP	AL,2CH			; ','
		JNE	LOC_0E49
		INC	SI

;==== External Entry into Subroutine ======================================
;
;         Scan off spaces and Tabs

SCAN_SPTAB_0E3F:
LOC_0E3F:
		LODSB				; String [si] to al
		CMP	AL,20H			; ' '
		JE	LOC_0E3F
		CMP	AL,9			; TAB
		JE	LOC_0E3F
		DEC	SI
LOC_0E49:
		CMP	AL,0DH			; CR
		RETN
SUB_0E37	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0E4C	PROC	NEAR
		MOV	SI,DATA_2893		; (=0)
LOC_0E50:
		MOV	DL,0
		TEST	BYTE PTR [SI],80H
		JZ	LOC_0E58
		RETN
LOC_0E58:
		MOV	BX,SI
LOC_0E5A:
		ADD	SI,3
		MOV	AL,[SI]
		TEST	AL,0C0H
		JNZ	LOC_0E67
		OR	DL,AL
		JMP	SHORT LOC_0E5A
LOC_0E67:
		OR	DL,DL
		JNZ	LOC_0E50
		OR	BYTE PTR [BX],20H	; ' '
		JMP	SHORT LOC_0E50
SUB_0E4C	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0E70	PROC	NEAR
		CMP	DATA_2891,40H		; (=0)
		MOV	DI,OFFSET DATA_2895	; 128-byte buffer
		JC	LOC_0E88
		MOV	CX,20H
		JMP	SHORT LOC_0E82

LOCLOOP_0E7F:
		ADD	DI,4
LOC_0E82:
		CMP	DX,[DI]
		JE	LOC_0E8F
		JNC	LOC_0E8D
LOC_0E88:
		SUB	DI,4
		JMP	SHORT LOC_0E8F
LOC_0E8D:
		LOOPNZ	LOCLOOP_0E7F		; Loop if zf=0, cx>0

LOC_0E8F:
		MOV	DI,[DI+2]
		JMP	SHORT LOC_0E97
LOC_0E94:
		ADD	DI,3
LOC_0E97:
		MOV	AL,[DI]
		TEST	AL,0C0H
		JZ	LOC_0E94
		TEST	AL,80H
		JNZ	LOC_0EA6
		CMP	DX,[DI+1]
		JA	LOC_0E94
LOC_0EA6:
;**CHANGED**	MOV	DS:ALTR_W_0D37+1,DI	; (72B5:0D38=0)
		MOV	DS:OLD_W_0D38,DI	; (72B5:0D38=0)
		RETN
SUB_0E70	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0EAB	PROC	NEAR
LOC_0EAB:
		CMP	BYTE PTR DATA_2861,1	; (=0)
		JNE	LOC_0EA6
;**CHANGED**	TEST	BYTE PTR DATA_2871,0FFH	; (=0FFH)
		TEST	BYTE PTR SW_R_TABLE_LST,0FFH	; (=0FFH)
		JZ	LOC_0EA6
		PUSH	DI
		MOV	BX,DATA_2858		; (=0)
		TEST	BYTE PTR DATA_2887,7FH	; (=0)
		JNZ	LOC_0EC9
		SUB	BX,DATA_2854		; (=0)
LOC_0EC9:
		CALL	SUB_0E70
		JZ	LOC_0EE4
		MOV	AH,6
		INC	DATA_2891		; (=0)
		CALL	SUB_0F76
		JC	ALTR_B_0EF8
		MOV	BYTE PTR [DI],40H	; '@'
		MOV	[DI+1],DX
		ADD	DI,3
		JMP	SHORT LOC_0F0C
LOC_0EE4:
		ADD	DI,3
		TEST	BYTE PTR [DI],0C0H
		JNZ	LOC_0EF1
		CMP	BX,[DI+1]
		JAE	LOC_0EE4
LOC_0EF1:
		MOV	AH,3
		CALL	SUB_0F76
		JNC	LOC_0F0C

ALTR_B_0EF8:					; Altered code
;**CHANGED**	MOV	AL,0
		MOV	AL,OLD_B_0EF9
		OR	AL,AL
		JNZ	LOC_0F6A
		PUSH	DX
		MOV	DX,OFFSET MS_REF_TBL_INCOMP	; (72B5:27B6=7)
		MOV	AH,9
;**CHANGED**	MOV	DS:ALTR_B_0EF8+1,AH	; (72B5:0EF9=0)
		MOV	DS:OLD_B_0EF9,AH	; (72B5:0EF9=0) value=9
		INT	21H			; DOS Services  ah=function 09h
						;  display char string at ds:dx
		JMP	SHORT LOC_0F69
LOC_0F0C:
		MOV	AL,OPW_HI_NBL_286A	; (72B5:286A=0)
		MOV	CL,4
		SHR	AL,CL			; Shift w/zeros fill
		MOV	CL,30H			; '0'
		AND	CL,OPJ_HI_BYT_2869	; (72B5:2869=0)
		OR	AL,CL
		TEST	BYTE PTR DATA_2887,7FH	; (=0)
		JZ	LOC_0F24
		MOV	AL,0
LOC_0F24:
		MOV	[DI],AL
		MOV	[DI+1],BX
		MOV	BYTE PTR DATA_2888,0FFH	; (=0)
		TEST	DATA_2891,3FH		; (=0)
		JNZ	LOC_0F6A
		MOV	SI,DATA_2893		; (=0)
		MOV	DI,OFFSET DATA_2895	; 128-byte buffer
		PUSH	DX
		PUSH	BX
		MOV	BL,20H			; ' '
		MOV	CL,5
		MOV	DX,DATA_2891		; (=0)

ALTR_B_0F47:					; Altered code
;**CHANGED**	MOV	AL,0
		MOV	AL,OLD_B_0F48
		CMP	AL,DL
		JE	LOC_0F68
;**CHANGED**	MOV	DS:ALTR_B_0F47+1,DL	; (72B5:0F48=0)
		MOV	DS:OLD_B_0F48,DL	; (72B5:0F48=0)
		SHR	DX,CL			; Shift w/zeros fill
LOC_0F53:
		MOV	CX,DX
		MOV	AX,SI
		INC	SI
		MOVSW				; Mov [si] to es:[di]
		STOSW				; Store ax to es:[di]

LOCLOOP_0F5A:
		ADD	SI,3
		TEST	BYTE PTR [SI],0C0H
		JZ	LOCLOOP_0F5A
		LOOP	LOCLOOP_0F5A		; Loop if cx > 0

		DEC	BL
		JNZ	LOC_0F53
LOC_0F68:
		POP	BX
LOC_0F69:
		POP	DX
LOC_0F6A:
		POP	DI
		RETN
SUB_0EAB	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0F6C	PROC	NEAR
		CALL	SUB_0F76
		JNC	LOC_RET_0F75
		POP	AX			; equallize stack
		JMP	LOC_0126		; memory full error message

LOC_RET_0F75:
		RETN
SUB_0F6C	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0F76	PROC	NEAR
		PUSH	DI
		PUSH	SI
		PUSH	CX
		PUSH	AX
		MOV	AL,AH
		MOV	AH,0
		MOV	CX,DATA_2915		; (=0)
		MOV	SI,CX
		SUB	CX,DI
		INC	CX
		MOV	DI,SI
		ADD	DI,AX
		CMP	DI,DATA_2E9E_E		; (=0)
		JB	LOC_0F97
		CMP	DATA_2883,DI		; (=0)
		JAE	LOC_0F9A
LOC_0F97:
		STC				; Set carry flag
		JMP	SHORT LOC_0FA3
LOC_0F9A:
		MOV	DATA_2915,DI		; (=0)
		STD				; Set direction flag
		REP	MOVSB			; Rep when cx >0 Mov [si] to es:[di]
		CLD				; Clear direction
		CLC				; Clear carry flag
LOC_0FA3:
		POP	AX
		POP	CX
		POP	SI
		POP	DI

LOC_RET_0FA7:
		RETN
SUB_0F76	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_0FA8	PROC	NEAR
		TEST	BYTE PTR DATA_2888,0FFH	; (=0)
		JZ	LOC_RET_0FA7
		MOV	DI,BP
		MOV	AL,[DI]
		AND	AL,1			; clear all but bit-0
;**CHANGED**	MOV	DS:ALTR_B_10AA+1,AL	; (72B5:10AB=0)
		MOV	DS:OLD_B_10AB,AL	; (72B5:10AB=0)
		JZ	LOC_0FC3

ALTR_B_0FBA:					; Altered code
;**CHANGED**	MOV	AL,0
		MOV	AL,OLD_B_0FBB
		OR	AL,AL
		JZ	LOC_0FC3
		CALL	SUB_1221
LOC_0FC3:
		PUSH	WORD PTR [DI+1]
		MOV	SI,BP
		MOV	BYTE PTR DATA_2863,0	; (=0)
;**CHANGED**	MOV	AL,DATA_2870		; (=0FFH)
		MOV	AL,SW_O_OUTPUT_LST	; (=0FFH)
		PUSH	AX
		OR	AL,AL
		JZ	LOC_0FD8
;**CHANGED**	MOV	AL,DATA_2872		; (=0FFH)
		MOV	AL,SW_E_EMBED_REF	; (=0FFH)
LOC_0FD8:
;**CHANGED**	MOV	DATA_2870,AL		; (=0FFH)
		MOV	SW_O_OUTPUT_LST,AL		; (=0FFH)
		CALL	SUB_1067
		XOR	CX,CX
LOC_0FE0:
		INC	DATA_2863		; (=0)
		MOV	AL,DATA_2863		; (=0)
		MOV	BX,8
		CMP	BYTE PTR DATA_2862,41H	; (=0) 'A'
		JNE	LOC_0FF4
		INC	AL
		INC	BX
LOC_0FF4:
		OR	CX,CX
		JZ	LOC_100C
		CMP	AL,9
		JBE	LOC_1009
		CALL	WR_CRLF_05AE
		CALL	SUB_1067
		MOV	BYTE PTR DATA_2863,2	; (=0)
		MOV	CX,BX
LOC_1009:
		CALL	SUB_060E
LOC_100C:
		CMP	BYTE PTR DATA_2862,41H	; (=0) 'A'
		JNE	LOC_1016
		CALL	WR_L_05B6
LOC_1016:
		LODSB				; String [si] to al
		LODSW				; String [si] to ax
		CALL	SUB_058C
		MOV	CX,4
		MOV	AL,[SI-3]
		TEST	AL,40H			; '@'
		JZ	LOC_102D
		TEST	AL,1
		JZ	LOC_104D
		MOV	AL,53H			; 'S'
		JMP	SHORT LOC_1049
LOC_102D:
		PUSH	AX
		CALL	SUB_05BF
		POP	AX
		MOV	CL,4
		SHR	AL,CL			; Shift w/zeros fill
		AND	AL,3			; clear all but 2 LSB's
		MOV	BX,OFFSET DATA_24DC	; (72B5:24DC=44H)
		XLAT				; al=[al+[bx]] table
		CALL	WR_CHR_AL_05C1
		DEC	CX
		MOV	AL,[SI-3]
		AND	AL,0FH			; clear high 4-bits
		MOV	BX,OFFSET DATA_24D3	; (72B5:24D3=49H)
		XLAT				; al=[al+[bx]] table
LOC_1049:
		CALL	WR_CHR_AL_05C1
		DEC	CX
LOC_104D:
		CMP	BYTE PTR [SI],3FH	; '?'
		JBE	LOC_0FE0
		CALL	WR_CRLF_05AE
		POP	AX
;**CHANGED**	MOV	DATA_2870,AL		; (=0FFH)
		MOV	SW_O_OUTPUT_LST,AL	; (=0FFH)
		MOV	BP,SI
		LODSB				; String [si] to al
		TEST	AL,80H
		JZ	LOC_1065
		MOV	BYTE PTR DATA_2888,0	; (=0)
LOC_1065:
		POP	DX
		RETN
SUB_0FA8	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_1067	PROC	NEAR
		CMP	BYTE PTR DATA_2862,41H	; (=0) 'A'
		JNE	LOC_107B
		PUSH	CX
		MOV	CX,6

LOCLOOP_1072:
		CALL	SUB_05BC
		LOOP	LOCLOOP_1072		; Loop if cx > 0

		POP	CX
		JMP	LOC_05B9
LOC_107B:
		MOV	BYTE PTR DATA_2848,0	; (=0)
		RETN
SUB_1067	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_1081	PROC	NEAR

ALTR_J_B_1081:					; Altered JMP offset, to 10A7 or 'NOP'

;**CHANGED**	JMP	SHORT LOC_RET_10A7
		TEST	BYTE PTR OLD_JUMP_1082,0FFH
		JZ	LOC_RET_10A7

;==== External Entry into Subroutine ======================================

SUB_1083:

						; 24H s/b LOC_RET_10A7-SUB_1081-2
;**CHANGED**	MOV	BYTE PTR DS:ALTR_J_B_1081+1,24H	; (72B5:1082=24H) '$'
;**CHANGED**	MOV	BYTE PTR DS:ALTR_J_B_1081+1,LOC_RET_10A7-SUB_1081-2
		MOV	BYTE PTR DS:OLD_JUMP_1082,0	;take jump next time
		PUSH	DI
		PUSH	DX
		MOV	SI,OFFSET DATA_2823	; (=0)
		MOV	DI,OFFSET FIX_DS_SEG	; (72B5:2470=30H)
		MOV	CX,4

LOCLOOP_1093:
		PUSH	CX
		LODSW				; String [si] to ax
		XCHG	AX,DX
		CALL	CNV_W_2_HX_151D
		POP	CX
		ADD	DI,6
		LOOP	LOCLOOP_1093		; Loop if cx > 0

		MOV	SI,OFFSET MN_ASSUME	; (72B5:2464=9)
		CALL	WR_STRING_0601
		POP	DX
		POP	DI

LOC_RET_10A7:
		RETN
SUB_1081	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_10A8	PROC	NEAR
		PUSH	DX
		PUSHF

ALTR_B_10AA:					; Altered code
;**CHANGED**	MOV	AL,0
		MOV	AL,OLD_B_10AB
		TEST	AL,1
		JZ	LOC_110E
		MOV	WORD PTR FIX_MN_STK,8A0DH	; "CR LF", high bit set

ALTR_B_10B6:					; Altered code
;**CHANGED**	MOV	AL,0
		MOV	AL,OLD_B_10B7
		OR	AL,AL
		JZ	LOC_10C8
ALTR_W_10BC:
;**CHANGED**	CMP	DX,8888H
		CMP	DX,OLD_W_10BE
		JNE	LOC_10C8
		MOV	WORD PTR FIX_MN_STK,2020H	; "Space Space"
LOC_10C8:
		MOV	AL,53H			; 'S'
		CALL	WR_CHR_AL_05C1
;CHANGED**	MOV	DS:ALTR_W_1222+1,DX	; (72B5:1223=0)
		MOV	DS:OLD_W_1223,DX	; (72B5:1223=0)
		CALL	SUB_05A6
		MOV	SI,OFFSET MN_SEG_STK	; (72B5:2453=9)
		CALL	WR_STRING_0601
		MOV	WORD PTR FIX_MN_STK,8A0DH	; "CR LF", bit-7 set
;**CHANGED**	MOV	BYTE PTR DS:ALTR_B_0FBA+1,0FFH	; (72B5:0FBB=0)
		MOV	BYTE PTR DS:OLD_B_0FBB,0FFH	; (72B5:0FBB=0)
		TEST	BYTE PTR DATA_2887,7FH	; (=0)
		JNZ	LOC_10EF
		CALL	SUB_1083
LOC_10EF:
		OR	DX,DX
		JNZ	LOC_110E
		MOV	AX,DATA_285A		; (=0)
		OR	AX,AX
		JZ	LOC_110E
		PUSH	DX
		XCHG	AX,DX
		MOV	SI,OFFSET MN_ORG_$	; (72B5:2494=9)
		CALL	WR_STRING_0601
		CALL	SUB_05A6
		MOV	AL,48H			; 'H'
		CALL	WR_CHR_AL_05C1
		CALL	WR_CRLF_05AE
		POP	DX
LOC_110E:
		MOV	AX,DATA_2858		; (=0)
		TEST	DATA_284D,0FFFFH	; (72B5:284D=0)
		JZ	LOC_111D
		CMP	AX,DX
		JE	LOC_1122
LOC_111D:
		CALL	SUB_119B
		JMP	SHORT LOC_1198
LOC_1122:
		PUSH	SI
ALTR_W_1123:
;**CHANGED**	MOV	SI,0
		MOV	SI,OLD_W_1124
		CMP	DX,[SI-4]
		JNE	LOC_1185
		TEST	BYTE PTR [SI-1],0FFH
		JZ	LOC_1185
		PUSH	DX
		MOV	DL,[SI-1]
		TEST	DL,80H
		JZ	LOC_1150
		PUSH	SI
		XOR	DX,DX
LOC_113D:
		LODSB				; String [si] to al
		INC	DX
		TEST	AL,80H
		JZ	LOC_113D
		CALL	WR_SEMI_05B9
		CALL	SUB_05BC
		CALL	WR_STRING_0601
		CALL	WR_CRLF_05AE
		POP	SI
LOC_1150:
		CMP	BYTE PTR [SI],0AEH
		JE	LOC_1184
		POP	AX
		CALL	WR_STRING_0601
		TEST	BYTE PTR DATA_2887,0FH	; (=0)
		JNZ	LOC_1167
		INC	DL
		MOV	AL,3AH			; ':'
		CALL	WR_CHR_AL_05C1
LOC_1167:
		CMP	DL,7
		JBE	LOC_1181
		TEST	BYTE PTR DATA_2887,0FH	; (=0)
		JZ	LOC_117E
		MOV	SI,OFFSET DATA_218C_EQU	; (72B5:218C=9)
		CALL	WR_STRING_0601
		MOV	AL,24H			; '$'
		CALL	WR_CHR_AL_05C1
LOC_117E:
		CALL	WR_CRLF_05AE
LOC_1181:
		POP	SI
		JMP	SHORT LOC_1198
LOC_1184:
		POP	DX
LOC_1185:
		POP	SI
		CALL	WR_L_05B6
		CALL	SUB_05A6
		TEST	BYTE PTR DATA_2887,0FH	; (=0)
		JNZ	LOC_1198
		MOV	AL,3AH			; ':'
		CALL	WR_CHR_AL_05C1
LOC_1198:
		POPF
		POP	DX
		RETN
SUB_10A8	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_119B	PROC	NEAR
		PUSH	DX
;**CHANGED**	MOV	DI,OFFSET DATA_298B	; 132-byte line buffer
		MOV	DI,OFFSET LINE_BUF_132CHR ; 132-byte line buffer
		PUSH	DI
		PUSH	AX
;**CHANGED**	MOV	SI,DS:ALTR_W_1123+1	; (72B5:1124=0)
		MOV	SI,DS:OLD_W_1124	; (72B5:1124=0)
		CMP	DX,[SI-4]
		JNE	LOC_11B5
		TEST	BYTE PTR [SI-1],0FFH
		JZ	LOC_11B5
		CALL	WRT_STRING_18A4
		JMP	SHORT LOC_11BB
LOC_11B5:
		MOV	AL,4CH			; 'L'
		STOSB				; Store al to es:[di]
		CALL	CNV_W_2_HX_151D
LOC_11BB:
		MOV	SI,OFFSET DATA_218C_EQU	; (72B5:218C=9)
		CALL	WRT_STRING_18A4
		POP	AX
		SUB	AX,DX
		XCHG	AX,DX
		MOV	AL,24H			; '$'
		MOV	AH,2DH			; '-'
		OR	DH,DH
		JNS	LOC_11D1		; Jump if not sign
		MOV	AH,2BH			; '+'
		NEG	DX
LOC_11D1:
		STOSW				; Store ax to es:[di]
		CALL	SUB_1345
		CALL	SUB_136C
		MOV	BYTE PTR [DI],0
		POP	SI
		CALL	WR_STRING_0601
		CALL	WR_CRLF_05AE
		POP	DX
		RETN
SUB_119B	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_11E4	PROC	NEAR
		MOV	AL,2DH			; '-'
		STOSB				; Store al to es:[di]

;==== External Entry into Subroutine ======================================

SUB_11E7:
		PUSH	CX
		PUSH	SI
		MOV	SI,OFFSET LOC_1215
		MOV	CX,5
LOC_11EF:
		MOV	AL,0
		ADD	SI,2
LOC_11F4:
		SUB	BX,[SI]
		JC	LOC_11FC
		INC	AL
		JMP	SHORT LOC_11F4
LOC_11FC:
		ADD	BX,[SI]
		OR	AL,30H			; '0'
		OR	CH,CH
		JNZ	LOC_1208
		TEST	AL,0FH
		JZ	LOC_120B
LOC_1208:
		STOSB				; Store al to es:[di]
		INC	CH
LOC_120B:
		DEC	CL
		JNZ	LOC_11EF
		OR	CH,CH
		JNZ	LOC_1214
		STOSB				; Store al to es:[di]
LOC_1214:
		POP	SI
LOC_1215:
		POP	CX
		RETN
SUB_11E4	ENDP

DATA_1217	DW	2710H, 3E8H, 64H
		DW	0AH, 1

;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_1221	PROC	NEAR
		PUSH	DX
ALTR_W_1222:
;**CHANGED**	MOV	DX,0
		MOV	DX,OLD_W_1223
		CALL	SUB_05BC
		MOV	AL,53H			; 'S'
		CALL	WR_CHR_AL_05C1
		CALL	SUB_05A6
		MOV	SI,OFFSET DATA_2182	; (72B5:2182=9)
		CALL	WR_STRING_0601
		POP	DX
		RETN
SUB_1221	ENDP


;==========================================================================
;         Read byte and	skip over Space or Tab
;==========================================================================

RD_SK_SPTB_1238	PROC	NEAR
LOC_1238:
		CALL	RD_NXT_BYT_1B1B
		CMP	AL,20H			; ' '
		JE	LOC_1238
		CMP	AL,9
		JE	LOC_1238
		RETN
RD_SK_SPTB_1238	ENDP

		DB	10,'Op-codes '

;==========================================================================
;			       SUBROUTINE
;==========================================================================
; op-codes: 26, 2E, 36, 3E

OP_1250		PROC	NEAR
LOC_1250:
		TEST	BYTE PTR DATA_2866,0FFH	; (=0)
		JZ	LOC_125A
		JMP	LOC_17D1
LOC_125A:
		MOV	DATA_2866,AL		; (=0)
		SHL	AL,1			; Shift w/zeros fill
		NOT	AL
		AND	AL,30H			; clear all but bits 4 & 5
		MOV	OPJ_HI_BYT_2869,AL	; (72B5:2869=0)
		JMP	SHORT LOC_1277

;==== External Entry into Subroutine ======================================
; op-codes: F0, F2, F3

OP_1268:
		MOV	SI,OPW_TBL_WD_285F	; (72B5:285F=0)
		AND	SI,0FFFH		; clear high 4-bits
		ADD	SI,OFFSET MN_AAA	; (72B5:20F4=41H)
		CALL	WR_STRING_0601

;==== External Entry into Subroutine ======================================

SUB_1277:
LOC_1277:
		CALL	RD_NXT_BYT_1B1B
		MOV	AH,0
		MOV	BX,AX
		MOV	OPCODE_BYT_286B,AL	; (72B5:286B=0)
		ADD	BX,BX
		ADD	BX,BX
		ADD	BX,OFFSET OPW_00_ADD	; Op-code Dispatch Table
		MOV	CX,[BX]
		MOV	OPW_TBL_WD_285F,CX	; (72B5:285F=0)
		MOV	DH,0F0H			; mask for AND 
		AND	DH,CH			; keep high 4-bits
		MOV	OPW_HI_NBL_286A,DH	; (72B5:286A=0)
		AND	BYTE PTR OPW_HI_NBL_286A,0F0H	; (72B5:286A=0)
;**CHANGED**	MOV	DI,OFFSET DATA_298B	; 132-byte line buffer
		MOV	DI,OFFSET LINE_BUF_132CHR ; 132-byte line buffer
		MOV	BX,[BX+2]
		TEST	BYTE PTR DATA_2866,0FFH	; (=0)
		JNZ	LOC_12AD
		MOV	OPJ_HI_BYT_2869,BH	; (72B5:2869=0)
LOC_12AD:
		AND	BH,0FH			; keep low 12-bits of BX
;**CHANGED**	ADD	BX,WORD PTR OPJ_BASE_288B	; (72B5:288B=1250H)
		ADD	BX,OFFSET LOC_1250	; beginning of op-code handlers
		XCHG	CX,BX

						; Op-code byte (X4) is index
		JMP	CX			;*Register jump
		DB	10,'Dispatch '
;==== External Entry into Subroutine ======================================
; op-codes: 80-82

OP_12B8:
		CALL	SUB_17E6
LOC_12BB:
		CALL	SUB_18B0
		JMP	SHORT LOC_1322

;==== External Entry into Subroutine ======================================
; op-codes: 83

OP_12C0:
		CALL	SUB_17E6
		CALL	SUB_18B0
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		CALL	RD_NXT_BYT_1B1B
		CBW				; Convrt byte to word
		XCHG	AX,DX
		MOV	BYTE PTR OPW_HI_NBL_286A,0	; (72B5:286A=0)
		CALL	SUB_1420
		CALL	SUB_13CB
		OR	DH,DH
		JNZ	LOC_12DE
		RETN
LOC_12DE:
		DEC	DI
		CMP	BYTE PTR [DI-1],2CH	; ','
		JNE	LOC_12DE
		NEG	DX
		MOV	AL,2DH			; '-'
		STOSB				; Store al to es:[di]
		JMP	SHORT LOC_1345
	;***	DB	90H

;==== External Entry into Subroutine ======================================
; op-codes: C4, C5

OP_12ED:
		CALL	PARS_MOD_B_1836
		CALL	SUB_1551
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		MOV	SI,OFFSET DATA_2174	; (72B5:2174=44H)
		CALL	WRT_STRING_18A4
		JMP	LOC_18BA

;==== External Entry into Subroutine ======================================
; op-codes: C6, C7

OP_12FF:
		CALL	PARS_MOD_B_1836
		OR	AL,AL
		JZ	LOC_12BB
		JMP	LOC_17FE

;==== External Entry into Subroutine ======================================
; op-codes: C2

OP_1309:
		MOV	BX,OFFSET MAC_RET_NEAR_P	; (72B5:258B=0)
		JMP	SHORT LOC_1311

;==== External Entry into Subroutine ======================================
; op-codes: CA

OP_130E:
		MOV	BX,OFFSET MAC_RET_FAR_P	; (72B5:253A=0)
LOC_1311:
		MOV	BYTE PTR [BX],1
		CALL	SUB_1B10
		INC	DATA_285C		; (=0)
		JMP	SHORT LOC_1342

;==== External Entry into Subroutine ======================================
; op-codes: 04, 05, 0C, 0D, 14, 15, 1C, 1D, 24, 25, 2C, 2D, 34, 35, 3C, 3D,
; A8, A9, A8, A9

OP_131D:
		MOV	AL,0
LOC_131F:
		CALL	SUB_1554
LOC_1322:
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		TEST	BYTE PTR OPCODE_BYT_286B,1	; (72B5:286B=0)
		JZ	LOC_132F
		JMP	LOC_13C3

;==== External Entry into Subroutine ======================================

SUB_132F:
LOC_132F:
		CALL	RD_NXT_BYT_1B1B

;==== External Entry into Subroutine ======================================

SUB_1332:
LOC_1332:
		MOV	BYTE PTR OPW_HI_NBL_286A,0	; (72B5:286A=0)

;==== External Entry into Subroutine ======================================

SUB_1337:
		MOV	AH,0
		MOV	DX,AX
;**CHANGED**	TEST	BYTE PTR DATA_2876,0FFH	; (=0FFH)
		TEST	BYTE PTR SW_B_BYTE_REFS,0FFH	; (=0FFH)
		JZ	LOC_1345

;==== External Entry into Subroutine ======================================

SUB_1342:
LOC_1342:
		CALL	SUB_0EAB

;==== External Entry into Subroutine ======================================

SUB_1345:
LOC_1345:
		OR	DX,DX
		JZ	LOC_1386
		CALL	SUB_138A
		CMP	DX,0AH
		JB	LOC_RET_1385
		MOV	AL,DL
		CALL	SUB_1A7D
		JNC	LOC_136C
		PUSH	DI
		MOV	DI,OFFSET DATA_287C	; (72B5:287C=48H)
		MOV	AH,27H			; ''' single quote
		CMP	AL,AH			; number TEN
		JNE	LOC_1364
		MOV	AH,22H			; '"' double quote
LOC_1364:
		MOV	[DI-1],AH
		OR	AH,80H			; set bit-7
		STOSW				; Store ax to es:[di]
		POP	DI

;==== External Entry into Subroutine ======================================

SUB_136C:
LOC_136C:
		MOV	AL,[DI-1]
		CMP	AL,48H			; 'H'
		JE	LOC_RET_1385
;**CHANGED**	TEST	BYTE PTR RAD16_FLAG_2877,0FFH	; (72B5:2877=0FFH)
		TEST	BYTE PTR SW_H_HEX_SUFFIX,0FFH	; (72B5:2877=0FFH)
		JZ	LOC_1382
		CMP	AL,42H			; 'B'
		JE	LOC_1382
		CMP	AL,44H			; 'D'
		JNE	LOC_RET_1385
LOC_1382:
		MOV	AL,48H			; 'H'
		STOSB				; Store al to es:[di]

LOC_RET_1385:
		RETN
LOC_1386:
		MOV	AL,30H			; '0'
		STOSB				; Store al to es:[di]
		RETN

;==== External Entry into Subroutine ======================================
; Convert word in DX to ASCII HEX and write to file

SUB_138A:
;**LOC_138A:
		MOV	BYTE PTR DATA_13C2,0	; zero suppress flag = true
		MOV	AL,DH			; to convert high byte
		CALL	SUB_1396
		MOV	AL,DL			; to convert low byte

;==== External Entry into Subroutine ======================================
; Convert byte in AL to ASCII HEX and write to file

SUB_1396:
		MOV	AH,AL			; save low nyble
		MOV	CL,4			; shift high nyble right
		SHR	AL,CL			; Shift w/zeros fill
		CALL	SUB_13A1		; convert nyble to ASCII
		MOV	AL,AH			; convert nyble to ASCII

;==== External Entry into Subroutine ======================================
; Convert nyble to ASCII HEX and write to file

SUB_13A1:
		AND	AL,0FH			; clear high 4-bits
		TEST	BYTE PTR DATA_13C2,0FFH	; suppress zero?
		JNZ	LOC_13BA
		OR	AL,AL
		JNZ	LOC_13AF
		RETN
LOC_13AF:
		MOV	DATA_13C2,AL		; zero suppress flag
		CMP	AL,0AH			; number TEN
		JB	LOC_13BA
		MOV	BYTE PTR [DI],30H	; '0'
		INC	DI
LOC_13BA:
		ADD	AL,90H
		DAA				; Decimal adjust
		ADC	AL,40H			; '@'
		DAA				; Decimal adjust
		STOSB				; Store al to es:[di]

LOC_RET_13C1:
		RETN

DATA_13C2	DB	0			; zero suppress flag

;==========================================================================
LOC_13C3:
		MOV	BYTE PTR OPW_HI_NBL_286A,0	; (72B5:286A=0)
		CALL	SUB_141D
OP_1250		ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_13CB	PROC	NEAR
		MOV	AL,DL
		CALL	SUB_1A7D
		JNC	LOC_RET_13C1
		MOV	AL,DH
		CALL	SUB_1A7D
		JNC	LOC_RET_13C1
		MOV	AH,DL
		PUSH	DI
		PUSH	BX
		MOV	DI,OFFSET DATA_287C	; (72B5:287C=48H)
		MOV	BL,27H			; '''
		CMP	AL,BL
		JE	LOC_13EA
		CMP	AH,BL
		JNE	LOC_13EC
LOC_13EA:
		MOV	BL,22H			; '"'
LOC_13EC:
		MOV	[DI-1],BL
		STOSW				; Store ax to es:[di]
		XCHG	AX,BX
		OR	AL,80H
		STOSB				; Store al to es:[di]
		POP	BX
		POP	DI
		RETN
SUB_13CB	ENDP

		DB	0FEH, 6, 5CH, 28H	; (apparemtly unused)

;==========================================================================
;			       SUBROUTINE
;==========================================================================
; op-codes: 9A, EA

OP_13FB		PROC	NEAR
		CALL	SUB_1B10
		XCHG	BX,DX
		CALL	SUB_1B10
		MOV	CL,4
		PUSH	DX
		SHL	DX,CL			; Shift w/zeros fill
		ADD	BX,DX
		XCHG	BX,DX
		CALL	SUB_14C8
		POP	DX
		CALL	SUB_1420
		SUB	DI,5
		RETN
OP_13FB		ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================
; op-codes: A0, A1

OP_1417		PROC	NEAR
		CALL	SUB_15FA
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]

;==== External Entry into Subroutine ======================================

SUB_141D:
LOC_141D:
		CALL	SUB_1B10

;==== External Entry into Subroutine ======================================

SUB_1420:
;**CHANGED**	MOV	DS:ALTR_W_0945+1,DX	; (72B5:0946=0)
		MOV	DS:OLD_W_0946,DX	; (72B5:0946=0)
		PUSH	BX
		MOV	BL,OPJ_HI_BYT_2869	; (72B5:2869=0)
		TEST	BL,80H
		JNZ	LOC_1446		; jump if bit-7=1
		AND	BL,30H			; clear all but bits 4 & 5
		MOV	CL,3			; align as word index value
		SHR	BL,CL			; Shift w/zeros fill
		MOV	BH,0
		MOV	AX,DATA_2823[BX]	; 4-words indexed
		OR	AX,AX
		JZ	LOC_1446
		ADD	DX,AX
;**CHANGED**	MOV	BYTE PTR DS:ALTR_J_B_0943+1,0	; (72B5:0944=0AH)
		MOV	BYTE PTR DS:OLD_JUMP_0944,0FFH	; don't take jump
LOC_1446:
		POP	BX

;==== External Entry into Subroutine ======================================

SUB_1447:
LOC_1447:
		CALL	SUB_181D
		PUSH	DI
		MOV	DI,DATA_288D		; (=0)
		CMP	DI,DATA_2893		; (=0)
		JAE	LOC_147C
		MOV	AX,[DI]
		CMP	AX,DATA_2858		; (=0)
		POP	DI
		JNC	LOC_147B
;**CHANGED**	MOV	DX,DS:ALTR_W_0945+1	; (72B5:0946=0)
		MOV	DX,DS:OLD_W_0946	; (72B5:0946=0)
		TEST	DX,0F000H
		JZ	LOC_146E
		MOV	AX,3F09H		; "TAB ?"
		STOSW				; Store ax to es:[di]
		JMP	SHORT LOC_1472
LOC_146E:
		MOV	CL,4
		SHL	DX,CL			; Shift w/zeros fill
LOC_1472:
;**CHANGED**	MOV	DS:ALTR_W_09A0+1,DX	; (72B5:09A1=0)
		MOV	DS:OLD_W_09A1,DX	; (72B5:09A1=0)
		MOV	AL,53H			; 'S'
		JMP	LOC_1519
LOC_147B:
		PUSH	DI
LOC_147C:
		CALL	SUB_0E70
		TEST	BYTE PTR [DI],20H	; ' '
		POP	DI
		JZ	LOC_148F
;**CHANGED**	TEST	BYTE PTR DATA_2873,0FFH	; (=0FFH)
		TEST	BYTE PTR SW_L_LABEL_NUMB,0FFH	; (=0FFH)
		JNZ	LOC_148F
		JMP	LOC_1345
LOC_148F:
		MOV	AL,OPW_HI_NBL_286A	; (72B5:286A=0)
		MOV	AH,DATA_2887		; (=0)
		CMP	DX,DATA_285A		; (=0)
		JAE	LOC_14B8
		OR	AH,AH
		JNZ	LOC_14C8
		OR	AL,AL
		JZ	LOC_14B5
		CMP	AL,60H			; '`'
		JA	LOC_14C8
		CMP	BYTE PTR [DI-1],3AH	; ':'
		JE	LOC_14B5
		MOV	AX,5344H		; 'DS'
		STOSW				; Store ax to es:[di]
		MOV	AL,3AH			; ':'
		STOSB				; Store al to es:[di]
LOC_14B5:
		JMP	LOC_1342
LOC_14B8:
		OR	AX,AX
		JNZ	LOC_14C8
		CMP	DX,0FFFFH		; test for 0FFFF (s/b H)
	;***	nop				;*Fixup for MASM (M)
		PATCH83	0FFH			;PATCH83 edited in
;**FIXED**	JE	LOC_1514
		JNE	LOC_14BC_X		; jump, could be label

		; new code to correct the 0FFFF 'H' suffix (JEG)
		CALL	SUB_138A		; convert 0FFFF to HEX
		MOV	AL,'H'			; output 'H' Hex suffix
		STOSB
		RETN

LOC_14BC_X:	MOV	SI,OFFSET MN_OFFSET	; (72B5:23A4=4FH)
		CALL	WRT_STRING_18A4

;==== External Entry into Subroutine ======================================

SUB_14C8:
LOC_14C8:
		CMP	BYTE PTR DATA_2861,2	; (=0)
		JE	LOC_14D9
		TEST	BYTE PTR DATA_2887,80H	; (=0)
		JNZ	LOC_RET_1501
		JMP	LOC_0EAB
LOC_14D9:
		CALL	SUB_1B70
		JC	LOC_150D
		JZ	LOC_1502
		TEST	BYTE PTR OPW_HI_NBL_286A,0FFH	; (72B5:286A=0)
		JZ	LOC_14F2
		CMP	BYTE PTR [SI-2],3
		JNE	LOC_14F2
		PUSH	SI
		CALL	SUB_1897
		POP	SI
LOC_14F2:
		PUSH	SI
		CALL	WRT_STRING_18A4
		POP	AX
		XCHG	AX,SI
		TEST	BYTE PTR [SI-1],80H
		JZ	LOC_RET_1501
;**CHANGED**	MOV	DS:ALTR_W_09E2+1,AX	; (72B5:09E3=0FFFFH)
		MOV	DS:OLD_W_09E3,AX	; (72B5:09E3=0FFFFH)

LOC_RET_1501:
		RETN

LOC_1502:
		TEST	BYTE PTR [SI-1],80H
		JZ	LOC_150D
		INC	SI
;**CHANGED**	MOV	DS:ALTR_W_09E2+1,SI	; (72B5:09E3=0FFFFH)
		MOV	DS:OLD_W_09E3,SI	; (72B5:09E3=0FFFFH)
LOC_150D:
		TEST	BYTE PTR DATA_2887,80H	; (=0)
		JZ	LOC_1517

;**LOC_1514:
;**FIXED**	JMP	LOC_138A		; convert DX to ASCII HEX
		; new code to correct the 'D' command 'H' suffix (JEG)
		CALL	SUB_138A		; convert number to HEX
		MOV	AL,'H'			; output 'H' Hex suffix
		STOSB
		RETN

LOC_1517:
		MOV	AL,4CH			; 'L'
LOC_1519:
		STOSB				; Store al to es:[di]
		CALL	SUB_0EAB
OP_1417		ENDP


;==========================================================================
;         Convert word in DX to HEX, store [DI]
;==========================================================================

CNV_W_2_HX_151D	PROC	NEAR
		MOV	AL,DH
		CALL	CNV_B_2_HX_1524
		MOV	AL,DL

;==== External Entry into Subroutine ======================================
;
;         Convert byte in AL to HEX, store [DI]

CNV_B_2_HX_1524:
		MOV	AH,AL
		SHR	AL,1			; Shift w/zeros fill
		SHR	AL,1			; Shift w/zeros fill
		SHR	AL,1			; Shift w/zeros fill
		SHR	AL,1			; Shift w/zeros fill
		CALL	SUB_1533
		MOV	AL,AH

;==== External Entry into Subroutine ======================================

SUB_1533:					; convert low 4-bits to ASCII
		AND	AL,0FH			; clear high 4-bits
		ADD	AL,90H
		DAA				; Decimal adjust
		ADC	AL,40H			; '@'
		DAA				; Decimal adjust
		STOSB				; Store al to es:[di]
		RETN
CNV_W_2_HX_151D	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================
; op-codes: D4, D5

OP_153D		PROC	NEAR
		CALL	RD_NXT_BYT_1B1B
		CMP	AL,0AH
		JNE	LOC_1545
		RETN
LOC_1545:
		JMP	LOC_1810
OP_153D		ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================
; op-codes: 00, 01, 08, 09, 10, 11, 18, 19, 20, 21, 28, 29, 30, 31, 38, 39,
; 88, 89

OP_1548		PROC	NEAR
		CALL	PARS_MOD_B_1836
		CALL	SUB_18BA
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]

;==== External Entry into Subroutine ======================================

SUB_1551:
		MOV	AL,REG_FIELD_2845	; (72B5:2845=0)

;==== External Entry into Subroutine ======================================

SUB_1554:
LOC_1554:
		MOV	SI,OFFSET BYTE_REGS_249B	; (72B5:249B=41H)
		TEST	BYTE PTR OPCODE_BYT_286B,1	; (72B5:286B=0)
		JZ	LOC_1561

;==== External Entry into Subroutine ======================================
; op-codes: 40-4F, 50-5F

OP_155E:
LOC_155E:
		MOV	SI,OFFSET WORD_REGS_24AB	; (72B5:24AB=41H)
LOC_1561:
		AND	AL,7			; clear high 5-bits
		CBW				; Convrt byte to word
		ADD	SI,AX
		ADD	SI,AX
		MOVSW				; Mov [si] to es:[di]
		RETN
OP_1548		ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================
; op-codes: 06, 07, 0E, 16, 17, 1E, 1F,

OP_156A		PROC	NEAR
		MOV	CL,3
		SHR	AL,CL			; Shift w/zeros fill

;==== External Entry into Subroutine ======================================

SUB_156E:
LOC_156E:
		AND	AL,3			; clear all but 2-LSB's
		MOV	SI,OFFSET SEG_REGS_24BB	; (72B5:24BB=45H)
		JMP	SHORT LOC_1561
OP_156A		ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================
; op-codes: 8C

OP_1575		PROC	NEAR
		MOV	BYTE PTR OPCODE_BYT_286B,1	; (72B5:286B=0)
		CALL	PARS_MOD_B_1836
		CMP	AL,4
		JB	LOC_1584
LOC_1581:
		JMP	LOC_17FE
LOC_1584:
		CALL	SUB_18BA
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		MOV	AL,REG_FIELD_2845	; (72B5:2845=0)
		JMP	SHORT LOC_156E

;==== External Entry into Subroutine ======================================
; op-codes: 8E

OP_158F:
		CALL	PARS_MOD_B_1836
		CMP	AL,4
		JAE	LOC_1581
		CALL	SUB_156E
		MOV	BYTE PTR OPCODE_BYT_286B,1	; (72B5:286B=0)
		JMP	SHORT LOC_15B4

;==== External Entry into Subroutine ======================================
; op-codes: 8F

OP_15A0:
		CALL	PARS_MOD_B_1836
		OR	AL,AL
		JNZ	LOC_1581
		JMP	SHORT LOC_15B7

;==== External Entry into Subroutine ======================================
; op-codes: 8D

OP_15A9:
		OR	BYTE PTR OPCODE_BYT_286B,1	; (72B5:286B=0)

;==== External Entry into Subroutine ======================================
; op-codes: 02, 03, 0A, 0B, 12, 13, 1A, 1B, 22, 23, 2A, 2B, 32, 33, 3A, 3B,
; 84-87, 8A, 8B

OP_15AE:
		CALL	PARS_MOD_B_1836
		CALL	SUB_1551
LOC_15B4:
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
LOC_15B7:
		JMP	LOC_18BA

;==== External Entry into Subroutine ======================================
; op-codes: EB

OP_15BA:
		INC	DATA_285C		; (=0)

;==== External Entry into Subroutine ======================================
; op-codes: 70-7F E0-E3

OP_15BE:
		CALL	RD_NXT_BYT_1B1B
		CBW				; Convrt byte to word
		MOV	DX,AX
		JMP	SHORT LOC_15E2

;==== External Entry into Subroutine ======================================
; op-codes: E9

OP_15C6:
		INC	DATA_285C		; (=0)
		CALL	SUB_1B10
		PUSH	DX
		CALL	SUB_15E2
		POP	DX
		INC	DH
		JNZ	LOC_RET_15DE
		OR	DL,DL
		JNS	LOC_RET_15DE		; Jump if not sign
		INC	DATA_285D		; (=0)

LOC_RET_15DE:
		RETN

;==== External Entry into Subroutine ======================================
; op-codes: E8

OP_15DF:
		CALL	SUB_1B10

;==== External Entry into Subroutine ======================================

SUB_15E2:
LOC_15E2:
		ADD	DX,DATA_2858		; (=0)
		JMP	LOC_1447

;==== External Entry into Subroutine ======================================
; op-codes: 91-97

OP_15E9:
		CALL	OP_155E
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		MOV	AL,0
		JMP	LOC_155E

;==== External Entry into Subroutine ======================================
; op-codes: A2, A3

OP_15F4:
		CALL	SUB_141D
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]

;==== External Entry into Subroutine ======================================

SUB_15FA:
		JMP	SHORT LOC_1649
	;***	DB	90H

;==== External Entry into Subroutine ======================================
; op-codse: A4-A7, AA-AF

OP_15FD_STRINGS:
		TEST	BYTE PTR DATA_2866,0FFH	; (=0)
		JZ	LOC_RET_165F
		MOV	DL,AL
		SUB	AL,0A4H
		SHR	AL,1			; Shift w/zeros fill
		MOV	BX,OFFSET STR_2030	; (72B5:2030=95H)
		CALL	SUB_185A
		DEC	BX
		JNZ	LOC_1616
		JMP	LOC_17D1
LOC_1616:
		CALL	SUB_1897
		CMP	DL,0A8H
		JA	LOC_1624
		MOV	SI,OFFSET DATA_2165	; (72B5:2165=5BH)
		CALL	WRT_STRING_18A4
LOC_1624:
		CALL	SUB_181D
		MOV	SI,OFFSET DATA_2417	; (72B5:2417=5BH)
		JMP	LOC_18A4

;==== External Entry into Subroutine ======================================
; op-codes: B0-B7

OP_162D:
		MOV	BYTE PTR OPCODE_BYT_286B,0	; (72B5:286B=0)
		JMP	SHORT LOC_1639

;==== External Entry into Subroutine ======================================
; op-codes: B8-BF

OP_1634:
		MOV	BYTE PTR OPCODE_BYT_286B,1	; (72B5:286B=0)
LOC_1639:
		AND	AL,7			; clear high 5-bits
		JMP	LOC_131F

;==== External Entry into Subroutine ======================================
; op-codes: CC

OP_163E:
		MOV	AL,3
		JMP	LOC_1332

;==== External Entry into Subroutine ======================================
; op-codes: E6, E7

OP_1643:
		CALL	OP_1654
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]

;==== External Entry into Subroutine ======================================

SUB_1649:
LOC_1649:
		MOV	AL,0
		JMP	LOC_1554

;==== External Entry into Subroutine ======================================
; op-codes: E4, E5

OP_164E:
		CALL	SUB_1649
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]

;==== External Entry into Subroutine ======================================
; op-codes: CD
OP_1654:
		CALL	RD_NXT_BYT_1B1B
		CALL	SUB_1337

;==== External Entry into Subroutine ======================================

SUB_165A:
LOC_165A:
		MOV	BYTE PTR DATA_287C,80H	; (72B5:287C=48H)

LOC_RET_165F:
		RETN

;==== External Entry into Subroutine ======================================
; op-codes: D8

OP_1660:
		CALL	SUB_171A
		MOV	AX,5453H		; 'ST'
		STOSW				; Store ax to es:[di]
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]

;==== External Entry into Subroutine ======================================

SUB_166A:
LOC_166A:
		MOV	AX,5453H		; 'ST'
		STOSW				; Store ax to es:[di]
		MOV	AX,3028H		; '(0'
		OR	AH,RM_FIELD_2843	; patch the '0', above
		STOSW				; Store ax to es:[di]
		MOV	AL,29H			; ')'
		STOSB				; Store al to es:[di]
		RETN

;==== External Entry into Subroutine ======================================
; op-code: DC
OP_167A:
		CALL	SUB_171A
		CALL	SUB_166A
		JMP	LOC_1712

;==== External Entry into Subroutine ======================================
; op-codes: D9

OP_1683_ESC1:
		CALL	SUB_171A
		MOV	AL,MOD_REG_RM_286C	; (72B5:286C=0)
		SUB	AL,0E0H
		JC	LOC_1697
		MOV	BX,OFFSET ESC_2054	; (72B5:2054=0BBH)
		CALL	SUB_185A
		DEC	BX
		JZ	LOC_16AF

LOC_RET_1696:
		RETN
LOC_1697:
		MOV	BX,OFFSET ESC_204C	; (72B5:204C=40H)
		MOV	AL,REG_FIELD_2845	; (72B5:2845=0)
		CALL	SUB_185A
		MOV	AL,MOD_REG_RM_286C	; (72B5:286C=0)
		SUB	AL,0D0H
		JC	LOC_166A
		JZ	LOC_RET_1696
		AND	AL,0FH			; clear high 4-bits
		CMP	AL,8			; test if bit-3 set
		JAE	LOC_166A		; jump if 8 thru 15
LOC_16AF:
		JMP	LOC_17FE		; jump, 0 thru 7

;==== External Entry into Subroutine ======================================
; op-codes: DA

OP_16B2:
		CALL	SUB_171A
		JMP	LOC_17FE

;==== External Entry into Subroutine ======================================
; op-codes: DB

OP_16B8_ESC3:
		CALL	SUB_171A
		MOV	BX,OFFSET ESC_20B4	; (72B5:20B4=0F3H)
		MOV	AL,MOD_REG_RM_286C	; (72B5:286C=0)
		SUB	AL,0E0H
		JC	LOC_172F
		CMP	AL,4
		JAE	LOC_172F
		JMP	LOC_185A

;==== External Entry into Subroutine ======================================
; op-codes: DD, DF

OP_16CC_ESC5_7:
		CALL	SUB_171A
		CMP	BYTE PTR REG_FIELD_2845,4	; (72B5:2845=0)
		JAE	LOC_172F
		MOV	BX,OFFSET ESC_20CC	; (72B5:20CC=0F7H)
		CALL	SUB_185A
		CMP	BYTE PTR OPCODE_BYT_286B,0DDH	; (72B5:286B=0)
		JE	LOC_16EA
		TEST	BYTE PTR REG_FIELD_2845,0FFH	; (72B5:2845=0)
		JZ	LOC_172F
LOC_16EA:
		JMP	LOC_166A

;==== External Entry into Subroutine ======================================
; op-codes: DE

OP_16ED_ESC6:
		CALL	SUB_171A
		MOV	BX,OFFSET ESC_20D4	; (72B5:20D4=0ADH)
		MOV	AL,REG_FIELD_2845	; (72B5:2845=0)
		CALL	SUB_185A
		CMP	BYTE PTR REG_FIELD_2845,3	; (72B5:2845=0)
		JNE	LOC_1708
		CMP	BYTE PTR MOD_REG_RM_286C,0D9H	; (72B5:286C=0)
		JNE	LOC_172F
		RETN
LOC_1708:
		CALL	SUB_166A
		CMP	BYTE PTR REG_FIELD_2845,2	; (72B5:2845=0)
		JE	LOC_RET_1719
LOC_1712:
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		MOV	AX,5453H		; 'ST'
		STOSW				; Store ax to es:[di]

LOC_RET_1719:
		RETN

;==== External Entry into Subroutine ======================================

SUB_171A:
;**CHANGED**	TEST	BYTE PTR DATA_2874,0FFH	; (=0FFH)
		TEST	BYTE PTR SW_F_8087_CODES,0FFH	; (=0FFH)
		JNZ	LOC_1735
		CALL	SUB_1855
		CMP	BYTE PTR MOD_FIELD_2844,3	; (72B5:2844=0)
		JE	LOC_RET_1719
		DEC	BX
		POP	AX
		JNZ	LOC_1732
LOC_172F:
		JMP	LOC_17FE
LOC_1732:
		JMP	LOC_18BA
LOC_1735:
		POP	CX
						; 9DH s/b MN_ESC-MN_AAA
;**CHANGED**	MOV	OPW_TBL_WD_285F,9DH	; (72B5:285F=0)
		MOV	OPW_TBL_WD_285F,MN_ESC-MN_AAA
		AND	AL,7			; clear high 5-bits
		MOV	DL,AL
		CALL	PARS_MOD_B_1836
		MOV	CL,3
		SHL	DL,CL			; Shift w/zeros fill
		OR	AL,DL
		CALL	SUB_1332
		MOV	BYTE PTR OPCODE_BYT_286B,1	; (72B5:286B=0)
		JMP	LOC_15B4

;==== External Entry into Subroutine ======================================
; op-codes: EC, ED

OP_1754:
		CALL	SUB_1649
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]

;==== External Entry into Subroutine ======================================

SUB_175A:
		MOV	AX,5844H		; 'DT'
		STOSW				; Store ax to es:[di]
		RETN

;==== External Entry into Subroutine ======================================
; op-codes: EE, EF

OP_175F:
		CALL	SUB_175A
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		JMP	LOC_1649

;==== External Entry into Subroutine ======================================
; op-codes: D0-D3

OP_1768:
		CALL	SUB_1865
		CALL	SUB_18B0
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		TEST	BYTE PTR OPCODE_BYT_286B,2	; (72B5:286B=0)
		JZ	LOC_177D
		MOV	AX,4C43H		; 'CL'
		STOSW				; Store ax to es:[di]
		RETN
LOC_177D:
		MOV	AL,31H			; '1'
		STOSB				; Store al to es:[di]
		RETN

;==== External Entry into Subroutine ======================================
; op-codes: F6, F7

OP_1781:
		CALL	SUB_1865
		OR	AL,AL
		JNZ	LOC_179D
		JMP	LOC_12BB

;==== External Entry into Subroutine ======================================
; op-codes: FE, FF

OP_178B:
		CALL	SUB_1865
		CMP	BYTE PTR OPW_HI_NBL_286A,50H	; (72B5:286A=0) 'P'
		JNE	LOC_1799
		INC	DATA_285C		; (=0)
LOC_1799:
		CMP	AL,2
		JAE	LOC_17A0
LOC_179D:
		JMP	LOC_18B0
LOC_17A0:
		TEST	BYTE PTR OPCODE_BYT_286B,1	; (72B5:286B=0)
		JZ	LOC_17FE
		CMP	AL,2
		JE	LOC_179D
		CMP	AL,4
		JE	LOC_179D
		JMP	LOC_18BA

;==== External Entry into Subroutine ======================================
; op-codes: C3

OP_17B2:
		MOV	BX,OFFSET MAC_RET_NEAR	; (72B5:2568=0)
		JMP	SHORT LOC_17C0

;==== External Entry into Subroutine ======================================
; op-codes: CF
OP_17B7:
		INC	DATA_285C		; (=0)
		JMP	SHORT LOC_17CA

;==== External Entry into Subroutine ======================================
; op-codes: CB

OP_17BD:
		MOV	BX,OFFSET MAC_RET_FAR	; (72B5:2518=0)
LOC_17C0:
		MOV	BYTE PTR [BX],1
		INC	DATA_285C		; (=0)

;==== External Entry into Subroutine ======================================
; op-codes: D7

OP_17C7:
		CALL	SUB_181D

;==== External Entry into Subroutine ======================================
; op-codes: 27, 2F, 37, 3F, 90, 98, 99, 9B-9F, CE, F4, F5, F8-FD

OP_17CA:
LOC_17CA:
		TEST	BYTE PTR DATA_2866,0FFH	; (=0)
		JZ	LOC_RET_1835

;==== External Entry into Subroutine ======================================
; op-codes: 0F, 60-6F, C0, C1, C8, C9, D6, F1

OP_17D1:
LOC_17D1:
		TEST	BYTE PTR DATA_2866,0FFH	; (=0)
		JZ	LOC_180A
		MOV	AL,DATA_2866		; (=0)
		CALL	SUB_1332
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		MOV	AL,OPCODE_BYT_286B	; (72B5:286B=0)
		JMP	SHORT LOC_180A

;==== External Entry into Subroutine ======================================

SUB_17E6:
		CALL	SUB_1865
		CMP	BYTE PTR OPCODE_BYT_286B,82H	; (72B5:286B=0)
		JB	LOC_RET_17FC
		CMP	AL,1
		JE	LOC_17FD
		CMP	AL,4
		JE	LOC_17FD
		CMP	AL,6
		JE	LOC_17FD

LOC_RET_17FC:
		RETN
LOC_17FD:
		POP	BX
LOC_17FE:
		MOV	AL,OPCODE_BYT_286B	; (72B5:286B=0)
		CALL	SUB_1332
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		MOV	AL,MOD_REG_RM_286C	; (72B5:286C=0)

LOC_180A:					; 6AH s/b MN_DB-MN_AAA
;**CHANGED**	MOV	OPW_TBL_WD_285F,6AH	; (72B5:285F=0)
		MOV	OPW_TBL_WD_285F,MN_DB-MN_AAA
LOC_1810:
		CALL	SUB_1332
		MOV	AL,9			; TAB
		STOSB				; Store al to es:[di]
		MOV	AX,3F3FH		; '??'
		STOSW				; Store ax to es:[di]
		JMP	LOC_165A

;==== External Entry into Subroutine ======================================

SUB_181D:
		TEST	BYTE PTR DATA_2866,0FFH	; (=0)
		JZ	LOC_RET_1835
		PUSH	AX
		MOV	AL,DATA_2866		; (=0)
		CALL	OP_156A
		MOV	AL,3AH			; ':'
		STOSB				; Store al to es:[di]
		MOV	BYTE PTR DATA_2866,0	; (=0)
		POP	AX
		STC				; Set carry flag

LOC_RET_1835:
		RETN

;==== External Entry into Subroutine ======================================
;
;         Parse	MOD-REG-R/M byte

PARS_MOD_B_1836:
		CALL	RD_NXT_BYT_1B1B
		MOV	MOD_REG_RM_286C,AL	; (72B5:286C=0)
		MOV	AH,AL
		AND	AL,7			; clear high 5-bits
		MOV	RM_FIELD_2843,AL	; (72B5:2843=0)
		MOV	CL,3
		SHR	AH,CL			; Shift w/zeros fill
		MOV	AL,AH
		AND	AL,7			; clear high 5-bits
		MOV	REG_FIELD_2845,AL	; (72B5:2845=0)
		SHR	AH,CL			; Shift w/zeros fill
		MOV	MOD_FIELD_2844,AH	; (72B5:2844=0)
		RETN

;==== External Entry into Subroutine ======================================

SUB_1855:
		CALL	PARS_MOD_B_1836
		MOV	DL,AL

;==== External Entry into Subroutine ======================================

SUB_185A:
LOC_185A:
		MOV	AH,0
		ADD	BX,AX
		ADD	BX,AX
		XOR	AX,AX
		DEC	BX
		JMP	SHORT LOC_1873

;==== External Entry into Subroutine ======================================

SUB_1865:
		CALL	PARS_MOD_B_1836
		MOV	DL,AL
		CBW				; Convrt byte to word
		ADD	BX,AX
		ADD	BX,AX
		ADD	BX,AX
		MOV	AL,[BX]
LOC_1873:
		TEST	BYTE PTR DATA_2866,0FFH	; (=0)
		JNZ	LOC_187D
		MOV	OPJ_HI_BYT_2869,AL	; (72B5:2869=0)
LOC_187D:
		MOV	AX,[BX+1]
		MOV	OPW_TBL_WD_285F,AX	; (72B5:285F=0)
		MOV	BX,AX
		MOV	OPW_HI_NBL_286A,AH	; (72B5:286A=0)
		AND	BYTE PTR OPW_HI_NBL_286A,0F0H	; clear low 4-bits
		OR	AX,AX
		MOV	AL,DL
		JNZ	LOC_RET_18AF
		JMP	LOC_17FD

;==== External Entry into Subroutine ======================================
;
;         Output string	- 'BYTE PTR' or 'WORD PTR'

SUB_1897:
		MOV	SI,OFFSET MN_BYT_PT	; (72B5:2109=42H)
		TEST	BYTE PTR OPCODE_BYT_286B,1	; (72B5:286B=0)
		JZ	LOC_18A4
		MOV	SI,OFFSET MN_WORD_PT	; (72B5:243F=57H)

;==== External Entry into Subroutine ======================================
;
;         Output string	- ends with bit-7=1

WRT_STRING_18A4:
LOC_18A4:
		LODSB				; String [si] to al
		MOV	AH,AL
		AND	AL,7FH			; clear bit-7
		STOSB				; Store al to es:[di]
		AND	AH,80H			; clear all but bit-7
		JZ	LOC_18A4		; jump if not end of string

LOC_RET_18AF:
		RETN

;==== External Entry into Subroutine ======================================

SUB_18B0:
LOC_18B0:
		CMP	BYTE PTR MOD_FIELD_2844,3	; (72B5:2844=0)
		JE	LOC_18BA
		CALL	SUB_1897
OP_1575		ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_18BA	PROC	NEAR
LOC_18BA:
		MOV	AX,WORD PTR RM_FIELD_2843	; (72B5:2843=0)
		CMP	AH,3
		JNE	LOC_18C5
		JMP	LOC_1554
LOC_18C5:
		MOV	DX,AX
		CMP	AX,6
		JNE	LOC_18CF
		JMP	LOC_141D
LOC_18CF:
		MOV	BL,AL
		MOV	BH,0
		SHL	BX,1			; Shift w/zeros fill
		CMP	BYTE PTR DATA_24C3[BX],50H	; (72B5:24C3=42H) 'P'
		JNE	LOC_18E1
		MOV	BYTE PTR OPJ_HI_BYT_2869,10H	; (72B5:2869=0)
LOC_18E1:
		CALL	SUB_181D
		MOV	AL,5BH			; '['
		STOSB				; Store al to es:[di]
		MOV	AX,WORD PTR DATA_24C3[BX]	; (72B5:24C3=5842H)
		STOSW				; Store ax to es:[di]
		CMP	DL,4
		JAE	LOC_18FC
		MOV	AL,2BH			; '+'
		STOSB				; Store al to es:[di]
		AND	BL,2			; clear all but bit-1
		MOV	AX,WORD PTR DATA_24CB[BX] ; 2-words indexed SI,DI
		STOSW				; Store ax to es:[di]
LOC_18FC:
		OR	DH,DH
		JZ	LOC_1924
		DEC	DH
		JZ	LOC_190C
		MOV	AL,2BH			; '+'
		STOSB				; Store al to es:[di]
		CALL	SUB_141D
		JMP	SHORT LOC_1924
LOC_190C:
		CALL	RD_NXT_BYT_1B1B
		CBW				; Convrt byte to word
		MOV	DX,AX
		MOV	AH,AL
		MOV	AL,2BH			; '+'
		OR	AH,AH
		JNS	LOC_191E
		MOV	AL,2DH			; '-'
		NEG	AH
LOC_191E:
		STOSB				; Store al to es:[di]
		MOV	AL,AH
		CALL	SUB_1332
LOC_1924:
		MOV	AL,5DH			; ']'
		STOSB				; Store al to es:[di]
		JMP	LOC_165A
SUB_18BA	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_192A	PROC	NEAR

						; D20AH is opcode OR DL,DL
;**CHANGED**	MOV	WORD PTR DS:ALTR_OPW_1965+0,0D20AH	; (72B5:1965=0CAFEH)
		MOV	BYTE PTR OLD_DEC_1965,0	;for OR DL,DL (no decrement)
		JMP	SHORT LOC_1938

;==== External Entry into Subroutine ======================================

SUB_1932:

						; CAFEH is opcode DEC DL
;**CHANGED**	MOV	WORD PTR DS:ALTR_OPW_1965+0,0CAFEH	; (72B5:1965=0CAFEH)
		MOV	BYTE PTR OLD_DEC_1965,1	;for DEC DL

LOC_1938:
		TEST	BYTE PTR DATA_2856,0FFH	; (=0)
		JNZ	LOC_1970
		CALL	SUB_132F
		MOV	AX,DATA_2919		; (=0) (store AL only)
		MOV	BYTE PTR DATA_2919+1,0	; (=0) (zero AH value)
		OR	AH,AH
		JNZ	LOC_1950
		DEC	AH
LOC_1950:
		AND	DL,AH
LOC_1952:
		SHR	AH,1			; Shift w/zeros fill
		JC	LOC_195A
		SHR	DL,1			; Shift w/zeros fill
		JMP	SHORT LOC_1952
LOC_195A:
		OR	DL,DL
		JNZ	ALTR_OPW_1965

LOC_195E:					; 6AH s/b MN_DB-MN_AAA
;**CHANGED**	MOV	OPW_TBL_WD_285F,6AH	; (72B5:285F=0)
		MOV	OPW_TBL_WD_285F,MN_DB-MN_AAA
		RETN

ALTR_OPW_1965:					; Altered op-code - 'DEC DL' or
						;  'OR DL,DL'
;**CHANGED**	DEC	DL
		SUB	DL,OLD_DEC_1965		;conditional decrement, test 0

		MOV	DATA_2856,DL		; (=0)
		JZ	LOC_195E
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
SUB_192A	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_1970	PROC	NEAR
LOC_1970:
		XOR	CX,CX

						; 6AH s/b MN_DB-MN_AAA
;**CHANGED**	MOV	OPW_TBL_WD_285F,6AH	; (72B5:285F=0)
		MOV	OPW_TBL_WD_285F,MN_DB-MN_AAA
LOC_1978:
		CALL	RD_NXT_BYT_1B1B
		MOV	DL,AL
		TEST	BYTE PTR DATA_2846,0FFH	; (=0)
		PUSHF
		CMP	AL,2CH			; ','
		JE	LOC_19AD
		CMP	AL,27H			; '''
		JE	LOC_19AD
		CMP	AL,22H			; '"'
		JE	LOC_19AD
		CALL	SUB_1A7D
		JNC	LOC_19AD
		POPF
		JNZ	LOC_199D
		MOV	AL,27H			; '''
		STOSB				; Store al to es:[di]
		MOV	DATA_2846,AL		; (=0)
LOC_199D:
		MOV	AL,DL
		STOSB				; Store al to es:[di]
		INC	CX
		CMP	AL,24H			; '$'
		JNE	LOC_19E5
LOC_19A5:
		CALL	SUB_19F1
		JC	LOC_RET_19ED
		JMP	LOC_1A68
LOC_19AD:
		POPF
		JZ	LOC_19B9
		MOV	AX,2C27H		; "'," single quote, comma
		STOSW				; Store ax to es:[di]
		MOV	BYTE PTR DATA_2846,0	; (=0)
LOC_19B9:
		CMP	DL,0DH			; CR
		JNE	LOC_19C3
		MOV	AX,5243H		; 'CR'
		JMP	SHORT LOC_19CB
LOC_19C3:
		CMP	DL,0AH			; LF
		JNE	LOC_19CE
		MOV	AX,464CH		; 'LF'
LOC_19CB:
		STOSW				; Store ax to es:[di]
		JMP	SHORT LOC_19D5
LOC_19CE:
		MOV	AL,DL
		PUSH	CX
		CALL	SUB_1332
		POP	CX
LOC_19D5:
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		CMP	DL,0AH
		JE	LOC_19A5
		TEST	DL,80H
		JNZ	LOC_19A5
		ADD	CX,4
LOC_19E5:
		CMP	CX,35H			; 53 decimal
		CALL	SUB_19F1
		JNC	LOC_1978

LOC_RET_19ED:
		RETN

;==== External Entry into Subroutine ======================================

SUB_19EE:
		CMP	CX,16H			; 22 decimal

;==== External Entry into Subroutine ======================================

SUB_19F1:
		PUSH	BX
		PUSHF
		TEST	BYTE PTR DATA_2856,0FFH	; (=0)
		JZ	LOC_1A0D
		DEC	DATA_2856		; (=0)
		JNZ	LOC_1A1A
		TEST	BYTE PTR DATA_291B,0FFH	; (=0)
		JZ	LOC_1A5D
		DEC	DATA_2919		; (=0)
		JMP	SHORT LOC_1A5D
LOC_1A0D:
		TEST	BYTE PTR DATA_291B,0FFH	; (=0)
		JZ	LOC_1A1A
		DEC	DATA_2919		; (=0)
		JZ	LOC_1A5D
LOC_1A1A:
		TEST	DATA_284D,0FFFFH	; (72B5:284D=0)
		JZ	LOC_1A5D
		MOV	AX,DATA_2889		; (=0)
		CMP	AX,DATA_288F		; (=0)
		MOV	AX,DATA_2858		; (=0)
		JNC	LOC_1A34
		CMP	DATA_2885,AX		; (=0)
		JBE	LOC_1A5D
LOC_1A34:
		CMP	BYTE PTR DATA_2861,1	; (=0)
		JE	LOC_1A47
		TEST	BYTE PTR DATA_2888,0FFH	; (=0)
		JZ	LOC_1A47
		CMP	AX,[BP+1]
		JAE	LOC_1A5D
LOC_1A47:
		MOV	BX,DATA_288D		; (=0)
		CMP	BX,DATA_2893		; (=0)
		JAE	LOC_1A55
		CMP	AX,[BX]
		JAE	LOC_1A5D
LOC_1A55:
		POPF
		JNC	LOC_1A5E
		CLC				; Clear carry flag
		POP	BX
		RETN
CALL_INDR_1A5B	DW	0			; Indirect CALL offset
LOC_1A5D:
		POPF
LOC_1A5E:
		POP	BX
		POP	CALL_INDR_1A5B		; (72B5:1A5B=0)
		STC				; Set carry flag
		CALL	CALL_INDR_1A5B		; (72B5:1A5B=0)
LOC_1A68:
		CMP	BYTE PTR [DI-1],2CH	; ','
		JNE	LOC_1A72
		DEC	DI
		MOV	BYTE PTR [DI],0
LOC_1A72:
		TEST	BYTE PTR DATA_2846,0FFH	; (=0)
		JZ	LOC_RET_1A7C
		MOV	AL,27H			; '''
		STOSB				; Store al to es:[di]

LOC_RET_1A7C:
		RETN
SUB_1970	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_1A7D	PROC	NEAR
		CMP	AL,20H			; ' '
		CMC				; Complement carry
		JNC	LOC_RET_1A84
		CMP	AL,7BH			; '{'

LOC_RET_1A84:
		RETN
SUB_1A7D	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_1A85	PROC	NEAR

						; 7EH s/b MN_DW-MN_AAA
;**CHANGED**	MOV	AX,7EH
		MOV	AX,MN_DW-MN_AAA
		CMP	BYTE PTR DATA_2887,1	; (=0)
		JNE	LOC_1A92

						; 6AH s/b MN_DB-MN_AAA
;**CHANGED**	MOV	AX,6AH
		MOV	AX,MN_DB-MN_AAA
LOC_1A92:
		MOV	OPW_TBL_WD_285F,AX	; (72B5:285F=0)
		XOR	BX,BX
		MOV	CX,BX
		CALL	SUB_1AFC
LOC_1A9C:
;**CHANGED**	MOV	DS:ALTR_W_1AC9+1,AX	; (72B5:1ACA=0)
		MOV	DS:OLD_W_1ACA,AX	; (72B5:1ACA=0)
		CALL	SUB_19EE
		JC	LOC_1AC5
LOC_1AA4:
		CALL	SUB_1AFC
;**CHANGED**	CMP	AX,DS:ALTR_W_1AC9+1	; (72B5:1ACA=0)
		CMP	AX,DS:OLD_W_1ACA	; (72B5:1ACA=0)
		JNE	LOC_1AB5
		INC	BX
		CALL	SUB_19EE
		JC	LOC_1AE0
		JMP	SHORT LOC_1AA4
LOC_1AB5:
		PUSH	AX
		OR	BX,BX
		JZ	LOC_1ABF
		CALL	SUB_1AE0
		JMP	SHORT LOC_1AC2
LOC_1ABF:
		CALL	SUB_1AC5
LOC_1AC2:
		POP	AX
		JMP	SHORT LOC_1A9C

;==== External Entry into Subroutine ======================================

SUB_1AC5:
LOC_1AC5:
		ADD	CX,6
		PUSH	CX

ALTR_W_1AC9:					; Altered code
;**CHANGED**	MOV	DX,0
		MOV	DX,OLD_W_1ACA
		CMP	BYTE PTR DATA_2887,1	; (=0)
		JNE	LOC_1AD8
		CALL	SUB_1342
		JMP	SHORT LOC_1ADB
LOC_1AD8:
		CALL	SUB_1447
LOC_1ADB:
		MOV	AL,2CH			; ','
		STOSB				; Store al to es:[di]
		POP	CX
		RETN
SUB_1A85	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_1AE0	PROC	NEAR
LOC_1AE0:
		ADD	CX,0AH
		PUSH	CX
		INC	BX
		XCHG	DX,BX
		CALL	SUB_1345
		MOV	SI,OFFSET DATA_216D_DUP	; (72B5:216D=20H)
		CALL	WRT_STRING_18A4
		POP	CX
		CALL	SUB_1AC5
		DEC	DI
		MOV	AX,2C29H		; '),' close paren, comma
		STOSW				; Store ax to es:[di]
		XOR	BX,BX
		RETN
SUB_1AE0	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_1AFC	PROC	NEAR
		CALL	RD_NXT_BYT_1B1B
		MOV	AH,AL
		MOV	AL,0
		CMP	BYTE PTR DATA_2887,1	; (=0)
		JE	LOC_1B0D
		CALL	RD_NXT_BYT_1B1B
LOC_1B0D:
		XCHG	AH,AL
		RETN
SUB_1AFC	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_1B10	PROC	NEAR
		CALL	RD_NXT_BYT_1B1B
		MOV	DL,AL
		CALL	RD_NXT_BYT_1B1B
		MOV	DH,AL
		RETN
SUB_1B10	ENDP


;==========================================================================
;         Read next byte from input file
;==========================================================================

RD_NXT_BYT_1B1B	PROC	NEAR
		PUSH	SI
		MOV	AL,0
		TEST	DATA_284D,0FFFFH	; (72B5:284D=0)
		JZ	LOC_1B57
		MOV	SI,DATA_287F		; (=0)
		CMP	SI,OFFSET DTA4_2C9E	; (72B5:2C9E=0)
		JB	LOC_1B4E
		PUSH	AX
		PUSH	DX
		MOV	DX,OFFSET DTA3_2A9E	; 
		MOV	AH,1AH
		INT	21H			; DOS Services  ah=function 1Ah
						;  set DTA to ds:dx
		XCHG	DX,SI
		MOV	DX,OFFSET FCB3_2A0F	; (72B5:2A0F=61H)
		MOV	AH,14H
		INT	21H			; DOS Services  ah=function 14h
						;  sequentl file read FCB @ds:dx
		CMP	AL,1
		JNE	LOC_1B4C
		MOV	DATA_284D,0		; (72B5:284D=0)
LOC_1B4C:
		POP	DX
		POP	AX
LOC_1B4E:
		LODSB				; String [si] to al
		MOV	DATA_287F,SI		; (=0)
		DEC	DATA_284D		; (72B5:284D=0)
LOC_1B57:
		INC	DATA_2854		; (=0)
		INC	DATA_2858		; (=0)
		MOV	SI,DATA_2854		; (=0)
		CMP	SI,18H
		JA	LOC_1B6E
		ADD	SI,OFFSET DATA_282A	; (=0)
		MOV	[SI],AL
LOC_1B6E:
		POP	SI
		RETN
RD_NXT_BYT_1B1B	ENDP


;==========================================================================
;			       SUBROUTINE
;==========================================================================

SUB_1B70	PROC	NEAR
		MOV	SI,DATA_2E9E_E		; (=0)
LOC_1B73:
		CMP	SI,DATA_288F		; (=0)
		JA	LOC_1B95
		CMP	DX,[SI]
		PUSHF
		LODSW				; String [si] to ax
		LODSB				; String [si] to al
		LODSB				; String [si] to al
		AND	AL,7FH			; clear bit-7
		MOV	AH,0
		ADD	SI,AX
		POPF
		JC	LOC_1B95
		JNZ	LOC_1B73
		OR	AX,AX
		JZ	LOC_1B73
		SUB	SI,AX
		CMP	BYTE PTR [SI],0AEH
		CLC				; Clear carry flag
		RETN
LOC_1B95:
		STC				; Set carry flag
		RETN
SUB_1B70	ENDP

;==========================================================================
		DB	10,'Table '
DATA_1BA9	DW	OFFSET SUB_1277		; Data table (indexed access)
		DW	OFFSET SUB_1A85
		DW	OFFSET SUB_1A85
		DW	OFFSET SUB_1970
		DW	OFFSET SUB_1932
		DW	OFFSET SUB_192A
		DW	OFFSET SUB_1277
		DW	OFFSET SUB_1277
		DW	OFFSET SUB_1277
		DB	5 DUP (0)		;(apparent padding)

		DB	10,'Op-code Dispatch, 2-words/entry, all 12-bit differences plus high 4-bits'
		DB	10,'1st word difference from "Mnemonic", 2nd word difference from "Op-codes"'
		DB	10,'except, use labels for 1st word of op-codes: 80-83,D0-D3,D8-DF,F6,F7,FE,FF',10

OPW_00_ADD	DW	MN_ADD-MN_AAA+04000H	;00 ADD
OPJ_00		DW	OP_1548-OP_1250		;
OPW_01_ADD	DW	MN_ADD-MN_AAA+04000H	;01 ADD
OPJ_01		DW	OP_1548-OP_1250		;
OPW_02_ADD	DW	MN_ADD-MN_AAA+01000H	;02 ADD
OPJ_02		DW	OP_15AE-OP_1250		;
OPW_03_ADD	DW	MN_ADD-MN_AAA+01000H	;03 ADD
OPJ_03		DW	OP_15AE-OP_1250		;
OPW_04_ADD	DW	MN_ADD-MN_AAA		;04 ADD
OPJ_04		DW	OP_131D-OP_1250		;
OPW_05_ADD	DW	MN_ADD-MN_AAA		;05 ADD
OPJ_05		DW	OP_131D-OP_1250		;
OPW_06_PUSH_ES	DW	MN_PUSH-MN_AAA		;06 PUSH ES
OPJ_06		DW	OP_156A-OP_1250		;
OPW_07_POP_ES	DW	MN_POP-MN_AAA		;07 POP ES
OPJ_07		DW	OP_156A-OP_1250		;
OPW_08_OR	DW	MN_OR-MN_AAA+04000H	;08 OR
OPJ_08		DW	OP_1548-OP_1250		;
OPW_09_OR	DW	MN_OR-MN_AAA+04000H	;09 OR
OPJ_09		DW	OP_1548-OP_1250		;
OPW_0A_OR	DW	MN_OR-MN_AAA+01000H	;0A OR
OPJ_0A		DW	OP_15AE-OP_1250		;
OPW_0B_OR	DW	MN_OR-MN_AAA+01000H	;0B OR
OPJ_0B		DW	OP_15AE-OP_1250		;
OPW_0C_OR	DW	MN_OR-MN_AAA		;0C OR
OPJ_0C		DW	OP_131D-OP_1250		;
OPW_0D_OR	DW	MN_OR-MN_AAA		;0D OR
OPJ_0D		DW	OP_131D-OP_1250		;
OPW_0E_PUSH_CS	DW	MN_PUSH-MN_AAA		;0E PUSH CS
OPJ_0E		DW	OP_156A-OP_1250		;
OPW_0F_???	DW	0000H			;0F ???
OPJ_0F		DW	OP_17D1-OP_1250		;
OPW_10_ADC	DW	MN_ADC-MN_AAA+04000H	;10 ADC
OPJ_10		DW	OP_1548-OP_1250		;
OPW_11_ADC	DW	MN_ADC-MN_AAA+04000H	;11 ADC
OPJ_11		DW	OP_1548-OP_1250		;
OPW_12_ADC	DW	MN_ADC-MN_AAA+01000H	;12 ADC
OPJ_12		DW	OP_15AE-OP_1250		;
OPW_13_ADC	DW	MN_ADC-MN_AAA+01000H	;13 ADC
OPJ_13		DW	OP_15AE-OP_1250		;
OPW_14_ADC	DW	MN_ADC-MN_AAA		;14 ADC
OPJ_14		DW	OP_131D-OP_1250		;
OPW_15_ADC	DW	MN_ADC-MN_AAA		;15 ADC
OPJ_15		DW	OP_131D-OP_1250		;
OPW_16_PUSH_ES	DW	MN_PUSH-MN_AAA		;16 PUSH ES
OPJ_16		DW	OP_156A-OP_1250		;
OPW_17_POP_ES	DW	MN_POP-MN_AAA		;17 POP ES
OPJ_17		DW	OP_156A-OP_1250		;
OPW_18_SBB	DW	MN_SBB-MN_AAA+04000H	;18 SBB
OPJ_18		DW	OP_1548-OP_1250		;
OPW_19_SBB	DW	MN_SBB-MN_AAA+04000H	;19 SBB
OPJ_19		DW	OP_1548-OP_1250		;
OPW_1A_SBB	DW	MN_SBB-MN_AAA+01000H	;1A SBB
OPJ_1A		DW	OP_15AE-OP_1250		;
OPW_1B_SBB	DW	MN_SBB-MN_AAA+01000H	;1B SBB
OPJ_1B		DW	OP_15AE-OP_1250		;
OPW_1C_SBB	DW	MN_SBB-MN_AAA		;1C SBB
OPJ_1C		DW	OP_131D-OP_1250		;
OPW_1D_SBB	DW	MN_SBB-MN_AAA		;1D SBB
OPJ_1D		DW	OP_131D-OP_1250		;
OPW_1E_PUSH_DS	DW	MN_PUSH-MN_AAA		;1E PUSH DS
OPJ_1E		DW	OP_156A-OP_1250		;
OPW_1F_POP_DS	DW	MN_POP-MN_AAA		;1F POP DS
OPJ_1F		DW	OP_156A-OP_1250		;
OPW_20_AND	DW	MN_AND-MN_AAA+04000H	;20 AND
OPJ_20		DW	OP_1548-OP_1250		;
OPW_21_AND	DW	MN_AND-MN_AAA+04000H	;21 AND
OPJ_21		DW	OP_1548-OP_1250		;
OPW_22_AND	DW	MN_AND-MN_AAA+01000H	;22 AND
OPJ_22		DW	OP_15AE-OP_1250		;
OPW_23_AND	DW	MN_AND-MN_AAA+01000H	;23 AND
OPJ_23		DW	OP_15AE-OP_1250		;
OPW_24_AND	DW	MN_AND-MN_AAA		;24 AND
OPJ_24		DW	OP_131D-OP_1250		;
OPW_25_AND	DW	MN_AND-MN_AAA		;25 AND
OPJ_25		DW	OP_131D-OP_1250		;
OPW_26_ES_COLON	DW	MN_AAA-MN_AAA		;26 ES:
OPJ_26		DW	OP_1250-OP_1250		;
OPW_27_DAA	DW	MN_DAA-MN_AAA		;27 DAA
OPJ_27		DW	OP_17CA-OP_1250		;
OPW_28_SUB	DW	MN_SUB-MN_AAA+04000H	;28 SUB
OPJ_28		DW	OP_1548-OP_1250		;
OPW_29_SUB	DW	MN_SUB-MN_AAA+04000H	;29 SUB
OPJ_29		DW	OP_1548-OP_1250		;
OPW_2A_SUB	DW	MN_SUB-MN_AAA+01000H	;2A SUB
OPJ_2A		DW	OP_15AE-OP_1250		;
OPW_2B_SUB	DW	MN_SUB-MN_AAA+01000H	;2B SUB
OPJ_2B		DW	OP_15AE-OP_1250		;
OPW_2C_SUB	DW	MN_SUB-MN_AAA		;2C SUB
OPJ_2C		DW	OP_131D-OP_1250		;
OPW_2D_SUB	DW	MN_SUB-MN_AAA		;2D SUB
OPJ_2D		DW	OP_131D-OP_1250		;
OPW_2E_CS_COLON	DW	MN_AAA-MN_AAA		;2E CS:
OPJ_2E		DW	OP_1250-OP_1250		;
OPW_2F_DAS	DW	MN_DAS-MN_AAA		;2F DAS
OPJ_2F		DW	OP_17CA-OP_1250		;
OPW_30_XOR	DW	MN_XOR-MN_AAA+04000H	;30 XOR
OPJ_30		DW	OP_1548-OP_1250		;
OPW_31_XOR	DW	MN_XOR-MN_AAA+04000H	;31 XOR
OPJ_31		DW	OP_1548-OP_1250		;
OPW_32_XOR	DW	MN_XOR-MN_AAA+01000H	;32 XOR
OPJ_32		DW	OP_15AE-OP_1250		;
OPW_33_XOR	DW	MN_XOR-MN_AAA+01000H	;33 XOR
OPJ_33		DW	OP_15AE-OP_1250		;
OPW_34_XOR	DW	MN_XOR-MN_AAA		;34 XOR
OPJ_34		DW	OP_131D-OP_1250		;
OPW_35_XOR	DW	MN_XOR-MN_AAA		;35 XOR
OPJ_35		DW	OP_131D-OP_1250		;
OPW_36_SS_COLON	DW	MN_AAA-MN_AAA		;36 SS:
OPJ_36		DW	OP_1250-OP_1250		;
OPW_37_AAA	DW	MN_AAA-MN_AAA		;37 AAA
OPJ_37		DW	OP_17CA-OP_1250		;
OPW_38_CMP	DW	MN_CMP-MN_AAA+02000H	;38 CMP
OPJ_38		DW	OP_1548-OP_1250		;
OPW_39_CMP	DW	MN_CMP-MN_AAA+02000H	;39 CMP
OPJ_39		DW	OP_1548-OP_1250		;
OPW_3A_CMP	DW	MN_CMP-MN_AAA+02000H	;3A CMP
OPJ_3A		DW	OP_15AE-OP_1250		;
OPW_3B_CMP	DW	MN_CMP-MN_AAA+02000H	;3B CMP
OPJ_3B		DW	OP_15AE-OP_1250		;
OPW_3C_CMP	DW	MN_CMP-MN_AAA		;3C CMP
OPJ_3C		DW	OP_131D-OP_1250		;
OPW_3D_CMP	DW	MN_CMP-MN_AAA		;3D CMP
OPJ_3D		DW	OP_131D-OP_1250		;
OPW_3E_DS_COLON	DW	MN_AAA-MN_AAA		;3E DS:
OPJ_3E		DW	OP_1250-OP_1250		;
OPW_3F_AAS	DW	MN_AAS-MN_AAA		;3F AAS
OPJ_3F		DW	OP_17CA-OP_1250		;
OPW_40_INC_AX	DW	MN_INC-MN_AAA		;40 INC AX
OPJ_40		DW	OP_155E-OP_1250		;
OPW_41_INC_CX	DW	MN_INC-MN_AAA		;41 INC CX
OPJ_41		DW	OP_155E-OP_1250		;
OPW_42_INC_DX	DW	MN_INC-MN_AAA		;42 INC DX
OPJ_42		DW	OP_155E-OP_1250		;
OPW_43_INC_BX	DW	MN_INC-MN_AAA		;43 INC BX
OPJ_43		DW	OP_155E-OP_1250		;
OPW_44_INC_SP	DW	MN_INC-MN_AAA		;44 INC SP
OPJ_44		DW	OP_155E-OP_1250		;
OPW_45_INC_BP	DW	MN_INC-MN_AAA		;45 INC BP
OPJ_45		DW	OP_155E-OP_1250		;
OPW_46_INC_SI	DW	MN_INC-MN_AAA		;46 INC SI
OPJ_46		DW	OP_155E-OP_1250		;
OPW_47_INC_DI	DW	MN_INC-MN_AAA		;47 INC DI
OPJ_47		DW	OP_155E-OP_1250		;
OPW_48_DEC_AX	DW	MN_DEC-MN_AAA		;48 DEC AX
OPJ_48		DW	OP_155E-OP_1250		;
OPW_49_DEC_CX	DW	MN_DEC-MN_AAA		;49 DEC CX
OPJ_49		DW	OP_155E-OP_1250		;
OPW_4A_DEC_DX	DW	MN_DEC-MN_AAA		;4A DEC DX
OPJ_4A		DW	OP_155E-OP_1250		;
OPW_4B_DEC_BX	DW	MN_DEC-MN_AAA		;4B DEC BX
OPJ_4B		DW	OP_155E-OP_1250		;
OPW_4C_DEC_SP	DW	MN_DEC-MN_AAA		;4C DEC SP
OPJ_4C		DW	OP_155E-OP_1250		;
OPW_4D_DEC_BP	DW	MN_DEC-MN_AAA		;4D DEC BP
OPJ_4D		DW	OP_155E-OP_1250		;
OPW_4E_DEC_SI	DW	MN_DEC-MN_AAA		;4E DEC SI
OPJ_4E		DW	OP_155E-OP_1250		;
OPW_4F_DEC_DI	DW	MN_DEC-MN_AAA		;4F DEC DI
OPJ_4F		DW	OP_155E-OP_1250		;
OPW_50_PUSH_AX	DW	MN_PUSH-MN_AAA		;50 PUSH AX
OPJ_50		DW	OP_155E-OP_1250		;
OPW_51_PUSH_CX	DW	MN_PUSH-MN_AAA		;51 PUSH CX
OPJ_51		DW	OP_155E-OP_1250		;
OPW_52_PUSH_DX	DW	MN_PUSH-MN_AAA		;52 PUSH DX
OPJ_52		DW	OP_155E-OP_1250		;
OPW_53_PUSH_BX	DW	MN_PUSH-MN_AAA		;53 PUSH BX
OPJ_53		DW	OP_155E-OP_1250		;
OPW_54_PUSH_SP	DW	MN_PUSH-MN_AAA		;54 PUSH SP
OPJ_54		DW	OP_155E-OP_1250		;
OPW_55_PUSH_BP	DW	MN_PUSH-MN_AAA		;55 PUSH BP
OPJ_55		DW	OP_155E-OP_1250		;
OPW_56_PUSH_SI	DW	MN_PUSH-MN_AAA		;56 PUSH SI
OPJ_56		DW	OP_155E-OP_1250		;
OPW_57_PUSH_DI	DW	MN_PUSH-MN_AAA		;57 PUSH DI
OPJ_57		DW	OP_155E-OP_1250		;
OPW_58_POP_AX	DW	MN_POP-MN_AAA		;58 POP AX
OPJ_58		DW	OP_155E-OP_1250		;
OPW_59_POP_CX	DW	MN_POP-MN_AAA		;59 POP CX
OPJ_59		DW	OP_155E-OP_1250		;
OPW_5A_POP_DX	DW	MN_POP-MN_AAA		;5A POP DX
OPJ_5A		DW	OP_155E-OP_1250		;
OPW_5B_POP_BX	DW	MN_POP-MN_AAA		;5B POP BX
OPJ_5B		DW	OP_155E-OP_1250		;
OPW_5C_POP_SP	DW	MN_POP-MN_AAA		;5C POP SP
OPJ_5C		DW	OP_155E-OP_1250		;
OPW_5D_POP_BP	DW	MN_POP-MN_AAA		;5D POP BP
OPJ_5D		DW	OP_155E-OP_1250		;
OPW_5E_POP_SI	DW	MN_POP-MN_AAA		;5E POP SI
OPJ_5E		DW	OP_155E-OP_1250		;
OPW_5F_POP_DI	DW	MN_POP-MN_AAA		;5F POP DI
OPJ_5F		DW	OP_155E-OP_1250		;
OPW_60_???	DW	0000H			;60 ???
OPJ_60		DW	OP_17D1-OP_1250		;
OPW_61_???	DW	0000H			;61 ???
OPJ_61		DW	OP_17D1-OP_1250		;
OPW_62_???	DW	0000H			;62 ???
OPJ_62		DW	OP_17D1-OP_1250		;
OPW_63_???	DW	0000H			;63 ???
OPJ_63		DW	OP_17D1-OP_1250		;
OPW_64_???	DW	0000H			;64 ???
OPJ_64		DW	OP_17D1-OP_1250		;
OPW_65_???	DW	0000H			;65 ???
OPJ_65		DW	OP_17D1-OP_1250		;
OPW_66_???	DW	0000H			;66 ???
OPJ_66		DW	OP_17D1-OP_1250		;
OPW_67_???	DW	0000H			;67 ???
OPJ_67		DW	OP_17D1-OP_1250		;
OPW_68_???	DW	0000H			;68 ???
OPJ_68		DW	OP_17D1-OP_1250		;
OPW_69_???	DW	0000H			;69 ???
OPJ_69		DW	OP_17D1-OP_1250		;
OPW_6A_???	DW	0000H			;6A ???
OPJ_6A		DW	OP_17D1-OP_1250		;
OPW_6B_???	DW	0000H			;6B ???
OPJ_6B		DW	OP_17D1-OP_1250		;
OPW_6C_???	DW	0000H			;6C ???
OPJ_6C		DW	OP_17D1-OP_1250		;
OPW_6D_???	DW	0000H			;6D ???
OPJ_6D		DW	OP_17D1-OP_1250		;
OPW_6E_???	DW	0000H			;6E ???
OPJ_6E		DW	OP_17D1-OP_1250		;
OPW_6F_???	DW	0000H			;6F ???
OPJ_6F		DW	OP_17D1-OP_1250		;
OPW_70_JO	DW	MN_JO-MN_AAA+05000H	;70 JO
OPJ_70		DW	OP_15BE-OP_1250+0A000H	;
OPW_71_JNO	DW	MN_JNO-MN_AAA+05000H	;71 JNO
OPJ_71		DW	OP_15BE-OP_1250+0A000H	;
OPW_72_JB	DW	MN_JB-MN_AAA+05000H	;72 JB
OPJ_72		DW	OP_15BE-OP_1250+0A000H	;
OPW_73_JAE_JNB	DW	MN_JNB-MN_AAA+05000H	;73 JAE/JNB
OPJ_73		DW	OP_15BE-OP_1250+0A000H	;
OPW_74_JZ	DW	MN_JZ-MN_AAA+05000H	;74 JZ/JE
OPJ_74		DW	OP_15BE-OP_1250+0A000H	;
OPW_75_JNZ	DW	MN_JNZ-MN_AAA+05000H	;75 JNZ/JNE
OPJ_75		DW	OP_15BE-OP_1250+0A000H	;
OPW_76_JBE	DW	MN_JBE-MN_AAA+05000H	;76 JBE
OPJ_76		DW	OP_15BE-OP_1250+0A000H	;
OPW_77_JA	DW	MN_JA-MN_AAA+05000H	;77 JA
OPJ_77		DW	OP_15BE-OP_1250+0A000H	;
OPW_78_JS	DW	MN_JS-MN_AAA+05000H	;78 JS
OPJ_78		DW	OP_15BE-OP_1250+0A000H	;
OPW_79_JNS	DW	MN_JNS-MN_AAA+05000H	;79 JNS
OPJ_79		DW	OP_15BE-OP_1250+0A000H	;
OPW_7A_JP	DW	MN_JPE-MN_AAA+05000H	;7A JP
OPJ_7A		DW	OP_15BE-OP_1250+0A000H	;
OPW_7B_JNP	DW	MN_JPO-MN_AAA+05000H	;7B JNP
OPJ_7B		DW	OP_15BE-OP_1250+0A000H	;
OPW_7C_JL	DW	MN_JL-MN_AAA+05000H	;7C JL
OPJ_7C		DW	OP_15BE-OP_1250+0A000H	;
OPW_7D_JGE	DW	MN_JGE-MN_AAA+05000H	;7D JGE
OPJ_7D		DW	OP_15BE-OP_1250+0A000H	;
OPW_7E_JLE	DW	MN_JLE-MN_AAA+05000H	;7E JLE
OPJ_7E		DW	OP_15BE-OP_1250+0A000H	;
OPW_7F_JG	DW	MN_JG-MN_AAA+05000H	;7F JG
OPJ_7F		DW	OP_15BE-OP_1250+0A000H	;
OPW_80_TABLE_V	DW	OFFSET MNV_1FD8		;80 (TABLE V)
OPJ_80		DW	OP_12B8-OP_1250		;
OPW_81_TABLE_V	DW	OFFSET MNV_1FD8		;81 (TABLE V)
OPJ_81		DW	OP_12B8-OP_1250		;
OPW_82_TABLE_V	DW	OFFSET MNV_1FD8		;82 (TABLE V)
OPJ_82		DW	OP_12B8-OP_1250		;
OPW_83_TABLE_V	DW	OFFSET MNV_1FD8		;83 (TABLE V)
OPJ_83		DW	OP_12C0-OP_1250		;
OPW_84_TEST	DW	MN_TEST-MN_AAA+02000H	;84 TEST
OPJ_84		DW	OP_15AE-OP_1250		;
OPW_85_TEST	DW	MN_TEST-MN_AAA+02000H	;85 TEST
OPJ_85		DW	OP_15AE-OP_1250		;
OPW_86_XCHG	DW	MN_XCHG-MN_AAA+03000H	;86 XCHG
OPJ_86		DW	OP_15AE-OP_1250		;
OPW_87_XCHG	DW	MN_XCHG-MN_AAA+03000H	;87 XCHG
OPJ_87		DW	OP_15AE-OP_1250		;
OPW_88_MOV	DW	MN_MOV-MN_AAA+03000H	;88 MOV
OPJ_88		DW	OP_1548-OP_1250		;
OPW_89_MOV	DW	MN_MOV-MN_AAA+03000H	;89 MOV
OPJ_89		DW	OP_1548-OP_1250		;
OPW_8A_MOV	DW	MN_MOV-MN_AAA+01000H	;8A MOV
OPJ_8A		DW	OP_15AE-OP_1250		;
OPW_8B_MOV	DW	MN_MOV-MN_AAA+01000H	;8B MOV
OPJ_8B		DW	OP_15AE-OP_1250		;
OPW_8C_MOV	DW	MN_MOV-MN_AAA+03000H	;8C MOV
OPJ_8C		DW	OP_1575-OP_1250		;
OPW_8D_LEA	DW	MN_LEA-MN_AAA+01000H	;8D LEA
OPJ_8D		DW	OP_15A9-OP_1250		;
OPW_8E_MOV	DW	MN_MOV-MN_AAA+01000H	;8E MOV
OPJ_8E		DW	OP_158F-OP_1250		;
OPW_8F_POP	DW	MN_POP-MN_AAA+03000H	;8F POP
OPJ_8F		DW	OP_15A0-OP_1250		;
OPW_90_NOP	DW	MN_NOP-MN_AAA		;90 NOP
OPJ_90		DW	OP_17CA-OP_1250		;
OPW_91_XCHG	DW	MN_XCHG-MN_AAA		;91 XCHG
OPJ_91		DW	OP_15E9-OP_1250		;
OPW_92_XCHG	DW	MN_XCHG-MN_AAA		;92 XCHG
OPJ_92		DW	OP_15E9-OP_1250		;
OPW_93_XCHG	DW	MN_XCHG-MN_AAA		;93 XCHG
OPJ_93		DW	OP_15E9-OP_1250		;
OPW_94_XCHG	DW	MN_XCHG-MN_AAA		;94 XCHG
OPJ_94		DW	OP_15E9-OP_1250		;
OPW_95_XCHG	DW	MN_XCHG-MN_AAA		;95 XCHG
OPJ_95		DW	OP_15E9-OP_1250		;
OPW_96_XCHG	DW	MN_XCHG-MN_AAA		;96 XCHG
OPJ_96		DW	OP_15E9-OP_1250		;
OPW_97_XCHG	DW	MN_XCHG-MN_AAA		;97 XCHG
OPJ_97		DW	OP_15E9-OP_1250		;
OPW_98_CBW	DW	MN_CBW-MN_AAA		;98 CBW
OPJ_98		DW	OP_17CA-OP_1250		;
OPW_99_CDW	DW	MN_CWD-MN_AAA		;99 CDW
OPJ_99		DW	OP_17CA-OP_1250		;
OPW_9A_CALL_FAR	DW	MN_CALL_FAR-MN_AAA+06000H ;9A CALL FAR
OPJ_9A		DW	OP_13FB-OP_1250+0A000H	;
OPW_9B_WAIT	DW	MN_WAIT-MN_AAA		;9B WAIT
OPJ_9B		DW	OP_17CA-OP_1250		;
OPW_9C_PUSHF	DW	MN_PUSHF-MN_AAA		;9C PUSHF
OPJ_9C		DW	OP_17CA-OP_1250		;
OPW_9D_POPF	DW	MN_POPF-MN_AAA		;9D POPF
OPJ_9D		DW	OP_17CA-OP_1250		;
OPW_9E_SAHF	DW	MN_SAHF-MN_AAA		;9E SAHF
OPJ_9E		DW	OP_17CA-OP_1250		;
OPW_9F_LAHF	DW	MN_LAHF-MN_AAA		;9F LAHF
OPJ_9F		DW	OP_17CA-OP_1250		;
OPW_A0_MOV	DW	MN_MOV-MN_AAA+01000H	;A0 MOV
OPJ_A0		DW	OP_1417-OP_1250		;
OPW_A1_MOV	DW	MN_MOV-MN_AAA+01000H	;A1 MOV
OPJ_A1		DW	OP_1417-OP_1250		;
OPW_A2_MOV	DW	MN_MOV-MN_AAA+03000H	;A2 MOV
OPJ_A2		DW	OP_15F4-OP_1250		;
OPW_A3_MOV	DW	MN_MOV-MN_AAA+03000H	;A3 MOV
OPJ_A3		DW	OP_15F4-OP_1250		;
OPW_A4_MOVSB	DW	MN_MOVSB-MN_AAA		;A4 MOVSB
OPJ_A4		DW	OP_15FD_STRINGS-OP_1250	;
OPW_A5_MOVSW	DW	MN_MOVSW-MN_AAA		;A5 MOVSW
OPJ_A5		DW	OP_15FD_STRINGS-OP_1250	;
OPW_A6_CMPSB	DW	MN_CMPSB-MN_AAA		;A6 CMPSB
OPJ_A6		DW	OP_15FD_STRINGS-OP_1250	;
OPW_A7_CMPSW	DW	MN_CMPSW-MN_AAA		;A7 CMPSW
OPJ_A7		DW	OP_15FD_STRINGS-OP_1250	;
OPW_A8_TEST	DW	MN_TEST-MN_AAA		;A8 TEST
OPJ_A8		DW	OP_131D-OP_1250		;
OPW_A9_TEST	DW	MN_TEST-MN_AAA		;A9 TEST
OPJ_A9		DW	OP_131D-OP_1250		;
OPW_AA_STOSB	DW	MN_STOSB-MN_AAA		;AA STOSB
OPJ_AA		DW	OP_15FD_STRINGS-OP_1250	;
OPW_AB_STOSW	DW	MN_STOSW-MN_AAA		;AB STOSW
OPJ_AB		DW	OP_15FD_STRINGS-OP_1250	;
OPW_AC_LODSB	DW	MN_LODSB-MN_AAA		;AC LODSB
OPJ_AC		DW	OP_15FD_STRINGS-OP_1250	;
OPW_AD_LODSW	DW	MN_LODSW-MN_AAA		;AD LODSW
OPJ_AD		DW	OP_15FD_STRINGS-OP_1250	;
OPW_AE_SCASB	DW	MN_SCASB-MN_AAA		;AE SCASB
OPJ_AE		DW	OP_15FD_STRINGS-OP_1250	;
OPW_AF_SCASW	DW	MN_SCASW-MN_AAA		;AF SCASW
OPJ_AF		DW	OP_15FD_STRINGS-OP_1250	;
OPW_B0_MOV	DW	MN_MOV-MN_AAA		;B0 MOV
OPJ_B0		DW	OP_162D-OP_1250		;
OPW_B1_MOV	DW	MN_MOV-MN_AAA		;B1 MOV
OPJ_B1		DW	OP_162D-OP_1250		;
OPW_B2_MOV	DW	MN_MOV-MN_AAA		;B2 MOV
OPJ_B2		DW	OP_162D-OP_1250		;
OPW_B3_MOV	DW	MN_MOV-MN_AAA		;B3 MOV
OPJ_B3		DW	OP_162D-OP_1250		;
OPW_B4_MOV	DW	MN_MOV-MN_AAA		;B4 MOV
OPJ_B4		DW	OP_162D-OP_1250		;
OPW_B5_MOV	DW	MN_MOV-MN_AAA		;B5 MOV
OPJ_B5		DW	OP_162D-OP_1250		;
OPW_B6_MOV	DW	MN_MOV-MN_AAA		;B6 MOV
OPJ_B6		DW	OP_162D-OP_1250		;
OPW_B7_MOV	DW	MN_MOV-MN_AAA		;B7 MOV
OPJ_B7		DW	OP_162D-OP_1250		;
OPW_B8_MOV	DW	MN_MOV-MN_AAA		;B8 MOV
OPJ_B8		DW	OP_1634-OP_1250		;
OPW_B9_MOV	DW	MN_MOV-MN_AAA		;B9 MOV
OPJ_B9		DW	OP_1634-OP_1250		;
OPW_BA_MOV	DW	MN_MOV-MN_AAA		;BA MOV
OPJ_BA		DW	OP_1634-OP_1250		;
OPW_BB_MOV	DW	MN_MOV-MN_AAA		;BB MOV
OPJ_BB		DW	OP_1634-OP_1250		;
OPW_BC_MOV	DW	MN_MOV-MN_AAA		;BC MOV
OPJ_BC		DW	OP_1634-OP_1250		;
OPW_BD_MOV	DW	MN_MOV-MN_AAA		;BD MOV
OPJ_BD		DW	OP_1634-OP_1250		;
OPW_BE_MOV	DW	MN_MOV-MN_AAA		;BE MOV
OPJ_BE		DW	OP_1634-OP_1250		;
OPW_BF_MOV	DW	MN_MOV-MN_AAA		;BF MOV
OPJ_BF		DW	OP_1634-OP_1250		;
OPW_C0_???	DW	0000H			;C0 ???
OPJ_C0		DW	OP_17D1-OP_1250		;
OPW_C1_???	DW	0000H			;C1 ???
OPJ_C1		DW	OP_17D1-OP_1250		;
OPW_C2_RETN	DW	MN_RET_NEAR_POP-MN_AAA	;C2 RETN POP
OPJ_C2		DW	OP_1309-OP_1250		;
OPW_C3_RETN	DW	MN_RET_NEAR-MN_AAA	;C3 RETN
OPJ_C3		DW	OP_17B2-OP_1250		;
OPW_C4_LES	DW	MN_LES-MN_AAA+01000H	;C4 LES
OPJ_C4		DW	OP_12ED-OP_1250		;
OPW_C5_LDS	DW	MN_LDS-MN_AAA+01000H	;C5 LDS
OPJ_C5		DW	OP_12ED-OP_1250		;
OPW_C6_MOV	DW	MN_MOV-MN_AAA+03000H	;C6 MOV
OPJ_C6		DW	OP_12FF-OP_1250		;
OPW_C7_MOV	DW	MN_MOV-MN_AAA+03000H	;C7 MOV
OPJ_C7		DW	OP_12FF-OP_1250		;
OPW_C8_???	DW	0000H			;C8 ???
OPJ_C8		DW	OP_17D1-OP_1250		;
OPW_C9_???	DW	0000H			;C9 ???
OPJ_C9		DW	OP_17D1-OP_1250		;
OPW_CA_RETF	DW	MN_RET_FAR_POP-MN_AAA	;CA RETF POP
OPJ_CA		DW	OP_130E-OP_1250		;
OPW_CB_RETF	DW	MN_RET_FAR-MN_AAA	;CB RETF
OPJ_CB		DW	OP_17BD-OP_1250		;
OPW_CC_INT_3	DW	MN_INT-MN_AAA+06000H	;CC INT 3
OPJ_CC		DW	OP_163E-OP_1250+02000H	;
OPW_CD_INT	DW	MN_INT-MN_AAA+06000H	;CD INT
OPJ_CD		DW	OP_1654-OP_1250+02000H	;
OPW_CE_INTO	DW	MN_INTO-MN_AAA		;CE INTO
OPJ_CE		DW	OP_17CA-OP_1250		;
OPW_CF_IRET	DW	MN_IRET-MN_AAA		;CF IRET
OPJ_CF		DW	OP_17B7-OP_1250+02000H	;
OPW_D0_TABLE_W	DW	OFFSET MNW_1FC0		;D0 (TABLE W)
OPJ_D0		DW	OP_1768-OP_1250		;
OPW_D1_TABLE_W	DW	OFFSET MNW_1FC0		;D1 (TABLE W)
OPJ_D1		DW	OP_1768-OP_1250		;
OPW_D2_TABLE_W	DW	OFFSET MNW_1FC0		;D2 (TABLE W)
OPJ_D2		DW	OP_1768-OP_1250		;
OPW_D3_TABLE_W	DW	OFFSET MNW_1FC0		;D3 (TABLE W)
OPJ_D3		DW	OP_1768-OP_1250		;
OPW_D4_AAM	DW	MN_AAM-MN_AAA		;D4 AAM
OPJ_D4		DW	OP_153D-OP_1250		;
OPW_D5_AAD	DW	MN_AAD-MN_AAA		;D5 AAD
OPJ_D5		DW	OP_153D-OP_1250		;
OPW_D6_??DB??	DW	MN_DB-MN_AAA		;D6 ??DB??
OPJ_D6		DW	OP_17D1-OP_1250		;
OPW_D7_XLAT	DW	MN_XLAT-MN_AAA		;D7 XLAT
OPJ_D7		DW	OP_17C7-OP_1250		;
OPW_D8_ESC_0	DW	OFFSET ESC_2020		;D8 ESC 0
OPJ_D8		DW	OP_1660-OP_1250		;
OPW_D9_ESC_1	DW	OFFSET ESC_203C		;D9 ESC 1
OPJ_D9		DW	OP_1683_ESC1-OP_1250	;
OPW_DA_ESC_2	DW	OFFSET ESC_2094		;DA ESC 2
OPJ_DA		DW	OP_16B2-OP_1250		;
OPW_DB_ESC_3	DW	OFFSET ESC_20A4		;DB ESC 3
OPJ_DB		DW	OP_16B8_ESC3-OP_1250	;
OPW_DC_ESC_4	DW	OFFSET ESC_2020		;DC ESC 4
OPJ_DC		DW	OP_167A-OP_1250		;
OPW_DD_ESC_5	DW	OFFSET ESC_20BC		;DD ESC 5
OPJ_DD		DW	OP_16CC_ESC5_7-OP_1250	;
OPW_DE_ESC_6	DW	OFFSET ESC_2094		;DE ESC 6
OPJ_DE		DW	OP_16ED_ESC6-OP_1250	;
OPW_DF_ESC_7	DW	OFFSET ESC_20E4		;DF ESC 7
OPJ_DF		DW	OP_16CC_ESC5_7-OP_1250	;
OPW_E0_LOOPNZ	DW	MN_LOOPNZ-MN_AAA+05000H	;E0 LOOPNZ
OPJ_E0		DW	OP_15BE-OP_1250+0A000H	;
OPW_E1_LOOPZ	DW	MN_LOOPZ-MN_AAA+05000H	;E1 LOOPZ
OPJ_E1		DW	OP_15BE-OP_1250+0A000H	;
OPW_E2_LOOP	DW	MN_LOOP-MN_AAA+05000H	;E2 LOOP
OPJ_E2		DW	OP_15BE-OP_1250+0A000H	;
OPW_E3_JCXZ	DW	MN_JCXZ-MN_AAA+05000H	;E3 JCXZ
OPJ_E3		DW	OP_15BE-OP_1250+0A000H	;
OPW_E4_IN	DW	MN_IN-MN_AAA+07000H	;E4 IN
OPJ_E4		DW	OP_164E-OP_1250		;
OPW_E5_IN	DW	MN_IN-MN_AAA+07000H	;E5 IN
OPJ_E5		DW	OP_164E-OP_1250		;
OPW_E6_OUT	DW	MN_OUT-MN_AAA+07000H	;E6 OUT
OPJ_E6		DW	OP_1643-OP_1250		;
OPW_E7_OUT	DW	MN_OUT-MN_AAA+07000H	;E7 OUT
OPJ_E7		DW	OP_1643-OP_1250		;
OPW_E8_CALL_NEA	DW	MN_CALL-MN_AAA+06000H	;E8 CALL NEAR
OPJ_E8		DW	OP_15DF-OP_1250+0A000H	;
OPW_E9_JMP_NEAR	DW	MN_JMP-MN_AAA+05000H	;E9 JMP NEAR
OPJ_E9		DW	OP_15C6-OP_1250+0A000H	;
OPW_EA_JMP_FAR	DW	MN_JMP_FAR_PTR-MN_AAA+05000H ;EA JMP FAR
OPJ_EA		DW	OP_13FB-OP_1250+0A000H	;
OPW_EB_JMP_SHOR	DW	MN_JMP_SHORT-MN_AAA+05000H ;EB JMP SHORT
OPJ_EB		DW	OP_15BA-OP_1250+0A000H	;
OPW_EC_IN	DW	MN_IN-MN_AAA+07000H	;EC IN
OPJ_EC		DW	OP_1754-OP_1250		;
OPW_ED_IN	DW	MN_IN-MN_AAA+07000H	;ED IN
OPJ_ED		DW	OP_1754-OP_1250		;
OPW_EE_OUT	DW	MN_OUT-MN_AAA+07000H	;EE OUT
OPJ_EE		DW	OP_175F-OP_1250		;
OPW_EF_OUT	DW	MN_OUT-MN_AAA+07000H	;EF OUT
OPJ_EF		DW	OP_175F-OP_1250		;
OPW_F0_LOCK	DW	MN_LOCK-MN_AAA		;F0 LOCK
OPJ_F0		DW	OP_1268-OP_1250		;
OPW_F1_???	DW	0000H			;F1 ???
OPJ_F1		DW	OP_17D1-OP_1250		;
OPW_F2_REPNZ	DW	MN_REPNZ-MN_AAA		;F2 REPNZ
OPJ_F2		DW	OP_1268-OP_1250		;
OPW_F3_REPZ	DW	MN_REPZ-MN_AAA		;F3 REPZ
OPJ_F3		DW	OP_1268-OP_1250		;
OPW_F4_HLT	DW	MN_HLT-MN_AAA		;F4 HLT
OPJ_F4		DW	OP_17CA-OP_1250		;
OPW_F5_CMC	DW	MN_CMC-MN_AAA		;F5 CMC
OPJ_F5		DW	OP_17CA-OP_1250		;
OPW_F6_TABLE_X	DW	OFFSET MNX_1FF0		;F6 (TABLE X)
OPJ_F6		DW	OP_1781-OP_1250		;
OPW_F7_TABLE_X	DW	OFFSET MNX_1FF0		;F7 (TABLE X)
OPJ_F7		DW	OP_1781-OP_1250		;
OPW_F8_CLC	DW	MN_CLC-MN_AAA		;F8 CLC
OPJ_F8		DW	OP_17CA-OP_1250		;
OPW_F9_STC	DW	MN_STC-MN_AAA		;F9 STC
OPJ_F9		DW	OP_17CA-OP_1250		;
OPW_FA_CLI	DW	MN_CLI-MN_AAA		;FA CLI
OPJ_FA		DW	OP_17CA-OP_1250		;
OPW_FB_STI	DW	MN_STI-MN_AAA		;FB STI
OPJ_FB		DW	OP_17CA-OP_1250		;
OPW_FC_CLD	DW	MN_CLD-MN_AAA		;FC CLD
OPJ_FC		DW	OP_17CA-OP_1250		;
OPW_FD_STD	DW	MN_STD-MN_AAA		;FD STD
OPJ_FD		DW	OP_17CA-OP_1250		;
OPW_FE_TABLE_Y	DW	OFFSET MNY_2008		;FE (TABLE Y)
OPJ_FE		DW	OP_178B-OP_1250		;
OPW_FF_TABLE_Y	DW	OFFSET MNY_2008		;FF (TABLE Y)
OPJ_FF		DW	OP_178B-OP_1250		;
		DB	10,'Table V, 80-83: DB and DW difference from Mnemonic '
MNV_1FD8	DB	0			; op-code table-V
MNV_00_ADD	DW	MN_ADD-MN_AAA+04000H
MNV_1FDB	DB	0
MNV_01_OR	DW	MN_OR-MN_AAA+04000H
MNV_1FDE	DB	0
MNV_02_ADC	DW	MN_ADC-MN_AAA+04000H
MNV_1FE1	DB	0
MNV_03_SBB	DW	MN_SBB-MN_AAA+04000H
MNV_1FE4	DB	0
MNV_04_AND	DW	MN_AND-MN_AAA+04000H
MNV_1FE7	DB	0
MNV_05_SUB	DW	MN_SUB-MN_AAA+04000H
MNV_1FEA	DB	0
MNV_06_XOR	DW	MN_XOR-MN_AAA+04000H
MNV_1FED	DB	0
MNV_07_CMP	DW	MN_CMP-MN_AAA+02000H
		DB	10, 'Table W, D0-D3:'
MNW_1FC0	DB	0			; op-code table-W
MNW_00_ROL	DW	MN_ROL-MN_AAA+04000H
MNW_1FC3	DB	0
MNW_01_ROR	DW	MN_ROR-MN_AAA+04000H
MNW_1FC6	DB	0
MNW_02_RCL	DW	MN_RCL-MN_AAA+04000H
MNW_1FC9	DB	0
MNW_03_RCR	DW	MN_RCR-MN_AAA+04000H
MNW_1FCC	DB	0
MNW_04_SHL	DW	MN_SHL-MN_AAA+04000H
MNW_1FCF	DB	0
MNW_05_SHR	DW	MN_SHR-MN_AAA+04000H
MNW_1FD2	DB	0
MNW_06_???	DW	0000H
MNW_1FD5	DB	0
MNW_07_SAR	DW	MN_SAR-MN_AAA+04000H
		DB	10, 'Table X, F6,F7:'
MNX_1FF0	DB	0			; op-code table-X
MNX_00_TEST	DW	MN_TEST-MN_AAA+02000H
MNX_1FF3	DB	0
MNX_01_???	DW	0000H
MNX_1FF6	DB	0
MNX_02_NOT	DW	MN_NOT-MN_AAA+04000H
MNX_1FF9	DB	0
MNX_03_NEG	DW	MN_NEG-MN_AAA+04000H
MNX_1FFC	DB	0
MNX_04_MUL	DW	MN_MUL-MN_AAA+01000H
MNX_1FFF	DB	0
MNX_05_IMUL	DW	MN_IMUL-MN_AAA+01000H
MNX_2002	DB	0
MNX_06_DIV	DW	MN_DIV-MN_AAA+01000H
MNX_2005	DB	0
MNX_07_IDIV	DW	MN_IDIV-MN_AAA+01000H
		DB	10, 'Table Y, FE,FF:'
MNY_2008	DB	0			; op-code table-Y
MNY_00_INC	DW	MN_INC-MN_AAA+04000H
MNY_200B	DB	0
MNY_01_DEC	DW	MN_DEC-MN_AAA+04000H
MNY_200E	DB	20H
MNY_02_CALL_NEA	DW	MN_CALL-MN_AAA+06000H
MNY_2011	DB	20H
MNY_03_CALL_FAR	DW	MN_CALL_DW-MN_AAA+06000H
MNY_2014	DB	20H
MNY_04_JMP_NEAR	DW	MN_JMP-MN_AAA+05000H
MNY_2017	DB	20H
MNY_05_JMP_FAR	DW	MN_JMP_DW_PTR-MN_AAA+05000H
MNY_201A	DB	0
MNY_06_??PUSH??	DW	MN_PUSH-MN_AAA+01000H
MNY_201D	DB	0
MNY_07_???	DW	0000H
		DB	10,'Table ESC & String: DW difference from Mnemonic, 1=null '
ESC_2020	DW	MN_FADD-MN_AAA+01000H
ESC_2022	DW	MN_FMUL-MN_AAA+01000H
ESC_2024	DW	MN_FCOM-MN_AAA+01000H
ESC_2026	DW	MN_FCOMP-MN_AAA+01000H
ESC_2028	DW	MN_FSUB-MN_AAA+01000H
ESC_202A	DW	MN_FSUBR-MN_AAA+01000H
ESC_202C	DW	MN_FDIV-MN_AAA+01000H
ESC_202E	DW	MN_FDIVR-MN_AAA+01000H
STR_2030	DW	MN_MOVS-MN_AAA
STR_2032	DW	MN_CMPS-MN_AAA
STR_2034	DW	1			; 1
STR_2036	DW	1			; 1
STR_2038	DW	MN_LODS-MN_AAA
STR_203A	DW	1			; 1
ESC_203C	DW	MN_FLD-MN_AAA+01000H
ESC_203E	DW	1			; 1
ESC_2040	DW	MN_FST-MN_AAA+03000H
ESC_2042	DW	MN_FSTP-MN_AAA+03000H
ESC_2044	DW	MN_FLDENV-MN_AAA+01000H
ESC_2046	DW	MN_FLDCW-MN_AAA+01000H
ESC_2048	DW	MN_FSTENV-MN_AAA+03000H
ESC_204A	DW	MN_FSTCW-MN_AAA+03000H
ESC_204C	DW	MN_FLD-MN_AAA+01000H
ESC_204E	DW	MN_FXCH-MN_AAA
ESC_2050	DW	MN_FNOP-MN_AAA
ESC_2052	DW	MN_FSTP-MN_AAA
ESC_2054	DW	MN_FCHS-MN_AAA
ESC_2056	DW	MN_FABS-MN_AAA
ESC_2058	DW	1			; 1
ESC_205A	DW	1			; 1
ESC_205C	DW	MN_FTST-MN_AAA
ESC_205E	DW	MN_FXAM-MN_AAA
ESC_2060	DW	1			; 1
ESC_2062	DW	1			; 1
ESC_2064	DW	MN_FLD1-MN_AAA
ESC_2066	DW	MN_FLDL2T-MN_AAA
ESC_2068	DW	MN_FLDL2E-MN_AAA
ESC_206A	DW	MN_FLDPI-MN_AAA
ESC_206C	DW	MN_FLDLG2-MN_AAA
ESC_206E	DW	MN_FLDLN2-MN_AAA
ESC_2070	DW	MN_FLDZ-MN_AAA
ESC_2072	DW	1			; 1
ESC_2074	DW	MN_F2XM1-MN_AAA
ESC_2076	DW	MN_FYL2X-MN_AAA
ESC_2078	DW	MN_FPTAN-MN_AAA
ESC_207A	DW	MN_FPATAN-MN_AAA
ESC_207C	DW	MN_FXTRACT-MN_AAA
ESC_207E	DW	1			; 1
ESC_2080	DW	MN_FDECSTP-MN_AAA
ESC_2082	DW	MN_FINCSTP-MN_AAA
ESC_2084	DW	MN_FPREM-MN_AAA
ESC_2086	DW	MN_FYL2XP1-MN_AAA
ESC_2088	DW	MN_FSQRT-MN_AAA
ESC_208A	DW	1			; 1
ESC_208C	DW	MN_FRNDINT-MN_AAA
ESC_208E	DW	MN_FSCALE-MN_AAA
ESC_2090	DW	1			; 1
ESC_2092	DW	1			; 1
ESC_2094	DW	MN_FIADD-MN_AAA+01000H
ESC_2096	DW	MN_FIMUL-MN_AAA+01000H
ESC_2098	DW	MN_FICOM-MN_AAA+01000H
ESC_209A	DW	MN_FICOMP-MN_AAA+01000H
ESC_209C	DW	MN_FISUB-MN_AAA+01000H
ESC_209E	DW	MN_FISUBR-MN_AAA+01000H
ESC_20A0	DW	MN_FIDIV-MN_AAA+01000H
ESC_20A2	DW	MN_FIDIVR-MN_AAA+01000H
ESC_20A4	DW	MN_FILD-MN_AAA+01000H
ESC_20A6	DW	1			; 1
ESC_20A8	DW	MN_FIST-MN_AAA+03000H
ESC_20AA	DW	MN_FISTP-MN_AAA+03000H
ESC_20AC	DW	1			; 1
ESC_20AE	DW	MN_FLD-MN_AAA+01000H
ESC_20B0	DW	1			; 1
ESC_20B2	DW	MN_FSTP-MN_AAA+03000H
ESC_20B4	DW	MN_FENI-MN_AAA
ESC_20B6	DW	MN_FDISI-MN_AAA
ESC_20B8	DW	MN_FCLEX-MN_AAA
ESC_20BA	DW	MN_FINIT-MN_AAA
ESC_20BC	DW	MN_FLD-MN_AAA+01000H
ESC_20BE	DW	1			; 1
ESC_20C0	DW	MN_FST-MN_AAA+03000H
ESC_20C2	DW	MN_FSTP-MN_AAA+03000H
ESC_20C4	DW	MN_FRSTOR-MN_AAA
ESC_20C6	DW	1			; 1
ESC_20C8	DW	MN_FSAVE-MN_AAA+03000H
ESC_20CA	DW	MN_FSTSW-MN_AAA+03000H
ESC_20CC	DW	MN_FFREE-MN_AAA+03000H
ESC_20CE	DW	MN_FXCH-MN_AAA+03000H
ESC_20D0	DW	MN_FST-MN_AAA+03000H
ESC_20D2	DW	MN_FSTP-MN_AAA+03000H
ESC_20D4	DW	MN_FADDP-MN_AAA+01000H
ESC_20D6	DW	MN_FMULP-MN_AAA+01000H
ESC_20D8	DW	MN_FCOMP-MN_AAA+01000H
ESC_20DA	DW	MN_FCOMPP-MN_AAA+01000H
ESC_20DC	DW	MN_FSUBP-MN_AAA+01000H
ESC_20DE	DW	MN_FSUBRP-MN_AAA+01000H
ESC_20E0	DW	MN_FDIVP-MN_AAA+01000H
ESC_20E2	DW	MN_FDIVRP-MN_AAA+01000H
ESC_20E4	DW	MN_FILD-MN_AAA+01000H
ESC_20E6	DW	1			; 1
ESC_20E8	DW	MN_FIST-MN_AAA+03000H
ESC_20EA	DW	MN_FISTP-MN_AAA+03000H
ESC_20EC	DW	MN_FBLD-MN_AAA+01000H
ESC_20EE	DW	MN_FILD-MN_AAA+01000H
ESC_20F0	DW	MN_FBSTP-MN_AAA+03000H
ESC_20F2	DW	MN_FISTP-MN_AAA+03000H
		DB	10,'Mnemonic '
MN_AAA		DB	'AA', 0C1H
MN_AAD		DB	'AA', 0C4H
MN_AAM		DB	'AA', 0CDH
MN_AAS		DB	'AA', 0D3H
MN_ADC		DB	'AD', 0C3H
MN_ADD		DB	'AD', 0C4H
MN_AND		DB	'AN', 0C4H
MN_BYT_PT	DB	'BYTE PTR', 0A0H
MN_CALL		DB	'CAL', 0CCH
MN_CALL_DW	DB	'CALL', 9, 'DWORD PT', 0D2H
MN_CALL_FAR	DB	'CALL', 9, 'FAR PT', 0D2H
MN_CBW		DB	'CB', 0D7H
MN_CLC		DB	'CL', 0C3H
MN_CLD		DB	'CL', 0C4H
MN_CLI		DB	'CL', 0C9H
MN_CMC		DB	'CM', 0C3H
MN_CMP		DB	'CM', 0D0H
MN_CMPS		DB	'CMP', 0D3H
MN_CMPSB	DB	'CMPS', 0C2H
MN_CMPSW	DB	'CMPS', 0D7H
DATA_2150_CON	DB	'CON:', 0DH
MN_CWD		DB	'CW', 0C4H
MN_DAA		DB	'DA', 0C1H
MN_DAS		DB	'DA', 0D3H
MN_DB		DB	'D', 0C2H
MN_DD		DB	'D', 0C4H
MN_DEC		DB	'DE', 0C3H
DATA_2165	DB	'[DI]', 0ACH
MN_DIV		DB	'DI', 0D6H
DATA_216D_DUP	DB	' DUP', 0A8H
MN_DW		DB	'D', 0D7H
DATA_2174	DB	'DWORD PTR', 0A0H
DATA_217E	DB	'END', 89H
DATA_2182	DB	9, 'ENDS', 0DH, 0AH, ';', 0DH, 8AH
DATA_218C_EQU	DB	9, 'EQU', 89H
MN_ESC		DB	'ES', 0C3H
MN_F2XM1	DB	'F2XM', 0B1H
MN_FABS		DB	'FAB', 0D3H
MN_FADD		DB	'FAD', 0C4H
MN_FADDP	DB	'FADD', 0D0H
MN_FBLD		DB	'FBL', 0C4H
MN_FBSTP	DB	'FBST', 0D0H
MN_FCHS		DB	'F'
MN_CHS		DB	'CH', 0D3H
MN_FCLEX	DB	'FCLE', 0D8H
MN_FCOM		DB	'FCO', 0CDH
MN_FCOMP	DB	'FCOM', 0D0H
MN_FCOMPP	DB	'FCOMP', 0D0H
MN_FDECSTP	DB	'FDECST', 0D0H
MN_FDISI	DB	'FDIS', 0C9H
MN_FDIV		DB	'FDI', 0D6H
MN_FDIVP	DB	'F'
MN_DIVP		DB	'DIV', 0D0H
MN_FDIVR	DB	'FDIV', 0D2H
MN_FDIVRP	DB	'FDIVR', 0D0H
MN_FENI		DB	'FEN', 0C9H
MN_FFREE	DB	'FFRE', 0C5H
MN_FIADD	DB	'FIAD', 0C4H
MN_FICOM	DB	'FICO', 0CDH
MN_FICOMP	DB	'FICOM', 0D0H
MN_FIDIV	DB	'FIDI', 0D6H
MN_FIDIVR	DB	'FIDIV', 0D2H
MN_FILD		DB	'FIL', 0C4H
MN_FIMUL	DB	'FIMU', 0CCH
MN_FINCSTP	DB	'FINCST', 0D0H
MN_FINIT	DB	'FINI', 0D4H
MN_FIST		DB	'FIS', 0D4H
MN_FISTP	DB	'FIST', 0D0H
MN_FISUB	DB	'FISU', 0C2H
MN_FISUBR	DB	'FISUB', 0D2H
MN_FLD		DB	'FL', 0C4H
MN_FLD1		DB	'FLD', 0B1H
MN_FLDL2E	DB	'FLDL2', 0C5H
MN_FLDL2T	DB	'FLDL2', 0D4H
MN_FLDCW	DB	'FLDC', 0D7H
MN_FLDENV	DB	'FLDEN', 0D6H
MN_FLDLG2	DB	'FLDLG', 0B2H
MN_FLDLN2	DB	'FLDLN', 0B2H
MN_FLDPI	DB	'FLDP', 0C9H
MN_FLDZ		DB	'FLD', 0DAH
MN_FMUL		DB	'FMU', 0CCH
MN_FMULP	DB	'FMUL', 0D0H
MN_FNOP		DB	'FNO', 0D0H
MN_FPATAN	DB	'FPATA', 0CEH
MN_FPREM	DB	'FPRE', 0CDH
MN_FPTAN	DB	'FPTA', 0CEH
MN_FRNDINT	DB	'FRNDIN', 0D4H
MN_FRSTOR	DB	'FRSTO', 0D2H
MN_FSAVE	DB	'FSAV', 0C5H
MN_FSCALE	DB	'FSCAL', 0C5H
MN_FSQRT	DB	'FSQR', 0D4H
MN_FST		DB	'FS', 0D4H
MN_FSTCW	DB	'FSTC', 0D7H
MN_FSTENV	DB	'FSTEN', 0D6H
MN_FSTP		DB	'FST', 0D0H
MN_FSTSW	DB	'FSTS', 0D7H
MN_FSUB		DB	'FSU', 0C2H
MN_FSUBP	DB	'FSUB', 0D0H
MN_FSUBR	DB	'FSUB', 0D2H
MN_FSUBRP	DB	'FSUBR', 0D0H
MN_FTST		DB	'FTS', 0D4H
MN_FXAM		DB	'FXA', 0CDH
MN_FXCH		DB	'FXC', 0C8H
MN_FXTRACT	DB	'FXTRAC', 0D4H
MN_FYL2X	DB	'FYL2', 0D8H
MN_FYL2XP1	DB	'FYL2XP', 0B1H
MN_HLT		DB	'HL', 0D4H
MN_IDIV		DB	'IDI', 0D6H
MN_IMUL		DB	'IMU', 0CCH
MN_IN		DB	'I', 0CEH
MN_INC		DB	'IN', 0C3H
MN_INT		DB	'IN', 0D4H
MN_INTO		DB	'INT', 0CFH
MN_IRET		DB	'IRE', 0D4H
MN_JA		DB	'J', 0C1H
MN_JB		DB	'J', 0C2H
MN_JBE		DB	'JB', 0C5H
MN_JCXZ		DB	'JCX', 0DAH
MN_JG		DB	'J', 0C7H
MN_JGE		DB	'JG', 0C5H
MN_JL		DB	'J', 0CCH
MN_JLE		DB	'JL', 0C5H
MN_JMP		DB	'JM', 0D0H
MN_JMP_FAR_PTR	DB	'JMP', 9, 'FAR PT', 0D2H
MN_JMP_DW_PTR	DB	'JMP', 9, 'DWORD PT', 0D2H
MN_JMP_SHORT	DB	'JMP', 9, 'SHOR', 0D4H
MN_JNB		DB	'JN', 0C2H
MN_JNO		DB	'JN', 0CFH
MN_JNS		DB	'JN', 0D3H
MN_JNZ		DB	'JN', 0DAH
MN_JO		DB	'J', 0CFH
MN_JPE		DB	'JP', 0C5H
MN_JPO		DB	'JP', 0CFH
MN_JS		DB	'J', 0D3H
MN_JZ		DB	'J', 0DAH
MN_LAHF		DB	'LAH', 0C6H
MN_LDS		DB	'LD', 0D3H
MN_LEA		DB	'LE', 0C1H
MN_LES		DB	'LE', 0D3H
MN_LOCK		DB	'LOCK', 89H
MN_LODS		DB	'LOD', 0D3H
MN_LODSB	DB	'LODS', 0C2H
MN_LODSW	DB	'LODS', 0D7H
MN_LOOP		DB	'LOO', 0D0H
MN_LOOPNZ	DB	'LOOPN', 0DAH
MN_LOOPZ	DB	'LOOP', 0DAH
MN_MOV		DB	'MO', 0D6H
MN_MOVS		DB	'MOV', 0D3H
MN_MOVSB	DB	'MOVS', 0C2H
MN_MOVSW	DB	'MOVS', 0D7H
MN_MUL		DB	'MU', 0CCH
MN_NEG		DB	'NE', 0C7H
MN_TAB_NOP	DB	9
MN_NOP		DB	'NO', 0D0H
MN_NOT		DB	'NO', 0D4H
MN_OFFSET	DB	'OFFSET', 0A0H
MN_OR		DB	'O', 0D2H
MN_OUT		DB	'OU', 0D4H
MN_POP		DB	'PO', 0D0H
MN_POPF		DB	'POP', 0C6H
MN_PUSH		DB	'PUS', 0C8H
MN_PUSHF	DB	'PUSH', 0C6H
MN_RCL		DB	'RC', 0CCH
MN_RCR		DB	'RC', 0D2H
MN_REPNZ	DB	'REPNZ', 89H
MN_REPZ		DB	'REPZ', 89H
MN_RET_FAR	DB	'RET_FA', 0D2H
MN_RET_FAR_POP	DB	'RET_FAR_PO', 0D0H
MN_RET_NEAR	DB	'RET_NEA', 0D2H
MN_RET_NEAR_POP	DB	'RET_NEAR_PO', 0D0H
MN_ROL		DB	'RO', 0CCH
MN_ROR		DB	'RO', 0D2H
MN_SAHF		DB	'SAH', 0C6H
MN_SAR		DB	'SA', 0D2H
MN_SBB		DB	'SB', 0C2H
MN_SCASB	DB	'SCAS', 0C2H
MN_SCASW	DB	'SCAS', 0D7H
MN_SHL		DB	'SH', 0CCH
MN_SHR		DB	'SH', 0D2H
DATA_2417	DB	'[SI', 0DDH
MN_STC		DB	'ST', 0C3H
MN_STD		DB	'ST', 0C4H
MN_STI		DB	'ST', 0C9H
MN_STOSB	DB	'STOS', 0C2H
MN_STOSW	DB	'STOS', 0D7H
MN_SUB		DB	'SU', 0C2H
MN_TITLE	DB	'PAGE',9,'58,132',0DH,0AH ;added characters in string
		DB	'TITLE', 89H	; 'PAGE',9,'58,132',0DH,0AH,'TITLE',89H
MN_TEST		DB	'TES', 0D4H
MN_WAIT		DB	'WAI', 0D4H
MN_WORD_PT	DB	'WORD PTR', 0A0H
MN_XCHG		DB	'XCH', 0C7H
MN_XLAT		DB	'XLA', 0D4H
MN_XOR		DB	'XO', 0D2H
MN_SEG_STK	DB	9, 'SEGMENT'
FIX_MN_STK	DB	0DH, 8AH
		DB	'STACK', 0DH, 8AH
MN_ASSUME	DB	9, 'ASSUME DS:S'
FIX_DS_SEG	DB	'0000, SS:S0000 ,CS:S0000 ,ES:S0000', 0DH, 8AH
MN_ORG_$	DB	9, 'ORG', 9, '$', 0ABH
		;-------------------------------
BYTE_REGS_249B	DB	'ALCLDLBLAHCHDHBH'
WORD_REGS_24AB	DB	'AXCXDXBXSPBPSIDI'
SEG_REGS_24BB	DB	'ESCSSSDS'
DATA_24C3	DB	'BXBXBPBP'		; Data table (indexed access)
DATA_24CB	DB	'SIDIBPBX'		; Data table (indexed access)
DATA_24D3	DB	'IRTWMJCP?'
DATA_24DC	DB	'DSCE'
		;-------------------------------
MAC_PATCH83	DB	0			; byte can now be 0 or 0FFH
		DB	'PATCH83', 9, 'MACRO', 9, 'X', 0DH, 0AH
		DB	'ORG', 9, '$-3', 0DH, 0AH
		DB	'DB', 9, '81H', 0DH, 0AH  ;op-code is now 81H
		DB	'ORG', 9, '$+2', 0DH, 0AH
		DB	'DB', 9, 'X', 0DH, 0AH
		DB	'ENDM', 0DH, 0AH
		DB	';', 0DH
		DB	8AH
MAC_RET_FAR	DB	0
		DB	'RET_FAR', 9, 'MACRO', 0DH, 0AH
		DB	'DB', 9, '0CBH', 0DH, 0AH
		DB	'ENDM', 0DH, 0AH
		DB	';', 0DH
		DB	8AH
MAC_RET_FAR_P	DB	0
		DB	'RET_FAR_POP', 9, 'MACRO', 9, 'X', 0DH, 0AH
		DB	'DB', 9, '0CAH', 0DH, 0AH
		DB	'DW', 9, 'X', 0DH, 0AH
		DB	'ENDM', 0DH, 0AH
		DB	';', 0DH
		DB	8AH
MAC_RET_NEAR	DB	0
		DB	'RET_NEAR', 9, 'MACRO', 0DH, 0AH
		DB	'DB', 9, '0C3H', 0DH, 0AH
		DB	'ENDM', 0DH, 0AH
		DB	';', 0DH
		DB	8AH
MAC_RET_NEAR_P	DB	0
		DB	'RET_NEAR_POP', 9, 'MACRO', 9, 'X'
		DB	0DH, 0AH, 'DB', 9, '0C2H', 0DH, 0AH
		DB	'DW', 9, 'X', 0DH, 0AH
		DB	'ENDM', 0DH, 0AH
		DB	';', 0DH
		DB	8AH, 0FFH
		;-------------------------------
MN_PATCH83_POS	DB	9, 'PATCH83', 9, '0', 0DH	;altered, positive
		DB	8AH
MN_PATCH83_NEG	DB	9, 'PATCH83', 9, '0FFH', 0DH	;New MACRO, negative
		DB	8AH
MN_DOT_RADIX_16	DB	'.RADIX', 9, '16', 0DH, 0AH
MN_CRLF_INIT_VL	DB	'LF', 9, 'EQU', 9, '0AH', 0DH, 0AH
		DB	'CR', 9, 'EQU', 9, '0DH', 0DH, 0AH
		DB	';', 0DH, 0AH
		DB	';INITIAL VALUES :', 9, 'CS:IP', 9
INIT_CS_SEG_FIX	DB	'0000:0000', 0DH, 0AH		;patch up location
		DB	';', 9, 9, 9, 'SS:SP', 9
INIT_SP_SEG_FIX	DB	'0000:0000', 0DH		;patch up location
		DB	8AH
		;-------------------------------
MS_PROMPT_XARQ	DB	'X <$'
DATA_2627	DB	'>, A <CON>, R <CON> or Q ? $'
	;****	DB	'Invalid drive specification$'	; (apparently unused)
MS_NOCLOSE_265F	DB	0DH, 0AH, 'Unable to close output file$'
MS_FILE_267D	DB	'File $'
MS_NOTFND_2683	DB	' not found', 7
;***DATA_268E	DB	0DH, 0AH, '$'
MS_CRLF_$	DB	0DH, 0AH, '$'
MS_DIRFULL_2691	DB	'No room in disk directory$'
MS_DSKFULL_26AB	DB	'Insufficient space on disk$'
MS_ERR_RD_26C6	DB	'Error in reading exe file$'
MS_ERR_SEQ_26E0	DB	'Unrecognized type in /SEQ file near address '
DATA_270C	DB	'0000H$'
MS_AD_ORDR_2712	DB	'Addresses out of order near address '
DATA_2736	DB	'0000H', 0DH, 0AH, '$'
MS_STR_SEQ_273E	DB	'Undefined structure in SEQ file$'
MS_RELOC_275E	DB	';Relo'
		DB	0E3H
MS_ASM_2764	DB	'ASM'
MS_NUL_2767	DB	'NUL '
MS_SEQ_276B	DB	'SEQ'
MS_TBL_276E	DB	'TBL'
MS_HXVL_ER_2771	DB	'Hex value error in /SEQ file$'
MS_BYT_N_OT_FLE	DB	'Bytes in output file: $'
MS_FILE_SPEC_ER DB	' File spec error$'
MS_REF_TBL_INCOMP DB	7, 'Reference Table Incomplete due to '
MS_INSUFF_MEM	DB	'Insufficient memory$'
MS_INVALID_CMD	DB	'Invalid command$'
MS_WRITING_27FD	DB	0DH, 0AH, 'Writing $'
MS_BLDG_REF_TBL	DB	'Building Reference Table', 0DH, 0AH, '$'
		;-------------------------------
DATA_2823	DW	0			; Data table (indexed access)
DATA_2825	DW	0, 0, 0			;   4-words

DATA_282A	DB	0			; 0th-buffer byte (unused)
DATA_282B	DB	24 DUP (0)		; 24-byte buffer

RM_FIELD_2843	DB	0			; R/M 3-bit field
MOD_FIELD_2844	DB	0			; MOD 2-bit field
REG_FIELD_2845	DB	0			; REG 3-bit field
DATA_2846	DB	0
DATA_2847	DB	0
DATA_2848	DB	0
DATA_2849	DW	0
DATA_284B	DW	0
DATA_284D	DW	0, 0
DATA_2851	DW	0
DATA_2853	DB	0
DATA_2854	DW	0			; Tab counter ?
DATA_2856	DB	0, 0
DATA_2858	DW	0
DATA_285A	DW	0
DATA_285C	DB	0
DATA_285D	DB	0, 0
OPW_TBL_WD_285F	DW	0
DATA_2861	DB	0
DATA_2862	DB	0
DATA_2863	DB	0, 0, 0
DATA_2866	DB	0
DATA_2867	DW	0
OPJ_HI_BYT_2869	DB	0
OPW_HI_NBL_286A	DB	0			; The low 4-bits are zeros
OPCODE_BYT_286B	DB	0			; used as BYTE/WORD flag
MOD_REG_RM_286C	DB	0			; MOD REG R/M Op-code modifier byte
DATA_286D	DB	0
DATA_286E	DB	0
DATA_286F	DB	0
		;-------------------------------
;DATA_2870	DB	0FFH			; Data table (indexed access)
;DATA_2871	DB	0FFH
;DATA_2872	DB	0FFH
;DATA_2873	DB	0FFH
;DATA_2874	DB	0FFH
;DATA_2875	DB	0FFH
;DATA_2876	DB	0FFH
;RAD16_FLAG_2877 DB	0FFH
;DATA_2878	DB	0FFH

SEQ_SW_BYTES	LABEL	BYTE		;alias name, used for indexing
SW_O_OUTPUT_LST	DB	0FFH		; Data table (indexed access)
SW_R_TABLE_LST	DB	0FFH
SW_E_EMBED_REF	DB	0FFH
SW_L_LABEL_NUMB	DB	0FFH
SW_F_8087_CODES	DB	0FFH
SW_T_TRACE_OUTP	DB	0FFH
SW_B_BYTE_REFS	DB	0FFH
SW_H_HEX_SUFFIX	DB	0FFH
SW_M_MACRO_LIST	DB	0FFH
		;-------------------------------
DATA_2879	DB	9, ';', 27H
DATA_287C	DB	'HL'
		DB	0A7H
DATA_287F	DW	0
DATA_2881	DW	0
DATA_2883	DW	0
DATA_2885	DW	0
DATA_2887	DB	0
DATA_2888	DB	0
DATA_2889	DW	0
DATA_288D	DW	0
DATA_288F	DW	0
DATA_2891	DW	0
DATA_2893	DW	0
DATA_2895	DB	128 DUP (0)		; 128-byte buffer
DATA_2915	DW	0, 0
DATA_2919	DW	0
DATA_291B	DB	0
		;-------------------------------
FCB1_291C	DB	0			; File Control Block #1 (37-bytes)
FCB1_NAME_291D	DB	8 DUP (20H)		; 8-Byte File Name
FCB1_EXT_2925	DB	3 DUP (20H)		; 3-Byte File Extension
		DB	0, 0			; 1-Word Current Block Number
		DB	0, 0			; 1-Word Record Size
FCB1_FILSZ_292C	DB	4 DUP (0)		; 4-Byte File Size (in bytes)
		DB	0, 0			; 1-Word Date
		DB	0, 0			; 1-Word Time
		DB	8 DUP (0)		; 8-Byte Reserved for DOS
		DB	0			; 1-Byte Current Record Number
		DB	4 DUP (0)		; 4-Byte Random Record Number
	;***	DB	0			; (apparently unused)
		;-------------------------------
FCB2_2942	DB	0			; File Control Block #2 (37-bytes)
FCB2_NAME_2943	DB	8 DUP (20H)		; 8-Byte File Name
FCB2_EXT_294B	DB	3 DUP (20H) 		; 3-Byte File Extension
		DB	0, 0			; 1-Word Current Block Number
		DB	0, 0			; 1-Word Record Size
		DB	4 DUP (0)		; 4-Byte File Size (in bytes)
		DB	0, 0			; 1-Word Date
		DB	0, 0			; 1-Word Time
		DB	8 DUP (0)		; 8-Byte Reserved for DOS
		DB	0			; 1-Byte Current Record Number
		DB	4 DUP (0)		; 4-Byte Random Record Number
		;-------------------------------
	;***	DB	0			; (apparently unused)

KBD_BUF_2968	DB	20H, 0			; Keyboard Buffer
DATA_296A	DB	33 DUP (0)		; Keyboard line buffer
;**DATA_298B	DB	132 DUP (0)		; line buffer
LINE_BUF_132CHR	DB	132 DUP (0)		; line buffer
		;-------------------------------
FCB3_2A0F	DB	0			; FCB #3 - File to be disassembled
FCB3_NAME_2A10	DB	7 DUP (20H)		; 8-Byte File Name
FCB3_EXT_2A17	DB	20H			; 1-Word File Ext 1st char
FCB3_EXT1_2A18	DB	20H			; 1-Byte File Ext 1st char
FCB3_EXT2_2A19	DB	20H			; 1-Byte File Ext 2nd char
FCB3_EXT3_2A1A	DB	20H			; 1-Byte File Ext 3rd char
FCB3_BLKNO_2A1B	DB	0, 0			; 1-Word Current Block Number
FCB3_RECSZ_2A1D	DB	0, 0			; 1-Word Record Size
FCB3_FILSZ_2A1F	DB	4 DUP (0)		; 4-Byte File Size
FCB3_DATE_2A23	DB	0, 0			; 1-Word Date File Created/Updated
		DB	0, 0			; 1-Word Time File Created
		DB	8 DUP (0)		; 8-Byte Reserved for DOS
FCB3_CUREC_2A2F	DB	0			; 1-byte Current Record Number
FCB3_RNDRC_2A30	DW	0, 0			; 2-Word Random Record Number
		;-------------------------------
FCB4_2A34	DB	0			; File Control Block #4 (37-bytes)
FCB4_NAME_2A35	DB	8 DUP (20H)		; 8-Byte File Name
		DB	3 DUP (20H)		; 3-Byte File Extension
		DB	0, 0			; 1-word Current Block number
FCB4_RECSZ_2A42	DB	0, 0			; 1-Word Record Size
FCB4_FILSZ_2A44	DB	0, 0			; 4-Byte File Size
FCB4_FLSZH_2A46	DB	0, 0			; (High word of File Size)
		DB	0, 0			; Date
		DB	0, 0			; Time
FCB4_RESRV_2A4C	DB	8 DUP (0)		; 8-Byte (Reserved area)
FCB4_CUREC_2A54	DB	0			; Current Record number
		DB	4 DUP (0)		; Random Record number
		;-------------------------------
	;***	DB	37 DUP (0)		; (apparently unused)

DTA1_2A7E	DB	0, 0			; Disk transfer area #1
DATA_2A80	DW	0
DATA_2A82	DW	0
DATA_2A84	DW	7420H			; (value left just in case)
DATA_2A86	DW	0, 0, 0
DATA_2A8C	DW	0
DATA_2A8E	DW	0, 0
DATA_2A92	DW	0			; initial IP for disassembly
DATA_2A94	DW	0			; initial CS for disassembly
DATA_2A96	DW	0			; Random Rec Numb for FCB3
		;-------------------------------
DTA2_2A98	DB	0, 0			; Disk transfer area #2
DTA2_W2_2A9A	DB	0, 0
		DB	0, 0			; (apparently not used)
		;-------------------------------
DTA3_2A9E	DB	0		; Disk transfer area #3, 512 bytes
MS_PC_DISASMB	DB	0DH, 0AH, 'The IBM Personal Computer '
		DB	'Assembly Code Generator', 0DH, 0AH
		DB	'By J. Gersbach BTVVMLAB(U6081) '
		DB	'Public Domain Material', 0DH, 0AH
		DB	'Version 2.01 - Enhancements By '
		DB	'J. Damke BOEVM1(DAMKE)', 0DH, 0AH
		DB	'Version 3.01 - Enhancements and code clean-up By '
		DB	'James E. Galbraith', 0DH, 0AH, 0AH
		DB	'Command summary :', 0DH, 0AH
		DB	9, 'X Executable filespec', 0DH, 0AH
		DB	9, 'A <Assembly Code filespec>', 0DH, 0AH
		DB	9, 'R <Reference table filespec>', 0DH, 0AH
		DB	9, 'Q Quit and return to DOS', 0DH, 0AH, 0AH
		DB	'Executable filespec ? $'
		DB	124 DUP (0)	; for a total of 512 bytes in DTA3
		;-------------------------------
DTA4_2C9E	DB	0		; Disk transfer area #4, 98 bytes
;***		DB	96 DUP (0)
;**LAST_BYTE	DB	0		; DATA_2E9E_E	EQU	OFFSET LAST_BYTE+19FH

SEG_A		ENDS

		END	START
