;
; *** Listing 11-18 ***
;
; Demonstrates the calculation of the element number in a
; look-up table of a byte matching the ASCII value of a
; keystroke when SCASB is used, where the 1-count
; overrun of SCASB must be compensated for. The element
; number in the look-up table is used to look up the
; corresponding address in a second table; that address is
; then jumped to in order to handle the keystroke.
;
; This is a standalone program, not to be used with PZTIME
; but rather assembled, linked, and run by itself.
;
stack	segment	para stack 'STACK'
	db	512 dup (?)
stack	ends
;
code	segment	para public 'CODE'
	assume	cs:code, ds:nothing
;
; Main loop, which simply calls VectorOnASCIIKey until one
; of the key handlers ends the program.
;
start	proc	near
	call	VectorOnASCIIKey
	jmp	start
start	endp
;
; Gets the next 16-bit key code from the BIOS, looks up just
; the 8-bit ASCII portion in ASCIIKeyLookUpTable, and jumps
; to the corresponding routine according to
; ASCIIKeyJumpTable. When the jumped-to routine returns, it
; will return directly to the code that called
; VectorOnASCIIKey. Ignores the key if the key code is not
; in the look-up table.
;
; Input: none
;
; Output: none
;
; Registers altered: AX, CX, DI, ES
;
; Direction flag cleared
;
; Table of 8-bit ASCII codes this routine handles.
;
ASCIIKeyLookUpTable	label	word
	db	02h	;Ctrl-B to beep
	db	18h	;Ctrl-X to exit
;*** Additional ASCII codes go here ***
ASCII_KEY_LOOK_UP_TABLE_LENGTH equ ($-ASCIIKeyLookUpTable)
;
; Table of addresses to jump to when corresponding key codes
; in ASCIIKeyLookUpTable are found.
;
ASCIIKeyJumpTable	label	word
	dw	Beep
	dw	Exit
;*** Additional addresses go here ***
;
VectorOnASCIIKey	proc	near
WaitASCIIKeyLoop:
	mov	ah,1	;BIOS key status function
	int	16h	;invoke BIOS to see if
			; a key is pending
	jz	WaitASCIIKeyLoop ;wait until key comes along
	sub	ah,ah	;BIOS get key function
	int	16h	;invoke BIOS to get the key
	push	cs
	pop	es
	mov	di,offset ASCIIKeyLookUpTable
			;point ES:DI to the table of keys
			; we handle, which is in the same
			; segment as this code
	mov	cx,ASCII_KEY_LOOK_UP_TABLE_LENGTH
			;# of bytes to scan
	cld
	repnz	scasb	;look up the key
	jnz	WaitASCIIKeyLoop ;it's not in the table, so
				; ignore it
	mov	di,ASCII_KEY_LOOK_UP_TABLE_LENGTH-1
	sub	di,cx	;calculate the # of the element we
			; found in ASCIIKeyLookUpTable.
			; The -1 is needed to compensate for
			; the 1-count overrun of SCAS
	shl	di,1	;multiply by 2 in order to perform
			; the look-up in word-sized
			; ASCIIKeyJumpTable
	jmp	cs:[ASCIIKeyJumpTable+di]
			;jump to the routine for this key
VectorOnASCIIKey	endp
;
; Code to handle Ctrl-X (ends the program).
;
Exit	proc	near
	mov	ah,4ch	;DOS terminate program function
	int	21h	;exit program
Exit	endp
;
; Code to handle Ctrl-B (beeps the speaker).
;
Beep	proc	near
	mov	ax,0e07h ;AH=0E is BIOS print character
			; function, AL=7 is bell (beep)
			; character
	int	10h	;tell BIOS to beep the speaker
	ret
Beep	endp
;
code	ends
	end	start
