;
; *** Listing 7-18 ***
;
; Performs fast, compact bit-doubling of a byte in AL
; to a word in AX by using two nibble look-ups. Overall
; code length and performance are improved by
; using XLAT to look up the nibbles.
;
; Macro to double each bit in a byte.
;
; Input:
;	AL = byte to bit-double
;
; Output:
;	AX = bit-doubled word
;
; Registers altered: AX, BX, CL
;
DOUBLE_BYTE	macro
	mov	ah,al	;set aside the byte to look up
	mov	cl,4	;make a look-up pointer out of the
	shr	al,cl	; upper nibble of the byte (XLAT
			; uses AL as an index pointer)
	mov	bx,offset DoubledNibbleTable
			;XLAT uses BX as a base pointer
	xlat		;look up the doubled value of the
			; upper nibble
	xchg	ah,al	;store the doubled upper nibble in AH
			; and get back the value to double
	and	al,0fh	;make a look-up pointer out of the
			; lower nibble of the byte
	xlat		;look up the doubled value of the
			; lower nibble of the byte
	endm
;
	jmp	Skip
DOUBLED_VALUE=0
DoubledNibbleTable	label	byte
	db	000h, 003h, 00ch, 00fh
	db	030h, 033h, 03ch, 03fh
	db	0c0h, 0c3h, 0cch, 0cfh
	db	0f0h, 0f3h, 0fch, 0ffh
;
Skip:
	call	ZTimerOn
BYTE_TO_DOUBLE=0
	rept	100
	mov	al,BYTE_TO_DOUBLE
	DOUBLE_BYTE
BYTE_TO_DOUBLE=BYTE_TO_DOUBLE+1
	endm
	call	ZTimerOff
