;
; *** Listing 7-5 ***
;
; Adds one far array to another far array as only assembler
; can, loading the two far pointers once and keeping them in
; the registers during the entire loop for speed.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
Array1	db	ARRAY_LENGTH dup (1)
Array2	db	ARRAY_LENGTH dup (2)
;
; Adds one byte-sized array to another byte-sized array.
; C-callable.
;
; Input: parameters on stack as in AddArraysParms
;
; Output: none
;
; Registers altered: AL, BX, CX, DX, ES
;
AddArraysParms	struc
	dw	?	;pushed BP
	dw	?	;return address
FarPtr1	dd	?	;pointer to array to be added to
FarPtr2	dd	?	;pointer to array to add to the
			; other array
AddArraysLength	dw ?	;# of bytes to add
AddArraysParms	ends
;
AddArrays	proc	near
	push	bp		;save caller's BP
	mov	bp,sp		;point to stack frame
	push	si		;save registers used by many
	push	di		; C compilers for register
				; variables
	mov	cx,[bp+AddArraysLength]
				;get the length to add
	les	si,[bp+FarPtr2]	;point to the array to add
				; from
	mov	dx,es		;set aside the segment
	les	bx,[bp+FarPtr1]	;point to the array to add
				; to
	mov	di,es		;set aside the segment
AddArraysLoop:
	mov	es,dx		;point ES:SI to the next
				; byte of the array to add
				; from
	mov	al,es:[si]	;get the array element to
				; add
	inc	si		;point to the next byte of
				; the array to add from
	mov	es,di		;point ES:BX to the next
				; byte of the array to add
				; to
	add	es:[bx],al	;add to the array
	inc	bx		;point to the next byte of
				; the array to add to
	loop	AddArraysLoop
	pop	di		;restore registers used by
	pop	si		; many C compilers for
				; register variables
	pop	bp		;restore caller's BP
	ret
AddArrays	endp
;
Skip:
	call	ZTimerOn
	mov	ax,ARRAY_LENGTH
	push	ax	;pass the length to add
	push	ds	;pass segment of Array2
	mov	ax,offset Array2
	push	ax	;pass offset of Array2
	push	ds	;pass segment of Array1
	mov	ax,offset Array1
	push	ax	;pass offset of Array1
	call	AddArrays
	add	sp,10	;clear the parameters
	call	ZTimerOff
