// dev_dte.c - DTE20 Ten-Eleven Interface routines
//
// Written by
//  Timothy Stark <sword7@speakeasy.org>
//
// This file is part of the TS10 Emulator.
// See ReadMe for copyright notice.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Device Name: DTE
// Device Code: 200,204,210,214

// (CONxx) Condition Bits on Device DTE.
#define DTE_RM     0100000 // Restricted Mode 11
#define DTE_DEAD11 0040000 // Power Failure on PDP-11
#define DTE_TO11DB 0020000 // Ring Doorbell to PDP-11
#define DTE_CR11B  0010000 // Clear Reload PDP-11 Button
#define DTE_SR11B  0004000 // Set Reload PDP-11 Button
#define DTE_CL11PT 0001000 // Clear Doorbell for PDP-10
#define DTE_TO11ER 0000400 // To-11 Error
#define DTE_TO11DN 0000100 // To-11 Normal Termination Flag
#define DTE_CLTO11 0000100 // Clear To-11 Normal Termination Flag
#define DTE_TO10DN 0000040 // To-10 Normal Termination Flag
#define DTE_CLTO10 0000040 // Clear To-10 Normal Termination Flag
#define DTE_PILDEN 0000020 // Enable Load PIA
#define DTE_PIOENB 0000010 // PI0 Enable
#define DTE_PIA    0000007 // PIA

#define DTE_CLR    (DTE_CR11B|DTE_CL11PT|DTE_CLTO11|DTE_CLTO10)

// (DATAx) Data Bits on Device DTE.
#define DTE_TO10IB 0010000 // Interrupt after xfer
#define DTE_TO10BC 0007777 // To-10 Byte Count Field

// DTE20 Hardware EPT Locations
#define DTEHBG 0140 // Beginning of DTE20 Hardware EPT Location
#define DTEEBP 0140 // To-11 Byte Pointer
#define DTETBP 0141 // To-10 Byte Pointer
#define DTEDII 0142 // Interrupt Location
//             0143 // Unused
#define DTEEPW 0144 // Examine Protection Word
#define DTEERW 0145 // Examine Relocation Word
#define DTEDPW 0146 // Deposit Protection Word
#define DTEDRW 0147 // Deposit Relocation Word
#define DTEHBE 0147 // End of DTE20 Hardware EPT Location

// DTE20 Secondary Protocol Locations
//   11 = PDP10 Rings PDP11 Doorbell
//   10 = PDP11 Rings PDP10 Doorbell

#define DTEFLG 0444 //      Operation Complete Flag
//             0445 //      \
//             0446 //       > Unused
//             0447 //      /
#define DTEF11 0450 //      Chracter from CTY to PDP-10
#define DTECMD 0451 // (11) PDP-10 to PDP-11 Command Word
//             0452 //      \
//             0453 //       > Unused
//             0454 //      /
#define DTEMTD 0455 // (10) CTY Output Complete Flag
#define DTEMTI 0456 // (10) CTY Input Flag

// DTE20 Secondary Protocol Command Field
#define DTE_MTO 010 // CTY Output
#define DTE_ESP 011 // Enter Secondary Protocol
#define DTE_LSP 012 // Leave Secondary Protocol
#define DTE_GDT 013 // Get Date/Time

P10DEVICE p10dev_DTE = {
	"DTE",
	NULL,
	NULL,
	{
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
	}
};

