/*
 * rad50.c
 *
 * Routines to convert Radix-50 data as used in DEC systems.
 *
 * John Dudeck   SIM International   25-Aug-92
 */
#include "rad50.h"
/*
 * r50toa()
 * Convert long integer containing two rad50 characters
 * to three ascii characers plus null byte at destination
 */
void r50toa(char * dest, unsigned long int src) {
   int k;

   for (k=2; k>=0; k--) {
      dest[k] = (src % 40);
      switch (dest[k]) {
         case 0: {
            dest[k] = ' ';  /* 0 is space */
           break;
         }
         case 27: {
           dest[k] = '$';  /* 27 is $ */
            break;
         }
         default: {
            dest[k] += 64;  /* offset to alpha A-Z */
            if (dest[k] > 'Z') dest[k] -= 46;  /* offset to . / numerals */
            break;
         }
      }
      src /= 40;
   }
   dest[3] = '\0';
}