/*
 * dosfile.cpp
 *
 * Implementation module for DOSfile class.
 *
 * John Dudeck   SIM International   25-Aug-92
 */
#include <ctype.h>
#include <string.h>
#include <dir.h>
#include <sys\stat.h>
#include <iostream.h>
#include "dosfile.h"

typedef int boolean;
enum {false, true};

DOSfile::DOSfile(char * fspec) {
   // Filespec syntax:
   // fspec     ::= drive name extension
   // drive     ::= letter ':'
   //           | 
   // name      ::= letters(0 to 8)
   //           |   letters(0 to 7) '*'
   // extension ::= '.' letters(0 to 3)
   //           |   '.' letters(0 to 2) '*'
   //           |
   // letters   ::= 'A' thru 'Z', '0' thru '9', ~!@#$%^&()_-+={}[]
   // letter    ::= 'A' thru 'Z'
   //
   // Note:
   // A missing drive letter implies the current DOS default drive
   // A missing name part implies a name of '*'.
   // A missing dot implies an extension of '*'.
   
   char * cp = fspec;
   int flags;
   char curdrive = getdisk() + 'A';

   while (*cp) *cp++ = toupper(*cp);
   // Parse the input path & filename
   flags = fnsplit(fspec, drive, dir, file, ext);

   if (!(flags & DRIVE)) {
       drive[0] = curdrive;
   }
   // Drop the colon from the drive spec
   drive[1] = '\0';
   // If a drive is given and it is different from the current drive,
   // temporarily change current drive to that drive
   // while checking the path
   if (drive[0] != curdrive) {
      (void) setdisk(drive[0] - 'A');
   }
   // if no directory given, insert current directory
   // with leading & trailing slashes
   if(!(flags & DIRECTORY)) {
      dir[0] = '\\';  //leading slash
      dir[1] = '\0';
      (void) getcurdir(0, &dir[1]);
      int fin;
      if ((fin = strlen(dir)) > 1) {
         dir[fin] = '\\';  //trailing slash
         dir[fin+1] = '\0';
      }
   }
   // Determine whether the full path as given is a directory
   struct stat the_stat;
   int statres;
   char temp[80];
   strcpy(temp, drive);
   strcat(temp, ":");
   strcat(temp, dir);
   strcat(temp, file);
   strcat(temp, ext);
   statres = stat(temp, &the_stat);

//DEBUG
//   cout << "drive: " << drive << " dir: " << dir;
//   cout << " file: " << file << " ext: " << ext;
//   if (flags & WILDCARDS) cout << " Wild";
//   cout << '\n';
//   cout << "Path: " << temp << '\n';
//   cout << "Stat returns: " << statres;
//   if (statres == 0 && (the_stat.st_mode) & S_IFDIR) {
//      cout << " Directory \n";
//   } else {
//      cout << " Not directory \n";
//   }
// END DEBUG

   // Reset the current drive
   if (drive[0] != curdrive) {
      (void) setdisk(curdrive - 'A');
   }

   // Curiosities:
   // stat returns -1 when . or .. refers to the root, and other times, too?

   if(!(flags & FILENAME)) {
   // If no filename given, put in a "*"
      file[0] = '*';
      file[1] = '\0';
   } else {
   // If the filename happens to be a directory, 
   // and wild cards not used,
   // append it to dir and put a * in file.
      if (statres == 0 
         && (the_stat.st_mode) & S_IFDIR
         && !(flags & WILDCARDS)) {
         strcat(dir, file);
         strcat(dir, "\\");
         file[0] = '*';
         file[1] = '\0';
      }
   }
   // If no extension given, put in a ".*"
   if(!(flags & EXTENSION)) {
      strcpy(ext, ".*");
   }
   // If . or .. is at end of dir, append slash to dir
   if (!(flags & (FILENAME | EXTENSION))
      && dir[strlen(dir) - 1] == '.') {
      strcat(dir, "\\");
   }
}

DOSfile::DOSfile() {
   // Construct empty DOSfile object.
   drive[0] = '\0';
   drive[1] = '\0';
   for (int x = 0; x < MAXDIR; x++) dir[x] = '\0';
   for (x = 0; x < MAXFILE; x++) file[x] = '\0';
   for (x = 0; x < MAXEXT; x++) ext[x] = '\0';   
}

void DOSfile::print() {
   // effects: Prints file name to cout.
   cout << drive << ':' << dir << file << ext;
}