/*
 * dosdisk.h
 *
 * MS-DOS diskette class.
 *
 * John Dudeck   SIM International   25-Aug-92
 */
#ifndef _DOSDISK
#define _DOSDISK

#include "diskette.h"
#include "rtdisk.h"
#include "rtfile.h"
#include "dosfile.h"
#include "ercode.h"

class DOSdisk : public diskette {
   DOSfile destfile;
   
   void copy1RTtodos(RTdisk);
   
public:
   DOSdisk();
   // effects: Constructs a DOSdisk object.
   
   void print_directory();
   // effects: Prints the full directory for the diskette to cout.
   
   void print_directory(char *);
   // effects: Prints the directory for the diskette, constrained
   // by the file description string argument, to cout.

   void setdest(char *);
   // effects: Sets the destination file specification for this diskette.

   ercode copy(RTdisk);
   // effects: Copies the RT11 file(s) from the argument to this diskette.
   // returns: Error code.
   
   // ercode copy(DOSdisk);
   // effects: Copies the DOS file(s) from the argument to this diskette.
   // returns: Error code.
};
#endif
