/*
 * decdates.h
 *
 * John Dudeck   SIM International   25-Aug-92
 *
 * Routines to handle dates in format DD-MMM-YY
 */
#ifndef _DECDATES
#define _DECDATES

// RT-11 date format (as used in directory entries, etc):
// bits 0-4   year since 1972
//      5-9   day of month
//    10-14   month
//       15   reserved

void rtdatetodec(char *, short int);
// First argument is the address of a 10-byte destination buffer
//  which must be provided by the calling program.
// Second argument is RT11 date to be converted which is
//  stored as a string in DD-MMM-YY format at destination.
// Resulting string is always 10 bytes long (9 chars plus null).


void getdecdate(char *);
// Argument is the address of a 10-byte destination buffer
// which must be provided by the calling program.
// Gets current system date and stores it as a string in
// DD-MMM-YY format at destination.
// Resulting string is always 10 bytes long (9 chars plus null).

#endif
