/* absread example */

#include <stdio.h>
#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>
#include <conio.h>
#include <process.h>
#include <dos.h>
#include "rad50.h"
#include "rtdisk.h"

void dumpbuf(char *buf);
void dumpascii(char *buf);
void r50toa(char *dest, long src);

const int BLKSIZ = 512;
const int NUMSECTS = 800;

int main(void)
{
   int sector = 0;
   char buf[BLKSIZ], in_str[80];

   RTdisk a_disk;

   cout << "Insert an RT11 diskette into drive "
        << a_disk.getdestdrive() << ": and press <Enter>\n";
   cin.ignore(80, '\n'); // ignore everything up to \n
   cin.get(); // get the \n delimiter left by ignore

   // display directory info
   a_disk.print_directory();

   cout << "Type first sector number to read and press <Enter>\n";
  

   cin.getline(in_str, 8);
   if (in_str[1]) sector = atoi(&in_str[0]);
   else sector = 0;

   while (sector < NUMSECTS) {
   // drive, number of sectors to read, starting sector, buffer
      if (absread(3, 1, sector, &buf) != 0) {
         perror("Disk problem");
         exit(1);
      }
      cout << "Sector " << dec << setw(1) << sector;
      dumpbuf(buf);
      // dumpascii(buf);

      sector++;
      cout << "Next sector [" << dec << setw(1) << sector << "] ";
      cin.getline(in_str, 8);
      if (in_str[1]) sector = atoi(&in_str[0]);
   }
   return(0);
}

void dumpbuf(char buf[]) {
unsigned char ch_out;
   cout << '\n';
   for (int i=0; i<BLKSIZ; i+=16) {
      // Starting offset in octal
      cout << oct << setw(3) << i << ' ';
      // Hex bytes
      for (int j=0; j<16; j++) {
         cout << hex << setw(2) << setfill('0')
              << (buf[i+j] & 0xff) << ' ' << setfill(' ');
      }
      // ASCII chars
      for (j=0; j<16; j++) {
         ch_out = buf[i+j];
         if (ch_out < ' ' || ch_out > 254) ch_out = '.';
         cout << ch_out;
      }
      cout << "\n    ";
      // RAD50 chars
      for (j=0; j<16; j+=2) {
         char three[4];
         unsigned long int two;

         two = ((buf[i+j+1] << 8) | (buf[i+j] & 0xff)) & 0xffff;

         r50toa(three, two);

         cout << three << "   ";
      }
      cout << '\n';
   }
}

void dumpascii(char buf[]) {
unsigned char ch_out;
   cout << '\n';
   for (int i=0; i<BLKSIZ; i+=64) {
      // ASCII chars
      for (int j=0; j<64; j++) {
         ch_out = buf[i+j];
         if (ch_out < ' ' || ch_out > 254) ch_out = '.';
         cout << ch_out;
      }
      cout << '\n';
   }
}
