/*
 * rtcopy.cpp
 *
 * Utility to copy files from an RT-11 diskette to an MS-DOS file system.
 *
 * John Dudeck   SIM International   25-Aug-92
 */
#include <iostream.h>
#include <stdlib.h>
#include "rtdisk.h"
#include "dosdisk.h"
#include "rtfile.h"

main(int argc, char *argv[]) {
   DOSdisk dest;
   
   if (argc < 2 || argc > 3) {
      cout << "Usage: RTCOPY srcfile [destfile]\n"
           << "   srcfile must be on an RT-11 diskette\n"
           << "   destination must be to an MS-DOS disk\n"
           << "   MS-DOS style wildcards may be specified using '*' and '?'\n";
      exit(1);
   }
   if (argc == 3) dest.setdest(argv[2]);
   // Do the actual file copy:
   RTdisk src;
   src.setsrc(argv[1]);
   ercode berk = dest.copy(src);
   if (berk.is_err()) berk.print();
}
