            <<< EISNER::$2$DIA6:[NOTES$READONLY]MICRONOTE.NOTE;1 >>>
                              -< TOEM MicroNotes >-
================================================================================
Note 8.0                   LSI-11/73 Memory Managment                 No replies
JAWS::KAISER                                        558 lines  25-MAR-1985 09:17
--------------------------------------------------------------------------------
      +---------------+					   +-----------------+
      | d i g i t a l |					   |  uNOTE # 008    |
      +---------------+					   +-----------------+


      +----------------------------------------------------+-----------------+
      | Title: Memory Management and the LSI-11/73	   | Date: 22-Jun-84 |
      +----------------------------------------------------+-----------------+
      | Originator: Dave Smith				   | Page 1 of 10    |
      +----------------------------------------------------+-----------------+


      This  micronote  explains	 memory	 management  as	 it  applies  to   the
      LSI-11/73.   It includes descriptions of what memory management is, what
      it does, and how it works.

      Simply  stated,  memory  management  is  a  method  of  mapping  virtual
      addresses	 to physical addresses.	 The virtual address space is the view
      of memory as seen by a process running.  The physical address  space  is
      the  actual  physical  memory  as	 seen by the entire system.  Since ALL
      memory references must be mapped, this translation is done  in  hardware
      by  using	 a  Memory  Management Unit (MMU).  Various schemes (dependent
      upon the architecture) have been developed to accomplish this, but  most
      memory management systems provide the following services:

		     1) Protection

		     2) Relocation

		     3) Segmentation


      The first two are of great importance in a multiprogramming system since
      memory  management  provides the mechanism for assigning memory areas to
      user programs and for preventing users from accessing  areas  that  have
      been  assigned  to  other	 users.	  This	protects  the operating system
      executive as well as users from accidental or  willful  memory  accesses
      outside  of a user's assigned memory.  Relocation is also important in a
      multiprogramming	environment  since  the	 executive  must  be  able  to
      relocate the user's program to a free area in physical memory.

      The LSI-11/73 Memory Management Unit provides the hardware for  complete
      memory  management  by  providing	 all  of  the  above  services.	 It is
      software compatible with the  larger  UNIBUS  PDP-11s  and  other	 Q-bus
      processors.   Since  the	LSI-11/73  has	the  PDP-11 architecture and a
      16-bit program counter, all  16-bit  addresses  access  a	 64Kb  virtual
      address space.  On the LSI-11/73 this addressing limitation can be eased
      by using separate sets of memory management registers  for  instructions
      (I-space)	 and  for  data	 (D-space).   By  utilizing separate I- and D-
      space, the address space	can  be	 segmented  into  two  64Kb  segments,
      effectively  doubling  the virtual address space.	 The LSI-11/73 and the
      Q-bus allow 4 Mb of memory to be referenced.  The MMU  is	 necessary  to
      provide  the  mapping  from  the	64Kb virtual address space to the 4 Mb
      physical address space.


								Page 2


      When the MMU is activated, a 16-bit virtual  address  is	mapped	to  an
      18-bit  or  22-bit  physical  address.   The MMU uses registers known as
      Active Page Registers (APRs).  An APR consists of two  16-bit  registers
      which are called the Page Address Register (PAR) and the Page Descriptor
      Register (PDR).  PARs are used in the actual address  translation	 while
      PDRs  contain  access  and  other	 information.	Since the LSI-11/73 is
      functionally equivalent to the PDP-11/70, it can operate in one of three
      modes:   Kernel,	Supervisor,  or	 User  and it can use I- and D- space.
      This means that the MMU must provide separate sets of registers for each
      mode  and	 within	 each  mode,  sets  of	registers  for I-space and for
      D-space.	A set of registers consists of eight pairs of PDRs  and	 PARs.
      Thus the LSI-11/73 MMU has a total of three sets of 32 16-bit registers.

      Mapping is always done in pages of 8Kb (4K words) in length or less.  In
      order  to	 map  the  largest possible virtual address space (64 Kb), the
      address space is divided into eight pages of 8Kb each.  One APR is  used
      for  each	 of  the  eight pages, numbered 0 to 7.	 The uppermost page in
      physical memory is called the I/O page and is usually mapped by a Kernel
      Mode APR since it is a privileged area.

				  PHYSICAL
				  ADDRESS
				   SPACE

			   4 Mb +----------+
				| I/O page | <--+
				+----------+	|
				|	   |	|
				+----------+	|
	  USER MODE	+-----> |  page 7  |	|	KERNEL MODE
			|	+----------+	|
	    APRs	|	|	   |	|	   APRs
			|	+----------+	|
			|	      .		|
			|	      .		|
	+----------+	|	+----------+	|	+----------+
	|   PAR7   |----+	|	   |	+-------|   PAR7   |
	+----------+		+----------+		+----------+
	|   PAR6   |		|	   |		|   PAR6   |
	+----------+		+----------+		+----------+
	|   PAR5   |	  +---> |	   |		|   PAR5   |
	+----------+	  |	+----------+		+----------+
	|   PAR4   |----+ |	|	   |	+-------|   PAR4   |
	+----------+	| |	+----------+	|	+----------+
	|   PAR3   |	| |	|	   |	|	|   PAR3   |
	+----------+	| |	+----------+	|	+----------+
	|   PAR2   |	| |	|	   | <--+	|   PAR2   |
	+----------+	| |	+----------+		+----------+
	|   PAR1   |	+-----> |	   |		|   PAR1   |
	+----------+	  |	+----------+		+----------+
	|   PAR0   |------+	|	   | <----------|   PAR0   |
	+----------+	      0 +----------+		+----------+


      The Page Address Register consists solely	 of  the  Page	Address	 Field


								Page 3


      (PAF).  If 22-bit addressing is enabled, then all 16 bits of the PAR are
      used as the PAF.	If only 18-bit addressing is desired then the 12 lower
      order  bits  are the PAF and the 4 higher order bits are unused.	It may
      be thought of as a base register containing  a  base  address  or	 as  a
      relocation register containing a relocation constant.

			PAGE ADDRESS REGISTER	(PAR)
		 15					       0
		+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
		|	PAGE ADDRESS FIELD (PAF)		|
		+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+


      The Page Descriptor Register contains  information  about	 access,  page
      length, and expansion direction:


			PAGE DESCRIPTOR REGISTER (PDR)

		 15 14		      08 07 06 05 04 03 02 01 00
		+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
		|BC| PAGE LENGTH FIELD	| 0| W| 0| 0|ED| ACF | 0|
		+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+


	PDR <15>	BC	(Bypass Cache)

			Set if memory accessing is wished to be
			without utilizing the cache.  Useful with
			dual-ported memories.

	PDR <08:14>	PLF	(Page Length Field)

			Specifies the authorized length of the page
			in 32 word (or 64 byte) groups.

			0	<-->	32 word page
			.
			.
			177 (8) <-->	4096 word page


	PDR <06>	W	(Written Into)

			Useful in determining whether or not a page can
			simply be erased or must be saved to be brought
			back into memory.

			0	<-->	Page has NOT been written into
			1	<-->	Page has been written into


	PDR <03>	ED	(Expansion Direction)

			0	<-->	Expands to higher addresses


								Page 4


					(Normally used)
			1	<-->	Expands to lower addresses
					(Can be used for stack segments)

	PDR <01:02>	ACF	(Access Control Field)

			00	<-->	Nonresident
			01	<-->	Resident - Read Only
			10	<-->	Not Used
			11	<-->	Resident - Read/Write

      The 16-bit virtual address is divided into three fields:


				VIRTUAL ADDRESS (VA)

		15    13 12			6 5	       0
		+-------+------------------------+-------------+
		|  APF	|	   BN		 |    DIB      |
		+-------+------------------------+-------------+
			<--------DISPLACEMENT FIELD (DF)------->


	o APF or Active Page Field
		These three bits determine which of the eight
		APRs are selected.

	o BN or Block Number
		The PAF determines an 8 Kb page in memory.
		The BN is that offset that is added to the base
		of the page determined by the PAF to obtain the
		block within the page to map.

	o DIB or Displacement In the Block
		Tells exactly which one of the 32 words is being
		mapped to.  The low order 6 bits (DIB) are never
		relocated.


	The BN and DIB fields are collectively referred to as the
	Displacement Field (DF).


      If the MMU is not activated  then	 16-bit	 virtual  addresses  are  also
      16-bit physical addresses and linearly map the 64Kb address space.  When
      the MMU is activated the	16-bit	virtual	 address  (VA)	is  no	longer
      interpreted  as a physical address Instead, the physical address (PA) is
      constructed using the VA	and  the  PAF  (Page  Address  Field)  of  the
      selected PAR.

      The translation of virtual addresses to  22-bit  physical	 addresses  is
      accomplished as follows:

	1) A set of registers is selected.  This is determined by
	   the space being referenced (Instructions or Data) and by


								Page 5


	   the mode bits of the Processor Status Word (PSW <15:14>).

	2) The APF field of the virtual address determines which of the
	   eight pairs in the selected set will be used for the mapping.

	3) The PAF of the selected register pair contains the starting
	   address of the currently active page as a block number.

	4) The block number from the virtual address and the block number
	   from the PAF are added together.  The block number from the PAF
	   is shifted left by six bits in order to perform this addition.
	   The result is the actual physical block number (bits <21:06>
	   of the physical address).

	5) The DIB of the virtual address is carried along unchanged as
	   bits <05:00> of the translated address.


			VIRTUAL TO PHYSICAL ADDRESS TRANSLATION

					16-BIT VIRTUAL ADDRESS
			     15						   0
			    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
			    |	APF  |	       BN	  |	 DIB	    |
			    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
				|		|			|
				|		|			|
			   +---------+		|			|
			   | Selects |		|			|
			   |   APR   |		+---------------+	|
			   +---------+				|	|
								|	|
								|	|
			PAGE ADDRESS REGISTER			|	|
	   15						 0	|	|
	  +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+	|	|
	  |						  |	|	|
	  +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+	|	|
				|				|	|
				|	      +-----+		|	|
				+------------>| ADD |<----------+	|
					      +-----+			|
						|			|
				+---------------+			|
				|					|
				|					|
	 21			|		       6   5		|  0
	+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+ +--+--+--+--+--+--+
	|	BLOCK NUMBER IN PHYSICAL MEMORY		| |	DIB	    |
	+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+ +--+--+--+--+--+--+

	<--------------- 22-BIT PHYSICAL ADDRESS (PA) ---------------------->


								Page 6


      There are four memory management registers  that	are  used  for	memory
      fault  recovery  and  abort and status information as well as control of
      the MMU.	They are called MMR0, MMR1, MMR2, and MMR3.

      Memory Management Register 0 (MMR0)  is  the  main  control  and	status
      register.


			MEMORY MANAGEMENT REGISTER 0 (MMR0)

		 15 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00
		+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
		|  |  |	 | 0| 0| 0| 0| 0| 0|	 |  |	     |	|
		+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+



	MMR0 <15>	NONRESIDENT ABORT

			Set if an attempt is made to access a page
			with an ACF of 0 or 2 or if the PSW indicates
			mode 2.


	MMR0 <14>	PAGE LENGTH ABORT

			Set if an attempt is made to access a location
			whose block number is outside the area authorized
			by the PLF of the PDR for that page.


	MMR0 <13>	READ ONLY ABORT

			Set if an attempt is made to write to a page with
			an ACF of 1 (Read Only).


	MMR0 <06:05>	PROCESSOR MODE

			Copy of the PSW <15:14> when abort occurred.


	MMR0 <04>	PAGE SPACE

			1	<-->	D-space
			0	<-->	I-space


	MMR0 <03:01>	PAGE NUMBER

			Page Number of page causing the abort.
			Copy of APF of virtual address.


	MMR0 <00>	ENABLE RELOCATION


								Page 7



			1	<-->	ALL addresses are relocated
					(MMU activated)
			0	<-->	NO addresses are relocated
					(MMU disabled)



      Memory Management Register 1 (MMR1) is  called  the  Instruction	Backup
      Register.	  It records any autoincrement or autodecrement of any general
      purpose register.	 The lower byte is used for source  operands  and  the
      destination   operand   may  be  in  either  byte,  dependent  upon  the
      instruction.


			MEMORY MANAGEMENT REGISTER 1 (MMR1)

		 15 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00
		+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
		|	       |	|	       |	|
		+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+


	MMR1 <15:11>	AMOUNT CHANGED (2's complement)

	MMR1 <10:08>	REGISTER NUMBER

	MMR1 <07:03>	AMOUNT CHANGED (2's complement)

	MMR1 <02:01>	REGISTER NUMBER


      Memory Management Register 2 (MMR2) is known as the Last Virtual Program
      Counter.	 It  is	 loaded	 with  the value of the Program Counter at the
      beginning of each instruction fetch and is  used	in  instruction	 fault
      recovery.


								Page 8


      Memory Management Register 3 (MMR3) is used to select 18-bit  or	22-bit
      address  mapping and is used to enable/disable the data space for any of
      the processor modes.


			MEMORY MANAGEMENT REGISTER 3 (MMR3)

		 15 14 13 12 11 10 09 08 07 06 05 04 03 02 01 00
		+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
		| 0| 0| 0| 0| 0| 0| 0| 0| 0| 0|	 |  |  |	|
		+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+


	MMR3 <05>	UNINTERPRETED

			May be set or cleared but is not interpreted.


	MMR3 <04>	ENABLE 22-BIT MAPPING

			1	<-->	Mapping is to 22-bit space.
			0	<-->	Mapping is to 18-bit space.


	MMR3 <03>	ENABLE CSM (Call Supervisor Mode) INSTRUCTION

			1	<-->	CSM is recognized.
			0	<-->	CSM is not recognized.


	MMR3 <02>	KERNEL DATA SPACE

			1	<-->	Enable data space mapping in
					Kernel Mode
			0	<-->	Disable data space mapping in
					Kernel Mode


	MMR3 <01>	SUPERVISOR DATA SPACE

			1	<-->	Enable data space mapping in
					Supervisor Mode
			0	<-->	Disable data space mapping in
					Supervisor Mode


	MMR3 <00>	USER DATA SPACE

			1	<-->	Enable data space mapping in
					User Mode
			0	<-->	Disable data space mapping in
					User Mode


								Page 9



      Summary:

      The LSI-11/73  Memory  Management	 Unit  provides	 a  powerful,  general
      purpose  tool for memory management.  It can be used to expand memory in
      a simple way and it can be used in a multiprogramming system to  provide
      all the services necessary for an efficient and secure environment.

      The following is a simple MACRO-11 program which illustrates the	method
      of  setting  up the registers and performing some mappings.  It writes a
      known value to an unmapped location and sets up the  MMU	registers  and
      turns  on	 the  unit.   It  then	writes another known value to the same
      virtual address which is now mapped.  Then it turns  the	MMU  off.   At
      this point the two known values are in different memory locations.


		.TITLE	MMU

	;
	;	Program to demonstrate setting up MMU registers
	;	and to illustrate the mapping that takes place
	;

		PSW	=	177776	; Processor Status Word
		MMR0	=	177572	; Memory Management Register 0
		PDR0	=	172300	; Page Descriptor Register 0
		PAR0	=	172340	; Page Address Register 0
		PAR1	=	172342	; Page Address Register 1
		PAR7	=	172356	; Page Address Register 7


	; INSURE THAT MMU IS NOT ACTIVATED

	START:: CLR	@#MMR0		; CLEAR MMR0


	; STORE A KNOWN VALUE (152152) IN UNMAPPED LOCATION 20000

		MOV	#152152,@#20000


	; SET PSW TO KERNEL MODE

		BIC	#140000,@#PSW


	; SET THE PARS SO THAT EACH PAGE MAPS TO ITSELF

		MOV	#PAR0,R5	; SET UP PAR POINTER
		MOV	#10,R4		; SET UP PAR COUNTER
		CLR	R3		; SET UP PAR OFFSET VALUE


	LOOP1:	MOV	R3,(R5)+	; SET EACH RELOCATION CONSTANT TO
					; MAP TO ITSELF


							       Page 10


		ADD	#200,R3		; UPDATE OFFSET
		SOB	R4,LOOP1	; DO ALL OF THEM


	; SET PAR1 TO MAP PAGE 1 TO PAGE 2

		MOV	#400,@#PAR1


	; SET PAR7 TO MAP THE I/O PAGE TO THE TOP OF MEMORY

		MOV	#7600,@#PAR7	; 172356 POINTS TO 760000

	;
	; SET UP THE PDRS
	;
	; 77406 (8) = 0 111 111 100 000 110 (2)
	;
	;	RESIDENT - READ/WRITE
	;	UPWARD EXPANDING
	;	NOT WRITTEN INTO
	;	8KB PAGE SIZE
	;	DON'T BYPASS CACHE
	;

		MOV	#PDR0,R5	; SET UP PDR POINTER
		MOV	#10,R4		; SET UP PDR COUNTER

	LOOP2:	MOV	#77406,(R5)+	; SET EACH PDR
		SOB	R4,LOOP2	; DO THEM ALL


	; ENABLE THE MMU

		INC	@#MMR0		; SET BIT 0 OF MMR0


	; WRITE A VALUE TO LOCATION 20000. THIS SHOULD BE MAPPED.

		MOV	#107010,@#20000 ; WRITE 107010 TO MAPPED 2000


	; DISABLE THE MMU

		DEC	@#MMR0		; CLEAR BIT 0 OF MMR0


	; AT THIS POINT IN THE PROGRAM, EXAMINING PHYSICAL
	; ADDRESS 20000 SHOWS THE VALUE OF 152152 WHICH WAS PLACED THERE
	; ADDRESS 40000 (WHICH 20000 MAPPED TO) HOLDS THE VALUE 107010

		HALT
		.END	START
