/*
 * dosdisk.cpp
 *
 * Implementation module for DOSdisk class.
 *
 * John Dudeck   SIM International   25-Aug-92
 */

#include <string.h>
#include <dir.h>
#include <io.h>
#include <dos.h>
#include <iostream.h>
#include <stdio.h>
#include "dosdisk.h"
#include <stdlib.h>

DOSdisk::DOSdisk() {
   // effects: Constructs a DOSdisk object with default destination.
   unsigned defdisk;
   char filespec[16];
   
   strcpy(filespec, "C:*.*");
   defdisk = getdisk();        // get default drive (0 = 'A', etc.)
   filespec[0] = defdisk + 'A';
   destfile = DOSfile(filespec);
}

void DOSdisk::print_directory() {
   // effects: Prints the full directory for the diskette to cout.
   ercode(UNIMPLEMENTED).print();
}

void DOSdisk::print_directory(char * fspec) {
   // effects: Prints the directory for the diskette, constrained
   // by the file description string argument, to cout.
   ercode(UNIMPLEMENTED).print();
}

void DOSdisk::setdest(char * fspec) {
   // effects: Sets the destination file specification for this disk.
   destfile = DOSfile(fspec);
}

void DOSdisk::copy1RTtodos(RTdisk src) {
   // effects: Copies current RT11 file from the source disk to this disk.

// DEBUG
   src.curfile.print();
// END DEBUG
   
   char * a_buff;
   // open source file on RT11
   ercode filerr = src.RTopen(open_for_read);
   if (filerr.is_err()) {
      cout << "Cannot open RT11 file: "; src.curfile.print();
      filerr.print();
      exit(1);
   }
   // open dest file on DOS
   
   // create the destination filename with path:
   // take the drive and directory of the destination dos filespec.
   // if the dest filename is *, take the src file name.
   // if the dest extension is *, take the src ext.
   char curdest[100];
   
   (void) strcpy(curdest, destfile.drive);
   (void) strcat(curdest, ":");
   (void) strcat(curdest, destfile.dir);
   if (destfile.file[0] == '*') {
      strcat(curdest, src.curfile.name);
   } else {
      strcat(curdest, destfile.file);
   }
   if (destfile.ext[1] == '*') {  // remember there is a '.' in ext[0]
      strcat(curdest, ".");
      strcat(curdest, src.curfile.ext);
   } else {
      strcat(curdest, destfile.ext);
   }

// DEBUG
   cout << " to: " << curdest << '\n';
// END DEBUG

   int destfile = _creat(curdest, FA_ARCH);
   if (destfile < 0) {
      cout << "Could not create destination file.\n";
      exit(1);
   }
   // while not end of file on RT11
   while (!src.RTeof()) {
      // reads RT11 buffer
      filerr = src.RTreads(&a_buff);
      if (filerr.is_err()) {
         cout << "Read error in RT11 file: "; src.curfile.print();
         filerr.print();
         exit(1);
      }
      // write DOS buffer
      if(write(destfile, a_buff, DATBUFSIZ) < 0) {
	 cout << "Write error on destination disk (disk full?).\n";
	 exit(1);
      }

// DEBUG
//      for (int j = 0; j < DATBUFSIZ; j++) {
//	 putchar(a_buff[j]);
//      }
// END DEBUG

   }
   // close RT11 file
   src.RTclose();
   // close DOS file
   (void) close(destfile);
}


ercode DOSdisk::copy(RTdisk src) {
   // effects: Copies the RT11 file(s) from the argument to this disk.
   // returns: Error code.
   // This is the meat of the whole package!

// DEBUG
   cout << "RTCOPY ";
   src.srcfile.print();
   cout << ' ';
   destfile.print();
   cout << '\n';
   cout << "Copying files...\n";
// END DEBUG

   // Step through files matching wildcard specifications.
   // This relies on RTDisk being a friend...
   ercode finderr = src.RTFindFirst();
   if (!finderr.is_err()) {
      do {
	 if (src.status & PERM)
	    copy1RTtodos(src);
      } while (finderr = src.RTFindNext(), !finderr.is_err());
   }
   return ercode(NOERROR);
}

// ercode DOSdisk::copy(DOSdisk src) {
      // effects: Copies the DOS file(s) from the argument to this disk.
      // returns: Error code.
      // return ercode(UNIMPLEMENTED);
// }
