program RT11; {emulate RT11 functions, i.e. get stuff from diskette a:}
              {written by M.Aitchison, UofC Physics; rights reserved}

uses Dos;	{standard Turbo DOS interface}

(*
 useage: RT11     	{command line version; prompted like real RT11}
         RT11 command	{executes the given command, e.g. COPY DZ0:*.* C:\, then exits}
         RT11/?   	{explains how to use RT11 emulator}
*)
{$R+}
const MaxDirEntry = 72;

type ParameterTable = record TimingSpecifications : word;
                             TimeBeforeMotorOff,
                             BytesPerSector, {0=128, 1=256, 2=512, 3=1024}
                             SectorsPerTrack,
                             GapLength,
                             DataLength,
                             FormattedGapLength,
                             FormatFillByte,
                             HeadSettleTime,
                             MotorStartTime : byte;
                             end;

     RT11DirType = record StatusWord : word;
                       CrammedName : array[1..3] of word;
                       FileLength : word;
                       Job,Channel : byte;
                       CreationDate : word;
                       end;

     RT11DirBlock = record TotalSegments,
                       NextDirSegment,
                       HighestSegmentInUse,
                       ExtraBytesPerEntry,
                       DataStartSegment : word;
                       DirectoryEntry : array[1..MaxDirEntry] of RT11DirType;
                       Filler : array[1019..1024] of byte;
                       end;

var buffer      : array[1..512] of char;
    Where       : pointer;
    WhereOffset : word absolute Where;
    DirBuffer   : RT11DirBlock;
    Reply       : string[22];
    Printer     : text;
    FilePointer : ^Text;

const
    DataRate : array[0..3] of string[9]= ('500K','300K','250K','????');
    DiskPort =$3F0;	{normal base port address for diskette controller}
    Drive    : integer = 0; {A: by default}
    UseVirtualDisk : boolean = false;
    DZ0            : string[4] = 'DZ0:';
    EDFlag         = $800;
    DelFlag        = $200;
    All            = 32767;
    DT             : DateTime = (Year  : 1989; Month :  3; Day   :  8);
    DayOfWeek      : word = 2;

    IBMPC = $FF; IBMXT = $FE; PCJr = $FD; IBMAT = $FC; IBMPS2 = $FA;
    x128=0; x256=1; x512=2; x1024=3;  {codes for BPS int Parameter Table}

var
    BIOSdate      : array [1..8] of char absolute $F000:$FFF5;
    BlockSize     : integer;
    buff          : array[0..94,1..512] of char;
    Bstr          : string absolute buff;
    CommandLine   : string;
    Contig        : word; {greatest contiguous spare space}
    CurrentTrack  : array[0..1] of byte absolute $0040:$0094;
    dest          : file;
    DirSector     : word;
    DiskError     : boolean;
    DiskTable     : array[0..7] of ParameterTable absolute $F000:$A5B9;
    ExitRequested : boolean;
    FM            : boolean;
    fn            : string;
    GlobalOptions : string;
    Head          : integer;
    Heads         : integer;
    i,j,k         : integer;
    Interlace     : integer;
    Ivect         : array[0..$FF] of pointer absolute 0:0;
    LowestSector  : byte;
    MachineID     : byte absolute $F000:$FFFE;
    MediaState    : array[0..1] of byte absolute $0040:$0090;
    MotorCount    : byte absolute 0:$440;
    MotorStatus   : byte absolute 0:$43F;
    nnnn          : string;
    OldDisketteBios: pointer absolute 0:$0100;
    Options       : string;
    p             : integer;
    ParamOption,
    Parameter : array[0..10] of string;
    PresentDiskBios: pointer absolute 0:$004C;
    PresentTime   : longint absolute 0:$46C;
    Prompt        : string[20];
    PTpointer     : ^ParameterTable;
    reg           : registers;
    ResultByte    : array[0..6] of byte absolute $0040:$0042;
    RT11DriveParameters : ParameterTable;
    S             : SearchRec;
    SaveDriveP    : pointer;
    SaveExit      : pointer;
    SaveMediaState: byte;
    Sector        : integer;
    Sectors       : integer;
    Source        : string;
    st            : string;
    StartSector   : integer;
    TotalSpace    : word;
    Track         : integer;
    Tracks        : integer;
    UseFirst      : boolean;
    VirtualDisk   : file;

function hex(b : word) : string;
const digit : array[0..15] of char = ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
var   i     : byte;
      st    : string[4];
begin
if b<256 then st:='00' else st:='0000';
for i:=1 to length(st) do st[i]:=digit[(b shr ((length(st)*4)-4*i)) and $0F];
hex:=st;
end;

function ScanForLast(target,source : string) : byte;
var p : byte;
begin
for p:=length(source) downto 1 do
    if target[1]=source[p] then begin ScanForLast:=p; exit; end;
ScanForLast:=0;
end;

procedure SetupBios;
const
    MediaStateForRX50K : byte = $74; {special setting for DD 80-track disk in AT drive}
begin
move(SaveDriveP^,RT11DriveParameters,sizeof(RT11DriveParameters));
with RT11DriveParameters do
     begin
     SectorsPerTrack:=10;
     GapLength:=$14; {sadly, this is ignored by most BIOS routines!}
     FormattedGapLength:=$18; (* ??? *)
     FormatFillByte:=$e5;
     BytesPerSector:=x512;
     end;
SetIntVec($1E,@RT11DriveParameters);
if Drive < 2 then MediaState[Drive]:=MediaStateForRX50K;
with reg do begin
            AX:=0; DX:=Drive; intr($13,reg);
            end;
end;


procedure ReadRT11Sector(LogicalSector : word); {read RT11 logical sector into Buffer}
begin
if UseVirtualDisk then
   begin
   seek(VirtualDisk,LogicalSector);
   BlockRead(VirtualDisk,where^,1);
   exit;
   end;
MediaState[Drive]:=MediaState[Drive] and $DF;
with reg do
     begin
     AX:=$0201;	{read 1 sector into memory}
     DX:=Drive; {DH=0 every time for these disks!}
     CH:=succ(LogicalSector div 10) mod 80; {track number is easy}
     CL:=(LogicalSector*2 + (LogicalSector div 5)) mod 10 +1; {sector number needs fiddling!}
     ES:=seg(Where^); BX:=ofs(Where^);
     intr($13,reg);
     if odd(Flags)
        then begin
             SetupBios;
             AH:=$02; intr($13,reg);
             if odd(Flags) then writeln('Error ',ah,' reading from RT11 diskette sector ',LogicalSector);
             end;
     end;
end;

procedure WriteRT11Sector(LogicalSector : word); {write RT11 logical sector from Buffer}
begin
if UseVirtualDisk then
   begin
   seek(VirtualDisk,LogicalSector);
   BlockWrite(VirtualDisk,where^,1);
   exit;
   end;
MediaState[Drive]:=MediaState[Drive] and $DF;
with reg do
     begin
     AX:=$0301;	{write 1 sector from memory}
     DX:=Drive; {head,DH=0 every time for these disks!}
     CH:=succ(LogicalSector div 10) mod 80; {track number is easy}
     CL:=(LogicalSector*2 + (LogicalSector div 5)) mod 10 +1; {sector number needs fiddling!}
     ES:=seg(Where^); BX:=ofs(Where^);
     intr($13,reg);
     if odd(Flags)
        then begin
             SetupBios;
             AH:=3; intr($13,reg);
             if odd(flags) then writeln('Error ',ah,' writing to RT11 diskette sector ',LogicalSector);
             end;
     end;
end;

const ccram : string[40] = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ,.?0123456789-';

function RT11Uncram(w : word) : string;
var i,j : integer;
begin
ccram[0]:=' ';
RT11Uncram:=ccram[w div 1600]+ccram[(w mod 1600)div 40]+ccram[w mod 40];
end;

procedure RT11Cram(Filename : string; var DestArray );
var PackedName : array[1..3] of word absolute DestArray;
    i,j        : integer;
    st         : string;

function Convert(ch : char) : word;
begin
Convert:=pos(upcase(ch),ccram);
end;

begin
i:=pos('.',Filename);
if i=0 then st:=Filename+'      '
       else if i>7 then st:=copy(Filename,1,6)
       else st:=copy(Filename,1,(i-1))+'      ';
st[0]:=char(6);
if i=0 then st:=st+'   '
       else begin st:=st+copy(Filename,i+1,3)+'   '; st[0]:=chr(9); end;
for i:=1 to 3 do
    PackedName[i]:=(convert(st[i*3-2]) *40 + convert(st[i*3-1]) )*40 +convert(st[i*3]);
end;

function DateString(Day,Month,Year : word) : string;
const MonthString : array[0..12] of string[3] = (
                  '???','Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
begin
if Year>1900 then Year:=Year mod 1900;
if Day>31 then begin day:=day mod 100; month:=0; end
   else if month>12 then Month:=0;
Year:=Year mod 100; (* *)
DateString:=chr(48+day div 10)+chr(48+day mod 10)+'-'+MonthString[Month]+'-'+chr(48+Year div 10)+chr(48+Year mod 10);
end;

function RT11DateString(n : word) : string;
begin
with DT do begin
           Day:=(n shr 5) and 31;
           Month:=(n shr 10);
           if Month>12 then Month:=0;
           Year:=(n and 31)+72;
           RT11DateString:=DateString(Day,Month,Year);
           end;
end;

function ConvertToRT11Date(D,M,Y : word) : word;
var date : word;
begin
ConvertToRT11Date:=((Y mod 1900)-72) and 31 + (D shl 5) + (M shl 10);
end;

function Match(st1,target : string) : boolean;
var i : integer;
begin
Match:=true;
if target='' then exit  (* *)
   else if st1=target then exit
   else if target='*' then exit
   else if target='*.*' then exit;

for i:=length(st1) downto 1 do if st1[i]=' 'then delete(st1,i,1);
for i:=length(target) downto 1 do if target[i]=' 'then delete(target,i,1);

for i:=1 to length(target) do
    if target[i]<>st1[i]
       then if target[i]<>'*' then begin
                                   if target[i]='?' then match:=Match(copy(st1,i+1,99),copy(target,i+1,99))
                                                    else if st1[i]=' ' then Match:=Match(copy(st1,i+1,99),copy(target,i,99))
                                                                       else Match:=false;
                                   exit;
                                   end
                              else begin
                                   target:=copy(target,i+1,99);
                                   if target='' then exit;
                                   for i:=i to length(st1) do
                                       if st1[i]=target[1] then if Match(copy(st1,i,99),target) then exit;
                                   Match:=false;
                                   exit;
                                   end;
Match:=length(target)=length(st1);
end;

procedure MsDosListFiles(source : string);
var
        S : SearchRec;
        p : byte;
       dt : DateTime;
   MyDir,
     st   : string;
begin
if source[length(source)] in ['\',':'] then source:=source+'*.*'
   else if pos('.',source)=0 then source:=source+'.*';
p:=ScanForLast('\',source);
if source[2]=':' then GetDir(ord(source[1]) and 15,MyDir)
                 else GetDir(0,MyDir);
if mydir[length(MyDir)] in [':','\'] then {good} else mydir:=mydir+'\';
if p=1 then MyDir:=copy(MyDir,1,2)+copy(source,1,p)
       else if p=0 then {no change}
       else if mydir[2]=':' then MyDir:=copy(source,1,p)
                            else MyDir:=MyDir+copy(Source,1,p);
writeln(FilePointer^,' Listing of MSDOS directory: ',source);
FindFirst(source,anyfile,s);
while DosError=0 do with S do
      begin
      unpacktime(time,dt);
      str(Size,st);
      if boolean(attr and Directory) then st:='<DIR>'
         else if boolean(attr and ReadOnly) then st:=st+' P '
         else st:=st+'   ';
      with DT do writeln(FilePointer^,MyDir+Name,st:28-length(name),DateString(Day,Month,Year));
      FindNext(S);
      end;
writeln(FilePointer^,DiskFree(ord(MyDir[1]) and 15) div 512 :11,' Sectors remaining in ',MyDir[1],':');
end;

procedure RT11ListFiles;
var attr, st : string;
      found  : boolean;
begin
DirSector:=6;
Contig:=0; TotalSpace:=0;
Found:=false;
repeat
 FillChar(DirBuffer,sizeof(DirBuffer),0);
 Where:=@DirBuffer;
 ReadRT11Sector(DirSector);
 if DirBuffer.DataStartSegment=0 then ReadRt11Sector(DirSector); {retry once}
 inc(WhereOffset,512);
 ReadRT11Sector(DirSector+1);
 StartSector:=DirBuffer.DataStartSegment;
 if StartSector=0 then begin
                       writeln('?RT11-F-Invalid start sector (not a valid RT11 disk)');
                       if DiskSize(Drive)>0 then
                         writeln(' (I think this is an MSDOS diskette!)');
                       exit;
                       end;  (* !! *)
 Where:=@Buffer;
 with DirBuffer do
      for i:=1 to MaxDirEntry do with DirectoryEntry[i] do
             begin
             st:=RT11Uncram(CrammedName[1])+RT11Uncram(CrammedName[2])
                                      +'.'+RT11Uncram(CrammedName[3]);
             if StatusWord=EDFlag then
                begin
                if pos('/FU',Options)>0 then writeln(FilePointer^,st,' <End of Dir @',StartSector,'> ',FileLength);
                if not found then ;
                writeln(FilePointer^,FileLength+TotalSpace:11,' Sectors remaining on ',DZ0,
                                     ' disk',' (',Contig,' contig.)');
                exit;
                end;
             if StatusWord=DelFlag
                then begin
                     inc(TotalSpace,FileLength);
                     if FileLength>Contig then Contig:=FileLength;
                     if pos('/F',Options)>0 then writeln(FilePointer^,st,' <EMPTY> ',FileLength:5);
                     end
                else begin
                     if Match(st,Parameter[1]) then
                            begin
                            if StatusWord>$2000 then attr:='P ' else attr:='  ';
                            Found:=true;
                            write(FilePointer^,st,FileLength:6,attr,' ',RT11DateString(CreationDate),StartSector:4,' ');
                            if StartSector<800 then ReadRT11Sector(StartSector)
                                               else begin
                                                    writeln(FilePointer^,'Something DREADFULLY wrong here!');
                                                    exit;
                                                    end;
                            for j:=1 to 35 do if Buffer[j] in [' '..'~']
                                     then write(FilePointer^,Buffer[j])
                                     else write(FilePointer^,'.');
                            writeln(FilePointer^);
                            end;
                     end;
             inc(StartSector,FileLength);
             end;
 DirSector:=DirBuffer.NextDirSegment+6;
 until (DirSector<=6) ;
writeln(FilePointer^,'?RT11-W-Directory error - no end marker.');
end;

procedure RT11Test;
var attr, st : string;
    ErrorTotal : word;

    procedure TestSector(n : integer; descr : string);
    begin
    where:=@Buffer;
    ReadRT11Sector(n);
    write(^M,n:5,' ');
    if mem[0:$441]=0 then exit
                     else writeln(FilePointer^,' Sector error; track=',n div 10,' error=',mem[0:$441],' in ',descr);
    inc(ErrorTotal);
    end;

begin
ErrorTotal:=0;
where:=@Buffer;
for i:=0 to 5 do
    TestSector(i,'<Boot Sector>');
for i:=6 to 13 do
    TestSector(i,'<Dir Sector>');
DirSector:=6;
repeat
 FillChar(DirBuffer,sizeof(DirBuffer),0);
 Where:=@DirBuffer;
 ReadRT11Sector(DirSector);
 if DirBuffer.DataStartSegment=0 then begin ReadRt11Sector(DirSector); end; {retry once}
 inc(WhereOffset,512);
 ReadRT11Sector(DirSector+1);
 StartSector:=DirBuffer.DataStartSegment;
 if StartSector=0 then begin writeln(FilePointer^,' Start sector=',StartSector); end; (* !! *)
 with DirBuffer do
      for i:=1 to MaxDirEntry do with DirectoryEntry[i] do
                begin
                st:=RT11Uncram(CrammedName[1])+RT11Uncram(CrammedName[2])+'.'+RT11Uncram(CrammedName[3]);
                if StatusWord=EDFlag then
                   begin
                   writeln(FilePointer^,' * Test completed, ',ErrorTotal:6,' Errors *');
                   exit;
                   end;
                for j:=StartSector to StartSector+FileLength-1 do
                        if StatusWord=DelFlag then TestSector(j,'<Deleted file>')
                                              else TestSector(j,st);
                inc(StartSector,FileLength);
                end;
 DirSector:=DirBuffer.NextDirSegment+6;
 until (DirSector<=6) ;
end;

procedure RT11Delete(FileToDelete : string);
var attr, st : string;
       found : boolean;
begin
DirSector:=6;
Found:=false;
repeat
 FillChar(DirBuffer,sizeof(DirBuffer),0);
 Where:=@DirBuffer;
 ReadRT11Sector(DirSector);
 if DirBuffer.DataStartSegment=0 then ReadRt11Sector(DirSector); {retry once}
 inc(WhereOffset,512);
 ReadRT11Sector(DirSector+1);
 StartSector:=DirBuffer.DataStartSegment;
 if StartSector=0 then halt(2);  (* !! *)
 with DirBuffer do
      for i:=1 to MaxDirEntry do with DirectoryEntry[i] do
                begin
                if StatusWord=EDFlag then begin
                                        if not found then writeln(FilePointer^,'?KMON-W-File not found DZ0:'+FileToDelete);
                                        exit;
                                        end;
                if StatusWord<>DelFlag then begin
                                         st:=RT11Uncram(CrammedName[1])+RT11Uncram(CrammedName[2])
                                              +'.'+RT11Uncram(CrammedName[3]);
                                         if Match(st,Parameter[1]) then
                                             begin
                                             Found:=true;
                                             write(FilePointer^,st);
                                             if (StatusWord>=$2000) and (pos('/PROT',GlobalOptions+ParamOption[0])=0)
                                                then begin
                                                     writeln(FilePointer^,'?KMON-F-File protection error');
                                                     end;
                                             StatusWord:=DelFlag;  {flag it as deleted}
                                             where:=@DirBuffer;
                                             if i<30 then WriteRT11Sector(DirSector);
                                             inc(WhereOffset,512);
                                             if i>20 then WriteRT11Sector(DirSector+1);
                                             writeln(FilePointer^,' DELETED');
                                             end;
                                         end;
                inc(StartSector,FileLength);
                end;
 DirSector:=DirBuffer.NextDirSegment+6;
 until (DirSector<=6) ;
end;

procedure RT11UnDelete(FileToUnDelete : string);
var attr, st : string;
       found : boolean;
begin
DirSector:=6;
Found:=false;
repeat
 FillChar(DirBuffer,sizeof(DirBuffer),0);
 Where:=@DirBuffer;
 ReadRT11Sector(DirSector);
 if DirBuffer.DataStartSegment=0 then ReadRt11Sector(DirSector); {retry once}
 inc(WhereOffset,512);
 ReadRT11Sector(DirSector+1);
 StartSector:=DirBuffer.DataStartSegment;
 if StartSector=0 then halt(2);  (* !! *)
 with DirBuffer do
      for i:=1 to MaxDirEntry do with DirectoryEntry[i] do
                begin
                if StatusWord=EDFlag then begin
                                        if not found then writeln(FilePointer^,'?KMON-W-File not found DZ0:'+FileToUnDelete);
                                        exit;
                                        end;
                if StatusWord=DelFlag then begin
                                         st:=RT11Uncram(CrammedName[1])+RT11Uncram(CrammedName[2])
                                              +'.'+RT11Uncram(CrammedName[3]);
                                         if FileToUndelete=''
                                            then begin
                                                 write(FilePointer^,' deleted file: ',st,' UNDELETE it? [Y]');
                                                 reply:='YES';
                                                 read(reply);
                                                 if reply[1] in ['Y','y','U','u'] then Parameter[1]:=st
                                                                 else Parameter[1]:=#255;
                                                 end;
                                         if Match(st,Parameter[1]) then
                                             begin
                                             Found:=true;
                                             write(FilePointer^,st);
                                             if StatusWord>=$2000 then begin
                                                                       writeln(FilePointer^,'?KMON-F-File protection error');
                                                                       exit;
                                                                       end;
                                             StatusWord:=$400;  {change "deleted" flag to normal}
                                             where:=@DirBuffer;
                                             if i<30 then WriteRT11Sector(DirSector);
                                             inc(WhereOffset,512);
                                             if i>20 then WriteRT11Sector(DirSector+1);
                                             writeln(FilePointer^,' UNDELETED');
                                             end;
                                         end;
                inc(StartSector,FileLength);
                end;
 DirSector:=DirBuffer.NextDirSegment+6;
 until (DirSector<=6) ;
end;

procedure RT11Rename(Oldname,NewName : string);
var attr, st : string;
       found : boolean;
begin
DirSector:=6;
Found:=false;
repeat
 FillChar(DirBuffer,sizeof(DirBuffer),0);
 Where:=@DirBuffer;
 ReadRT11Sector(DirSector);
 if DirBuffer.DataStartSegment=0 then ReadRt11Sector(DirSector); {retry once}
 inc(WhereOffset,512);
 ReadRT11Sector(DirSector+1);
 StartSector:=DirBuffer.DataStartSegment;
 if StartSector=0 then halt(2);  (* !! *)
 with DirBuffer do
      for i:=1 to MaxDirEntry do with DirectoryEntry[i] do
                begin
                if StatusWord=EDFlag then begin
                                        if not found then writeln('?KMON-W-File not found DZ0:'+OldName);
                                        exit;
                                        end;
                if StatusWord<>DelFlag then begin
                                         st:=RT11Uncram(CrammedName[1])+RT11Uncram(CrammedName[2])
                                              +'.'+RT11Uncram(CrammedName[3]);
                                         if Match(st,OldName) then
                                             begin
                                             Found:=true;
                                             write(FilePointer^,st);
                                             if copy(OldName,1,2)='*.' then st:=copy(st,1,pos('.',st))+copy(NewName,3,99)
                                                                       else st:=NewName;
                                             RT11cram(st,CrammedName);  {flag it as deleted}
                                             where:=@DirBuffer;
                                             if i<30 then WriteRT11Sector(DirSector);
                                             inc(WhereOffset,512);
                                             if i>20 then WriteRT11Sector(DirSector+1);
                                             writeln(FilePointer^,' RENAMED');
                                             end;
                                         end;
                inc(StartSector,FileLength);
                end;
 DirSector:=DirBuffer.NextDirSegment+6;
 until (DirSector<=6) ;
end;

function RT11Create(NewName : string; Sectors : integer) : word; {create a file, and return starting sector}
var attr, st : string;
       found : boolean;
begin
DirSector:=6;
Contig:=0; TotalSpace:=0;
Found:=false;
UseFirst:=Sectors<0; Sectors:=abs(Sectors);
RT11Create:=0;
repeat
 FillChar(DirBuffer,sizeof(DirBuffer),0);
 Where:=@DirBuffer;
 ReadRT11Sector(DirSector);
 if DirBuffer.DataStartSegment=0 then ReadRt11Sector(DirSector); {retry once}
 inc(WhereOffset,512);
 ReadRT11Sector(DirSector+1);
 StartSector:=DirBuffer.DataStartSegment;
 if StartSector=0 then halt(2);  (* !! *)
 with DirBuffer do
      for i:=1 to MaxDirEntry do with DirectoryEntry[i] do
          begin
          if StatusWord=EDFlag
             then begin {got to end}
                  if Sectors=all then Sectors:=Contig;
                  if Sectors>Contig then begin
                                         writeln('?KMON-F-File exceeds space allowed');
                                         RT11Create:=0;
                                         exit;
                                         end;
                  RT11Create:=RT11Create(NewName,-sectors); {go through dir again, use first are >=sectors}
                  exit;
                  end;
          if StatusWord<>DelFlag then begin {not deleted, just check for existing filename clash}
                                   st:=RT11Uncram(CrammedName[1])+RT11Uncram(CrammedName[2])
                                              +'.'+RT11Uncram(CrammedName[3]);
                                   if Match(st,NewName) then
                                             begin
                                             if pos('/N',Options)>0 then begin
                                                                         writeln('?RT11-F-File already exists');
                                                                         exit;
                                                                         end;
                                             write(FilePointer^,' (REPLACING) ');
                                             StatusWord:=DelFlag;
                                             end;
                                         end;
            if StatusWord=DelFlag
               then begin {deleted, can we use this area?}
                    if (i<MaxDirEntry) and (FileLength<>Sectors)
                       then if (DirectoryEntry[i+1].StatusWord=DelFlag)
                               then begin {amalgamate two empty spaces}
                                    inc(FileLength,DirectoryEntry[i+1].FileLength);
                                    DirectoryEntry[i+1].FileLength:=0;
                                    end;
                    if FileLength>Contig then Contig:=FileLength;
                    if (FileLength=Sectors) or (UseFirst and (FileLength>Sectors))
                        then begin
                             RT11Cram(NewName,CrammedName);
                             with DT do CreationDate:=ConvertToRT11Date(Day,Month,Year);
                             StatusWord:=$400;
                             if FileLength>Sectors  {need to use just part of area, so...}
                                then if (i>1) and (DirectoryEntry[i-1].StatusWord=DelFlag)
                                     then begin
                                          inc(FileLength,DirectoryEntry[i-1].FileLength);
                                          j:=FileLength-Sectors;
                                          FileLength:=Sectors;
                                          move(DirectoryEntry[i],DirectoryEntry[i-1],sizeof(DirectoryEntry[1]));
                                          FileLength:=j;
                                          StatusWord:=DelFlag;
                                          RT11Cram(' EMPTY.FIL',CrammedName);
                                          dec(i);
                                          end
                                     else if (i<MaxDirEntry) and (DirectoryEntry[i+1].StatusWord=DelFlag)
                                             then begin
                                                  inc(DirectoryEntry[i+1].FileLength,FileLength-Sectors);
                                                  FileLength:=Sectors;
                                                  end
                                             else begin {push directory entries down 1}
                                                  for j:=MaxDirEntry-1 downto i do
                                                      move(DirectoryEntry[j],DirectoryEntry[j+1],sizeof(DirectoryEntry[1]));
                                                  DirectoryEntry[i].Filelength:=Sectors;
                                                  dec(DirectoryEntry[i+1].Filelength,Sectors);
                                                  DirectoryEntry[i+1].StatusWord:=DelFlag;
                                                  RT11Cram(' EMPTY.FIL',DirectoryEntry[i+1].CrammedName);
                                                  where:=@DirBuffer;
                                                  inc(WhereOffset,512);
                                                  WriteRT11Sector(DirSector+1);
                                                  end;
                             where:=@DirBuffer;
                             if i<30 then WriteRT11Sector(DirSector);
                             inc(WhereOffset,512);
                             if i>20 then WriteRT11Sector(DirSector+1);
                             RT11Create:=StartSector;
                             exit;
                             end;
                    end;
          inc(StartSector,FileLength);
          end;
 DirSector:=DirBuffer.NextDirSegment+6;
 until (DirSector<=6) ;
end;

procedure CopyFiles(destination : string);
var i,j : integer;
   attr : word;
  fname,
 source : string;
   dest : text;
  found : boolean;
   Time : longint;
    DestFileRec : FileRec absolute Dest;

procedure CopyThisRT11File(StartSector,Size : integer);
var
        st   : string;
  Hundredths : word;
        i,j  : integer;
begin
i:=pos('*',destination);
if i=0 then if destination[length(destination)] in ['\',':',#0] then st:=destination+fname
                                                                else st:=destination
       else if fname[1]='*'
            then st:=copy(destination,1,i-1)+copy(fname,pos(copy(fname,2,99),fname),99)+copy(destination,i+1,99)
            else st:=copy(destination,1,i-1)+copy(fname,1,pos('*',fname)-1 and 127)+copy(destination,i+1,99);
assign(dest,st);
write(FilePointer^,' -> ',st);
if st='CON' then writeln
            else (* *);
{$I-} rewrite(dest); {$I+}
if IORESULT<>0 then begin write(' ERROR openning file!'); exit; end;
where:=@Buffer;
for i:=StartSector to StartSector+pred(Size) do
    begin
    ReadRT11Sector(i);
    if pos('/AS',ParamOption[0])>0
       then for j:=1 to 512 do
                begin
                if Buffer[j]>#0 then write(dest,Buffer[j]);
                case Buffer[j] of
                     ^Z : exit;
                     ^M : if j<512 then if Buffer[j+1]<>^J then write(dest,^J);
                     end;
                end
       else with reg do
                begin
                AX:=$4000;
                BX:=DestFileRec.Handle;
                CX:=512; {bytes per sector}
                DS:=seg(Buffer); DX:=ofs(Buffer);
                MsDos(reg); {write 512 bytes to file/device}
                end;
    end;
if st<>'CON' then
   begin
   packtime(DT,time);
   SetFTime(dest,time);
   write(FilePointer^,' COPIED.');
   end;
close(dest);
end;

begin  {procedure CopyFiles}
DirSector:=6;
source:=Parameter[1];
if destination='' then if Parameter[2]='TO' then destination:=Parameter[3] else destination:=Parameter[2];
found:=false;

repeat
 FillChar(DirBuffer,sizeof(DirBuffer),0);
 Where:=@DirBuffer;
 ReadRT11Sector(DirSector);
 if DirBuffer.DataStartSegment=0 then ReadRt11Sector(DirSector); {retry once}
 inc(WhereOffset,512);
 ReadRT11Sector(DirSector+1);
 StartSector:=DirBuffer.DataStartSegment;
 if StartSector=0 then begin writeln(' ** ERROR: Invalid directory!'); exit; end;
 Where:=@Buffer;
 with DirBuffer do
      for i:=1 to MaxDirEntry do with DirectoryEntry[i] do
           begin
           if StatusWord=EDFlag
              then begin
                   if not found then writeln('?KMON-W-File not found DZ0:'+Source);
                   exit;
                   end;
           if StatusWord<>DelFlag
              then begin
                   st:=RT11Uncram(CrammedName[1])+RT11Uncram(CrammedName[2])
                                         +'.'+RT11Uncram(CrammedName[3]);
                   fname:=st;
                   if Match(st,source)
                      then begin
                           if StatusWord>$2000 then attr:=0 else attr:=0;
                           found:=true;
                           write(FilePointer^,st,FileLength:6,attr,' ',RT11DateString(CreationDate),StartSector:4,' ');
                           CopyThisRT11File(StartSector,FileLength);
                           writeln(FilePointer^);
                           end;
                   end;
           inc(StartSector,FileLength);
           end;
 DirSector:=DirBuffer.NextDirSegment+6;
 until (DirSector<=6) ;

end;

procedure DumpFile(radix : byte);
var i,j : integer;
   attr : word;
  fname,
 source : string;
  found : boolean;
   Time : longint;

function Convert(w : word) : string;
var st, st2 : string[16];
begin
case radix of
     0 : begin str(w and $FF:3,st); str(w shr 8:3,st2); st:=st+st2+' '; end;
     8 : st:=chr(48+w shr 15)+chr(48+(w shr 12) and 7)+chr(48+(w shr 9) and 7)+
            +chr(48+(w shr 6) and 7)+chr(48+(w shr 3)and 7)+chr(48+(w) and 7)+' ';
    10 : str(w:6,st);
    16 : st:=hex(w)+' ';
    40 : st:=RT11Uncram(w)+' ';
    end {of case};
Convert:=st;
end;

procedure CopyThisRT11File(StartSector,Size : integer);
var
        st   : string;
  Hundredths : word;
        i,j  : integer;
  WordBuffer : array[0..255] of word absolute Buffer;
begin
where:=@Buffer;
for i:=StartSector to StartSector+pred(Size) do
    begin
    ReadRT11Sector(i);
    writeln(FilePointer^,^M^J' Block ',i-StartSector,': ');
    for j:=0 to 31 do
        begin
        st:='';
        for k:=(j *8)  to (j * 8) +7 do
            st:=st+convert(WordBuffer[k]);
        st:=st+' ';
        for k:=j*16+1 to j*16+16 do
            if Buffer[k]<' ' then st:=st+'?'
               else if Buffer[k]<#127 then st:=st+char(Buffer[k])
               else st:=st+'.';
        writeln(FilePointer^,st);
        end;
    end;
end;

begin  {procedure DumpFile}
DirSector:=6;
source:=Parameter[1];
found:=false;

repeat
 FillChar(DirBuffer,sizeof(DirBuffer),0);
 Where:=@DirBuffer;
 ReadRT11Sector(DirSector);
 if DirBuffer.DataStartSegment=0 then ReadRt11Sector(DirSector); {retry once}
 inc(WhereOffset,512);
 ReadRT11Sector(DirSector+1);
 StartSector:=DirBuffer.DataStartSegment;
 if StartSector=0 then begin writeln(' ** ERROR: Invalid directory!'); exit; end;
 Where:=@Buffer;
 with DirBuffer do
      for i:=1 to MaxDirEntry do with DirectoryEntry[i] do
           begin
           if StatusWord=EDFlag
              then begin
                   if not found then writeln('?KMON-W-File not found DZ0:'+Source);
                   exit;
                   end;
           if StatusWord<>DelFlag
              then begin
                   st:=RT11Uncram(CrammedName[1])+RT11Uncram(CrammedName[2])
                                         +'.'+RT11Uncram(CrammedName[3]);
                   fname:=st;
                   if Match(st,source)
                      then begin
                           if StatusWord>$2000 then attr:=0 else attr:=0;
                           found:=true;
                           write(FilePointer^,st,FileLength:6,attr,' ',RT11DateString(CreationDate),StartSector:4,' ');
                           CopyThisRT11File(StartSector,FileLength);
                           writeln(FilePointer^);
                           end;
                   end;
           inc(StartSector,FileLength);
           end;
 DirSector:=DirBuffer.NextDirSegment+6;
 until (DirSector<=6) ;

end;

procedure CopyWholeDisk;
var dest : file;
    st   : string;
    i    : integer;
begin
st:=Parameter[2];
if st='' then begin
              write('what DOS file would you like to give the diskette image? ');
              readln(st);
              end;
assign(dest,st);
{$I-} reset(dest); {$I+}
if IORESULT=0 then begin
                   writeln('File ',st,' already exits! overwrite it (Y/N)?');
                   readln(st);
                   close(dest);
                   if st[1] in ['Y','y'] then {okay} else exit;
                   end;
{$I-} rewrite(dest,512); {$I+}
if IORESULT<>0 then begin write('ERROR openning file!'); exit; end;
where:=@Buffer;
for i:=0 to 799 do
    begin
    ReadRT11Sector(i);
    blockwrite(dest,where^,1);
    end;
close(dest);
end;

procedure CopyDosToRt11(destination : string);
var
   MyDir,
   source : string;
     temp : file;

begin
source:=Parameter[1];
if source[length(source)] in ['\',':'] then source:=source+'*.*'
   else if pos('.',source)=0 then source:=source+'.*';
p:=ScanForLast('\',source);
if source[2]=':' then GetDir(ord(source[1]) and 15,MyDir)
                 else GetDir(0,MyDir);
if mydir[length(MyDir)] in [':','\'] then {good} else mydir:=mydir+'\';
if p=1 then MyDir:=copy(MyDir,1,2)+copy(source,1,p)
       else if p=0 then {no change}
       else if mydir[2]=':' then MyDir:=copy(source,1,p)
                            else MyDir:=MyDir+copy(Source,1,p);

FindFirst(source,anyfile,s);
while DosError=0 do
      begin
      if (destination='') or (destination='*') or (destination='*.*') or (destination='*.')
         then st:=S.Name
         else begin
              p:=pos('*',destination);
              if p=0 then st:=destination
                     else if destination[p+1]='.' then st:=copy(S.Name,1,pos('.',S.Name))+copy(Destination,p+2,99)
                                                  else st:=copy(destination,1,p-1)+copy(S.Name,pos('*',S.Name)+1,99);
              end;
      write(FilePointer^,MyDir+S.Name);
      assign(temp,MyDir+S.Name);
      unpacktime(S.time,dt);
      Sectors:=(S.Size+511) div 512;
	{$I-} reset(temp,512); {$I+}
      i:=IORESULT;
      if i<>0 then begin j:=1; writeln(' ERROR ',i,' openning MSDOS file'); end
              else j:=RT11Create(st,Sectors);
      if j<6 then begin
                  if j<>1 then writeln(' ERROR creating file on ',DZ0);
                  end
             else begin
                  where:=@Buffer;
                  for Sector:=j to j+(pred(S.Size) div 512) do
                           begin
                           blockread(temp,where^,1,k);
                           if k=0 then if Sector=j+pred(S.Size) div 512
                                          then begin
                                               p:=pred(S.Size) mod 512;
                                               if pos('/AS',Options)>0
                                                  then if Buffer[p]<>^Z then Buffer[p+1]:=^Z;
                                               end
                                          else writeln('Error ',IORESULT,' reading disk');
                           WriteRt11Sector(Sector);
                           end;
                   writeln(FilePointer^,' COPIED to ',DZ0);
                   end;
	{$I-}close(temp);{$I+}
      if IORESULT<>0 then {ignore};

      FindNext(S);
      end;
end;

procedure RT11FormatDisk;
const Fmt : array[1..10] of record  C,H,R,N : byte end = (
            (C:0; H:0; R:1; N:2),
            (C:0; H:0; R:2; N:2),
            (C:0; H:0; R:3; N:2),
            (C:0; H:0; R:4; N:2),
            (C:0; H:0; R:5; N:2),
            (C:0; H:0; R:6; N:2),
            (C:0; H:0; R:7; N:2),
            (C:0; H:0; R:8; N:2),
            (C:0; H:0; R:9; N:2),
            (C:0; H:0; R:10;N:2)
            );
var Today : string[2];
begin
writeln('** NOTE: This will wipe any previous disk contents **');
if not (UseVirtualDisk or boolean(pos('/S',Options))) then with reg do
     begin
     writeln('   Insert double-density diskette to be formatted into drive ',chr(65+Drive),': ');
     write('   >> PRESS ENTER TO CONTINUE (or Q to Quit) <<');
     readln(reply);
     if reply[1] in ['Q','q','N','n',#27,^C] then begin writeln('** FORMAT CANCELLED **'); exit; end;
     AX:=$1702; DX:=Drive;
     intr($13,reg);
     for track:=0 to 79 do
         begin
         for sector:=1 to 10 do Fmt[Sector].C:=Track;
         ES:=seg(Fmt); BX:=ofs(Fmt);
         MediaState[Drive]:=MediaState[Drive] and $DF;
         write('Track ',Track:3);
         CH:=Track;
         AX:=$050A;
         intr($13,reg);
         if odd(Flags) then writeln(' Format error ',ah) else write(^M);
         end;
     writeln(FilePOinter^);
     end
   else begin
        write('   >> PRESS ENTER TO CONTINUE (or Q to Quit) <<');
        readln(reply);
        if reply[1] in ['Q','q','N','n',#27,^C] then begin writeln('** FORMAT CANCELLED **'); exit; end;
        end;
where:=@Buffer;
FillChar(Buffer,512,0);
st:=#160#0#5#0#4#1#0#0#0#0#16#67#16#156#0#1#55#8#36#0#13#0#0#0#0#10'?BOOT-U-No boot on disk!!'#13#10#10#128#0
    +chr($DF)+chr($8B)+chr($74)+chr($FF)+chr($FD)+chr($80)+chr($1F)+chr($94)+chr($76)+chr($FF)+chr($FA)+#128#255#1;  (* *)
move(st[1],Buffer,70);
WriteRT11Sector(0);
FillChar(Buffer,512,$E5);
WriteRT11Sector(2);
WriteRT11Sector(4);
Buffer[1]:=#0; Buffer[2]:=#0;
st:=#4#0#0#0#1#0#0#0#14#0#0#4#191#115#192#193#179#12#122#0; (* more? *)
move(st[1],Buffer[$85],length(st));
Buffer[$1C1]:=#0; Buffer[$1C2]:=#0; Buffer[$1C3]:=#0; Buffer[$1C4]:=#0;
st:=#1#0#6#0#83#142'FORMATTED BY PC-RT11    DECRT11A    ';
move(st[1],Buffer[$1D3],length(st));
WriteRT11Sector(1);
with DT do GetDate(Year,Month,Day,DayOfWeek);
where:=@DirBuffer;
FillChar(DirBuffer,512,$E5);
with DirBuffer do
     begin
     TotalSegments:=4;
     NextDirSegment:=0;
     HighestSegmentInUse:=1;
     ExtraBytesPerEntry:=0;
     DataStartSegment:=6+2*TotalSegments;
     with DirectoryEntry[1] do
          begin
          StatusWord:=DelFlag;
          CrammedName[1]:=$516B; CrammedName[2]:=$4E0C; CrammedName[3]:=$4E0C;
          with DT do CreationDate:=ConvertToRT11Date(Day,Month,Year);
          FileLength:=800-DataStartSegment; (* ? *)
          end;
     move(DirectoryEntry[1],DirectoryEntry[2],sizeof(RT11DirType));
     with DirectoryEntry[2] do
          begin
          StatusWord:=EDFlag;
          CrammedName[1]:=$00D5; CrammedName[2]:=$6739;CrammedName[3]:=$26F4;
          fileLength:=$00;
          end;
     end;
WriteRT11Sector(6);
writeln(' FINISHED!');
end;

procedure CopyWholeImageToDisk;
var source : file;
  reply,
    st   : string;
  ErrorCount,
    i    : integer;
begin
writeln(' ** THIS COMMAND WILL DESTROY ANY DATA ON THE DISKETTE IN DRIVE ',Chr(65+Drive),':');
writeln(' Press Ctrl-C to exit now safely if this isn''t what you want to do!');
st:=Parameter[1];
if st='' then begin
              st:=^C;
              write('what DOS file contains the diskette image? ');
              readln(st);
              if st[1] in [^C,#27] then exit;
              end
         else begin
              st:=' ';
              write('Press the ENTER key to continue..');
              readln(reply);
              if reply[1] in [^C,#27,'N','n','Q','q'] then exit;
              end;
assign(source,st);
{$I-} reset(source,512); {$I+}
if IORESULT>0 then begin
                   writeln('File ',st,' doesn''t exit! ');
                   exit;
                   end;
where:=@Buffer;
ErrorCount:=0;
for i:=0 to 799 do
    begin
    write(^M,i:4);
    blockread(source,where^,1);
    WriteRT11Sector(i);
    if (mem[0:$441]<>0) and (mem[0:$441]<>9) then
       begin
       writeln(' ERROR ',mem[0:$441]);
       if i=0 then begin
                   write('Do you want to format the diskette? (Y/N) '); readln(st);
                   if upcase(st[1])='Y' then RT11FormatDisk;
                   WriteRT11Sector(i);
                   end;
       inc(ErrorCount);
       if ErrorCount>10 then begin writeln('** TOO MANY ERRORS! Command Aborted.'); exit; end;
       end;
    end;
if pos('/V',GlobalOptions)>0 then
   begin
   seek(source,0);
   writeln('/VERIFY not implemented yet!');
   for i:=0 to 799 do
       begin
       ReadRT11Sector(i);
       (* *)
       end;
   end;

close(source);
end;

procedure ShowCommandList(var OutputFile : text);
begin
writeln(OutputFile,'commands are...');
writeln(OutputFile,
         '  CHDIR dir   {change the MSDOS working directory}'^M^J,
         '  COPY DZ0:file [msdosname] {copy file(s) from RT11 diskette to DOS}'^M^J,
         '  COPY DZ0: msdosname  {copy whole RT11 diskette image to a DOS file}'^M^J,
         '  COPY msdosname DZ0:file {copy file(s) from MSDOS to RT11 diskette}'^M^J,
         '  CREATE filename {make a file on RT11 or MSDOS disk, allocating space}'^M^J,
         '  DELETE filename {delete files from RT11 disk}'^M^J,
         '  DUMP file {display an RT11 non-ASCII file; default is octal}'^M^J,
         '  DIR	   {list files in the RT11 diskette directory}'^M^J,
         '  EXIT     {finish with RT11 simulator, return to DOS}'^M^J,
         '  FORMAT   {hardware- and software-format a SSDD disk for RT11}'^M^J,
         '  HELP [topic] {information on using the system}'^M^J,
         '  INIT     {software-format the disk, i.e. place an empty directory on disk}'^M^J,
         '  MKDIR msdosname {make an MSDOS directory}'^M^J,
         '  PRINT file    {copy RT11 file(s) to the printer}'^M^J,
         '  RENAME oldname newname {change the name of an RT11 file}'^M^J,
         '  TYPE file     {copy RT11 file or files to your screen}'^M^J,
         '  UNDEL file    {undo (hopefully) the effects of a DELETE operation}'^M^J
         );
end;

procedure Help(topic : string);
var st : string;
    HelpFile : file of char;
    p        : byte;
    Startat  : array[0..9] of longint;
    Prompt   : array[0..9] of string[44];
    Level    : 0..9;

function RelatedTopics : string;
var MyList : string;
begin
MyList:=^I;
RelatedTopics:=MyList+^M^J;
end;

procedure Lookup(keywords : string);
var st : string;
begin
writeln('** detailed HELP not available; I''m as confused as you are! **');
end;

begin
Level:=0;
Prompt[0]:='HELP topic';
Startat[0]:=0;
assign(HelpFile,'RT11.DOC');
{$I-}
reset(HelpFile);
if IORESULT<>0 then begin
                    assign(HelpFile,'\RT11.doc');
                    reset(HelpFile);
                    if IORESULT<>0 then begin
                                        st:=GetEnv('PATH');
                                        (* *)
                                        end;
                    end;
(* add stuff here! *)
repeat
  for i:=length(Topic) downto 1 do
      if (Topic[i]=' ') and (Topic[i-1]=' ') then delete(Topic,i,1){remove multiple blanks}
                     else Topic[i]:=upcase(Topic[i]);	{convert to capitals}
  while Topic[length(Topic)]=' ' do dec(Topic[0]);	{remove trailing blanks}
  while (Topic[1]=' ') and (length(Topic)>0) do delete(Topic,1,1); {remove leading blanks}
  if (Level=0) and (topic='') then
       write(FilePointer^,
        'HELP              Lists helpful information'^M^J,
        ^M^J,
        '  SYNTAX'^M^J,
        '        HELP[/options] [topic]'^M^J,
        '     or HELP *'^M^J,
        '  SEMANTICS'^M^J,
        '        HELP *      lists the items for which help is available.'^M^J,
        '        HELP        lists this information, how to use HELP.'^M^J,
        '        HELP topic  lists information on using the given command, etc.'^M^J,
        ^M^J,
        '  OPTIONS'^M^J,
        '    /Printer     sends information to printer instead of screen'^M^J,
        ^M^J,
        'EXAMPLES'^M^J,
        '      HELP COPY             !lists information about the COPY command'^M^J,
        '      HELP/P EXIT           !prints information on how to exit from RT11'^M^J,
        ^M^J,
        'TOPICS:'^M^J,
        RelatedTopics,
        ^M^J)
    else if topic='*' then
         begin
         ShowCommandList(FilePointer^);
         end
   else Lookup(topic);
  writeln(' (Press the ENTER key to exit HELP mode)');
  write('HELP> ');
  readln(topic);
  for j:=1 to length(topic) do topic[j]:=upcase(topic[j]);
  until (topic='') or (copy(topic,1,2)='ex');

{$I-} close(HelpFile); {$I+}
if IORESULT<>0 then ; {ignore error closing file}
end;

procedure ExamineParameters;
var i  : integer;
    st : string;
begin
GlobalOptions:='';
CommandLine:='';
Prompt:=^M^J'.';
Drive:=0;
for i:=1 to ParamCount do
    begin
    st:=paramstr(i);
    if st[1]='/' then GlobalOptions:=GlobalOptions+st
                 else if st[length(st)]=':' then GlobalOptions:=GlobalOptions+'/Drive='+st
                                            else begin
                                                 CommandLine:=st;
                                                 for i:=i+1 to ParamCount do
                                                     CommandLine:=CommandLine+' '+paramstr(i);
                                                 exit;
                                                 end;
    end;
if pos('/?',GlobalOptions)>0 then
   begin
   writeln('useage:');
   writeln('   RT11/?                {display this message}');
   writeln('   RT11 command          {execute given command & return to DOS}');
   writeln('   RT11                  {prompt user for commands, until EXIT}');
   ShowCommandList(output);
   writeln('Note: RT11 uses drive A: as DZ0: unless you specify RT11/Drive=B:');
   writeln('      You must have an 80-track 5.25" diskette drive.  The program');
   writeln('      will not access two drives, so only refer to DZ0: in commands.');
                                  if paramcount=1 then halt;
   end;

for i:=1 to length(GlobalOptions) do GlobalOptions[i]:=upcase(GlobalOptions[i]);

end;

{$F+}
procedure RestoreDriveParameters;
{$F-}
begin
SetIntVec($1E,SaveDriveP);
ExitProc:=SaveExit;
if Drive <2 then MediaState[Drive]:=SaveMediaState;
end;

procedure SetupDriveForRT11;
var
    p  : integer;

procedure UseFirstAppropriateDrive;
var reg       : registers;
    TracksOnA : word;
begin
with reg do begin
            Drive:=0;
            AH:=$0; DX:=00; intr($13,reg);
            exit; (* !! *)
            if odd(flags) then writeln('WARNING: I think your diskette BIOS cannot handle such disks!');
            writeln('AX=',hex(ax));
            AX:=$0800; DX:=0; {check type of drive 0}
            intr($13,reg);
            if odd(flags) then writeln('WARNING: I think your diskette BIOS cannot handle such disks!');
            writeln('AX=',hex(AX),' BL=',bl,' CH=',ch,' media=',hex(mediastate[0]),' machine=',hex(MachineID));
            if BL=2 then exit; {this is a 1.2Mb drive}
            TracksOnA:=CH;
            AX:=$0800; DL:=1; {Check type of drive 1}
            intr($13,reg);
            if BL=2 then Drive:=1
                     else if TracksOnA=80 then exit
                     else if CH=80 then Drive:=1
                     else if DL>1 then begin
                                       Drive:=DL;
                                       AX:=$0800; intr($13,reg);
                                       end;
             writeln('WARNING: I don''t think drive ',chr(65+Drive),': (which has ',CH,' tracks) is suitable');
             end;
end;

begin
GetIntVec($1E,SaveDriveP);
SaveExit:=ExitProc;
for p:=1 to length(GlobalOptions) do GlobalOptions[p]:=upcase(GlobalOptions[p]);
p:=pos('/D',GlobalOptions);
if p>0 then begin
            repeat inc(p);
                   if p>255 then begin writeln('ERROR: Invalid /Drive= option'); halt; end;
                   until GlobalOptions[p] in ['=',':','/','0','1',' '];
            inc(p);
            case upcase(GlobalOptions[p]) of
                 'A' : Drive := 0;
                 'B' : Drive := 1;
                 'D' : Drive := ord(GlobalOptions[p+2]) and 7;
            '0'..'9' : Drive := ord(GlobalOptions[p]) and 15;
                 '"' : begin
                       UseVirtualDisk:=true;
                       st:=copy(GlobalOptions,p+1,99);
                       st[0]:=char(pos('"',st)-1);
                       assign(VirtualDisk,st);
                       writeln('Openning virtual disk ',st,'...');
                       reset(VirtualDisk,512);
                       exit;
                       end;
                else begin writeln('ERROR: Invalid /Drive= option'); halt; end;
                end {of case};
            if Drive>1 then begin writeln('WARNING: You should use drive 0 or 1'); end;
            end
       else UseFirstAppropriateDrive;
if Drive < 2 then SaveMediaState:=MediaState[Drive];
ExitProc:=@RestoreDriveParameters;
SetupBios;
end;

procedure ProcessCommand(CommandLine : string);
const
    Delim   : set of char=[#0..' ',','];
var i       : integer;
    st      : string;
    Keyword : string[80] absolute Parameter;
    state   : byte;
    TempFile: file;
    RT11ParamCount : integer;
begin
RT11ParamCount:=-1;
state:=1;
st:='';
Parameter[1]:=''; Parameter[2]:=''; Parameter[3]:='';
for i:=1 to length(CommandLine) do
    case state of
         1 : if CommandLine[i] = '/'
                then if RT11ParamCount<0
                        then begin {cannot start with a /option}
                             writeln('?KMON-F-Invalid Command (missing keyword)');
                             exit
                             end
                        else begin
                             state:=2;
                             ParamOption[RT11ParamCount]:=ParamOption[RT11ParamCount]+upcase(CommandLine[i]);
                             end
                else if CommandLine[i] in Delim then {ignore}
                     else begin
                          State:=3;
                          inc(RT11ParamCount);
                          Parameter[RT11ParamCount]:=upcase(CommandLine[i]);
                          ParamOption[RT11ParamCount]:='';
                          end;
         2 : if CommandLine[i] in Delim
                then state:=1
                else ParamOption[RT11ParamCount]:=ParamOption[RT11ParamCount]+upcase(CommandLine[i]);
         3 : if CommandLine[i]='/'
                then begin state:=2; ParamOption[RT11ParamCount]:='/'; end
                else if CommandLine[i] in Delim
                        then state:=1
                        else Parameter[RT11ParamCount]:=Parameter[RT11ParamCount]+upcase(CommandLine[i]);
         end;

Options:='';
for i:=0 to RT11ParamCount do Options:=Options+ParamOption[i];
Options:=Options+GlobalOptions;
ParamOption[0]:=ParamOption[0]+GlobalOptions;
if KeyWord='' then exit;

if Parameter[2]='TO' then Parameter[2]:=Parameter[3];
Source:=Parameter[1];
if copy(Source,1,4)=DZ0 then delete(source,1,4);
if (Keyword='CO') or ((length(KeyWord)=1) and (pos(Keyword,'RHQED')=0))
                  then begin
                       writeln('?KMON-F-Ambiguous command');
                       exit;
                       end;
if copy(KeyWord,1,3)='DIF' then KeyWord:='FC';  {File Compare}
if copy(KeyWord,1,3)='PRO' then KeyWord:='HIDE';
if pos(KeyWord,'QUIT')=1 then KeyWord:='EXIT';
if pos('/L',Options)>0
 then begin
      p:=pos('/L',Options);
      repeat inc(p) until (p>=length(Options)) or (Options[p] in [':','=','/',' ']);
      if Options[p] in ['=',':']
                 then assign(Printer,copy(Options,p+1,99))
                 else assign(Printer,'PRN');
      {$I-}
      append(Printer);
      if IORESULT<>0 then rewrite(Printer);
      {$I+}
      if IORESULT<>0 then begin
                          writeln('?DOS-W-Error openning /LIST= file');
                          FilePointer:=@Output;
                          end
                     else FilePointer:=@Printer;
      end
 else FilePointer:=@Output;

case (pos(copy(KeyWord,1,2),'.CO.DI.EX.HE.PR.TY.FO.DE.RE.CD.CH.MD.MK.XY.AB.BO.AS.CR.DA.DI.ED.DU.SE.SH.HI.UN.IN')+1) div 3 of
     1 : begin
	{COPY source dest}
         if parameter[1]='' then begin write('Source file name: '); readln(Parameter[1]); end;
         if parameter[1]=DZ0 then CopyWholeDisk
                                else if (copy(Parameter[2],1,4)=DZ0) or (Parameter[1][2]=':') or boolean(pos('\',Parameter[1]))
                                     then if (length(Parameter[2])=4) and (pos('*',parameter[1])=0)
                                             then CopyWholeImageToDisk
                                             else CopyDosToRT11(copy(Parameter[2],5,99))
                                     else CopyFiles('');
         end;
     2 : begin
	{DIR [source]}
         if parameter[1]='' then Parameter[1]:=dz0+'*.*';
         if copy(parameter[1],1,4)=DZ0 then delete(parameter[1],1,4);
         if parameter[1][1]='.'
            then if parameter[1]='.'
                    then MsDosListFiles('*.*')
                    else if parameter[1]='..' then begin
                                                   GetDir(0,st);
                                                   st:=copy(st,1,ScanForLast('\',st));
                                                   MsDosListFiles(st+'*.*');
                                                   end
                                              else MsDosListFiles(Parameter[1])
            else if boolean(pos('\',Parameter[1])) or (parameter[1][2]=':')
                    then MsDosListFiles(parameter[1])
                    else begin
                         if pos('/BAD',Options)>0 then RT11Test
                                                  else RT11ListFiles;
                         end;
         end;
     3 : begin
	{EXIT}
         ExitRequested:=true;
         end;
     4 : begin
	{HELP [topic]}
         Help(Parameter[1]+' '+Parameter[2]+' '+Parameter[3]);
         end;
     5 : begin
	{PRINT source}
         CopyFiles('PRN');
         end;
     6 : begin
	{TYPE source}
         CopyFiles('CON')
         end;
     7 : begin
	{FORMAT disk}
         RT11FormatDisk;
         end;
     8 : begin
	{DELETE file}
         if (parameter[1][2]=':') or boolean(pos('\',parameter[1]))
            then begin
                 assign(TempFile,parameter[1]);
                 erase(TempFile);
                 end
            else Rt11Delete(Parameter[1]);
         end;
     9 : begin
	{RENAME file1 [TO] file2}
         if (parameter[1][2]=':') or boolean(pos('\',parameter[1]))
            then begin
                 assign(TempFile,parameter[1]);
                 rename(TempFile,parameter[2])
                 end
            else Rt11Rename(Parameter[1],Parameter[2]);
         end;
    10,
    11 : begin
	{CD=CHDIR directory}
         ChDir(Parameter[1]);
         end;
    12,
    13 : begin
	{MD=MKDIR directory}
         MkDir(Parameter[1]);
         end;
    14 : begin
	{XYZZY magic}
         if parameter[1]<>'' then writeln(FilePointer^,match(parameter[1],parameter[2]))
                             else writeln(FilePointer^,'Nothing Happens!');  (* implement later *)
         end;
    15 : begin
	{ABORT}
         halt;
         end;
    16 : begin
	{BOOT}
         writeln(FilePointer^,'Don''t be silly');
         end;
    17 : begin
	{ASSIGN}
         writeln('?MSA-F-Not implemented');
         end;
    18 : begin
	{CREATE filename}
         p:=pos('/A',Options);
         if p=0 then begin
                     i:=All;
                     if Parameter[2]<>'' then if Parameter[2][1] in ['0'..'9'] then val(Parameter[2],i,j);
                     end
                else begin
                     repeat inc(p) until (Options[p] in [':','=','0'..'9']) or (p>=length(Options));
                     val(copy(Options,p+1,4),i,j);
                     end;
         with DT do GetDate(Year,Month,Day,DayOfWeek);
         if (parameter[1][2]=':') or boolean(pos('\',parameter[1]))
            then begin
                 assign(TempFile,parameter[1]);
	        {$I-}
                 reset(TempFile);
                 if IORESULT=0 then begin
                                    close(TempFile);
                                    if pos('/N',Options)>0
                                       then begin
                                            writeln('?DOS-F-File already exists');
                                            exit;
                                            end
                                       else writeln(FilePointer^,'?DOS-I-File already exists; re-creating...');
                                    end;
                 rewrite(TempFile,512);
	        {$I+}
                 if IORESULT<>0 then begin
                                     close(TempFile);
                                     writeln('?DOS-F-File Protection error');
                                     exit;
                                     end;
                 if i=All then i:=DiskFree(0) div 512;
                 seek(TempFile,i);
                 FillChar(Buffer,512,0);
                 blockwrite(TempFile,Buffer,1);
                 close(TempFile);
                 end
            else begin
                 j:= Rt11Create(Parameter[1],i);
                 end;
         end;
    19 : begin
	{DATE}
         with DT do begin
                    GetDate(Year,Month,Day,DayOfWeek);
                    writeln(FilePointer^,DateString(day,month,year));
                    end;
         end;
    20 : begin
	{FC=DIFFERENCES}
	{EDIT}
	{SET}
	{SHOW}
	{HIDE=PROTECT}
         writeln('?MSA-W-Command not implemented');
         end;
    22 : begin
	{DUMP}
         if pos('/D',options)>0 then DumpFile(10)
            else if pos('/H',options)>0 then Dumpfile(16)
            else if pos('/B',options)>0 then DumpFile(0)
            else if pos('/R',options)>0 then DumpFile(40)
            else DumpFile(8);
         end;
    26 : begin
	{UNDELETE}
         RT11Undelete(Parameter[1]);
         end;
    27 : begin
	{INIT disk}
         Options:=Options+'/SOFT';
         RT11FormatDisk;
         end;
    else writeln('?UCL-F-Command does not exist!)');
    end;
if FilePointer<>@Output then close(Printer);
end;

{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}
{{                                                               {}
{{   MAIN PROGRAM: RT11 EMULATOR                                 {}
{{                                                               {}
{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}

begin
ExitRequested:=false;
writeln('RT11 <-> PC file transer program (Dj-vu-Dec)           Version 1.02');
writeln(' [M.Aitchison, Dept of Physics, University of Canterbury]     (C)1989');
writeln;
ExamineParameters;
SetupDriveForRT11;
if CommandLine<>''
   then ProcessCommand(CommandLine)
   else repeat write(Prompt);
               readln(CommandLine);
               ProcessCommand(CommandLine);
               until ExitRequested;
RestoreDriveParameters;
end.

