/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __MACH_H
#define __MACH_H

/* die Reihenfolge ist entscheidend, 
   sie muss struct jmpbuf in setjmp.h entsprechend
*/
#define REG_R0 1
#define REG_R1 2
#define REG_R2 3
#define REG_R3 4
#define REG_R4 5
#define REG_R5 6
#define REG_SP 7
#define REG_PSW 8
#define REG_PC 9

typedef unsigned int addr_t;
typedef unsigned int break_t;
typedef unsigned int mem_t;

extern void setreg();
extern void clrreg();
extern void initreg();
extern void showreg();
extern void disasm();

#define NAME "PDP-11"
#define RADIX 8
#define WORDSIZE 2
#define WORDLEN_16 4
#define WORDLEN_10 5
#define WORDLEN_8  6
#define IOFMT "%0.wr\n"
#define MEMFMT "%0.wr "
#define ADRFMT "%0.wr"
#define DMPFMT_A "%A  "
#define DMPFMT_S "%S\n"
#define BRKINST 000003
#define STACKPTR 0160000
#define find_register(t, s, c) find_string(t, s, c, 2)

/* DS-Manipulation entfaellt */
#define DS_VAR(x)
#define STACK(x)
#define CODE(x)
#define RESTORE(x)

/* Trace-Flag */
#include <pdp11/status.h>
#define settrace() (status.psw|=0x0010)
#define untrace()  (status.psw&=0xffef)
#define togtrace() (status.psw^=0x0010)
#define istrace()  ((status.psw&0x0010) != 0)

/* der 2.11BSD C-Compiler kennt noch kein const */
#define const 

extern void init();

#endif /* __MACH_H */
