/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#include <vport50/setjmp.h>
#include <vport50/status.h>
#include <vport50/mach.h>
#include <vport50/addr.h>
#include <common/stdio.h>
#include <common/string.h>
#include <common/intel.h>

void intel(start)
        addr_t *start;
{
        char buf[80];
        char *ptr;
        unsigned int cnt, seg=0x100, ofs, typ, val, sum, state=0;
        addr_t addr;
        DS_VAR(ds);

        STACK(ds);
        for(;;) {
                sum=0;
                printf("> ");
                ptr=gets(buf, 79);
                if(buf[0] != ':')
                        goto error;
	  
                cnt  = hex(buf[1]) << 4;
                cnt += hex(buf[2]);
                sum += cnt;
	  
                ofs  = hex(buf[3]) <<12;
                ofs += hex(buf[4]) << 8;
                ofs += hex(buf[5]) << 4;
                ofs += hex(buf[6]);
                sum += (ofs&0xff00)>>8;
                sum += (ofs&0x00ff);
                set_addr(&addr, seg, ofs);
	  
                typ  = hex(buf[7]) << 4;
                typ += hex(buf[8]);
                sum += typ;
                ptr  = buf + 9;
	  
                switch(typ) {
                case IH_DATA: /* data record */
                        if(!state)
                                goto segerror;
                        while(cnt--) {
                                val  = hex(*ptr++) << 4;
                                val += hex(*ptr++);
                                sum += val;
                                writeb(&addr, val);
                                inc_addr(&addr);
                        }
                        break;
	       
                case IH_END: /* end record */
                        if(!state)
                                goto segerror;
                        break;
	       
                case IH_SEGADDR: /* expanded address record */
                        seg  = hex(buf[9]) << 12;
                        seg += hex(buf[10]) << 8;
                        seg += hex(buf[11]) << 4;
                        seg += hex(buf[12]);
                        sum += (seg&0xff00)>>8;
                        sum += (seg&0x00ff);
                        set_addr(&addr, seg, ofs);
                        state = 1; /* state == 1 -> Segmentadresse gesetzt */
                        ptr = buf + 13;
                        break;
	       
                case IH_SSTART: /* start address record */
                        if(!state)
                                goto segerror;
                        seg  = hex(buf[9]) <<12;
                        seg += hex(buf[10]) << 8;
                        seg += hex(buf[11]) << 4;
                        seg += hex(buf[12]);
                        sum += (seg&0xff00)>>8;
                        sum += (seg&0x00ff);
                        ofs  = hex(buf[13]) <<12;
                        ofs += hex(buf[14]) << 8;
                        ofs += hex(buf[15]) << 4;
                        ofs += hex(buf[16]);
                        sum += (ofs&0xff00)>>8;
                        sum += (ofs&0x00ff);
                        status.cs = seg;
                        status.ip = ofs;
                        set_addr(start, seg, ofs);
                        ptr = buf + 17;
                        break;
	       
                default:
                        printf("%c%cillegal record type\n", 7, 7);
                        longjmp();
                }
                val  = hex(*ptr++) << 4;
                val += hex(*ptr++);
                sum += val;
                if(sum&0x00ff) {
                        printf("%c%cchecksum error\n", 7, 7);
                        longjmp();
                }
                if(typ == 0x01) {
                        RESTORE(ds);
                        return;
                }
        }

error:
        printf("%c%cnot Intel-Hex format\n", 7, 7);
        longjmp();

segerror:
        printf("%c%csegment address not set\n", 7, 7);
        longjmp();
}
