/* VPort-50 Monitor
   Copyright (c) 2004, 2005 Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#include <common/stdio.h>
#include <common/break.h>
#include <pdp11/status.h>
#include <pdp11/addr.h>
#include <pdp11/mach.h>

#define TERMINATE 024
#define GETCHAR   020
#define PUTCHAR   021
#define GETCHARW  022

extern int end, incr;

/* Inkrement fr SP, wird einmal beim Reset berechnet (Maschinenabhngig 6 oder 8) */
int incr;

void trap(r0, r1, r2, r3, r4, r5, sp, why, pc, ps)
        unsigned int r0, r1, r2, r3, r4, r5, sp, why, pc, ps;
{
        register i;
        unsigned int arg;
        addr_t tmp;

        sp += incr;

        switch(why) {
        case 0:
                printf("\nbus error, loc %r\n", pc);
                break;
        case 1:
                printf("\nillegal instruction, loc %r\n", pc);
                break;
        case 2: /* Breakpoint & Trace */
                unbreak();
                set_addr(&tmp, pc-2);
                for(i=0; i!=brkcnt; i++)
                        if(!cmp_addr(&brktbl[i].addr, &tmp))
                                break;
                if(brkcur != NBRK) {
                        brkcur = NBRK;
                        if(trace == 0) {
                                ps &= 0xffef;
                                dobreak();
                                return;
                        }
                } else if(i != brkcnt) {
                        printf("\nbreakpoint reached\n");
                        brkcur=i;
                        ps|=0x0010;
                        pc-=2;
                }
                break;
        case 3:
                printf("\niot trap, loc %r\n", pc);
                break;
        case 4:
                printf("\npower failure\n");
                break;
        case 5:
                printf("\nEMT instruction, loc %r\n", pc);
                break;
        case 6:
                tmp = pc-2;
                arg = readw(&tmp);
                arg &= 0377;
                switch(arg) {
                case TERMINATE:
                        printf("\nterminated.\n");
                        break;
                case PUTCHAR:
                        putchar(r0);
                        return;
                case GETCHAR:
                        r0 = getchar_nb();
                        return;
                case GETCHARW:
                        r0 = getchar();
                        return;
                default:
                        printf("\nunknown TRAP - %d\n", arg);
                }
                break;
        case 7:
                printf("\nprogrammed interrupt\n");
                break;
        case 8:
                printf("\nfloating point trap, loc %r\n", pc);
                break;
        case 9:
                printf("\nsegmentation violation\n");
                break;
        default:
                printf("\nunknown trap, loc %r\n", pc);
        }
     
        /* User war Verursacher des Traps */
        if(pc >= &end) {
                status.r0 = r0;
                status.r1 = r1;
                status.r2 = r2;
                status.r3 = r3;
                status.r4 = r4;
                status.r5 = r5;
                status.sp = sp;
                status.pc = pc;
                status.psw = ps;
                showreg();
                set_addr(&tmp, status.pc);
                disasm(&tmp);
        }
        longjmp();
}
