/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __ADDR_H
#define __ADDR_H

#include <pdp11/mach.h>

/* Adressmanipulation */
#define add_addr(a, b) (*(a)+=(b))
#define sub_addr(a, b) (*(a)-=(b))
#define inc_addr(a)    ((*(a))++)
#define dec_addr(a)    ((*(a))--)
#define cmp_addr(a, b) (((int) *(a)) - ((int)*(b)))
#define cpy_addr(a, b) (*(b) = *(a))
#define set_addr(a, b) (*(a) = (b))
#define clr_addr(a)    (*(a) = 0)

/* die meisten PDP11-Prozessoren verlangen word-alignment */
#define odd_addr_err(a) if(*(a)&1) { printf("odd address\n"); longjmp(); }
#define odd_addr_inc(a) (*(a) = ((*(a))+1)&0xfffe)

/* direkter Speicherzugriff */
#define writeb(addr, val) (*((char *) *(addr)) = (char) (val))
#define writew(addr, val) (*((int *) *(addr)) = (val))

#define readb(addr) (*((char *) *(addr)))
#define readw(addr) (*((int *) *(addr)))

#define write_mem(addr, val) writew(addr, val)
#define read_mem(addr) readw(addr)

/* IO-Zugriffe */
#define out(port, val) (*((unsigned int *) (port)) = val)
#define in(port)       (*((unsigned int *) (port)))

/* die meisten PDP11-Prozessoren verlangen word-alignment */
#define odd_port(port) if(port&1) { printf("odd port\n"); longjmp(); }

/* Zugriffe auf Breakpoints */
#define write_break(addr, val) writew(addr, val)
#define read_break(addr)       readw(addr)

/* Adress-Ein/Ausgabe */
#define scan_addr(ptr, val) scann(ptr, val, 0)
#define print_addr(addr)    printf(ADRFMT, *(addr))

#endif /* __ADDR_H */
