/* VPort-50 Monitor
   Copyright (c) 2004, 2005 Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#include <common/stdio.h>
#include <mach/setjmp.h>
#include <mach/mach.h>
#include <mach/addr.h>

/* gets liest eine Zeichenkette von der Console
   (blockierend, mit Echo und Zeileneditor)
*/
char* gets(string, count)
        char *string;
        unsigned int count;
{
        int c, dflg;
        char *ptr=string;
        DS_VAR(ds);

        if(count == 0) return(string);

        STACK(ds);
        do {
                dflg=0;
                switch(c=getchar()) {
                case 0x08: /* backspace */
                case 0x7f: /* delete */
                        if(ptr == string)
                                putchar(7);
                        else {
                                ptr--;
                                count++;
                                putchar(8);
                                putchar(' ');
                                putchar(8);
                        }
                        dflg=1;
                        break;
                case 0x15:
                        while(ptr!=string) {
                                putchar(8);
                                putchar(' ');
                                putchar(8);
                                count++;
                                *--ptr=0;
                        }
                        dflg=1;
                        break;
                default:
                        if((c>=0x20 && c<=0x7e) || c=='\n')
                                putchar(*ptr=c);
                        else { 
                                putchar(7);
                                dflg=1;
                        }
                }
        } while(dflg ? 1 : (--count && *ptr++ != '\n'));
 
        *ptr='\0';
        RESTORE(ds);
        return(string);
}

/* gibt einen vorzeichenlosen Integer n zur Basis b aus
   es werden mindestens (m = 0) oder genau (m = 1) c+1 Ziffern ausgegeben
*/
void printn(n, b, c, m)
        unsigned int n, b;
        int c, m;
{
        register int a = n / b, p = m ? c : (c || a) ;
        DS_VAR(ds);

        if(p)
                printn(a, b, c ? c - 1 : 0, m);

        CODE(ds);
        putchar("0123456789abcdefghijklmnopqrstuvwxyz"[n % b]);
        RESTORE(ds);
}

/* Minimalversion von printf(), kennt nur %d, %o, %x, %r, %c, %s, %S, %A, %C, %F
   Bei %d, %o, %x kann ein Zero-Pad-Flag (0) und die (einstellige) Anzahl
   der auszugebenden Ziffern (.[0-9]) angegeben werden, die Zeichen 'b' und 'w'
   entsprechen der Anzahl der auszugebenden Zeichen fr ein Byte oder Word beim
   verwendeten Radix.
   Achtung: der Formatstring fmt muss _immer_ ein String-Literal sein,
   _keine_ Variable, fr String-Argumente gilt das Gegenteil (ausser bei %C).

   Der ungewhnliche Funktionskopf ist ntig, um je nach Compiler K&R- oder ANSI-
   Syntax fr die variable Argumentliste verwenden zu knnen, siehe mach/printf.h.
*/

extern struct flagtab flagtab[];

void PRINTF(fmt)
{
        va_list argp;
        int c, cnt, pad;
        char *ptr;
        struct flagtab *flt;
        DS_VAR(ds);

        va_start(argp, fmt);

        for(;;) {
                CODE(ds);
                while((c = *fmt++) != '%')
                        if(c)
                                putchar(c);
                        else goto exit ;
	  
                c = *fmt++;
                if(!c) goto exit;

                cnt = 1;
                pad = 0;

                if(c == '0') {
                        pad = 1;
                        c = *fmt++;
                }
                if(c == '.') {
                        c = *fmt++;
                        switch(c) {
                        case 'b':
                                cnt = -1;
                                break;
                        case 'w':
                                cnt = -2;
                                break;
                        default:
                                if(c >= '0' && c<= '9')
                                        cnt = c - '0';
                        }
                        c = *fmt++;
                }	  
                RESTORE(ds);

                STACK(ds);
                if(cnt == -2)
                        cnt = (radix == 16 ? WORDLEN_16 : (radix == 10 ? WORDLEN_10 : WORDLEN_8));
                else if(cnt == -1)
                        cnt = (radix == 16 ? 2 : 3);

                switch(c) {
                case 'r':
                        pad=1;
                        if(cnt == 1)
                                cnt = (radix == 16 ? WORDLEN_16 : (radix == 10 ? WORDLEN_10 : WORDLEN_8));
                case 'd':
                case 'o':
                case 'x':
                        cnt--;
                        printn(va_arg(argp, unsigned int),
                               c == 'r' ? radix : (c == 'o' ? 8 : (c == 'd' ? 10 : 16)),
                               cnt, pad);
                        break;

                case 'A':
                        print_addr(va_arg(argp, addr_t *));
                        break;

                case 'C':
                        ptr = va_arg(argp, char *);
                        RESTORE(ds);
                        CODE(ds);
                        while((c = *ptr++))
                                if(c == '\n') {
                                        putchar('\\');
                                        putchar('n');
                                } else putchar(c);
                        break;

                case 's':
                        ptr = va_arg(argp, char *);
                        while(*ptr)
                                putchar(*ptr++);
                        break;

                case 'S':
                        ptr = va_arg(argp, char *);
                        for(cnt = 0; cnt != 16; cnt++) {
                                c = *ptr++;
                                putchar(c < 32 ? '.' : (c > 126 ? '.' : c));
                        }
                        break;

                case 'F':
                        cnt = va_arg(argp, int);
                        RESTORE(ds);
                        CODE(ds);
                        for(flt = flagtab; flt->name != 0; flt++)		    
                                printf("%c ", cnt&flt->bit ? flt->name : '-');
                        break;

                case 'c':
                        putchar(va_arg(argp, int));
                        break;

                default:
                        putchar('%');
                        putchar(c);
                }
                RESTORE(ds);
        }

exit:
        va_end(argp);
        RESTORE(ds);
        return;
}

/* liest eine Zahl der Basis rad aus string und speichert sie in val,
   gibt einen Zeiger auf das nachfolgende Zeichen zurck
   im Fehlerfall wird das Programm zurckgesetzt
   Achtung: ist die Zahl zu gross fr einen unsigned int werden nur die
   niederwertigen Bits gespeichert
*/
char* scann(string, val, rad)
        char *string;
        unsigned int *val;
        int rad;
{
        register int c;
        register unsigned int tmp = 0;
        DS_VAR(ds);

        STACK(ds);
        if(rad == 0)
                rad = radix;
        while((c = *string++)) {
                if(c == ':' || c == ' ' || c == '\t' || c == '\n' || c == ',')
                        break;
                tmp *= rad;
                switch(rad) {
                case 16:
                        if(c >= 'A' && c <= 'F') {
                                tmp += c - 'A' + 10;
                                break;
                        } else if(c >= 'a' && c <= 'f') {
                                tmp += c - 'a' + 10;
                                break;
                        }
                case 10:
                        if(c >= '8' && c<='9') {
                                tmp += c - '0';
                                break;
                        }
                case 8:
                        if(c >= '0' && c<='7') {
                                tmp += c - '0';
                                break;
                        } else {
                                printf("\nparse error: illegal character: %c\n", c);
                                longjmp();
                        }
                default:
                        printf("\nscan error: unknown radix - %d\n", radix);
                        longjmp();
                }
        }
        *val=tmp;
        RESTORE(ds);
        return(string-1);
}
