/* VPort-50 Monitor
   Copyright (c) 2005 Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#include <arm/mach.h>
#include <arm/addr.h>
#include <arm/setjmp.h>
#include <arm/status.h>
#include <common/command.h>
#include <common/string.h>
#include <common/stdio.h>
#include <common/break.h>

/* Kommando-Struktur fr Register */
const struct command c_reg[] = {
        { "CPSR", REG_CPSR },
        { "R0",   REG_R0   },
        { "R1",   REG_R1   },
        { "R2",   REG_R2   },
        { "R3",   REG_R3   },
        { "R4",   REG_R4   },
        { "R5",   REG_R5   },
        { "R6",   REG_R6   },
        { "R7",   REG_R7   },
        { "R8",   REG_R8   }, 
        { "R9",   REG_R9   },
        { "R10",  REG_R10  },
        { "R11",  REG_R11  },
        { "R12",  REG_R12  },
        { "R13",  REG_R13  },
        { "R14",  REG_R14  },
        { "R15",  REG_R15  },
        { 0, 0 }
};

/* flagtab fr %F in printf */
const struct flagtab flagtab[] = {
        { 0x8000000, 'N' },
        { 0x4000000, 'Z' },
        { 0x2000000, 'C' },
        { 0x1000000, 'V' },
        { 0x0000080, 'I' },
        { 0x0000040, 'F' },
        { 0x0000020, 'T' },
        { 0, 0 }
};

/* der GNU-Linker ordnet globale Variable automatisch im RAM an,
   deshalb knnen die hier definiert werden
*/

struct jmpbuf status, jmpbuf;
struct breakpoint brktbl[NBRK];
int brkcur, brkcnt, trace, radix;


/* showreg, clrreg, initreg - Register anzeigen, lschen und initialisieren */
void showreg(void)
{
        printf("\
R0  = %r, R1  = %r, R2  = %r, R3  = %r\n\
R4  = %r, R5  = %r, R6  = %r, R7  = %r\n\
R8  = %r, R9  = %r, R10 = %r, R11 = %r\n\
R12 = %r, R13 = %r, R14 = %r, R15 = %r\n\
CPSR = %r, %F\n",
               status.r0, status.r1, status.r2, status.r3, status.r4,
               status.r5, status.r6, status.r7, status.r8, status.r9,
               status.r10, status.r11, status.r12, status.r13, status.r14,
               status.r15, status.cpsr, status.cpsr);
}

void clrreg(void)
{
        status.r0 = status.r1 = status.r2 = status.r3 = status.r4 = status.r5 =
                status.r6 = status.r7 = status.r8 = status.r9 = status.r10 = status.r11 =
                status.r12 = status.r13 = status.r14 = status.r15 = status.cpsr = 0;
}

void initreg(addr_t *addr)
{
        status.cpsr = 0x1f; 
        status.r15  = *addr;
        status.r13  = STACKPTR;
}

unsigned int tflag;

unsigned int settrace(void)
{
        return(tflag=1);
}

unsigned int untrace(void)
{
        tracepoint.addr = 0xffffffff;
        tracepoint.inst = 0;
        return(tflag=0);
}

unsigned int istrace(void)
{
        return(tflag);
}

unsigned int togtrace(void)
{
        tflag = tflag ? 0 : 1;
        return(tflag);
}

