;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	@(#)globals.asm	1.6	11/10/12
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

msize	.equ	60		; CP/M version memory size in kilobytes
moff	.equ	0x3400		; memory offset

rom	.equ	0xF000		; ROM starting address

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Available ROM routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_cold_start	= rom+3*0	; ROM cold start - erases memory
_warm_start	= rom+3*1	; ROM warm start
_con_rxstat	= rom+3*2	; console receiver status
_con_txstat	= rom+3*3	; console transmitter status
_getchar	= rom+3*4	; get a character from the console
_putchar	= rom+3*5	; send a character to the console
_gets		= rom+3*6	; get a string from the console
_put		= rom+3*7	; send a string to the console
_puts		= rom+3*8	; send a string to the console w/CR,LF
_crlf		= rom+3*9	; send a CR,LF to the console
_prhex		= rom+3*10	; send a hex byte to the console
_spio13_rxstat	= rom+3*11	; serial port receiver status
_spio13_txstat	= rom+3*12	; serial port transmitter status
_spio13_sctrl	= rom+3*13	; serial port modem control
_spio13_sread	= rom+3*14	; serial port raw read
_spio13_swrite	= rom+3*15	; serial port raw write
_ide_address	= rom+3*16	; get the address of the IDE controller
_ide_configure	= rom+3*17	; configure the IDE drive
_ide_read	= rom+3*18	; read a 512 byte sector from a drive
_ide_write	= rom+3*19	; write a 512 byte sector to a drive
_ide_get_chs	= rom+3*20	; get the CHS of the last sector processed
_ide_drive_id	= rom+3*21	; get IDE drive info


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	CP/M disk constants.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
hstsiz	.equ	512		; host disk sector size
nparts	.equ	16		; number of disk partition entries
blksiz	.equ	16384		; CP/M allocation size
dsksiz	.equ	512		; size of each partition in allocation units
dirent	.equ	dsksiz-(dsksiz>>4)	; number of directory entries per partition

dirinit	.equ	0		; include the directory initialization routine
