	.title	Serial I/O Routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	@(#)spio13.s	1.5	11/10/01
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.module	spio13

	.area CODE (CON)

	.include "globals.s"

crxstat	.gblequ	_spio13_rxstat
ctxstat	.gblequ	_spio13_txstat
cctl	.gblequ	_spio13_sctrl
ci	.gblequ	_spio13_sread
co	.gblequ	_spio13_swrite

; PIO Register Offsets
_PA	.equ	0		; Port A
_PB	.equ	1		; Port B
_PC	.equ	2		; Port C
_CR	.equ	3		; Control Register (write only)

; PIO Control Register
_MODE_ACTIVE	= 0B10000000
_GA_MODE_2	= 0B01000000
_GA_MODE_1	= 0B00100000
_GA_PA_IN	= 0B00010000
_GA_PCH_IN	= 0B00001000
_GB_MODE_1	= 0B00000100
_GB_PB_IN	= 0B00000010
_GB_PCL_IN	= 0B00000001

; UART Register Offsets
_RR	.equ	0		; Receiver Register (read only)
_TBR	.equ	0		; Transmitter Buffer Register (write only)
_SR	.equ	1		; Status Register (read only)
_MCR	.equ	1		; Modem Control Register (write only)

; UART Modem Control Register
_RTS	.gblequ	0B00000010	; Request To Send
_DTR	.gblequ	0B00000001	; Data Terminal Ready

MODEM	.gblequ	_DTR+_RTS	; both lines

; UART Status Register
_TBRE	.equ	7		; Transmitter Buffer Register Empty
_DR	.equ	6		; Data Received
_OE	.equ	5		; Overrun Error
_FE	.equ	4		; Framing Error
_PE	.equ	3		; Parity Error
_TRE	.equ	2		; Transmitter Register Empty
_CTS	.equ	1		; Clear To Send
_DSR	.equ	0		; Data Set Ready

XOFF	.equ	19
XON	.equ	17

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Get the UART receive status.
;
;	Parameters:
;		C = port
;
;	Returns:
;		A = UART status register
;		Z: 1=no data, 0=data available
;
;	T States: 38
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_spio13_rxstat::
	inc	c		; switch to the status register		4
	in	a,(c)		; get the UART status			12
	dec	c		; switch to the data register		4
	bit	_DR,a		; data received?			8
	ret			; done					10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Get the UART transmit status.
;
;	Parameters:
;		C = port
;
;	Returns:
;		A = UART status register
;		Z: 0=no data, 1=data transmitting
;
;	T States: 38
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_spio13_txstat::
	inc	c		; switch to the status register		4
	in	a,(c)		; get the UART status			12
	dec	c		; switch to the data register		4
	bit	_TBRE,a		; transmit register empty?		8
	ret			; done					10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Modify the modem control lines.
;
;	Parameters:
;		B = new line states
;		C = port
;
;	Returns:
;		Nothing
;
;	T States: 30
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_spio13_sctrl::
	inc	c		; switch to the modem control register	4
	out	(c),b		; set the modem control lines		12
	dec	c		; switch to the data register		4
	ret			; done					10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Wait until the receive register is full
;	then read a character from the UART.
;
;	Parameters:
;		C = port
;
;	Returns:
;		A = new character
;
;	T States: 57+
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_spio13_sread::
	inc	c		; switch to the status register		4
1$:	in	a,(c)		; get the UART status			12
	bit	_DR,a		; data received?			8
	jr	z,1$		; no, check again			7,12
	dec	c		; yes, switch to the data register	4
	in	a,(c)		; get byte from the serial port		12
	ret			; done					10


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Wait until the transmit register is empty
;	then write a character to the UART.
;
;	Parameters:
;		A = character
;		C = port
;
;	Returns:
;		Clobbers B
;
;	T States: 57+
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_spio13_swrite::
	inc	c		; switch to the status register		4
1$:	in	b,(c)		; get the UART status			12
	bit	_TBRE,b		; is the transmitter buffer empty?	8
	jr	z,1$		; no, check again			7,12
	dec	c		; switch to transmit register		4
	out	(c),a		; write byte to serial port		12
	ret			; done					10

	.end
