/* f8pst.c */

/*
 * (C) Copyright 2005
 * All Rights Reserved
 *
 * Alan R. Baldwin
 * 721 Berkeley St.
 * Kent, Ohio  44240
 */

#include "asxxxx.h"
#include "f2mc8.h"

/*
 * Coding Banks
 */
struct	bank	bank[2] = {
    /*	The '_CODE' area/bank has a NULL default file suffix.	*/
    {	NULL,		"_CSEG",	NULL,		0,	0,	0,	0,	0	},
    {	&bank[0],	"_DSEG",	"_DS",		1,	0,	0,	0,	B_FSFX	}
};

/*
 * Coding Areas
 */
struct	area	area[2] = {
    {	NULL,		&bank[0],	"_CODE",	0,	0,	0,	A_1BYTE|A_BNK|A_CSEG	},
    {	&area[0],	&bank[1],	"_DATA",	1,	0,	0,	A_1BYTE|A_BNK|A_DSEG	}
};

/*
 * Basic Relocation Mode Definition
 *
 *	#define		R_NORM	0000		No Bit Positioning
 */
char	mode0[32] = {	/* R_NORM */
	'\200',	'\201',	'\202',	'\203',	'\204',	'\205',	'\206',	'\207',
	'\210',	'\211',	'\212',	'\213',	'\214',	'\215',	'\216',	'\217',
	'\220',	'\221',	'\222',	'\223',	'\224',	'\225',	'\226',	'\227',
	'\230',	'\231',	'\232',	'\233',	'\234',	'\235',	'\236',	'\237'
};

/*
 * Additional Relocation Mode Definitions
 *
 * Specification for the 3-bit CALLV addressing mode:
 */
char	mode1[32] = {	/* R_3BIT */
	'\200',	'\201',	'\202',	'\003',	'\004',	'\005',	'\006',	'\007',
	'\015',	'\016',	'\017',	'\013',	'\014',	'\015',	'\016',	'\017',
	'\020',	'\021',	'\022',	'\023',	'\024',	'\025',	'\026',	'\027',
	'\030',	'\031',	'\032',	'\033',	'\034',	'\035',	'\036',	'\037'
};

/* None Required */

/*
 *     *m_def is a pointer to the bit relocation definition.
 *	m_flag indicates that bit position swapping is required.
 *	m_mask contains the active bit positions for the output.
 *	m_mbro contains the active bit positions for the input.
 *
 *	struct	mode
 *	{
 *		char *	m_def;		Bit Relocation Definition
 *		a_uint	m_flag;		Bit Swapping Flag
 *		a_uint	m_mask;		Bit Mask
 *		a_uint	m_mbro;		Bit Range Overflow Mask
 *	};
 */
struct	mode	mode[2] = {
    {	&mode0[0],	0,	0x0000FFFF,	0x0000FFFF	},
    {	&mode1[0],	0,	0x00000007,	0x00000007	}
};

/*
 * Array of Pointers to MODE Structures
 */
struct	mode	*modep[16] = {
	&mode[0],	&mode[1],	NULL,		NULL,
	NULL,		NULL,		NULL,		NULL,
	NULL,		NULL,		NULL,		NULL,
	NULL,		NULL,		NULL,		NULL
};

/*
 * Mnemonic Structure
 */
struct	mne	mne[] = {

	/* machine */

    {	NULL,	"CSEG",		S_ATYP,		0,	A_CSEG|A_1BYTE	},
    {	NULL,	"DSEG",		S_ATYP,		0,	A_DSEG|A_1BYTE	},

    {	NULL,	".setdp",	S_SDP,		0,	0	},

	/* system */

    {	NULL,	"BANK",		S_ATYP,		0,	A_BNK	},
    {	NULL,	"CON",		S_ATYP,		0,	A_CON	},
    {	NULL,	"OVR",		S_ATYP,		0,	A_OVR	},
    {	NULL,	"REL",		S_ATYP,		0,	A_REL	},
    {	NULL,	"ABS",		S_ATYP,		0,	A_ABS	},
    {	NULL,	"NOPAG",	S_ATYP,		0,	A_NOPAG	},
    {	NULL,	"PAG",		S_ATYP,		0,	A_PAG	},

    {	NULL,	"BASE",		S_BTYP,		0,	B_BASE	},
    {	NULL,	"SIZE",		S_BTYP,		0,	B_SIZE	},
    {	NULL,	"FSFX",		S_BTYP,		0,	B_FSFX	},
    {	NULL,	"MAP",		S_BTYP,		0,	B_MAP	},

    {	NULL,	".page",	S_PAGE,		0,	0	},
    {	NULL,	".title",	S_HEADER,	0,	O_TITLE	},
    {	NULL,	".sbttl",	S_HEADER,	0,	O_SBTTL	},
    {	NULL,	".module",	S_MODUL,	0,	0	},
    {	NULL,	".include",	S_INCL,		0,	0	},
    {	NULL,	".area",	S_AREA,		0,	0	},
    {	NULL,	".bank",	S_BANK,		0,	0	},
    {	NULL,	".org",		S_ORG,		0,	0	},
    {	NULL,	".radix",	S_RADIX,	0,	0	},
    {	NULL,	".globl",	S_GLOBL,	0,	0	},
    {	NULL,	".local",	S_LOCAL,	0,	0	},
    {	NULL,	".if",		S_CONDITIONAL,	0,	O_IF	},
    {	NULL,	".else",	S_CONDITIONAL,	0,	O_ELSE	},
    {	NULL,	".endif",	S_CONDITIONAL,	0,	O_ENDIF	},
    {	NULL,	".ifdef",	S_CONDITIONAL,	0,	O_IFDEF	},
    {	NULL,	".ifndef",	S_CONDITIONAL,	0,	O_IFNDEF},
    {	NULL,	".ifgt",	S_CONDITIONAL,	0,	O_IFGT	},
    {	NULL,	".iflt",	S_CONDITIONAL,	0,	O_IFLT	},
    {	NULL,	".ifge",	S_CONDITIONAL,	0,	O_IFGE	},
    {	NULL,	".ifle",	S_CONDITIONAL,	0,	O_IFLE	},
    {	NULL,	".ifeq",	S_CONDITIONAL,	0,	O_IFEQ	},
    {	NULL,	".ifne",	S_CONDITIONAL,	0,	O_IFNE	},
    {	NULL,	".list",	S_LISTING,	0,	O_LIST	},
    {	NULL,	".nlist",	S_LISTING,	0,	O_NLIST	},
    {	NULL,	".equ",		S_EQU,		0,	O_EQU	},
    {	NULL,	".gblequ",	S_EQU,		0,	O_GBLEQU},
    {	NULL,	".lclequ",	S_EQU,		0,	O_LCLEQU},
    {	NULL,	".byte",	S_DATA,		0,	O_1BYTE	},
    {	NULL,	".db",		S_DATA,		0,	O_1BYTE	},
    {	NULL,	".fcb",		S_DATA,		0,	O_1BYTE	},
    {	NULL,	".word",	S_DATA,		0,	O_2BYTE	},
    {	NULL,	".dw",		S_DATA,		0,	O_2BYTE	},
    {	NULL,	".fdb",		S_DATA,		0,	O_2BYTE	},
/*    {	NULL,	".3byte",	S_DATA,		0,	O_3BYTE	},	*/
/*    {	NULL,	".triple",	S_DATA,		0,	O_3BYTE	},	*/
/*    {	NULL,	".4byte",	S_DATA,		0,	O_4BYTE	},	*/
/*    {	NULL,	".quad",	S_DATA,		0,	O_4BYTE	},	*/
    {	NULL,	".blkb",	S_BLK,		0,	O_1BYTE	},
    {	NULL,	".ds",		S_BLK,		0,	O_1BYTE	},
    {	NULL,	".rmb",		S_BLK,		0,	O_1BYTE	},
    {	NULL,	".rs",		S_BLK,		0,	O_1BYTE	},
    {	NULL,	".blkw",	S_BLK,		0,	O_2BYTE	},
/*    {	NULL,	".blk3",	S_BLK,		0,	O_3BYTE	},	*/
/*    {	NULL,	".blk4",	S_BLK,		0,	O_4BYTE	},	*/
    {	NULL,	".ascii",	S_ASCIX,	0,	O_ASCII	},
    {	NULL,	".ascis",	S_ASCIX,	0,	O_ASCIS	},
    {	NULL,	".asciz",	S_ASCIX,	0,	O_ASCIZ	},
    {	NULL,	".str",		S_ASCIX,	0,	O_ASCII	},
    {	NULL,	".strs",	S_ASCIX,	0,	O_ASCIS	},
    {	NULL,	".strz",	S_ASCIX,	0,	O_ASCIZ	},
    {	NULL,	".fcc",		S_ASCIX,	0,	O_ASCII	},
    {	NULL,	".define",	S_DEFINE,	0,	O_DEF	},
    {	NULL,	".undefine",	S_DEFINE,	0,	O_UNDEF	},
    {	NULL,	".even",	S_BOUNDARY,	0,	O_EVEN	},
    {	NULL,	".odd",		S_BOUNDARY,	0,	O_ODD	},
    {	NULL,	".msg"	,	S_MSG,		0,	0	},
    {	NULL,	".assume",	S_ERROR,	0,	O_ASSUME},
    {	NULL,	".error",	S_ERROR,	0,	O_ERROR	},
/*    {	NULL,	".msb",		S_MSB,		0,	0	},	*/
/*    {	NULL,	".8bit",	S_BITS,		0,	O_1BYTE	},	*/
/*    {	NULL,	".16bit",	S_BITS,		0,	O_2BYTE	},	*/
/*    {	NULL,	".24bit",	S_BITS,		0,	O_3BYTE	},	*/
/*    {	NULL,	".32bit",	S_BITS,		0,	O_4BYTE	},	*/
    {	NULL,	".end",		S_END,		0,	0	},

	/* Machines */

    {	NULL,	".f2mc8l",	S_CPU,		0,	X_8L	},
    {	NULL,	".f2mc8fx",	S_CPU,		0,	X_8FX	},

	/* F2MC8L / F2MC8FX */

    {	NULL,	"mulu",		S_AOP,		0,	0x01	},
    {	NULL,	"divu",		S_AOP,		0,	0x11	},
    {	NULL,	"rolc",		S_AOP,		0,	0x02	},
    {	NULL,	"rorc",		S_AOP,		0,	0x03	},

    {	NULL,	"mov",		S_MOV,		0,	0x00	},
    {	NULL,	"movw",		S_MOVW,		0,	0x00	},

    {	NULL,	"cmp",		S_OP,		0,	0x12	},
    {	NULL,	"addc",		S_OP,		0,	0x22	},
    {	NULL,	"subc",		S_OP,		0,	0x32	},
    {	NULL,	"xor",		S_OP,		0,	0x52	},
    {	NULL,	"and",		S_OP,		0,	0x62	},
    {	NULL,	"or",		S_OP,		0,	0x72	},

    {	NULL,	"cmpw",		S_OP,		1,	0x12	},
    {	NULL,	"addcw",	S_OP,		1,	0x22	},
    {	NULL,	"subcw",	S_OP,		1,	0x32	},
    {	NULL,	"xorw",		S_OP,		1,	0x52	},
    {	NULL,	"andw",		S_OP,		1,	0x62	},
    {	NULL,	"orw",		S_OP,		1,	0x72	},

    {	NULL,	"jmp",		S_JMP,		0,	0x21	},
    {	NULL,	"call",		S_CALL,		0,	0x31	},
    {	NULL,	"callv",	S_CALLV,	0,	0xE8	},

    {	NULL,	"pushw",	S_PUSH,		0,	0x40	},
    {	NULL,	"popw",		S_PUSH,		0,	0x50	},

    {	NULL,	"xch",		S_XCH,		0,	0x42	},
    {	NULL,	"xchw",		S_XCHW,		0,	0x43	},

    {	NULL,	"clrb",		S_BIT,		0,	0xA0	},
    {	NULL,	"setb",		S_BIT,		0,	0xA8	},

    {	NULL,	"bbc",		S_BRAB,		0,	0xB0	},
    {	NULL,	"bbs",		S_BRAB,		0,	0xB8	},

    {	NULL,	"decw",		S_DECW,		0,	0xD0	},
    {	NULL,	"incw",		S_DECW,		0,	0xC0	},

    {	NULL,	"dec",		S_DEC,		0,	0xD8	},
    {	NULL,	"inc",		S_DEC,		0,	0xC8	},

    {	NULL,	"bnc",		S_BRA,		0,	0xF8	},
    {	NULL,	"bc",		S_BRA,		0,	0xF9	},
    {	NULL,	"bp",		S_BRA,		0,	0xFA	},
    {	NULL,	"bn",		S_BRA,		0,	0xFB	},
    {	NULL,	"bnz",		S_BRA,		0,	0xFC	},
    {	NULL,	"bz",		S_BRA,		0,	0xFD	},
    {	NULL,	"bge",		S_BRA,		0,	0xFE	},
    {	NULL,	"blt",		S_BRA,		0,	0xFF	},

    {	NULL,	"bhs",		S_BRA,		0,	0xF8	},
    {	NULL,	"blo",		S_BRA,		0,	0xF9	},
    {	NULL,	"bne",		S_BRA,		0,	0xFC	},
    {	NULL,	"beq",		S_BRA,		0,	0xFD	},

    {	NULL,	"nop",		S_INH,		0,	0x00	},
    {	NULL,	"swap",		S_INH,		0,	0x10	},
    {	NULL,	"ret",		S_INH,		0,	0x20	},
    {	NULL,	"reti",		S_INH,		0,	0x30	},
    {	NULL,	"clri",		S_INH,		0,	0x80	},
    {	NULL,	"clrc",		S_INH,		0,	0x81	},
    {	NULL,	"daa",		S_INH,		0,	0x84	},
    {	NULL,	"seti",		S_INH,		0,	0x90	},
    {	NULL,	"setc",		S_INH,		0,	0x91	},
    {	NULL,	"das",		S_INH,		S_EOL,	0x94	}
};


