C
C---------------------------------------------------------------
C
C     FOLNUT IS CALLED ONCE PER INCIDENT NEUTRON TO FOLLOW THE
C     NEUTRON THROUGH THE SCINTILLATOR AND VARIOUS REACTIONS
C     ESSENTIALLY IT RETURNS ONLY  ( EL ) THE LIGHT PRODUCED
C
C     MANY SUBROUTINES THAT WERE PREVIOUSELY CODED AS SUBROUTINES
C     AND WERE CALLED FROM WITHIN FOLNUT HAVE BEEN RECODED AS
C     PART OF FOLNUT ,  THIS ELIMINATES  MANY JUMPS TO SUBROUTINE
C     AND  MUCH MEMORY SWAPPING AND OVER LAYING  ON SOME COMPUTERS
C     THE RESULTING CODE EXECUTES  FASTER
C
C-----------------------------------------------------------------
C
      SUBROUTINE FOLNUT(X,C,E ,EMIN,EL,NS)
      DIMENSION X1S(3),C1S(3)
      DIMENSION X(3),C(3), EL(7),S(10),NF(5)
      INTEGER*4 NDUMP,MDUMP
C
      COMMON /FIRSC/ NFS(6,5,2)
      COMMON /SCIN/ DHYD,DCARB,IGEO,XB,YB,ZB
      COMMON /SWBLK/ NSW(6),NDUMP,MDUMP
      COMMON /TIMING/ TBIAS,DTIM, DPOS,NTIM(100),NPOS(100)
      COMMON /CRBANG/ ED(32),AD(32,8)
      COMMON /MASS/ RM1,RM2,RM3,RM4,RM2A,QQ,RM5,RM6
C
      RM1=939.55
      RM2=11178.
      RM3=3728.3
      RM4=8394.6
      RM2A=11182.4
      QQ=-7.26
      RM5=1878.5
      RM6=10255.
      L=7
      NSMAX=10
      NS=0
      TIME=0.
      ICOUNT=0
      X0=X(1)
      DO 4 I=1,L
    4 EL(I)=0.
C
C  PREPARE TO PRINT INDIVIDUAL HISTORIES, IF DESIRED.
C
      NDUMP=NDUMP+1.
      IF (NDUMP .GT. MDUMP) GO TO 2000
      IF (NDUMP .EQ. 1.) WRITE(6,9)
    9 FORMAT(' ','DUMP OF INDIVIDUAL HISTORIES',
     1 /,' ','THE FOLLOWING VARIABLE ARE DUMPED AT EACH INTERACTION',
     1 /,' ','(SEE FOLNUT LISITNG FOR DEFINITION)',
     1 /,' ','E,EL(7),MS,ELT,(X(I),I=1,3),(C(I),I=1,3),COSL,PHI,TIME')
      WRITE(6,11) NDUMP,E
   11 FORMAT(' ','EVENT ',F5.0,5X,'INITIAL ENERGY ',F8.3,' MEV')
C
C  FIND TOTAL CROSS SECTIONS
C
 2000 CONTINUE
      IF (E .LT. EMIN) GOTO 9999
      CALL SIGTOT(E,S)
      ELT=0.
C
C  FIND DISTANCE TO NEXT SCATTER.
C  SHH AND SCC ARE THE TOTAL CROSS-SECTIONS IN HYDROGEN AND CARBON.
C  DHYD AND DCARB ARE THE NUMBER OF H AND C NUCLEI PER BARN-INCH
C
      SHH=S(1)
      SCC=S(2)+S(10)+S(7)
      PATH=1./(DHYD*SHH+DCARB*SCC)
      D=-PATH*ALOG(FNCRAN())
C
C  PROPAGATE NEUTRON A DISTANCE D.
C
      DO 20 I=1,3
   20 X(I)=X(I)+C(I)*D
      IF(INBNDS(X) .LE. 0) GOTO 9999
      NS=NS+1
      TIME=TIME+D*1.84/SQRT(E)
      IF(NS .GT. NSMAX) GOTO 9999
C
C  DECIDE WHETHER CARBON INTERACTION OCCURRED.
C
      IF(DCARB*SCC*PATH .GT. FNCRAN()) GO TO 200
C
C  ELASTIC SCATTER FROM HYDROGEN OCCURRED (REACTION CHANNEL 1)
C
      MS=1
      CALL NPNP(E,W,COSL,X,C,ELT)
      GO TO 1000
C
C  CARBON INTERACTION OCCURED.  DECIDE WHETHER ELASTIC OR INELASTIC.
C
  200 IF (S(10)/SCC .GT. FNCRAN()) GO TO 300
C
C  ELASTIC SCATTER FROM CARBON OCCURRED (REACTION CHANNEL 2)
C
      MS=2
      CALL NCEL(E,W,COSL,S(2),S(10),S(7),ELT)
C
C  W,COSL, ELT ARE DIFINED UNDER NPNP ABOVE
C
      GO TO 1000
C
C  INELASTIC CARBON INTERACTION OCCURRED.  CHOOSE WHICH.
C
  300 IF (S(3)/S(10) .LE. FNCRAN()) GO TO 400
C
C  N+C--N+C+GAMMA OCCURRED (REACION CHANNEL 3)
C
      MS=3
      CALL NCNCGM(E,W,COSL,X,C,ELT)
      GO TO 1000
  400 SR=S(4)+S(5)+S(6)+S(8)+S(9)
      U=FNCRAN()
      IF (S(4)/SR .LE. U) GO TO 500
C
C  N+C--ALPHA+9BE    OCCURRED (REACTION CHANNEL 4)
C
      MS=4
C
C  START OF NALPHA--------------------------------------------------
C
C  SIMULATE THE REACTION N+C--ALPHA+9BE
C  ISOTROPIC TWO-BODY REACTION ASSUMED.
C      DATA STATEMENT ABOVE FOR RM1-RM4
C
      CNAL=-1.+2.*FNCRAN()
      CALL KINNR(RM1,RM2,RM3,RM4,E,CNAL,VB ,WCM ,PCM ,COSL,T   )
      ELT=EEQUIV(T,X,C,COSL,4)
      GO TO 950
C
C  END OF NALPHA----------------------------------------------------
C
  500 IF((S(4)+S(5))/SR .LE. U) GO TO 600
C
C  N+C--N+THREE ALPHAS OCCURRED (REACTION CHANNEL 5)
C
      MS=5
      CALL NN3AL(E,W,COSL,X,C,ELT)
      GO TO 1000
C
C  N+C--P+12B  OCCURRED (REACTION CHANNEL 6)
C
  600 MS=6
      IF((S(4)+S(5)+S(6))/SR.LE.U) GOTO 700
      CALL NPB(E,W,COSL,X,C,ELT)
      GOTO 1000
  700 MS=6
      IF ((S(4)+S(5)+S(6)+S(8))/SR.LE.U) GOTO 800
C
C  START OF (N,2N) -------------------------------------------------
C  TREAT N2N SAME AS NPB KINEMATICALLY EXCEPT FOR THRESHOLD
C
      SQUNI=SQRT(FNCRAN())
      CALL KINNR(RM1,RM2,1882.8,RM6,E,SQUNI,VB,WCM,PCM,COSL,E)
      CALL SCATTR(C,COSL,6.2832*FNCRAN(),C1S)
      DO 9223 I=1,3
 9223 X1S(I)=X(I)
      W=E*FNCRAN()
      E=E-W
      CALL SECNUT(X1S,C1S,E,.1,ELT,NS1S)
      GOTO 1000
C
C     FOLLOW ONE NEUTRON WITH SECNUT AND THE OTHER  STAYS IN FOLNUT
C     END OF (N,2N) ------------------------------------------------
C
  800 MS=6
C  START OF NPEVAP -------------------------------------------------
  950 W=0.
      COSL=1.
C
C  INCREMENT THE ELEMENT MS=1 TO 6 OF THE LIGHT OUTPUT ARRAY ELT
C  CORRESPONDING TO THE CHANNEL OF INTERACTION, AND ELT(7),THE TOTAL
C  LIGHT OUTPUT
C
 1000 EL(MS)=EL(MS)+ELT
      EL(7)=EL(7)+ELT
      E=W
      PHI=6.2832*FNCRAN()
      MC=MS
      CALL SCATTR(C,COSL,PHI,C)
      IF(NS-2) 810,820,1100
  810 DO 802 I=1,5
  802 NF(I)=1
  820 BIAS=.125
      DO 910 I=1,5
      BIAS=BIAS*2.
      IF(NF(I))910,910,902
  902 IF (ELT-BIAS) 910,905,905
  905 NFS(MC,I,NS)=NFS(MC,I,NS)+1
      NF(I)=0
  910 CONTINUE
 1100 IF (ICOUNT  .EQ. 1) GO TO 1110
C
C  CHECK WHETHER TIMING BIAS IS EXCEEDED.
C  IF SO, SET FLAG AND INCREMENT ARRAYS.
C
      IF(ELT-TBIAS) 1110,1105,1105
 1105 ICOUNT=1
      JT=TIME/DTIM+1.
      IF(JT .GT. 100) JT=100
      IF (JT .LT. 1) JT=1
      JP=(X(1)-X0)/DPOS+50.
      IF (JP .GT. 100) JP=100
      IF(JP .LT. 1) JP=1
      NTIM(JT)=NTIM(JT)+1
      NPOS(JP)=NPOS(JP)+1
C
C  PRINT DETAILED INFORMATION FOR THIS EVENT
C
 1110 IF (NDUMP .GE. MDUMP) GO TO 2000
      WRITE(6,1) E,EL(L),MS,ELT,(X(I),I=1,3), (C(I),I=1,3),COSL,PHI
     1 ,TIME
    1 FORMAT(F6.1,3X,F6.2,I3,F6.2,3X,3F6.2,3X,3F6.2,3X,3F7.4)
      GO TO 2000
 9999 RETURN
      END

