C
C------------------------------------------------------------------
C
C     THIS SUBROUTINE IS IDENTICAL TO FOLNUT,  EXCEPT FOR A
C     MODIFICATION TO THE NPB ROUTINE.  IT IS CALLED ONLY FROM
C     THE N2N ROUTINE WITHIN FOLNUT TO FOLLOW THE PATH OF THE
C     SECOND NEUTRON THROUGH THE SCINTILLATOR.
C
C     ON SOME MACHINES THAT SUPPORT RECURSIVE CALLS TO SUBROUTINES
C     THIS SUBROUTINE  CAN BE REPLACED BY A CALL TO FOLNUT WITHIN
C     FOLNUT ITSELF,  HOWEVER CODING IN THIS FASHION ALLOWS
C     THE PROGRAM TO BE RUN ON ANY MACHINE EASILY
C
C-----------------------------------------------------------------
C
      SUBROUTINE SECNUT(X,C,E ,EMIN,EL,NS)
C
      DIMENSION X(3),C(3),S(10)
      COMMON /SCIN/ DHYD,DCARB,IGEO,XB,YB,ZB
      COMMON /TIMING/ TBIAS,DTIM, DPOS,NTIM(100),NPOS(100)
      COMMON /CRBANG/ ED(32),AD(32,8)
      COMMON /MASS/ RM1,RM2,RM3,RM4,RM2A,QQ,RM5,RM6
C
      L=7
      NSMAX=10
      NS=0
      TIME=0.
      ICOUNT=0
      X0=X(1)
C
C  FIND TOTAL CROSS SECTIONS
C
 2000 CONTINUE
      IF (E .LT. EMIN) RETURN
      CALL SIGTOT(E,S)
      ELT=0.
      EL=0.
C
C  FIND DISTANCE TO NEXT SCATTER.
C  SHH AND SCC ARE THE TOTAL CROSS-SECTIONS IN HYDROGEN AND CARBON.
C  DHYD AND DCARB ARE THE NUMBER OF H AND C NUCLEI PER BARN-INCH
C
      SHH=S(1)
      SCC=S(2)+S(10)+S(7)
      PATH=1./(DHYD*SHH+DCARB*SCC)
      D=-PATH*ALOG(FNCRAN())
C
C  PROPAGATE NEUTRON A DISTANCE D.
C
      DO 20 I=1,3
   20 X(I)=X(I)+C(I)*D
      IF(INBNDS(X) .LE. 0) RETURN
      NS=NS+1
      TIME=TIME+D*1.84/SQRT(E)
      IF(NS .GT. NSMAX) RETURN
C
C  DECIDE WHETHER CARBON INTERACTION OCCURRED.
C
      IF(DCARB*SCC*PATH .GT. FNCRAN()) GO TO 200
C
C  ELASTIC SCATTER FROM HYDROGEN OCCURRED (REACTION CHANNEL 1)
C
      MS=6
      CALL NPNP(E,W,COSL,X,C,ELT)
      GO TO 1000
C
C  CARBON INTERACTION OCCURED.  DECIDE WHETHER ELASTIC OR INELASTIC.
C
  200 IF (S(10)/SCC .GT. FNCRAN()) GO TO 300
C
C  ELASTIC SCATTER FROM CARBON OCCURRED (REACTION CHANNEL 2)
C
      CALL NCEL(E,W,COSL,S(2),S(10),S(7),ELT)
C
C  W,COSL,ELT ARE DIFINED UNDER NPNP ABOVE
C
      GO TO 1000
C
C  INELASTIC CARBON INTERACTION OCCURRED.  CHOOSE WHICH.
C
  300 IF (S(3)/S(10) .LE. FNCRAN()) GO TO 400
C
C  N+C--N+C+GAMMA OCCURRED (REACION CHANNEL 3)
C
      CALL NCNCGM(E,W,COSL,X,C,ELT)
      GO TO 1000
  400 SR=S(4)+S(5)+S(6)+S(8)+S(9)
      U=FNCRAN()
      IF (S(4)/SR .LE. U) GO TO 500
C
C  N+C--ALPHA+9BE    OCCURRED (REACTION CHANNEL 4)
C  START OF NALPHA --------------------------------------------------
C  SIMULATE THE RACTION N+C--ALPHA+9BE
C  ISOTROPIC TWO-BODY REACTION ASSUMED.
C
      CNAL=-1.+2.*FNCRAN()
      CALL KINNR(RM1,RM2,RM3,RM4,E,CNAL,VB ,WCM ,PCM ,COSL,T   )
      ELT=EEQUIV(T,X,C,COSL,4)
      GO TO 950
C
C  END OF NALPHA----------------------------------------------------
C
  500 IF((S(4)+S(5))/SR .LE. U) GO TO 600
C
C  N+C--N+THREE ALPHAS OCCURRED (REACTION CHANNEL 5)
C
      CALL NN3AL(E,W,COSL,X,C,ELT)
      GO TO 1000
C
C  N+C--P+12B  OCCURRED (REACTION CHANNEL 6)
C
 600  CALL NPB(E,W,COSL,X,C,ELT)
      IF((S(4)+S(5)+S(6))/SR.LE.U) GOTO 950
      GOTO 1000
  950 W=0.
      COSL=1.
C
C  INCREMENT THE ELEMENT MS=1 TO 6 OF THE LIGHT OUTPUT ARRAY ELT
C  CORRESPONDING TO THE CHANNEL OF INTERACTION, AND ELT(7),THE TOTAL
C  LIGHT OUTPUT
C
 1000 EL=EL+ELT
      E=W
      PHI=6.2832*FNCRAN()
      CALL SCATTR(C,COSL,PHI,C)
      IF (ICOUNT  .EQ. 1) GO TO 2000
C
C  CHECK WHETHER TIMING BIAS IS EXCEEDED.
C  IF SO, SET FLAG AND INCREMENT ARRAYS.
C
      IF(ELT-TBIAS) 2000,1105,1105
 1105 ICOUNT=1
      JT=TIME/DTIM+1.
      IF(JT .GT. 100) JT=100
      IF (JT .LT. 1) JT=1
      JP=(X(1)-X0)/DPOS+50.
      IF(JP .GT. 100) JP=100
      IF(JP .LT. 1) JP=1
      NTIM(JT)=NTIM(JT)+1
      NPOS(JP)=NPOS(JP)+1
      END

