1	!

	!	P I C T R E


2!		PROGRAM		: PICTRE
5!		VERSION		: VO6C
6!		EDIT		: 03
7!		EDIT DATE	: 15-JAN-78
8!
9!		AUTHOR		: JOHN CISAR

10	NO EXTEND
11	!


	!	C O P Y R I G H T


   !  	      Copyright  1979 by
   !		   John Cisar
   !
   !		Omaha South High
   !		Omaha, Nebraska


20	!

	!	M O D I F I C A T I O N    H I S T O R Y

21!	VER/ED		EDIT DATE		REASON






100	!

	!	G E N E R A L    D E S C R I P T I O N

110!
   !		     PICTRE  was   designed   to   help   in   the
   !		formulation  of posters and certain types of text.
   !		It is divided  into  three  parts:   creating  the
   !		picture,  and  its resultant command file, for the
   !		first time;   running    an   already  established
   !		command   file;    and   restarting   an   already
   !		established command file.
   !	
   !		     PICTRE creates two files; a command file, and
   !		the  picture  file,  the  user  has  the option of
   !		specifying the names he  wishes  for  both  files,
   !		except  for  the first time through, in which case
   !		the command  file  is  given  a  default  name  of
   !		'COMAND.DAT'.

120!
   !
   !				Usage
   !
   !
   !		     To run the PICTRE program, type:
   !
   !			RUN! PICTRE
   !
   !		     After prining its header, PICTRE asks:
   !
   !			Do you want to continue a command file? [/H for help]
   !
   !		     Respond with YES or NO (Y or N  is  suffic-
   !		ient).  if the user responds with a YES, no add-
   !		ition to the command file will be taking  place.
   !		After answering, PICTRE asks:

130!			  Enter command file name---
   !		
   !		     Respond with the command file name.   If  the
   !		user  hits  carriage  return,  the default command
   !		file,  'COMAND.DAT'  is  used.   If  no  extension
   !		('.EXT')  is  specified, the program automatically
   !		assumes an extension of '.DAT',  and  concatenates
   !		it  with  the  first six letters of the name typed
   !		in.  PICTRE will then ask:
   !
   !			  At which line---
   !
   !		     Respond with the line number the user  wishes
   !		to begin typing at.  PICTRE automatically adds all
   !		the lines which occur before the line  number  the
   !		user types in to the new command file, should that
   !		be different from  the  default  of  'COMAND.DAT'.
   !		PICTRE will then generate line numbers as it would
   !		if creating a file for the first time.
   !
   !		     Should the user respond  with  a  NO  to  the
   !		first question, PICTRE would ask:

140!			  Do you have a command file to be printed?  (Y or N)
   !
   !		     Respond  with  YES  or  NO   (Y   or   N   is
   !		sufficient).  if  the user responds with a YES, no
   !		addition to the command file will be taking place.
   !		After answering, PICTRE asks:
   !
   !			  Type in picture file name---
   !
   !		     The  user  now  types  in  the  name  of  his
   !		picture.    The   user  also  has  the  option  of
   !		directing  output  to  his,  or   another   unused
   !		terminal.  He merely specifies which by typing KB:
   !		or KBn:   where  n  is  another  keyboard  number.
   !		Again,   the   default  extension  (unless  KB  is
   !		specified) is '.DAT'. If the user has answered  NO
   !		to  the  previous  two  questions, PICTRE would be
   !		creating a picture for the first time.   As  such,
   !		PICTRE  would  print  all  command  lines  to  the
   !		command file 'COMAND.DAT' (default for  the  first
   !		time  through)  and  place  the  executed  command
   !		statements in file '??????.???' (the name the user
   !		types in).
   !
   !		     However, something different happens when the
   !		user  responds with a YES to question two.  PICTRE
   !		first asks:

150!			  Enter the name of the command file---
   !
   !		     Respond with a name or  carriage  return.   A
   !		carriage return signifies the default command file
   !		'COMAND.DAT'.  Again,  the  default  extension  is
   !		'.DAT'.   After   the   command   file   has  been
   !		determined,  PICTRE  takes  the   command   lines,
   !		executes them, and prints them to the picture file
   !		specified by the user.  In this  routine,  the  KB:
   !		option  is  most  used.   After completion of this
   !		routine, PICTRE signifies its end by printing:
   !
   !			  Finished
   !
   !		     Any other aspect  of  the  program,  such  as
   !		creating a file for the first time, or adding onto
   !		a previously created file, can be exited  from  by
   !		typing a Control-C or Control-Z combination.
   !
   !		     It should be noted that when exiting from the
   !		program,  all files are closed, so some extraneous
   !		material may be  included  in  some  files.   User
   !		discretion  should  be used as to the optimum time
   !		to exit.

160!
   !
   !				Error Messages
   !
   !		LINE TOO LONG
   !			     the user has put in too long  of  a
   !			line, program restarts at that point.
   !
   !		ILLEGAL FILE NAME--THE DEFAULT EXTENSION IS '.DAT'
   !			     The user has typed  in  an  illegal
   !			file name, program restarts at input  of
   !			illegal file-name.
   !
   !		Finished
   !			     User has typed in a  Control-C   or
   !			Control-Z combination.


300	!


	!	I / O    C H A N N E L S

305!	CHANNEL #		USED FOR
   !	------- -		---- ---

310!	    1		KB: Assignment
   !	    2		Picture file-executed command statements
   !	    3		Command file, or 'TEMP.TMP' when the addition 
   !			option is used.
   !	    4		Command file-used only when the addition
   !			option is in effect.
   !	    5		Used to output instructions ('PICTRE.HLP').


400	!


	!	V A R I A B L E    D E F I N I T I O N S


405!	VARIABLE NAME		USED FOR
   !	-------- ----		---- ---

410!	A$		Universal throughout the program for picture file
   !			name.
   !	A2$
   !	A3$
   !	A4$		Work variables.
   !	A5$
   !    A6$
   !	D$		Contains the format for the print using statement.
   !	N$()		Holds the individual characters of the command string.
   !	S$		Universal for the command statement string.
   !	S%		Switch for individual ASCII character of N$().
   !	S1$		Test string in printing of an already established file.
   !	T%		
   !	T2%
   !    T4%		Work variables.
   !	T5%
   !	T6%
   !	X$		String used for holding the value of the number of 
   !			times the character is to be printed.
   !	X%		Universal for the line number.


800	!


	!	F U N C T I O N / S U B R O U T I N E    D E S C.


805!	FUNCTION/SUBROUTINE			USE
   !	-------------------			---

810!	FNA$() [Line 5010]		Determines whether or not dot "." is
   !					in user inputted file name.  If not 
   !					found, '.DAT' extension is added, other-
   !					wise the name is left alone.


900	!


	!	D I M E N S I O N    S T A T E M E N T S

901	DIM N$(257%)
		! Individual characters of command statement are 
		! read into this string.


998	!


	!	M A I N   C O D I N G    A R E A

999	I$="VO6C-03"
		! Set up version/edit number.

1000	PRINT
	\PRINT "PICTRE   VERSION #1  ";I$;"  BY JOHN CISAR ";
	\PRINT "Poster Program ";DATE$(0%);"   ";TIME$(0%)
		! Prints a blank line, and the
		! system header.

1010	Z$=SYS(CHR$(6%)+CHR$(-7%))
		! Allows Control-C trapping.

1020	ON ERROR GOTO 19000
		! Set up standard error routine.

1030	X$=""
	\ X%=1%
	\ T2%,T4%=0%
		! Setting up default values.

1040	PRINT
	\ OPEN "KB:" AS FILE #1%
	\ PRINT "Do you want to continue a command file? [/H for help] ";
	\ INPUT #1%,A4$
		! First question asked.

1050	IF LEFT(A4$,1%)="/" THEN GOSUB 10000 ELSE
	IF LEFT(A4$,1%)="Y" THEN 1240 ELSE 1070
		! Finding answer to first question
		! then branching to the appropriate
		! part.

1060	GOTO 1040
		! This line is executed only if
		! the '/HELP' option is used in
		! the first question.

1070	INPUT #1%, "Do you have a command file to be printed? (Y or N) ";A2$
	\INPUT #1%,"Type in picture file name---";A$
		! Asks questions two and three
		! respectively.

1080	IF LEFT(A$,2%)="KB" AND INSTR(0%,A$,":")>0% THEN 1100
		! Checks to see if output is to
		! users's terminal (or another
		! unused one).

1090	A$=FNA$(A$)
		! This line is executed if answers 
		! to first two questions was 'NO', 
		! and 'KB' was not specified in last
		! question.

1100	OPEN A$ AS FILE #2%
		! This opens the picture file.

1110	IF LEFT(A2$,1%)="Y" THEN 1290
		! Checking for answer to second question
		! if 'YES' then branching to print option.

1120	OPEN "COMAND.DAT" AS FILE #3%
	\PRINT "Your command file will be 'COMAND.DAT'.  Now enter"
	\PRINT "each line of programming, the number of  the  line"
	\PRINT "will appear to the right (^C to exit)."
		! Opens command file, first time
		! through the program, and prints
		! introductory phrase.

1130	D$=STRING$(6%,35%)
	\PRINT USING D$,X%;
	\PRINT ") ";
	\INPUT LINE #1%,S$
	\S$=CVT$$(S$,4%)
	\PRINT #3%, USING D$,X%;
	\PRINT #3%,") ";S$
		! Inputs command line from user terminal
		! and sets parameters for print-using
		! statement.

1140	IF T6%=1% THEN X%=X%+1%
	\GOTO 1130
		! Tests to see if the continue
		! option is in effect.

1150	IF S$="" THEN 1220
		! Testing to see if inputted line
		! is a blank line.

1160	FOR T%=1% TO LEN(S$)
	\N$(T%)=NUM1$(ASCII(MID(S$,T%,1%)))
	\IF VAL(N$(T%))>47% AND VAL(N$(T%))<59% THEN S3%=1% ELSE S3%=0%
		! Determines if character is a number or
		! symbol to be printed. If it is,
		! sets switch telling so.

1170	IF S3%=1% THEN X$=X$+CHR$(VAL(N$(T%)))
	\GOTO 1200
		! Checks to see if switch is on. If
		! it is, the number of times the
		! character is to be printed is determined.

1180	IF X$="" THEN X$="1"
		! Tests to see if there is a number, or if
		! there isn't, sets default value of 1.

1190	B$=STRING$(VAL(X$),VAL(N$(T%)))
	\PRINT #2%,B$;
	\X$=""
		! If the number in front of the character
		! to be printed is absent, program assumes
		! a value of 1 [Line 1180], then makes the 
		! string of the particular character, and
		! resets varaibles to 'off' position.

1200	NEXT T%
		! Terminating loop execution.

1210	IF T2%=1% THEN 1320
		! Tests to see if printing option is
		! in effect.

1220	PRINT #2%
	\X%=X%+1%
	\GOTO 1130
		! Starting new line in first run
		! through mode.

1230	!


	!	C O N T I N U I N G    R O U T I N E


1240	T6%=1%
	\INPUT #1%,"Enter command file name---";A5$
	\INPUT #1%,"At which line---";A6$
	\IF A5$="" THEN A5$="COMAND.DAT"
	\GOTO 1250
		! First and second questions are asked in
		! the continue option.  Also, default command
		! file is checked.

1250	A5$=FNA$(A5$)
		! This line is executed only if the
		! default command file is not used, or
		! if no extension is on the user inputted
		! command file name.

1260	OPEN A5$ AS FILE #4%
	\OPEN "TEMP.TMP" AS FILE #3%
	\FOR T5%=1% TO VAL(A6$)-1%
	\INPUT LINE #4%,S$
	\S$=CVT$$(S$,4%)
	\PRINT #3%,S$
	\NEXT T5%
		! Opening up a temporary file to
		!	input all commands
		!	occuring before the line
		!	number the user types in.

1270	X%=VAL(A6$)
	\CLOSE #4%
	\KILL A5$
	\NAME "TEMP.TMP" AS A5$
	\GOTO 1130
		! Finishes last steps in continue
		! option, goes to execution of
		! command statement routine.

1280	!


	!	P R I N T I N G   R O U T I N E


1290	T2%=1%
	\INPUT #1%,"Enter the name of the command file---";A3$
	\IF A3$="" THEN A3$="COMAND.DAT"
	\GOTO 1310
		! Checks for default command file name.

1300	A3$=FNA$(A3$)
		! This line is executed only if the
		! default command file is not used.

1310	OPEN A3$ AS FILE #3%
		! First question is asked in printing
		! of an already established file option.

1320	INPUT LINE #3%,S$
	\S1$=MID(S$,9%,1%)
	\IF ASCII(S1$)=13% OR ASCII(S1$)=10% THEN T4%=1% ELSE T4%=0%
		! Inputs a string starting from
		! the beginning of the command file, 
		! executes the string, after checking to
		! see if it's a blank line, then outputs
		! the result to the picture file name.

1330	IF T4%=1% THEN PRINT #2% ELSE S$=RIGHT(S$,9%)
	\GOTO 1160
		! Checks to see if there is a command
		! statement, then if there is, branches to
		! execute portion of program.

1340	GOTO 1320
		! If line was blank, goes and
		! retrieves another line.

5000	!


	!	F U N C T I O N S



5010	DEF FNA$(A$)
	\IF INSTR(0%,A$,".")=0% THEN FNA$=A$+".DAT" ELSE FNA$=A$

5020	FNEND
		! Function ends.

10000	!


	!	S U B - R O U T I N E S



10010	OPEN 'PICTRE.HLP' AS FILE #5%
	\PRINT"Note:"
	\PRINT"      For your files, these instructions can"
	\PRINT"be obtained using 'PIP' (should you desire"
	\PRINT"a clean copy).  Merely type 'PIP !PICTRE.HLP'."
		! Message to user.

10020	INPUT LINE #5%,S$
	\S$=CVT$$(S$,4%)
	\PRINT S$
	\GOTO 10020
		! Prints 'PICTRE.HLP'.

10030	CLOSE #5%
	\RETURN
		! Returns to original question.

18999	!


	!	E R R O R    H A N D L I N G


19000	IF ERR=47% AND ERL=1140% THEN PRINT "LINE TOO LONG"
	\RESUME 1140
		! If a line longer than 257 characters 
		! is input, program restarts at the line
		! number where it was too long.

19010	IF ERR=2% AND ERL=1100 THEN RESUME 1070 ELSE
	IF ERR=2% AND ERL=1260 THEN RESUME 1240 ELSE
	IF ERR=2% AND ERL=1290 THEN RESUME 1290
		! Resumes at execution of illegal file input.

19020	IF ERR=11% AND ERL=1260 THEN RESUME 1270 ELSE
	IF ERR=11% AND ERL=10020 THEN RESUME 10030
		! Two aspects of the end of data option,
		! used in the gosub and the printing option.

19025	IF ERR=10% AND ERL=1070 THEN RESUME 1070
		! Just in case user types in a carriage
		! return when inputting a picture file
		! name.

19030	PRINT "Finished"
	\CLOSE #1%,#2%,#3%
		! Any other error will also cause
		! execution of this line.

32767	END


