1	!



		A C O U N T . B A S 



	!


10	!

		PROGRAM		: ACOUNT.BAS
		VERSION		: 6C
		EDIT		: 03

		AUTHOR		: JIM GREGORY
		INSTALLATION	: WITTENBERG UNIVERSITY

		DATE		: 18-Aug-78


	!

20	!
	****************************************************************
	*                                                              *
	*            M O D I F I C A T I O N    H I S T O R Y          *
	*                                                              *
	****************************************************************


	!
21	!
	EDIT		DATE		REASON



	!

100	!
	****************************************************************
	*                                                              *
	*             P R O G R A M    D E S C R I P T I O N           *
	*                                                              *
	****************************************************************


	!
120	!

		THIS PROGRAM PRODUCES A VARIETY OF REPORTS OF SYSTEM USAGE
	BASED UPON USER INPUT OPTIONS.  IT WILL PROVIDE MORE INFORMATION IN
	AN EXPANDED FORMAT THAN THE $MONEY PROGRAM.

		REPORTS MAY BE PRINTED USING DATA FROM A PREVIOUS RUN OR
	NEW DATA MAY BE REQUESTED. ( NEW DATA WILL DESTROY THE OLD VALUES ).
	IF NEW DATA IS DESIRED, THE USER HAS THE OPTION OF RESETING THE
	SYSTEM VALUES TO 0.  IT IS RECOMMENDED THAT THIS PROGRAM BE RUN
	ONCE A WEEK WITH THE RESET OPTION SO THAT THE SYSTEM DATA FIELDS
	WILL NOT OVERFLOW.

		TWO MAJOR OPTIONS ARE AVAILABLE FOR REPORTING, THE PROJECT
	SUMMARY AND INDIVIDUAL REPORTING.  THE PROJECT SUMMARY GIVES TOTAL
	VALUES COLLECTED FOR ALL ACCOUNTS WITHIN EACH PROJECT WITH SYSTEM
	TOTALS AT THE END AND A WEEKLY/YEARLY % OF GROWTH OR DECLINE.

		THE INDIVIDUAL ACCOUNT OPTION ALLOWS SELECTIVE OR TOTAL 
	PRINT OUT OF INFORMATION FOR EACH INDIVIDUAL ACCOUNT WITHIN EACH
	PROJECT.  IF SELECTIVE, THE PROGRAM WILL PRINT OUT A REPORT OF ALL
	ACCOUNTS WITHIN THE SELECTED PROJECT.

		THE HEADING CONTAINS THE TIME FRAME OVER WHICH THE DATA HAS
	BEEN COLLECTED.  


	!



300	!
	****************************************************************
	*                                                              *
	*                    I / O    C H A N N E L S                  *
	*                                                              *
	****************************************************************


	!
320	!


	CHANNEL		FILE

	    #1		ACOUNT.FL1	INDIVIDUAL ACCOUNT DATA
	    #2		ACOUNT.FL2	PROJECT DATA
	    #3		ACOUNT.FL3	DESCRIPTIVE AND SYSTEM TOTAL DATA
	    #4		OUTPUT REPORT FILE



	!

400	!
	****************************************************************
	*                                                              *
	*                  V A R I A B L E S    U S E D                *
	*                                                              *
	****************************************************************


	!
420	!

		NUMERIC VARIABLES

	ACNTS(1800,8)		ACCOUNT ARRAY
		ACNTS(0,0)	TOTAL # OF ACCOUNTS
		ACNTS(I,0)	UNUSED
		ACNTS(I,1)	PROGRAMMER #
		ACNTS(I,2)	PROJECT #
		ACNTS(I,3)	CPU TIME IN TENTHS OF SECONDS
		ACNTS(I,4)	CONNECT TIME
		ACNTS(I,5)	KCT'S
		ACNTS(I,6)	DEVICE TIME
		ACNTS(I,7)	DISK OWNED
		ACNTS(I,8)	DISK QUOTA

	C%			DUMMY COUNTER

	I%			ROW POINTER IN ARRAYS AND FOR/NEXT LOOP COUNTER
	J%			COLUMN POINTER IN ARRAYS
	K%			COLUMN POINTER IN ARRAYS
	LN.CNT%			PRINTED LINE COUNTER

	M%(I)			SYS CALL ARRAY

	PROJ%			INPUT VARIABLE FOR PROJECT #
	PRJ.IND%		PROJECT OR INDIVIDUAL SWITCH

	PRO8.TOTS(255,J)	PROJECT TOTALS ARRAY
		PROJ.TOTS(0,0)	TOTAL # OF PROJECTS
		PROJ.TOTS(I,0)	UNUSED
		PROJ.TOTS(I,1)	TOTAL # OF ACCOUNTS IN PROJECT
		PROJ.TOTS(I,2)	PROJECT #
		PROJ.TOTS(I,3)	CPU TIME
		PROJ.TOTS(I,4)	CONNECT TIME
		PROJ.TOTS(I,5)	KCT'S
		PROJ.TOTS(I,6)	DEVICE TIME
		PROJ.TOTS(I,7)	DISK OWNED
		PROJ.TOTS(I,8)	DISK QUOTA
		PROJ.TOTS(0,J)	THE 0 ROW CONTAINS SYSTEM TOTALS

	RESET%			RESET SWITCH

	TOTS(5,8)		WEEKLY SYSTEM TOTALS
		TOTS(0,J)	BASE VALUES FOR COMPARISON & % INCREASE
		TOTS(1,J)	PREVIOUS WEEK'S VALUES
		TOTS(2,J)	THIS WEEK'S VALUES ( VALUES FROM LAST RESET )
		TOTS(3-5,J)	NOT USED

	T			DUMMY USED TO CALCULATE HOURS/MINS/SECS
	T%			DUMMY USED TO CALCULATE HOURS/MINS/SECS
	T0			DUMMY USED TO CALCULATE HOURS/MINS/SECS
	X			DUMMY USED IN FUNCTIONS
	Y			DUMMY USED IN FUNCTIONS

	!


480	!

		ALPHABETIC VARIABLES


	D$		DETAIL LINE
	D1$ - D8$	DUMMYS USED IN FORMATTINE DETAIL LINE
	F9$		DUMMY IN FORMAT FUNCTION
	H$		HEADING
	M$		INPUT AND SYS CALL DUMMY
	P1$		DUMMY TO SET % VALUES INTO
	PPN$		ACCOUNT FILES ARE STORED IN
	S$		SPACER VARIABLE = SPACES
	S9$		SPACER VARIABLE = SPACES
	

	MISC$(I)		MISC STRINGS
		MISC$(0)	FIRST WEEK OF RUNNING   ( BASE LINE WEEK FOR %'S )
		MISC$(1)	BEGINING DATE AND TIME OF REPORT PERIOD
		MISC$(2)	ENDING   DATE AND TIME OF REPORT PERIOD
		MISC$(3)	DISK UNIT TO GET ACCOUNTING DATA FOR
		MISC$(4-10)	NOT USED

	PRJ.NAME$(I)		PROJECT NAMES - AN ENTRY OF 'END' TERMINATES
					THE LIST OF VALID PROJECTS
					THE 0 ELEMENT CONTAINS 'SYSTEM TOTAL'


	!


800	!
	****************************************************************
	*                                                              *
	*      F U N C T I O N S    A N D    S U B R O U T I N E S     *
	*                                                              *
	****************************************************************


	!
820	!

		SUBROUTINES

		11000		SUMMATION REPORT BY PROJECTS
		12000		INDIVIDUAL ACCOUNTS ROUTINE
		14100		HEADING FOR INDIVIDUAL ACCOUNTS
		14200		REPORT HEADING
		14500		DECODE ACCOUNTING DATA
		14700		FORMAT AND PRINT DETAIL LINE FOR INDIVIDUAL



	!


860	!

		FUNCTIONS

		FNPRJ.NAME$		GET PROJECT NAME
		FNPRCNT.TOT$(X,Y)	% TO TOTAL USAGE
		FNPRCNT.INCRSE$(X,Y)	% INCREASE OVER BASE VALUES
		FNJOB.SIZE$(X,Y)	AVERAGE JOB SIZE ( KCT'S/CPU TIME )
		FNFORMAT$		FORMAT VALUES FOR DETIAL LINE PRINT OUT


              
	!


900	!
	****************************************************************
	*                                                              *
	*                 P R O G R A M    S E T    U P                *
	*                                                              *
	****************************************************************


	!
910	  ON ERROR GOTO 19000
	\ EXTEND
	\ T$  =  'ACCOUNTING DUMP  '
	\ Z1$ = CHR$(155%) + "H" + CHR$(155%) + "J"
	!


920	  P1$ = SPACE$(16%)
	\ D1$ = SPACE$(10%)
	\ D2$ = SPACE$(2%)
	\ D3$ = SPACE$(3%)
	\ D4$ = SPACE$(4%)
	\ D5$ = SPACE$(5%)
	\ D6$ = SPACE$(6%)
	\ D8$ = SPACE$(8%)
	!
		SET UP CONSTANT LENGTH FIELDS FOR LSET AND RSET TO
		MOVE DATA INTO WITHOUT CHANGING FIELD LENGTH FOR
		FORMATTING OF OUTOUT LINE
	!


940	  DIM M%(30%)
	\ PPN$ = '[1,7]'
	\ RESET% = 0%
	!


990	  PRINT Z1$;
	\ E$ = SYS(CHR$(6%) + CHR$(9%) + CHR$(0%))
	\ E% = INSTR(3%,E$,CHR$(0%))
	\ J% = ASCII(E$)/2%
	\ K% = ASCII(RIGHT(E$,2%))/2%
	\ E$ = MID(E$,3%,E%-3%)
	\ PRINT
	\ PRINT T$;'  ';E$;' JOB =  ';J%;'  KB =  ';K%
	\ PRINT
	!

	PRINT HEADER ROUTINE
	!



1000	!
	****************************************************************
	*                                                              *
	*                   M A I N L I N E    C O D E                 *
	*                                                              *
	****************************************************************


	!
1100	  OPEN PPN$ + 'ACOUNT.FL1' AS FILE 1%
	\	DIM #1%, ACNTS(1800%,8%)
	\ OPEN PPN$ + 'ACOUNT.FL2' AS FILE 2%
	\	DIM #2%, PROJ.TOTS(255%,8%)
	\ OPEN PPN$ + 'ACOUNT.FL3' AS FILE 3%
	\	DIM #3%, TOTS(5%,8%), PRJ.NAME$(255%)=16%, MISC$(10%)=16%
	!
		ACNTS()		INDIVIDUAL ACCOUNTS DATA
		PROJ.TOTS()	PROJECT TOTALS DATA
		TOTS()		SYSTEM TOTALS DATA
		PRJ.NAME$()	NAMES OF ALL VALID PROJECTS
		MISC$()		MISCELLANIOUS STRINGS
	!


1220	  PRINT
	\ PRINT
	\ PRINT 'Output File Name <KB:> ';
	\ INPUT LINE M$
	\ M$ = 'KB:ACOUNT.OUT' IF LEN( CVT$$(M$,-1%) ) = 0%
	\ OPEN M$ FOR OUTPUT AS FILE 4%
	\ PRINT
	\ INPUT 'Use Old Data <YES> ';M$
	\ GOTO 3000 IF ASCII(M$) <> 78%
	\ PRINT
	\ INPUT 'Reset <NO> ';M$
	\ RESET% = 1% IF ASCII(M$) = 89%
	\ PRINT
	\ INPUT 'Disk <SYSTEM> ';M$
	\ CHANGE SYS( CHR$(6%) + CHR$(-10%) + M$ ) TO M%
	\ IF M%(26%) THEN
		MISC$(3%) = CHR$(M%(23%)) + CHR$(M%(24%)) +CHR$(M%(25%)+48%)+':'
	  ELSE	MISC$(3%) = 'SYSTEM'
	!

		GET OUTPUT FILE
		DETERMINE USE OLD OR NEW DATA IF OLD THEN SKIP GATHERING
			THE INFORMATION
		IF NEW THEN ASK IF RESET AND GET DEVICE AND FORMAT 
			DEVICE NAME FOR HEADING
	!


1260	  MAT ACNTS = ZER
	\ MAT PROJ.TOTS = ZER
	\ ACNTS(0%,I%),PROJ.TOTS(0%,I%) = 0 FOR I% = 0% TO 8%
	\ MISC$(2%) = DATE$(0%) + '  ' + TIME$(0%)
	\ J% = 0%
	!
		ZERO MATRICES
		SET UP ENDING DATE FOR REPORT HEADING H$
	!

1280	  FOR I% = 1% TO 1800%
	\	M%(0%) = 30%
	\	M%(1%) = 6%
	\	M%(2%) = 14%
	\	M%(3%) = I%
	\	M%(4%) = SWAP%(I%)
	\	M%(5%) = RESET%
	\	M%(6%) = RESET%
	\	CHANGE M% TO M$
	\	CHANGE SYS(M$) TO M%
	\	GO SUB 14500
	\ NEXT I%
	!	SET UP SYSCALL LOOP TO GET ACCOUNTING
			DATA FOR ALL ACCOUNTS
		THEN DECODE THE DATA

		ERR = 5 GENERATED WHEN ALL ACOUNTS HAVE BEEN READ
			AND RESUME AT 2000 FROM ERROR ROUTINE

	!


2000	!	ROUTINE FOR SUMMATIONS BY PROJECT
		ENTERED FROM ERROR ROUTINE AT 19050
	!
2020	  PROJ.TOTS(I%,2%) = VAL( LEFT(PRJ.NAME$(I%),3%) ) FOR I% = 1%
				UNTIL LEFT(PRJ.NAME$(I%),3%) = 'END
	\ PROJ.TOTS(0%,0%) = I% - 1%
	!
		SET UP PROJ.TOTS() WITH ALL THE VALID PROJECTS
		PUT # OF PROJECTS INTO PROJ.TOTS(0,0)
	!


2040	  FOR J% = 1% TO ACNTS(0%,0%)
	\	I% = 1%
	\	I% = I% + 1% UNTIL PROJ.TOTS(I%,2%) = ACNTS(J%,2%)
	\		PROJ.TOTS(0%,K%) = PROJ.TOTS(0%,K%) + ACNTS(J%,K%) FOR K% = 3% TO 8%
	\		PROJ.TOTS(I%,K%) = PROJ.TOTS(I%,K%) + ACNTS(J%,K%) FOR K% = 3% TO 8%
	\		PROJ.TOTS(I%,1%) = PROJ.TOTS(I%,1%) + 1 
	\ NEXT J%
	!
	!	GET INDIVIDUAL ACCOUNT INFO
		FIND PROJECT SLOT IN PROJECT ARRAY
		ADD EACH ACCOUNT TO SYSTEM TOTAL KEPT IN PROJ.TOTS(0%,K%)
		ADD EACH ACCOUNT TO APPROPRIATE PROJECT TOTALS
		INCREMENT ACCOUNT COUNTERS IN PROJ.TOTS(I%,1%)
	!
2060	  IF RESET% THEN 
		TOTS(1%,J%) = TOTS(2%,J%) FOR J% = 3% TO 8%
	\	TOTS(2%,J%) = PROJ.TOTS(0%,J%) FOR J% = 3% TO 8%
	!
		IF RESET SWITCH ON THEN COPY VALUES FROM LAST RESET
			INTO TOTS(1,J) THEN SET TOTS(2,J) TO CURRENT
			PROJECT TOTALS
	!


3000	  GOSUB 14200
	\ MISC$(1%) = MISC$(2%) IF RESET% = 1%
	!
		RESET BEGINING DATE TO LAST ENDING DATE IF
		RESET SWITCH ON
	!
3020	  PRINT
	\ INPUT 'Project Summery or Individual Acoounts ( 1 OR 2 ) ';PRJ.IND%
	\ PRJ.IND% = 1% IF PRJ.IND%<>2%
	\ ON PRJ.IND% GOSUB 11000, 12000
	\ GOTO 3020
	!


10000	!
	****************************************************************
	*                                                              *
	*                     S U B R O U T I N E S                    *
	*                                                              *
	****************************************************************


	!
11000	!
	******  SUMMATION REPORT BY PROJECTS  ******
	!



11100	  S$ = '   '
	\ PRINT #4%
	\ PRINT #4%
	\ PRINT #4%,  TAB(26%);H$
	\ PRINT #4%
	\ PRINT #4%
	\ PRINT #4%,  TAB(56%);'SUMMATION BY PROJECTS   ( ';PROJ.TOTS(0%,0%);' PROJECTS )'
	\ PRINT #4%
	\ PRINT #4%,	TAB(18%);'HH:MM:SS.S';TAB(38%);'HHH:MM';TAB(71%);'HHH:MM';
	\ PRINT #4%,  TAB(85%);'DISK';TAB(106%);'DISK';TAB(120%);'AVG   #'
	\ PRINT #4%,  '  PROJECT';TAB(23%);'CPU';TAB(30%);'% ALL';TAB(37%);
		      'CONNECT   % ALL';TAB(55%);"KCT'S    % ALL";TAB(71%);
		      'DEVICE % ALL';TAB(85%);'USED   % DSK  % QUO';
		      TAB(106%);'QUOTA  % DSK';TAB(120%);'JOB ACT'
	\ PRINT #4%
	!

		PRINT OUT HEADERS
	!


11120	  FOR I% = 1% TO PROJ.TOTS(0%,0%)
	\	D$ = FNPRJ.NAME$
	\	D$ = D$ + '  ' + FNFORMAT$(PROJ.TOTS(I%,K%),PROJ.TOTS(0%,K%)) FOR K% = 3% TO 8%
	\	D$ = D$ + '  ' + FNJOB.SIZE$(PROJ.TOTS(I%,5%),PROJ.TOTS(I%,3%)) + '  '
	\	RSET D3$ = NUM1$(PROJ.TOTS(I%,1%))
	\	D$ = D$ + D3$
	\	PRINT #4%, D$
	\ NEXT I%
	\ PRINT #4%
	\ PRINT #4%
	!



11140	  RSET P1$ = PRJ.NAME$(0%)
	\ D$ = P1$
	\ D$ = D$ + '  ' + FNFORMAT$(PROJ.TOTS(0%,K%),PROJ.TOTS(0%,K%)) FOR K% = 3% TO 6%
	\ RSET D6$ = NUM1$(PROJ.TOTS(0%,7%))
	\ D$ = CVT$$(D$,128%) + ' ' + D6$ + '   ' + FNPRCNT.TOT$(PROJ.TOTS(0%,7%),167200.) + '   ' + 
				    FNPRCNT.TOT$(PROJ.TOTS(0%,7%),PROJ.TOTS(0%,8%))
	\ RSET D6$ = NUM1$(PROJ.TOTS(0%,8%))
	\ D$ = D$ + ' ' + D6$ + '   ' + FNPRCNT.TOT$(PROJ.TOTS(0%,8%),167200.)
	\ D$ = D$ + '  ' + FNJOB.SIZE$(PROJ.TOTS(0%,5%),PROJ.TOTS(0%,3%)) + '  '
	\ RSET D3$ = NUM1$(ACNTS(0%,0%))
	\ D$ = D$ + D3$
	\ PRINT #4%, D$
	!
	!			TOTAL LINE
	!



11160	  IF RESET% THEN  PRINT #4%
	\	PRINT #4%
	\	PRINT #4%, '   WEEKLY CHANGE       ';
	\	PRINT #4%, FNPRCNT.INCRSE$(PROJ.TOTS(0%,J%),TOTS(1%,J%));'          ';
				FOR J% = 3% TO 8%
	\	PRINT #4%
	
	\	PRINT #4%, '   YEARLY CHANGE       ';
	\	PRINT #4%, FNPRCNT.INCRSE$(PROJ.TOTS(0%,J%),TOTS(0%,J%));'          ';          
				FOR J% = 3% TO 8%
	\	PRINT #4%
	\	PRINT #4%, MISC$(0%)
	!
		PRINT OUT WEEKLY AND YEARLY % CHANGES (  +  OR - )
		WEEKLY CHANGES ARE DETERMINED FROM PREVIOUS WEEK'S TOTALS
		THE YEARLY BASE LINE WILL BE FIRST WEEK'S VALUES STORED IN
				TOTS(0,J%)
	!
	!



11180	RETURN
	!		GO BACK TO OPTION
	!






12000	!
	******  INDIVIDUAL ACCOUNT ROUTINE  ******
	!

12100	  PRINT
	\ INPUT 'Selective  <NO> ';M$
	\ PRINT #4%, FOR LN.CNT% = 1% TO 66%-PROJ.TOTS(0%,0%) + 13%
	\ PRINT #4%, TAB(26%); H$
	\ PRINT #4%,
	\ PRINT #4%,
	\ GOTO 12200 IF ASCII(M$) <> 89%
	!
		SELECTIVE OR ALL ACCOUNTS
	!

12120	  PRINT
	\ I% = 0%
	\ INPUT 'Project # ';PROJ%
	\ I% = I% + 1% UNTIL PROJ% = PROJ.TOTS(I%,2%)
	\ GOSUB 14100
	\ GOSUB 14700
	\ PRINT #4%,
	\ GOTO 12120
	!
		PRINT DETAIL LINE FOR EACT ACCOUNT WITHIN A SPECIFIC
			PROJECT
		GET NEXT PROJECT
	!


12200	  FOR I% = 1% TO PROJ.TOTS(0%,0%)
	\	GOSUB 14100
	\	GOSUB 14700
	\	PRINT #4%
	\	PRINT #4%
	\ NEXT I%
	\ RETURN
	!
		DO ALL ACCOUNTS BY EACH PROJECT THEN RETURN TO OPTION
	!


14100	!
	******  HEADING SUBROUTINE FOR INDIVIDUAL ACCOUNTS REPORT  ******
	!
14120	  PRINT #4%,	TAB(48%);'ACCOUNTS  BY  PROJECT	PROJECT  =  ';
			LEFT(PRJ.NAME$(I%),3%);'	';RIGHT(PRJ.NAME$(I%),5%)
	\ PRINT #4%,
	\ PRINT #4%,	TAB(24%);'%';TAB(29%);'%';TAB(43%);'%';TAB(48%);'%';
			TAB(62%);'%';TAB(67%);'%';TAB(80%);'%';TAB(85%);'%';
			TAB(89%);'DISK    %    %    %';
			TAB(111%);'DISK    %    %   AVG'
	\ PRINT #4%,	'  ACCOUNT';TAB(14%);'CPU';TAB(23%);'ALL  PRJ  CONNECT ';
			' ALL  PRJ';TAB(54%);"KCT'S  ALL  PRJ  DEVICE  ALL";
			'  PRJ  USED   ALL  PRJ  QUO  QUOTA  ALL  PRJ  JOB'
	\ PRINT #4%,
	\ RETURN
	!



14200	!
		******  REPORT HEADING  ******
	!

14220	  H$ = 'ACCOUNTING REPORT FOR '
	\ H$ = H$ + MISC$(3%)
	\ H$ = H$ + ' FROM ' + MISC$(1%) + '  THROUGH  ' + MISC$(2%)
	\ H$ = H$ + ' WITH DATA BEING RESET' IF RESET%	\ RETURN
	!
		SET UP HEADING FOR REPORT IN H$
	!



14500	!
	******  DECODE ACCOUNTING DATA ROUTINE  ******
	!


14520	  J% = J% + 1%
	\ ACNTS(J%,1%) = M%(7%)
	\ ACNTS(J%,2%) = M%(8%)
				!	INCREMENT ROW COUNTER	& 
				!	GET PROGRAMMER #	& 
				!	GET PROJECT #		& 
				!				& 



	\ ACNTS(J%,3%) = 256%*M%(14%) +M%(13%) +
			 16384.*(M%(22%) AND 252%)
				!				& 
				!	CPU TIME IN TENTHS	& 
				!	   OF SECONDS		& 
				!				& 



	\ ACNTS(J%,4%) = 256.*M%(16%) + M%(15%)
				!				& 
				!	CONNECT TIME IN		& 
				!		MINUTES		& 
				!				& 



	\ ACNTS(J%,5%) = 256.*M%(18%) + M%(17%) +
			 65536.*( M%(21%)+256.*(M%(22%) AND 3%)) & 
				!				& 
				!	KCT'S			&
				!				& 



	\ ACNTS(J%,6%) = 256.*M%(20%) + M%(19%)			& 
				!				&
				!	DEVICE TIME IN MINUTES	& 
				!				& 



	\ ACNTS(J%,7%) = 256.*M%(6%) + M%(5%)
				!				& 
				!	DISK BLOCKS OWNED	& 
				!				& 



	\ ACNTS(J%,8%) = 256.*M%(28%) + M%(27%)
				!				& 
				!	QUOTA			& 
				!				& 



	\ ACNTS(J%,8%) = ACNTS(J%,7%) IF ACNTS(J%,8%) = 0%
				!				& 
				!	IF QUOTA 0 THE SET	& 
				!	QUOTA TO DISK OWNED	& 
				!				& 
	\ RETURN




14700	!
	******  FORMAT AND PRINT DETAIL LINE FOR INDIVIDUAL REPORTS ******
	!

14720	  FOR J% = 1% UNTIL C% = PROJ.TOTS(I%,1%) OR J%>ACNTS(0%,0%)
	\	IF ACNTS(J%,2%)=PROJ.TOTS(I%,2%) THEN
			C% = C% + 1%
	\		RSET D6$ = NUM1$(ACNTS(J%,2%)) + ','
	\		LSET D3$ = NUM1$(ACNTS(J%,1%))
	\		D$ = D6$ + D3$
	\		D$ = D$ + '  ' + FNFORMAT$(ACNTS(J%,K%),PROJ.TOTS(0%,K%)) FOR K% = 3% TO 8%
	\		D$ = D$ + '  ' + FNJOB.SIZE$(ACNTS(J%,5%),ACNTS(J%,3%))
	\		PRINT #4%, D$
	!
	!	FORMAT DETAIL LINE FOR INDIVIDUAL ACCOUNTS
	!
14740	  NEXT J%
	\ C% = 0%
	\ D$ = '  TOTAL  '
	\ D$ = D$ + '  ' + FNFORMAT$(PROJ.TOTS(I%,K%),PROJ.TOTS(0,K%)) FOR K% = 3% TO 8%
	\ D$ = D$ + '  ' + FNJOB.SIZE$(PROJ.TOTS(I%,5%),PROJ.TOTS(I%,3%))
	\ PRINT #4%,
	\ PRINT #4%, D$
	\ PRINT #4%,
	\ PRINT #4%, STRING$(132%,42%)
	!
	
14760	RETURN
	!



15000	!
	****************************************************************
	*                                                              *
	*                       F U N C T I O N S                      *
	*                                                              *
	****************************************************************


	!



15100	   DEF FNPRJ.NAME$
	\ LSET P1$ = ''
	\ LSET P1$ = PRJ.NAME$(K%) IF
			PROJ.TOTS(I%,2%) = VAL(LEFT(PRJ.NAME$(K%),3%))
				FOR K% = 1% TO PROJ.TOTS(0%,0%)
	\ FNPRJ.NAME$ = P1$
	\ FNEND
	!
	!	GET ACCOUNT NAME OR TOTALS LINE NAME
	!



15300	   DEF FNPRCNT.TOT$(X,Y)
	\ RSET D4$ = ''
	\ RSET D4$ = PLACE$(LEFT(NUM1$(100.*X/Y),4%),0%) + '%'
			IF Y<>0.
	\ RSET D4$ = '' IF D4$ = '  0%'
	\ FNPRCNT.TOT$ = D4$
	\ FNEND
	!
	!		FIND % USAGE OT TOTAL USAGE
	!



15400	   DEF FNJOB.SIZE$(X,Y)
	\ RSET D3$ = ''
	\ RSET D3$ = PLACE$(NUM1$(X/Y),0%) + 'K' IF Y<>0.
	\ FNJOB.SIZE$ = D3$
	\ FNEND
	!			AVERAGE JOB SIZE  =  KCT'S/CPU TIME
	!



15500	   DEF FNPRCNT.INCRSE$(X,Y)
	\ S9$=''
	\ S9$='  ' IF J% = 4%
	\ S9$='     ' IF J% = 7%
	\ RSET D5$ = '0%'
	\ RSET D5$ = PLACE$(LEFT(NUM$(100.*(X-Y)/Y),4%),1%) + '%'
			UNLESS Y = 0.
	\ RSET D5$ = '100%' IF Y = 0.
	\ FNPRCNT.INCRSE$ = D5$ + S9$
	\ FNEND
	!
		FIND % OF INCREASE OVER BASE VALUES
	!



16000	DEF FNFORMAT$(X,Y)
	\ F9$ = ''
16030	  IF K%<>3% THEN GOTO 16050 ELSE F9$ = '0'
	\	RSET D1$ = ''
	\	T = INT(X/10.)
	\	T0 = X-10.*T
	\	F9$ = NUM1$(T0) IF T0<>0.
	!
		SEPARATE SECS AND TENTHS OF SECS
	!


16032	  T% = T/3600.
	\ IF T% THEN RSET D1$ = NUM1$(T%) + ':'
	\	T = T-3600.*T%
	!
			GET HOURS
	!

16034	  T% = T/60%
	\ RSET D2$ = '0' + NUM1$(T%)
	\ IF T% THEN RSET D1$ = D1$ + D2$ + ':'
	\	T = T-60%*T%
	!
		MINUTES
	!

16036	  RSET D2$ = '0' + NUM1$(T)
	\ RSET D1$ = D1$ + D2$ + "." + F9$
	\ RSET D1$ = '0' IF X = 0.
	\ F9$ = D1$ + S$ + FNPRCNT.TOT$(X,Y)
	\ GOTO 16090
	!
		SECONDS AND FORMAT REST OF LINE
	!

16050	  IF K% = 5% THEN RSET D8$ = '0'
	\	RSET D8$ = NUM1$(X) IF X<>0.
	\	F9$ = D8$ + S$ + FNPRCNT.TOT$(X,Y)
	\	GOTO 16090
	!
		KCT'S
	!

16060	  IF K% = 6% OR K% = 4% THEN RSET D2$ = '00'
	\	T% = X/60%
	\	RSET D2$ = '0' + NUM1$(X-T%*60%) IF X-T%<>0.
	\	RSET D6$ = NUM1$(T%) + ':' + D2$
	\	RSET D6$ = '0' IF X = 0.
	\	F9$ = D6$ + S$ + FNPRCNT.TOT$(X,Y)
	\	GOTO 16090
	!
			CONNECT OR DEVICE TIME IN HRS:MINS
	!

16070	  IF K% = 7% THEN RSET D5$ = '0'
	\	RSET D5$ = NUM1$(X) IF X<>0.
	\	F9$ = D5$ + S$ + FNPRCNT.TOT$(X,167200.)
	\	GOTO 16090
	!
		DISK USED
	!

16080	  IF K% = 8% THEN RSET D5$ = '0'
	\	RSET D5$ = NUM1$(X) IF X<>0.
	\	F9$ = D5$ + S$ + FNPRCNT.TOT$(X,167200.)
	!

			QUOTA
	!

16090	  F9$ = F9$ + S$ + FNPRCNT.TOT$(X,PROJ.TOTS(I%,8%)) IF PRJ.IND% = 1% AND K% = 7%
	\ F9$ = F9$ + S$ + FNPRCNT.TOT$(X,PROJ.TOTS(I%,K%)) IF PRJ.IND% = 2%
	\ F9$ = F9$ + S$ + FNPRCNT.TOT$(X,ACNTS(J%,8%)) IF PRJ.IND% = 2% AND K% = 7% AND C%<>0%
	\ F9$ = F9$ + S$ + FNPRCNT.TOT$(X,PROJ.TOTS(I%,8%)) IF PRJ.IND% = 2% AND K% = 7% AND C% = 0%
	\ FNFORMAT$ = F9$
	\ FNEND
	!		
		FORMAT EACH VALUE WITH % INCLUDED
		ADD % OF PROJECT QUOTA IF SUMMARY AND DISK USED
		ADD % OF PROJECT VALUE IF INDIVIDUAL 
		ADD % OF ACCOUNT QUOTA IF INDIVIDUAL AND DISK USED
		ADD % OF TOTAL PROJECT QUOTA IF INDIVIDUAL AND DISK USED

	!





19000	!
	****************************************************************
	*                                                              *
	*                     E R R O R    T R A P S                   *
	*                                                              *
	****************************************************************


	!
19050	   IF ERR = 5% AND ERL = 1280 THEN ACNTS(0%,0%) = I%-1%
	\	RESUME 2000
	!
	!	AT END OF ACCOUNTS, STORE TOTAL # OF ACCOUNTS IN ACNTS(0%,0%)
		AND RESUME AT PROJECT SUMMATION ROUTINE
	!
19100	   IF ERR = 57% AND ERL = 2020 THEN PROJ.TOTS(0%,0%) = I%-1%
	\ RESUME 2040
	!
	!	OUT OF DATA IN READ STATEMENT ( ALL PROJECT #'S READ IN )
	!
19200	  IF ERR = 50% THEN RESUME 32700
	!
		DATA FORMAT ERRORS FOR BAD INPUT 
	!

19500	   IF ERR = 11% THEN RESUME 32700
	!
	!		END OF JOB IF ^Z ENTERED
	!
19990	  ON ERROR GOTO 0
	!

32700	!
	****************************************************************
	*                                                              *
	*                    E O J    R O U T I N E S                  *
	*                                                              *
	****************************************************************


	!
32720	  CLOSE 1%,2%,3%,4%
	!

32760	  NO EXTEND
	!


32767	  END
