10	!---------------------------------------------------------------------!
	!								      !
	!	CHGPAS  V03.01						      !
	!	PASSWORD CHANGING PROGRAM				      !
	!	BY RUSS SCHWARTZ					      !
	!	NATIONWIDE MUTUAL INSURANCE COMPANY			      !
	!	FEBRUARY, 1980						      !
	!								      !
	!---------------------------------------------------------------------!

13	!*********************************************************************!
	!								      !
	!			D I S C L A I M E R			      !
	!								      !
	!*********************************************************************!
	!								      !
	!	THIS SOFTWARE IS PROPERTY OF NATIONWIDE MUTUAL INSURANCE      !
	!	COMPANY.  NO WARRANTY, EXPRESS OR IMPLIED, IS MADE CON-       !
	!	CERNING THE ACCURACY OR RELIABILITY OF THIS SOFTWARE.	      !
	!	THUS THE OWNER ASSUMES NO RESPONSIBILITY FOR THE SUPPORT      !
	!	OR MAINTENANCE OF THIS SOFTWARE ON ANY SYSTEM.		      !
	!								      !
	!*********************************************************************!

15	!---------------------------------------------------------------------!
	!								      !
	!	"CHGPAS" IS THE NON-PRIVILEGED USER PASSWORD CHANGING	      !
	!	PROGRAM.  IT ASSEMBLES ALL THE PARAMETERS NECESSARY FOR       !
	!	MAKING A PASSWORD-CHANGE REQUEST.  THE USER NEED ONLY	      !
	!	SUPPLY THE NEW PASSWORD.  THE REQUEST IS THE PASSED TO        !
	!	"ACMAN.BAC", THE ACCOUNT MANAGER IN THE SAME FORMAT AS       !
	!	WOULD HAVE BEEN GENERATED BY "MANAGE.BAC".		      !
	!								      !
	!---------------------------------------------------------------------!

20	!	EDIT	DATE		MODIFICATION
	!	----	----		------------
	!	01	05-FEB-80	UPGRADE TO VERSION 3.
30	!	VARIABLE NAME	DESCRIPTION
	!	-------------	-----------
	!	A$		PARAMETER STRING FOR SYS() CALLS.
	!	CMD$		REQUEST COMMAND PARAMETER STRING.
	!				ASCII(CMD$) = COMMAND NUMBER.
	!	DEV$		SYSTEM DISK PARAMETER.
	!	ERR1$		ERROR TEXT AS GENERATED BY FIP #9.
	!	INFO$		ACCOUNT INFORMATION STRING (PPN & PASSWORD).
	!	JUNK$		DUMMY PARAMETER.
	!	KB$		KEYBOARD NUMBER PARAMETER FOR BROADCASTING
	!				TO REQUESTOR; ASCII(KB$) = UNIT NUMBER.
	!	NEW.PASS$	REQUESTED NEW PASSWORD.
	!	OLD.PASS$	CURRENT ACCOUNT PASSWORD.
	!	PARM$		REQUEST PARAMETER STRING.
	!	PASS$		REQUESTED NEW PASSWORD.
	!	PASWRD$		PASSWORD PARAMETER IN RADIX-50.
	!	PPN$		ACCOUNT NUMBER PARAMETER.
	!	VERSION$	CURRENT VERSION NUMBER.
60	EXTEND
	! PROGRAM WRITTEN IN EXTEND MODE.

70	VERSION$ = 'V03.01'

1000	ON ERROR GO TO 9000
	\ A$ = SYS(CHR$(6%) + CHR$(-7%))
	\ PRINT STRING$(6%, 10%) + 'CHGPAS  ' + VERSION$ + CHR$(9%)
	  + RIGHT(SYS(CHR$(6%) + CHR$(9%)), 3%)
	\ PRINT
	\ PRINT 'Password Changing Program'
	\ PRINT
	! SET UP ERROR TRAP.
	! CTRL/C TRAP ENABLE.
	! PRINT HEADER & SYSTEM ID.

1005	INFO$ = SYS(CHR$(6%) + CHR$(14%) + STRING$(28%, 0%))
	\ OLD.PASS$ = MID(INFO$, 9%, 4%)
	! GET CURRENT PPN & PASSWORD.

1010	A$ = SYS(CHR$(3%))
	\ INPUT 'Enter your current password'; PASS$
	\ PRINT
	\ PRINT
	\ A$ = SYS(CHR$(2%))
	\ A$ = SYS(CHR$(6%) + CHR$(-10%) + PASS$)
	\ PASS$ = MID(A$, 7%, 4%)
	\ GO TO 1060 IF CVT$%(PASS$) = 0% OR PASS$ <> OLD.PASS$
	! FIND OUT IF THEY SHOULD BE IN THIS ACCOUNT.
	! IF SO, THEN THEY KNOW THE PASSWORD.
	! OTHERWISE THEIR RESPONSE DOESN'T MATCH, SO GET OUT.

1020	A$ = SYS(CHR$(3%))
	\ INPUT 'Change your password to'; PASS$
	\ A$ = SYS(CHR$(2%))
	\ PRINT
	\ NEW.PASS$ = MID(SYS(CHR$(6%) + CHR$(-10%) + PASS$), 7%, 4%)
	\ IF CVT$%(NEW.PASS$) = 0% THEN
	  PRINT TAB(5%); PASS$ + ' -- Invalid password'
	\ GO TO 1020
	! GET NEW PASSWORD.
	! MAKE SURE IT IS LEGAL.

1025	PRINT
	\ PRINT 'Your password will be changed to:  ' + PASS$;
	\ SLEEP(10%)
	\ PRINT CHR$(13%) + SPACE$(35%) + '######'
	  + CHR$(13%) + SPACE$(35%) + 'HHHHHH'
	  + CHR$(13%) + SPACE$(35%) + 'IIIIII'
	\ PRINT
	! VERIFY NEW PASSWORD.

1030	OPEN "NL:CHGPAS.WRK" AS FILE 12%, RECORDSIZE 84%
	\ FIELD #12%,	84% AS PARM$
	\ FIELD #12%,	1% AS KB$,
			1% AS CMD$,
			2% AS PPN$,
			4% AS PASWRD$,
			4% AS JUNK$,
			4% AS DEV$
	\ LSET PARM$ = STRING$(84%, 0%)
	! SET UP WORK BUFFER.
	! ZERO IT.

1040	LSET KB$ = CHR$(ASCII(MID(SYS(CHR$(6%) + CHR$(9%)), 2%, 1%)) / 2%)
	\ LSET CMD$ = CHR$(4%)
	\ LSET PPN$ = MID(INFO$, 7%, 2%)
	\ LSET PASWRD$ = NEW.PASS$
	\ LSET DEV$ = MID(SYS(CHR$(6%) + CHR$(-10%) + 'SY:'), 23%, 4%)
	! SAVE KB: NUMBER SO ACMAN CAN BROADCAST MESSAGES.
	! FORCE COMMAND TO BE 4 (CHANGE PASSWORD).
	! SAVE NEW PASSWORD.

1050	A$ = CHR$(6%) + CHR$(22%) + CHR$(-1%) + CHR$(0%)
	  + 'ACMAN ' + CHR$(12%) + CHR$(0%)
	  + CHR$(84%) + CHR$(SWAP%(84%))
	  + STRING$(27%, 0%)
	\ A$ = SYS(A$)
	! SEND THE REQUEST TO ACMAN.

1060	CLOSE 12%
	\ PRINT
	\ A$ = SYS(CHR$(9%))
	\ STOP WHILE 1% = 1%
	! QUIT.
	! SET UP NONAME BECAUSE THIS IS PRIVILEGED.
8990	!---------------------------------------------------------------------!
	!								      !
	!	E R R O R    H A N D L I N G				      !
	!								      !
	!---------------------------------------------------------------------!

9000	ERR1$ = RIGHT(SYS(CHR$(6%) + CHR$(9%) + CHR$(ERR)), 3%)
	! SET UP ERROR TEXT.

9005	IF ERR = 28% THEN
	  RESUME 1060
	! THEY CTRL/C'D, SO GET OUT.

9010	IF ERL = 1020 THEN
	  PRINT TAB(5%); PASS$ + ' -- Invalid password'
	\ RESUME 1020
	! INVALID PASSWORD ERRORS.

9020	IF ERL = 1050% AND (ERR = 4% OR ERR = 32%) THEN
	  RESUME 1080
	! CAN'T SEND A MESSAGE RIGHT NOW, SO TRY AGAIN.

9030	IF ERL = 1050% AND ERR = 5% THEN
	  PRINT TAB(5%); "?ACMAN not running -- Can't change password"
	\ RESUME 1060
	! CAN'T SEND A MESSAGE.

9040	IF ERL = 1010% THEN
	  RESUME 1060
	! MORE INVALID PASSWORD ERRORS.

9990	PRINT TAB(5%); ERR1$ + ' at line'; ERL
	\ PRINT TAB(5%); "?Program malfunction at line"; ERL
	\ PRINT
	\ RESUME 1060
	! UNEXPECTED ERRORS.

32767	END
