1	!



		A C T S Y S . B A S 



	!


10	!

		PROGRAM		: ACTSYS.BAS
		VERSION		: 6C
		EDIT		: 03

		AUTHOR		: JIM GREGORY
		INSTALLATION	: WITTENBERG UNIVERSITY

		DATE		: 10-Aug-78


	!

20	!
	****************************************************************
	*                                                              *
	*            M O D I F I C A T I O N    H I S T O R Y          *
	*                                                              *
	****************************************************************


	!
21	!
	EDIT		DATE		REASON



	!

100	!
	****************************************************************
	*                                                              *
	*             P R O G R A M    D E S C R I P T I O N           *
	*                                                              *
	****************************************************************


	!
110	!

		THIS PROGRAM CAN BE USED TO RECONSTRUCT THE ACCT.SYS FILE
	TO REFLECT THE CURRENT STATUS OF THE SYSTEM DISK ACCOUNT STRUCTURE.
	AS ACCOUNTS GET ADDED AND DELETED AND AS QUOTAS AND PASSWORDS CHANGE
	THE DATA IN THIS FILE IS NO LONGER USEFUL FOR RECREATING THE ACCOUNT
	STRUCTURE THROUGH THE 'STANDARD' OPTION OF THE REACT.BAS PROGRAM.
	THE FILE CREATED BY THIS PROGRAM WILL CREATE A VIABLE ACCT.SYS
	FILE THAT MAY BE USED IN CONFIDENCE THAT IT ACCURATELY REFLECTS
	THE SYSTEM STATUS.

		THE FILE NOT ONLY IS RECONSTRUCTED, IT IS PUT INTO NUMERIC
	ORDER BY PPN USING A BINARY SEARCH TECHNIQUE FOR INSERTING DATA IN
	THE CORRECT SEQUENCE.

		THE USER MAY FIRST OPT FOR EITHER A RECONSTRUCTION OR A 
	LISTING OF THE CURRENT ACCT.SYS FILE.  FOR RECONSTRUCTION, THE
	PROGRAM READS EACH ACCOUNT FROM THE ACCT.SYS FILE AND ATTEMPTS TO
	FIND THE ACCOUNT THROUGH THE ACCOUNTING DUMP SYS CALL.  IF THIS
	ACCOUNT NO LONGER EXISTS, IT IS SKIPPED. IF FOUND IT IS INSERTED
	INTO THE CORRECT PLACE IN THE OUT$() ARRAY REPLACING ANY PREVIOUS
	INFORMATION FOR THE SAME ACCOUNT.  ( THIS REPLACEMENT PROCESS 
	INSURES THAT THE LATEST CREATED ACCOUNT IS LEFT IN THE NEW ACCT.SYS)
	AFTER RECONSTRUCTION, A VERIFICATION PROCESS WILL PRINT OUT THE
	OUT$() ARRAY FOR INSPECTION.  IF OK, THE OLD ACCT.SYS FILE HAS
	ZEROES WRITTEN OVER ALL INFORMATION AND THEN THE FILE IS KILLED.
	THEN ACCT.SYS IS REOPENED AND THE OUT$() ARRAY IS PUT OUT
	TO IT LINE BY LINE.

		UNDER THE LIST OPTION, THE USER MAY LIST THE ENTIRE 
	ACCT.SYS FILE WITH BREAKS BETWEEN PPN'S OR A SPECIFIC PPN MAY
	BE LISTED.

		A ^Z AT ANY INPUT WILL SAFELY EXIT THE PROGRAM, CLOSING
	THE ACCT.SYS FILE AND BLANKING OUT THE OUT$() ARRAY.  BOTH THE
	ZEROING OF OLD ACCT.SYS FILE AND THE BLANKING OF THE OUT$() 
	ARRAY IS TO INSURE THAT THE PASSWORD INFORMATION IS NOT AVAILABLE
	TO BROWSERS AFTER THE AREAS HAVE BEEN RELEASED.




300	!
	****************************************************************
	*                                                              *
	*                    I / O    C H A N N E L S                  *
	*                                                              *
	****************************************************************


	!
320	!


	CHANNEL		FILE

	    #1		$ACCT.SYS


	!

400	!
	****************************************************************
	*                                                              *
	*                  V A R I A B L E S    U S E D                *
	*                                                              *
	****************************************************************


	!
420	!

		NUMERIC VARIABLES

		CLSTR%		CLUSTERSIZE
		E%		HEADER ROUTINE
		HIGH%		HIGH VALUE FOR BINARY SEARCH
		I%		COUNTER FOR ITERATIONS
		IN.CNT%		# OF ACCOUNTS INPUT FROM OLD ACCT.SYS
		J%		COUNTER FOR ITERATIONS
		K%		HEADER ROUTINE
		LOW%		LOW VALUE FOR BINARY SEARCH
		M%()		ARRAY FOR SYS CALLS
		MID.%		MIDDLE VALUE FOR BINARY SEARCH
		OUT.CNT%	POINTER TO LAST VALUE IN OUT$()
		PROG%		PROGRAMMER #
		PROJ%		PROJECT #
		QUOTA%		QUOTA



	!


480	!

		ALPHABETIC VARIABLES

		CLSTR$		CLUSTERSIZE 
		E$		HEADER ROUTINE
		HOLD$		DUMMY FOR COMPARISON FOR BREAKS IN PRINT
					OF ACCT.SYS
		L$		LINE OF DATA FROM ACCT.SYS
		LFT$		FIRST 9 CHARACTERS (PPN) OF THE LAST VALUE
					ENTERED INTO THE OUT$() ARRAY
		LINE.$		LINE CONCATINATED FOR OUTPUT TO OUT$() ARRAY
		LIST.$		LIST OPTION	( ALL OR SPECIFIC PROJECT )
		M$		DUMMY
		NAME.$		NAME OF ACCOUNT FROM ACCT.SYS
		OPTION$		INPUT OPTION OF EITHER RECONSTRUCT OR LIST
					ACCT.SYS
		OUT$()		ARRAY CONTAINING NEW VERSION OF ACCT.SYS IN
					NUMERICALLY INCREASING ORDER
		PPN$		PROJECT , PROGRAMMER NUMBER
		PROG$		PROGRAMMER #
		PROJ$		PROJECT #
		PSWRD$		OLD PASSWORD
		PW$		CURRENT PASSWORD
		QUOTA$		QUOTA
		T$		TITLE OF PROGRAM
		Y$		INPUT DUMMY
		Z1$		CLEAR SCREEN

	!


800	!
	****************************************************************
	*                                                              *
	*      F U N C T I O N S    A N D    S U B R O U T I N E S     *
	*                                                              *
	****************************************************************


	!
820	!

		SUBROUTINES



	!


821	!

		10100	MOVE OUT$() ELEMENTS DOWN ONE POSITION SO LINE
			CAN BE INSERTED IN CORRECT LOCATION

		11000	RECONSTRUCT ACCT.SYS FILE

		12000	LIST OUT ACCT.SYS.FILE


	!


860	!

		FUNCTIONS


              
	!


900	!
	****************************************************************
	*                                                              *
	*                 P R O G R A M    S E T    U P                *
	*                                                              *
	****************************************************************


	!
910	  ON ERROR GOTO 19000
	\ EXTEND
	\ T$ = 'ACCT.SYS CLEAN UP  '
	\ Z1$=CHR$(155%)+"H"+CHR$(155%)+"J"
	!


920	  DIM M%(30%), OUT$(1000%)
	\ PROJ$ = SPACE$(3%)
	\ PROG$ = SPACE$(3%)
	\ CLSTR$ = SPACE$(3%)
	\ QUOTA$ = SPACE$(5%)
	\ PW$ = SPACE$(10%)
	\ IN.CNT%, OUT.CNT% = 0%
	!

	!
980	  OPEN '$ACCT.SYS' FOR INPUT AS FILE 1%
	!
		OPEN FILE
	!


990	  PRINT Z1$;
	\ E$=SYS(CHR$(6%)+CHR$(9%)+CHR$(0%))
	\ E%=INSTR(3%,E$,CHR$(0%))
	\ J%=ASCII(E$)/2%
	\ K%=ASCII(RIGHT(E$,2%))/2%
	\ E$=MID(E$,3%,E%-3%)
	\ PRINT
	\ PRINT T$;'  ';E$;' JOB= ';J%;'  KB= ';K%
	\ PRINT
	!

	PRINT HEADER ROUTINE
	!



1000	!
	****************************************************************
	*                                                              *
	*                   M A I N L I N E    C O D E                 *
	*                                                              *
	****************************************************************


	!
1020	  PRINT
	\ INPUT 'Enter Option -  Reconstruct or List <List> ';OPTION$
	\ IF ASCII(OPTION$) = 82% THEN GOSUB 11000 ELSE GOSUB 12000
	!
		RECONSTRUCT ACCT.SYS FILE OR LIST IT OUT
	!


1060	  PRINT Z1$;
	\ GOTO 1020
	!


	!



10000	!
	****************************************************************
	*                                                              *
	*                     S U B R O U T I N E S                    *
	*                                                              *
	****************************************************************


	!
10100	!
		******  MOVE OUT$() ELEMENTS DOWN ONE POSITION  ******
	!


10120	  OUT.CNT% = OUT.CNT% + 1%
	\ OUT$(I%) = OUT$(I%-1%) FOR I% = OUT.CNT% TO MID.% STEP -1%
	\ RETURN
	!

		MOVE ARRAY VALUES DOWN ONE POS SO CAN INSERT LINE
		AT CORRECT POSITION
	!

11000	!

	******  RECONSTRUCT ACCT.SYS FILE  ******

	!

11020	  PRINT
	\ PRINT 'Reconstruction of ACCT.SYS Now Running'
	!

11040	  INPUT #1%, PROJ%, PROG%, PSWRD$, QUOTA%, CLSTR%, NAME.$
	\ IN.CNT%=IN.CNT% + 1%
	\ CHANGE SYS(CHR$(6%)+CHR$(-10%)+PSWRD$) TO M%
	\ M%(0%) = 30%
	\ M%(1%) = 6%
	\ M%(2%) = 14%
	\ M%(I%) = 0% FOR I%=3% TO 22%
	\ M%(7%) = PROG%
	\ M%(8%) = PROJ%
	\ M%(I%) = 0% FOR I%=27% TO 30%
	\ CHANGE M% TO M$
	\ CHANGE SYS(M$) TO M%
	!

		GET INFO FROM ACCT.SYS
		SET UP DEVICE NAME
		CHECK IF ACCOUNT STILL EXISTS WITH READ ACCOUNTING SYS CALL
	!

11060	  PSWRD$ = RAD$( M%(9%) + SWAP%( M%(10%) ) ) +
			RAD$( M%(11%) + SWAP%( M%(12%) ) )
	\ PSWRD$ = CHR$(M%(23%)) + CHR$(M%(24%)) + CHR$(M%(25%)+48%) + ':' +
		PSWRD$ IF M%(26%)
	\ QUOTA% = M%(27%) +256.*M%(28%)
	\ RSET PROJ$ = NUM1$(PROJ%)
	\ RSET PROG$ = NUM1$(PROG%)
	\ RSET PW$   = PSWRD$+''
	\ RSET QUOTA$= NUM1$(QUOTA%)+''
	\ RSET CLSTR$= NUM1$(CLSTR%)+''
	\ PPN$       = PROJ$+' , '+PROG$
	\ LFT$ = LEFT(OUT$(OUT.CNT%),9%)
	\ LINE.$     = PPN$ + ' , ' + PW$ + ' , ' + QUOTA$ + ' , ' + CLSTR$ +
				' , ' + NAME.$
	!

		GET VALUES AND SET UP OUTPUT LINE CONTAINING
		CURRENT INFO ABOUT ACCOUNT


		PPN$ = LEFT 9 POSITIONS OF LINE.$ ( PPN OF ACCOUNT TO PUT OUT )
		LFT$ = LEFT 9 POSITIONS OF LAST VALUE OF OUT$() ARRAY FOR COMPARE

	!

11100	  IF PPN$ > LFT$ THEN
		OUT.CNT% = OUT.CNT% + 1%
	\	OUT$(OUT.CNT%) = LINE.$
	\	GOTO 11040
	!
		PUT IN NEXT SLOT IF > LAST ENTRY IN OUT$()

	!

11120	  IF PPN$ = LFT$ THEN 
		OUT$(OUT.CNT%) = LINE.$
	\	GOTO 11040
	!
		IF EQUAL THEN SUBSTITUTE MORE RECENT VALUE FOR EARLIER ONE
	!

11140	  LOW% =1%
	\ HIGH% = OUT.CNT%
	!
		INITIALIZE FOR BINARY SEARCH
	
	!

11160	  MID.% = ( LOW% + HIGH% )/2%
	\ GOTO 11300 IF PPN$ > LEFT( OUT$(MID.%), 9% )
	\ IF PPN$ = LEFT( OUT$(MID.%), 9% ) THEN
		OUT$(MID.%) = LINE.$
	\	GOTO 11040
	!
		CHECK MIDDLE OF SEARCH AREA AND

		1) GOTO 1300 IF > MIDDLE VALUE
		2) REPLACE IF =
		3) CONTINUE  IF < MIDDLE VALUE

	!

11200	!
	******  PPN$ < MIDDLE VALUE  ******

	!


11220	  IF PPN$ > LEFT( OUT$(MID.%-1%), 9% ) THEN
		GOSUB 10100
	\	OUT$(MID.%) = LINE.$
	\	GOTO 11040
	!
		CHECK IF BETWEEN MIDDLE AND IMMEDIATELY PREVIOUS
	!

11240	  HIGH% = MID.%
	\ GOTO 11160
	!
		IF NOT BETWEEN THEN LOWER HIGH% TO MID.% AND 
		CONTINUE SEARCH IN LOW HALF
	!

11300	!
	****** PPN$ > MIDDLE VALUE  ******

	!


11320	  IF PPN$ < LEFT( OUT$(MID.%+1%), 9% ) THEN
		MID.% = MID.% + 1%
	\	GOSUB 10100
	\	OUT$(MID.%) = LINE.$
	\	GOTO 11040
	!
		CHECK IF BETWEEN MIDDLE AND NEXT 
	!

11340	  LOW% = MID.%
	\ GOTO 11160
	!
		IF NOT BETWEEN THEN RAISE LOW% TO MID.% AND
		CONTINUE SEARCH IN HIGH HALF
	!


11500	  PRINT Z1$;
	\ PRINT 'Reconstruction Complete- ';OUT.CNT%;' RECORDS IN $ACCT.SYS'
	\ PRINT
	\ INPUT 'Verify <Yes> ';Y$
	\ PRINT OUT$(I%) FOR I% = 1% TO OUT.CNT% IF ASCII(Y$) <> 78%
	\ PRINT
	\ PRINT
	\ PRINT 'Verification Complete- ';OUT.CNT%;' Records in ACCT.SYS File'
		IF ASCII(Y$) <>78%
	\ PRINT
	\ INPUT 'Proceed ? (ACCT.SYS will be destroyed) Yes/No ';Y$
	\ GOTO 11580 IF Y$<>'YES'
	!
		VERIFY THAT OUT$() CONTAINS VALID DATA
	!


11520	  CLOSE #1%
	\ OPEN '$ACCT.SYS' AS FILE 1%
	\ FIELD #1%, 512% AS M$
	\ FOR I%=1% TO 32767%
	\	GET #1, RECORD I%
	\	LSET M$=STRING$(512%, 48%)
	\	PUT #1, RECORD I%
	\ NEXT I%
	!
		ZERO OUT OLD ACCT.SYS FILE
	!

11540	  CLOSE #1%
	\ KILL '$ACCT.SYS'
	\ OPEN '$ACCT.SYS' AS FILE 1%, MODE 2% 
	\ FOR I%= 1% TO OUT.CNT%
	\	PRINT #1%, OUT$(I%)
	\ NEXT I%
	!
		RESUMES HERE AFTER FILE ZEROED
		KILL OLD FILE
		OPEN AGAIN AND PRINT OUT RECONSTRUCTED FILE
	!


11580	  CLOSE #1%
	\ RETURN
	!
		CLOSE ACCT.SYS AND RETURN TO OPTIONS
	!


12000	!
	******  LIST ACCT.SYS FILE  ******

	!

12120	  PRINT Z1$;
	\ INPUT 'Enter -  Project #  or  All <All> ';LIST.$
	\ OPEN '$ACCT.SYS' FOR INPUT AS FILE 1%
	\ PRINT
	\ INPUT 'Pause ( For Paper Alignment ) ';Y$
	\ PRINT
	\ PRINT
	\ GOTO 12160 IF LEN(LIST.$)=0% OR
		VAL(LIST.$) < 0% OR VAL(LIST.$) > 255%
	!
		PRINT OUT WHOLE ACCT.SYS IF OUT OF RANGE OR NON NUMERIC
		DATA ENTERED ( GENERATES ERROR THEN RESUME AT 12160 )

	!


12140	  INPUT LINE #1%, L$
	\ GOTO 12180 IF VAL(LEFT(L$,3%)) > VAL(LIST.$)
	\ PRINT L$;  IF VAL(LEFT(L$,3%)) = VAL(LIST.$)
	\ GOTO 12140
	!
		DONE IF INPUT PROJECT # IS > LIST.$
		PRINT OUT ALL EQUALS
	!

12160	  HOLD$ = '   '
	\ WHILE -1%
	\	INPUT LINE #1%, L$
	\	PRINT CHR$(11%) IF LEFT(L$,3%) > HOLD$
	\	PRINT L$;
	\	HOLD$ = LEFT(L$,3%)
	\ NEXT
	!
		PRINT OUT WHOLE ACCT.SYS FILE WITH BREAKS BETWEEN
			PROJECTS
	!

12180	  PRINT CHR$(12%)
	\ PRINT
	\ CLOSE #1%
	\ RETURN
	!


15000	!
	****************************************************************
	*                                                              *
	*                       F U N C T I O N S                      *
	*                                                              *
	****************************************************************


	!
19000	!
	****************************************************************
	*                                                              *
	*                     E R R O R    T R A P S                   *
	*                                                              *
	****************************************************************


	!
19100	  IF ERR = 5% AND ERL = 11040 THEN RESUME 11040

	!
		SKIP IF ACCOUNT FROM ACCT.SYS NO LONGER EXISTS ON SYSTEM
	!

19200	  IF ERR = 11% THEN 
		IF ERL = 11040 THEN RESUME 11500 ELSE
		IF ERL = 11520 THEN RESUME 11540 ELSE
		IF ERL = 12160 THEN RESUME 12180 ELSE
			RESUME 32700
	!
		IF END OF FILE THEN 
		
		1) RESUME AT VERIFY IF GOT ALL ACCT.SYS DATA
		2) RESUME AT KILL FILE IF ACCT.SYS ALL ZEROED OUT
		3) RESUME AT RETURN IF READ ALL OF ACCT.SYS FOR LIST OPTION
		4) CLOSE FILE, BLANK OUT OUT$(), AND END PROGRAM ON
			ANY ^Z INPUT

	!


19600	 IF ERR = 52% AND ERL = 12120 THEN RESUME 12160
	!
		ILLEGAL # INPUT FOR LIST RANGE THEN RESUME
		AT PRINT WHOLE ACCT.SYS FILE
	!


19990	  ON ERROR GOTO 0
	!

32700	!
	****************************************************************
	*                                                              *
	*                    E O J    R O U T I N E S                  *
	*                                                              *
	****************************************************************


	!
32760	  NO EXTEND
	!


32767	  END
