1 !
	500.21 - STAT11 - CORREL

		CORRELATION MODULE

	RELEASED FOR SUBMISSION TO THE DECUS LIBRARY BY THE DEC
	ENGINEERING SYSTEMS GROUP AND EDUCATION PRODUCTS GROUP
		SEPTEMBER, 1977


2 !	COPYRIGHT (C) 1973, DIGITAL EQUIPMENT CORPORATION,

			MAYNARD, MASSACHUSETTS

3 !	THIS SOFTWARE IS FURNISHED TO PURCHASER UNDER A LICENSE FOR USE
	ON A SINGLE COMPUTER SYSTEM AND CAN BE COPIED (WITH INCLUSION OF
	DEC'S COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS
	MAY OTHERWISE BE PROVIDED IN WRITING BY DEC.

4 !	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE WITHOUT
	NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
	EQUIPMENT CORPORATION.

5 !	DEC ASSUMES NO RESPONSIBILITY FOR USE OR RELIABILITY OF ITS
	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DEC.


6 !	THIS PROGRAM COMPUTES AND PRINTS A TABLE OF THE DEGREES OF
	ASSOCIATION (CORRELATION COEFFICIENTS) BETWEEN EACH TWO 
	VARIABLES IN THE DATA MATRIX.



7 !	AUTHOR:		MICHAEL D. KNAUER

	VERSION NUMBER:	001

	DATE:		OCTOBER, 1973


8  !	MODIFICATIONS:  MAY, 1975

	MODIFIED TO ACCEPT MISSING DATA POINTS

		BY ARDOTH HASSLER WILSON
		   CENTRAL STATE UNIVERSITY
		   EDMOND, OKLAHOMA


00009!	MODIFICATIONS:  JUNE, 1976

	CTRL/C TRAP ADDED

10 !

	CALLING ARGUMENTS

11 !		1) VARIABLE NAME:	F3$
		   RANGE OF VALUES:	S00000.RWM - S99999.RWM
		   USE:			THIS IS THE 250 ROW BY 15 COLUMN
					DATA MATRIX USED BY ALL STAT11
					MODULES

15 !		3) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			CONTAINS NUMBER OF ROWS OF
					DATA IN F3$

17 !		4) VARIABLE NAME:	C%
		   RANGE OF VALUES:	1 - 15
		   USE:			CONTAINS THE NUMBER OF COLUMNS
					OF DATA IN F3$

20 !

	RETURNING ARGUMENTS

		NONE -- THIS MODULE DOES NOT ALTER OR ADD TO ANY OF
			THE FILES OR VARIABLES PASSED TO IT.




30 !	DESCRIPTION OF FUNCTION

		CORREL COMPUTES AND PRINTS A TABLE OF THE DEGREES OF
		ASSOCIATION (CORRELATION COEFFICIENTS) BETWEEN EACH
		TWO VARIABLES IN THE DATA MATRIX F3$.

31 !		THIS MODULE FIRST COMPUTES THE SUMS OF DEVIATIONS FROM
		MEANS, SUMS OF SQUARES OF DEVIATIONS FROM MEANS, AND
		SUMS OF CROSS-PRODUCTS OF DEVIATIONS FROM MEANS FOR ALL
		VARIABLES IN MATRIX F3$.

32 !		USING THESE VALUES, IT THEN COMPUTES AND PRINTS THE
		CORRELATION COEFFICIENTS.

33 !		AFTER PRINTING THE TABLE, CORREL ALWAYS TRANSFERS
		CONTROL (CHAINS) TO THE STATCM MODULE.


45 !


	THIS FIRST SECTION OF CODE RETRIEVES THE CALLING ARGUMENTS FROM
	COMMON AND OPENS THE INPUT FILES.



50	ON ERROR GOTO 9000: GOSUB 10000
100	F$=SYS(CHR$(7))
105	A9$=MID(F$,62%,9%): A9$=LEFT(A9$,INSTR(5%,A9$,"]")):
	H9=.9E-38
110	R%=VAL(MID(F$,46%,5%))
120	C%=VAL(MID(F$,51%,5%))
130	F3$=MID(F$,31%,15%)
140	F4$=LEFT(F3$,6%)+".ESF"
150	OPEN F3$ FOR INPUT AS FILE 3
160	DIM #3,A(250%,15%)
185	!

	THE FOLLOWING SECTION COMPUTES THE MEANS, MEAN DEVIATIONS,
	CROSS-PRODUCTS OF DEVIATIONS, ETC. AND THE CORRELATION
	COEFFICIENT.


187	IF C%=1% THEN PRINT "YOU CANNOT COMPUTE A CORRELATION";
	" COEFFICIENT FOR ONLY ONE VARIABLE": GOTO 510
190	PRINT  : PRINT "CORRELATION MATRIX"
200	PRINT 
210	DIM Q(15%,15%),N%(15%,15%)
220	FOR J%=1% TO C%
230	FOR K%=1% TO C%
240	M1=0: M2=0: S1=0: S2=0
250	FOR I%=1% TO R%:
	IF A(I%,J%)=H9 OR A(I%,K%)=H9 GOTO 270
260	M1=M1+A(I%,J%): M2=M2+A(I%,K%): N%(J%,K%)=N%(J%,K%)+1%
270	NEXT I%
280	IF N%(J%,K%)<=1% THEN Q(J%,K%)=0: GOTO 370
290	N=N%(J%,K%): M1=M1/N: M2=M2/N
300	FOR I%=1% TO R%
	: GOTO 330 IF A(I%,J%)=H9 OR A(I%,K%)=H9
310	S1=S1+(A(I%,J%)-M1)^2: S2=S2+(A(I%,K%)-M2)^2
320	Q(J%,K%)=Q(J%,K%)+(A(I%,J%)-M1)*(A(I%,K%)-M2)
330	NEXT I%
360	Q(J%,K%)=Q(J%,K%)/SQR(S1*S2)
370	NEXT K%: GOSUB 460
380	NEXT J%: PRINT: PRINT
390	GOTO 515
440	!

		PRINT THE CORRELATION MATRIX AND THE ASSOCIATED N


460	PRINT "ROW";J%
465	S%=1%: S9%=10%
470	IF S9%>C% THEN S9%=C%
480	PRINT USING " ##.###",Q(J%,K%); FOR K%=S% TO S9%: PRINT
485	PRINT USING "  (###)",N%(J%,K%); FOR K%=S% TO S9%: PRINT
490	IF S9%>=C% GOTO 500
	ELSE S%=S9%+1%: S9%=S9%+10%: PRINT: GOTO 470
500	PRINT: PRINT: RETURN
515 !


	THIS SECTION REPLACES THE COMMON STRING AND TRANSFERS CONTROL
	TO STATCM.


520	R$=SYS(CHR$(8)+F$)
530	CHAIN "STATCM"+A9$
09000	IF ERR=28% THEN GOSUB 10000: RESUME 520
09010	IF ERR=48% THEN 
	PRINT "NUMBERS ARE TOO LARGE IN THESE COLUMNS": RESUME 480
09020	ON ERROR GOTO 0
10000	V0$=SYS(CHR$(6%)+CHR$(-7%)): RETURN	! CTRL/C TRAP
32767	END
