1	!



		S E T D E C . B A S 



	!


10	!

		PROGRAM		: SETDEC.BAS
		VERSION		: RSTS-E 6C
		EDIT		: 03

		AUTHOR		: DR. JOHN S. ABMA
		INSTALLATION	: WITTENBERG UNIVERSITY

		DATE		: 13-May-79


	!

100	!
	****************************************************************
	*                                                              *
	*             P R O G R A M    D E S C R I P T I O N           *
	*                                                              *
	****************************************************************


	!
110	! This program writes .CAI files for use by DECAL:CREATE to create
	! DECAL lessons.  
	!
	! The user can select QUIZ or LESSON.  If QUIZ, the program will
	! randomly generate quizzes of specified size from the total number
	! of items entered. If LESSON, user enters up to fifty instructional
	! segments.
	!
	! The A,3 answer type is used in both QUIZ and LESSON generation.
	!
	! Modified on NOV 28, 1979 to run with patched DECAL:CREATE program.
	! Blank lines had to be added as follows:
	!  In QUIZ option, just before the initial ! in segment two.
	!  In LESSON options, just before every ! in each segment.

120	!
	! Modified on DEC 04, 1979 to permit user to stop program with
	! CTRL/C.  Later, the lesson can be continued by running the program
	! again.
	!

300	!
	****************************************************************
	*                                                              *
	*                    I / O    C H A N N E L S                  *
	*                                                              *
	****************************************************************


	!
320	!


	CHANNEL		FILE



	!

330	! #1%		??????.CAI  

400	!
	****************************************************************
	*                                                              *
	*                  V A R I A B L E S    U S E D                *
	*                                                              *
	****************************************************************


	!
420	!

		NUMERIC VARIABLES



	!


430	! ERR		System error variable.
	! ITEM%		Looping index while user inputs questions or items.
	! SAMPLE%	Number of items in each quiz.
	! TOTAL.ITEMS%	Total number of questions or items entered.

480	!

		ALPHABETIC VARIABLES



	!


490	! ANSWER$	Correct answer to be matched by student.
	! FAILURE.COMMENT$ Author gives comment after wrong student answer.
	! LESSON$	Name of .CAI file being written.
	! OPTION$	All-purpose user option variable.
	! TEXT$		The text-question block entered by author.
	! TOPIC$	Area of quizz, announced to student in first segment
	!		of quiz.

800	!
	****************************************************************
	*                                                              *
	*      F U N C T I O N S    A N D    S U B R O U T I N E S     *
	*                                                              *
	****************************************************************


	!
820	!

		SUBROUTINES



	!


830	!  Two subroutines for lesson generation.  
	!	Line 10000 to generate quizzes.
	!	Line 11000 to generate sequential lessons.
	!
	!  Various subroutines for instructions.

860	!

		FUNCTIONS


              
	!


870	!  One function at 15000 to clear screen.

900	!
	****************************************************************
	*                                                              *
	*                 P R O G R A M    S E T    U P                *
	*                                                              *
	****************************************************************


	!
910	  ON ERROR GOTO 19000
	\ EXTEND
	\ TOPIC$ = 'S E T D E C  '
	\ PRINT FNCLEAR.SCREEN$
	!


950	  DIM A$(500%)

990	  PRINT TOPIC$; '  ';
	\ TOPIC$=SYS(CHR$(6%)+CHR$(9%)+CHR$(0%))
	\ ITEM%=INSTR(3%,TOPIC$,CHR$(0%))
	\ PRINT MID(TOPIC$,3%,ITEM%-3%);' JOB= ';ASCII(TOPIC$)/2%;'  KB= ';ASCII(RIGHT(TOPIC$,2%))/2%
	\ PRINT
	\ ITEM%=0%
	! This will announce the program, job and terminal.  The ITEM variable
	! will be used later and must be zero here.
	!

	PRINT HEADER ROUTINE
	!



1000	!
	****************************************************************
	*                                                              *
	*                   M A I N L I N E    C O D E                 *
	*                                                              *
	****************************************************************


	!
1040	  PRINT
	\ INPUT'Do you want instructions? (YES or NO) <NO>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ GOSUB 12000 IF ASCII(OPTION$)=89%
	! Instructions are available.

1050	  PRINT
	\ INPUT'Name for the DECAL lesson file? (Form; LESON1) <HELP>';LESSON$
	\ LESSON$=CVT$$(LESSON$,-1%)
	\ GOSUB 12500 UNLESS ASCII(LESSON$)
	\ GOTO   1050 UNLESS ASCII(LESSON$)
	! User must name a file for the lesson.

1060	  OPEN LESSON$+'.CAI' FOR INPUT AS FILE #1%
	\ PRINT'That lesson already exists.'
	\ GOSUB 13000
	\ IF ITEM%=TOTAL.ITEMS% THEN
		PRINT'Lesson is complete'
	\	INPUT'Do you want to overwrite it? (YES or NO) <NO>';OPTION$
	\	IF ASCII(OPTION$)=89% THEN GOTO 1065 ELSE
		GOTO 32760
	! No error occurs if the file opened for input does exist.
	! Subroutine analyzes state of lesson file to see if it is a complete
	! or incomplete lesson.  If complete, user can overwrite, or get out.

1061	  INPUT'Do you want to continue it? (YES or NO) <YES>';OPTION1$
	\ OPTION1$='Y' IF ASCII(OPTION1$)<>78%
	\ ITEM%=ITEM%-1% IF OPTION$='Q'
	\ TOTAL.ITEMS%=TOTAL.ITEMS%-3% IF OPTION$='Q'
	\ ITEM%=ITEM%+1% IF OPTION$='L'
	\ IF ASCII(OPTION1$)=89% THEN CLOSE #1%
	\	OPEN LESSON$+'.CAI' AS FILE#1%, MODE 2%
	\	GOSUB 10050 IF OPTION$='Q'
	\	GOSUB 11020 IF OPTION$='L'
	\	GOTO 32720
	! The lesson file is opened in append mode for continuation.
	! When completed, user is sent for instructions on how to run DECAL
	! CREATE, then leaves the program.

1062	  INPUT'Do you want to overwrite it? (YES or NO) <NO>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ GOTO 32760 UNLESS ASCII(OPTION$)=89%

1065	  GOTO 1050 UNLESS ASCII(OPTION$)=89%
	\ OPEN LESSON$+'.CAI' FOR OUTPUT AS FILE #1%
	! If the named lesson does not exist, (in line 1060), then ERR 5
	! occurs, and program resumes at this line.

1080	  PRINT
	\ ITEM%=1%
	\ INPUT'Will you enter a QUIZ or LESSON? (Type Q or L) <HELP>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ OPTION$='' UNLESS OPTION$='Q' OR OPTION$='L'
	\ GOSUB 12100 UNLESS ASCII(OPTION$)
	\ GOTO   1080 UNLESS ASCII(OPTION$)
	\ GOSUB 10005 IF ASCII(OPTION$)=81%
	\ GOSUB 11000 IF ASCII(OPTION$)=76%
	\ GOTO 1090
	! Give instructions if no answer is provided for Q or L.
	! Go to right lesson-creating subroutine.

1085	  GOSUB 12800
	\ GOTO  32760
	! The CTL/C trap resumes here, analyzes incomplete lesson in the
	! subroutine, then sends user out of program.

1090	  GOTO  32720
	! Gives instructions in creating a lesson with DECAL:CREATE, then
	! closes file and leaves the program.

10000	!
	****************************************************************
	*                                                              *
	*                     S U B R O U T I N E S                    *
	*                                                              *
	****************************************************************


	!
10001	!
	! ***** SEGMENTS FOR QUIZ *****
	!
10005	  PRINT
	\ PRINT'What is your subject area or topic <HELP>'
	\ INPUT LINE TOPIC$
	\ TOPIC$=CVT$$(TOPIC$,4%)
	\ GOSUB 12600 UNLESS ASCII(TOPIC$)
	\ GOTO  10005 UNLESS ASCII(TOPIC$)
	\ PRINT
	! The quiz will tell the user what the topic is, in segment 1.
	
10010	  PRINT
	\ INPUT'How many questions will you enter';TOTAL.ITEMS%
	\ IF TOTAL.ITEMS% < 1% OR TOTAL.ITEMS% > 47% THEN
	  PRINT'Enter from 1 to 47 items'
	\ GOTO 10010
	! Ask for how many items, check for legal response, give another
	! chance if illegal.

10020	  INPUT'How many questions to select randomly for each quiz';SAMPLE%
	\ IF SAMPLE% < 1% OR SAMPLE% > TOTAL.ITEMS% THEN
		PRINT'Your quiz size should be less than or equal to the'
	\	PRINT'total questions entered; please re-enter both values'
	\	GOTO 10010
	! Ask for sub-sample to be selected for each quiz; check for legality.

10040	  PRINT #1%,LESSON$
	\ PRINT #1%,'N, '+NUM1$(TOTAL.ITEMS%+3%)
	\ PRINT #1%,'T, 0'
	\ PRINT #1%,'This will be a quiz of 'SAMPLE% 'items over 'TOPIC$
	\ PRINT #1%,'!'
	\ PRINT #1%,'V'
	\ PRINT #1%,'W=1'
	\ PRINT #1%,'!'
	\ PRINT #1%,'E'
	\ PRINT #1%
	\ PRINT #1%,'!'
	\ PRINT #1%,'V'
	\ PRINT #1%,'C=C+1'
	\ PRINT #1%,'!'
	\ PRINT #1%,'BC,'+NUM1$(TOTAL.ITEMS%+3%)+',C='+NUM1$(SAMPLE%+1%)
	\ PRINT #1%,'BN,3-'+NUM1$(TOTAL.ITEMS%+2%)
	\ PRINT #1%,'C'
	\ PRINT #1%
	\ PRINT #1%,'!'
	\ PRINT #1%,'E'
	! The first two segments are purely house-keeping for the random-
	! selection strategy of quizzing.

10050	  Q$=SYS(CHR$(6%)+CHR$(-7%))
	! Set CTRL-C trap.

10052	  FOR ITEM%=ITEM% TO TOTAL.ITEMS%
	\ PRINT
	\ PRINT'***** Item #'ITEM%'of'TOTAL.ITEMS%
	\ PRINT
	\	PRINT #1%
	\	PRINT #1%,'Question # \C\'
	\	PRINT #1%
	\	TEXT$=''
	\	WHILE -1%
	\		PRINT'Text and question <FINISHED>'UNLESS ASCII(TEXT$)

10055			INPUT LINE TEXT$
	\		TEXT$=CVT$$(TEXT$,4%)
	\		IF TEXT$='!' OR TEXT$='E' THEN
				GOSUB 11100
	\			GOTO 10055

10057			GOTO 10060 UNLESS ASCII(TEXT$)
	\		PRINT #1%,TEXT$
	\	NEXT
	! User is kept informed of place in lesson.  The text-question block
	! may be as long as desired, and is terminated by a <CR> alone.

10060	 	PRINT #1%,'!'
	\	PRINT #1%,'A,3'
	\	PRINT
	\	PRINT'Answer'

10061		INPUT LINE ANSWER$
	\	ANSWER$=CVT$$(ANSWER$,4%)
	\	IF ANSWER$='!' THEN
			GOSUB 11100
	\		GOTO 10061

10062		PRINT #1%,ANSWER$
	\	PRINT #1%,'C'
	\	PRINT #1%
	\	PRINT #1%,'Right!'
	\	PRINT #1%
	\	PRINT #1%,'!'
	\	PRINT #1%,'BQ,2'
	\	PRINT #1%,'BM,2,0'
	\	PRINT #1%,'F'
	\	PRINT #1%
	\	PRINT #1%,'*** Wrong'
	\	PRINT #1%
	\	PRINT

10063		INPUT'Comment after wrong answer <NONE>'FAILURE.COMMENT$
	\	PRINT #1%,FAILURE.COMMENT$
	\	IF FAILURE.COMMENT$='!' OR FAILURE.COMMENT$='E' THEN
			GOSUB 11100
	\		GOTO  10063

10064		PRINT #1%,'!'
	\	PRINT #1%,'E'
	\ NEXT ITEM%
	! All items have the same house-keeping.

10065	  PRINT #1%
	\ PRINT #1%,'End of the quiz.  If you missed more than'
	\ PRINT #1%,'two items, study the material again'
	\ PRINT #1%,'!'
	\ PRINT #1%,'V'
	\ PRINT #1%,'W=0'
	\ PRINT #1%,'!'
	\ PRINT #1%,'E'
	! A sign-off segment summarizes quiz results for student.

10070	  RETURN

11000	!
	! ***** SEGMENTS FOR LINEAR PROGRAM *****
	!
11010	  PRINT
	\ INPUT'How many items of instruction? <HELP>';TOTAL.ITEMS%
	\ GOSUB 12700 UNLESS TOTAL.ITEMS%
	\ GOTO  11010 UNLESS TOTAL.ITEMS%
	\ IF TOTAL.ITEMS% < 1% OR TOTAL.ITEMS% > 50% THEN
	  PRINT'Please enter from 1 to 50 items.'
	\ GOTO 11010
	! Help is available for number of items; number is checked for legality.

11015	  PRINT #1%,LESSON$
	\ PRINT #1%,'N, '+NUM1$(TOTAL.ITEMS%)
	\ PRINT #1%,'T, 0'
	! These three lines are needed to start every CAI lesson, are
	! transparent to the user.

11020	  Q$=SYS(CHR$(6%)+CHR$(-7%))
	! Set CTRL-C trap.

11022	  FOR ITEM%=ITEM% TO TOTAL.ITEMS%
	\	PRINT
	\	PRINT'***** Item #'ITEM%'of'TOTAL.ITEMS%
	\	PRINT
	\	TEXT$=''
	\	WHILE -1%
	\		PRINT'Text and question <FINISHED>' UNLESS ASCII(TEXT$)

11025			INPUT LINE TEXT$
	\		TEXT$=CVT$$(TEXT$,4%)
	\		IF TEXT$='!' OR TEXT$='E' THEN
				GOSUB 11100
	\			GOTO 11025

11027			GOTO 11030 UNLESS ASCII(TEXT$)
	\		PRINT #1%,TEXT$
	\	NEXT
	! The text-question block can be any length.  Is terminated by a
	! <CR> alone on a line.

11030		PRINT #1%
	\	PRINT #1%,'!'
	\	PRINT #1%,'A,3'
	\	PRINT
	\	PRINT'Answer'

11031		INPUT LINE ANSWER$
	\	ANSWER$=CVT$$(ANSWER$,4%)
	\	IF ANSWER$='!' THEN
			GOSUB 11100
	\		GOTO 11031

11032		PRINT #1%,ANSWER$
	\	PRINT #1%,'U'
	\	PRINT
	\	PRINT'Comment after wrong answer <NONE>'

11033		INPUT LINE FAILURE.COMMENT$
	\	FAILURE.COMMENT$=CVT$$(FAILURE.COMMENT$,4%)
	\	IF FAILURE.COMMENT$='!' OR FAILURE.COMMENT$='E' THEN
			GOSUB 11100
	\		GOTO 11033

11034		PRINT #1%,FAILURE.COMMENT$
	\	PRINT #1%
	\	PRINT #1%,'!'
	\	PRINT #1%,'BM,'+NUM1$(ITEM%+1%)+',2' UNLESS ITEM%=TOTAL.ITEMS%
	\	PRINT #1%,'BM,0,2' IF ITEM%=TOTAL.ITEMS%
	\	PRINT
	\	PRINT'Comment after second wrong answer <NONE>'

11035		INPUT LINE FAILURE.COMMENT$
	\	FAILURE.COMMENT$=CVT$$(FAILURE.COMMENT$,4%)
	\	IF FAILURE.COMMENT$='!' OR FAILURE.COMMENT$='E' THEN
			GOSUB 11100
	\		GOTO  11035

11036		PRINT #1%,'F'
	\	PRINT #1%,FAILURE.COMMENT$
	\	PRINT #1%
	\	PRINT #1%,'!'
	\	PRINT #1%,'E'

11040	  NEXT ITEM%
	! All segments have the same format and house-keeping.

11050	  RETURN

11100	!
	! ***** MESSAGE FOR ILLEGAL DECAL COMMAND ENTERED AS TEXT OR COMMENT *****
	!

11110	  PRINT'Do not use ! or E alone on a line as these are reserved DECAL'
	\ PRINT'command symbols. (Exception: You may use E alone for a correct'
	\ PRINT'answer when answer is called for.)'

11120	  RETURN

11200	!
	! ***** INSTRUCTIONS FOR USING CTRL-C TO STOP PROGRAM *****
	!

11210	  PRINT
	\ PRINT'You can enter part of your lesson, then use CTRL/C at any time'
	\ PRINT'to stop. (Hold CTRL key down and type C). Later, run DECAL:SETDEC'
	\ PRINT'again and ask for the same lesson to continue or complete it.

11220	  RETURN

11999	!
	! ***** GENERAL INSTRUCTIONS *****
	!
12000	  PRINT FNCLEAR.SCREEN$
	\ PRINT'	***** GENERAL INSTRUCTIONS *****'
	\ PRINT
	\ PRINT'With this program you can create two types of DECAL Computer-Assisted-'
	\ PRINT'Instruction (CAI) lessons.  First, you can write quizzes, and second,'
	\ PRINT'you can write lessons to teach new or review material.
	\ PRINT
	\ PRINT'There are <HELP> messages throughout the program.  To get help, use the'
	\ PRINT'RETURN key alone. In general, whatever is between < > is made effective'
	\ PRINT'by using the RETURN key alone.  < > means RETURN.'
	\ PRINT
	\ PRINT'Before using this program, you should have a list of'
	\ PRINT'quiz items or lesson material prepared.  The program allows'
	\ PRINT'you to enter prepared material in DECAL form.'
	\ PRINT
	\ GOSUB 11200
	\ PRINT'If you make errors while entering material, make a note of where'
	\ PRINT'the errors occurred.  Later, use DECAL:LEDIT or the system'
	\ PRINT'editor EDT to make your corrections.'

12005	  PRINT
	\ INPUT'Are you ready to proceed? (YES or NO) <NO>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ RETURN IF ASCII(OPTION$)=89%

12010	  PRINT
	\ PRINT'Please run the program again later, when you are ready.'
	\ PRINT
	\ GOTO 32760

12099	!
	! ***** INSTRUCTIONS FOR QUIZ OR LESSON *****
	!
12100	  PRINT FNCLEAR.SCREEN$
	\ PRINT'	***** QUIZ or LESSON *****'
	\ PRINT
	\ PRINT'You can now enter a quiz or an instructional lesson.'
	\ PRINT'If you select QUIZ then you may enter up to 47 questions,'
	\ PRINT'and the program will make up quizzes by random selection from'
	\ PRINT'those questions.  You also specify the number of items that'
	\ PRINT'will be selected for the quizzes.
	\ PRINT
	\ PRINT'If you select LESSON then you may enter up to 50 units'
	\ PRINT'of instruction, each unit containing some text and a practice'
	\ PRINT'question.
	\ PRINT
	\ PRINT'Text and questions will require you to enter more than one line.'
	\ PRINT'After you have entered the last line, use the <RETURN> key alone
	\ PRINT'to signal completion of the text or question entry.'
	\ GOSUB 11200

12110	  RETURN

12499	!
	! ***** INSTRUCTIONS FOR NAMING .CAI FILE *****
	!
12500	  PRINT FNCLEAR.SCREEN$
	\ PRINT'	***** NAMING THE DECAL LESSON FILE *****'
	\ PRINT
	\ PRINT'Enter a name for the new DECAL lesson you are writing.'
	\ PRINT'The name should be one to six characters, with the first'
	\ PRINT'character a letter, for example;'
	\ PRINT'LESON1 or L1 or CHPT12'
	\ GOSUB 11200

12510	  RETURN

12599	!
	! ***** INSTRUCTIONS FOR NAMING SUBJECT AREA OR TOPIC *****
	!
12600	  PRINT FNCLEAR.SCREEN$
	\ PRINT'	***** NAMING A SUBJECT AREA OR TOPIC *****'
	\ PRINT
	\ PRINT'An introductory statement will be given to the student'
	\ PRINT'indicating the number of quiz items and the quiz area.'
	\ PRINT'To identify the quiz area for the student, enter a word or two.'
	\ PRINT
	\ PRINT'Example;'
	\ PRINT
	\ PRINT'TEXT, CHAPTER 12 or GEOGRAPHY 114 or LECTURE 5 ON POE'
	\ PRINT
	\ GOSUB 11200

12610	  RETURN

12699	!
	! ***** INSTRUCTIONS FOR ITEMS OF INSTRUCTION *****
	!
12700	  PRINT FNCLEAR.SCREEN$
	\ PRINT'	***** ITEMS OF INSTRUCTION *****'
	\ PRINT
	\ PRINT'You can enter from one to fifty items of instruction.'
	\ PRINT'Each item will have four parts;'
	\ PRINT
	\ PRINT'1.  New or review material (text)'
	\ PRINT'	Students tend to skip over material if there are'
	\ PRINT'	over ten lines, item after item.  Be concise.'
	\ PRINT'2.  A question (completion, TF, or multiple-choice)'
	\ PRINT'	The question enables students to determine if they'
	\ PRINT'	understand the text. Frequent questions keep students'
	\ PRINT'	interested and active.'
	\ PRINT'3.  The correct answer'
	\ PRINT'	This program uses the  A,3  answer-type as described in'
	\ PRINT'	the DECAL manual.  You can specify one to five words in'
	\ PRINT'	an answer, each word separated by a space.  Each word'
	\ PRINT'	can take one to five variants, each variant separated'
	\ PRINT'	by a comma.'
	\ PRINT'4.  Comments to follow student errors'
	\ PRINT'	Comments will follow each wrong answer.  They can be'
	\ PRINT'	hints after the first error, or give the right answer'
	\ PRINT'	after the second error.'
	\ PRINT'	Comments are optional.  Use <RETURN> alone to omit a comment.'
	\ PRINT'5.  Students will have two chances to get each item correct.'

12710	  RETURN

12800	!
	! ***** SUBROUTINE FOR CTRL/C TERMINATION *****
	!

12805	  PRINT
	\ PRINT'Just a moment, please.'
	\ PRINT
	! It takes a while to check for completed segments.  The last segment
	! must be deleted if it is incomplete.  Reason; the lesson file will
	! be opened in append mode when completed later.

12810	  OPEN LESSON$+'.CAI' FOR INPUT  AS FILE #1%
	\ OPEN 'TEMP2.CAI'    FOR OUTPUT AS FILE #2%
	\ OPEN 'TEMP3.CAI'    FOR OUTPUT AS FILE #3%

12820	  WHILE -1%
	\	L%=L%+1%
	\	INPUT LINE #1%, A$
	\	A$=CVT$$(A$,4%)
	\	A$(L%)=A$ IF A$='!' OR A$='E' OR A$='A,3'
	\	PRINT #2%, A$
	\	IF A$(L%)='E' AND A$(L%-1%)='!' THEN
			CLOSE #2%
	\		OPEN 'TEMP2.CAI' FOR INPUT AS FILE #2%
	\		FOR I%=1% TO L%
	\			INPUT LINE #2%, A$
	\			A$=CVT$$(A$,4%)
	\			PRINT #3%, A$
	\		NEXT I%
	\		A$(L%)='' FOR L%=L% TO 0% STEP-1%
	\		CLOSE #2%
	\		OPEN 'TEMP2.CAI' FOR OUTPUT AS FILE #2%
	! Only complete segments are written to the TEMP3 file.
	! Notice that segment length may vary as a result of different numbers
	! of lines used by the author.  Hence, only the ! E sequence can be used
	! to signal end of complete segment. Looking for E alone will not
	! work, as a legal answer could be E in the answer block.

12830	  NEXT

12840	  CLOSE #1%,#2%,#3%
	\ KILL 'TEMP2.CAI'
	\ KILL  LESSON$+'.CAI'
	\ NAME 'TEMP3.CAI' AS LESSON$+'.CAI'
	! Get rid of unwanted files, then name TEMP3 as the file to keep.

12910	  PRINT'You have completed';ITEM%-1%;'of'TOTAL.ITEMS%;'segments.'
	\ PRINT'To finish your lesson, run the DECAL:SETDEC program again,'
	\ PRINT'and give the name of the lesson as ';LESSON$
	! Give needed sign-off messages to summarize the lesson so far.

12920	  RETURN
	! This return will only send user out of the program.

13000	!
	! ***** SUBROUTINE TO COUNT COMPLETED SEGMENTS IF LESSON EXISTS *****
	!

13005	  FOR I%=1% TO 2%
	\	INPUT LINE #1%, A$
	\	A$=CVT$$(A$,4%)
	! Input two lines of the lesson to reach the second line.

13010	  NEXT I%
	\ TOTAL.ITEMS%=VAL(RIGHT(A$,4%))
	! Find out how many segments there should be in all.

13030	  FOR I%=1% TO 2%
	\	INPUT LINE #1%, A$
	\	A$=CVT$$(A$,4%)
	\	IF INSTR(1%,A$,'quiz') THEN
		OPTION$='Q' ELSE OPTION$='L'
	! If the lesson is a quiz, the word quiz will appear in line four.

13040	  NEXT I%

13050	  WHILE -1%
	\	INPUT LINE #1%,A$
	\	A$=CVT$$(A$,4%)
	\	IF A$='!' OR A$='E' OR A$='A,3' THEN
			I%=I%+1%
	\		A$(I%)=A$ 

13060	  NEXT 
	! This loop will load an array with the DECAL commands ! and E and A,3.
	! Whenever ! is followed by E, that is the end of a segment.

13065	  ITEM%=ITEM%+1% IF A$(I%)='!' AND A$(I%+1%)='E' FOR I%=I% TO 0% STEP -1%
	\ IF ITEM%=TOTAL.ITEMS% THEN
		PRINT 'You finished segment';ITEM%;'of';TOTAL.ITEMS% IF OPTION$='L'
	\	PRINT 'You finished segment';ITEM%-3% 'of'TOTAL.ITEMS%-3% IF OPTION$='Q'
	\	CLOSE #1%
	\	RETURN
	! An item counter is incremented for every end-of-segment detected.
	! If all items have been completed, then an appropriate message is
	! printed, and the user is returned to the dialogue for a choice.

13067	  IF OPTION$='L' THEN PRINT 'You finished segment';ITEM% 'of'TOTAL.ITEMS% ELSE
	  IF OPTION$='Q' THEN PRINT 'You finished segment';ITEM%-2%'of'TOTAL.ITEMS%-3% 
	! These messages are given if the lesson is incomplete.

13070	  PRINT'Lesson is not complete' 
	\ CLOSE #1%

13080	  RETURN
	! User is returned to dialogue if lesson is incomplete.  User may
	! decide to complete the lesson, overwrite it, or leave the program.

15000	!
	****************************************************************
	*                                                              *
	*                       F U N C T I O N S                      *
	*                                                              *
	****************************************************************


	!
15010	  DEF FNCLEAR.SCREEN$
	\ PRINT CHR$(155%)+'H';CHR$(155%)+'J';
	\ FNEND

19000	!
	****************************************************************
	*                                                              *
	*                     E R R O R    T R A P S                   *
	*                                                              *
	****************************************************************


	!
19010	  IF ERR=5% THEN OPTION$='Y'
	\ RESUME 1065
	! An error occurs if the lesson file does not exist.  This informs
	! the program that the lesson will be a new one. The program
	! resumes with the option to create a new lesson, and the lesson
	! file is opened for output, and no error is created.

19020	  IF ERR=51% THEN PRINT 'Please enter a whole number'
	\ RESUME
	! Data format error is possible.

19030	  IF ERR=28% THEN CLOSE #1%
	\ RESUME 1085
	! Control-C trap is enabled.

19032	  IF ERR=11% AND ERL=13005 THEN OPTION$='Y'
	\ CLOSE #1%
	\ PRINT'(Lesson had zero length, was empty. A new file was created)'
	\ RESUME 1065
	! File was zero length, better open it for output and proceed.

19035	  IF ERR=11% AND ERL=13050 THEN RESUME 13065

19040	  IF ERR=11% AND ERL=12820 THEN RESUME 12840
	! End-of-files occur when the existing lesson file is read for
	! analysis.  There is no way to know just how long the file is
	! ahead of time.

19990	  ON ERROR GOTO 0
	! Return to default error handling for unexpected errors.
	!

32700	!
	****************************************************************
	*                                                              *
	*                    E O J    R O U T I N E S                  *
	*                                                              *
	****************************************************************


	!
32720	  PRINT
	\ PRINT'To create the lesson you have entered, type'
	\ PRINT'RUN DECAL:CREATE   It will ask "Do you have a source file?"'
	\ PRINT'Answer with  Y  then name the file as 'LESSON$
	\ PRINT'After lesson creation, it asks again "Do you have a source file?"'
	\ PRINT'Then, type the CTRL-C combination to terminate DECAL:CREATE
	\ PRINT
	\ PRINT'To try the lesson, type RUN DECAL:QUIZ and follow instructions.'
	! Instructions for use of DECAL:CREATE if lesson is completed.

32760	  NO EXTEND
	\ CLOSE #1%
	! Return to default no-extend terminal setting and close lesson file.


32767	  END
	! That's all she wrote!

