1	!


	!		S Q U I S H 



2!		Program:	SQUISH
3!		Version:	V02A
4!		Edit:		01
7!		Edit Date:	04-Jun-80
9!		Author:		Brant Cheikes/Dr. Terry F. O'Dwyer


15	EXTEND
	!  Set up BASIC-PLUS EXTEND mode processing

20	! &
	&
	&
	!	M o d i f i c a t i o n   H i s t o r y &
	&
	&
	!	Version/Edit	Edit Date	Reason &

21!		V02A-01		04-Jun-80	New release &

50	! &
	&
	&
	!	P r o g r a m   D e s c r i p t i o n &
	&
	&

60	! &
	!  SQUISH is designed to squish together files that were assembled &
	!  by APPENDing various modules together.  It is useful since  &
	!  partially filled blocks (which exist where there is the gap &
	!  between APPENDed files) cause editors such as EDT to interpret &
	!  the gap as an EOF and subsequently disallow editing beyond the &
	!  gap.  SQUISH eliminates such problems by spanning blocks and &
	!  'squishing' the file together without the gap(s). &
	! &
	!  SQUISH accepts a filename specification, creates a backup file &
	!  and proceeds to squish the given file. &
	! &
	!  This program was originally written by Dr. Terry F. O'Dwyer, Dean &
	!  of Instruction for Learning Resources of Nassau Community College. &
	!  The current version was done by Brant Cheikes, T.E.O.R.E. &
	! &

900	! &
	&
	&
	!	D i m e n s i o n   S t a t e m e n t s &
	&
	&

910	DIM TABLE%(256%) &
	!  Set up conversion table &

1000	! &
	&
	&
	!	M a i n   P r o g r a m   C o d i n g &
	&
	&

1010	V$ = "V02A-01" &
	!  Set up version/edit level &

1020	ON ERROR GOTO 30000 &
	\  PRINT &
	\  PRINT "SQUISH   "+V$+"   "+ &
	   CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)),3%),4%) &
	\  PRINT "Program Squisher" &
	\  PRINT &
	!  Output the system header &

1030	TABLE%(I%) = I%-1% FOR I% = 1% TO 256% &
	\  TABLE%(0%) = 256% &
	\  CHANGE TABLE% TO TABLE$ &
	!  Set up the table string for the XLATE conversion &

1040	PRINT "File to squish"; &
	\  INPUT LINE INSQU$ &
	\  INSQU$ = CVT$$(INSQU$,4%) &
	\  I% = INSTR(1%,INSQU$,'.') &
	\  GOTO 1050 IF I% &
	\  INSQU$ = INSQU$ + '.BAS' &
	\  I% = LEN(INSQU$) - 3% &
	!  Get the file to squish; look for a dot; if none, add default &
	!  extension and set length of filename minus extension &

1050	FIL$ = LEFT(INSQU$,I%-1%) + '.BAK' &
	!  Set up the backup filename &

1060	NAME INSQU$ AS FIL$ &
	!  Try to do a rename operation &

1070	OPEN FIL$ FOR INPUT AS FILE 1%, MODE 8192% &
	\  OPEN INSQU$ FOR OUTPUT AS FILE 2% &
	\  FIELD #1%, BUFSIZ(1%) AS INP$ &
	\  FIELD #2%, BUFSIZ(2%) AS OUTP$ &
	\  PRINT &
	\  PRINT "Squishing..." &
	\  PRINT &
	!  Open all files, field the buffers and tell user we are beginning &

2000	! &
	&
	&
	!	S q u i s h &
	&
	&

2010	GET #1% &
	\  STR$ = STR$ + XLATE(INP$,TABLE$) &
	\  IF LEN(STR$) < BUFSIZ(2%) THEN 2010 ELSE &
		   LSET OUTP$ = LEFT(STR$,BUFSIZ(2%)) &
		\  PUT #2% &
		\  STR$ = RIGHT(STR$,BUFSIZ(2%)+1%) &
	\  GOTO 2010 &
	!  Suck in some data to play with; add data to string; if string is &
	!  bigger than the output buffer, fill that buffer with as much data &
	!  as will fit cutting string properly; output; put remainder back &
	!  into the string and go back for another draught of data &

2020	IF LEN(STR$) = 0% THEN 3000 ELSE &
		   IF LEN(STR$) > BUFSIZ(2%) THEN 2030 ELSE &
	   LSET OUTP$ = STR$ + STRING$(BUFSIZ(2%)-LEN(STR$),0%) &
	\  PUT #2% &
	\  GOTO 3000 &
	!  We are closing up; check remainder to see if it is bigger than &
	!  the buffer; if so, handle accordingly else pad with nulls, do &
	!  the final output and go exit &

2030	LSET OUTP$ = LEFT(STR$,BUFSIZ(2%)) &
	\  PUT #2% &
	\  STR$ = RIGHT(STR$,BUFSIZ(2%)+1%) &
	\  GOTO 2020 &
	!  Put a bufferful of data out; cut string and go recheck length &

3000	! &
	&
	&
	!	C l o s e   U p &
	&
	&

3010	PRINT ">SPLATT!<   Your file has been squished." &
	\  PRINT &
	\  CLOSE #1%,2% &
	\  GOTO 32000 &
	!  Tell user we is finished and go exit &

30000	! &
	&
	&
	!	E r r o r   H a n d l i n g &
	&
	&

30010	IF ERL = 1060% AND ERR = 16% THEN PRINT &
	"%Superseding existing backup" &
	\  PRINT &
	\  KILL FIL$ &
	\  RESUME 1060 &
	!  If NAME AS statement fails, kill the existing backup and retry &

30015	IF ERL = 1060% AND ERR = 5% THEN PRINT &
	"?No file matching that specification - file ";INSQU$ &
	\  PRINT &
	\  RESUME 1040 &
	!  Handle no file errors &

30017	IF ERR = 2% THEN PRINT &
	"?Illegal filename - file ";INSQU$ &
	\  PRINT &
	\  RESUME 1040 &
	!  Handle bad filenames &

30020	IF ERL = 1060% THEN PRINT &
	"?Unable to delete or rename file" &
	\  PRINT &
	\  RESUME 32000 &
	!  If NAME AS fails and not due to existing file, we abort &

30030	IF ERL = 2010% AND ERR = 11% THEN RESUME 2020 &
	!  Handle EOF on input &

30800	IF ERR = 11% THEN RESUME 32000 &
	!  Exit fast on CTRL/Z &

30900	PRINT "?Unexpected error - "; &
	CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%),4%); &
	" - (ERR=";NUM1$(ERR);") at line";ERL &
	\  GOTO 32000 &
	!  Handle unexpected errors &

32000	! &
	&
	&
	!	E x i t &
	&
	&

32600	NO EXTEND
	!  Disable EXTEND mode processing

32700	S$ = SYS(CHR$(9%))
	!  Clear core and exit fast

32767	END
