1	!


	!		C O N V R T 



2!		Program:	CONVRT
3!		Version:	V01A
4!		Edit:		03
7!		Edit Date:	20-May-80
9!		Author:		Brant Cheikes


15	EXTEND
	!  Set up BASIC-PLUS EXTEND mode processing

20	! &
	&
	&
	!	M o d i f i c a t i o n   H i s t o r y &
	&
	&
	!	Version/Edit	Edit Date	Reason &

21!		V01A-01		04-May-80	New release &
  !		V01A-02		07-May-80	Fix conversion problem &
  !						before EXTEND statements &
  !						and after NOEXTEND statements &
  !		V01A-03		20-May-80	Fix backup file supersede &

50	! &
	&
	&
	!	P r o g r a m   D e s c r i p t i o n &
	&
	&

60	!  CONVRT is designed to convert BASIC-PLUS EXTEND mode programs &
	!  with <LF><CR><NULL> line continuation sequences to DEC standard &
	!  EXTEND mode programs.  It takes all occurrances of the <LF><CR> &
	!  <NULL> sequence within the file and changes them to <SPACE>&. &
	! &
	!  The specified input file is renamed to a .BAK file; the original &
	!  filename is OPENed FOR OUTPUT.  The .BAK input file is read in &
	!  read-only (MODE 8192%) mode. &
	! &

700	! &
	&
	&
	!	V a r i a b l e   I n i t i a l i z a t i o n &
	&
	&

710	CONT.SEQ$ = CHR$(10%)+CHR$(13%)+CHR$(0%)	! A <LF><CR><NULL> &
 	\  REPLACE.SEQ$ = CHR$(32%)+"&"			! <SPACE>ampersand &
	\  REPLACE.SEQ$ = REPLACE.SEQ$ + CHR$(13%)+CHR$(10%) &
	\  CRLF$ = CHR$(13%)+CHR$(10%) &
	!  <SPACE>ampersand sequence is followed by a <CR><LF> sequence &

1000	! &
	&
	&
	!	M a i n   P r o g r a m   C o d i n g &
	&
	&

1010	V$ = "V01A-03" &
	!  Set up version/edit level &

1020	ON ERROR GOTO 30000 &
	\  PRINT &
	\  PRINT "CONVRT   "+V$+"   "+ &
	   CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)),3%),4%) &
	\  PRINT "EXTEND Mode Converter" &
	\  PRINT &
	!  Output the system header &

1030	PRINT "File to convert"; &
	\  INPUT LINE CONVERT.FILE$ &
	\  CONVERT.FILE$ = CVT$$(CONVERT.FILE$,4%) &
	\  FIND.DOT% = INSTR(1%,CONVERT.FILE$,'.') &
	\  GOTO 1040 IF FIND.DOT% &

1035	THE.FILE$ = CONVERT.FILE$ + '.BAS' &
	\  NAME THE.FILE$ AS CONVERT.FILE$ + '.BAK' &
	\  GOTO 1050 &
	!  Get the file to convert and trim off line terminators; look for &
	!  a dot (indicates and extension); skip out if extension found else &
	!  use a '.BAS' default extension; rename this file to a '.BAK' file &

1040	THE.FILE$ = CONVERT.FILE$ &
	\  CONVERT.FILE$ = LEFT(THE.FILE$,FIND.DOT%-1%) &

1045	NAME THE.FILE$ AS CONVERT.FILE$ + '.BAK' &
	!  THE.FILE$ is the file entered since an explicit extension was &
	!  entered; set CONVERT.FILE$ to the filename minus the extension &
	!  Rename the input file, giving it a '.BAK' extension &

1050	OPEN THE.FILE$ FOR OUTPUT AS FILE 1% &
	\  OPEN CONVERT.FILE$ + '.BAK' FOR INPUT AS FILE 2%, MODE 8192% &
	!  Open the original file for output and the backup file for input &
	!  in read-only mode &

2000	! &
	&
	&
	!	C o n v e r s i o n   L o o p &
	&
	&

2010	PRINT &
	\  PRINT "Converting..." &
	\  PRINT &
	\  LINE.COUNT% = 0% &
	\  LF.COUNT% = 0% &
	\  GOSUB 10000 &
	!  Tell user we are beginning and reset counter of lines &
	!  Also reset counter of LF sequences found &

2020	INPUT LINE #2% LINE.IN$ &
	\  LINE.COUNT% = LINE.COUNT% + 1% &
	\  GOSUB 10500 &
	\  FIND.LF.SEQ% = INSTR(1%,LINE.IN$,CONT.SEQ$) &
	\  GOTO 2200 UNLESS FIND.LF.SEQ% &
	!  Get a line from the input file; look for the LF line continuation &
	!  sequence; skip out if none &
	!  Keep a count of the number of lines processed &

2030	LINE.OUT$ = LEFT(LINE.IN$,FIND.LF.SEQ%-1%) + REPLACE.SEQ$ &
	\  LINE.OUT$ = CHR$(9%)+"&"+CHR$(13%)+CHR$(10%) IF FIND.LF.SEQ% = 1% &
	\  LF.COUNT% = LF.COUNT% + 1% &
	\  PRINT #1% LINE.OUT$; &
	\  GOTO 2020 &
	!  Cut off the LF sequence and replace it with the DEC standard &
	!  sequence; count number of lines fixed in this way &

2200	PRINT #1% LINE.IN$; &
	\  GOTO 2020 &
	!  Output the line as is and go get another &

10000	! &
	&
	&
	!	S u b r o u t i n e s &
	&
	&
	!	E X T E N D   H u n t i n g &
	&
	&

10010	INPUT LINE #2% LINE.IN$ &
	\  LINE.COUNT% = LINE.COUNT% + 1% &
	\  COMPRESSED$ = CVT$$(LINE.IN$,2%+4%+32%) &
	\  FIND.EXT% = INSTR(1%,COMPRESSED$,"EXTEND") &
	\  GOTO 10030 IF FIND.EXT% &
	!  Get a line and increment the line counter; look for an EXTEND &
	!  statement; skip out if none &

10020	PRINT #1% LINE.IN$; &
	\  GOTO 10010 &
	!  Write out the line and go get another &

10030	I% = INSTR(1%,COMPRESSED$,"!") &
	\  GOTO 10020 IF I% < FIND.EXT% IF I% &
	\  I% = INSTR(1%,COMPRESSED$,"NOEXTEND") &
	\  GOTO 10020 IF I% &
	\  I% = INSTR(1%,COMPRESSED$,'"') &
	\  GOTO 10020 IF I% < FIND.EXT% IF I% &
	\  I% = INSTR(1%,COMPRESSED$,"'") &
	\  GOTO 10020 IF I% < FIND.EXT% IF I% &
	!  Check line for a valid occurrence of the EXTEND statement &

10200	PRINT #1% LINE.IN$; &
	\  GOTO 10300 IF INSTR(1%,LINE.IN$,CRLF$) &
	\  INPUT LINE #2% LINE.IN$ &
	\  LINE.COUNT% = LINE.COUNT% + 1% &
	\  GOTO 10200 &
	!  Print the line to the output file; skip out if there is a CRLF &
	!  sequence else get another line; count it and go write and re-test &
	!  it &

10300	RETURN &

10500	! &
	&
	&
	!	N O E X T E N D   H u n t i n g &
	&
	&

10510	COMPRESSED$ = CVT$$(LINE.IN$,2%+4%+32%) &
	\  I% = INSTR(1%,COMPRESSED$,"NOEXTEND") &
	\  GOTO 10530 IF I% &
	!  Squish the line down to size and look for a NOEXTEND statement; &
	!  Branch out if one is found &

10520	RETURN &

10530	I1% = INSTR(1%,COMPRESSED$,"!") &
	\  GOTO 10520 IF I1% < I% IF I1% &
	\  I1% = INSTR(1%,COMPRESSED$,'"') &
	\  GOTO 10520 IF I1% < I% IF I1% &
	\  I1% = INSTR(1%,COMPRESSED$,"'") &
	\  GOTO 10520 IF I1% < I% IF I1% &
	\  GOSUB 10020 &
	\  GOTO 10520 &
	!  A NOEXTEND statement was found; resume processing as if looking &
	!  for that initial EXTEND statement &

20000	! &
	&
	&
	!	F  u n c t i o n s &
	&
	&

20010	DEF* FNS$(NUMBER%) &
	!  This function returns "s were " if NUMBER% <> 1% and "was " if &
	!  NUMBER% = 1% &

20020	IF NUMBER% <> 1% THEN FNS$ = "s were " ELSE FNS$ = "was " &

20030	FNEND &

30000	! &
	&
	&
	!	E r r o r   H a n d l i n g &
	&
	&

30005	RESUME 30010		!  Re-enable error handling &

30010	IF ERR = 11% THEN IF ERL = 2020% OR &
			     ERL = 10010% OR &
			     ERL = 10200% THEN PRINT "Conversion completed" &
	\  CLOSE #1%,2% &
	\  PRINT &
	\  PRINT "Totals: ";LINE.COUNT%;"line";FNS$(LINE.COUNT%);"in your"; &
	\  PRINT " program" &
	\  PRINT "        ";LF.COUNT%;"line";FNS$(LF.COUNT%);"changed" &
	\  GOTO 32000 &
	!  If EOF on input, close all files, print totals and exit &

30020	IF ERR = 5% AND ERL = 1035% THEN PRINT "?File not found" &
	\  PRINT &
	\  GOTO 1030 &
	!  If input file does not exist, say so and get another &

30030	IF ERR = 16% AND ERL = 1035% THEN PRINT &
	\  PRINT "%Superseding existing backup file" &
	\  KILL CONVERT.FILE$ + '.BAK' &
	\  GOTO 1035 &

30040	IF ERR = 16% AND ERL = 1045% THEN PRINT &
	\  PRINT "%Superseding existing backup file" &
	\  KILL CONVERT.FILE$ + '.BAK' &
	\  GOTO 1045 &
	!  Take care of existing backup files &

30050	IF ERR = 10% AND ERL = 1050% THEN PRINT "?No access to files" &
	\  GOTO 32000 &
	!  Can't read or write files - abort &

30060	IF ERR = 11% THEN GOTO 32000 &
	!  Handle CTRL/Z on input &

30200	IF ERR = 10% THEN PRINT &
	"?Unable to delete file - aborting" &
	\  GOTO 32000 &

30900	PRINT "?Unexpected error - "; &
	CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%),4%); &
	" (ERR=";NUM1$(ERR);") at line";ERL &

32000	! &
	&
	&
	!	E x i t &
	&
	&

32600	NO EXTEND
	!  Disable EXTEND mode processing

32700	S$ = SYS(CHR$(9%))

32767	END
