10	!

		PROGRAM		: SETBMD.BAS
		VERSION		: 1
		EDIT		: 3A

		AUTHOR		: JOHN S. ABMA
		INSTALLATION	: WITTENBERG UNIVERSITY

		DATE		: 11-Feb-79


	!

20	!
	****************************************************************
	*                                                              *
	*            M O D I F I C A T I O N    H I S T O R Y          *
	*                                                              *
	****************************************************************


	!
21	!
	EDIT		DATE		REASON



	!

100	!
	****************************************************************
	*                                                              *
	*             P R O G R A M    D E S C R I P T I O N           *
	*                                                              *
	****************************************************************


	!
110	!
	  The purpose of this program is to facilitate use of the BMD
	computer programs.  The user is prompted to describe his analysis,
	and the program constructs a control file to reflect his description.

	  The resulting control file is displayed at the end of the program.
	If minor changes are needed from one analysis to another, we suggest
	that the system editor be used to effect those changes, rather than
	repeating the whole process with this program.

	  Most, but not all the functionality of the BMD programs is
	maintained.  Where a function is missing, it can be inserted with the
	system editor.

300	!
	****************************************************************
	*                                                              *
	*                    I / O    C H A N N E L S                  *
	*                                                              *
	****************************************************************


	!
320	!


	CHANNEL		FILE



	!

330	!
	  #1		P??.CTL		Control file being created.
	  #2		HELP??.BMD	Help files in departmental library.
					These files must be in a "0" programmer
					account, such as 100,0.  They are
					accessed in the program with the
					pound sign  #

400	!
	****************************************************************
	*                                                              *
	*                  V A R I A B L E S    U S E D                *
	*                                                              *
	****************************************************************


	!
420	!

		NUMERIC VARIABLES



	!


430	!
	ADD%		The number of new variables added by transformation.
	CASE%		The number of cases to use, if less than all.
	ERR		BASIC-PLUS error variable.
	GROUP%		The subscript of a variable for which grouping is
			specified, whether by codes or cutpoints (ranges).
	J%		Subscript for arrays holding variable names, including
			names created by data transformation, if any.
	LOOP%		Dummy variable to control loops.
	TOT.TRF%	Total number of transformations specified.

480	!

		ALPHABETIC VARIABLES



	!


490	!
	A.OR.B$		Option to determine whether checking for codes or
			cutpoints will observe values before or after trans-
			formation, if any.
	ANALYSIS$	The BMD analysis selected; ie, P1D or P4M.
	CUT.CODE$	The cutpoints or codes for variables for which grouping
			is specified.
	DATA.FILE$	The name of the file holding data to be analyzed.
	FNCLEAR$	User-defined function to clear screen and start at
			upper-left corner (home).
	FORMAT$		Fortran descripton of data.
	GROUP$		The name or subscript of a variable used to group
			other variables into categories.
	LABEL$		Variables containing labelling information (A-format).
	MISSING.VALUE.CODE$	Holds values which BMD will regard as missing
			data.
	NAM$(60)	Variable names.  (NAME cannot be used because it is a
			restricted variable name).
	OPTION$		All-purpose variable to hold user option specifications.
	T$		Holds strings developed by transformation, temporarily.
	TITLE$		Title for analysis.
	TRANSFORM$	Holds variable names developed by transformation.
	USE$		Variables to be used in the analysis.

800	!
	****************************************************************
	*                                                              *
	*      F U N C T I O N S    A N D    S U B R O U T I N E S     *
	*                                                              *
	****************************************************************


	!
820	!

		SUBROUTINES



	!


830	!
	1.  There is a subroutine for every analysis requested.
	2.  There are subroutines for;
		a). Transformations
		b). Specifying a grouping variable
		c). Grouping variables into codes or ranges (cutpoints)
		d). Brief help messages.

860	!

		FUNCTIONS


              
	!


870	!
	One user-defined function to clear screeen and place cursor at
	upper-left.

900	!
	****************************************************************
	*                                                              *
	*                 P R O G R A M    S E T    U P                *
	*                                                              *
	****************************************************************


	!
910	  ON ERROR GOTO 19000
	\ EXTEND
	\ TITLE$ = '   "CREATE CONTROL FILES FOR BMD PROGRAMS"'
	!


990	  PRINT FNCLEAR$;
	\ PRINT
	\ PRINT TITLE$
	\ PRINT
	\ TITLE$=SYS(CHR$(6%)+CHR$(9%)+CHR$(0%))
	\ LOOP%=INSTR(3%,TITLE$,CHR$(0%))
	\ PRINT MID(TITLE$,3%,LOOP%-3%);' JOB= ';ASCII(TITLE$)/2%;'  KB= ';ASCII(RIGHT(TITLE$,2%))
	\ PRINT
	!

	PRINT HEADER ROUTINE
	!



1000	!
	****************************************************************
	*                                                              *
	*                   M A I N L I N E    C O D E                 *
	*                                                              *
	****************************************************************


	!
1010	  DIM TRANSFORM$(50%), NAM$(100%)
	! 100 variable names can be entered, and 50 more added by transformation
	! Of course, these arrays can be made larger for gargantuan problems.

1030	  PRINT
	\ INPUT'Want instructions? Y or <NO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=89% THEN OPEN 'BMD:HELP01.BMD' AS FILE #2%
	\ GOSUB 13220
	! Help file is read at 13220

1040	  PRINT
	\ INPUT'What analysis? Form: P1D <LIST AVAILABLE>'ANALYSIS$
	\ ANALYSIS$=CVT$$(ANALYSIS$,-1%)
	\ IF ASCII(ANALYSIS$)=0% THEN OPEN 'BMD:HELP02.BMD' AS FILE #2%
	\ GOSUB 13220
	\ GOTO 1040
	! Another help file read, giving list of available BMD programs.
	! User is return to this same line for choice of analysis.

1045	  GOSUB 13300
	! Look at existing control file, if any.

1047	  OPEN ANALYSIS$+'.CTL' FOR OUTPUT AS FILE#1%
	! Creates the control file selected, with .CTL extension.

1050	  PRINT
	\ PRINT 'Title for analysis? (H for help) <BMD TITLE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,4%)
	\ GOSUB 13090 IF ASCII(OPTION$)=72%
	\ GOTO  1050  IF ASCII(OPTION$)=72%
	\ OPTION$= 'BMD ANALYSIS' UNLESS ASCII(OPTION$)
	\ PRINT #1%,"/PROBLEM"
	\ PRINT #1%,"		TITLE = '"OPTION$"'."
	!
	! Subroutine 13090 gives help in writing a title if user types  H
	! A default title is supplied if <RETURN> is used.
	! The control file (Channel #1%) gets necessary commands and
	! title and punctuation.

1055	  GOTO 1200 IF ANALYSIS$='P4D'

	\ PRINT #1%,'/INPUT'
	!
	! P4D is unique.  The entire control file is written in a subroutine,
	! skipping all the usual options.  It is also the least likely to be
	! used.  It only aids in checking the accuracy of data files.

1060	  PRINT
	\ INPUT'Name of data file; (HELP for help) Form: STUDY.DAT'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF OPTION$='HELP' THEN
	  GOSUB 13160
	\ GOTO 1060
	!
	! Help in naming a data file is found at 13160 if user types  HELP
	! Any other input becomes the FILE name in the INPUT paragraph.

1070	  PRINT #1%,"		FILE = '"OPTION$"'."
	! The necessary punctuation is added, and the file name is written
	! in the control file.

1080	  PRINT
	\ PRINT 'What is the format; (H for help) Form: F2.0,3F4.0'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=72% THEN
	  GOSUB 13170
	\ GOTO 1080
	! Help is available at 13170 for specifying format.

1090	  PRINT #1%,"		FORMAT = '(" OPTION$")'."

	\ PRINT
	\ INPUT'How many variables';OPTION%
	\ PRINT #1%,'		VARIABLES = 'OPTION%'.'
	! The format is printed in the control file.
	! User is asked to specify number of variables, and the
	! number is printed in the control file.

1100	  PRINT
	\ PRINT 'Names for variables? 
	\ GOSUB 12000 
	\ GOTO 1110 IF J%
	\ NAM$(1%)="'X(1)'." 

1110	  PRINT
	\ INPUT'Want variable transformations? (H for help) Y or <NO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=72% THEN OPEN 'BMD:HELP09.BMD' AS FILE #2%
	\ GOSUB 13220
	\ GOTO 1110

1115	  GOSUB 11000 IF ASCII(OPTION$)=89%
	\ GOTO 1130 UNLESS TOT.TRF%

1120	  PRINT
	\ INPUT'Check limits after or before transformation? (H for help) A or <BEFORE>'A.OR.B$
	\ A.OR.B$=CVT$$(A.OR.B$,-1%)
	\ IF ASCII(A.OR.B$)=72% THEN
	  GOSUB 13180
	\ GOTO 1120

1130	  PRINT
	\ INPUT'Want to use fewer than all cases? (H for help) Y or <NO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ GOSUB 13000 IF ASCII(OPTION$)=72%
	\ GOTO  1130  IF ASCII(OPTION$)=72%
	\ IF ASCII(OPTION$)=89% THEN
	  PRINT
	\ INPUT'How many cases? <END OF FILE>'OPTION%
	\ PRINT #1%,'		CASE = 'OPTION%'.' IF OPTION%

1140	  GOSUB 12100
	\ PRINT
	\ PRINT		'H   = Help'
	\ PRINT		'V   = Use selected variables'
	\ PRINT		'MIS = Missing value codes'
	\ PRINT		'MAX = Maximum value to be analyzed'
	\ PRINT		'MIN = Minimum value to be analyzed'
	\ PRINT		'L   = Labelling variable(s) (A-format)'

1150	  PRINT
	\ PRINT 'Options; enter letter for each. Form: VMISMAXMINL <NONE>'
	\ INPUT OPTION1$
	\ OPTION1$=CVT$$(OPTION1$,-1%)
	\ IF INSTR(1%,OPTION1$,'H') THEN OPEN 'BMD:HELP03.BMD' AS FILE #2%
	\ GOSUB 13220
	\ GOTO 1150

1160	  IF INSTR(1%,OPTION1$,'V') THEN
	  PRINT
	\ PRINT 'Use which variables in analysis? Form: VAR,VAR or 1,2 or 1 TO 4 <ALL>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ PRINT #1%,'		USE = 'OPTION$'.' 

1170	  IF INSTR(1%,OPTION1$,'L') THEN
	  PRINT
	\ INPUT'What labelling variable(s)? Form: VAR,VAR or 1,2'OPTION$
	\ PRINT #1%,'		LABEL = 'OPTION$'.' 

1180	  IF INSTR(1%,OPTION1$,'MIS') THEN
	  PRINT
	\ PRINT 'Enter missing value codes; Form: 999,-1,-9,0 or (3)-9,(4)0
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		MISSING = 'OPTION$'.' IF ASCII(OPTION$)

1183	  IF INSTR(1%,OPTION1$,'MAX') THEN
	  PRINT
	\ PRINT 'Enter maximum for each variable'
	\ PRINT 'Form: 9999,100,900,999 or (2)100,(4)999 <NONE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		MAXIMUM = 'OPTION$'.' IF ASCII(OPTION$)

1185	  IF INSTR(1%,OPTION1$,'MIN') THEN
	  PRINT
	\ PRINT 'Enter minimum for each variable'
	\ PRINT 'Form: 1,10,3,20,15 or (2)10,(5)15 <NONE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		MINIMUM = 'OPTION$'.' IF ASCII(OPTION$)

1190	  PRINT #1%,'		AFTER.' IF ASCII(A.OR.B$)=65%
	\ PRINT #1%,'		ADD = 'ADD%'.' IF ADD%
	\			GOSUB 11100 UNLESS ANALYSIS$='P1D' OR
						   ANALYSIS$='P2D' OR
						   ANALYSIS$='P7D' OR
						   ANALYSIS$='P4M' OR
						   ANALYSIS$='P1F'
	\ PRINT #1%,'/TRANSFORM'IF TOT.TRF%
	\		FOR LOOP%=1% TO TOT.TRF%
	\ PRINT #1%,			TAB(16%);
	\ PRINT #1%,			TRANSFORM$(LOOP%)'.' 
	\		NEXT LOOP%

1200	  IF ANALYSIS$='P1D' THEN GOSUB 10100 ELSE
	  IF ANALYSIS$='P2D' THEN GOSUB 10200 ELSE
	  IF ANALYSIS$='P3D' THEN GOSUB 10300 ELSE
	  IF ANALYSIS$='P4D' THEN GOSUB 10400 ELSE
	  IF ANALYSIS$='P5D' THEN GOSUB 10500 ELSE
	  IF ANALYSIS$='P6D' THEN GOSUB 10600 ELSE
	  IF ANALYSIS$='P7D' THEN GOSUB 10700 ELSE
	  IF ANALYSIS$='P1V' THEN GOSUB 10720 ELSE
	  IF ANALYSIS$='P2V' THEN GOSUB 10750 ELSE
	  IF ANALYSIS$='P1F' THEN GOSUB 10780 ELSE
	  IF ANALYSIS$='P4M' THEN GOSUB 10800 ELSE
	  IF ANALYSIS$='P3S' THEN GOSUB 10820 ELSE
	  IF ANALYSIS$='P1R' THEN GOSUB 10830

1210	  PRINT #1%,'/END'
	\ CLOSE #1%
	\ GOTO 1045
	! Line 1045 is the entry point for reviewing existing .CTL files.

10000	!
	****************************************************************
	*                                                              *
	*                     S U B R O U T I N E S                    *
	*                                                              *
	****************************************************************


	!
10099	!
	! ***** P1D *****
	!
10100	  GOSUB 11120
	\ GOTO 10130 UNLESS INSTR(1%,OPTION1$,'MIS') OR
			    INSTR(1%,OPTION1$,'MAX') OR
			    INSTR(1%,OPTION1$,'MIN')
	
10105	  PRINT
	\ PRINT	'MIS = Print cases having missing value codes' IF INSTR(1%,OPTION1$,'MIS')
	\ PRINT	'MAX = Print cases above maximum stated earlier' IF INSTR(1%,OPTION1$,'MAX')
	\ PRINT	'MIN = Print cases below minimum stated earlier' IF INSTR(1%,OPTION1$,'MIN')
	\ PRINT
	\ INPUT 'Options; Enter capitals. Form: MISMAXMIN <NONE>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)

10110	  PRINT #1%,'/PRINT' IF ASCII(OPTION$)
	\ PRINT #1%,'		MISSING.' IF INSTR(1%,OPTION$,'MIS')
	\ PRINT #1%,'		MAXIMUM.' IF INSTR(1%,OPTION$,'MAX')
	\ PRINT #1%,'		MINIMUM.' IF INSTR(1%,OPTION$,'MIN')
	\ RETURN

10130	  PRINT
	\ INPUT 'Want data file printed? Y or <NO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=89% THEN
	  PRINT #1%,'/PRINT'
	\ PRINT #1%,'			DATA.'

10180	  RETURN

10199	!
	! ***** P2D *****
	!
10200	!
10280	  RETURN

10299	!
	! ***** P3D *****
	!
10300	  GOSUB 11120
	\ PRINT #1%,'/TEST'
	\ PRINT #1%,'		CORRELATIONS.'
	\ PRINT #1%,'		HOTELLING.'

10380	  RETURN

10399	!
	! ***** P4D *****
	!
10400	  OPEN 'P4D.CTL' FOR OUTPUT AS FILE#1%
	\ PRINT #1%,"/PROBLEM	TITLE = '"OPTION$"'."

	\ PRINT
	\ INPUT'Name of data file? Form: MYDATA.DAT'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,"/INPUT		FILE = '"OPTION$"'."

	\ PRINT
	\ INPUT'Want to use fewer than all cases? Y or <NO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=89% THEN
	  PRINT
	\ INPUT'How many cases? <END OF FILE>'OPTION%
	\ PRINT#1%,'		CASE = 'OPTION%'.' IF OPTION%

10410	  PRINT
	\ PRINT		'H  = Help'
	\ PRINT		'PR = Print data file'
	\ PRINT		'A  = Replace letters with @'
	\ PRINT		'N  = Replace numbers with blank space'
	\ PRINT		'B  = Replace blanks  with &'
	\ PRINT		'PE = Replace periods with !'
	\ PRINT		'SI = Replace + or -  with $'
	\ PRINT		'SY = Replace symbols with S'
	\ PRINT		'IL = Replace illegal values with *'

10420	  PRINT
	\ INPUT 'Options; Type capitals. Form: PRANBPESISYIL <NONE>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=72% THEN OPEN 'BMD:HELP10.BMD' AS FILE #2%
	\ GOSUB 13220
	\ GOTO 10420

10430	  PRINT #1%,'/PRINT' IF ASCII(OPTION$)
	\ PRINT #1%,"		ALPHABETIC = '@'." IF INSTR(1%,OPTION$,'A' )
	\ PRINT #1%,"		NUMBERIC   = ' '." IF INSTR(1%,OPTION$,'N' )
	\ PRINT #1%,"		BLANK      = '&'." IF INSTR(1%,OPTION$,'B' )
	\ PRINT #1%,"		PERIOD     = '!'." IF INSTR(1%,OPTION$,'PE')
	\ PRINT #1%,"		SIGN       = '$'." IF INSTR(1%,OPTION$,'SI')
	\ PRINT #1%,"		SYMBOL     = 'S'." IF INSTR(1%,OPTION$,'SY')
	\ PRINT #1%,"		ILLEGAL    = '*'." IF INSTR(1%,OPTION$,'IL')

10480	  RETURN

10499	!
	! ***** P5D *****
	!
10500	  GOSUB 11120

	\ PRINT
	\ PRINT 'Graphs?  Form: HIST,NORM,HALFNORM,DNORM,CUM,CHIST <HIST>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ OPTION$='HIST' UNLESS ASCII(OPTION$)
	\ PRINT #1%,'/PLOT		TYPE = 'OPTION$'.'

	\ PRINT
	\ PRINT 'Size for graphs? Form: WIDE,HIGH <30,15>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ OPTION$='30,15' UNLESS ASCII(OPTION$)
	\ PRINT #1%,'		SIZE = 'OPTION$'.'

	\ PRINT
	\ PRINT 'Variables to plot? Form: VAR,VAR or 1,2 or 2 TO 4 <ALL>
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ PRINT #1%,'		VARIABLE = 'OPTION$'.' IF ASCII(OPTION$)

10505	  PRINT
	\ INPUT'Want specific groups plotted? Y or <NO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ RETURN UNLESS ASCII(OPTION$)=89%

10520	  PRINT
	\ PRINT "Group(s) to plot? Form: VAR or 1 or VAR,VAR or 1,2 <NO MORE>"
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ RETURN UNLESS ASCII(OPTION$)
	\ PRINT #1%,'		GROUP = 'OPTION$'.'
	\ GOTO 10520

10599	!
	! ***** P6D *****
	!

10600	  GOSUB 11120

	\ PRINT
	\ PRINT 'Variables for X-axis? Form: VAR,VAR <FIRST LISTED>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ OPTION$= LEFT(NAM$(1%),LEN(NAM$(1%))-1%) UNLESS ASCII(OPTION$)
	\ PRINT #1%,'/PLOT		XVAR = 'OPTION$'.' 

	\ PRINT
	\ PRINT 'Variables for Y-axis? Form: VAR,VAR <LAST LISTED>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		YVAR = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT
	\ INPUT'Plot each var against each other? Y or <PAIRS ONLY>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		CROSS.' IF ASCII(OPTION$)=89%

	\ PRINT
	\ PRINT 'What size for plots? Form: WIDE,HIGH <30,15>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ OPTION$='30,15' UNLESS ASCII(OPTION$)
	\ PRINT #1%,'		SIZE = 'OPTION$'.'
	\ PRINT #1%,'		STATISTICS.'

10610	  PRINT
	\ INPUT'Want specific groups plotted? Y or <NO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ RETURN UNLESS ASCII(OPTION$)=89%

10620	  PRINT
	\ PRINT "Group(s) to plot? Form: VAR or 1 or VAR,VAR or 1,2 <NO MORE>"
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ RETURN UNLESS ASCII(OPTION$)
	\ PRINT #1%,'		GROUP = 'OPTION$'.'
	\ GOTO 10620

10699	!
	! ***** P7D *****
	!

10700	  GOSUB 11100
	\ PRINT #1%,'/HISTOGRAM 	GROUPING = 'GROUP$'.' 

	\ PRINT 'Analyze what variables? Form: VAR,VAR or 1,2 or 1 TO 4 <ALL>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ PRINT #1%,'		VARIABLE = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT 'Increment for histogram? (One per variable)'

	\ PRINT 'Form: 5,1,3  <DEFAULT> Default is (MAX-MIN/INTERVAL)'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		INCREMENT = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT 'How many intervals in histogram? (One per variable)'

	\ PRINT 'Form: 5,1,3  <MINIMUM>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		INTERVAL = 'OPTION$'.' IF ASCII(OPTION$)
	\ GOSUB 11120

	\ PRINT
	\ PRINT 'H = Help'
	\ PRINT 'D = Data printed'
	\ PRINT 'O = Order data by grouping variable, then print'
	\ PRINT 'C = Correlations among all variables'
	\ PRINT 'W = Winsorized means'

10710	  PRINT
	\ PRINT 'Type letter for each option desired; Form: DOCW <NONE>'
	\ INPUT OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ RETURN UNLESS ASCII(OPTION$)
	\ IF ASCII(OPTION$)=72% THEN OPEN 'BMD:HELP08.BMD' AS FILE #2%
	\ GOSUB 13220
	\ GOTO 10710

10715	  PRINT #1%,'/PRINT' IF ASCII(OPTION$)
	\ PRINT #1%,'		DATA.'  IF INSTR(1%,OPTION$,'D')
	\ PRINT #1%,'		ORDER.' IF INSTR(1%,OPTION$,'O')
	\ PRINT #1%,'		CORR.'  IF INSTR(1%,OPTION$,'C')
	\ PRINT #1%,'		WINSOR.'IF INSTR(1%,OPTION$,'W')
	\ RETURN

10719	!
	! ***** P1V *****
	!

10720	  GOSUB 11120
	\ PRINT
	\ PRINT 'Dependent variables? Form: VAR,VAR or 1,2 or 2 TO 5 <ALL>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ PRINT #1%,"/DESIGN	TITLE = 'ONE WAY ANALYSIS'."
	\ PRINT #1%,'		DEPENDENT = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT 'Covariates? Form: 2,4,6 <NONE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		INDEPENDENT = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT
	\ INPUT'Scatterplots? Y or <NO>'OPTION$
	\ PRINT #1%,'		PLOT.' IF ASCII(OPTION$)=89%
	\ PRINT #1%,'/PRINT	CORRELATION.'

10730	  PRINT
	\ PRINT	  'ME = MEans for each group'
	\ PRINT   'CO = Covariance matrix for each group'
	\ PRINT   'T  = Variance-covariance matrix (no grouping)'
	\ PRINT   'B  = Variance-covariance matrix (between groups)'
	\ PRINT   'W  = Variance-covariance matrix (withing groups)'
	\ PRINT   'R  = Correlations between coefficients of covariates'
	\ PRINT   'MC = Correlations between adjusted group means'

	\ PRINT
	\ INPUT'Enter one or two capitals. Form: MECOTBWRMC <NONE>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)

	\ PRINT #1%,'		MEAN.'		IF INSTR(1%,OPTION$,'ME')
	\ PRINT #1%,'		COVARIANCE.'	IF INSTR(1%,OPTION$,'CO')
	\ PRINT #1%,'		TOTAL.'		IF INSTR(1%,OPTION$,'T' )
	\ PRINT #1%,'		BETWEEN.'	IF INSTR(1%,OPTION$,'B' )
	\ PRINT #1%,'		WITHIN.'	IF INSTR(1%,OPTION$,'W' )
	\ PRINT #1%,'		RREGRESSION.'	IF INSTR(1%,OPTION$,'R' )
	\ PRINT #1%,'		MCORRELATION.'	IF INSTR(1%,OPTION$,'MC')

10740	  RETURN

10749	!
	! ***** P2V *****
	!
10750	  PRINT
	\ PRINT 'Dependent variables? Form: VAR,VAR or 1,2 or 1 TO 5 <SECOND LISTED>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,36%)
	\ OPTION$='2' UNLESS ASCII(OPTION$)
	\ PRINT #1%,'/DESIGN		DEPENDENT = 'OPTION$'.'

	\ PRINT
	\ INPUT'Is this a repeated measures design? Y or <NO>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ GOTO 10765 UNLESS ASCII(OPTION$)=89%

10755	  PRINT
	\ PRINT 'Levels of trial factors; (H for help) Form: 1,2 <NONE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=72% THEN
	  GOSUB 13200
	\ GOTO 10755

10757	  PRINT #1%,'		LEVEL = 'OPTION$'.' IF ASCII(OPTION$)
	\ PRINT
	\ PRINT 'Names for trial factors? Form TRIAL,DAY <NONE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		NAME = 'OPTION$'.' IF ASCII(OPTION$)

10765	  PRINT
	\ PRINT 'Covariates? Form: 2,4,6 <NONE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		COVARIATE = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT
	\ INPUT'Want orthogonal decompositions? Y or <NO>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		ORTHOGONAL.' IF ASCII(OPTION$)=89%

	\ PRINT
	\ INPUT'Want residuals printed? Y or <NO>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		PRINT.' IF ASCII(OPTION$)=89%
	\ PRINT #1%,'		GROUPING = 'GROUP$'.' IF ASCII(GROUP$)
	\			GOSUB 11120

10775	  RETURN

10779	!
	! ***** P1F *****
	!
10780	  PRINT
	\ INPUT'Want pair-wise or cross-compare? CROSS or <PAIR>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ OPTION$='PAIR' UNLESS ASCII(OPTION$)=67%
	\ OPTION$='CROSS' IF ASCII(OPTION$)=67%
	\ PRINT #1%,'/TABLE			'OPTION$'.'

	\ PRINT
	\ PRINT 'What ROW variables? Form: VAR,VAR or 1,2'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		ROW = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT
	\ PRINT 'What COLUMN variables? Form: VAR,VAR or 1,2'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		COLUMN = 'OPTION$'.' IF ASCII(OPTION$)

10784	  PRINT
	\ PRINT 'Want above tables formed for each level of one or'
	\ INPUT 'more additional variables? (H for help) Y or <NO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=72% THEN OPEN 'BMD:HELP13.BMD' AS FILE #2%
	\ GOSUB 13220
	\ GOTO 10784

10785	  IF ASCII(OPTION$)=89% THEN
	  PRINT
	\ PRINT 'List variables for which you want tables at each level;'
	\ INPUT 'Form: VAR,VAR or 1,2'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ PRINT #1%,'		CONDITION = 'OPTION$'.'

10786	  GOSUB 11120
	\ PRINT
	\ PRINT'What tables do you want printed? (H for help)'
	\ PRINT
	\ PRINT		'OB = Observed frequencies'
	\ PRINT		'EX = Expected frequencies'
	\ PRINT		'RO = Row percentages'
	\ PRINT		'CO = Column percentages'
	\ PRINT		'TO = Percentages of total frequency'
	\ PRINT		'DI = Differences'
	\ PRINT		'ST = Standardized deviations'
	\ PRINT		'AD = Adjusted standardized deviations'
	\ PRINT		'FR = Freeman-Tukey deviates'
	\ PRINT		'SM = Smoothed values'

10788	  PRINT
	\ INPUT'Type capital letters for each option; Form: OBEXROCOTODISTADFRSM <OBEXTO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=72% THEN OPEN 'BMD:HELP11.BMD' AS FILE #2%
	\ GOSUB 13220
	\ GOTO 10788

10790	  OPTION$='OBEXTO' UNLESS ASCII(OPTION$)
	\ PRINT #1%,'/PRINT' IF ASCII(OPTION$)
	\ PRINT #1%,'		OBSERVED.'	IF INSTR(1%,OPTION$,'OB')
	\ PRINT #1%,'		EXPECTED.'	IF INSTR(1%,OPTION$,'EX')
	\ PRINT #1%,'		ROWPERCENT.'	IF INSTR(1%,OPTION$,'RO')
	\ PRINT #1%,'		COLPERCENT.'	IF INSTR(1%,OPTION$,'CO')
	\ PRINT #1%,'		TOTPERCENT.'	IF INSTR(1%,OPTION$,'TO')
	\ PRINT #1%,'		DIFFERENCE.'	IF INSTR(1%,OPTION$,'DI')
	\ PRINT #1%,'		STANDARDIZED.'	IF INSTR(1%,OPTION$,'ST')
	\ PRINT #1%,'		ADJUSTED.'	IF INSTR(1%,OPTION$,'AD')
	\ PRINT #1%,'		FREEMAN.'	IF INSTR(1%,OPTION$,'FR')
	\ PRINT #1%,'		SMOOTHED.'	IF INSTR(1%,OPTION$,'SM')

10792	  PRINT
	\ PRINT 'What statistics would you like printed? (H for help)'
	\ PRINT
	\ PRINT		'CH = Chi-Square'
	\ PRINT		'CON= Contingency table'
	\ PRINT		'LR = Likelihood ratio'
	\ PRINT		"FI = Fisher's exact probabilities"
	\ PRINT		'TE = Tetrachoric correlation'
	\ PRINT		'COR= Product-moment correlation'
	\ PRINT		'SP = Spearman rank correlation'
	\ PRINT		"GA = Gamma (Kendall's, Stuart's and Somer's statistics)"
	\ PRINT		'LA = Lambda statistic'
	\ PRINT		'LS = Lambda-Star statistic'
	\ PRINT		"TA = Goodman and Kruskall's T"
	\ PRINT		'UN = Uncertainty coefficients'
	\ PRINT		"MC = McNemar's test of symmetry'

10794	  PRINT
	\ INPUT 'Type capitals; Form: CHCONLRCORLSMC <CHCOR>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=72% THEN OPEN 'BMD:HELP12.BMD' AS FILE#2%
	\ GOSUB 13220
	\ GOTO 10794

10796	  OPTION$='CHCOR' UNLESS ASCII(OPTION$)
	\ PRINT #1%,'/STATISTICS' IF ASCII(OPTION$)
	\ PRINT #1%,'		CHISQUARE.'	IF INSTR(1%,OPTION$,'CH')
	\ PRINT #1%,'		CONTINGENCY.'	IF INSTR(1%,OPTION$,'CON')
	\ PRINT #1%,'		LRCHI.'		IF INSTR(1%,OPTION$,'LR' )
	\ PRINT #1%,'		FISHER.'	IF INSTR(1%,OPTION$,'FI' )
	\ PRINT #1%,'		TETRACHORIC.'	IF INSTR(1%,OPTION$,'TE' )
	\ PRINT #1%,'		CORRELATION.'	IF INSTR(1%,OPTION$,'COR')
	\ PRINT #1%,'		SPEARMAN.'	IF INSTR(1%,OPTION$,'SP' )
	\ PRINT #1%,'		GAMMA.'		IF INSTR(1%,OPTION$,'GA' )
	\ PRINT #1%,'		LAMBDA.'	IF INSTR(1%,OPTION$,'LA' )
	\ PRINT #1%,'		LSTAR.'		IF INSTR(1%,OPTION$,'LS' )
	\ PRINT #1%,'		TAUS.'		IF INSTR(1%,OPTION$,'TA' )
	\ PRINT #1%,'		UNCERTAINTY.'	IF INSTR(1%,OPTION$,'UN' )
	\ PRINT #1%,'		MCNEMAR.'	IF INSTR(1%,OPTION$,'MC' )

10798	  RETURN

10799	!
	! ***** P4M *****
	!

10800	!

10805	  RETURN

10819	!
	! ***** P3S *****
	!

10820	  GOSUB 11120

	\ PRINT
	\ PRINT 'Title for test? Form: Any <NON-PARAMETRIC TEST>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,4%)
	\ OPTION$='NON-PARAMETRIC TEST' UNLESS ASCII(OPTION$)
	\ PRINT #1%,"/TEST		TITLE = '"OPTION$"'."

	\ PRINT
	\ PRINT 'Analyze which variables? Form VAR,VAR or 1,2 <ALL>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,4%)
	\ PRINT #1%,'		VARIABLE = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT
	\ PRINT	  'SIgn test'
	\ PRINT   'Wilcoxon signed-rank'
	\ PRINT   'Friedman two-way analysis of variance'
	\ PRINT   'KRuskal-Wallis one-way analysis of variance'
	\ PRINT   'KEndall rank correlation'
	\ PRINT   'SPearman rank correlation'

10822	  PRINT
	\ PRINT 'Options; enter one or two capital letters. Form: SIWFKRKESP <HELP>
	\ INPUT OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=0% THEN OPEN 'BMD:HELP05.BMD' AS FILE #2%
	\ GOSUB 13220
	\ GOTO 10822

10825	  PRINT #1%,'		SIGN.'     IF INSTR(1%,OPTION$,'SI')
	\ PRINT #1%,'		WILCOXON.' IF INSTR(1%,OPTION$,'W' )
	\ PRINT #1%,'		FRIEDMAN.' IF INSTR(1%,OPTION$,'F' )
	\ PRINT #1%,'		KRUSKAL.'  IF INSTR(1%,OPTION$,'KR')
	\ PRINT #1%,'		KENDALL.'  IF INSTR(1%,OPTION$,'KE')
	\ PRINT #1%,'		SPEARMAN.' IF INSTR(1%,OPTION$,'SP')

10827	  RETURN

10829	!
	! ***** P1R *****
	!

10830	  GOSUB 11120

	\ PRINT #1%,"/REGRESS	TITLE = 'Multiple Linear Regression'."
	\ PRINT
	\ PRINT 'Dependent variable? Form: VAR or 1 < 1 >'
	\ INPUT LINE OPTION$
	\ OPTION$ = CVT$$(OPTION$,60%)
	\ OPTION$='1' UNLESS ASCII(OPTION$)
	\ PRINT #1%,'		DEPENDENT = 'OPTION$'.'

	\ PRINT
	\ PRINT 'Independent variables? Form: VAR,VAR or 1,2 or 2 TO 4 <ALL POSSIBLE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ PRINT #1%,'		INDEPENDENT = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT
	\ PRINT 'D = Data file printed.'
	\ PRINT 'COV = COVariance matrix printed.'
	\ PRINT 'COR = CORrelation matrix printed.'
	\ PRINT 'RE  = REgression coefficients correlation matrix printed.'
	\ PRINT
	\ PRINT 'Options; Type capital letters. Form: DCOVCORRE <NONE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)

	\ PRINT #1%,'/PRINT' IF ASCII(OPTION$)
	\ PRINT #1%,'		DATA.'		IF INSTR(1%,OPTION$,'D'  )
	\ PRINT #1%,'		COVARIANCE.'	IF INSTR(1%,OPTION$,'COV')
	\ PRINT #1%,'		CORRELATION.'	IF INSTR(1%,OPTION$,'COR')
	\ PRINT #1%,'		RREG.'		IF INSTR(1%,OPTION$,'RE' )

10835	  PRINT
	\ PRINT 'What length X and Y axes for plots? Form: 50,50 <50,50>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ OPTION$='50,50' UNLESS ASCII(OPTION$)
	\ PRINT #1%,'/PLOT		SIZE = 'OPTION$'.'

	\ PRINT
	\ PRINT 'What are the variables against which predicted and'
	\ PRINT 'observed values and residuals are to be plotted?'
	\ PRINT 'Form: VAR,VAR or 1,2 or 2 TO 4 <NONE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ PRINT #1%,'		VARIABLE = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT
	\ PRINT 'What variables to use in partial resicual plots?'
	\ PRINT 'Form: VAR,VAR or 1,2 or 2 TO 4 <NONE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ PRINT #1%,'		PREP = 'OPTION$'.' IF ASCII(OPTION$)

	\ PRINT
	\ PRINT 'R = Residuals plotted against predicted values.'
	\ PRINT 'N = Normal probability plot of residuals.'
	\ PRINT 'D = Detrended probability plot of residuals.'
	\ PRINT
	\ PRINT 'Options; Type capital letter for each. Form: RND <NONE>'
	\ INPUT LINE OPTION$
	\ OPTION$=CVT$$(OPTION$,60%)
	\ PRINT #1%,'		RESIDUAL.' IF INSTR(1%,OPTION$,'R')
	\ PRINT #1%,'		NORMAL.'   IF INSTR(1%,OPTION$,'N')
	\ PRINT #1%,'		DNORMAL.'  IF INSTR(1%,OPTION$,'D')

10840	  RETURN

10999	!
	! ***** TRANSFORMATIONS *****
	!

11000	  PRINT
	\ PRINT 'Form: OLDorNEW VAR = OLD VAR + OLD VAR  (or + VALUE)'

11010	  TOT.TRF%=TOT.TRF%+1%

	\ PRINT
	\ PRINT 'Enter transformation? <NO MORE>'
	\ INPUT LINE TRANSFORM$(TOT.TRF%)
	\ TRANSFORM$(TOT.TRF%)=CVT$$(TRANSFORM$(TOT.TRF%),-1%)
	\ GOTO 11020 IF ASCII(TRANSFORM$(TOT.TRF%))
	\ TOT.TRF%=TOT.TRF%-1% 
	\ RETURN 

11020	  T$=LEFT(TRANSFORM$(TOT.TRF%),INSTR(1%,TRANSFORM$(TOT.TRF%),'=')-1%)
	\ GOTO 11010 IF INSTR(1%,NAM$(LOOP%),T$) FOR LOOP%=1% TO J% 
	\ T$="'"+T$+"'"
	\ NAM$(J%)=LEFT(NAM$(J%),LEN(NAM$(J%))-1%)+','

11030	  J%=J%+1%

11040	  NAM$(J%)=T$+'.'
	\ ADD%=ADD%+1%
	\ GOTO 11010

11099	!
	! ***** NAME A GROUPING VARIABLE IN VARIABLE PARAGRAPH *****
	!

11100	  PRINT
	\ INPUT'Want to designate a grouping variable? (H for help) Y or <NO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=72% THEN OPEN 'BMD:HELP04.BMD' AS FILE#2%
	\ GOSUB 13220
	\ GOTO 11100

11105	  RETURN UNLESS ASCII(OPTION$)=89%

	\ PRINT
	\ PRINT 'Name of grouping vairable? <FIRST LISTED>'
	\ INPUT LINE GROUP$
	\ GROUP$=CVT$$(GROUP$,-1%)
	\ GROUP$='1' UNLESS ASCII(GROUP$)

	\ PRINT #1%,'		GROUPING = 'GROUP$'.' UNLESS ANALYSIS$='P7D'
							  OR ANALYSIS$='P2V'

	\ RETURN

	!		Programs P3D, P5D and P6D allow a grouping
	!		variable to be named.
	!
	! ***** GROUPING OF VARIABLES *****
	!

11120	  PRINT
	\ INPUT'Divide any variables into groups? (H for help) Y <NO>'OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=72% THEN OPEN 'BMD:HELP06.BMD' AS FILE #2%
	\ GOSUB 13220
	\ GOTO 11120

11122	  RETURN UNLESS ASCII(OPTION$)=89%

11130	  PRINT #1%,'/GROUP' UNLESS ANALYSIS$='P1F'
	\ PRINT #1%,'/CATEGORY' IF	  ANALYSIS$='P1F'

11131	  PRINT
	\ INPUT'Number of variable <  1  >';GROUP%
	\ GROUP%=1% UNLESS GROUP%

11132	  PRINT
	\ INPUT'Want cut points or codes? (H for help) CUT <CODES>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=72% THEN OPEN 'BMD:HELP07.BMD' AS FILE #2%
	\ GOSUB 13220
	\ GOTO 11132

11134	  PRINT
	\ PRINT 'Enter cut points: Form is 10,20,30' IF ASCII(OPTION$)
	\ PRINT
	\ PRINT 'Enter codes: Form is 1,2,3' UNLESS ASCII(OPTION$)
	\ INPUT LINE CUT.CODE$
	\ CUT.CODE$=CVT$$(CUT.CODE$,-1%)
	\ PRINT'Please enter codes or cutpoints; they are required.' UNLESS ASCII(CUT.CODE$)
	\ GOTO 11134 UNLESS ASCII(CUT.CODE$)
	\ PRINT #1%,'		CUTPOINTS('; IF ASCII(OPTION$)
	\ PRINT #1%,'		CODES('; UNLESS ASCII(OPTION$) IF ASCII(CUT.CODE$)
	\ PRINT #1%,		GROUP%') = 'CUT.CODE$'.' 

	\ PRINT
	\ PRINT 'Enter names for categories.' IF ASCII(OPTION$) 
	\ PRINT
	\ PRINT 'Enter names for codes.' UNLESS ASCII(OPTION$)
	\ GOSUB 12020
	\ PRINT #1%,'		NAMES('GROUP%') = '; IF LEN(NAM$(1%))
	\			GOSUB 12102 IF LEN(NAM$(1%))>2%

	\ PRINT
	\ INPUT'More grouping? Y or <NO>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ GOTO 11131 IF ASCII(OPTION$)=89%

11140	  RETURN

12000	!
	! *** NAME VARIABLES ***
	!

12020	  PRINT
	\ PRINT 'Use <RETURN> key alone when finished.'
	\ PRINT 'Type HELP for help.'
	\ PRINT

12035	  FOR J%=1% TO 100%

12040		PRINT '#'J%;
	\	INPUT LINE NAM$(J%)
	\	NAM$(J%)= LEFT(NAM$(J%),LEN(NAM$(J%))-2%)
	\	GOSUB 13190 IF NAM$(J%)='HELP'
	\	GOTO 12040 IF NAM$(J%)='HELP'
	\	GOTO 12080 UNLESS LEN(NAM$(J%))
	\	NAM$(J%)="'"+LEFT(NAM$(J%),8%)+"',"
	\ NEXT J%

12080	  J%=J%-1%

12090	  NAM$(J%)=LEFT(NAM$(J%),LEN(NAM$(J%))-1%)+'.'

12095	  RETURN

12099	!
	! ***** PRINT VARIABLE NAMES *****
	!

12100  PRINT #1%,'/VARIABLE	NAMES ='
	\ 	PRINT #1%TAB(20%);

12102	  	FOR J%=1% TO 100%

12104	  		PRINT #1% NAM$(J%);
	\		IF INSTR(1%,NAM$(J%),'.') THEN PRINT #1%
	\		RETURN

12108	 		IF J%/5%=J%/5. THEN PRINT #1%
	\		PRINT #1% TAB(20%);

12110		NEXT J%

12120	  RETURN

12999	!
	! ***** HELPS *****
	!

13000	! *** Number of cases to use ***

13010	  PRINT
	\ PRINT 'You can specify the number of cases in your data file to use in'
	\ PRINT 'the analysis.  The cases used will begin with the first case  and'
	\ PRINT 'end with the case number you enter.  The default response will'
	\ PRINT 'use all cases in the data file.'

	\ RETURN

13085	! *** Title ***

13090	  PRINT
	\ PRINT 'The title you enter will appear as a heading for your analysis.'
	\ PRINT 'Title may be up to 160 characters and may include all characters,'
	\ PRINT 'including commas.'

13100	  RETURN

13160	  PRINT
	\ PRINT 'Give the name of the file containing data to be analyzed.'
	\ PRINT 'Include the extension.  The data may be in an account other'
	\ PRINT 'than the account you are logged in, if the protection code'
	\ PRINT 'is <40>.  In that case, type the account number just before'
	\ PRINT 'the file name.  Example; [15,200]STUDY.DAT or DB1:[15,200]STUDY.DAT'

13165	  RETURN
	!
	! *** The FORMAT statement ***
	!
13170	  PRINT
	\ PRINT 'The FORTRAN format description is needed.  Do not supply'
	\ PRINT 'parentheses.  Correct is   F1.0,10F3.2,2F2.0'

13175	  RETURN
	!
	! *** Check limits before or after transformations ***
	!

13180	  PRINT
	\ PRINT 'Transformation may change the range or codes specified later'
	\ PRINT 'for transformed variables.  Type   A   if you want the new values'
	\ PRINT 'used.  <RETURN> gives original values for later coding or
	\ PRINT 'range cutpoints.'

13185	  RETURN
	!
	! *** Naming variables ***
	!

13190	  PRINT
	\ PRINT 'Names can be any characters; alpha or numeric.  The program'
	\ PRINT 'will shorten all names to a maximum length of 8 characters, and'
	\ PRINT 'place the name in quotes.'
	\ PRINT
	\ PRINT 'A space character is acceptable, and is the most convenient way'
	\ PRINT 'to skip naming a variable.  When finished, the <RETURN> key alone'
	\ PRINT 'will return you to the next inquiry in the program.'

13195	  RETURN
	!
	! *** Trial factors
	!

13200	  PRINT
	\ PRINT 'A trial factor appears when subjects are measured repeatedly.'
	\ PRINT 'The levels of the trial factor is the number of times subjects are'
	\ PRINT 'measured.'

13205	  RETURN

13210	!
	! *** Help messages from BMD help files ***
	!

13220	  PRINT FNCLEAR$
	\ FOR LOOP%=1% TO 20%
	\	INPUT LINE #2%, OPTION$
	\	OPTION$=CVT$$(OPTION$,4%)
	\	PRINT OPTION$
	\ NEXT LOOP%
	\ CLOSE #2%
	\ RETURN

13299	!
	! ***** Review CTL file, make any changes *****
	!
13300	  OPEN ANALYSIS$+'.CTL' FOR INPUT AS FILE #1%

13310	  PRINT FNCLEAR$
	\ PRINT
	\ PRINT "Here is your BMD control file  "ANALYSIS$+'.CTL'
	\ PRINT 
	\ J%,LOOP%=0%
	\ WHILE -1%
	\	J%=J%+1%
	\	INPUT LINE #1%, OPTION$
	\	OPTION$=CVT$$(OPTION$,4%)
	\	NAM$(J%)=OPTION$
	\ 	PRINT OPTION$
	\	LOOP%=LOOP%+1%
	\ NEXT

13315	  PRINT
	\ INPUT'Make Changes, create New file or done? Form: C or N <DONE>';OPTION$ 
	\ GOTO 13320 UNLESS ASCII(OPTION$)
	\ RETURN IF ASCII(OPTION$)=78%
	\ PRINT FNCLEAR$
	\ FOR J%=1% TO LOOP%
	\	PRINT J%;
	\	PRINT NAM$(J%)
	\ NEXT J%
	\ GOSUB 13340
	\ GOTO 13300

13320	  PRINT
	\ PRINT 'For your analysis, type RUN BMD:'ANALYSIS$
	\ GOTO 32710
	! All done, sign off.
	!
	! ***** Make Changes *****
	!

13340	  PRINT
	\ INPUT 'Replace, Delete or Insert a line? Form: R D I <REPLACE>';OPTION$
	\ OPTION$=CVT$$(OPTION$,-1%)
	\ IF ASCII(OPTION$)=73% THEN
	  PRINT
	\ INPUT 'Insert before what line number';OPTION%
	\ RETURN IF OPTION%<1% OR OPTION%>LOOP%+1%
	\ LOOP%=LOOP%+1%
	\ NAM$(J%)=NAM$(J%-1%) FOR J%=LOOP% TO OPTION% STEP -1%

13350	  PRINT
	\ INPUT 'Replace or Delete what line';OPTION% UNLESS ASCII(OPTION$)=73%
	\ RETURN IF OPTION%<1% OR OPTION%>LOOP%
	\ PRINT
	\ PRINT 'Type new line ';
	\ PRINT '<DELETE LINE>' UNLESS ASCII(OPTION$)=73%
	\ PRINT
	\ INPUT LINE NAM$(OPTION%)
	\ NAM$(OPTION%)=CVT$$(NAM$(OPTION%),4%)
	\ IF NAM$(OPTION%)='' THEN
	  NAM$(J%)=NAM$(J%+1%) FOR J%=OPTION% TO LOOP%
	\ LOOP%=LOOP%-1%

13360	  CLOSE #1%
	\ OPEN ANALYSIS$+'.CTL' FOR OUTPUT AS FILE#1%
	\ PRINT #1%, NAM$(J%) FOR J%=1% TO LOOP%
	\ CLOSE #1%
	\ RETURN

15000	!
	****************************************************************
	*                                                              *
	*                       F U N C T I O N S                      *
	*                                                              *
	****************************************************************


	!
15010	  DEF FNCLEAR$
	\ PRINT CHR$(155%)+'H';
	\ PRINT CHR$(155%)+'J';
	\ FNEND

19000	!
	****************************************************************
	*                                                              *
	*                     E R R O R    T R A P S                   *
	*                                                              *
	****************************************************************


	!
19010	  IF ERR=11% THEN RESUME 13315

19020	  IF ERR=50% THEN PRINT 'Please enter a whole number (integer).
	\ RESUME

19030	  IF ERR=5% THEN RESUME 1047

19990	  ON ERROR GOTO 0
	!

32700	!
	****************************************************************
	*                                                              *
	*                    E O J    R O U T I N E S                  *
	*                                                              *
	****************************************************************


	!
32710	  CLOSE #1%

32760	  NO EXTEND
	!


32767	  END
