10	!---------------------------------------------------------------------!
	!								      !
	!	PRIMAN  V03.01						      !
	!	PRIVATE DISK ACCOUNT MANAGEMENT PROGRAM			      !
	!	BY RUSS SCHWARTZ					      !
	!	NATIONWIDE MUTUAL INSURANCE COMPANY			      !
	!	FEBRUARY, 1980						      !
	!								      !
	!---------------------------------------------------------------------!

13	!*********************************************************************!
	!								      !
	!			D I S C L A I M E R			      !
	!								      !
	!*********************************************************************!
	!								      !
	!	THIS SOFTWARE IS PROPERTY OF NATIONWIDE MUTUAL INSURANCE      !
	!	COMPANY.  NO WARRANTY, EXPRESS OR IMPLIED, IS MADE CON-       !
	!	CERNING THE ACCURACY OR RELIABILITY OF THIS SOFTWARE.	      !
	!	THUS THE OWNER ASSUMES NO RESPONSIBILITY FOR THE SUPPORT      !
	!	OR MAINTENANCE OF THIS SOFTWARE ON ANY SYSTEM.		      !
	!								      !
	!*********************************************************************!

15	!---------------------------------------------------------------------!
	!								      !
	!	"PRIMAN" IS THE PRIVATE DISK MANAGEMENT PROGRAM.  IT          !
	!	ASSEMBLES ALL THE PARAMETERS NECESSARY FOR MAKING ACCOUNT     !
	!	CREATION & DELETION REQUESTS FOR PRIVATE DISK PACKS.  THE     !
	!	USER NEED ONLY SUPPLY THE ACCOUNT NUMBERS.  THE REQUEST IS    !
	!	THEN PASSED TO "ACMAN.BAC", THE ACCOUNT MANAGER IN THE       !
	!	SAME FORMAT AS WOULD HAVE BEEN GENERATED BY "MANAGE.BAC".     !
	!								      !
	!---------------------------------------------------------------------!

20	!	EDIT	DATE		MODIFICATION
	!	----	----		------------
	!	01	05-FEB-80	UPGRADE TO VERSION 3.
30	!	VARIABLE NAME	DESCRIPTION
	!	-------------	-----------

60	EXTEND
	! PROGRAM WRITTEN IN EXTEND MODE.

70	VERSION$ = "V03.01"
	\ LIBR$ = ""
	\ LIBPAS$ = ""
	\ DISK$ = ""
	\ BUF.LEN% = 84%
	! INITIALIZE CONSTANTS.
1000	ON ERROR GO TO 9000
	\ A$ = SYS(CHR$(6%) + CHR$(-7%))
	\ PRINT STRING$(6%, 10%) + "PRIMAN  " + VERSION$ + CHR$(9%)
	  + RIGHT(SYS(CHR$(6%) + CHR$(9%)), 3%) + CHR$(10%)
	\ PRINT "Private Disk Management Program" + CHR$(10%)
	! SET UP ERROR TRAP.
	! CTRL/C TRAP ENABLE.
	! PRINT HEADER & SYSTEM I.D.

1001	A$ = SYS(CHR$(3%))
	\ INPUT 'Enter PRIMAN password'; R$
	\ PRINT STRING$(2%, 10%)
	\ A$ = SYS(CHR$(2%))
	\ IF CVT$$(R$, -1%) <> LIBPAS$ THEN
	  A$ = SYS(CHR$(9%))
	! SEE IF THEY SHOULD BE IN HERE.
	! IF NOT, THEN GET OUT.

1010	OPEN "NL:MANAGE.WRK" AS FILE 12%, RECORDSIZE BUF.LEN%
	\ FIELD #12%,	BUF.LEN% AS PARM$
	\ FIELD #12%,	1% AS KB$,
			1% AS CMD$,
			2% AS PPN$,
			4% AS PASWRD$,
			2% AS QUOTA$,
			2% AS CLUSTR$,
			4% AS DEV$,
			4% AS RES$,
			64% AS DESC$
	\ LSET PARM$ = STRING$(BUF.LEN%, 0%)
	! SET UP PARAMETER BUFFER.

1020	PRINT 'Enter "C" to create an account on ' + DISK$
	\ PRINT 'Enter "D" to delete an account on ' + DISK$
	\ PRINT '(NOTE: You must zero the account with PIP before '
	  + ' deletion)'
	\ PRINT
	! GIVE THEM A LITTLE HELP.

1025	INPUT "Select an option"; OPTION$
	\ GO TO 1025 IF OPTION$ = ""
	\ OPTION% = ASCII(CVT$$(OPTION$, -1%))
	\ IF (OPTION% < 67% OR OPTION% > 68%) THEN
	  PRINT TAB(5%); OPTION$ + " -- Illegal option."
	\ GO TO 1025
	! SELECT AN OPTION.
	! MAKE SURE IT IS LEGAL.

1030	PRINT
	\ PRINT "Project numbers can be: 1 - 254"
	\ PRINT "Programmer numbers can be: 0 - 254"
	\ PRINT
	! GIVE THEN SOME MORE HELP.

1035	INPUT "ENTER PROJECT-PROGRAMMER NUMBER AS: PROJ,PROG"
	\ INPUT LINE PPN1$
	\ PPN1$ = CVT$$(PPN1$, -1%)
	\ GO TO 1035 IF PPN1$ = ""
	\ I% = INSTR(0%, PPN1$, ",")
	\ IF I% = 0% THEN
	  PRINT TAB(5%); PPN1$ + " -- Invalid project-programmer number"
	\ GO TO 1035
	! GET A PPN.
	! MAKE SURE THERE'S A COMMA IN IT.

1040	PROJ% = ABS(VAL(LEFT(PPN1$, I% - 1%)))
	\ PROG% = ABS(VAL(RIGHT(PPN1$, I% + 1%)))
	\ IF (PROJ% > 254% OR PROJ% < 1% OR PROG% > 254%) THEN
	  PRINT TAB(5%); PPN1$ + " -- Invalid project-programmer number"
	\ GO TO 1035
	! MAKE SURE PPN IS IN LEGAL RANGE.

1050	LSET PPN$ = CHR$(PROG%) + CHR$(PROJ%)
	\ LSET KB$ = CHR$(ASCII(MID(SYS(CHR$(6%) + CHR$(9%)), 2%, 1%)) / 2%)
	\ LSET DEV$ = MID(SYS(CHR$(6%) + CHR$(-10%) + DISK$), 23%, 4%)
	\ LSET PASWRD$ = CVT%$(SWAP%(23014%)) + CVT%$(SWAP%(2125%))
		IF OPTION% = 67%
	\ LSET CLUSTR$ = CVT%$(SWAP%(16%)) IF OPTION% = 67%
	\ IF OPTION% = 67% THEN
	  LSET CMD$ = CHR$(1%) ELSE
	  LSET CMD$ = CHR$(2%)
	! STORE THE PPN.
	! SAVE OUR KB: NUMBER FOR BROADCASTS.
	! IF "CREATE" THEN USE "NONAME" FOR PASSWORD,
	! 	BECAUSE THE SYSTEM DOESN'T CARE WHAT IT IS.
	! PUT THE REQUEST NUMBER IN THE BUFFER.

1080	A$ = CHR$(6%) + CHR$(22%) + CHR$(-1%) + CHR$(0%)
	  + 'ACMAN ' + CHR$(12%) + CHR$(0%)
	  + CHR$(BUF.LEN%) + CHR$(SWAP%(BUF.LEN%))
	  + STRING$(2%, 0%) + CHR$(0%) + STRING$(4%, 0%)
	  + STRING$(20%, 0%)
	\ A$ = SYS(A$)
	! SEND BY LOGNAME.
	! LOGNAME = ACMAN
	! CHANNEL = 12
	! LENGTH = BUF.LEN% = 84%
	! OFFSET = 0
	! SEND THE MESSAGE.

1090	GO TO 32766
	! GET OUT.
8990	!---------------------------------------------------------------------!
	!								      !
	!	E R R O R   H A N D L I N G				      !
	!								      !
	!---------------------------------------------------------------------!

9000	ERR1$ = RIGHT(SYS(CHR$(6%) + CHR$(9%) + CHR$(ERR)), 3%)
	! SET UP ERROR TEXT.

9010	IF ERR = 28% THEN
	  RESUME 32766
	! IF THEY CTRL/C'D THEN GET OUT FAST.

9020	IF ERR = 11% AND ERL = 8000 THEN
	  RESUME 32766
	! THEY CTRL/Z'D ON A RESPONSE, SO THEY WANT OUT.

9030	IF ERL = 1040% THEN
	  PRINT TAB(5%); PPN1$ + " -- " + ERR1$ + " -- Please re-enter..."
\ RESUME 1035
	! ILLEGAL NUMBER ERRORS.

9040	IF ERL = 1080% AND (ERR = 4% OR ERR = 32%) THEN
	  RESUME 1080
	! CAN'T SEND A MESSAGE RIGHT NOW, SO TRY AGAIN.

9050	IF ERL = 1080% AND ERR = 5% THEN
	  PRINT TAB(5%); '?ACMAN not running'
	\ RESUME 32766
	! CAN'T SEND A MESSAGE BECAUSE NOT A RECEIVER.

9100	IF ERL = 1001% THEN
	  A$ = SYS(CHR$(9%))
	! IF ANY ERRORS OCCURRED HERE, THEN THEY SHOULDN'T BE IN HERE.

9900	PRINT TAB(5%); ERR1$ + ' at line'; ERL
	\ PRINT TAB(5%); "?Program malfunction at line"; ERL
		\ PRINT
	\ RESUME 32766
	! UNEXPECTED ERRORS.

32766	CLOSE INDEX% FOR INDEX% = 1% TO 12%
	\ A$ = SYS(CHR$(9%))

32767	END
