10	!---------------------------------------------------------------------!
	!								      !
	!	CHGALL  V03.01						      !
	!	MULTIPLE PASSWORD CHANGING PROGRAM			      !
	!	BY RUSS SCHWARTZ					      !
	!	NATIONWIDE MUTUAL INSURANCE COMPANY			      !
	!	FEBRUARY, 1980						      !
	!								      !
	!---------------------------------------------------------------------!

15	!---------------------------------------------------------------------!
	!								      !
	!	THIS PROGRAM CHANGES THE PASSWORDS OF ALL ACCOUNTS WITH A     !
20	!	EDIT	DATE		MODIFICATION
	!	----	----		------------
	!	01	06-FEB-80	UPGRADE TO VERSION 3.
30	!	VARIABLE NAME	DESCRIPTION
	!	-------------	-----------
	!	A$		SYS() CALL PARAMETER STRING.
	!	ACCT.MAX%	MAX. NO. OF ACCOUNTS WHICH WORKFILES CAN HOLD.
	!	CMD$		REQUEST COMMAND; ASCII(CMD$) = REQUEST NUMBER.
	!	DEV$		DEVICE PARAMETER IN SYS() FORMAT.
	!	ERR1$		ERROR TEXT AS GENERATED BY FIP #9.
	!	INDEX%		GENERAL-USE INDEX.
	!	JOB%		CURRENT JOB NUMBER.
	!	JUNK$		UTILITY VARIABLE.
	!	KB$		KEYBOARD PARAM. FOR BROADCASTING TO REQUESTOR.
	!				ASCII(KB$) = UNIT NUMBER.
	!	LIBPAS$		SYSTEM LIBRARY PASSWORD.
	!	MSG$		DUMMY ARGUMENT FOR BROADCAST-MESSAGE FUNCTION.
	!	PARM$		FIELD VARIABLE FOR ZEROING REQUEST BUFFER.
	!	PASS$		DESIRED NEW PASSWORD.
	!	PASS1$		DESIRED NEW PASSWORD CONVERTED TO RADIX-50.
	!	PASWRD$		PASSWORD PARAMETER IN RADIX-50.
	!	PASWRD$()	LIST OF NEW PASSWORDS/NO-CHANGE-FLAGS.
	!	POINT%		GENERAL-USE POINTER.
	!	PPN$		ACCOUNT NUMBER PARAMETER.
	!	PPN%()		TABLE OF ACCOUNT NUMBERS ON SYSTEM.
	!	RES$		RESERVED PARAMETER STRING.
	!	VERSION$	CURRENT VERSION NUMBER.
60	EXTEND
	\ DIM 		PPN%(400%, 1%)
	! PROGRAM WRITTEN IN EXTEND MODE.
	! DIMENSION STATEMENTS.

70	VERSION$ = "V03.01"
	\ ACCT.MAX% = 400%
		! VARIES ACCORDING TO INSTALLATION.
900	!---------------------------------------------------------------------!
	!								      !
	!	E X E C U T I V E    S E C T I O N			      !
	!								      !
	!---------------------------------------------------------------------!

1000	ON ERROR GO TO 9000
	\ A$ = SYS(CHR$(6%) + CHR$(-7%))
	\ PRINT STRING$(6%, 10%) + "CHGALL  " + VERSION$ + CHR$(9%)
	  + RIGHT(SYS(CHR$(6%) + CHR$(9%)), 3%) + CHR$(10%)
	\ PRINT "Project Password Changing Program" + CHR$(10%)
	! SET UP ERROR TRAP.
	! CTRL/C TRAP ENABLE.
	! PRINT HEADER & SYSTEM ID.

1010	LIBPAS$ = SYS(CHR$(6%) + CHR$(14%) + STRING$(4%, 0%) + CHR$(2%) + CHR$(1%)
		+ STRING$(22%, 0%))
	\ A$ = SYS(CHR$(3%))
	\ INPUT "ENTER SYSTEM LIBRARY PASSWORD"; PASS$
	\ PRINT STRING$(2%, 10%)
	\ A$ = SYS(CHR$(2%))
	\ IF CVT$$(PASS$, -1%) <> CVT$$(RAD$(SWAP%(CVT$%(MID(LIBPAS$, 9%, 2%))))
	 + RAD$(SWAP%(CVT$%(MID(LIBPAS$, 11%, 2%)))), -1%) THEN
	  A$ = SYS(CHR$(9%))
	\ STOP WHILE 1% = 1%
	! SEE IF THEY SHOULD BE IN HERE.
	! IF NOT, THEN GET OUT FAST.

1110	PRINT "Reading $ACCT.SYS -- Please wait..." + CHR$(10%)
	\ PPN%(INDEX%, POINT%) = 0% FOR POINT% = 1% TO 0% STEP -1%
				FOR INDEX% = ACCT.MAX% TO 0% STEP -1%
	! LET THEM KNOW THIS IS GOING TO TAKE A MINUTE.
	! ZERO ARRAYS.

1130	OPEN "$ACCT.SYS/RONLY" FOR INPUT AS FILE 1%
	\ PPN%(0%, 0%), POINT% = 1%
	! ACCESS $ACCT.SYS TO GET PPN'S AND OLD PASSWORDS.
	! INITIALIZE POINTERS.

1140	INPUT #1%, PPN%(POINT%, 0%), PPN%(POINT%, 1%),
		JUNK$, JUNK$, JUNK$, JUNK$
	\ PPN%(0%, 0%), POINT% = POINT% + 1%
	\ GO TO 1140
		! READ IN PPN FROM $ACCT.SYS
		! SKIP OTHER INFO IN FILE.

1145	INPUT "Enter project number"; PROJ%
	\ DETACH% = 0%
	\ IF PROJ% <= 0%
		THEN PRINT TAB(5%); "Project numbers can be: 1 - 254."
		\ GO TO 1145

1150	POINT% = 0%
	\ POINT% = POINT% + 1%
		UNTIL PPN%(POINT%, 0%) = PROJ% OR POINT% = PPN%(0%, 0%)
	\ IF POINT% = PPN%(0%, 0%) AND PROJ% <> PPN%(POINT%, 0%)
		THEN PRINT TAB(5%); PROJ%; "-- No such project number."
		\ GO TO 1145

1155	POINT1% = POINT%
	\ POINT1% = POINT1% + 1%
		UNTIL PPN%(POINT1%, 0%) <> PROJ% OR PPN%(0%, 0%) = POINT1%
	\ POINT1% = POINT1% - 1% IF PPN%(POINT1%, 0%) <> PROJ%

1158	INPUT "Enter new password"; PASS$
	\ NEW.PASS$ = MID(SYS(CHR$(6%) + CHR$(-10%) + PASS$), 7%, 4%)

1160	OPEN "NL:CHGALL.WRK" AS FILE 12%, RECORDSIZE 84%
	\ FIELD #12%, 84% AS PARM$
	\ FIELD #12%,	1% AS KB$,
			1% AS CMD$,
			2% AS PPN$,
			4% AS PASWRD$,
			4% AS RES$,
			4% AS DEV$
	\ LSET PARM$ = STRING$(84%, 0%)
	! SET UP REQUEST BUFFER.
	! ZERO IT.

1170	LSET KB$ = CHR$(ASCII(MID(SYS(CHR$(6%) + CHR$(9%)), 2%, 1%)) / 2%)
	\ LSET CMD$ = CHR$(4%)
	\ LSET DEV$ = MID(SYS(CHR$(6%) + CHR$(-10%) + "SY:"), 23%, 4%)
	! SAVE KB: NUMBER SO ACMAN CAN BROADCAST MESSAGES.
	! FORCE COMMAND TO BE 4 (CHANGE PASSWORD).
	! DO THE PUBLIC STRUCTURE.

1175	INPUT "Detach (Y/N) <N>"; R$
	\ DETACH% = (ASCII(R$) = 89%)
	\ PRINT
	\ PRINT "Detaching..." + STRING$(6%, 10%) IF DETACH%
	\ A$ = SYS(CHR$(6%) + CHR$(7%)) IF DETACH%
		! SEE IF THEY WANT TO DETACH.
		! LET THEM KNOW WE'RE GOING TO DO IT.

1180	FOR INDEX% = POINT% TO POINT1%
	\ LSET PPN$ = CHR$(PPN%(INDEX%, 1%)) + CHR$(PPN%(INDEX%, 0%))
	\ LSET PASWRD$ = NEW.PASS$
	! DON'T CHANGE THIS PASSWORD IF SO FLAGGED.
	! PREPARE TO CHANGE THE PASSWORD.

1190	A$ = CHR$(6%) + CHR$(22%) + CHR$(-1%) + CHR$(0%)
	  + "ACMAN " + CHR$(12%) + CHR$(0%)
	  + CHR$(84%) + CHR$(SWAP%(84%)) + STRING$(27%, 0%)
	\ A$ = SYS(A$)
	! SEND THE REQUEST TO "ACMAN".

1195	NEXT INDEX%
	\ A$ = FNSEND$("Changed passwords SY:[" + NUM1$(PROJ%) + ",*]")
		IF DETACH%
	\ PRINT "Changed passwords SY:[" + NUM1$(PROJ%) + ",*]"
		UNLESS DETACH%

1200	CLOSE INDEX% FOR INDEX% = 1% TO 12%
	\ KILL "CHGALL.WRK"
	! LET THEM KNOW WE'RE FINISHED.
	! CLOSE ALL FILES.
	! DELETE THE WORK FILE.

1210	JOB% = ASCII(SYS(CHR$(6%) + CHR$(9%))) / 2%
	\ A$ = SYS(CHR$(6%) + CHR$(8%) + CHR$(JOB%) + STRING$(24%, 0%)
	  + CHR$(255%) + STRING$(2%, 0%)) IF DETACH%
	\ GO TO 32767 UNLESS DETACH%
	\ STOP WHILE 1% = 1%
	! KILL THIS JOB NOW THAT WE'RE FINISHED.

6990	!---------------------------------------------------------------------!
	!								      !
	!	F U N C T I O N S					      !
	!								      !
	!---------------------------------------------------------------------!

7000	DEF FNSEND$(MSG$) = SYS(CHR$(6%) + CHR$(-5%) + KB$ + CHR$(10%)
	  + CHR$(13%) + "CHGALL: " + MSG$ + CHR$(10%) + CHR$(13%))
	! FUNCTION TO BROADCAST A MESSAGE BACK TO THE REQUESTOR.
8990	!---------------------------------------------------------------------!
	!								      !
	!	E R R O R   H A N D L I N G				      !
	!								      !
	!---------------------------------------------------------------------!

9000	ERR1$ = RIGHT(SYS(CHR$(6%) + CHR$(9%) + CHR$(ERR)), 3%)
	! SET UP ERROR TEXT.

9010	IF ERR = 11% AND ERL = 1140% THEN
	  CLOSE 1%
	\ RESUME 1145
	! END OF $ACCT.SYS REACHED.

9015	IF (ERR = 11% OR ERR = 28%)
		THEN PRINT TAB(5%); "?Program interruped" UNLESS DETACH%
		\ Z% = FNSEND%("?Program interruped") IF DETACH%
		\ RESUME 1200

9020	IF ERL = 1158% AND ERR = 2% THEN
	  PRINT TAB(5%); PASS$ + " -- Invalid password"
	\ RESUME 1158
	! INVALID PASSWORD, SO TRY TO GET A GOOD ONE.

9030	IF ERL = 1190% AND (ERR = 4% OR ERR = 32%) THEN
	  SLEEP(15%)
	\ RESUME 1190
	! CAN'T SEND RIGHT NOW.
	! SO TRY AGAIN IN A FEW SECONDS.

9040	IF ERL = 1190% AND ERR = 5%
		THEN A$ = FNSEND$("?ACMAN not running -- Terminating")
			IF DETACH%
		\ PRINT "?ACMAN not running" UNLESS DETACH%
		\ RESUME 1200
			! GIVE UP IF "ACMAN" NOT RUNNING.

9990	PRINT TAB(5%); ERR1$ + " at line"; ERL UNLESS DETACH%
	\ PRINT TAB(5%); "?Program malfunction at line"; ERL UNLESS DETACH%
	\ A$ = FNSEND$(ERR1$ + " at line" + NUM$(ERL)
	  + " -- ?Program malfunction") IF DETACH%
	\ CLOSE INDEX% FOR INDEX% = 1% TO 12%
	\ RESUME 32767
	! UNEXPECTED ERRORS.
	! IF WE'RE STILL ATTACHED THEN PRINT THEM.
	! IF WE'RE NOW DETACHED THEN BROADCAST THEM.
	! CLOSE ALL FILES AND HALT.

32767	END
