10	!
			V I D E O 2

	Permits user to set parameters within which the program
	designs patterns.  A random element is always
	involved, so no two patterns are the same.
	FOR USE ON PRINTING TERMINALS. (No cursor-control functions.)

20	!
		MODIFICATION HISTORY

	VIDEO2 was written by Dr. John S. Abma, Wittenberg University,
		Springfield, Ohio, in the Spring of 1978.
	It is related to his VIDEO1 program, which runs on video terminals ONLY.  

	It was written in  VO6C version of RSTS-E, to run on DEC PDP 11/70

21	!
	Neither Wittenberg University nor the author accepts any responsibility
	for the damage that may result, spiritually or mentally, from the use
	of this program.

22	!  This is Version VO6C-1  Any new versions will increment the -1 by 1

100	! 	PROGRAM DESCRIPTION

110	!	This program may be run on PRINTING TERMINALS. No cursor
		control functions are called.

	Four types of symmetry are produced;
	N = No symmetry.
	T = Top-bottom symmetry, where the top half is "Folded" onto the bottom.
	R = Right-left, where the left side is "Folded" onto the right.
	F = Four-fold symmetry, where the upper-left quadrant is repeated, or
		reflected in the other three quadrants.

120	!
	The user has control of these symmetries, and also has these options;
	1.  User determines how many lines will be started in pattern.
	2.  User determines whether the lines will cross or not.
	3.  User determines what printing characters will make up the pattern.
	4.  Thickness of printed lines is SET TO 1, because of better appear-
	    ance.  Also, the string matrix gets too large with long strings.

	Purpose of the program is to permit experiments in abstract designs.

400 !		VARIABLES USED

	A$	Character set used for printing design.
	A$()	Matrix to hold design.  Is printed as last command of program.
	A%()	Matrix stores 1 if character or space is printed.
		PURPOSE; Prevents line-crossing or overprinting.
	B%	Dummy for number of lines printed.
	B1%	Dummy for line length.
420 !	D%	A value, 1 thru 8, selecting direction for line to grow.
	D%()	Direction of line growth.
	F1$	The printed character in a line.
	I%	Vertical coordinate.
	J%	Horizontal coordinate.
	J1%	In A%() matrix, prints 1 to prevent horizontal lines being
		crossed. (Horizontal characters are printed in alternate print
		positions only).
	L0%	Number of lines in pattern.
	L2%	Line length.
430 !	O$	User input, Y or N for lines to cross.
		Also, to request instructions.
	O1$	User input to signal rady for design to be printed.
	O9$	User option for type of symmertry (N R T or F).
	T%	SET TO 1.  Left in program to provide for future revisions
		which may allow various line thicknesses.

800  !		FUNCTIONS AND SUBROUTINES

	There is only one SUBROUTINE, for INSTRUCTIONS at line 10000

	There are no user-defined functions.

900	  DIM A%(24%,80%) \ DIM D%(8%,2%) \ DIM A$(24%,80%)
1000	  ON ERROR GOTO 19000

1010	  PRINT\PRINT'	Welcome to V I D E O 2'
	\ PRINT'This program is best run on a printing terminal, using clear side'
	\ PRINT'of paper.'

1020	  MAT READ D%
	\ DATA -1,-1,  -1,0,  -1,1,  0,-1,  0,1,  1,-1,  1,0,  1,1

1030	  A$(I%,J%)=' 'FOR I%=0% TO 24% FOR J%=0% TO 80%

1040	  RANDOM

1050	  INPUT'Want Instructions (Type Y or N)';O$
	\ GOTO 1050 IF O$<>'Y' AND O$<>'N'

1060	  GOSUB 10000 IF O$='Y'

1080	!
	! ***** USER DESIGNS DISPLAY *****
	!
1090	PRINT\PRINT'WHAT KIND OF SYMMETRY?'
1100	  PRINT'N = No Symmetry'
	\ PRINT'R = Right-Left Symmetry'
	\ PRINT'T = Top-Bottom Symmetry'
	\ PRINT'F = Four-Fold Symmetry'

1110	PRINT\INPUT'Type one: N,R,T,F';O9$ \ GOTO 1110 IF O9$<>'N'
				AND O9$<>'R' AND O9$<>'T' AND O9$<>'F'

1120	  PRINT\INPUT'HOW MANY LINES';L0%
	\ IF 1%>L0% OR L0%>100% THEN PRINT'Type a number between 1 and 100'
	\ GOTO 1120

1130	  PRINT\INPUT'WHAT LENGTH OF LINE';L2%
	\ IF 1%>L2% OR L2%>80% THEN PRINT'Type a number between 1 and 80'
	\ GOTO 1130

1140	PRINT\INPUT'WANT LINES TO CROSS EACH OTHER (Type Y or N)';O$
	\ GOTO 1140 IF O$<>'N'AND O$<>'Y'

1150	  PRINT\INPUT'TYPE 10 CHARACTERS, (May be same or different)';A$
	\ IF LEN(A$)<10%THEN PRINT'Please enter at least 10 characters (No commas).'
	\ GOTO 1150

1155 !	  PRINT\INPUT'MAXIMUM THICKNESS OF LINES (Enter from 1 to 10)';T%
	\ GOTO 1155 IF 1%>T% OR T%>10%
	! Not a variable in this program.  Left in for future versions.

1157	  T%=1%
	! T% is the string length.  It is SET TO 1 for the printing terminals
	  for better appearance.  May be a variable in later versions.

1160	  PRINT\PRINT' Advance paper so printing head is just below perforation.'
	\ INPUT'TYPE   Y   WHEN READY';O1$
	\ GOTO 1160 IF O1$<>'Y'

1190	!
	! ***** NUMBER OF LINES *****
	!
1200	  FOR B%=1% TO L0%
		\ F1$=MID(A$,RND*10%+1%,T%)
		\ IF O9$='N' THEN I%=RND*23%+1% \ J%=(80%-LEN(F1$))*RND+1%
		! F1$ is character printed for entire line, selected from A$.
		  For N (No symmetry), lines start anywhere in 24x80 field.
		  The -LEN(F1$) factor allows for entire string to be printed.

1210		  IF O9$='R' THEN I%=RND*23%+1% \ J%=(40%-LEN(F1$))*RND+1%
		! For Right-left symmetry, lines start in left half of screen.

1220		  IF O9$='T' THEN I%=RND*12%+1% \ J%=(80%-LEN(F1$))*RND+1%
		! For Top-bottom symmetry, lines start in top half of screen.

1230		  IF O9$='F' THEN I%=RND*12%+1% \ J%=(40%-LEN(F1$))*RND+1%
		! For Four-fold symmetry, lines start in upper-left quadrant.

1240		  D%=RND*8%+1%
		! Selects one of 8 directions for the line to grow in.

1250	!
	! ***** LENGTH OF LINE *****
	!
1260	  FOR B1%=1% TO L2%
		\ A%(I%,J%+J1%)=1% FOR J1%=0% TO LEN(F1$) IF O$='N'
		! When lines are not to cross, matrix A% must show a "1"
		  where characters are printed.

1265		  GOTO 1270 IF D%(D%,1%)
		! If line grows vertically, then skip next statement.

1268		  J%=J%+(LEN(F1$)+1%)*D%(D%,2%) \ GOTO 1280
		! Horizontal characters have a space between them for better
		  appearance.

1270		  J%=J%+D%(D%,2%)
		\ I%=I%+D%(D%,1%)
		  ! Both horiz. and vert. coordinates incremented.

1280		  IF O9$='N' THEN GOTO 1380 IF I%<=0% OR I%>=24%
					    OR J%<=0% OR J%>=80%
		  ! Abort lines if they go out of range.

1290		  IF O9$='R' THEN GOTO 1380 IF I%<=0% OR I%>=24%
					    OR J%<=0% OR J%>=40%
		  ! Abort lines if they go beyond left half of field.

1300		  IF O9$='T' THEN GOTO 1380 IF I%<=0% OR I%>=13%
					    OR J%<=0% OR J%>=80%
		  ! Abort lines if they go beyond top half of field.

1310		  IF O9$='F' THEN GOTO 1380 IF I%<=0% OR I%>=13%
					    OR J%<=0% OR J%>=40%
		  ! Abort lines if they go beyond upper-left quadrant.

1320		GOTO 1380 IF A%(I%,J%) AND O$='N'
		  ! Abort lines if they meet an existing line, and lines are
		  not supposed to cross or over-print.

1330		  A$(I%,J%)=F1$
		! Prints character once.

1340		IF O9$='R' OR O9$='F' THEN A$(I%,80%-LEN(F1$)-J%)=F1$
		! Prints character again if symmetry is Rgt-lft or Fourfold.

1350		IF O9$='T' OR O9$='F' THEN A$(24%-I%,J%)=F1$
		! Prints character again if symmetry is Top-bottom or Fourfold.

1360		IF O9$='F' THEN A$(24%-I%,80%-LEN(F1$)-J%)=F1$
		! Prints character fourth time if symmetry is Four-fold.
		  In this and above lines, the LEN(F1$) factor allows room
		  for the whole string to appear.

1370	  NEXT B1%
	! Extend this line with same character.

1380	NEXT B%
	! Go start another line with a new character selection.

1400	  PRINT\MATPRINTA$;
	! Print the string matrix that stores the pattern.

1430	  PRINT\PRINT'SUMMARY; This is for' \PRINT
	\ PRINT'No symmetry' IF O9$='N'
	\ PRINT'Right-Left symmetry' IF O9$='R'
	\ PRINT'Top-Bottom symmetry' IF O9$='T'
	\ PRINT'Four-Fold symmetry'  IF O9$='F'
	\ PRINT'Number of lines = 'L0%
	\ PRINT'Length = 'L2%
	\ PRINT'Lines DO'; \ PRINT' NOT'; IF O$='N' \ PRINT' cross'
	\ PRINT'Character set was 'A$
	! \ PRINT'Maximum line thickness was'T%
	  Line is always 1 character thick, so is not reported here.

1435 GOTO 32767

9990	!
	! ***** SUBROUTINE; INSTRUCTIONS *****
	!
10000	  PRINT\PRINT'		INSTRUCTIONS'
10005	  PRINT\PRINT'1.	There are four kinds of symmetry.  No symmetry,'
	\ PRINT'	Right-left, Top-bottom and Four-fold.'

10007	  PRINT\PRINT'2.	The number of line-starts can be from 1 to 100.'
	\ PRINT\PRINT'3.	Length of line can be from 1 to 80.'
	\ PRINT\PRINT'4.	If the lines cross each other, there will be more total'
	\ PRINT'	characters on the screen.  Also, symbols can then be "Erased" by'
	\ PRINT'	printing of spaces.'
	\ PRINT\PRINT'5.	10 characters must be specified, but may all be the same'
	\ PRINT'	or different.  May include spaces but NO COMMAS.'
	! \ PRINT\PRINT'6.	Maximum line thickness may be from 1 to 10 characters.'
10010	  PRINT\PRINT'6.	Just answer the questions as they appear.  GOOD LUCK!!'

10100	RETURN
18990	!
	! ***** ERROR HANDLING *****
	!
19000	  IF ERR=50% THEN PRINT\PRINT'Enter a whole number only' \ RESUME
19010	  IF ERR=52% THEN PRINT\PRINT'Enter a smaller number' \ RESUME
19100	  ON ERROR GOTO 0
32599	!
	! ***** SIGN-OFF MESSAGE *****
	!
32600	! None, but user can supply one here.
32767	  END
