10	!
			V I D E O 1

	Permits user to set parameters within which the program
	designs patterns.  A random element is always
	involved, so no two patterns are the same.
	FOR USE ON VIDEO TERMINALS ONLY because of cursor-control functions.

20	!
		MODIFICATION HISTORY

	VIDEO1 was written by Dr. John S. Abma, Wittenberg University,
		Springfield, Ohio, in the Spring of 1978.  

	He has also written a program VIDEO2 which
	prints out similar patterns.  However, VIDEO2 is limited to line
	thinckness of 1 character only.

	VIDEO1 was written in  VO6C version of RSTS-E, to run on DEC PDP 11/70

21	!
	Neither Wittenberg University nor the author accepts any responsibility
	for the use or misuse, artistic or banal, that may result from the
	execution of this program.

22	!  This is Version VO6C-1  Any new versions will increment the -1 by 1

100	! 	PROGRAM DESCRIPTION

110	!	This program must be run on VIDEO TERMINALS only.  Cursor
		control functions are called.

	Four types of symmetry are produced;
	N = No symmetry.
	T = Top-bottom symmetry, where the top half is "Folded" onto the bottom.
	R = Right-left, where the left side is "Folded" onto the right.
	F = Four-fold symmetry, where the upper-left quadrant is repeated, or
		reflected in the other three quadrants.

120	!
	The user has control of these symmetries, and also has these options;
	1.  User determines how many lines will be started in pattern.
	2.  User determines whether the lines will cross or not.
	3.  User determines what printing characters will make up the pattern.
	4.  User determines thickness (number of characters across) of lines.

	Purpose of the program is to permit experiments in abstract designs.

400 !		VARIABLES USED

	A$	Character set used for printing design.
	A%()	Matrix stores 1 if character or space is printed.
		PURPOSE; Prevents line-crossing or overprinting.
	A1$	User input choosing S D I or X
410 !	A3$	'SDIX'
	B%	Dummy for number of lines printed.
	B1%	Dummy for line length.
	B2%	Dummy for number of patterns printed.
	B3%	Dummy for ON GOTO after user selects A1$ = S D I or X
420 !	D%	A value, 1 thru 8, selecting direction on vertical axis.
	D%()	Direction of movement, both vertical and horizontal axis.
	F1$	The printed character.
	FNC	Clear entire screen
	FNQ1%  Position cursor.
	I%	Vertical coordinate.
	J%	Horizontal coordinate.
	J1%	In A%() matrix, prints 1 to prevent horizontal lines being
		crossed. (Horizontal characters are printed in alternate print
		positions only).
	L0%	Number of lines in pattern.
	L2%	Line length.
	L4%	Number of patterns printed before next user option.
430 !	O$	User input, Y or N for lines to cross.
	O9$	User option for type of symmertry (N R T or F).
	T%	User inputs desired thickness of lines (Number of characters).
	Z%	Enables user-defined functions.

800  !	There are two user-defined functions:
	1.  FNC returns cursor to HOME and CLEARS ENTIRE SCREEN.
	2.  FNQ1% Provides for cursor positioning at any I%,J% coordinate.

	There is only one SUBROUTINE for INSTRUCTIONS, at line 10000.

900	  DIM A%(24%,80%) \ DIM D%(8%,2%)

1000	  ON ERROR GOTO 19000

1010	  RANDOM

1020	  MAT READ D%
	\ DATA -1,-1,  -1,0,  -1,1,  0,-1,  0,1,  1,-1,  1,0,  1,1

1030	!
	! ***** INTRODUCTION *****
	!
1035	  Z%=FNC
1040	  PRINT\PRINT'	Welcome to VIDEO1.  First, you will see a SAMPLE PATTERN.  It'
	\ PRINT'will remain for about 20 seconds. Then you can ask for another'
	\ PRINT'sample, or design your own displays.'
1045	  PRINT'All displays (including this message) will remain on the screen'
	\ PRINT'for about 10 seconds to permit viewing.  To hurry up, use the'
1046	  PRINT'RETURN key.'
1050	  SLEEP 10%
1060	!
	! ***** SAMPLE DESIGN *****
	!
1070	  A$='*.@OXox=#+'
	\ O$=MID('YN',RND*2%+1%,1%)
	\ L0%=15%*RND+5%
	\ O9$=MID('NRTF',RND*4%+1%,1%)
	\ L2%=RND*25%+5%
	\ L4%=0%
	\ T%=RND*3%+1%
	\ GOTO 1180
1080	!
	! ***** USER DESIGNS OWN DISPLAYS *****
	!
1090	PRINT\PRINT'WHAT KIND OF SYMMETRY?'
1100	  PRINT'N = No Symmetry'
	\ PRINT'R = Right-Left Symmetry'
	\ PRINT'T = Top-Bottom Symmetry'
	\ PRINT'F = Four-Fold Symmetry'

1110	PRINT\INPUT'Type one: N,R,T,F';O9$ \ GOTO 1110 IF O9$<>'N'
				AND O9$<>'R' AND O9$<>'T' AND O9$<>'F'

1120	  PRINT\INPUT'HOW MANY LINES';L0%
	\ IF 1%>L0% OR L0%>100% THEN PRINT'Type a number between 1 and 100'
	\ GOTO 1120

1130	  PRINT\INPUT'WHAT LENGTH OF LINE';L2%
	\ IF 1%>L2% OR L2%>80% THEN PRINT'Type a number between 1 and 80'
	\ GOTO 1130

1140	PRINT\INPUT'WANT LINES TO CROSS EACH OTHER (Type Y or N)';O$
	\ GOTO 1140 IF O$<>'N'AND O$<>'Y'

1150	  PRINT\INPUT'TYPE 10 CHARACTERS, (May be same or different)';A$
	\ IF LEN(A$)<10%THEN PRINT'Please enter at least 10 characters (No commas).'
	\ GOTO 1150

1155	  PRINT\INPUT'MAXIMUM THICKNESS OF LINE (Enter 1 to 10)';T%
	\ GOTO 1155 IF 1%>T% OR T%>10%

1160	  L4%=2%
	! Provides for three examples of user-designed display.

1170	!
	! ***** NUMBER OF DESIGNS *****
	!
1180	  FOR B2%=0% TO L4%
		\ Z%=FNC
		\ A%(I%,J%)=0% FOR I%=0% TO 24% FOR J%=0% TO 80%
1190	!
	! ***** NUMBER OF LINES *****
	!
1200	  FOR B%=1% TO L0%
		\ F1$=MID(A$,RND*10%+1%,T%)
		\ IF O9$='N' THEN I%=RND*23%+1% \ J%=(80%-LEN(F1$))*RND+1%
		! F1$ is character printed for entire line, selected from A$.
		  For N (No symmetry), lines start anywhere on screen.
		  The -LEN(F1$) factor assures room for whole string to appear.

1210		  IF O9$='R' THEN I%=RND*23%+1% \ J%=(40%-LEN(F1$))*RND+1%
		! For Right-left symmetry, lines start in left half of screen.

1220		  IF O9$='T' THEN I%=RND*12%+1% \ J%=(80%-LEN(F1$))*RND+1%
		! For Top-bottom symmetry, lines start in top half of screen.

1230		  IF O9$='F' THEN I%=RND*12%+1% \ J%=(40%-LEN(F1$))*RND+1%
		! For Four-fold symmetry, lines start in upper-left quadrant.

1240		  D%=RND*8%+1%
		! Selects one of 8 directions for the line to grow in.

1250	!
	! ***** LENGTH OF LINE *****
	!
1260	  FOR B1%=1% TO L2%
		\ A%(I%,J%+J1%)=1% FOR J1%=0% TO LEN(F1$) IF O$='N'
		! When lines are not to cross, matrix A% must show a "1"
		  where characters are printed.

1265		  GOTO 1270 IF D%(D%,1%)
		! If line grows vertically, then skip next statement.

1268		  J%=J%+(LEN(F1$)+1%)*D%(D%,2%) \ GOTO 1280
		  ! Horizontal characters have a space between them.

1270		  J%=J%+D%(D%,2%)
		\ I%=I%+D%(D%,1%)
		  ! Both horiz. and vert. coordinates incremented.

1280		  IF O9$='N' THEN GOTO 1380 IF I%<=0% OR I%>=24%
					    OR J%<=0% OR J%>=80%
		  ! Abort lines if they go off screen.

1290		  IF O9$='R' THEN GOTO 1380 IF I%<=0% OR I%>=24%
					    OR J%<=0% OR J%>=40%
		  ! Abort lines if they go beyond left half of screen.

1300		  IF O9$='T' THEN GOTO 1380 IF I%<=0% OR I%>=13%
					    OR J%<=0% OR J%>=80%
		  ! Abort lines if they go beyond top half of screen.

1310		  IF O9$='F' THEN GOTO 1380 IF I%<=0% OR I%>=13%
					    OR J%<=0% OR J%>=40%
		  ! Abort lines if they go beyond upper-left quadrant.

1320		GOTO 1380 IF A%(I%,J%) AND O$='N'
		  ! Abort lines if they meet an existing line, and lines are
		  not supposed to cross or over-print.

1330		Z%=FNQ1%(I%,J%) \ PRINTF1$;
		! Prints character once.

1340		IF O9$='R' OR O9$='F' THEN Z%=FNQ1%(I%,80%-LEN(F1$)-J%) \ PRINTF1$;
		! Prints character again if symmetry is Rgt-lft or Fourfold.

1350		IF O9$='T' OR O9$='F' THEN Z%=FNQ1%(24%-I%,J%) \ PRINTF1$;
		! Prints character again if symmetry is Top-bottom or Fourfold.

1360		IF O9$='F' THEN Z%=FNQ1%(24%-I%,80%-LEN(F1$)-J%) \ PRINTF1$;
		! Prints character fourth time if symmetry is Four-fold.
		  In above lines, the -LEN(F1$) gives room for whole string.

1370	NEXT B1%
	! Go for same character and extend this line.

1380	NEXT B%
	! Go start another line with a different character.

1390	SLEEP 15%
	! Allow time for viewing completed design.

1400	NEXT B2%
	! Go make another design, using same ideas.

1410	!
	! ***** SUMMARY OF DESIGN PARAMETERS *****
	!
1420	Z%=FNC
1430	  PRINT'SUMMARY; This is for' \PRINT
	\ PRINT'No symmetry' IF O9$='N'
	\ PRINT'Right-Left symmetry' IF O9$='R'
	\ PRINT'Top-Bottom symmetry' IF O9$='T'
	\ PRINT'Four-Fold symmetry'  IF O9$='F'
	\ PRINT'Number of lines = 'L0%
	\ PRINT'Length = 'L2%
	\ PRINT'Lines DO'; \ PRINT' NOT'; IF O$='N' \ PRINT' cross'
	\ PRINT'Character set was 'A$
	\ PRINT'Maximum line thickness was'T%
1440	!
	! ***** USER OPTIONS *****
	!
1450	  A3$='SDIX'
	\ PRINT\PRINT'YOUR OPTIONS; Do you want'
	\ PRINT'	S = Sample again'
	\ PRINT'	D = Design your own'
	\ PRINT'	I = Instructions'
	\ PRINT'	X = eXit, all done'

1460	  PRINT\PRINT'Type S D I or X'
1470	INPUT A1$ \ GOTO 1470 IF A1$<>'S' AND A1$<>'D' AND A1$<>'I' AND A1$<>'X'
	\ B3%=INSTR(1%,A3$,A1$)+1%
	\ ON B3% GOTO 1460, 1070, 1090, 1480, 32600
1480	GOSUB 10000 \ GOTO 1450
9990	!
	! ***** SUBROUTINE; INSTRUCTIONS *****
	!
10000	  Z%=FNC \ PRINT'		INSTRUCTIONS'
	\ PRINT\PRINT'	When you design your own display, you will be asked'
	\ PRINT'for 6 decisions, like those summarized for the sample.'
	\ PRINT'You will get 3 EXAMPLES of your design. Just wait for the next one.'

10005	  PRINT\PRINT'1.	There are four kinds of symmetry.  No symmetry,'
	\ PRINT'	Right-left, Top-bottom and Four-fold.'

10007	  PRINT\PRINT'2.	The number of line-starts can be from 1 to 100.'
	\ PRINT\PRINT'3.	Length of line can be from 1 to 80.'
	\ PRINT\PRINT'4.	If the lines cross each other, there will be more total'
	\ PRINT'	characters on the screen.  Also, symbols can then be "Erased" by'
	\ PRINT'	printing of spaces.'
	\ PRINT\PRINT'5.	10 characters must be specified, but may all be the same'
	\ PRINT'	or different.  May include spaces BUT NO COMMAS.'
	\ PRINT\PRINT'6.	Maximum line thickness may be from 1 to 10 characters.
10020	  PRINT\INPUT'Ready (Type  Y)';O$ \ GOTO 10000 IF O$<>'Y'
10100	RETURN
14990	!
	! ***** FUNCTIONS *****
	!
15000	  DEF FNC
	\ PRINTCHR$(155%)+'H';
	\ PRINTCHR$(155%)+'J';
	\ FNEND

15010	  DEF FNQ1%(I%,J%)
	\ PRINTCHR$(155%)+'Y'+CHR$(32%+I%)+CHR$(32%+J%);
	\ FNEND

18990	!
	! ***** ERROR HANDLING *****
	!
19000	  IF ERR=50% THEN PRINT\PRINT'Enter a whole number only' \ RESUME
19010	  IF ERR=52% THEN PRINT\PRINT'Enter a smaller number' \ RESUME
19100	  ON ERROR GOTO 0
32599	!
	! ***** SIGN-OFF MESSAGE *****
	!
32600	  PRINT\PRINT' Type  BYEF  if leaving !'

32767	  END
