10	!


	!	V I D E O


12	!
	Presents a wide variety of graphic displays.  Does not use graphic mode.
	User does not interact with program, just watches.  Good introduction
	to artistic possibilities

	Modular structure is used, with each subroutine containing a module.

20	!
		***** MODIFICATION HISTORY *****

	VIDEO was written by Dr. John S. Abma, Wittenberg University,
		Springfield, Ohio, in the Spring of 1978.

	It was written in VO6C version of RSTS-E, for a DEC PDP 11/70
	This is version VO6C-1  

30	!
	Neither the author nor Wittenberg University accepts any responsibility 
	for the use or misuse, psychological or otherwise that may ensue the
	implementation of these programs.

100	!
		***** PROGRAM DESCRIPTION *****

	This program must be run on VIDEO TERMINALS ONLY, because cursor control
	functions are called.

	It presents the following types of displays;

	1. A field of randomly selected and placed symbols.
	2. A small border, or "Frame" of *'s.
	3. A clearing out of the framed area, and various titles appear.
	4. RECTANGLES, four of them of random dimensions and positions appear
	   slightly like some of the works of MONDRIAN, the French painter.
	5. SYMMETRIES of the following kind;
110 !
		a).  Right-Left symmetry, with "Folding" of right on left half.
		b).  Top-Bottom symmetry, with "Folding" of top on bottom.
		c).  No symmetry, with lines of random length and direction.
		d).Four-fold symmetry, with four quadrants reflected.

	6. The program then gives some "Circles" of various radii.
	7.  It closes with a "Wheel-Spoke" display of T H E  E N D.

120	!
	The symbols printed are randomly selected from among 10 given.
	Line length is random, but will not exceed 16.
	Line thickness (Number of characters "Fat") is variable.

	PURPOSE of the program is to suggest artistic possibilities, and to
	entertain.

400	!
		***** VARIABLES USED *****

	A$	String from which printed symbols are randomly selected.
	A%()	Matrix to store positions where symbols are printed.
	B%	Bottom of rectangle.
	D%	The directions for lines to grow.
	D%()	The coordinates governing line propagation.
	D1%()	Coordinates for line propatation, T H E  E N D display only.
	D0%	Dummy for loop.
	D1%	Dummy for loop.
	D2%	Dummy for loop.
	D3%	Dummy for loop.
	F1$	Printed symbol.
	FNC	Clear entire screen.
	FNQ1%()	Position cursor.

800	!
		***** FUNCTIONS AND SUBROUTINES *****

	Two user-defined functions;
	1.  Clear entire screen.
	2.  Position cursor at any I,J coordinate.

	Subroutines are;
	1.  Introductory display and titles.
	2.  "Mondrian-type" interwoven rectangles.
	3.  Various types of SYMMETRY.
	4.  Circles.
	5.  A Display that spells T H E  E N D.
	6.  Clear space in center of screen for titles and announcements.


900	  DIM D%(8%,2%) \ DIM D1%(6%,2%) \ DIM A%(24%,80%)
	! 1.  There are 8 directions for line growth, with 2 coordinates.
	  2.  There are 6 directions for line growth in END display.
	  3.  The screen is 24x80.

990	!
	! ***** MAIN LINE CODE *****
	!
1000	! There is no ERROR HANDLING, as the user has no inputs.

1010	! No HEADER is printed for this program.

1030	! No CONSTANTS TO INITIALIZE.

1060	  MAT READ D%
	\ DATA -1,-1, -1,0, -1,1, 0,-1, 0,1, 1,-1, 1,0, 1,1
1065	! There are 8 directions for a line to grow.

1070	  MAT READ D1%
	\ DATA -1,1, 0,1, 1,1, 1,-1, 0,-1, -1,-1
1075	! There are 6 directions for a line to grow in END display.

1080	  RANDOM
1085	  PRINT\PRINT'Welcome to VIDEO  This is a program to watch - it will proceed'
	\ PRINT'without any input.  Each display will be held on the screen for'
	\ PRINT'about 10 seconds.  Use the "RETURN" key to hurry up.'

1087	  SLEEP 15%

1090	  GOSUB 10000
	\ GOSUB 10500
	\ GOSUB 10600
	\ GOSUB 11000
	\ GOSUB 11100
	! Modules are;
		1. Introduction and titles.
		2. MONDRIAN rectangles.
		3. Four types of SYMMETRY displays.
		4. Circles.
		5. THE END display.

1100	!
	! ***** TERMINATION *****
	!
1110	  GOSUB 12000
	\ PRINT"That's all, folks!!"
	\ PRINT\PRINT'Type  B Y E F  if leaving.'
	\ GOTO 32767
	! Clear area in center of screen, say goodbye.

9990 !
     ! ***** SUBROUTINE; INTRODUCTION *****
     !
10000	  A$='Xx*.+-#@$o'
	\ Z%=FNC
	! First, a little razzle-dazzle, clear screen.

10020	  FOR D0%=0% TO 199%
		\ I%=RND*24%+1%
		\ J%=RND*80%+1%
		\ Z%=FNQ1%(I%,J%)
		\ PRINT MID(A$,RND*10%+1%,1%);
	\ NEXT D0%
	! Scatter 200 symbols all over screen.

10030	  I%=10%
	\ J%=20%
	! Starting point for frame.

10040	  FOR J%=J% TO 51%
		\ Z%=FNQ1%(I%,J%)
		\ PRINT '*';
	\ NEXT J%

	\ FOR I%=I% TO 15%
		\ Z%=FNQ1%(I%,J%)
		\ PRINT '*';
	\ NEXT I%

	\ FOR J%=J% TO 20% STEP -1%
		\ Z%=FNQ1%(I%,J%)
		\ PRINT '*';
	\ NEXT J%

	\ FOR I%=I% TO 10% STEP -1%
		\ Z%=FNQ1%(I%,J%)
		\ PRINT '*';
	\ NEXT I%

	! Make a little FRAME of *'s in CENTER.

10300	  GOSUB 12000
	! Make space for titles.

10310	  PRINT'P R E S E N T I N G';
	\ SLEEP 15%
	\ GOSUB 12000
		\ PRINT'A VIDEO SPECTACULAR!!!';
		\ SLEEP 5%
	\ GOSUB 12000
		\ PRINT'First, RECTANGLES'
		\ Z%=FNQ1%(13%,25%)
		\ PRINT'In the style of MONDRIAN'
		\ SLEEP 5%

10320	  RETURN

10490	!
	! ***** MONDRIAN-TYPE RECTANGLES *****
	!
	!  These are rectangles that generally overlap, and may share one
	   or more sides.

10500	  A$='*****.....'
	\ FOR D1%=0% TO 1%
		\ Z%=FNC
		\ FOR D2%=0% TO 3%
			\ F1$=MID(A$,RND*10%+1%,1%)
			\ T%=RND*11%+1%
			\ B%=11%+RND*11%+1%
			\ L%=RND*39%+1%
	! 1. Screen is cleared.
	  2. A printing character is selected ( * or . )
	  3. Top, Bottom, Left and Right dimensions of rectangles selected.

10510			  R%=39%+RND*39%+1%
			\ GOTO 10510 IF (R%+L%)/2<>(R%+L%)/2.
			\ I%=T%
	! 1. The right side will be an even number of spaces from the left.
	     This allows rectangle to come out "Even" since alternate zones
	     are printed horizontally, for better appearance.
	  2. Value of T% is saved for use in next statements.

10520			  FOR J%=L% TO R% STEP 2%
				\ Z%=FNQ1%(I%,J%) \ PRINTF1$;
			\ NEXT J%
			\ FOR I%=T% TO B%
				\ Z%=FNQ1%(I%,J%) \ PRINTF1$;
			\ NEXT I%
			\ FOR J%=R% TO L% STEP-2%
				\ Z%=FNQ1%(I%,J%) \ PRINTF1$;
			\ NEXT J%
			\ FOR I%=B% TO T% STEP-1%
				\ Z%=FNQ1%(I%,J%) \ PRINTF1$;
			\ NEXT I%
10530		  NEXT D2%
		\ SLEEP 15%
		! Go make another rectangle, lay over this one. Make 4 in all.
		  Sleeps allow viewing.

10550	  NEXT D1%
	! Go back, clar screen, make another design.  3 in all.

10560	  RETURN
10600	!
	! ***** LABELS FOR VARIOUS TYPES OF SYMMETRY **********
	!
10610	  FOR D0%=1% TO 4%
		\ GOSUB 12000
		\ PRINT'Now, RIGHT-LEFT symmetry' IF D0%=1%
		\ PRINT'Here is TOP-BOTTOM symmetry' IF D0%=2%
		\ PRINT'For a change, NO SYMMETRY' IF D0%=3%
		\ PRINT'FOUR FOLD symmetry' IF D0%=4%
	\ SLEEP 5%

10620	!
	! ***** CONSTRUCT DESIGN *****
	!
10630	  A$='*@.+#XYOxo'
	! Character set for line symbols.

10640	  FOR D1%=0% TO 1%
		\ Z%=FNC
		\ A%(I%,J%)=0% FOR I%=0% TO 24% FOR J%=0% TO 80%
		! There will be 2 examples of each type of symmetry.
		  Screen is cleared each time.
		  The A% matrix, showing where symbols are printed, is cleared.

10650	  	FOR D2%=0% TO 19%
			\ F1$=MID(A$,RND*10%+1%,RND*3%+1%)
			! Select a printing character. May be 1,2,or3 symbols.

10660			  I%=RND*23%+1% \ J%=RND*78%+2%
			 ! Select start of line

10670			  D%=RND*8%+1%
			! Select direction of line growth.

10680	  FOR D3%=0% TO (RND*4%+1%)^2%
	! Sets line length

10690		  A%(I%,J%+J1%)=1% FOR J1%=0% TO LEN(F1$)
		! Shows where symbols have been printed.

10700		  GOTO 10720 IF D%(D%,1%)
		! Skip next statement if a vertical line is being built.

10710		  J%=J%+(LEN(F1$)+1%)*D%(D%,2%) \ GOTO 10740
		! Provides for a space between horizontal characters.

10720		  I%=I%+D%(D%,1%)
		! Increments vertical line.

10730		  J%=J%+D%(D%,2%)
		! Increments diagonally.

10740		  GOTO 10810 IF I%<=0% OR I%>=23% OR J%<=0% OR J%>=79%
		\ GOTO 10810 IF A%(I%,J%)
		! This and above abort line when it goes out of range, or meets another line.

10760		  Z%=FNQ1%(I%,J%) \ PRINTF1$;
		! Prints character at I%,J%
		  Next three lines "Fold screen" for various symmetries.

10770		  IF D0%=1% OR D0%=4% THEN Z%=FNQ1%(I%,80%-J%) \ PRINTF1$;
10780		  IF D0%=2% OR D0%=4% THEN Z%=FNQ1%(24%-I%,J%) \ PRINTF1$;
10790		  IF D0%=4% THEN Z%=FNQ1%(24%-I%,80%-J%) \ PRINTF1$;
10800	  NEXT D3%
	! Go back to print the next character in the same line.

10810	  NEXT D2%
	! Go back to start a new line.

10820	  SLEEP 15%
	! Allow viewing of completed figure.

10830	  NEXT D1%
	! Go make another example of same type of symmetry.

10840	  NEXT D0%
	! Advance to next type of symmetry.

10850	  RETURN
11000	!
	! ***** CIRCLES *****
	!
11010	  GOSUB 12000
	\ PRINT'Circles'
	\ SLEEP 5%
	! Clear space in middle, give title, allow viewing.

11020	  FOR D3%=0% TO 2%
		\ Z%=FNC
		\ FOR D0%=0% TO 10%
			\ D1%=RND*10%+1%
			\ D2%=RND*25%+1%
	! There will be three examples in all.
	  Clear screen, then select 10 starting points for circles.

11030			  FOR D%=0% TO RND*20%+1%
				\ X=X+.2
				\ I%=10%+COS(X)*D1%
				\ J%=35%+SIN(X)*D2%
				\ Z%=FNQ1%(I%,J%) \ PRINT '*';
				\ Z%=FNQ1%(24%-I%,80%-J%) \ PRINT '.';
			\ NEXT D%
	! Circles are 20 symbols long.
	  An angle is incremented from 0 to 4 degrees.
	  The figure is positioned by some "Empirical constants" (Guesses).
	  Circles are printing,  "*" , with a "Shadow", "."

11040		  NEXT D0%
		\ SLEEP 10%
		! Go make another circle and view when 10 are completed.

11050	  NEXT D3%
	! Go make another display full of circles, from a clear screen.

11060	  RETURN

11100	  A$='THE END   '
	\ Z%=FNC
	! Select printed characters, clear screen.

11110	  FOR L%=10% TO 0% STEP-1%
		\ F1$=MID(A$,L1%+1%,1%)
		\ L1%=L1%+1%
		\ I%=12% \ J%=40%
		\ I1%=I% \ J1%=J%
	! Line length will go from 10 to 0.
	  The printed character will go from left to right in A$.
	  The starting position will always be the same.

11120		  FOR D%=1% TO 6%
		\ FOR B%=0% TO L%
			\ Z%=FNQ1%(I1%,J1%) \ PRINT F1$
	! Six directions in all.
	  A character is printed on line of length L.

11220		A%(I1%,J1%+Y1%)=1% FOR Y1%=-1% TO 1%
		! Fills in horizontal lines between printed characters.

11230		GOTO 11250 IF D1%(D%,1%)
		! If a vertical line is being built.

11240		J1%=J1%+2*D1%(D%,2%) \ GOTO 11270
		! Prints alternate print zones for horizontal lines.

11250		I1%=I1%+D1%(D%,1%)
		! Increments vertical line.

11260		J1%=J1%+D1%(D%,2%)
		! Increments diagonally.

11270		GOTO 11290 IF I1%<=0% OR I1%>=23% OR J1%<=0% OR J1%>=79%

11280	  NEXT B%
	! Go get the next character to be printed

11290	  I1%=I% \ J1%=J%
	\ NEXT D%
	! From the same starting point, make a new line in a new direction.

11310	  NEXT L%
	! Repeat the whole process with new line length.

11315	  SLEEP 10%
	! Allow viewing

11320	  RETURN
11990	!
	! ***** SUBROUTINE; CLEAR SPACE *****
	!
12000	  FOR I%=11% TO 14%
		\ Z%=FNQ1%(I%,21%)
		\ PRINT STRING$(30%,32%);
	\ NEXT I%
	\ Z%=FNQ1%(12%,25%)
	! Space is cleared, and cursor positioned for title, if any.

12010	  RETURN

14990	!
	! ***** DEFINE FUNCTIONS *****
	!
15000	  DEF FNC
	\ PRINTCHR$(155%)+'H';
	\ PRINTCHR$(155%)+'J';
	\ FNEND

15010	  DEF FNQ1%(I%,J%)
	\ PRINTCHR$(155%)+'Y'+CHR$(32%+I%)+CHR$(32%+J%);
	\ FNEND

32767 END
