1 !
	500.25 - STAT11 - PLOTER

		PLOT MODULE

	RELEASED FOR SUBMISSION TO THE DECUS LIBRARY BY THE DEC
	ENGINEERING SYSTEMS GROUP AND THE EDUCATION PRODUCTS GROUP
		SEPTEMBER, 1977


2 !	COPYRIGHT (C) 1973, DIGITAL EQUIPMENT CORPORATION,

			MAYNARD, MASSACHUSETTS

3 !	THIS SOFTWARE IS FURNISHED TO PURCHASER UNDER A LICENSE FOR USE
	ON A SINGLE COMPUTER SYSTEM AND CAN BE COPIED (WITH INCLUSION OF
	DEC'S COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS
	MAY OTHERWISE BE PROVIDED IN WRITING BY DEC.

4 !	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE WITHOUT
	NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
	EQUIPMENT CORPORATION.

5 !	DEC ASSUMES NO RESPONSIBILITY FOR USE OR RELIABILITY OF ITS
	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DEC.



6 !	THIS MODULE PRINTS A GRAPH OF UP TO 3 DEPENDENT VARIABLES VERSUS ONE
	INDEPENDENT VARIABLE.


7 ! 	AUTHOR:		MICHAEL D. KNAUER

	VERSION NUMBER:	001

	DATE:		OCTOBER, 1973



8  !	MODIFICATIONS:  MAY, 1975

	MODIFIED TO ACCEPT MISSING DATA

		BY ARDOTH HASSLER WILSON
		   CENTRAL STATE UNIVERSITY
		   EDMOND, OKLAHOMA


00009!	MODIFICATIONS:  JUNE, 1976

	CTRL/C TRAP ADDED

10 !
	CALLING ARGUMENTS


12 !		1) VARIABLE NAME:	 F1$
		   RANGE OF VALUES:	S00000.PLT - S99999.PLT
13 !		   USE:			NAME OF FILE CONTAINING DATA POINTS
					TO BE PLOTTED. COLUMN 0 CONTAINS
					THE INDEPENDENT VARIABLE, COLUMNS
					1 - 3 CONTAIN THE DEPENDENT VARIABLE(S).

14 !		2) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			CONTAINS NUMBER OF ROWS IN FILE F1$

15 !		3) VARIABLE NAME:	P%
		   RANGE OF VALUES:	1 - 3
		   USE:			CONTAINS THE NUMBER OF DEPENDENT
					VARIABLES IN FILE F1$

16 !		4) VARIABLE NAME:	R1$
		   RANGE OF VALUES:	LINE0P,REGRES
		   USE:			NAME OF MODULE TO WHICH CONTROL
					IS RETURNED

17 !		5) VARIABLE NAME:	R1%
		   RANGE OF VALUES:	1000,1990
		   USE:			LINE NUMBER TO WHICH CONTROL IS
					RETURNED IN THE CALLING MODULE

20 !

	RETURNING ARGUMENTS

		NONE -- THIS MODULE DOES NOT CHANGE OR ADD TO ANY OF THE
			FILES OR VARIABLES PASSED TO IT.



30 !	DESCRIPTION OF FUNCTION

		THIS MODULE TAKES DATA POINTS PASSED TO IT AND PRINTS A
		GRAPH FROM THEM.

31 !		BEFORE PRINTING, IT SORTS THE INDEPENDENT VARIABLE DATA
		POINTS, KEEPING CORRESPONDING DEPENDENT VARIABLE DATA POINTS
		MATCHING.

32!		IT EITHER COMPUTES PLOT DIMENSIONS ITSELF USING THE DATA
		POINTS OR LETS THE USER SPECIFY THE GRAPH SIZE AND DIMENSIONS.

33 !		THEN IT PRINTS THE GRAPH, WITH THE INDEPENDENT VARIABLE
		DOWN THE VERTICAL AXIS AND THE DEPENDENT VARIABLE(S)
		ACROSS THE HORIZONTAL AXIS.

34 !		FINALLY, PLOTER SURRENDERS CONTROL TO EITHER LINE0P OR
		REGRES, WHICHEVER MODULE CALLED IT.

40 !








99 !

	HERE THE CALLING ARGUMENTS ARE RETRIEVED FROM COMMON AND THE VIRTUAL
	MATRIX FILE CONTAINING THE DATA POINTS TO BE PLOTTED IS OPENED.



100	DIM C$(3%),Q(3%),D$(60%): ON ERROR GOTO 1500: GOSUB 10000
110  F$=SYS(CHR$(7))
120  F1$=LEFT(F$,15%)
130  R1$=MID(F$,16%,15%)
140 R1% = CVT$%(MID(F$,31%,2%)) : R% = CVT$%(MID(F$,33%,2%)) :
    P% = CVT$%(MID(F$,35%,2%))
170  C$(1%)=MID(F$,37%,1%)
180  C$(2%)=MID(F$,38%,1%)
190  C$(3%)=MID(F$,39%,1%)
195	H9=.9E-38
200  OPEN F1$ FOR INPUT AS FILE 1
210  DIM #1,A(250%,3%)
298 !


	THE INDEPENDENT VARIABLE DATA POINTS ARE SORTED IN ASCENDING ORDER,
	AND THE CORRESPONDING DEPENDENT VARIABLE POINTS ARE KEPT MATCHING.

299 !	I.E., IF A(2,0) AND A(3,0) ARE INTERCHANGED, THEN A(2,1), A(2,2), AND
	A(2,3) ARE INTERCHANGED WITH A(3,1), A(3,2), AND A(3,3).



300	Y1=A(1%,1%)
310	Y9=A(1%,1%)
315	N9%=R%
320	T9%=N9%-1%
330	FOR K%=1% TO N9%
340  S9%=0%
350	FOR J%=1% TO T9%
360  IF A(J%,0%)<=A(J%+1%,0%) GOTO 500
380	Q(I%)=A(J%,I%) FOR I%=0% TO P%
400	A(J%,I%)=A(J%+1%,I%) FOR I%=0% TO P%
420	A(J%+1%,I%)=Q(I%) FOR I%=0% TO P%
430  S9%=1%
500  NEXT J%
510  IF S9%=0% GOTO 540
520  T9%=T9%-1%
530  NEXT K%
539 !


	IN THIS SECTION, THE MAXIMUM AND MINIMUM VALUES FOR THE INDEPENDENT
	VARIABLE ARE SET, AND THE DEPENDENT VARIABLE(S) ARE SCANNED FOR
	A MAXIMUM AND MINIMUM VALUE.



540	X1=A(1%,0%): X9=A(N9%,0%)
550	FOR J%=1% TO N9%
560  FOR J1% = 1% TO P%
565  IF A(J%,J1%)=H9 GOTO 620
570  IF A(J%,J1%)<=Y9 GOTO 600
580  Y9=A(J%,J1%)
590  GOTO 620
600  IF A(J%,J1%)>=Y1 GOTO 620
610  Y1=A(J%,J1%)
620  NEXT J1%
630  NEXT J%
699 !


	HERE THE USER IS ASKED IF HE WANTS TO SPECIFY PLOT DIMENSIONS. IF
	HE DOES, THEN THE ACTUAL DATA RANGES ARE PRINTED OUT FOR HIS PERUSAL.



700  INPUT "DO YOU WISH TO SPECIFY PLOT DIMENSIONS ";W$
705  PRINT
710  IF LEFT(W$,1%)="Y" GOTO 750
715  IF LEFT(W$,1%)="N" OR W$="" GOTO 900
720  PRINT "YOU MUST ANSWER EITHER YES OR NO"
725  GOTO 700
730  ! PRINT MAX MIN  ASK FOR DIMENSIONS
750  PRINT "DATA RANGES :"
760  PRINT USING "  VERT(X) (###.####^^^^ ,###.####^^^^)",X1,X9
770  PRINT USING "  HORZ(Y) (###.####^^^^ ,###.####^^^^)",Y1,Y9
775  PRINT
777 !


	HERE THE USER IS ASKED TO ENTER THE DIMENSION INFORMATION FOR THE
	PLOT. NOTE THAT IF HE SPECIFIES MORE THAN 100 LINES TO BE PRINTED,
	HE IS ASKED IF HE REALLY MEANS IT.
778 !	NOTE ALSO THAT THE INFORMATION HE ENTERS HERE REPLACES THE MAXIMA
	AND MINIMA COMPUTED IN LINES 540 - 630.



780  ON ERROR GOTO 1500
785  PRINT "ENTER VERTICAL DIMENSIONS"
790  PRINT "(FORM: MINIMUM,MAXIMUM,NUMBER OF VERTICAL LINES)"
791  INPUT X1,X9,L%
792  IF L%<=100% GOTO 798
793  PRINT "DO YOU REALLY WANT TO PLOT";L%;" VERTICAL LINES";
794  INPUT W$:IF LEFT(W$,1%)="Y" GOTO 798
795  IF LEFT(W$,1%)="N" OR W$="" GOTO 785
796  PRINT "PLEASE ANSWER YES OR NO"
797  GOTO 793
798  PRINT "THE NUMBER OF HORIZONTAL SPACES THAT YOU SPECIFY"
800  PRINT "MUST BE <= 60"
805  PRINT "ENTER HORIZONTAL DIMENSIONS"
806  PRINT "(FORM: MINIMUM,MAXIMUM,NUMBER OF HORIZONTAL SPACES)"
807  INPUT Y1,Y9,S%
808  IF S%<=60% AND S%>=1% GOTO 815
809  PRINT "YOU MUST SPECIFY FROM 1 TO 60 HORIZONTAL SPACES"
810  PRINT "PLEASE TRY AGAIN"
812  GOTO 805
815  L=L%  : S=S%
820  PRINT
830  GOTO 1000
899 !


	THE DEFAULTS FOR THE NUMBER OF HORIZONTAL SPACES AND THE NUMBER OF
	VERTICAL LINES ARE SET HERE WHEN THE USER LETS PLOTER COMPUTE THE
	PLOT DIMENSIONS.


900  L%=39%: L=L%
910  S%=60%: S=S%
999 !


	HERE THE HORIZONTAL AND VERTICAL INTERVALS ARE COMPUTED. IF EITHER
	OF THE RANGES IS A CONSTANT, THEN THE WHOLE PLOT ROUTINE IS ABORTED.



1000 I9=(X9-X1)/L
1010 B9=(Y9-Y1)/S
1014 IF I9<>0 AND B9<>0 GOTO 1030
1018 IF I9=0 THEN PRINT "*** VERTICAL (X) VARIABLE IS A CONSTANT ***"
1022 IF B9=0 THEN PRINT "*** HORIZONTAL (Y) VARIABLE IS A CONSTANT ***"
1026 PRINT
1028 GOTO 1400
1029 !


	HERE THE USER IS INFORMED THAT THE PLOT IS ABOUT TO BEGIN. HE HAS
	ABOUT 17 SECONDS TO ADJUST HIS PAPER FOR THE PLOT.



1030 PRINT "IF DESIRED, ADJUST PAPER NOW"
1050 PRINT "CAUTION:  DO NOT USE CARRIAGE RETURN"
1055 PRINT "TO ADJUST PAPER FOR PLOT"
1060 SLEEP(17)
1069 !


	THIS SECTION PRINTS THE GRAPH; FOR EVERY PRINTLINE CORRESPONDING TO A
	DATA POINT FOR THE INDEPENDENT VARIABLE, THE POSITIONS FOR THE
	DEPENDENT VARIABLE(S) ARE FILLED IN WITH THE PLOT CHARACTERS AND THE
	LINE IS PRINTED.



1070 PRINT "Y-AXIS----->"
1080 PRINT "+...."; FOR I% = 1% TO 12%
1090 PRINT
1095	N%=1%: Z=X1
1100 IF A(N%,0%)>=Z GOTO 1120
1110 N%=N%+1% : GOTO 1100
1120 FOR K% = 1% TO L%
1125 IF K%=L% THEN Z=X9
1130 Z=Z+I9
1140 IF K%-((K%/5%)*5%)=0% THEN PRINT "+"; ELSE PRINT ".";
1150 D$(I%)=" " FOR I% = 0% TO 60%
1160	IF N%>N9% GOTO 1260
1165 IF A(N%,0%)>Z GOTO 1260
1170 FOR J% = 1% TO P%
1175	IF A(N%,J%)=H9 GOTO 1230
1180 Z2=Y1
1190 IF A(N%,J%)<Z2 THEN GOTO 1230
1200 IF A(N%,J%)>Y9 THEN GOTO 1230
1210 X5%=(A(N%,J%)-Y1)/B9
1215 IF X5%<=60% THEN 1220
1216 PRINT X5%,'****'
1220 D$(X5%)=C$(J%)
1230 NEXT J%
1240 N%=N%+1%
1250 GOTO 1160
1260 PRINT D$(I%); FOR I% = 0% TO 60%
1270 PRINT
1275	IF N%>N9% GOTO 1300
1280 NEXT K%
1300 PRINT "+...."; FOR I% = 1% TO 12%
1310 PRINT : PRINT
1320 PRINT USING "VERT(#.####^^^^ ,#.####^^^^) -TOP TO BTM",X1,X9
1330 PRINT USING "HORZ(#.####^^^^ ,#.####^^^^) -LFT TO RT",Y1,Y9
1335 PRINT
1340 PRINT "INCREMENTS : "
1350 PRINT USING "   VERT(PER LINE) =  #.####^^^^",I9
1360 PRINT USING "   HORZ(PER SPACE) = #.####^^^^",B9
1399 !


	HERE CONTROL IS RETURNED TO THE CALLING PROGRAM, EITHER LINE0P OR REGRES


1400 F$=MID(F$,40%,70%)
1402 CLOSE 1
1405 PRINT
1407 KILL F1$
1410 R$=SYS(CHR$(8)+F$)
1420 CHAIN R1$ R1%
1430 GOTO 32750
1499 !


	THIS IS AN ERROR ROUTINE FOR THE USER-INPUT DIMENSIONS ROUTINE.



1500	IF ERR=28% THEN GOSUB 10000: RESUME 1400
1501	PRINT "YOU TYPED NON-NUMERIC AND/OR"
1502 PRINT"INAPPROPRIATE VALUES FOR THE DIMENSIONS"
1510 PRINT "PLEASE TYPE ONLY NUMBERS WHEN NUMBERS ARE REQUESTED"
1515 RESUME 785
10000	V0$=SYS(CHR$(6%)+CHR$(-7%)): RETURN	! CTRL/C TRAP
32750	END
