1 !
	500.24 - STAT11 - LINE0P

		LINE PLOT CONTROL MODULE

	RELEASED FOR SUBMISSION TO THE DECUS LIBRARY BY THE DEC
	ENGINEERING SYSTEMS GROUP AND THE EDUCATION PRODUCTS GROUP
		SEPTEMBER, 1977


2 !	COPYRIGHT (C) 1973, DIGITAL EQUIPMENT CORPORATION,

			MAYNARD, MASSACHUSETTS

3 !	THIS SOFTWARE IS FURNISHED TO PURCHASER UNDER A LICENSE FOR USE
	ON A SINGLE COMPUTER SYSTEM AND CAN BE COPIED (WITH INCLUSION OF
	DEC'S COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS
	MAY OTHERWISE BE PROVIDED IN WRITING BY DEC.

4 !	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE WITHOUT
	NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
	EQUIPMENT CORPORATION.

5 !	DEC ASSUMES NO RESPONSIBILITY FOR USE OR RELIABILITY OF ITS
	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DEC.


6 !	THIS MODULE SETS UP THE TEMPORARY FILE THAT THE PLOTER MODULE USES
	TO PRODUCE A LINE PLOT.



7 !	AUTHOR:		MICHAEL D. KNAUER

	VERSION NUMBER:	001

	DATE:		OCTOBER, 1973


8  !	MODIFICATIONS:  MAY, 1975

	MODIFIED TO ACCEPT MISSING DATA

		BY ARDOTH HASSLER WILSON
		   CENTRAL STATE UNIVERSITY
		   EDMOND, OKLAHOMA


00009!	MODIFICATIONS:  JUNE, 1976

	CTRL/C TRAP ADDED

10 !	

	CALLING ARGUMENTS

11 !		1) VARIABLE NAME:	F3$
		   RANGE OF VALUES:	S00000.RWM - S99999.RWM
		   USE:			THIS IS THE 250 ROW BY 15 COLUMN
					DATA MATRIX USED BY ALL STAT11 MODULES

13 !		2) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			CONTAINS THE NUMBER OF ROWS OF ACTUAL 
					DATA IN THE VIRTUAL MATRIX F3$

15 !		3) VARIABLE NAME:	C%
		   RANGE OF VALUES:	1 - 15
		   USE:			CONTAINS THE NUMBER OF COLUMNS OF
					DATA IN THE MATRIX F3$

20 !

	RETURNING ARGUMENTS

21 !		1) VARIABLE NAME:	F5$
		   RANGE OF VALUES:	S00000.PLT - S99999.PLT
22 !		   USE:			THIS FILE CONTAINS THE DATA POINTS
					TO BE PLOTTED. COLUMN 0 CONTAINS THE
					INDEPENDENT VARIABLE, COLUMNS 1 - 3
					CONTAIN THE DEPENDENT VARIABLE(S).

24 !		2) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			CONTAINS THE NUMBER OF ROWS IN FILE F5$

26 !		3) VARIABLE NAME:	Y%
		   RANGE OF VALUES:	1 - 3
		   USE:			CONTAINS HOW MANY DEPENDENT VARIABLES 
					ARE STORED IN F5$

28 !		4) CONSTANT VALUE:	1000
		   USE:			THIS IS THE NUMBER OF THE LINE IN LINE0P
					THAT THE PLOTER MODULE CHAINS BACK TO.

29 !	NOTE THAT THESE ARE ONLY RETURNING ARGUMENTS WHEN CHAINING TO PLOTER,
		NOT WHEN CHAINING TO STATCM. THERE ARE NO RETURNING ARGU-
		MENTS WHEN CONTROL IS TRANSFERRED TO STATCM.


30 !	DESCRIPTION OF FUNCTION

31 !		LINE0P GETS TOGETHER AND PASSES TO PLOTER THE NECESSARY
		INFORMATION FOR MAKING A LINE PLOT.

32 !		IT ASKS THE USER WHAT COLUMNS ARE TO BE USED FOR THE
		INDEPENDENT AND DEPENDENT VARIABLES AND TRANSFERS THESE
		VARIABLES TO A TEMPORARY FILE.

33 !		AFTER LOADING THE APPROPRIATE RETURNING ARGUMENTS INTO COMMON,
		LINE0P THEN TRANSFERS CONTROL TO PLOTER.

34 !		WHEN PLOTER RETURNS CONTROL, LINE0P ASKS THE USER IF HE WANTS
		MORE PLOTS. IF NOT, THEN CONTROL IS TRANSFERRED TO STATCM.

35 !


95 !


	IN THE FIRST SECTION OF CODE, CALLING ARGUMENTS ARE RETRIEVED FROM
	COMMON, AND THE INPUT AND TEMPORARY FILES ARE OPENED.



100	DIM V%(3%),V$(3%): ON ERROR GOTO 1250: GOSUB 10000
110  F$=SYS(CHR$(7))
115	GOSUB 600
120  R%=VAL(MID(F$,46%,5%))
130  C%=VAL(MID(F$,51%,5%))
140  F3$=MID(F$,31%,15%)
150  OPEN F3$ FOR INPUT AS FILE 3
160  DIM #3,A(250%,15%)
170  F5$=LEFT(F3$,6%)+".PLT"
180  OPEN F5$ FOR OUTPUT AS FILE 5
185  DIM #5,P(250%,3%)
188 !


	HERE THE MODULE ASKS THE USER TO ENTER THE NUMBER OF THE INDEPENDENT
	VARIABLE, HOW MANY DEPENDENT VARIABLES HE WANTS TO PLOT, AND THE
	NUMBERS OF THE DEPENDENT VARIABLES.


189  S1%=1%
190  INPUT "ENTER INDEPENDENT(X) VARIABLE NUMBER ";X%
200  PRINT
205  IF X%>=1% AND X%<=C% GOTO 219
210  PRINT "THE INDEPENDENT VARIABLE NUMBER MUST BE BETWEEN 1 AND"; C%
215  PRINT "PLEASE TRY AGAIN"
217  GOTO 190
219  S1%=2%
220 INPUT"HOW MANY DEPENDENT VARIABLES DO YOU WANT TO PLOT (MAX=3)";Y%
230  PRINT
235  IF Y%>=1% AND Y%<=3% GOTO 244
237  PRINT "YOU MUST SPECIFY 1, 2, OR 3 AS THE NUMBER OF DEPENDENT VARIABLES"
239  PRINT "PLEASE TRY AGAIN"
241  GOTO 220
244  S1%=3%
247  PRINT "ENTER THE (COLUMN) NUMBER(S) FOR THE";Y%;" DEPENDENT VARIABLE(S)"
249  PRINT "TYPE THEM IN ONE AT A TIME"
251  FOR I%=1% TO Y%
253  INPUT V%(I%)
255  IF V%(I%)>=1% AND V%(I%)<=C% GOTO 270
260  PRINT "THE DEPENDENT VARIABLE NUMBER(S) MUST BE BETWEEN 1 AND";C%
265  PRINT "ENTER DEPENDENT VARIABLE NUMBER"; I%; " AGAIN AND CONTINUE";
267  INPUT V%(I%)
269  GOTO 255
270  NEXT I%
275 !


	HERE THE INDEPENDENT AND DEPENDENT VARIABLES ARE TRANSFERRED FROM
	THE INPUT FILE TO THE TEMPORARY FILE F5$.


280  PRINT
300	J1%=0%: FOR J%=1% TO R%: IF A(J%,X%)=H9 GOTO 330
310	J1%=J1%+1%: P(J1%,0%)=A(J%,X%)
320	P(J1%,I%)=A(J%,V%(I%)) FOR I%=1% TO Y%
330  NEXT J%
335	P(0%,I%)=J1% FOR I%=0% TO Y%
338	IF J1%=0% THEN PRINT "NO DATA EXISTS FOR VARIABLE";X%: GOTO 1200
340  !
400  CLOSE 3,5
405 !

	HERE THE RETURNING LINE NUMBER, THE NUMBER OF ROWS, AND THE NUMBER
	OF DEPENDENT VARIABLES ARE ADDED TO THE CHARACTER STRING TO BE
	PASSED VIA COMMON.

410  G$=LEFT(F5$+SPACE$(15%),15%)+"LINE0P"+A9$+"   "
415	G$=LEFT(G$+SPACE$(10%),30%)
420	G$=G$+CVT%$(1000%)+CVT%$(J1%)+CVT%$(Y%)
425 !

	HERE THE USER IS ASKED TO ENTER PLOT CHARACTERS. THESE OR DEFAULT
	CHARACTERS "A", "B", AND "C" ARE ADDED TO THE CHARACTER STRING TO BE
	PASSED.

430  PRINT "TYPE ";Y%;" PRINT CHARACTERS, ONE AT A TIME."
440  INPUT V$(I%) FOR I%=1% TO Y%
450  PRINT
460  G$=G$+LEFT(V$(1%)+"A",1%)+LEFT(V$(2%)+"B",1%)+LEFT(V$(3%)+"C",1%)
465 !

	HERE THE FINAL STRING OF RETURNING ARGUMENTS IS LOADED INTO COMMON
	AND CONTROL IS TRANSFERRED TO PLOTER.


470  G$=LEFT(G$+SPACE$(10),39%)
480  G$=G$+F$
490  R$=SYS(CHR$(8)+G$)
500  CHAIN "PLOTER"+A9$
510  !
600	A9$=MID(F$,62%,9%): A9$=LEFT(A9$,INSTR(5%,A9$,"]")):
	H9=.9E-38: RETURN
999 !


	THE LAST SECTION OF CODE ASKS THE USER IF HE WANTS TO PLOT MORE.
	IF HE DOESN'T, CONTROL IS TRANSFERRED TO STATCM.


1000 F$=SYS(CHR$(7))
1010	GOSUB 600
1020 GOTO 1200
1200 INPUT "DO YOU WISH TO PLOT MORE VARIABLES ";W$
1205 PRINT
1210 IF W$="YES" OR LEFT(W$,1%)="Y" GOTO 120
1215	IF LEFT(W$,1%)="N" OR W$="" GOTO 1230
1220 PRINT "YOU MUST ANSWER EITHER YES OR NO"
1225 GOTO 1200
1230 R$=SYS(CHR$(8)+F$)
1240 CHAIN "STATCM"+A9$
1245 !

	THIS IS THE ERROR ROUTINE FOR THE SECTION WHERE THE USER TYPES IN
	VARIABLE NUMBERS, ETC.

1250	IF ERR=28% THEN GOSUB 10000: RESUME 1200
1255	PRINT "YOU TYPED NON-NUMERIC CHARACTERS INSTEAD OF NUMBERS"
1260 PRINT "PLEASE TYPE ONLY NUMBERS WHEN NUMBERS ARE REQUESTED"
1270 ON S1% GOTO 1280,1285,1290
1280 RESUME 210
1285 RESUME 237
1290 RESUME 260
10000	V0$=SYS(CHR$(6%)+CHR$(-7%)): RETURN	! CTRL/C TRAP
32750	END
