1 !
	500.27 - STAT11 - HISTOG

		HISTOGRAM MODULE

	RELEASED FOR SUBMISSION TO THE DECUS LIBRARY BY THE DEC
	ENGINEERING SYSTEMS GROUP AND THE EDUCATION PRODUCTS GROUP
		SEPTEMBER, 1977


2 !	COPYRIGHT (C) 1973, DIGITAL EQUIPMENT CORPORATION,

			MAYNARD, MASSACHUSETTS

3 !	THIS SOFTWARE IS FURNISHED TO PURCHASER UNDER A LICENSE FOR USE
	ON A SINGLE COMPUTER SYSTEM AND CAN BE COPIED (WITH INCLUSION OF
	DEC'S COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS
	MAY OTHERWISE BE PROVIDED IN WRITING BY DEC.

4 !	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE WITHOUT
	NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
	EQUIPMENT CORPORATION.

5 !	DEC ASSUMES NO RESPONSIBILITY FOR USE OR RELIABILITY OF ITS
	SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DEC.



6 !	THIS PROGRAM PRINTS A HISTOGRAM (BAR GRAPH) FOR A VARIABLE.



7 ! 	AUTHOR:		MICHAEL D. KNAUER

	VERSION NUMBER:	001

	DATE:		OCTOBER, 1973



8   !	MODIFICATIONS:  MAY, 1975

	MODIFIED TO ACCEPT MISSING DATA POINTS

		BY ARDOTH HASSLER WILSON
		   CENTRAL STATE UNIVERSITY
		   EDMOND, OKLAHOMA


00009!	MODIFICATIONS:  JUNE, 1976

	CTRL/C TRAP ADDED

10 !

	CALLING ARGUMENTS

12 !		1) VARIABLE NAME:	F3$
		   RANGE OF VALUES:	S00000.RWM - S99999.RWM
		   USE:			THIS IS THE NAME OF THE 250 ROW
					BY 15 COLUMN VIRTUAL DATA MATRIX
					USED BY ALL STAT11 MODULES.

14 !		2) VARIABLE NAME:	F4$
		   RANGE OF VALUES:	S00000.ESF - S99999.ESF
		   USE:			THIS IS THE NAME OF A FILE THAT
					CONTAINS THE ELEMENTARY STATISTICS
					USED BY MANY STAT11 MODULES.

16 !		3) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			CONTAINS THE NUMBER OF ROWS OF
					ACTUAL DATA IN MATRIX F3$

18 !		4) VARIABLE NAME:	C%
		   RANGE OF VALUES:	1 - 15
		   USE:			CONTAINS THE NUMBER OF COLUMNS OF
					ACTUAL DATA IN MATRIX F3$

20 !


	RETURNING ARGUMENTS

22 !		NONE -- THIS MODULE DOES NOT ALTER OR ADD TO ANY OF THE
			FILES OR VARIABLES PASSED TO IT.



30 !	DESCRIPTION OF FUNCTION

		THIS MODULE PRINTS A HISTOGRAM (BAR GRAPH) FOR A VARIABLE.

		THE STRATEGY IT EMPLOYS IS AS FOLLOWS:

31 !		FIRST DIVIDE THE RANGE (MAXIMUM - MINIMUM) OF THE VARIABLE
		INTO THE DESIRED NUMBER OF INTERVALS.

32 !		THEN GO DOWN THE COLUMN OF OBSERVATIONS FOR THE VARIABLE
		AND COUNT HOW MANY OBSERVATIONS THERE ARE IN EACH INTERVAL.

33 !		FINALLY, PRINT THE HISTOGRAM. THEN, IF THE USER DOESN'T
		WANT ANY MORE HISTOGRAMS, CHAIN TO STATCM.

34 !














90 !
	THIS SECTION OPENS THE INPUT DATA MATRIX FILE AND THE ELEMENTARY
	STATISTICS FILE.



100	ON ERROR GOTO 9000: GOSUB 10000: F$=SYS(CHR$(7%))
105	A9$=MID(F$,62%,9%): A9$=LEFT(A9$,INSTR(5%,A9$,"]")):
	H9=.9E-38
110  R%=VAL(MID(F$,46%,5%))
120  C%=VAL(MID(F$,51%,5%))
130  F3$=MID(F$,31%,15%)
140  F4$=LEFT(F3$,6%)+".ESF"
150  OPEN F3$ FOR INPUT AS FILE 3
160  DIM #3,A(250%,15%)
170  OPEN F4$ FOR INPUT AS FILE 4
180  DIM #4,S(10%,15%)
183  DIM F%(10%),L(10%)
199 !


	HERE THE USER IS ASKED TO ENTER THE NUMBER OF THE VARIABLE FOR
	WHICH HE WANTS THE HISTOGRAM.



200  PRINT "TYPE THE COLUMN NUMBER OF THE VARIABLE"
202  INPUT "TO BE USED IN THE HISTOGRAM";V%:PRINT
205  IF V%>=1% AND V%<=C% GOTO 215
210  PRINT "YOU MUST SPECIFY A VARIABLE NUMBER BETWEEN 1 AND";C%
212  GOTO 200
215

	! F(I%) WILL HOLD THE FREQUENCY COUNT FOR EACH INTERVAL;
	L(I%) WILL HOLD THE LOWER BOUND OF EACH INTERVAL.  THESE
	ARRAYS ARE INITIALIZED HERE
216  FOR I%=0% TO 10%
217  F%(I%)=0%
218  L(I%)=0
219  NEXT I%     !


	HERE THE USER IS ASKED TO INPUT A PRINT CHARACTER AND THEN THE 
	NUMBER OF INTERVALS HE WANTS IN THE HISTOGRAM.



220  INPUT "TYPE A PRINT CHARACTER FOR THE HISTOGRAM ";C$
230  PRINT
240  C$=LEFT(C$+"*",1%)
250  PRINT "ENTER THE NUMBER OF INTERVALS YOU WANT IN THE HISTOGRAM"
255  INPUT "(MAXIMUM=10)";N%:PRINT
260  IF N%>=1% AND N%<=10% GOTO 290
270  PRINT "THE NUMBER OF INTERVALS YOU SPECIFY MUST BE BETWEEN 1 AND 10"
275  PRINT "PLEASE TRY AGAIN"
280  GOTO 250
289 !


	THIS SECTION SETS EACH L(J%) TO THE LOWER BOUND OF THE J%TH INTERVAL.



290	PRINT: PRINT TAB(15%);"HISTOGRAM FOR VARIABLE";V%
300  PRINT
310  N=N%
320	I=(S(1%,V%)-S(2%,V%))/N
330	M=S(2%,V%)
340	FOR J%=0% TO N%
350  L(J%)=M
360  M=I+L(J%)
370  NEXT J%
380	L(N%)=S(1%,V%)  !  NOTE:  THIS LINE SETS THE UPPER BOUND
		        OF THE LAST INTERVAL
389 !


	THIS CODE COUNTS THE NUMBER OF OBSERVATIONS IN EACH INTERVAL AND
	STORES THESE COUNTS IN THE F% ARRAY.



390	FOR J%=1% TO R%
400	FOR K%=1% TO N%
405	IF A(J%,V%)=H9 GOTO 420
410  IF A(J%,V%)<=L(K%) GOTO 430
420	NEXT K%: GOTO 440
430  F%(K%)=F%(K%)+1%
440  NEXT J%
450  H%=F%(1%)
460  FOR J%=2% TO N%
470  IF F%(J%)>H% THEN H%=F%(J%)
480  NEXT J%
489 !


	THIS CODE PRINTS THE FREQUENCY COUNTS ACROSS THE TOP OF THE GRAPH.



490  PRINT "FREQUENCY";
500  FOR J%=1% TO N%
510  PRINT USING "  ###",F%(J%);
520  NEXT J%
524 !


	THIS SECTION PRINTS THE HISTOGRAM.



525  PRINT
530  PRINT "  --------";
540  PRINT "+----"; FOR J%=1% TO 11%
545  PRINT
550  X%=H%
560  FOR J%=1% TO H%
570  PRINT USING "  ###",X%;
580  PRINT "     ";
590  FOR K%=1% TO N%
600  IF F%(K%)>=X% THEN PRINT "   ";C$;" "; ELSE PRINT "     ";
610  NEXT K%
620  PRINT
630  X%=X%-1%
640  NEXT J%
649 !


	HERE THE BOUNDS FOR THE INTERVALS ARE PRINTED ALONG THE BOTTOM
	OF THE GRAPH.



650  PRINT "  --------";
660  PRINT "+----"; FOR J% = 1% TO 11%
670  PRINT
680  PRINT "    ";
690  FOR J% = 0% TO N% STEP 2%
700  PRINT USING "  ####.###",L(J%);
710  NEXT J%
720  PRINT
730  PRINT "         ";
740  FOR J% = 1% TO N% STEP 2%
750  PRINT USING "  ####.###",L(J%);
760  NEXT J%
769 ! 


	IN THIS LAST SECTION, THE USER IS ASKED IF HE WANTS MORE HISTOGRAMS.
	IF NOT, CONTROL IS TRANSFERRED TO STATCM. ERROR ROUTINES ARE ALSO
	INCLUDED IN THIS SECTION OF CODE.



770  PRINT : PRINT
780  INPUT "DO YOU WISH TO PRINT ANY MORE HISTOGRAMS"; W$
785	IF LEFT(W$,1%)="Y" GOTO 199
790  IF LEFT(W$,1%)="N" OR W$="" GOTO 900
795  PRINT "PLEASE ANSWER YES OR NO": GOTO 780
900  R$=SYS(CHR$(8)+F$)
905	CLOSE 3,4
910  CHAIN "STATCM"+A9$
09000	IF ERR=28% THEN GOSUB 10000: RESUME 900
09010	PRINT "YOU TYPED NON-NUMERIC CHARACTERS.  PLEASE TYPE ONLY"
	: PRINT "NUMBERS WHEN NUMBERS ARE REQUESTED."
	: IF ERL=202 THEN RESUME 210 ELSE IF ERL=255 THEN RESUME 270
09020	ON ERROR GOTO 0
10000	V0$=SYS(CHR$(6%)+CHR$(-7%)): RETURN	! CTRL/C TRAP
32750	END
