00001	!

	500.28   STAT11 - ANALYS

		ANALYSIS OF VARIANCE MODULE


00006	!  THIS MODULE PERFORMS COMPLETELY RANDOMIZED DESIGN ANALYSIS OF
	   VARIANCE AND CRD AOV WITH REPEATED MEASURE FOR SELECTED (OR ALL)
	   VARIABLES (COLUMNS).


00007	!  AUTHOR:  ARDOTH HASSLER WILSON
		    CENTRAL STATE UNIVERSITY
		    EDMOND, OKLAHOMA


00008  !	DATE:  MAY, 1975





00009!	MODIFICATIONS:  JUNE, 1976

	CTRL/C TRAP ADDED

10 !
	CALLING ARGUMENTS

		1) VARIABLE NAME:	F1$
		   RANGE OF VALUES:	ANY VALID BASIC-PLUS FILE NAME
		   USE:			NAME OF USER'S INPUT DATA FILE

11 !		2) VARIABLE NAME:	F2$
		   RANGE OF VALUES:	ANY VALID BASIC-PLUS FILE NAME
		   USE:			NAME FOR OUTPUT FILE TO SAVE DATA

12 !		3) VARIABLE NAME:	F3$
		   RANGE OF VALUES:	S00000.RWM - S99999.RWM
		   USE:			NAME OF FILE WHERE 250 ROW BY
					15 COLUMN DATA MATRIX WILL BE STORED

13 !		4) VARIABLE NAME:	R%
		   RANGE OF VALUES:	1 - 250
		   USE:			NUMBER OF ROWS IN DATA MATRIX

14 !		5) VARIABLE NAME:	C%
		   RANGE OF VALUES:	1 - 15
		   USE:			NUMBER OF COLUMNS IN DATA MATRIX


15 !
	RETURNING ARGUMENTS

		THE RETURNING ARGUMENTS ARE THE SAME AS THE CALLING
		ARGUMENTS -- ALL ARE PASSED VIA COMMON STORAGE TO THE
		NEXT MODULE.


00030!	

	DESCRIPTION OF FUNCTION
00032!		THIS MODULE PERFORMS ANALYSIS OF VARIANCE FOR A 
		COMPLETELY RANDOMIZED DESIGN WITH OR WITHOUT REPEATED
		MEASURE

00034!		THE MODULE ASKS THE USER WHETHER HE HAS REPEATED MEASURE
		AND IF HE WISHES TO EXCLUDE ANY VARIABLES FROM THE ANALYSIS


00036!		AFTER COMPUTING THE AOV THE USER IS ASKED IF HE WANTS TO
		COMPUTE ANY MORE AOV'S.


00038	!	IF NOT, CONTROL IS RETURNED TO STATCM.










00100	!

	THIS CODE RETRIEVES CALLING ARGUEMENTS AND OPENS THE INPUT
	DATA FILE


00110	ON ERROR GOTO 20000: GOSUB 22000: F$=SYS(CHR$(7%))
00120	A9$=MID(F$,62%,9%): A9$=LEFT(A9$,INSTR(5%,A9$,"]")): H9=.9E-38
00130	R%=VAL(MID(F$,46%,5%))
00140	C%=VAL(MID(F$,51%,5%))
00150	F3$=MID(F$,31%,15%)
00170	OPEN F3$ FOR INPUT AS FILE 1%: DIM #1%,X(250%,15%)
00180	DIM D%(15%),T(15%),N%(15%)
00200	!

	THE USER IS ASKED IF HE AS REPEATED MEASURE.
	ALSO, IF HE DESIRES TO OMIT ANY VARIABLES AND IF SO, WHICH ONES


00220	PRINT "ANALYSIS OF VARIANCE": PRINT
00230	INPUT "DOES YOUR DATA HAVE REPEATED MEASURE";R$:
	IF LEFT(R$,1%)="Y" THEN F%=1% ELSE F%=0%
00235	D%(I%)=1% FOR I%=1% TO C%: T%=0%
00240	PRINT "DO YOU WISH TO OMIT ANY VARIABLES (COLUMNS) FROM":
	INPUT "THE ANALYSIS";R$: IF LEFT(R$,1%)="N" OR R$="" GOTO 400
		ELSE IF LEFT(R$,1%)<>"Y" THEN 
		PRINT "YOU MUST ANSWER YES OR NO": GOTO 240
00260	INPUT "ENTER VARIABLE TO BE OMITTED (0 TO END)";D%
00265	IF D%=0% GOTO 300
00270	IF D%<1% OR D%>C% THEN PRINT "VARIABLE MUST BE BETWEEN 1 AND";
		C%:  GOTO 260
00280	D%(D%)=-1%: T%=T%+1%: GOTO 260
00300	IF T%>=C%-1% THEN
	PRINT "YOU HAVE ASKED TO DELETE";T%;" VARIABLES":
	PRINT "THERE ARE ONLY";C%;" VARIABLES IN ALL": GOTO 210
00400	!

	THIS SECTION COMPUTES GRAND SUMS AND TREATMENT (VARIABLE)
	TOTALS.  ALSO, PERSON TOTALS ARE COMPUTED IF REPEATED 
	MEASURE IS DESIRED


00410	T%=C%-T%
00420	G=0: G2=0: P=0: P2=0: N=0
00430	MAT T=ZER
00440	MAT N%=ZER
00450	FOR I%=1% TO R%
00460	IF F%=0% GOTO 600
00465	P=0
00470	K%=0%: FOR J%=1% TO C%:
	IF D%(J%)=-1% GOTO 500
00480	IF X(I%,J%)=H9 THEN K%=K%+1%: GOTO 500
00490	P=P+X(I%,J%)
00500	NEXT J%
00510	F=K%*P/(T%-K%)
00520	P2=P2+(P+F)^2
00530	P=P/(T%-K%)
00600	FOR J%=1% TO C%:
	IF D%(J%)=-1% GOTO 650
00610	IF X(I%,J%)=H9 THEN IF F%=0% GOTO 650 ELSE X=P: GOTO 630
00620	X=X(I%,J%)
00630	T(J%)=T(J%)+X: G2=G2+X*X
00640	N%(J%)=N%(J%)+1%
00650	NEXT J%
00660	NEXT I%
00700	!

	THIS SECTION COMPUTES AND PRINTS THE AOV


00710	T=0: FOR J%=1% TO C%:
	IF D%(J%)=-1% GOTO 730
00720	T=T+T(J%)/N%(J%)*T(J%): G=G+T(J%): N=N+N%(J%)
00730	NEXT J%
00735	S$="\              \  ###   #########.####    #####.####"+
	"  ###.###"
00737	S1$="\           \ ###   #########.####    #####.####    "+
	"###.###"
00740	C=G/N*G
00750	S=G2-C
00760	IF F%=1% GOTO 900
00770	S1=T-C: E=S-S1: M1=S1/(T%-1%): M2=E/(N-T%): F=M1/M2
00780	GOSUB 9000
00790	PRINT USING S$,"TREATMENTS",T%-1%,S1,M1,F
00800	PRINT USING S$,"ERROR",N-T%,E,M2
00810	GOTO 1000
00900	P2=P2/T%: B=P2-C: W=G2-P2: S1=T-C: E=G2-T-P2+C: GOSUB 9000
00905	M1=S1/(T%-1%): M2=E/((R%-1%)*(T%-1%)): F=M1/M2
00910	PRINT USING S$,"BETWEEN SUBJECTS",R%-1%,B,B/(R%-1%)
00920	PRINT USING S$,"WITHIN SUBJECTS",R%*(T%-1%),W,W/(R%*(T%-1%))
00930	PRINT USING S1$,"  TREATMENTS",T%-1%,S1,M1,F
00940	PRINT USING S1$,"  RESIDUAL",(R%-1%)*(T%-1%),E,M2
01000	PRINT USING S$,"TOTAL",N-1,S
01010	PRINT: PRINT
02000	!

	HERE THE USER IS ASKED IF HE HAS MORE AOV. IF NO, CONTROL IS
	RETURNED TO STATCM


02010	INPUT "DO YOU WISH TO COMPUTE MORE ANALYSIS OF VARIANCE";R$:
	IF LEFT(R$,1%)="Y" GOTO 200 
02020	IF LEFT(R$,1%)="N" OR R$="" GOTO 32000
02030	PRINT "YOU MUST ANSWER YES OR NO": GOTO 2010
09000	PRINT: PRINT: PRINT: PRINT "ANALYSIS OF VARIANCE": PRINT
09020	PRINT "SOURCE             DF   SUM OF SQUARES   MEAN SQUARE";
	"    F"
09030	RETURN
20000	IF ERR=28% THEN GOSUB 22000: RESUME 32000
20010	IF ERR>49% AND ERR<53% THEN 
	PRINT "YOU TYPED NON-NUMERIC CHARACTERS INSTEAD OF A VARIABLE"
	: PRINT "NUMBER.  PLEASE TRY AGAIN."
	: RESUME 260
21000	ON ERROR GOTO 0
22000	V0$=SYS(CHR$(6%)+CHR$(-7%)): RETURN	! CTRL/C TRAP
32000	!

	CLOSE FILES, REPLACE ARGUEMENTS IN COMMON


32005	PRINT: PRINT
32010	CLOSE 1%
32020	R$=SYS(CHR$(8%)+F$)
32030	CHAIN "STATCM"+A9$
32750	END
